/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.RemoteConnection;
import com.android.internal.telecom.IConnectionService;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteConference
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mId;
    private IConnectionService mConnectionService;
    private Set<Callback> mCallbacks;
    private List<RemoteConnection> mChildConnections;
    private List<RemoteConnection> mUnmodifiableChildConnections;
    private List<RemoteConnection> mConferenceableConnections;
    private List<RemoteConnection> mUnmodifiableConferenceableConnections;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private int mCallCapabilities;

    private void $$robo$$android_telecom_RemoteConference$__constructor__(String id2, IConnectionService connectionService) {
        this.mCallbacks = new CopyOnWriteArraySet<Callback>();
        this.mChildConnections = new CopyOnWriteArrayList<RemoteConnection>();
        this.mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mId = id2;
        this.mConnectionService = connectionService;
    }

    private final String $$robo$$android_telecom_RemoteConference$getId() {
        return this.mId;
    }

    private final void $$robo$$android_telecom_RemoteConference$setDestroyed() {
        for (RemoteConnection connection : this.mChildConnections) {
            connection.setConference(null);
        }
        for (Callback c : this.mCallbacks) {
            c.onDestroyed(this);
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setState(int newState) {
        if (newState != 4 && newState != 5 && newState != 6) {
            Log.w(this, "Unsupported state transition for Conference call.", Connection.stateToString(newState));
            return;
        }
        if (this.mState != newState) {
            int oldState = this.mState;
            this.mState = newState;
            for (Callback c : this.mCallbacks) {
                c.onStateChanged(this, oldState, newState);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$addConnection(RemoteConnection connection) {
        if (!this.mChildConnections.contains(connection)) {
            this.mChildConnections.add(connection);
            connection.setConference(this);
            for (Callback c : this.mCallbacks) {
                c.onConnectionAdded(this, connection);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$removeConnection(RemoteConnection connection) {
        if (this.mChildConnections.contains(connection)) {
            this.mChildConnections.remove(connection);
            connection.setConference(null);
            for (Callback c : this.mCallbacks) {
                c.onConnectionRemoved(this, connection);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setCallCapabilities(int capabilities) {
        if (this.mCallCapabilities != capabilities) {
            this.mCallCapabilities = capabilities;
            for (Callback c : this.mCallbacks) {
                c.onCapabilitiesChanged(this, this.mCallCapabilities);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setConferenceableConnections(List<RemoteConnection> conferenceableConnections) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(conferenceableConnections);
        for (Callback c : this.mCallbacks) {
            c.onConferenceableConnectionsChanged(this, this.mUnmodifiableConferenceableConnections);
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mDisconnectCause = disconnectCause;
            this.setState(6);
            for (Callback c : this.mCallbacks) {
                c.onDisconnected(this, disconnectCause);
            }
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConference$getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    private final int $$robo$$android_telecom_RemoteConference$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_RemoteConference$getCallCapabilities() {
        return this.mCallCapabilities;
    }

    private final void $$robo$$android_telecom_RemoteConference$disconnect() {
        try {
            this.mConnectionService.disconnect(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$separate(RemoteConnection connection) {
        if (this.mChildConnections.contains(connection)) {
            try {
                this.mConnectionService.splitFromConference(connection.getId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$merge() {
        try {
            this.mConnectionService.mergeConference(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$swap() {
        try {
            this.mConnectionService.swapConference(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$hold() {
        try {
            this.mConnectionService.hold(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$unhold() {
        try {
            this.mConnectionService.unhold(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final DisconnectCause $$robo$$android_telecom_RemoteConference$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final void $$robo$$android_telecom_RemoteConference$playDtmfTone(char digit) {
        try {
            this.mConnectionService.playDtmfTone(this.mId, digit);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$stopDtmfTone() {
        try {
            this.mConnectionService.stopDtmfTone(this.mId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setAudioState(AudioState state) {
        try {
            this.mConnectionService.onAudioStateChanged(this.mId, state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConference$getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    private final void $$robo$$android_telecom_RemoteConference$registerCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    private final void $$robo$$android_telecom_RemoteConference$unregisterCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    private void __constructor__(String string2, IConnectionService iConnectionService) {
        this.$$robo$$android_telecom_RemoteConference$__constructor__(string2, iConnectionService);
    }

    RemoteConference(String string2, IConnectionService iConnectionService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference$__constructor__(java.lang.String com.android.internal.telecom.IConnectionService ), 0, this, string2, iConnectionService);
    }

    String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telecom_RemoteConference$getId(), 0, this);
    }

    void setDestroyed() {
        InvokeDynamicSupport.bootstrap("setDestroyed", $$robo$$android_telecom_RemoteConference$setDestroyed(), 0, this);
    }

    void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_RemoteConference$setState(int ), 0, this, n);
    }

    void addConnection(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_telecom_RemoteConference$addConnection(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    void removeConnection(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_telecom_RemoteConference$removeConnection(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    void setCallCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setCallCapabilities", $$robo$$android_telecom_RemoteConference$setCallCapabilities(int ), 0, this, n);
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_RemoteConference$setConferenceableConnections(java.util.List<android.telecom.RemoteConnection> ), 0, this, list);
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_RemoteConference$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public List<RemoteConnection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$android_telecom_RemoteConference$getConnections(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_RemoteConference$getState(), 0, this);
    }

    public int getCallCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCallCapabilities", $$robo$$android_telecom_RemoteConference$getCallCapabilities(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_RemoteConference$disconnect(), 0, this);
    }

    public void separate(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$android_telecom_RemoteConference$separate(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    public void merge() {
        InvokeDynamicSupport.bootstrap("merge", $$robo$$android_telecom_RemoteConference$merge(), 0, this);
    }

    public void swap() {
        InvokeDynamicSupport.bootstrap("swap", $$robo$$android_telecom_RemoteConference$swap(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_RemoteConference$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_RemoteConference$unhold(), 0, this);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_RemoteConference$getDisconnectCause(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_RemoteConference$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_RemoteConference$stopDtmfTone(), 0, this);
    }

    public void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_RemoteConference$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_RemoteConference$getConferenceableConnections(), 0, this);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConference$registerCallback(android.telecom.RemoteConference$Callback ), 0, this, callback);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_RemoteConference$unregisterCallback(android.telecom.RemoteConference$Callback ), 0, this, callback);
    }

    public /* synthetic */ RemoteConference() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteConference)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_RemoteConference_Callback$__constructor__() {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onStateChanged(RemoteConference conference, int oldState, int newState) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onDisconnected(RemoteConference conference, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionAdded(RemoteConference conference, RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionRemoved(RemoteConference conference, RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onCapabilitiesChanged(RemoteConference conference, int capabilities) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConferenceableConnectionsChanged(RemoteConference conference, List<RemoteConnection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onDestroyed(RemoteConference conference) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_RemoteConference_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_Callback$__constructor__(), 0, this);
        }

        public void onStateChanged(RemoteConference remoteConference, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_RemoteConference_Callback$onStateChanged(android.telecom.RemoteConference int int ), 0, this, remoteConference, n, n2);
        }

        public void onDisconnected(RemoteConference remoteConference, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_RemoteConference_Callback$onDisconnected(android.telecom.RemoteConference android.telecom.DisconnectCause ), 0, this, remoteConference, disconnectCause);
        }

        public void onConnectionAdded(RemoteConference remoteConference, RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_RemoteConference_Callback$onConnectionAdded(android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, remoteConnection);
        }

        public void onConnectionRemoved(RemoteConference remoteConference, RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionRemoved", $$robo$$android_telecom_RemoteConference_Callback$onConnectionRemoved(android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, remoteConnection);
        }

        public void onCapabilitiesChanged(RemoteConference remoteConference, int n) {
            InvokeDynamicSupport.bootstrap("onCapabilitiesChanged", $$robo$$android_telecom_RemoteConference_Callback$onCapabilitiesChanged(android.telecom.RemoteConference int ), 0, this, remoteConference, n);
        }

        public void onConferenceableConnectionsChanged(RemoteConference remoteConference, List<RemoteConnection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_RemoteConference_Callback$onConferenceableConnectionsChanged(android.telecom.RemoteConference java.util.List<android.telecom.RemoteConnection> ), 0, this, remoteConference, list);
        }

        public void onDestroyed(RemoteConference remoteConference) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConference_Callback$onDestroyed(android.telecom.RemoteConference ), 0, this, remoteConference);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

