/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.RemoteConference;
import android.telecom.StatusHints;
import android.telecom.VideoCallbackServant;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private IConnectionService mConnectionService;
    private String mConnectionId;
    private Set<Callback> mCallbacks;
    private List<RemoteConnection> mConferenceableConnections;
    private List<RemoteConnection> mUnmodifiableconferenceableConnections;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private boolean mRingbackRequested;
    private boolean mConnected;
    private int mCallCapabilities;
    private int mVideoState;
    private VideoProvider mVideoProvider;
    private boolean mIsVoipAudioMode;
    private StatusHints mStatusHints;
    private Uri mAddress;
    private int mAddressPresentation;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private RemoteConference mConference;

    private void $$robo$$android_telecom_RemoteConnection$__constructor__(String id2, IConnectionService connectionService, ConnectionRequest request) {
        this.mCallbacks = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableconferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectionId = id2;
        this.mConnectionService = connectionService;
        this.mConnected = true;
        this.mState = 0;
    }

    private void $$robo$$android_telecom_RemoteConnection$__constructor__(DisconnectCause disconnectCause) {
        this.mConnected = false;
        this.mState = 6;
        this.mDisconnectCause = disconnectCause;
    }

    private final void $$robo$$android_telecom_RemoteConnection$registerCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    private final void $$robo$$android_telecom_RemoteConnection$unregisterCallback(Callback callback) {
        if (callback != null) {
            this.mCallbacks.remove(callback);
        }
    }

    private final int $$robo$$android_telecom_RemoteConnection$getState() {
        return this.mState;
    }

    private final DisconnectCause $$robo$$android_telecom_RemoteConnection$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getCallCapabilities() {
        return this.mCallCapabilities;
    }

    private final boolean $$robo$$android_telecom_RemoteConnection$isVoipAudioMode() {
        return this.mIsVoipAudioMode;
    }

    private final StatusHints $$robo$$android_telecom_RemoteConnection$getStatusHints() {
        return this.mStatusHints;
    }

    private final Uri $$robo$$android_telecom_RemoteConnection$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getAddressPresentation() {
        return this.mAddressPresentation;
    }

    private final CharSequence $$robo$$android_telecom_RemoteConnection$getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    private final int $$robo$$android_telecom_RemoteConnection$getVideoState() {
        return this.mVideoState;
    }

    private final VideoProvider $$robo$$android_telecom_RemoteConnection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final boolean $$robo$$android_telecom_RemoteConnection$isRingbackRequested() {
        return false;
    }

    private final void $$robo$$android_telecom_RemoteConnection$abort() {
        try {
            if (this.mConnected) {
                this.mConnectionService.abort(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$answer() {
        try {
            if (this.mConnected) {
                this.mConnectionService.answer(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$answer(int videoState) {
        try {
            if (this.mConnected) {
                this.mConnectionService.answerVideo(this.mConnectionId, videoState);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$reject() {
        try {
            if (this.mConnected) {
                this.mConnectionService.reject(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$hold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.hold(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$unhold() {
        try {
            if (this.mConnected) {
                this.mConnectionService.unhold(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$disconnect() {
        try {
            if (this.mConnected) {
                this.mConnectionService.disconnect(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$playDtmfTone(char digit) {
        try {
            if (this.mConnected) {
                this.mConnectionService.playDtmfTone(this.mConnectionId, digit);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$stopDtmfTone() {
        try {
            if (this.mConnected) {
                this.mConnectionService.stopDtmfTone(this.mConnectionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$postDialContinue(boolean proceed) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onPostDialContinue(this.mConnectionId, proceed);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setAudioState(AudioState state) {
        try {
            if (this.mConnected) {
                this.mConnectionService.onAudioStateChanged(this.mConnectionId, state);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConnection$getConferenceableConnections() {
        return this.mUnmodifiableconferenceableConnections;
    }

    private final RemoteConference $$robo$$android_telecom_RemoteConnection$getConference() {
        return this.mConference;
    }

    private final String $$robo$$android_telecom_RemoteConnection$getId() {
        return this.mConnectionId;
    }

    private final IConnectionService $$robo$$android_telecom_RemoteConnection$getConnectionService() {
        return this.mConnectionService;
    }

    private final void $$robo$$android_telecom_RemoteConnection$setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            for (Callback c : this.mCallbacks) {
                c.onStateChanged(this, state);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mState = 6;
            this.mDisconnectCause = disconnectCause;
            for (Callback c : this.mCallbacks) {
                c.onDisconnected(this, this.mDisconnectCause);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setRingbackRequested(boolean ringback) {
        if (this.mRingbackRequested != ringback) {
            this.mRingbackRequested = ringback;
            for (Callback c : this.mCallbacks) {
                c.onRingbackRequested(this, ringback);
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setCallCapabilities(int callCapabilities) {
        this.mCallCapabilities = callCapabilities;
        for (Callback c : this.mCallbacks) {
            c.onCallCapabilitiesChanged(this, callCapabilities);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setDestroyed() {
        if (!this.mCallbacks.isEmpty()) {
            if (this.mState != 6) {
                this.setDisconnected(new DisconnectCause(1, "Connection destroyed."));
            }
            for (Callback c : this.mCallbacks) {
                c.onDestroyed(this);
            }
            this.mCallbacks.clear();
            this.mConnected = false;
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setPostDialWait(String remainingDigits) {
        for (Callback c : this.mCallbacks) {
            c.onPostDialWait(this, remainingDigits);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (Callback c : this.mCallbacks) {
            c.onVideoStateChanged(this, videoState);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Callback c : this.mCallbacks) {
            c.onVideoProviderChanged(this, videoProvider);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setIsVoipAudioMode(boolean isVoip) {
        this.mIsVoipAudioMode = isVoip;
        for (Callback c : this.mCallbacks) {
            c.onVoipAudioChanged(this, isVoip);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        for (Callback c : this.mCallbacks) {
            c.onStatusHintsChanged(this, statusHints);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setAddress(Uri address, int presentation) {
        this.mAddress = address;
        this.mAddressPresentation = presentation;
        for (Callback c : this.mCallbacks) {
            c.onAddressChanged(this, address, presentation);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setCallerDisplayName(String callerDisplayName, int presentation) {
        this.mCallerDisplayName = callerDisplayName;
        this.mCallerDisplayNamePresentation = presentation;
        for (Callback c : this.mCallbacks) {
            c.onCallerDisplayNameChanged(this, callerDisplayName, presentation);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConferenceableConnections(List<RemoteConnection> conferenceableConnections) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(conferenceableConnections);
        for (Callback c : this.mCallbacks) {
            c.onConferenceableConnectionsChanged(this, this.mUnmodifiableconferenceableConnections);
        }
    }

    private final void $$robo$$android_telecom_RemoteConnection$setConference(RemoteConference conference) {
        if (this.mConference != conference) {
            this.mConference = conference;
            for (Callback c : this.mCallbacks) {
                c.onConferenceChanged(this, conference);
            }
        }
    }

    private static final RemoteConnection $$robo$$android_telecom_RemoteConnection$failure(DisconnectCause disconnectCause) {
        return new RemoteConnection(disconnectCause);
    }

    private void __constructor__(String string2, IConnectionService iConnectionService, ConnectionRequest connectionRequest) {
        this.$$robo$$android_telecom_RemoteConnection$__constructor__(string2, iConnectionService, connectionRequest);
    }

    RemoteConnection(String string2, IConnectionService iConnectionService, ConnectionRequest connectionRequest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection$__constructor__(java.lang.String com.android.internal.telecom.IConnectionService android.telecom.ConnectionRequest ), 0, this, string2, iConnectionService, connectionRequest);
    }

    private void __constructor__(DisconnectCause disconnectCause) {
        this.$$robo$$android_telecom_RemoteConnection$__constructor__(disconnectCause);
    }

    RemoteConnection(DisconnectCause disconnectCause) {
        this("NULL", null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection$__constructor__(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConnection$registerCallback(android.telecom.RemoteConnection$Callback ), 0, this, callback);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_RemoteConnection$unregisterCallback(android.telecom.RemoteConnection$Callback ), 0, this, callback);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_RemoteConnection$getState(), 0, this);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_RemoteConnection$getDisconnectCause(), 0, this);
    }

    public int getCallCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCallCapabilities", $$robo$$android_telecom_RemoteConnection$getCallCapabilities(), 0, this);
    }

    public boolean isVoipAudioMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoipAudioMode", $$robo$$android_telecom_RemoteConnection$isVoipAudioMode(), 0, this);
    }

    public StatusHints getStatusHints() {
        return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_RemoteConnection$getStatusHints(), 0, this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_RemoteConnection$getAddress(), 0, this);
    }

    public int getAddressPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getAddressPresentation", $$robo$$android_telecom_RemoteConnection$getAddressPresentation(), 0, this);
    }

    public CharSequence getCallerDisplayName() {
        return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_RemoteConnection$getCallerDisplayName(), 0, this);
    }

    public int getCallerDisplayNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_RemoteConnection$getCallerDisplayNamePresentation(), 0, this);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_RemoteConnection$getVideoState(), 0, this);
    }

    public VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$android_telecom_RemoteConnection$getVideoProvider(), 0, this);
    }

    public boolean isRingbackRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRingbackRequested", $$robo$$android_telecom_RemoteConnection$isRingbackRequested(), 0, this);
    }

    public void abort() {
        InvokeDynamicSupport.bootstrap("abort", $$robo$$android_telecom_RemoteConnection$abort(), 0, this);
    }

    public void answer() {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_RemoteConnection$answer(), 0, this);
    }

    public void answer(int n) {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_RemoteConnection$answer(int ), 0, this, n);
    }

    public void reject() {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_RemoteConnection$reject(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_RemoteConnection$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_RemoteConnection$unhold(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_RemoteConnection$disconnect(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_RemoteConnection$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_RemoteConnection$stopDtmfTone(), 0, this);
    }

    public void postDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("postDialContinue", $$robo$$android_telecom_RemoteConnection$postDialContinue(boolean ), 0, this, bl);
    }

    public void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_RemoteConnection$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_RemoteConnection$getConferenceableConnections(), 0, this);
    }

    public RemoteConference getConference() {
        return InvokeDynamicSupport.bootstrap("getConference", $$robo$$android_telecom_RemoteConnection$getConference(), 0, this);
    }

    String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telecom_RemoteConnection$getId(), 0, this);
    }

    IConnectionService getConnectionService() {
        return InvokeDynamicSupport.bootstrap("getConnectionService", $$robo$$android_telecom_RemoteConnection$getConnectionService(), 0, this);
    }

    void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_RemoteConnection$setState(int ), 0, this, n);
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_RemoteConnection$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    void setRingbackRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_RemoteConnection$setRingbackRequested(boolean ), 0, this, bl);
    }

    void setCallCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setCallCapabilities", $$robo$$android_telecom_RemoteConnection$setCallCapabilities(int ), 0, this, n);
    }

    void setDestroyed() {
        InvokeDynamicSupport.bootstrap("setDestroyed", $$robo$$android_telecom_RemoteConnection$setDestroyed(), 0, this);
    }

    void setPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("setPostDialWait", $$robo$$android_telecom_RemoteConnection$setPostDialWait(java.lang.String ), 0, this, string2);
    }

    void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_RemoteConnection$setVideoState(int ), 0, this, n);
    }

    void setVideoProvider(VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_RemoteConnection$setVideoProvider(android.telecom.RemoteConnection$VideoProvider ), 0, this, videoProvider);
    }

    void setIsVoipAudioMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsVoipAudioMode", $$robo$$android_telecom_RemoteConnection$setIsVoipAudioMode(boolean ), 0, this, bl);
    }

    void setStatusHints(StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_RemoteConnection$setStatusHints(android.telecom.StatusHints ), 0, this, statusHints);
    }

    void setAddress(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_RemoteConnection$setAddress(android.net.Uri int ), 0, this, uri, n);
    }

    void setCallerDisplayName(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_RemoteConnection$setCallerDisplayName(java.lang.String int ), 0, this, string2, n);
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_RemoteConnection$setConferenceableConnections(java.util.List<android.telecom.RemoteConnection> ), 0, this, list);
    }

    void setConference(RemoteConference remoteConference) {
        InvokeDynamicSupport.bootstrap("setConference", $$robo$$android_telecom_RemoteConnection$setConference(android.telecom.RemoteConference ), 0, this, remoteConference);
    }

    public static RemoteConnection failure(DisconnectCause disconnectCause) {
        return InvokeDynamicSupport.bootstrapStatic("failure", $$robo$$android_telecom_RemoteConnection$failure(android.telecom.DisconnectCause ), 0, (DisconnectCause)disconnectCause);
    }

    public /* synthetic */ RemoteConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class VideoProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IVideoCallback mVideoCallbackDelegate;
        private VideoCallbackServant mVideoCallbackServant;
        private IVideoProvider mVideoProviderBinder;
        private Set<Listener> mListeners;

        private void $$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(IVideoProvider videoProviderBinder) {
            this.mVideoCallbackDelegate = new IVideoCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ VideoProvider this$0;

                private void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(VideoProvider videoProvider) {
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyRequest(VideoProfile videoProfile) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onReceiveSessionModifyRequest(this.this$0, videoProfile);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onReceiveSessionModifyResponse(this.this$0, status, requestedProfile, responseProfile);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$handleCallSessionEvent(int event) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onHandleCallSessionEvent(this.this$0, event);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changePeerDimensions(int width, int height) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onPeerDimensionsChanged(this.this$0, width, height);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCallDataUsage(int dataUsage) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onCallDataUsageChanged(this.this$0, dataUsage);
                    }
                }

                private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
                    for (Listener l : this.this$0.mListeners) {
                        l.onCameraCapabilitiesChanged(this.this$0, cameraCapabilities);
                    }
                }

                private final IBinder $$robo$$android_telecom_RemoteConnection_VideoProvider_1$asBinder() {
                    return null;
                }

                private void __constructor__(VideoProvider videoProvider) {
                    this.$$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(videoProvider);
                }
                {
                    this.this$0 = videoProvider;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$__constructor__(android.telecom.RemoteConnection$VideoProvider ), 0, this, videoProvider);
                }

                @Override
                public void receiveSessionModifyRequest(VideoProfile videoProfile) {
                    InvokeDynamicSupport.bootstrap("receiveSessionModifyRequest", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
                }

                @Override
                public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
                    InvokeDynamicSupport.bootstrap("receiveSessionModifyResponse", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$receiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, n, videoProfile, videoProfile2);
                }

                @Override
                public void handleCallSessionEvent(int n) {
                    InvokeDynamicSupport.bootstrap("handleCallSessionEvent", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$handleCallSessionEvent(int ), 0, this, n);
                }

                @Override
                public void changePeerDimensions(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("changePeerDimensions", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changePeerDimensions(int int ), 0, this, n, n2);
                }

                @Override
                public void changeCallDataUsage(int n) {
                    InvokeDynamicSupport.bootstrap("changeCallDataUsage", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCallDataUsage(int ), 0, this, n);
                }

                @Override
                public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
                    InvokeDynamicSupport.bootstrap("changeCameraCapabilities", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$changeCameraCapabilities(android.telecom.CameraCapabilities ), 0, this, cameraCapabilities);
                }

                @Override
                public IBinder asBinder() {
                    return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_telecom_RemoteConnection_VideoProvider_1$asBinder(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mVideoCallbackServant = new VideoCallbackServant(this.mVideoCallbackDelegate);
            this.mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
            this.mVideoProviderBinder = videoProviderBinder;
            try {
                this.mVideoProviderBinder.setVideoCallback(this.mVideoCallbackServant.getStub().asBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$addListener(Listener l) {
            this.mListeners.add(l);
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$removeListener(Listener l) {
            this.mListeners.remove(l);
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setCamera(String cameraId) {
            try {
                this.mVideoProviderBinder.setCamera(cameraId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setPreviewSurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setPreviewSurface(surface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setDisplaySurface(Surface surface) {
            try {
                this.mVideoProviderBinder.setDisplaySurface(surface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setDeviceOrientation(int rotation) {
            try {
                this.mVideoProviderBinder.setDeviceOrientation(rotation);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setZoom(float value) {
            try {
                this.mVideoProviderBinder.setZoom(value);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyRequest(VideoProfile reqProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyRequest(reqProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyResponse(VideoProfile responseProfile) {
            try {
                this.mVideoProviderBinder.sendSessionModifyResponse(responseProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCameraCapabilities() {
            try {
                this.mVideoProviderBinder.requestCameraCapabilities();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCallDataUsage() {
            try {
                this.mVideoProviderBinder.requestCallDataUsage();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_telecom_RemoteConnection_VideoProvider$setPauseImage(String uri) {
            try {
                this.mVideoProviderBinder.setPauseImage(uri);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private void __constructor__(IVideoProvider iVideoProvider) {
            this.$$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(iVideoProvider);
        }

        public VideoProvider(IVideoProvider iVideoProvider) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider$__constructor__(com.android.internal.telecom.IVideoProvider ), 0, this, iVideoProvider);
        }

        public void addListener(Listener listener) {
            InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_RemoteConnection_VideoProvider$addListener(android.telecom.RemoteConnection$VideoProvider$Listener ), 0, this, listener);
        }

        public void removeListener(Listener listener) {
            InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_RemoteConnection_VideoProvider$removeListener(android.telecom.RemoteConnection$VideoProvider$Listener ), 0, this, listener);
        }

        public void setCamera(String string2) {
            InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_telecom_RemoteConnection_VideoProvider$setCamera(java.lang.String ), 0, this, string2);
        }

        public void setPreviewSurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_telecom_RemoteConnection_VideoProvider$setPreviewSurface(android.view.Surface ), 0, this, surface);
        }

        public void setDisplaySurface(Surface surface) {
            InvokeDynamicSupport.bootstrap("setDisplaySurface", $$robo$$android_telecom_RemoteConnection_VideoProvider$setDisplaySurface(android.view.Surface ), 0, this, surface);
        }

        public void setDeviceOrientation(int n) {
            InvokeDynamicSupport.bootstrap("setDeviceOrientation", $$robo$$android_telecom_RemoteConnection_VideoProvider$setDeviceOrientation(int ), 0, this, n);
        }

        public void setZoom(float f) {
            InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_telecom_RemoteConnection_VideoProvider$setZoom(float ), 0, this, f);
        }

        public void sendSessionModifyRequest(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("sendSessionModifyRequest", $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
        }

        public void sendSessionModifyResponse(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("sendSessionModifyResponse", $$robo$$android_telecom_RemoteConnection_VideoProvider$sendSessionModifyResponse(android.telecom.VideoProfile ), 0, this, videoProfile);
        }

        public void requestCameraCapabilities() {
            InvokeDynamicSupport.bootstrap("requestCameraCapabilities", $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCameraCapabilities(), 0, this);
        }

        public void requestCallDataUsage() {
            InvokeDynamicSupport.bootstrap("requestCallDataUsage", $$robo$$android_telecom_RemoteConnection_VideoProvider$requestCallDataUsage(), 0, this);
        }

        public void setPauseImage(String string2) {
            InvokeDynamicSupport.bootstrap("setPauseImage", $$robo$$android_telecom_RemoteConnection_VideoProvider$setPauseImage(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ VideoProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static abstract class Listener
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$__constructor__() {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onReceiveSessionModifyRequest(VideoProvider videoProvider, VideoProfile videoProfile) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onReceiveSessionModifyResponse(VideoProvider videoProvider, int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onHandleCallSessionEvent(VideoProvider videoProvider, int event) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onPeerDimensionsChanged(VideoProvider videoProvider, int width, int height) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onCallDataUsageChanged(VideoProvider videoProvider, int dataUsage) {
            }

            private final void $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onCameraCapabilitiesChanged(VideoProvider videoProvider, CameraCapabilities cameraCapabilities) {
            }

            private void __constructor__() {
                this.$$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$__constructor__();
            }

            public Listener() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$__constructor__(), 0, this);
            }

            public void onReceiveSessionModifyRequest(VideoProvider videoProvider, VideoProfile videoProfile) {
                InvokeDynamicSupport.bootstrap("onReceiveSessionModifyRequest", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onReceiveSessionModifyRequest(android.telecom.RemoteConnection$VideoProvider android.telecom.VideoProfile ), 0, this, videoProvider, videoProfile);
            }

            public void onReceiveSessionModifyResponse(VideoProvider videoProvider, int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
                InvokeDynamicSupport.bootstrap("onReceiveSessionModifyResponse", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onReceiveSessionModifyResponse(android.telecom.RemoteConnection$VideoProvider int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, videoProvider, n, videoProfile, videoProfile2);
            }

            public void onHandleCallSessionEvent(VideoProvider videoProvider, int n) {
                InvokeDynamicSupport.bootstrap("onHandleCallSessionEvent", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onHandleCallSessionEvent(android.telecom.RemoteConnection$VideoProvider int ), 0, this, videoProvider, n);
            }

            public void onPeerDimensionsChanged(VideoProvider videoProvider, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onPeerDimensionsChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onPeerDimensionsChanged(android.telecom.RemoteConnection$VideoProvider int int ), 0, this, videoProvider, n, n2);
            }

            public void onCallDataUsageChanged(VideoProvider videoProvider, int n) {
                InvokeDynamicSupport.bootstrap("onCallDataUsageChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onCallDataUsageChanged(android.telecom.RemoteConnection$VideoProvider int ), 0, this, videoProvider, n);
            }

            public void onCameraCapabilitiesChanged(VideoProvider videoProvider, CameraCapabilities cameraCapabilities) {
                InvokeDynamicSupport.bootstrap("onCameraCapabilitiesChanged", $$robo$$android_telecom_RemoteConnection_VideoProvider_Listener$onCameraCapabilitiesChanged(android.telecom.RemoteConnection$VideoProvider android.telecom.CameraCapabilities ), 0, this, videoProvider, cameraCapabilities);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_RemoteConnection_Callback$__constructor__() {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onStateChanged(RemoteConnection connection, int state) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onDisconnected(RemoteConnection connection, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onRingbackRequested(RemoteConnection connection, boolean ringback) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onCallCapabilitiesChanged(RemoteConnection connection, int callCapabilities) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onPostDialWait(RemoteConnection connection, String remainingPostDialSequence) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVoipAudioChanged(RemoteConnection connection, boolean isVoip) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onStatusHintsChanged(RemoteConnection connection, StatusHints statusHints) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onAddressChanged(RemoteConnection connection, Uri address, int presentation) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onCallerDisplayNameChanged(RemoteConnection connection, String callerDisplayName, int presentation) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVideoStateChanged(RemoteConnection connection, int videoState) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onDestroyed(RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConferenceableConnectionsChanged(RemoteConnection connection, List<RemoteConnection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onVideoProviderChanged(RemoteConnection connection, VideoProvider videoProvider) {
        }

        private final void $$robo$$android_telecom_RemoteConnection_Callback$onConferenceChanged(RemoteConnection connection, RemoteConference conference) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_RemoteConnection_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnection_Callback$__constructor__(), 0, this);
        }

        public void onStateChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_RemoteConnection_Callback$onStateChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onDisconnected(RemoteConnection remoteConnection, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_RemoteConnection_Callback$onDisconnected(android.telecom.RemoteConnection android.telecom.DisconnectCause ), 0, this, remoteConnection, disconnectCause);
        }

        public void onRingbackRequested(RemoteConnection remoteConnection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onRingbackRequested", $$robo$$android_telecom_RemoteConnection_Callback$onRingbackRequested(android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, bl);
        }

        public void onCallCapabilitiesChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onCallCapabilitiesChanged", $$robo$$android_telecom_RemoteConnection_Callback$onCallCapabilitiesChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onPostDialWait(RemoteConnection remoteConnection, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_RemoteConnection_Callback$onPostDialWait(android.telecom.RemoteConnection java.lang.String ), 0, this, remoteConnection, string2);
        }

        public void onVoipAudioChanged(RemoteConnection remoteConnection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onVoipAudioChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVoipAudioChanged(android.telecom.RemoteConnection boolean ), 0, this, remoteConnection, bl);
        }

        public void onStatusHintsChanged(RemoteConnection remoteConnection, StatusHints statusHints) {
            InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_RemoteConnection_Callback$onStatusHintsChanged(android.telecom.RemoteConnection android.telecom.StatusHints ), 0, this, remoteConnection, statusHints);
        }

        public void onAddressChanged(RemoteConnection remoteConnection, Uri uri, int n) {
            InvokeDynamicSupport.bootstrap("onAddressChanged", $$robo$$android_telecom_RemoteConnection_Callback$onAddressChanged(android.telecom.RemoteConnection android.net.Uri int ), 0, this, remoteConnection, uri, n);
        }

        public void onCallerDisplayNameChanged(RemoteConnection remoteConnection, String string2, int n) {
            InvokeDynamicSupport.bootstrap("onCallerDisplayNameChanged", $$robo$$android_telecom_RemoteConnection_Callback$onCallerDisplayNameChanged(android.telecom.RemoteConnection java.lang.String int ), 0, this, remoteConnection, string2, n);
        }

        public void onVideoStateChanged(RemoteConnection remoteConnection, int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVideoStateChanged(android.telecom.RemoteConnection int ), 0, this, remoteConnection, n);
        }

        public void onDestroyed(RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConnection_Callback$onDestroyed(android.telecom.RemoteConnection ), 0, this, remoteConnection);
        }

        public void onConferenceableConnectionsChanged(RemoteConnection remoteConnection, List<RemoteConnection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConferenceableConnectionsChanged(android.telecom.RemoteConnection java.util.List<android.telecom.RemoteConnection> ), 0, this, remoteConnection, list);
        }

        public void onVideoProviderChanged(RemoteConnection remoteConnection, VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_RemoteConnection_Callback$onVideoProviderChanged(android.telecom.RemoteConnection android.telecom.RemoteConnection$VideoProvider ), 0, this, remoteConnection, videoProvider);
        }

        public void onConferenceChanged(RemoteConnection remoteConnection, RemoteConference remoteConference) {
            InvokeDynamicSupport.bootstrap("onConferenceChanged", $$robo$$android_telecom_RemoteConnection_Callback$onConferenceChanged(android.telecom.RemoteConnection android.telecom.RemoteConference ), 0, this, remoteConnection, remoteConference);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

