/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.ConnectionServiceAdapterServant;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.StatusHints;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.IVideoProvider;
import com.android.internal.telecom.RemoteServiceCallback;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteConnectionService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static RemoteConnection NULL_CONNECTION;
    private static RemoteConference NULL_CONFERENCE;
    private IConnectionServiceAdapter mServantDelegate;
    private ConnectionServiceAdapterServant mServant;
    private IBinder.DeathRecipient mDeathRecipient;
    private IConnectionService mOutgoingConnectionServiceRpc;
    private ConnectionService mOurConnectionServiceImpl;
    private Map<String, RemoteConnection> mConnectionById;
    private Map<String, RemoteConference> mConferenceById;
    private Set<RemoteConnection> mPendingConnections;

    private void $$robo$$android_telecom_RemoteConnectionService$__constructor__(IConnectionService outgoingConnectionServiceRpc, ConnectionService ourConnectionServiceImpl) throws RemoteException {
        this.mServantDelegate = new IConnectionServiceAdapter(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RemoteConnectionService this$0;

            private void $$robo$$android_telecom_RemoteConnectionService_1$__constructor__(RemoteConnectionService remoteConnectionService) {
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$handleCreateConnectionComplete(String id2, ConnectionRequest request, ParcelableConnection parcel) {
                RemoteConnection connection = this.this$0.findConnectionForAction(id2, "handleCreateConnectionSuccessful");
                if (connection != NULL_CONNECTION && this.this$0.mPendingConnections.contains(connection)) {
                    this.this$0.mPendingConnections.remove(connection);
                    connection.setCallCapabilities(parcel.getCapabilities());
                    connection.setAddress(parcel.getHandle(), parcel.getHandlePresentation());
                    connection.setCallerDisplayName(parcel.getCallerDisplayName(), parcel.getCallerDisplayNamePresentation());
                    if (parcel.getState() == 6) {
                        connection.setDisconnected(parcel.getDisconnectCause());
                    } else {
                        connection.setState(parcel.getState());
                    }
                    ArrayList<RemoteConnection> conferenceable = new ArrayList<RemoteConnection>();
                    for (String confId : parcel.getConferenceableConnectionIds()) {
                        if (!this.this$0.mConnectionById.containsKey(confId)) continue;
                        conferenceable.add((RemoteConnection)this.this$0.mConnectionById.get(confId));
                    }
                    connection.setConferenceableConnections(conferenceable);
                    connection.setVideoState(parcel.getVideoState());
                    if (connection.getState() == 6) {
                        connection.setDestroyed();
                    }
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setActive(String callId) {
                if (this.this$0.mConnectionById.containsKey(callId)) {
                    this.this$0.findConnectionForAction(callId, "setActive").setState(4);
                } else {
                    this.this$0.findConferenceForAction(callId, "setActive").setState(4);
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setRinging(String callId) {
                this.this$0.findConnectionForAction(callId, "setRinging").setState(2);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setDialing(String callId) {
                this.this$0.findConnectionForAction(callId, "setDialing").setState(3);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setDisconnected(String callId, DisconnectCause disconnectCause) {
                if (this.this$0.mConnectionById.containsKey(callId)) {
                    this.this$0.findConnectionForAction(callId, "setDisconnected").setDisconnected(disconnectCause);
                } else {
                    this.this$0.findConferenceForAction(callId, "setDisconnected").setDisconnected(disconnectCause);
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setOnHold(String callId) {
                if (this.this$0.mConnectionById.containsKey(callId)) {
                    this.this$0.findConnectionForAction(callId, "setOnHold").setState(5);
                } else {
                    this.this$0.findConferenceForAction(callId, "setOnHold").setState(5);
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setRingbackRequested(String callId, boolean ringing) {
                this.this$0.findConnectionForAction(callId, "setRingbackRequested").setRingbackRequested(ringing);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setCallCapabilities(String callId, int callCapabilities) {
                if (this.this$0.mConnectionById.containsKey(callId)) {
                    this.this$0.findConnectionForAction(callId, "setCallCapabilities").setCallCapabilities(callCapabilities);
                } else {
                    this.this$0.findConferenceForAction(callId, "setCallCapabilities").setCallCapabilities(callCapabilities);
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setIsConferenced(String callId, String conferenceCallId) {
                RemoteConnection connection = this.this$0.findConnectionForAction(callId, "setIsConferenced");
                if (connection != NULL_CONNECTION) {
                    if (conferenceCallId == null) {
                        if (connection.getConference() != null) {
                            connection.getConference().removeConnection(connection);
                        }
                    } else {
                        RemoteConference conference = this.this$0.findConferenceForAction(conferenceCallId, "setIsConferenced");
                        if (conference != NULL_CONFERENCE) {
                            conference.addConnection(connection);
                        }
                    }
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$addConferenceCall(String callId, ParcelableConference parcel) {
                RemoteConference conference = new RemoteConference(callId, this.this$0.mOutgoingConnectionServiceRpc);
                for (String id2 : parcel.getConnectionIds()) {
                    RemoteConnection c = (RemoteConnection)this.this$0.mConnectionById.get(id2);
                    if (c == null) continue;
                    conference.addConnection(c);
                }
                if (conference.getConnections().size() == 0) {
                    return;
                }
                conference.setState(parcel.getState());
                conference.setCallCapabilities(parcel.getCapabilities());
                this.this$0.mConferenceById.put(callId, conference);
                conference.registerCallback((RemoteConference.Callback)new ShadowedObject(this, callId){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ String val$callId;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_telecom_RemoteConnectionService_1_1$__constructor__(1 var1_1, String string2) {
                    }

                    private final void $$robo$$android_telecom_RemoteConnectionService_1_1$onDestroyed(RemoteConference c) {
                        this.this$1.this$0.mConferenceById.remove(this.val$callId);
                        this.this$1.this$0.maybeDisconnectAdapter();
                    }

                    private void __constructor__(1 var1_1, String string2) {
                        this.$$robo$$android_telecom_RemoteConnectionService_1_1$__constructor__(var1_1, string2);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$callId = string2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnectionService_1_1$__constructor__(android.telecom.RemoteConnectionService$1 java.lang.String ), 0, this, var1_1, string2);
                    }

                    @Override
                    public void onDestroyed(RemoteConference remoteConference) {
                        InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConnectionService_1_1$onDestroyed(android.telecom.RemoteConference ), 0, this, remoteConference);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                this.this$0.mOurConnectionServiceImpl.addRemoteConference(conference);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$removeCall(String callId) {
                if (this.this$0.mConnectionById.containsKey(callId)) {
                    this.this$0.findConnectionForAction(callId, "removeCall").setDestroyed();
                } else {
                    this.this$0.findConferenceForAction(callId, "removeCall").setDestroyed();
                }
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$onPostDialWait(String callId, String remaining) {
                this.this$0.findConnectionForAction(callId, "onPostDialWait").setPostDialWait(remaining);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$queryRemoteConnectionServices(RemoteServiceCallback callback) {
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setVideoProvider(String callId, IVideoProvider videoProvider) {
                this.this$0.findConnectionForAction(callId, "setVideoProvider").setVideoProvider(new RemoteConnection.VideoProvider(videoProvider));
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setVideoState(String callId, int videoState) {
                this.this$0.findConnectionForAction(callId, "setVideoState").setVideoState(videoState);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setIsVoipAudioMode(String callId, boolean isVoip) {
                this.this$0.findConnectionForAction(callId, "setIsVoipAudioMode").setIsVoipAudioMode(isVoip);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setStatusHints(String callId, StatusHints statusHints) {
                this.this$0.findConnectionForAction(callId, "setStatusHints").setStatusHints(statusHints);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setAddress(String callId, Uri address, int presentation) {
                this.this$0.findConnectionForAction(callId, "setAddress").setAddress(address, presentation);
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setCallerDisplayName(String callId, String callerDisplayName, int presentation) {
                this.this$0.findConnectionForAction(callId, "setCallerDisplayName").setCallerDisplayName(callerDisplayName, presentation);
            }

            private final IBinder $$robo$$android_telecom_RemoteConnectionService_1$asBinder() {
                throw new UnsupportedOperationException();
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_1$setConferenceableConnections(String callId, List<String> conferenceableConnectionIds) {
                ArrayList<RemoteConnection> conferenceable = new ArrayList<RemoteConnection>();
                for (String id2 : conferenceableConnectionIds) {
                    if (!this.this$0.mConnectionById.containsKey(id2)) continue;
                    conferenceable.add((RemoteConnection)this.this$0.mConnectionById.get(id2));
                }
                if (this.this$0.hasConnection(callId)) {
                    this.this$0.findConnectionForAction(callId, "setConferenceableConnections").setConferenceableConnections(conferenceable);
                } else {
                    this.this$0.findConferenceForAction(callId, "setConferenceableConnections").setConferenceableConnections(conferenceable);
                }
            }

            private void __constructor__(RemoteConnectionService remoteConnectionService) {
                this.$$robo$$android_telecom_RemoteConnectionService_1$__constructor__(remoteConnectionService);
            }
            {
                this.this$0 = remoteConnectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnectionService_1$__constructor__(android.telecom.RemoteConnectionService ), 0, this, remoteConnectionService);
            }

            @Override
            public void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) {
                InvokeDynamicSupport.bootstrap("handleCreateConnectionComplete", $$robo$$android_telecom_RemoteConnectionService_1$handleCreateConnectionComplete(java.lang.String android.telecom.ConnectionRequest android.telecom.ParcelableConnection ), 0, this, string2, connectionRequest, parcelableConnection);
            }

            @Override
            public void setActive(String string2) {
                InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_RemoteConnectionService_1$setActive(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setRinging(String string2) {
                InvokeDynamicSupport.bootstrap("setRinging", $$robo$$android_telecom_RemoteConnectionService_1$setRinging(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setDialing(String string2) {
                InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_RemoteConnectionService_1$setDialing(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setDisconnected(String string2, DisconnectCause disconnectCause) {
                InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_RemoteConnectionService_1$setDisconnected(java.lang.String android.telecom.DisconnectCause ), 0, this, string2, disconnectCause);
            }

            @Override
            public void setOnHold(String string2) {
                InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_RemoteConnectionService_1$setOnHold(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setRingbackRequested(String string2, boolean bl) {
                InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_RemoteConnectionService_1$setRingbackRequested(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public void setCallCapabilities(String string2, int n) {
                InvokeDynamicSupport.bootstrap("setCallCapabilities", $$robo$$android_telecom_RemoteConnectionService_1$setCallCapabilities(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void setIsConferenced(String string2, String string3) {
                InvokeDynamicSupport.bootstrap("setIsConferenced", $$robo$$android_telecom_RemoteConnectionService_1$setIsConferenced(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void addConferenceCall(String string2, ParcelableConference parcelableConference) {
                InvokeDynamicSupport.bootstrap("addConferenceCall", $$robo$$android_telecom_RemoteConnectionService_1$addConferenceCall(java.lang.String android.telecom.ParcelableConference ), 0, this, string2, parcelableConference);
            }

            @Override
            public void removeCall(String string2) {
                InvokeDynamicSupport.bootstrap("removeCall", $$robo$$android_telecom_RemoteConnectionService_1$removeCall(java.lang.String ), 0, this, string2);
            }

            @Override
            public void onPostDialWait(String string2, String string3) {
                InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_RemoteConnectionService_1$onPostDialWait(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) {
                InvokeDynamicSupport.bootstrap("queryRemoteConnectionServices", $$robo$$android_telecom_RemoteConnectionService_1$queryRemoteConnectionServices(com.android.internal.telecom.RemoteServiceCallback ), 0, this, remoteServiceCallback);
            }

            @Override
            public void setVideoProvider(String string2, IVideoProvider iVideoProvider) {
                InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_RemoteConnectionService_1$setVideoProvider(java.lang.String com.android.internal.telecom.IVideoProvider ), 0, this, string2, iVideoProvider);
            }

            @Override
            public void setVideoState(String string2, int n) {
                InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_RemoteConnectionService_1$setVideoState(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void setIsVoipAudioMode(String string2, boolean bl) {
                InvokeDynamicSupport.bootstrap("setIsVoipAudioMode", $$robo$$android_telecom_RemoteConnectionService_1$setIsVoipAudioMode(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public void setStatusHints(String string2, StatusHints statusHints) {
                InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_RemoteConnectionService_1$setStatusHints(java.lang.String android.telecom.StatusHints ), 0, this, string2, statusHints);
            }

            @Override
            public void setAddress(String string2, Uri uri, int n) {
                InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_RemoteConnectionService_1$setAddress(java.lang.String android.net.Uri int ), 0, this, string2, uri, n);
            }

            @Override
            public void setCallerDisplayName(String string2, String string3, int n) {
                InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_RemoteConnectionService_1$setCallerDisplayName(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_telecom_RemoteConnectionService_1$asBinder(), 0, this);
            }

            @Override
            public void setConferenceableConnections(String string2, List<String> list) {
                InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_RemoteConnectionService_1$setConferenceableConnections(java.lang.String java.util.List<java.lang.String> ), 0, this, string2, list);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mServant = new ConnectionServiceAdapterServant(this.mServantDelegate);
        this.mDeathRecipient = new IBinder.DeathRecipient(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RemoteConnectionService this$0;

            private void $$robo$$android_telecom_RemoteConnectionService_2$__constructor__(RemoteConnectionService remoteConnectionService) {
            }

            private final void $$robo$$android_telecom_RemoteConnectionService_2$binderDied() {
                for (Object c : this.this$0.mConnectionById.values()) {
                    ((RemoteConnection)c).setDestroyed();
                }
                for (Object c : this.this$0.mConferenceById.values()) {
                    ((RemoteConference)c).setDestroyed();
                }
                this.this$0.mConnectionById.clear();
                this.this$0.mConferenceById.clear();
                this.this$0.mPendingConnections.clear();
                this.this$0.mOutgoingConnectionServiceRpc.asBinder().unlinkToDeath(this.this$0.mDeathRecipient, 0);
            }

            private void __constructor__(RemoteConnectionService remoteConnectionService) {
                this.$$robo$$android_telecom_RemoteConnectionService_2$__constructor__(remoteConnectionService);
            }
            {
                this.this$0 = remoteConnectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnectionService_2$__constructor__(android.telecom.RemoteConnectionService ), 0, this, remoteConnectionService);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telecom_RemoteConnectionService_2$binderDied(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnectionById = new HashMap<String, RemoteConnection>();
        this.mConferenceById = new HashMap<String, RemoteConference>();
        this.mPendingConnections = new HashSet<RemoteConnection>();
        this.mOutgoingConnectionServiceRpc = outgoingConnectionServiceRpc;
        this.mOutgoingConnectionServiceRpc.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mOurConnectionServiceImpl = ourConnectionServiceImpl;
    }

    private final String $$robo$$android_telecom_RemoteConnectionService$toString() {
        return "[RemoteCS - " + this.mOutgoingConnectionServiceRpc.asBinder().toString() + "]";
    }

    private final RemoteConnection $$robo$$android_telecom_RemoteConnectionService$createRemoteConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request, boolean isIncoming) {
        String id2 = UUID.randomUUID().toString();
        ConnectionRequest newRequest = new ConnectionRequest(request.getAccountHandle(), request.getAddress(), request.getExtras(), request.getVideoState());
        try {
            if (this.mConnectionById.isEmpty()) {
                this.mOutgoingConnectionServiceRpc.addConnectionServiceAdapter(this.mServant.getStub());
            }
            RemoteConnection connection = new RemoteConnection(id2, this.mOutgoingConnectionServiceRpc, newRequest);
            this.mPendingConnections.add(connection);
            this.mConnectionById.put(id2, connection);
            this.mOutgoingConnectionServiceRpc.createConnection(connectionManagerPhoneAccount, id2, newRequest, isIncoming, false);
            connection.registerCallback((RemoteConnection.Callback)new ShadowedObject(this, id2){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$id;
                /* synthetic */ RemoteConnectionService this$0;

                private void $$robo$$android_telecom_RemoteConnectionService_3$__constructor__(RemoteConnectionService remoteConnectionService, String string2) {
                }

                private final void $$robo$$android_telecom_RemoteConnectionService_3$onDestroyed(RemoteConnection connection) {
                    this.this$0.mConnectionById.remove(this.val$id);
                    this.this$0.maybeDisconnectAdapter();
                }

                private void __constructor__(RemoteConnectionService remoteConnectionService, String string2) {
                    this.$$robo$$android_telecom_RemoteConnectionService_3$__constructor__(remoteConnectionService, string2);
                }
                {
                    this.this$0 = remoteConnectionService;
                    this.val$id = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnectionService_3$__constructor__(android.telecom.RemoteConnectionService java.lang.String ), 0, this, remoteConnectionService, string2);
                }

                @Override
                public void onDestroyed(RemoteConnection remoteConnection) {
                    InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConnectionService_3$onDestroyed(android.telecom.RemoteConnection ), 0, this, remoteConnection);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return connection;
        }
        catch (RemoteException e) {
            return RemoteConnection.failure(new DisconnectCause(1, e.toString()));
        }
    }

    private final boolean $$robo$$android_telecom_RemoteConnectionService$hasConnection(String callId) {
        return this.mConnectionById.containsKey(callId);
    }

    private final RemoteConnection $$robo$$android_telecom_RemoteConnectionService$findConnectionForAction(String callId, String action) {
        if (this.mConnectionById.containsKey(callId)) {
            return this.mConnectionById.get(callId);
        }
        Log.w(this, "%s - Cannot find Connection %s", action, callId);
        return NULL_CONNECTION;
    }

    private final RemoteConference $$robo$$android_telecom_RemoteConnectionService$findConferenceForAction(String callId, String action) {
        if (this.mConferenceById.containsKey(callId)) {
            return this.mConferenceById.get(callId);
        }
        Log.w(this, "%s - Cannot find Conference %s", action, callId);
        return NULL_CONFERENCE;
    }

    private final void $$robo$$android_telecom_RemoteConnectionService$maybeDisconnectAdapter() {
        if (this.mConnectionById.isEmpty() && this.mConferenceById.isEmpty()) {
            try {
                this.mOutgoingConnectionServiceRpc.removeConnectionServiceAdapter(this.mServant.getStub());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static void __staticInitializer__() {
        NULL_CONNECTION = new RemoteConnection("NULL", null, null);
        NULL_CONFERENCE = new RemoteConference("NULL", null);
    }

    private void __constructor__(IConnectionService iConnectionService, ConnectionService connectionService) throws RemoteException {
        this.$$robo$$android_telecom_RemoteConnectionService$__constructor__(iConnectionService, connectionService);
    }

    RemoteConnectionService(IConnectionService iConnectionService, ConnectionService connectionService) throws RemoteException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConnectionService$__constructor__(com.android.internal.telecom.IConnectionService android.telecom.ConnectionService ), 0, this, iConnectionService, connectionService);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_RemoteConnectionService$toString(), 0, this);
    }

    RemoteConnection createRemoteConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createRemoteConnection", $$robo$$android_telecom_RemoteConnectionService$createRemoteConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest boolean ), 0, this, phoneAccountHandle, connectionRequest, bl);
    }

    private boolean hasConnection(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasConnection", $$robo$$android_telecom_RemoteConnectionService$hasConnection(java.lang.String ), 0, this, string2);
    }

    private RemoteConnection findConnectionForAction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("findConnectionForAction", $$robo$$android_telecom_RemoteConnectionService$findConnectionForAction(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private RemoteConference findConferenceForAction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("findConferenceForAction", $$robo$$android_telecom_RemoteConnectionService$findConferenceForAction(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void maybeDisconnectAdapter() {
        InvokeDynamicSupport.bootstrap("maybeDisconnectAdapter", $$robo$$android_telecom_RemoteConnectionService$maybeDisconnectAdapter(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RemoteConnectionService.class);
    }

    public /* synthetic */ RemoteConnectionService() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteConnectionService)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

