/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelecomManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String ACTION_INCOMING_CALL = "android.telecom.action.INCOMING_CALL";
    public static String ACTION_NEW_UNKNOWN_CALL = "android.telecom.action.NEW_UNKNOWN_CALL";
    public static String ACTION_CONNECTION_SERVICE_CONFIGURE = "android.telecom.action.CONNECTION_SERVICE_CONFIGURE";
    public static String ACTION_SHOW_CALL_SETTINGS = "android.telecom.action.SHOW_CALL_SETTINGS";
    public static String ACTION_CHANGE_PHONE_ACCOUNTS = "android.telecom.action.CHANGE_PHONE_ACCOUNTS";
    public static String EXTRA_START_CALL_WITH_SPEAKERPHONE = "android.telecom.extra.START_CALL_WITH_SPEAKERPHONE";
    public static String EXTRA_START_CALL_WITH_VIDEO_STATE = "android.telecom.extra.START_CALL_WITH_VIDEO_STATE";
    public static String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telecom.extra.PHONE_ACCOUNT_HANDLE";
    public static String EXTRA_INCOMING_CALL_EXTRAS = "android.telecom.extra.INCOMING_CALL_EXTRAS";
    public static String EXTRA_OUTGOING_CALL_EXTRAS = "android.telecom.extra.OUTGOING_CALL_EXTRAS";
    public static String EXTRA_UNKNOWN_CALL_HANDLE = "android.telecom.extra.UNKNOWN_CALL_HANDLE";
    public static String EXTRA_CALL_DISCONNECT_CAUSE = "android.telecom.extra.CALL_DISCONNECT_CAUSE";
    public static String EXTRA_CALL_DISCONNECT_MESSAGE = "android.telecom.extra.CALL_DISCONNECT_MESSAGE";
    public static String EXTRA_CONNECTION_SERVICE = "android.telecom.extra.CONNECTION_SERVICE";
    public static String GATEWAY_PROVIDER_PACKAGE = "android.telecom.extra.GATEWAY_PROVIDER_PACKAGE";
    public static String GATEWAY_ORIGINAL_ADDRESS = "android.telecom.extra.GATEWAY_ORIGINAL_ADDRESS";
    public static String EXTRA_CALL_BACK_NUMBER = "android.telecom.extra.CALL_BACK_NUMBER";
    public static char DTMF_CHARACTER_PAUSE = ',';
    public static char DTMF_CHARACTER_WAIT = ';';
    public static int TTY_MODE_OFF = 0;
    public static int TTY_MODE_FULL = 1;
    public static int TTY_MODE_HCO = 2;
    public static int TTY_MODE_VCO = 3;
    public static String ACTION_CURRENT_TTY_MODE_CHANGED = "android.telecom.action.CURRENT_TTY_MODE_CHANGED";
    public static String EXTRA_CURRENT_TTY_MODE = "android.telecom.intent.extra.CURRENT_TTY_MODE";
    public static String ACTION_TTY_PREFERRED_MODE_CHANGED = "android.telecom.action.TTY_PREFERRED_MODE_CHANGED";
    public static String EXTRA_TTY_PREFERRED_MODE = "android.telecom.intent.extra.TTY_PREFERRED";
    public static int PRESENTATION_ALLOWED = 1;
    public static int PRESENTATION_RESTRICTED = 2;
    public static int PRESENTATION_UNKNOWN = 3;
    public static int PRESENTATION_PAYPHONE = 4;
    private static String TAG = "TelecomManager";
    private Context mContext;

    private static final TelecomManager $$robo$$android_telecom_TelecomManager$from(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    private void $$robo$$android_telecom_TelecomManager$__constructor__(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getDefaultOutgoingPhoneAccount(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultOutgoingPhoneAccount(uriScheme);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getDefaultOutgoingPhoneAccount", e);
        }
        return null;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getUserSelectedOutgoingPhoneAccount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getUserSelectedOutgoingPhoneAccount();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getUserSelectedOutgoingPhoneAccount", e);
        }
        return null;
    }

    private final void $$robo$$android_telecom_TelecomManager$setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setUserSelectedOutgoingPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#setUserSelectedOutgoingPhoneAccount");
        }
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getSimCallManager() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManager();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getSimCallManager");
        }
        return null;
    }

    private final void $$robo$$android_telecom_TelecomManager$setSimCallManager(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setSimCallManager(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#setSimCallManager");
        }
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getSimCallManagers() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManagers();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getSimCallManagers");
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getConnectionManager() {
        return this.getSimCallManager();
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getPhoneAccountsSupportingScheme(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsSupportingScheme(uriScheme);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccountsSupportingScheme", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallCapablePhoneAccounts();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getCallCapablePhoneAccounts", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    private final boolean $$robo$$android_telecom_TelecomManager$hasMultipleCallCapableAccounts() {
        return this.getCallCapablePhoneAccounts().size() > 1;
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getPhoneAccountsForPackage() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsForPackage(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccountsForPackage", e);
        }
        return null;
    }

    private final PhoneAccount $$robo$$android_telecom_TelecomManager$getPhoneAccount(PhoneAccountHandle account) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccount", e);
        }
        return null;
    }

    private final int $$robo$$android_telecom_TelecomManager$getAllPhoneAccountsCount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountsCount();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccountsCount", e);
        }
        return 0;
    }

    private final List<PhoneAccount> $$robo$$android_telecom_TelecomManager$getAllPhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccounts();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccounts", e);
        }
        return Collections.EMPTY_LIST;
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getAllPhoneAccountHandles() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountHandles();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccountHandles", e);
        }
        return Collections.EMPTY_LIST;
    }

    private final void $$robo$$android_telecom_TelecomManager$registerPhoneAccount(PhoneAccount account) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().registerPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#registerPhoneAccount", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().unregisterPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#unregisterPhoneAccount", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$clearAccounts() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().clearAccounts(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#clearAccounts", e);
        }
    }

    private final ComponentName $$robo$$android_telecom_TelecomManager$getDefaultPhoneApp() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultPhoneApp();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException attempting to get the default phone app.", e);
        }
        return null;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isInCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isInCall();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException calling isInCall().", e);
        }
        return false;
    }

    private final int $$robo$$android_telecom_TelecomManager$getCallState() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallState();
            }
        }
        catch (RemoteException e) {
            Log.d("TelecomManager", "RemoteException calling getCallState().", e);
        }
        return 0;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isRinging() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isRinging();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException attempting to get ringing state of phone app.", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$endCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().endCall();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#endCall", e);
        }
        return false;
    }

    private final void $$robo$$android_telecom_TelecomManager$acceptRingingCall() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().acceptRingingCall();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#acceptRingingCall", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$silenceRinger() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().silenceRinger();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "Error calling ITelecomService#silenceRinger", e);
        }
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isTtySupported() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isTtySupported();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException attempting to get TTY supported state.", e);
        }
        return false;
    }

    private final int $$robo$$android_telecom_TelecomManager$getCurrentTtyMode() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCurrentTtyMode();
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException attempting to get the current TTY mode.", e);
        }
        return 0;
    }

    private final void $$robo$$android_telecom_TelecomManager$addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewIncomingCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException adding a new incoming call: " + phoneAccount, e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewUnknownCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            Log.e("TelecomManager", "RemoteException adding a new unknown call: " + phoneAccount, e);
        }
    }

    private final boolean $$robo$$android_telecom_TelecomManager$handleMmi(String dialString) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmi(dialString);
            }
            catch (RemoteException e) {
                Log.e("TelecomManager", "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    private final void $$robo$$android_telecom_TelecomManager$cancelMissedCallsNotification() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.cancelMissedCallsNotification();
            }
            catch (RemoteException e) {
                Log.e("TelecomManager", "Error calling ITelecomService#cancelMissedCallsNotification", e);
            }
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$showInCallScreen(boolean showDialpad) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.showInCallScreen(showDialpad);
            }
            catch (RemoteException e) {
                Log.e("TelecomManager", "Error calling ITelecomService#showCallScreen", e);
            }
        }
    }

    private final ITelecomService $$robo$$android_telecom_TelecomManager$getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isServiceConnected() {
        boolean isConnected;
        boolean bl = isConnected = this.getTelecomService() != null;
        if (!isConnected) {
            Log.w("TelecomManager", "Telecom Service not found.");
        }
        return isConnected;
    }

    public static TelecomManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telecom_TelecomManager$from(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telecom_TelecomManager$__constructor__(context);
    }

    public TelecomManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_TelecomManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String string2) {
        return InvokeDynamicSupport.bootstrap("getDefaultOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$getDefaultOutgoingPhoneAccount(java.lang.String ), 0, this, string2);
    }

    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        return InvokeDynamicSupport.bootstrap("getUserSelectedOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$getUserSelectedOutgoingPhoneAccount(), 0, this);
    }

    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("setUserSelectedOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$setUserSelectedOutgoingPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public PhoneAccountHandle getSimCallManager() {
        return InvokeDynamicSupport.bootstrap("getSimCallManager", $$robo$$android_telecom_TelecomManager$getSimCallManager(), 0, this);
    }

    public void setSimCallManager(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("setSimCallManager", $$robo$$android_telecom_TelecomManager$setSimCallManager(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public List<PhoneAccountHandle> getSimCallManagers() {
        return InvokeDynamicSupport.bootstrap("getSimCallManagers", $$robo$$android_telecom_TelecomManager$getSimCallManagers(), 0, this);
    }

    public PhoneAccountHandle getConnectionManager() {
        return InvokeDynamicSupport.bootstrap("getConnectionManager", $$robo$$android_telecom_TelecomManager$getConnectionManager(), 0, this);
    }

    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String string2) {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountsSupportingScheme", $$robo$$android_telecom_TelecomManager$getPhoneAccountsSupportingScheme(java.lang.String ), 0, this, string2);
    }

    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return InvokeDynamicSupport.bootstrap("getCallCapablePhoneAccounts", $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts(), 0, this);
    }

    public boolean hasMultipleCallCapableAccounts() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMultipleCallCapableAccounts", $$robo$$android_telecom_TelecomManager$hasMultipleCallCapableAccounts(), 0, this);
    }

    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountsForPackage", $$robo$$android_telecom_TelecomManager$getPhoneAccountsForPackage(), 0, this);
    }

    public PhoneAccount getPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getPhoneAccount", $$robo$$android_telecom_TelecomManager$getPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public int getAllPhoneAccountsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllPhoneAccountsCount", $$robo$$android_telecom_TelecomManager$getAllPhoneAccountsCount(), 0, this);
    }

    public List<PhoneAccount> getAllPhoneAccounts() {
        return InvokeDynamicSupport.bootstrap("getAllPhoneAccounts", $$robo$$android_telecom_TelecomManager$getAllPhoneAccounts(), 0, this);
    }

    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        return InvokeDynamicSupport.bootstrap("getAllPhoneAccountHandles", $$robo$$android_telecom_TelecomManager$getAllPhoneAccountHandles(), 0, this);
    }

    public void registerPhoneAccount(PhoneAccount phoneAccount) {
        InvokeDynamicSupport.bootstrap("registerPhoneAccount", $$robo$$android_telecom_TelecomManager$registerPhoneAccount(android.telecom.PhoneAccount ), 0, this, phoneAccount);
    }

    public void unregisterPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("unregisterPhoneAccount", $$robo$$android_telecom_TelecomManager$unregisterPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void clearAccounts() {
        InvokeDynamicSupport.bootstrap("clearAccounts", $$robo$$android_telecom_TelecomManager$clearAccounts(), 0, this);
    }

    public ComponentName getDefaultPhoneApp() {
        return InvokeDynamicSupport.bootstrap("getDefaultPhoneApp", $$robo$$android_telecom_TelecomManager$getDefaultPhoneApp(), 0, this);
    }

    public boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$android_telecom_TelecomManager$isInCall(), 0, this);
    }

    public int getCallState() {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telecom_TelecomManager$getCallState(), 0, this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$android_telecom_TelecomManager$isRinging(), 0, this);
    }

    public boolean endCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("endCall", $$robo$$android_telecom_TelecomManager$endCall(), 0, this);
    }

    public void acceptRingingCall() {
        InvokeDynamicSupport.bootstrap("acceptRingingCall", $$robo$$android_telecom_TelecomManager$acceptRingingCall(), 0, this);
    }

    public void silenceRinger() {
        InvokeDynamicSupport.bootstrap("silenceRinger", $$robo$$android_telecom_TelecomManager$silenceRinger(), 0, this);
    }

    public boolean isTtySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTtySupported", $$robo$$android_telecom_TelecomManager$isTtySupported(), 0, this);
    }

    public int getCurrentTtyMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentTtyMode", $$robo$$android_telecom_TelecomManager$getCurrentTtyMode(), 0, this);
    }

    public void addNewIncomingCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addNewIncomingCall", $$robo$$android_telecom_TelecomManager$addNewIncomingCall(android.telecom.PhoneAccountHandle android.os.Bundle ), 0, this, phoneAccountHandle, bundle);
    }

    public void addNewUnknownCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addNewUnknownCall", $$robo$$android_telecom_TelecomManager$addNewUnknownCall(android.telecom.PhoneAccountHandle android.os.Bundle ), 0, this, phoneAccountHandle, bundle);
    }

    public boolean handleMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMmi", $$robo$$android_telecom_TelecomManager$handleMmi(java.lang.String ), 0, this, string2);
    }

    public void cancelMissedCallsNotification() {
        InvokeDynamicSupport.bootstrap("cancelMissedCallsNotification", $$robo$$android_telecom_TelecomManager$cancelMissedCallsNotification(), 0, this);
    }

    public void showInCallScreen(boolean bl) {
        InvokeDynamicSupport.bootstrap("showInCallScreen", $$robo$$android_telecom_TelecomManager$showInCallScreen(boolean ), 0, this, bl);
    }

    private ITelecomService getTelecomService() {
        return InvokeDynamicSupport.bootstrap("getTelecomService", $$robo$$android_telecom_TelecomManager$getTelecomService(), 0, this);
    }

    private boolean isServiceConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceConnected", $$robo$$android_telecom_TelecomManager$isServiceConnected(), 0, this);
    }

    public /* synthetic */ TelecomManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelecomManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

