/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.telephony.IMms;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.SmsRawData;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SmsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_SUB_ID = -1002;
    private static SmsManager sInstance;
    private static Object sLockObject;
    private static Map<Long, SmsManager> sSubInstances;
    private long mSubId;
    public static String MMS_CONFIG_APPEND_TRANSACTION_ID = "enabledTransID";
    public static String MMS_CONFIG_MMS_ENABLED = "enabledMMS";
    public static String MMS_CONFIG_GROUP_MMS_ENABLED = "enableGroupMms";
    public static String MMS_CONFIG_NOTIFY_WAP_MMSC_ENABLED = "enabledNotifyWapMMSC";
    public static String MMS_CONFIG_ALIAS_ENABLED = "aliasEnabled";
    public static String MMS_CONFIG_ALLOW_ATTACH_AUDIO = "allowAttachAudio";
    public static String MMS_CONFIG_MULTIPART_SMS_ENABLED = "enableMultipartSMS";
    public static String MMS_CONFIG_SMS_DELIVERY_REPORT_ENABLED = "enableSMSDeliveryReports";
    public static String MMS_CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION = "supportMmsContentDisposition";
    public static String MMS_CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES = "sendMultipartSmsAsSeparateMessages";
    public static String MMS_CONFIG_MMS_READ_REPORT_ENABLED = "enableMMSReadReports";
    public static String MMS_CONFIG_MMS_DELIVERY_REPORT_ENABLED = "enableMMSDeliveryReports";
    public static String MMS_CONFIG_MAX_MESSAGE_SIZE = "maxMessageSize";
    public static String MMS_CONFIG_MAX_IMAGE_WIDTH = "maxImageWidth";
    public static String MMS_CONFIG_MAX_IMAGE_HEIGHT = "maxImageHeight";
    public static String MMS_CONFIG_RECIPIENT_LIMIT = "recipientLimit";
    public static String MMS_CONFIG_ALIAS_MIN_CHARS = "aliasMinChars";
    public static String MMS_CONFIG_ALIAS_MAX_CHARS = "aliasMaxChars";
    public static String MMS_CONFIG_SMS_TO_MMS_TEXT_THRESHOLD = "smsToMmsTextThreshold";
    public static String MMS_CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD = "smsToMmsTextLengthThreshold";
    public static String MMS_CONFIG_MESSAGE_TEXT_MAX_SIZE = "maxMessageTextSize";
    public static String MMS_CONFIG_SUBJECT_MAX_LENGTH = "maxSubjectLength";
    public static String MMS_CONFIG_HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    public static String MMS_CONFIG_UA_PROF_TAG_NAME = "uaProfTagName";
    public static String MMS_CONFIG_USER_AGENT = "userAgent";
    public static String MMS_CONFIG_UA_PROF_URL = "uaProfUrl";
    public static String MMS_CONFIG_HTTP_PARAMS = "httpParams";
    public static String MMS_CONFIG_EMAIL_GATEWAY_NUMBER = "emailGatewayNumber";
    public static String MMS_CONFIG_NAI_SUFFIX = "naiSuffix";
    public static int STATUS_ON_ICC_FREE = 0;
    public static int STATUS_ON_ICC_READ = 1;
    public static int STATUS_ON_ICC_UNREAD = 3;
    public static int STATUS_ON_ICC_SENT = 5;
    public static int STATUS_ON_ICC_UNSENT = 7;
    public static int RESULT_ERROR_GENERIC_FAILURE = 1;
    public static int RESULT_ERROR_RADIO_OFF = 2;
    public static int RESULT_ERROR_NULL_PDU = 3;
    public static int RESULT_ERROR_NO_SERVICE = 4;
    public static int RESULT_ERROR_LIMIT_EXCEEDED = 5;
    public static int RESULT_ERROR_FDN_CHECK_FAILURE = 6;
    private static String PHONE_PACKAGE_NAME = "com.android.phone";
    public static int MMS_ERROR_UNSPECIFIED = 1;
    public static int MMS_ERROR_INVALID_APN = 2;
    public static int MMS_ERROR_UNABLE_CONNECT_MMS = 3;
    public static int MMS_ERROR_HTTP_FAILURE = 4;
    public static int MMS_ERROR_IO_ERROR = 5;
    public static int MMS_ERROR_RETRY = 6;
    public static int MMS_ERROR_CONFIGURATION_ERROR = 7;
    public static String EXTRA_MMS_DATA = "android.telephony.extra.MMS_DATA";
    public static int SMS_TYPE_INCOMING = 0;
    public static int SMS_TYPE_OUTGOING = 1;
    public static String MESSAGE_STATUS_SEEN = "seen";
    public static String MESSAGE_STATUS_READ = "read";

    private final void $$robo$$android_telephony_SmsManager$sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendText(ActivityThread.currentPackageName(), destinationAddress, scAddress, text, sentIntent, deliveryIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        if (!format.equals("3gpp") && !format.equals("3gpp2")) {
            throw new IllegalArgumentException("Invalid pdu format. format must be either 3gpp or 3gpp2");
        }
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.injectSmsPdu(pdu, format, receivedIntent);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$updateSmsSendStatus(int messageRef, boolean success) {
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.updateSmsSendStatus(messageRef, success);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final ArrayList<String> $$robo$$android_telephony_SmsManager$divideMessage(String text) {
        if (null == text) {
            throw new IllegalArgumentException("text is null");
        }
        return SmsMessage.fragmentText(text);
    }

    private final void $$robo$$android_telephony_SmsManager$sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null || parts.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (parts.size() > 1) {
            try {
                ISms iccISms = SmsManager.getISmsServiceOrThrow();
                iccISms.sendMultipartText(ActivityThread.currentPackageName(), destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
            }
            catch (RemoteException iccISms) {}
        } else {
            PendingIntent sentIntent = null;
            PendingIntent deliveryIntent = null;
            if (sentIntents != null && sentIntents.size() > 0) {
                sentIntent = sentIntents.get(0);
            }
            if (deliveryIntents != null && deliveryIntents.size() > 0) {
                deliveryIntent = deliveryIntents.get(0);
            }
            this.sendTextMessage(destinationAddress, scAddress, parts.get(0), sentIntent, deliveryIntent);
        }
    }

    private final void $$robo$$android_telephony_SmsManager$sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid message data");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendData(ActivityThread.currentPackageName(), destinationAddress, scAddress, destinationPort & 0xFFFF, data, sentIntent, deliveryIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final SmsManager $$robo$$android_telephony_SmsManager$getDefault() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SmsManager $$robo$$android_telephony_SmsManager$getSmsManagerForSubscriber(long subId) {
        Object object = sLockObject;
        synchronized (object) {
            SmsManager smsManager = sSubInstances.get(subId);
            if (smsManager == null) {
                smsManager = new SmsManager(subId);
                sSubInstances.put(subId, smsManager);
            }
            return smsManager;
        }
    }

    private void $$robo$$android_telephony_SmsManager$__constructor__(long subId) {
        this.mSubId = subId;
    }

    private final long $$robo$$android_telephony_SmsManager$getSubId() {
        if (this.mSubId == -1002L) {
            return SmsManager.getDefaultSmsSubId();
        }
        return this.mSubId;
    }

    private static final ISms $$robo$$android_telephony_SmsManager$getISmsServiceOrThrow() {
        ISms iccISms = SmsManager.getISmsService();
        if (iccISms == null) {
            throw new UnsupportedOperationException("Sms is not supported");
        }
        return iccISms;
    }

    private static final ISms $$robo$$android_telephony_SmsManager$getISmsService() {
        return ISms.Stub.asInterface(ServiceManager.getService("isms"));
    }

    private final boolean $$robo$$android_telephony_SmsManager$copyMessageToIcc(byte[] smsc, byte[] pdu, int status) {
        boolean success = false;
        if (null == pdu) {
            throw new IllegalArgumentException("pdu is NULL");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.copyMessageToIccEf(ActivityThread.currentPackageName(), status, pdu, smsc);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private final boolean $$robo$$android_telephony_SmsManager$deleteMessageFromIcc(int messageIndex) {
        boolean success = false;
        byte[] pdu = new byte[175];
        Arrays.fill(pdu, (byte)-1);
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(ActivityThread.currentPackageName(), messageIndex, 0, pdu);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private final boolean $$robo$$android_telephony_SmsManager$updateMessageOnIcc(int messageIndex, int newStatus, byte[] pdu) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(ActivityThread.currentPackageName(), messageIndex, newStatus, pdu);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private static final ArrayList<SmsMessage> $$robo$$android_telephony_SmsManager$getAllMessagesFromIcc() {
        List<SmsRawData> records = null;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                records = iccISms.getAllMessagesFromIccEf(ActivityThread.currentPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return SmsManager.createMessageListFromRawRecords(records);
    }

    private final boolean $$robo$$android_telephony_SmsManager$enableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.enableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private final boolean $$robo$$android_telephony_SmsManager$disableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.disableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private final boolean $$robo$$android_telephony_SmsManager$enableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.enableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private final boolean $$robo$$android_telephony_SmsManager$disableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.disableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    private static final ArrayList<SmsMessage> $$robo$$android_telephony_SmsManager$createMessageListFromRawRecords(List<SmsRawData> records) {
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        if (records != null) {
            int count = records.size();
            for (int i = 0; i < count; ++i) {
                SmsMessage sms;
                SmsRawData data = records.get(i);
                if (data == null || (sms = SmsMessage.createFromEfRecord(i + 1, data.getBytes())) == null) continue;
                messages.add(sms);
            }
        }
        return messages;
    }

    private final boolean $$robo$$android_telephony_SmsManager$isImsSmsSupported() {
        boolean boSupported = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                boSupported = iccISms.isImsSmsSupported();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return boSupported;
    }

    private final String $$robo$$android_telephony_SmsManager$getImsSmsFormat() {
        String format = "unknown";
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                format = iccISms.getImsSmsFormat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return format;
    }

    private static final long $$robo$$android_telephony_SmsManager$getDefaultSmsSubId() {
        ISms iccISms = null;
        try {
            iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            return iccISms.getPreferredSmsSubscription();
        }
        catch (RemoteException ex) {
            return -1002L;
        }
        catch (NullPointerException ex) {
            return -1002L;
        }
    }

    private final boolean $$robo$$android_telephony_SmsManager$isSMSPromptEnabled() {
        ISms iccISms = null;
        try {
            iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            return iccISms.isSMSPromptEnabled();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final void $$robo$$android_telephony_SmsManager$sendMultimediaMessage(Context context, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            context.grantUriPermission("com.android.phone", contentUri, 1);
            this.grantCarrierPackageUriPermission(context, contentUri, "android.provider.Telephony.MMS_SEND", 1);
            iMms.sendMessage(this.getSubId(), ActivityThread.currentPackageName(), contentUri, locationUrl, configOverrides, sentIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$grantCarrierPackageUriPermission(Context context, Uri contentUri, String action, int permission2) {
        Intent intent = new Intent(action);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        List<String> carrierPackages = telephonyManager.getCarrierPackageNamesForIntent(intent);
        if (carrierPackages != null && carrierPackages.size() == 1) {
            context.grantUriPermission(carrierPackages.get(0), contentUri, permission2);
        }
    }

    private final void $$robo$$android_telephony_SmsManager$downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent) {
        if (TextUtils.isEmpty(locationUrl)) {
            throw new IllegalArgumentException("Empty MMS location URL");
        }
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            context.grantUriPermission("com.android.phone", contentUri, 2);
            this.grantCarrierPackageUriPermission(context, contentUri, "android.provider.Telephony.MMS_DOWNLOAD", 2);
            iMms.downloadMessage(this.getSubId(), ActivityThread.currentPackageName(), locationUrl, contentUri, configOverrides, downloadedIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$updateMmsSendStatus(Context context, int messageRef, byte[] pdu, int status, Uri contentUri) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.updateMmsSendStatus(messageRef, pdu, status);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (contentUri != null) {
            context.revokeUriPermission(contentUri, 1);
        }
    }

    private final void $$robo$$android_telephony_SmsManager$updateMmsDownloadStatus(Context context, int messageRef, int status, Uri contentUri) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.updateMmsDownloadStatus(messageRef, status);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (contentUri != null) {
            context.revokeUriPermission(contentUri, 2);
        }
    }

    private final Uri $$robo$$android_telephony_SmsManager$importTextMessage(String address, int type, String text, long timestampMillis, boolean seen, boolean read) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.importTextMessage(ActivityThread.currentPackageName(), address, type, text, timestampMillis, seen, read);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final Uri $$robo$$android_telephony_SmsManager$importMultimediaMessage(Uri contentUri, String messageId, long timestampSecs, boolean seen, boolean read) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.importMultimediaMessage(ActivityThread.currentPackageName(), contentUri, messageId, timestampSecs, seen, read);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final boolean $$robo$$android_telephony_SmsManager$deleteStoredMessage(Uri messageUri) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.deleteStoredMessage(ActivityThread.currentPackageName(), messageUri);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_SmsManager$deleteStoredConversation(long conversationId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.deleteStoredConversation(ActivityThread.currentPackageName(), conversationId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_SmsManager$updateStoredMessageStatus(Uri messageUri, ContentValues statusValues) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.updateStoredMessageStatus(ActivityThread.currentPackageName(), messageUri, statusValues);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_SmsManager$archiveStoredConversation(long conversationId, boolean archived) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.archiveStoredConversation(ActivityThread.currentPackageName(), conversationId, archived);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final Uri $$robo$$android_telephony_SmsManager$addTextMessageDraft(String address, String text) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.addTextMessageDraft(ActivityThread.currentPackageName(), address, text);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final Uri $$robo$$android_telephony_SmsManager$addMultimediaMessageDraft(Uri contentUri) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.addMultimediaMessageDraft(ActivityThread.currentPackageName(), contentUri);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final void $$robo$$android_telephony_SmsManager$sendStoredTextMessage(Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendStoredText(this.getSubId(), ActivityThread.currentPackageName(), messageUri, scAddress, sentIntent, deliveryIntent);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$sendStoredMultipartTextMessage(Uri messageUri, String scAddress, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendStoredMultipartText(this.getSubId(), ActivityThread.currentPackageName(), messageUri, scAddress, sentIntents, deliveryIntents);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$sendStoredMultimediaMessage(Uri messageUri, Bundle configOverrides, PendingIntent sentIntent) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                iMms.sendStoredMessage(this.getSubId(), ActivityThread.currentPackageName(), messageUri, configOverrides, sentIntent);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SmsManager$setAutoPersisting(boolean enabled) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                iMms.setAutoPersisting(ActivityThread.currentPackageName(), enabled);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_telephony_SmsManager$getAutoPersisting() {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.getAutoPersisting();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final Bundle $$robo$$android_telephony_SmsManager$getCarrierConfigValues() {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.getCarrierConfigValues(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    static void __staticInitializer__() {
        sInstance = new SmsManager(-1002L);
        sLockObject = new Object();
        sSubInstances = new ArrayMap<Long, SmsManager>();
    }

    public void sendTextMessage(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendTextMessage", $$robo$$android_telephony_SmsManager$sendTextMessage(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, string4, pendingIntent, pendingIntent2);
    }

    public void injectSmsPdu(byte[] byArray, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$android_telephony_SmsManager$injectSmsPdu(byte[] java.lang.String android.app.PendingIntent ), 0, this, byArray, string2, pendingIntent);
    }

    public void updateSmsSendStatus(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateSmsSendStatus", $$robo$$android_telephony_SmsManager$updateSmsSendStatus(int boolean ), 0, this, n, bl);
    }

    public ArrayList<String> divideMessage(String string2) {
        return InvokeDynamicSupport.bootstrap("divideMessage", $$robo$$android_telephony_SmsManager$divideMessage(java.lang.String ), 0, this, string2);
    }

    public void sendMultipartTextMessage(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        InvokeDynamicSupport.bootstrap("sendMultipartTextMessage", $$robo$$android_telephony_SmsManager$sendMultipartTextMessage(java.lang.String java.lang.String java.util.ArrayList<java.lang.String> java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> ), 0, this, string2, string3, arrayList, arrayList2, arrayList3);
    }

    public void sendDataMessage(String string2, String string3, short s, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendDataMessage", $$robo$$android_telephony_SmsManager$sendDataMessage(java.lang.String java.lang.String short byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, s, byArray, pendingIntent, pendingIntent2);
    }

    public static SmsManager getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_telephony_SmsManager$getDefault(), 0);
    }

    public static SmsManager getSmsManagerForSubscriber(long l) {
        return InvokeDynamicSupport.bootstrapStatic("getSmsManagerForSubscriber", $$robo$$android_telephony_SmsManager$getSmsManagerForSubscriber(long ), 0, (long)l);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_telephony_SmsManager$__constructor__(l);
    }

    private SmsManager(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SmsManager$__constructor__(long ), 0, this, l);
    }

    public long getSubId() {
        return (long)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$android_telephony_SmsManager$getSubId(), 0, this);
    }

    private static ISms getISmsServiceOrThrow() {
        return InvokeDynamicSupport.bootstrapStatic("getISmsServiceOrThrow", $$robo$$android_telephony_SmsManager$getISmsServiceOrThrow(), 0);
    }

    private static ISms getISmsService() {
        return InvokeDynamicSupport.bootstrapStatic("getISmsService", $$robo$$android_telephony_SmsManager$getISmsService(), 0);
    }

    public boolean copyMessageToIcc(byte[] byArray, byte[] byArray2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("copyMessageToIcc", $$robo$$android_telephony_SmsManager$copyMessageToIcc(byte[] byte[] int ), 0, this, byArray, byArray2, n);
    }

    public boolean deleteMessageFromIcc(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteMessageFromIcc", $$robo$$android_telephony_SmsManager$deleteMessageFromIcc(int ), 0, this, n);
    }

    public boolean updateMessageOnIcc(int n, int n2, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateMessageOnIcc", $$robo$$android_telephony_SmsManager$updateMessageOnIcc(int int byte[] ), 0, this, n, n2, byArray);
    }

    public static ArrayList<SmsMessage> getAllMessagesFromIcc() {
        return InvokeDynamicSupport.bootstrapStatic("getAllMessagesFromIcc", $$robo$$android_telephony_SmsManager$getAllMessagesFromIcc(), 0);
    }

    public boolean enableCellBroadcast(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableCellBroadcast", $$robo$$android_telephony_SmsManager$enableCellBroadcast(int ), 0, this, n);
    }

    public boolean disableCellBroadcast(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableCellBroadcast", $$robo$$android_telephony_SmsManager$disableCellBroadcast(int ), 0, this, n);
    }

    public boolean enableCellBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableCellBroadcastRange", $$robo$$android_telephony_SmsManager$enableCellBroadcastRange(int int ), 0, this, n, n2);
    }

    public boolean disableCellBroadcastRange(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableCellBroadcastRange", $$robo$$android_telephony_SmsManager$disableCellBroadcastRange(int int ), 0, this, n, n2);
    }

    private static ArrayList<SmsMessage> createMessageListFromRawRecords(List<SmsRawData> list) {
        return InvokeDynamicSupport.bootstrapStatic("createMessageListFromRawRecords", $$robo$$android_telephony_SmsManager$createMessageListFromRawRecords(java.util.List<com.android.internal.telephony.SmsRawData> ), 0, list);
    }

    public boolean isImsSmsSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsSmsSupported", $$robo$$android_telephony_SmsManager$isImsSmsSupported(), 0, this);
    }

    public String getImsSmsFormat() {
        return InvokeDynamicSupport.bootstrap("getImsSmsFormat", $$robo$$android_telephony_SmsManager$getImsSmsFormat(), 0, this);
    }

    public static long getDefaultSmsSubId() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultSmsSubId", $$robo$$android_telephony_SmsManager$getDefaultSmsSubId(), 0);
    }

    public boolean isSMSPromptEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSMSPromptEnabled", $$robo$$android_telephony_SmsManager$isSMSPromptEnabled(), 0, this);
    }

    public void sendMultimediaMessage(Context context, Uri uri, String string2, Bundle bundle, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("sendMultimediaMessage", $$robo$$android_telephony_SmsManager$sendMultimediaMessage(android.content.Context android.net.Uri java.lang.String android.os.Bundle android.app.PendingIntent ), 0, this, context, uri, string2, bundle, pendingIntent);
    }

    private void grantCarrierPackageUriPermission(Context context, Uri uri, String string2, int n) {
        InvokeDynamicSupport.bootstrap("grantCarrierPackageUriPermission", $$robo$$android_telephony_SmsManager$grantCarrierPackageUriPermission(android.content.Context android.net.Uri java.lang.String int ), 0, this, context, uri, string2, n);
    }

    public void downloadMultimediaMessage(Context context, String string2, Uri uri, Bundle bundle, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("downloadMultimediaMessage", $$robo$$android_telephony_SmsManager$downloadMultimediaMessage(android.content.Context java.lang.String android.net.Uri android.os.Bundle android.app.PendingIntent ), 0, this, context, string2, uri, bundle, pendingIntent);
    }

    public void updateMmsSendStatus(Context context, int n, byte[] byArray, int n2, Uri uri) {
        InvokeDynamicSupport.bootstrap("updateMmsSendStatus", $$robo$$android_telephony_SmsManager$updateMmsSendStatus(android.content.Context int byte[] int android.net.Uri ), 0, this, context, n, byArray, n2, uri);
    }

    public void updateMmsDownloadStatus(Context context, int n, int n2, Uri uri) {
        InvokeDynamicSupport.bootstrap("updateMmsDownloadStatus", $$robo$$android_telephony_SmsManager$updateMmsDownloadStatus(android.content.Context int int android.net.Uri ), 0, this, context, n, n2, uri);
    }

    public Uri importTextMessage(String string2, int n, String string3, long l, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("importTextMessage", $$robo$$android_telephony_SmsManager$importTextMessage(java.lang.String int java.lang.String long boolean boolean ), 0, this, string2, n, string3, l, bl, bl2);
    }

    public Uri importMultimediaMessage(Uri uri, String string2, long l, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("importMultimediaMessage", $$robo$$android_telephony_SmsManager$importMultimediaMessage(android.net.Uri java.lang.String long boolean boolean ), 0, this, uri, string2, l, bl, bl2);
    }

    public boolean deleteStoredMessage(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteStoredMessage", $$robo$$android_telephony_SmsManager$deleteStoredMessage(android.net.Uri ), 0, this, uri);
    }

    public boolean deleteStoredConversation(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteStoredConversation", $$robo$$android_telephony_SmsManager$deleteStoredConversation(long ), 0, this, l);
    }

    public boolean updateStoredMessageStatus(Uri uri, ContentValues contentValues) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateStoredMessageStatus", $$robo$$android_telephony_SmsManager$updateStoredMessageStatus(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    public boolean archiveStoredConversation(long l, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("archiveStoredConversation", $$robo$$android_telephony_SmsManager$archiveStoredConversation(long boolean ), 0, this, l, bl);
    }

    public Uri addTextMessageDraft(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("addTextMessageDraft", $$robo$$android_telephony_SmsManager$addTextMessageDraft(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public Uri addMultimediaMessageDraft(Uri uri) {
        return InvokeDynamicSupport.bootstrap("addMultimediaMessageDraft", $$robo$$android_telephony_SmsManager$addMultimediaMessageDraft(android.net.Uri ), 0, this, uri);
    }

    public void sendStoredTextMessage(Uri uri, String string2, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendStoredTextMessage", $$robo$$android_telephony_SmsManager$sendStoredTextMessage(android.net.Uri java.lang.String android.app.PendingIntent android.app.PendingIntent ), 0, this, uri, string2, pendingIntent, pendingIntent2);
    }

    public void sendStoredMultipartTextMessage(Uri uri, String string2, ArrayList<PendingIntent> arrayList, ArrayList<PendingIntent> arrayList2) {
        InvokeDynamicSupport.bootstrap("sendStoredMultipartTextMessage", $$robo$$android_telephony_SmsManager$sendStoredMultipartTextMessage(android.net.Uri java.lang.String java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> ), 0, this, uri, string2, arrayList, arrayList2);
    }

    public void sendStoredMultimediaMessage(Uri uri, Bundle bundle, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("sendStoredMultimediaMessage", $$robo$$android_telephony_SmsManager$sendStoredMultimediaMessage(android.net.Uri android.os.Bundle android.app.PendingIntent ), 0, this, uri, bundle, pendingIntent);
    }

    public void setAutoPersisting(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoPersisting", $$robo$$android_telephony_SmsManager$setAutoPersisting(boolean ), 0, this, bl);
    }

    public boolean getAutoPersisting() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAutoPersisting", $$robo$$android_telephony_SmsManager$getAutoPersisting(), 0, this);
    }

    public Bundle getCarrierConfigValues() {
        return InvokeDynamicSupport.bootstrap("getCarrierConfigValues", $$robo$$android_telephony_SmsManager$getCarrierConfigValues(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SmsManager.class);
    }

    public /* synthetic */ SmsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

