/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.BaseColumns;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.ISub;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionManager
implements BaseColumns,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SUB";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static int INVALID_PHONE_ID = -1000;
    public static int DEFAULT_PHONE_ID = Integer.MAX_VALUE;
    public static int INVALID_SLOT_ID = -1000;
    public static int DEFAULT_SLOT_ID = Integer.MAX_VALUE;
    public static long ASK_USER_SUB_ID = -1001L;
    public static long INVALID_SUB_ID = -1000L;
    public static long DEFAULT_SUB_ID = Long.MAX_VALUE;
    public static Uri CONTENT_URI;
    public static int DEFAULT_INT_VALUE = -100;
    public static String DEFAULT_STRING_VALUE = "N/A";
    public static int EXTRA_VALUE_NEW_SIM = 1;
    public static int EXTRA_VALUE_REMOVE_SIM = 2;
    public static int EXTRA_VALUE_REPOSITION_SIM = 3;
    public static int EXTRA_VALUE_NOCHANGE = 4;
    public static String INTENT_KEY_DETECT_STATUS = "simDetectStatus";
    public static String INTENT_KEY_SIM_COUNT = "simCount";
    public static String INTENT_KEY_NEW_SIM_SLOT = "newSIMSlot";
    public static String INTENT_KEY_NEW_SIM_STATUS = "newSIMStatus";
    public static String ICC_ID = "icc_id";
    public static String SIM_ID = "sim_id";
    public static int SIM_NOT_INSERTED = -1;
    public static String DISPLAY_NAME = "display_name";
    public static int DEFAULT_NAME_RES = 17039374;
    public static String NAME_SOURCE = "name_source";
    public static int NAME_SOURCE_UNDEFINDED = -1;
    public static int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static int NAME_SOURCE_SIM_SOURCE = 1;
    public static int NAME_SOURCE_USER_INPUT = 2;
    public static String COLOR = "color";
    public static int COLOR_1 = 0;
    public static int COLOR_2 = 1;
    public static int COLOR_3 = 2;
    public static int COLOR_4 = 3;
    public static int COLOR_DEFAULT = 0;
    public static String NUMBER = "number";
    public static String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static int DISPLAY_NUMBER_NONE = 0;
    public static int DISPLAY_NUMBER_FIRST = 1;
    public static int DISPLAY_NUMBER_LAST = 2;
    public static int DISLPAY_NUMBER_DEFAULT = 1;
    public static String DATA_ROAMING = "data_roaming";
    public static int DATA_ROAMING_ENABLE = 1;
    public static int DATA_ROAMING_DISABLE = 0;
    public static int DATA_ROAMING_DEFAULT = 0;
    public static String MCC = "mcc";
    public static String MNC = "mnc";
    private static int RES_TYPE_BACKGROUND_DARK = 0;
    private static int RES_TYPE_BACKGROUND_LIGHT = 1;
    private static int[] sSimBackgroundDarkRes;
    public static String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";

    private void $$robo$$android_telephony_SubscriptionManager$__constructor__() {
        SubscriptionManager.logd("SubscriptionManager created");
    }

    private static final SubInfoRecord $$robo$$android_telephony_SubscriptionManager$getSubInfoForSubscriber(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getSubInfoForSubscriberx]- invalid subId");
            return null;
        }
        SubInfoRecord subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getSubInfoForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    private static final List<SubInfoRecord> $$robo$$android_telephony_SubscriptionManager$getSubInfoUsingIccId(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getSubInfoUsingIccId]- null iccid");
            return null;
        }
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSubInfoUsingIccId(iccId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static final List<SubInfoRecord> $$robo$$android_telephony_SubscriptionManager$getSubInfoUsingSlotId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubInfoUsingSlotId]- invalid slotId");
            return null;
        }
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSubInfoUsingSlotId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static final List<SubInfoRecord> $$robo$$android_telephony_SubscriptionManager$getAllSubInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static final List<SubInfoRecord> $$robo$$android_telephony_SubscriptionManager$getActiveSubInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getAllSubInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getActiveSubInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final Uri $$robo$$android_telephony_SubscriptionManager$addSubInfoRecord(String iccId, int slotId) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[addSubInfoRecord]- invalid slotId");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setColor(int color2, long subId) {
        int size = sSimBackgroundDarkRes.length;
        if (!SubscriptionManager.isValidSubId(subId) || color2 < 0 || color2 >= size) {
            SubscriptionManager.logd("[setColor]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setColor(color2, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, long subId) {
        return SubscriptionManager.setDisplayName(displayName, subId, -1L);
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, long subId, long nameSource) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(String number, long subId) {
        if (number == null || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setDisplayNumberFormat(int format, long subId) {
        if (format < 0 || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDisplayNumberFormat]- fail, return -1");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumberFormat(format, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int roaming, long subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getSlotId(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getSlotId]- fail");
        }
        int result = -1000;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final long[] $$robo$$android_telephony_SubscriptionManager$getSubId(int slotId) {
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        long[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getPhoneId(long subId) {
        if (!SubscriptionManager.isValidSubId(subId)) {
            SubscriptionManager.logd("[getPhoneId]- fail");
            return -1000;
        }
        int result = -1000;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int[] $$robo$$android_telephony_SubscriptionManager$setSimResource(int type) {
        int[] simResource = null;
        switch (type) {
            case 0: {
                simResource = new int[]{17303045, 17303047, 17303046, 17303048};
                break;
            }
            case 1: {
                simResource = new int[]{17303049, 17303051, 17303050, 17303052};
            }
        }
        return simResource;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$logd(String msg) {
        Rlog.d("SUB", "[SubManager] " + msg);
    }

    private static final long $$robo$$android_telephony_SubscriptionManager$getDefaultSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final long $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final SubInfoRecord $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultVoiceSubId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubId());
    }

    private static final long $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final SubInfoRecord $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultSmsSubId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubId());
    }

    private static final long $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubId() {
        long subId = -1000L;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(long subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final SubInfoRecord $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubInfo() {
        return SubscriptionManager.getSubInfoForSubscriber(SubscriptionManager.getDefaultDataSubId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubId());
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$clearSubInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected() {
        if (SubscriptionManager.getDefaultDataSubId() == -1000L) {
            return false;
        }
        if (SubscriptionManager.getDefaultSmsSubId() == -1000L) {
            return false;
        }
        return SubscriptionManager.getDefaultVoiceSubId() != -1000L;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSubId(long subId) {
        return subId > -1000L;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSlotId(int slotId) {
        return slotId != -1000 && slotId >= 0 && slotId < TelephonyManager.getDefault().getSimCount();
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int phoneId) {
        return phoneId != -1000 && phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        long[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId, long subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    private static final long[] $$robo$$android_telephony_SubscriptionManager$getActiveSubIdList() {
        long[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new long[]{};
        }
        return subId;
    }

    static void __staticInitializer__() {
        CONTENT_URI = Uri.parse("content://telephony/siminfo");
        sSimBackgroundDarkRes = SubscriptionManager.setSimResource(0);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_SubscriptionManager$__constructor__();
    }

    public SubscriptionManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager$__constructor__(), 0, this);
    }

    public static SubInfoRecord getSubInfoForSubscriber(long l) {
        return InvokeDynamicSupport.bootstrapStatic("getSubInfoForSubscriber", $$robo$$android_telephony_SubscriptionManager$getSubInfoForSubscriber(long ), 0, (long)l);
    }

    public static List<SubInfoRecord> getSubInfoUsingIccId(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSubInfoUsingIccId", $$robo$$android_telephony_SubscriptionManager$getSubInfoUsingIccId(java.lang.String ), 0, (String)string2);
    }

    public static List<SubInfoRecord> getSubInfoUsingSlotId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSubInfoUsingSlotId", $$robo$$android_telephony_SubscriptionManager$getSubInfoUsingSlotId(int ), 0, (int)n);
    }

    public static List<SubInfoRecord> getAllSubInfoList() {
        return InvokeDynamicSupport.bootstrapStatic("getAllSubInfoList", $$robo$$android_telephony_SubscriptionManager$getAllSubInfoList(), 0);
    }

    public static List<SubInfoRecord> getActiveSubInfoList() {
        return InvokeDynamicSupport.bootstrapStatic("getActiveSubInfoList", $$robo$$android_telephony_SubscriptionManager$getActiveSubInfoList(), 0);
    }

    public static int getAllSubInfoCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAllSubInfoCount", $$robo$$android_telephony_SubscriptionManager$getAllSubInfoCount(), 0);
    }

    public static int getActiveSubInfoCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getActiveSubInfoCount", $$robo$$android_telephony_SubscriptionManager$getActiveSubInfoCount(), 0);
    }

    public static Uri addSubInfoRecord(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("addSubInfoRecord", $$robo$$android_telephony_SubscriptionManager$addSubInfoRecord(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int setColor(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setColor", $$robo$$android_telephony_SubscriptionManager$setColor(int long ), 0, (int)n, (long)l);
    }

    public static int setDisplayName(String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String long ), 0, (String)string2, (long)l);
    }

    public static int setDisplayName(String string2, long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String long long ), 0, (String)string2, (long)l, (long)l2);
    }

    public static int setDisplayNumber(String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDisplayNumber", $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(java.lang.String long ), 0, (String)string2, (long)l);
    }

    public static int setDisplayNumberFormat(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDisplayNumberFormat", $$robo$$android_telephony_SubscriptionManager$setDisplayNumberFormat(int long ), 0, (int)n, (long)l);
    }

    public static int setDataRoaming(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setDataRoaming", $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int long ), 0, (int)n, (long)l);
    }

    public static int getSlotId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSlotId", $$robo$$android_telephony_SubscriptionManager$getSlotId(long ), 0, (long)l);
    }

    public static long[] getSubId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSubId", $$robo$$android_telephony_SubscriptionManager$getSubId(int ), 0, (int)n);
    }

    public static int getPhoneId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPhoneId", $$robo$$android_telephony_SubscriptionManager$getPhoneId(long ), 0, (long)l);
    }

    private static int[] setSimResource(int n) {
        return InvokeDynamicSupport.bootstrapStatic("setSimResource", $$robo$$android_telephony_SubscriptionManager$setSimResource(int ), 0, (int)n);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_telephony_SubscriptionManager$logd(java.lang.String ), 0, (String)string2);
    }

    public static long getDefaultSubId() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultSubId", $$robo$$android_telephony_SubscriptionManager$getDefaultSubId(), 0);
    }

    public static long getDefaultVoiceSubId() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultVoiceSubId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubId(), 0);
    }

    public static void setDefaultVoiceSubId(long l) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultVoiceSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(long ), 0, (long)l);
    }

    public static SubInfoRecord getDefaultVoiceSubInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultVoiceSubInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubInfo(), 0);
    }

    public static int getDefaultVoicePhoneId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoicePhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId(), 0);
    }

    public static long getDefaultSmsSubId() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultSmsSubId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubId(), 0);
    }

    public static void setDefaultSmsSubId(long l) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultSmsSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(long ), 0, (long)l);
    }

    public static SubInfoRecord getDefaultSmsSubInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSmsSubInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubInfo(), 0);
    }

    public static int getDefaultSmsPhoneId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSmsPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId(), 0);
    }

    public static long getDefaultDataSubId() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultDataSubId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubId(), 0);
    }

    public static void setDefaultDataSubId(long l) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultDataSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(long ), 0, (long)l);
    }

    public static SubInfoRecord getDefaultDataSubInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultDataSubInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubInfo(), 0);
    }

    public static int getDefaultDataPhoneId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultDataPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId(), 0);
    }

    public static void clearSubInfo() {
        InvokeDynamicSupport.bootstrapStatic("clearSubInfo", $$robo$$android_telephony_SubscriptionManager$clearSubInfo(), 0);
    }

    public static boolean allDefaultsSelected() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("allDefaultsSelected", $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected(), 0);
    }

    public static void clearDefaultsForInactiveSubIds() {
        InvokeDynamicSupport.bootstrapStatic("clearDefaultsForInactiveSubIds", $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds(), 0);
    }

    public static boolean isValidSubId(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSubId", $$robo$$android_telephony_SubscriptionManager$isValidSubId(long ), 0, (long)l);
    }

    public static boolean isValidSlotId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSlotId", $$robo$$android_telephony_SubscriptionManager$isValidSlotId(int ), 0, (int)n);
    }

    public static boolean isValidPhoneId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidPhoneId", $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int ), 0, (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int ), 0, (Intent)intent, (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int long ), 0, (Intent)intent, (int)n, (long)l);
    }

    public static long[] getActiveSubIdList() {
        return InvokeDynamicSupport.bootstrapStatic("getActiveSubIdList", $$robo$$android_telephony_SubscriptionManager$getActiveSubIdList(), 0);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

