/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstants;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TelephonyManager";
    private static ITelephonyRegistry sRegistry;
    private Context mContext;
    private static String multiSimConfig;
    private static TelephonyManager sInstance;
    public static String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static String EXTRA_STATE = "state";
    public static String EXTRA_STATE_IDLE;
    public static String EXTRA_STATE_RINGING;
    public static String EXTRA_STATE_OFFHOOK;
    public static String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    public static String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static String EXTRA_DATA_STATE = "state";
    public static String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static String EXTRA_DATA_APN_TYPE = "apnType";
    public static String EXTRA_DATA_APN = "apn";
    public static String EXTRA_DATA_CHANGE_REASON = "reason";
    public static String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static int PHONE_TYPE_NONE = 0;
    public static int PHONE_TYPE_GSM = 1;
    public static int PHONE_TYPE_CDMA = 2;
    public static int PHONE_TYPE_SIP = 3;
    private static String sKernelCmdLine;
    private static Pattern sProductTypePattern;
    private static String sLteOnCdmaProductType;
    public static int NETWORK_TYPE_UNKNOWN = 0;
    public static int NETWORK_TYPE_GPRS = 1;
    public static int NETWORK_TYPE_EDGE = 2;
    public static int NETWORK_TYPE_UMTS = 3;
    public static int NETWORK_TYPE_CDMA = 4;
    public static int NETWORK_TYPE_EVDO_0 = 5;
    public static int NETWORK_TYPE_EVDO_A = 6;
    public static int NETWORK_TYPE_1xRTT = 7;
    public static int NETWORK_TYPE_HSDPA = 8;
    public static int NETWORK_TYPE_HSUPA = 9;
    public static int NETWORK_TYPE_HSPA = 10;
    public static int NETWORK_TYPE_IDEN = 11;
    public static int NETWORK_TYPE_EVDO_B = 12;
    public static int NETWORK_TYPE_LTE = 13;
    public static int NETWORK_TYPE_EHRPD = 14;
    public static int NETWORK_TYPE_HSPAP = 15;
    public static int NETWORK_TYPE_GSM = 16;
    public static int NETWORK_CLASS_UNKNOWN = 0;
    public static int NETWORK_CLASS_2_G = 1;
    public static int NETWORK_CLASS_3_G = 2;
    public static int NETWORK_CLASS_4_G = 3;
    public static int SIM_STATE_UNKNOWN = 0;
    public static int SIM_STATE_ABSENT = 1;
    public static int SIM_STATE_PIN_REQUIRED = 2;
    public static int SIM_STATE_PUK_REQUIRED = 3;
    public static int SIM_STATE_NETWORK_LOCKED = 4;
    public static int SIM_STATE_READY = 5;
    public static int SIM_STATE_CARD_IO_ERROR = 6;
    public static int CALL_STATE_IDLE = 0;
    public static int CALL_STATE_RINGING = 1;
    public static int CALL_STATE_OFFHOOK = 2;
    public static int DATA_ACTIVITY_NONE = 0;
    public static int DATA_ACTIVITY_IN = 1;
    public static int DATA_ACTIVITY_OUT = 2;
    public static int DATA_ACTIVITY_INOUT = 3;
    public static int DATA_ACTIVITY_DORMANT = 4;
    public static int DATA_UNKNOWN = -1;
    public static int DATA_DISCONNECTED = 0;
    public static int DATA_CONNECTING = 1;
    public static int DATA_CONNECTED = 2;
    public static int DATA_SUSPENDED = 3;
    public static int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;

    private void $$robo$$android_telephony_TelephonyManager$__constructor__(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private void $$robo$$android_telephony_TelephonyManager$__constructor__() {
        this.mContext = null;
    }

    private static final TelephonyManager $$robo$$android_telephony_TelephonyManager$getDefault() {
        return sInstance;
    }

    private final MultiSimVariants $$robo$$android_telephony_TelephonyManager$getMultiSimConfiguration() {
        String mSimConfig = SystemProperties.get("persist.radio.multisim.config");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneCount() {
        int phoneCount = 1;
        switch (1.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[this.getMultiSimConfiguration().ordinal()]) {
            case 1: 
            case 2: {
                phoneCount = 2;
                break;
            }
            case 3: {
                phoneCount = 3;
            }
        }
        return phoneCount;
    }

    private static final TelephonyManager $$robo$$android_telephony_TelephonyManager$from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion() {
        try {
            return this.getSubscriberInfo().getDeviceSvn();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getDeviceId() {
        return this.getDeviceId(this.getDefaultSim());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getDeviceId(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        try {
            return this.getSubscriberInfo().getDeviceIdForSubscriber(subId[0]);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getImei() {
        return this.getImei(this.getDefaultSim());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getImei(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        try {
            return this.getSubscriberInfo().getImeiForSubscriber(subId[0]);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final CellLocation $$robo$$android_telephony_TelephonyManager$getCellLocation() {
        try {
            Bundle bundle = this.getITelephony().getCellLocation();
            if (bundle.isEmpty()) {
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableLocationUpdates() {
        this.enableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(long subId) {
        try {
            this.getITelephony().enableLocationUpdatesForSubscriber(subId);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$disableLocationUpdates() {
        this.disableLocationUpdates(TelephonyManager.getDefaultSubscription());
    }

    private final void $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(long subId) {
        try {
            this.getITelephony().disableLocationUpdatesForSubscriber(subId);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final List<NeighboringCellInfo> $$robo$$android_telephony_TelephonyManager$getNeighboringCellInfo() {
        try {
            return this.getITelephony().getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType() {
        return this.getCurrentPhoneType(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSubscriber(subId);
            }
            return this.getPhoneTypeFromProperty(subId);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(subId);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(subId);
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(long subId) {
        String type = TelephonyManager.getTelephonyProperty("gsm.current.phone-type", subId, null);
        if (type != null) {
            return Integer.parseInt(type);
        }
        return this.getPhoneTypeFromNetworkType(subId);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(long subId) {
        String mode = TelephonyManager.getTelephonyProperty("ro.telephony.default_network", subId, null);
        if (mode != null) {
            return TelephonyManager.getPhoneType(Integer.parseInt(mode));
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_telephony_TelephonyManager$getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d("TelephonyManager", "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d("TelephonyManager", "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d("TelephonyManager", "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName() {
        return this.getNetworkOperatorName(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.alpha", subId, "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperator() {
        return this.getNetworkOperator(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperator(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.numeric", subId, "");
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isNetworkRoaming() {
        return this.isNetworkRoaming(TelephonyManager.getDefaultSubscription());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(long subId) {
        return "true".equals(TelephonyManager.getTelephonyProperty("gsm.operator.isroaming", subId, null));
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso() {
        return this.getNetworkCountryIso(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.operator.iso-country", subId, "");
    }

    private final int $$robo$$android_telephony_TelephonyManager$getNetworkType() {
        return this.getDataNetworkType();
    }

    private final int $$robo$$android_telephony_TelephonyManager$getNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataNetworkType() {
        return this.getDataNetworkType(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType() {
        return this.getVoiceNetworkType(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(long subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId);
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    private static final String $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
        }
        return "UNKNOWN";
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasIccCard() {
        return this.hasIccCard(this.getDefaultSim());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasIccCard(long slotId) {
        try {
            return this.getITelephony().hasIccCardUsingSlotId(slotId);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimState() {
        return this.getSimState(this.getDefaultSim());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimState(int slotId) {
        long[] subId = SubscriptionManager.getSubId(slotId);
        if (subId == null) {
            return 1;
        }
        String prop = TelephonyManager.getTelephonyProperty("gsm.sim.state", subId[0], "");
        if ("ABSENT".equals(prop)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(prop)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(prop)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(prop)) {
            return 4;
        }
        if ("READY".equals(prop)) {
            return 5;
        }
        if ("CARD_IO_ERROR".equals(prop)) {
            return 6;
        }
        return 0;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperator() {
        long subId = TelephonyManager.getDefaultSubscription();
        Rlog.d("TelephonyManager", "getSimOperator(): default subId=" + subId);
        return this.getSimOperator(subId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperator(long subId) {
        String operator = TelephonyManager.getTelephonyProperty("gsm.sim.operator.numeric", subId, "");
        Rlog.d("TelephonyManager", "getSimOperator: subId=" + subId + " operator=" + operator);
        return operator;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorName() {
        return this.getSimOperatorName(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorName(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.alpha", subId, "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimCountryIso() {
        return this.getSimCountryIso(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimCountryIso(long subId) {
        return TelephonyManager.getTelephonyProperty("gsm.sim.operator.iso-country", subId, "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimSerialNumber() {
        return this.getSimSerialNumber(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(long subId) {
        try {
            return this.getSubscriberInfo().getIccSerialNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(long subId) {
        try {
            return this.getITelephony().getLteOnCdmaModeForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSubscriberId() {
        return this.getSubscriberId(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSubscriberId(long subId) {
        try {
            return this.getSubscriberInfo().getSubscriberIdForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1() {
        try {
            return this.getSubscriberInfo().getGroupIdLevel1();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(long subId) {
        try {
            return this.getSubscriberInfo().getGroupIdLevel1ForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1Number() {
        return this.getLine1NumberForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1NumberForSubscriber(long subId) {
        String number = null;
        try {
            number = this.getITelephony().getLine1NumberForDisplay(subId);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            return this.getSubscriberInfo().getLine1NumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(String alphaTag, String number) {
        this.setLine1NumberForDisplayForSubscriber(TelephonyManager.getDefaultSubscription(), alphaTag, number);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplayForSubscriber(long subId, String alphaTag, String number) {
        try {
            this.getITelephony().setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag() {
        return this.getLine1AlphaTagForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1AlphaTagForSubscriber(long subId) {
        String alphaTag = null;
        try {
            alphaTag = this.getITelephony().getLine1AlphaTagForDisplay(subId);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            return this.getSubscriberInfo().getLine1AlphaTagForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMsisdn() {
        return this.getMsisdn(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMsisdn(long subId) {
        try {
            return this.getSubscriberInfo().getMsisdnForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber() {
        return this.getVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(long subId) {
        try {
            return this.getSubscriberInfo().getVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(long subId) {
        try {
            return this.getSubscriberInfo().getCompleteVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount() {
        return this.getVoiceMessageCount(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(long subId) {
        try {
            return this.getITelephony().getVoiceMessageCountForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(long subId) {
        try {
            return this.getSubscriberInfo().getVoiceMailAlphaTagForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimImpi() {
        try {
            return this.getSubscriberInfo().getIsimImpi();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimDomain() {
        try {
            return this.getSubscriberInfo().getIsimDomain();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getIsimImpu() {
        try {
            return this.getSubscriberInfo().getIsimImpu();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final IPhoneSubInfo $$robo$$android_telephony_TelephonyManager$getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCallState() {
        try {
            return this.getTelecomService().getCallState();
        }
        catch (RemoteException | NullPointerException e) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCallState(long subId) {
        try {
            return this.getITelephony().getCallStateForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataActivity() {
        try {
            return this.getITelephony().getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataState() {
        try {
            return this.getITelephony().getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final ITelephony $$robo$$android_telephony_TelephonyManager$getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private final ITelecomService $$robo$$android_telephony_TelephonyManager$getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    private final void $$robo$$android_telephony_TelephonyManager$listen(PhoneStateListener listener, int events) {
        String pkgForDebug = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            Boolean notifyNow = this.getITelephony() != null;
            sRegistry.listenForSubscriber(listener.mSubId, pkgForDebug, listener.callback, events, notifyNow);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(long subId) {
        try {
            return this.getITelephony().getCdmaEriIconIndexForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(TelephonyManager.getDefaultSubscription());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(long subId) {
        try {
            return this.getITelephony().getCdmaEriIconModeForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaEriText() {
        return this.getCdmaEriText(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaEriText(long subId) {
        try {
            return this.getITelephony().getCdmaEriTextForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956931);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956932);
    }

    private final List<CellInfo> $$robo$$android_telephony_TelephonyManager$getAllCellInfo() {
        try {
            return this.getITelephony().getAllCellInfo();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setCellInfoListRate(int rateInMillis) {
        try {
            this.getITelephony().setCellInfoListRate(rateInMillis);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039409);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039410);
    }

    private final IccOpenLogicalChannelResponse $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(String AID) {
        try {
            return this.getITelephony().iccOpenLogicalChannel(AID);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int channel) {
        try {
            return this.getITelephony().iccCloseLogicalChannel(channel);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            return this.getITelephony().iccTransmitApduLogicalChannel(channel, cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            return this.getITelephony().iccTransmitApduBasicChannel(cla, instruction, p1, p2, p3, data);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final byte[] $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            return this.getITelephony().iccExchangeSimIO(fileID, command, p1, p2, p3, filePath);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(String content) {
        try {
            return this.getITelephony().sendEnvelopeWithStatus(content);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final String $$robo$$android_telephony_TelephonyManager$nvReadItem(int itemID) {
        try {
            return this.getITelephony().nvReadItem(itemID);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvReadItem NPE", ex);
        }
        return "";
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvWriteItem(int itemID, String itemValue) {
        try {
            return this.getITelephony().nvWriteItem(itemID, itemValue);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvWriteItem NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            return this.getITelephony().nvWriteCdmaPrl(preferredRoamingList);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvResetConfig(int resetType) {
        try {
            return this.getITelephony().nvResetConfig(resetType);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvResetConfig NPE", ex);
        }
        return false;
    }

    private static final long $$robo$$android_telephony_TelephonyManager$getDefaultSubscription() {
        return SubscriptionManager.getDefaultSubId();
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDefaultSim() {
        return 0;
    }

    private static final void $$robo$$android_telephony_TelephonyManager$setTelephonyProperty(String property, long subId, String value) {
        int i;
        String propVal = "";
        String[] p = null;
        String prop = SystemProperties.get(property);
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (value == null) {
            value = "";
        }
        if (prop != null) {
            p = prop.split(",");
        }
        if (phoneId < 0) {
            return;
        }
        for (i = 0; i < phoneId; ++i) {
            String str = "";
            if (p != null && i < p.length) {
                str = p[i];
            }
            propVal = propVal + str + ",";
        }
        propVal = propVal + value;
        if (p != null) {
            for (i = phoneId + 1; i < p.length; ++i) {
                propVal = propVal + "," + p[i];
            }
        }
        if (property.length() > 31 || propVal.length() > 91) {
            Rlog.d("TelephonyManager", "setTelephonyProperty length too long:" + property + ", " + propVal);
            return;
        }
        Rlog.d("TelephonyManager", "setTelephonyProperty property=" + property + " propVal=" + propVal);
        SystemProperties.set(property, propVal);
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    private static final boolean $$robo$$android_telephony_TelephonyManager$putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    private static final String $$robo$$android_telephony_TelephonyManager$getTelephonyProperty(String property, long subId, String defaultVal) {
        String propVal = null;
        int phoneId = SubscriptionManager.getPhoneId(subId);
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimIst() {
        try {
            return this.getSubscriberInfo().getIsimIst();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getIsimPcscf() {
        try {
            return this.getSubscriberInfo().getIsimPcscf();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimChallengeResponse(String nonce) {
        try {
            return this.getSubscriberInfo().getIsimChallengeResponse(nonce);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIccSimChallengeResponse(long subId, int appType, String data) {
        try {
            return this.getSubscriberInfo().getIccSimChallengeResponse(subId, appType, data);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIccSimChallengeResponse(int appType, String data) {
        return this.getIccSimChallengeResponse(TelephonyManager.getDefaultSubscription(), appType, data);
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getPcscfAddress(String apnType) {
        try {
            return this.getITelephony().getPcscfAddress(apnType);
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setImsRegistrationState(boolean registered) {
        try {
            this.getITelephony().setImsRegistrationState(registered);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPreferredNetworkType() {
        try {
            return this.getITelephony().getPreferredNetworkType();
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getPreferredNetworkType NPE", ex);
        }
        return -1;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setPreferredNetworkType(int networkType) {
        try {
            return this.getITelephony().setPreferredNetworkType(networkType);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setPreferredNetworkType NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setGlobalPreferredNetworkType() {
        return this.setPreferredNetworkType(10);
    }

    private final int $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges() {
        try {
            return this.getITelephony().hasCarrierPrivileges();
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges NPE", ex);
        }
        return 0;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(String brand) {
        try {
            return this.getITelephony().setOperatorBrandOverride(brand);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMdn() {
        return this.getCdmaMdn(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMdn(long subId) {
        try {
            return this.getITelephony().getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMin() {
        return this.getCdmaMin(TelephonyManager.getDefaultSubscription());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMin(long subId) {
        try {
            return this.getITelephony().getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackage(String pkgname) {
        try {
            return this.getITelephony().checkCarrierPrivilegesForPackage(pkgname);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges NPE", ex);
        }
        return 0;
    }

    private final List<String> $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntent(Intent intent) {
        try {
            return this.getITelephony().getCarrierPackageNamesForIntent(intent);
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getCarrierPackageNamesForIntent RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getCarrierPackageNamesForIntent NPE", ex);
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$dial(String number) {
        try {
            this.getITelephony().dial(number);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#dial", e);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$call(String callingPackage, String number) {
        try {
            this.getITelephony().call(callingPackage, number);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#call", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$endCall() {
        try {
            return this.getITelephony().endCall();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#endCall", e);
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$answerRingingCall() {
        try {
            this.getITelephony().answerRingingCall();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#answerRingingCall", e);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$silenceRinger() {
        try {
            this.getTelecomService().silenceRinger();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelecomService#silenceRinger", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isOffhook() {
        try {
            return this.getITelephony().isOffhook();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isOffhook", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isRinging() {
        try {
            return this.getITelephony().isRinging();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isRinging", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isIdle() {
        try {
            return this.getITelephony().isIdle();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isIdle", e);
            return true;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isRadioOn() {
        try {
            return this.getITelephony().isRadioOn();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isRadioOn", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isSimPinEnabled() {
        try {
            return this.getITelephony().isSimPinEnabled();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isSimPinEnabled", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$supplyPin(String pin) {
        try {
            return this.getITelephony().supplyPin(pin);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPin", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$supplyPuk(String puk, String pin) {
        try {
            return this.getITelephony().supplyPuk(puk, pin);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPuk", e);
            return false;
        }
    }

    private final int[] $$robo$$android_telephony_TelephonyManager$supplyPinReportResult(String pin) {
        try {
            return this.getITelephony().supplyPinReportResult(pin);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPinReportResult", e);
            return new int[0];
        }
    }

    private final int[] $$robo$$android_telephony_TelephonyManager$supplyPukReportResult(String puk, String pin) {
        try {
            return this.getITelephony().supplyPukReportResult(puk, pin);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#]", e);
            return new int[0];
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$handlePinMmi(String dialString) {
        try {
            return this.getITelephony().handlePinMmi(dialString);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#handlePinMmi", e);
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$toggleRadioOnOff() {
        try {
            this.getITelephony().toggleRadioOnOff();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRadio(boolean turnOn) {
        try {
            return this.getITelephony().setRadio(turnOn);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setRadio", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRadioPower(boolean turnOn) {
        try {
            return this.getITelephony().setRadioPower(turnOn);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setRadioPower", e);
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$updateServiceLocation() {
        try {
            this.getITelephony().updateServiceLocation();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#updateServiceLocation", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$enableDataConnectivity() {
        try {
            return this.getITelephony().enableDataConnectivity();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#enableDataConnectivity", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$disableDataConnectivity() {
        try {
            return this.getITelephony().disableDataConnectivity();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#disableDataConnectivity", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isDataConnectivityPossible() {
        try {
            return this.getITelephony().isDataConnectivityPossible();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isDataConnectivityPossible", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$needsOtaServiceProvisioning() {
        try {
            return this.getITelephony().needsOtaServiceProvisioning();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#needsOtaServiceProvisioning", e);
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataEnabled(boolean enable) {
        try {
            this.getITelephony().setDataEnabled(enable);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setDataEnabled", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getDataEnabled() {
        try {
            return this.getITelephony().getDataEnabled();
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getDataEnabled", e);
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableSimplifiedNetworkSettings(boolean enable) {
        this.enableSimplifiedNetworkSettingsForSubscriber(TelephonyManager.getDefaultSubscription(), enable);
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableSimplifiedNetworkSettingsForSubscriber(long subId, boolean enable) {
        try {
            this.getITelephony().enableSimplifiedNetworkSettingsForSubscriber(subId, enable);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSimplifiedNetworkSettingsEnabled() {
        return this.getSimplifiedNetworkSettingsEnabledForSubscriber(TelephonyManager.getDefaultSubscription());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSimplifiedNetworkSettingsEnabledForSubscriber(long subId) {
        try {
            return this.getITelephony().getSimplifiedNetworkSettingsEnabledForSubscriber(subId);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private final int $$robo$$android_telephony_TelephonyManager$invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            return this.getITelephony().invokeOemRilRequestRaw(oemReq, oemResp);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    static void __staticInitializer__() {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telephony_TelephonyManager$__constructor__(context);
    }

    public TelephonyManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_TelephonyManager$__constructor__();
    }

    private TelephonyManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager$__constructor__(), 0, this);
    }

    public static TelephonyManager getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_telephony_TelephonyManager$getDefault(), 0);
    }

    public MultiSimVariants getMultiSimConfiguration() {
        return InvokeDynamicSupport.bootstrap("getMultiSimConfiguration", $$robo$$android_telephony_TelephonyManager$getMultiSimConfiguration(), 0, this);
    }

    public int getPhoneCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneCount", $$robo$$android_telephony_TelephonyManager$getPhoneCount(), 0, this);
    }

    public static TelephonyManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telephony_TelephonyManager$from(android.content.Context ), 0, (Context)context);
    }

    public boolean isMultiSimEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiSimEnabled", $$robo$$android_telephony_TelephonyManager$isMultiSimEnabled(), 0, this);
    }

    public String getDeviceSoftwareVersion() {
        return InvokeDynamicSupport.bootstrap("getDeviceSoftwareVersion", $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion(), 0, this);
    }

    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_telephony_TelephonyManager$getDeviceId(), 0, this);
    }

    public String getDeviceId(int n) {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_telephony_TelephonyManager$getDeviceId(int ), 0, this, n);
    }

    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$android_telephony_TelephonyManager$getImei(), 0, this);
    }

    public String getImei(int n) {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$android_telephony_TelephonyManager$getImei(int ), 0, this, n);
    }

    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$android_telephony_TelephonyManager$getCellLocation(), 0, this);
    }

    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(), 0, this);
    }

    public void enableLocationUpdates(long l) {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(long ), 0, this, l);
    }

    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(), 0, this);
    }

    public void disableLocationUpdates(long l) {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(long ), 0, this, l);
    }

    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        return InvokeDynamicSupport.bootstrap("getNeighboringCellInfo", $$robo$$android_telephony_TelephonyManager$getNeighboringCellInfo(), 0, this);
    }

    public int getCurrentPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPhoneType", $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(), 0, this);
    }

    public int getCurrentPhoneType(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPhoneType", $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(long ), 0, this, l);
    }

    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$android_telephony_TelephonyManager$getPhoneType(), 0, this);
    }

    private int getPhoneTypeFromProperty() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromProperty", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(), 0, this);
    }

    private int getPhoneTypeFromProperty(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromProperty", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(long ), 0, this, l);
    }

    private int getPhoneTypeFromNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromNetworkType", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(), 0, this);
    }

    private int getPhoneTypeFromNetworkType(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromNetworkType", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(long ), 0, this, l);
    }

    public static int getPhoneType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPhoneType", $$robo$$android_telephony_TelephonyManager$getPhoneType(int ), 0, (int)n);
    }

    private static String getProcCmdLine() {
        return InvokeDynamicSupport.bootstrapStatic("getProcCmdLine", $$robo$$android_telephony_TelephonyManager$getProcCmdLine(), 0);
    }

    public static int getLteOnCdmaModeStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLteOnCdmaModeStatic", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaModeStatic(), 0);
    }

    public String getNetworkOperatorName() {
        return InvokeDynamicSupport.bootstrap("getNetworkOperatorName", $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(), 0, this);
    }

    public String getNetworkOperatorName(long l) {
        return InvokeDynamicSupport.bootstrap("getNetworkOperatorName", $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(long ), 0, this, l);
    }

    public String getNetworkOperator() {
        return InvokeDynamicSupport.bootstrap("getNetworkOperator", $$robo$$android_telephony_TelephonyManager$getNetworkOperator(), 0, this);
    }

    public String getNetworkOperator(long l) {
        return InvokeDynamicSupport.bootstrap("getNetworkOperator", $$robo$$android_telephony_TelephonyManager$getNetworkOperator(long ), 0, this, l);
    }

    public boolean isNetworkRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(), 0, this);
    }

    public boolean isNetworkRoaming(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(long ), 0, this, l);
    }

    public String getNetworkCountryIso() {
        return InvokeDynamicSupport.bootstrap("getNetworkCountryIso", $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(), 0, this);
    }

    public String getNetworkCountryIso(long l) {
        return InvokeDynamicSupport.bootstrap("getNetworkCountryIso", $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(long ), 0, this, l);
    }

    public int getNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkType", $$robo$$android_telephony_TelephonyManager$getNetworkType(), 0, this);
    }

    public int getNetworkType(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkType", $$robo$$android_telephony_TelephonyManager$getNetworkType(long ), 0, this, l);
    }

    public int getDataNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getDataNetworkType", $$robo$$android_telephony_TelephonyManager$getDataNetworkType(), 0, this);
    }

    public int getDataNetworkType(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getDataNetworkType", $$robo$$android_telephony_TelephonyManager$getDataNetworkType(long ), 0, this, l);
    }

    public int getVoiceNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceNetworkType", $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(), 0, this);
    }

    public int getVoiceNetworkType(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceNetworkType", $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(long ), 0, this, l);
    }

    public static int getNetworkClass(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNetworkClass", $$robo$$android_telephony_TelephonyManager$getNetworkClass(int ), 0, (int)n);
    }

    public String getNetworkTypeName() {
        return InvokeDynamicSupport.bootstrap("getNetworkTypeName", $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(), 0, this);
    }

    public static String getNetworkTypeName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTypeName", $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(int ), 0, (int)n);
    }

    public boolean hasIccCard() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$android_telephony_TelephonyManager$hasIccCard(), 0, this);
    }

    public boolean hasIccCard(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$android_telephony_TelephonyManager$hasIccCard(long ), 0, this, l);
    }

    public int getSimState() {
        return (int)InvokeDynamicSupport.bootstrap("getSimState", $$robo$$android_telephony_TelephonyManager$getSimState(), 0, this);
    }

    public int getSimState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSimState", $$robo$$android_telephony_TelephonyManager$getSimState(int ), 0, this, n);
    }

    public String getSimOperator() {
        return InvokeDynamicSupport.bootstrap("getSimOperator", $$robo$$android_telephony_TelephonyManager$getSimOperator(), 0, this);
    }

    public String getSimOperator(long l) {
        return InvokeDynamicSupport.bootstrap("getSimOperator", $$robo$$android_telephony_TelephonyManager$getSimOperator(long ), 0, this, l);
    }

    public String getSimOperatorName() {
        return InvokeDynamicSupport.bootstrap("getSimOperatorName", $$robo$$android_telephony_TelephonyManager$getSimOperatorName(), 0, this);
    }

    public String getSimOperatorName(long l) {
        return InvokeDynamicSupport.bootstrap("getSimOperatorName", $$robo$$android_telephony_TelephonyManager$getSimOperatorName(long ), 0, this, l);
    }

    public String getSimCountryIso() {
        return InvokeDynamicSupport.bootstrap("getSimCountryIso", $$robo$$android_telephony_TelephonyManager$getSimCountryIso(), 0, this);
    }

    public String getSimCountryIso(long l) {
        return InvokeDynamicSupport.bootstrap("getSimCountryIso", $$robo$$android_telephony_TelephonyManager$getSimCountryIso(long ), 0, this, l);
    }

    public String getSimSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getSimSerialNumber", $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(), 0, this);
    }

    public String getSimSerialNumber(long l) {
        return InvokeDynamicSupport.bootstrap("getSimSerialNumber", $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(long ), 0, this, l);
    }

    public int getLteOnCdmaMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(), 0, this);
    }

    public int getLteOnCdmaMode(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(long ), 0, this, l);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_telephony_TelephonyManager$getSubscriberId(), 0, this);
    }

    public String getSubscriberId(long l) {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_telephony_TelephonyManager$getSubscriberId(long ), 0, this, l);
    }

    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(), 0, this);
    }

    public String getGroupIdLevel1(long l) {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(long ), 0, this, l);
    }

    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$android_telephony_TelephonyManager$getLine1Number(), 0, this);
    }

    public String getLine1NumberForSubscriber(long l) {
        return InvokeDynamicSupport.bootstrap("getLine1NumberForSubscriber", $$robo$$android_telephony_TelephonyManager$getLine1NumberForSubscriber(long ), 0, this, l);
    }

    public void setLine1NumberForDisplay(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setLine1NumberForDisplay", $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setLine1NumberForDisplayForSubscriber(long l, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setLine1NumberForDisplayForSubscriber", $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplayForSubscriber(long java.lang.String java.lang.String ), 0, this, l, string2, string3);
    }

    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag(), 0, this);
    }

    public String getLine1AlphaTagForSubscriber(long l) {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTagForSubscriber", $$robo$$android_telephony_TelephonyManager$getLine1AlphaTagForSubscriber(long ), 0, this, l);
    }

    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$android_telephony_TelephonyManager$getMsisdn(), 0, this);
    }

    public String getMsisdn(long l) {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$android_telephony_TelephonyManager$getMsisdn(long ), 0, this, l);
    }

    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(), 0, this);
    }

    public String getVoiceMailNumber(long l) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(long ), 0, this, l);
    }

    public String getCompleteVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(), 0, this);
    }

    public String getCompleteVoiceMailNumber(long l) {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(long ), 0, this, l);
    }

    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(), 0, this);
    }

    public int getVoiceMessageCount(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(long ), 0, this, l);
    }

    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(), 0, this);
    }

    public String getVoiceMailAlphaTag(long l) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(long ), 0, this, l);
    }

    public String getIsimImpi() {
        return InvokeDynamicSupport.bootstrap("getIsimImpi", $$robo$$android_telephony_TelephonyManager$getIsimImpi(), 0, this);
    }

    public String getIsimDomain() {
        return InvokeDynamicSupport.bootstrap("getIsimDomain", $$robo$$android_telephony_TelephonyManager$getIsimDomain(), 0, this);
    }

    public String[] getIsimImpu() {
        return InvokeDynamicSupport.bootstrap("getIsimImpu", $$robo$$android_telephony_TelephonyManager$getIsimImpu(), 0, this);
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return InvokeDynamicSupport.bootstrap("getSubscriberInfo", $$robo$$android_telephony_TelephonyManager$getSubscriberInfo(), 0, this);
    }

    public int getCallState() {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telephony_TelephonyManager$getCallState(), 0, this);
    }

    public int getCallState(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telephony_TelephonyManager$getCallState(long ), 0, this, l);
    }

    public int getDataActivity() {
        return (int)InvokeDynamicSupport.bootstrap("getDataActivity", $$robo$$android_telephony_TelephonyManager$getDataActivity(), 0, this);
    }

    public int getDataState() {
        return (int)InvokeDynamicSupport.bootstrap("getDataState", $$robo$$android_telephony_TelephonyManager$getDataState(), 0, this);
    }

    private ITelephony getITelephony() {
        return InvokeDynamicSupport.bootstrap("getITelephony", $$robo$$android_telephony_TelephonyManager$getITelephony(), 0, this);
    }

    private ITelecomService getTelecomService() {
        return InvokeDynamicSupport.bootstrap("getTelecomService", $$robo$$android_telephony_TelephonyManager$getTelecomService(), 0, this);
    }

    public void listen(PhoneStateListener phoneStateListener, int n) {
        InvokeDynamicSupport.bootstrap("listen", $$robo$$android_telephony_TelephonyManager$listen(android.telephony.PhoneStateListener int ), 0, this, phoneStateListener, n);
    }

    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(), 0, this);
    }

    public int getCdmaEriIconIndex(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(long ), 0, this, l);
    }

    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(), 0, this);
    }

    public int getCdmaEriIconMode(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(long ), 0, this, l);
    }

    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$android_telephony_TelephonyManager$getCdmaEriText(), 0, this);
    }

    public String getCdmaEriText(long l) {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$android_telephony_TelephonyManager$getCdmaEriText(long ), 0, this, l);
    }

    public boolean isVoiceCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoiceCapable", $$robo$$android_telephony_TelephonyManager$isVoiceCapable(), 0, this);
    }

    public boolean isSmsCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmsCapable", $$robo$$android_telephony_TelephonyManager$isSmsCapable(), 0, this);
    }

    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$android_telephony_TelephonyManager$getAllCellInfo(), 0, this);
    }

    public void setCellInfoListRate(int n) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$android_telephony_TelephonyManager$setCellInfoListRate(int ), 0, this, n);
    }

    public String getMmsUserAgent() {
        return InvokeDynamicSupport.bootstrap("getMmsUserAgent", $$robo$$android_telephony_TelephonyManager$getMmsUserAgent(), 0, this);
    }

    public String getMmsUAProfUrl() {
        return InvokeDynamicSupport.bootstrap("getMmsUAProfUrl", $$robo$$android_telephony_TelephonyManager$getMmsUAProfUrl(), 0, this);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String string2) {
        return InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(java.lang.String ), 0, this, string2);
    }

    public boolean iccCloseLogicalChannel(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int ), 0, this, n);
    }

    public String iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, string2);
    }

    public String iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
    }

    public byte[] iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2) {
        return InvokeDynamicSupport.bootstrap("iccExchangeSimIO", $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
    }

    public String sendEnvelopeWithStatus(String string2) {
        return InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(java.lang.String ), 0, this, string2);
    }

    public String nvReadItem(int n) {
        return InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$android_telephony_TelephonyManager$nvReadItem(int ), 0, this, n);
    }

    public boolean nvWriteItem(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$android_telephony_TelephonyManager$nvWriteItem(int java.lang.String ), 0, this, n, string2);
    }

    public boolean nvWriteCdmaPrl(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$android_telephony_TelephonyManager$nvWriteCdmaPrl(byte[] ), 0, this, byArray);
    }

    public boolean nvResetConfig(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$android_telephony_TelephonyManager$nvResetConfig(int ), 0, this, n);
    }

    private static long getDefaultSubscription() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getDefaultSubscription", $$robo$$android_telephony_TelephonyManager$getDefaultSubscription(), 0);
    }

    public int getDefaultSim() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSim", $$robo$$android_telephony_TelephonyManager$getDefaultSim(), 0, this);
    }

    public static void setTelephonyProperty(String string2, long l, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setTelephonyProperty", $$robo$$android_telephony_TelephonyManager$setTelephonyProperty(java.lang.String long java.lang.String ), 0, (String)string2, (long)l, (String)string3);
    }

    public static int getIntAtIndex(ContentResolver contentResolver, String string2, int n) throws Settings.SettingNotFoundException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntAtIndex", $$robo$$android_telephony_TelephonyManager$getIntAtIndex(android.content.ContentResolver java.lang.String int ), 0, (ContentResolver)contentResolver, (String)string2, (int)n);
    }

    public static boolean putIntAtIndex(ContentResolver contentResolver, String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("putIntAtIndex", $$robo$$android_telephony_TelephonyManager$putIntAtIndex(android.content.ContentResolver java.lang.String int int ), 0, (ContentResolver)contentResolver, (String)string2, (int)n, (int)n2);
    }

    public static String getTelephonyProperty(String string2, long l, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getTelephonyProperty", $$robo$$android_telephony_TelephonyManager$getTelephonyProperty(java.lang.String long java.lang.String ), 0, (String)string2, (long)l, (String)string3);
    }

    public int getSimCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSimCount", $$robo$$android_telephony_TelephonyManager$getSimCount(), 0, this);
    }

    public String getIsimIst() {
        return InvokeDynamicSupport.bootstrap("getIsimIst", $$robo$$android_telephony_TelephonyManager$getIsimIst(), 0, this);
    }

    public String[] getIsimPcscf() {
        return InvokeDynamicSupport.bootstrap("getIsimPcscf", $$robo$$android_telephony_TelephonyManager$getIsimPcscf(), 0, this);
    }

    public String getIsimChallengeResponse(String string2) {
        return InvokeDynamicSupport.bootstrap("getIsimChallengeResponse", $$robo$$android_telephony_TelephonyManager$getIsimChallengeResponse(java.lang.String ), 0, this, string2);
    }

    public String getIccSimChallengeResponse(long l, int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getIccSimChallengeResponse", $$robo$$android_telephony_TelephonyManager$getIccSimChallengeResponse(long int java.lang.String ), 0, this, l, n, string2);
    }

    public String getIccSimChallengeResponse(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getIccSimChallengeResponse", $$robo$$android_telephony_TelephonyManager$getIccSimChallengeResponse(int java.lang.String ), 0, this, n, string2);
    }

    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$android_telephony_TelephonyManager$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$android_telephony_TelephonyManager$setImsRegistrationState(boolean ), 0, this, bl);
    }

    public int getPreferredNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$android_telephony_TelephonyManager$getPreferredNetworkType(), 0, this);
    }

    public boolean setPreferredNetworkType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$android_telephony_TelephonyManager$setPreferredNetworkType(int ), 0, this, n);
    }

    public boolean setGlobalPreferredNetworkType() {
        return (boolean)InvokeDynamicSupport.bootstrap("setGlobalPreferredNetworkType", $$robo$$android_telephony_TelephonyManager$setGlobalPreferredNetworkType(), 0, this);
    }

    public int hasCarrierPrivileges() {
        return (int)InvokeDynamicSupport.bootstrap("hasCarrierPrivileges", $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges(), 0, this);
    }

    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public String getCdmaMdn() {
        return InvokeDynamicSupport.bootstrap("getCdmaMdn", $$robo$$android_telephony_TelephonyManager$getCdmaMdn(), 0, this);
    }

    public String getCdmaMdn(long l) {
        return InvokeDynamicSupport.bootstrap("getCdmaMdn", $$robo$$android_telephony_TelephonyManager$getCdmaMdn(long ), 0, this, l);
    }

    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$android_telephony_TelephonyManager$getCdmaMin(), 0, this);
    }

    public String getCdmaMin(long l) {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$android_telephony_TelephonyManager$getCdmaMin(long ), 0, this, l);
    }

    public int checkCarrierPrivilegesForPackage(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkCarrierPrivilegesForPackage", $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackage(java.lang.String ), 0, this, string2);
    }

    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntent(android.content.Intent ), 0, this, intent);
    }

    public void dial(String string2) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$android_telephony_TelephonyManager$dial(java.lang.String ), 0, this, string2);
    }

    public void call(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("call", $$robo$$android_telephony_TelephonyManager$call(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean endCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("endCall", $$robo$$android_telephony_TelephonyManager$endCall(), 0, this);
    }

    public void answerRingingCall() {
        InvokeDynamicSupport.bootstrap("answerRingingCall", $$robo$$android_telephony_TelephonyManager$answerRingingCall(), 0, this);
    }

    public void silenceRinger() {
        InvokeDynamicSupport.bootstrap("silenceRinger", $$robo$$android_telephony_TelephonyManager$silenceRinger(), 0, this);
    }

    public boolean isOffhook() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffhook", $$robo$$android_telephony_TelephonyManager$isOffhook(), 0, this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$android_telephony_TelephonyManager$isRinging(), 0, this);
    }

    public boolean isIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdle", $$robo$$android_telephony_TelephonyManager$isIdle(), 0, this);
    }

    public boolean isRadioOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioOn", $$robo$$android_telephony_TelephonyManager$isRadioOn(), 0, this);
    }

    public boolean isSimPinEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSimPinEnabled", $$robo$$android_telephony_TelephonyManager$isSimPinEnabled(), 0, this);
    }

    public boolean supplyPin(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supplyPin", $$robo$$android_telephony_TelephonyManager$supplyPin(java.lang.String ), 0, this, string2);
    }

    public boolean supplyPuk(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("supplyPuk", $$robo$$android_telephony_TelephonyManager$supplyPuk(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int[] supplyPinReportResult(String string2) {
        return InvokeDynamicSupport.bootstrap("supplyPinReportResult", $$robo$$android_telephony_TelephonyManager$supplyPinReportResult(java.lang.String ), 0, this, string2);
    }

    public int[] supplyPukReportResult(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("supplyPukReportResult", $$robo$$android_telephony_TelephonyManager$supplyPukReportResult(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$android_telephony_TelephonyManager$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    public void toggleRadioOnOff() {
        InvokeDynamicSupport.bootstrap("toggleRadioOnOff", $$robo$$android_telephony_TelephonyManager$toggleRadioOnOff(), 0, this);
    }

    public boolean setRadio(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRadio", $$robo$$android_telephony_TelephonyManager$setRadio(boolean ), 0, this, bl);
    }

    public boolean setRadioPower(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$android_telephony_TelephonyManager$setRadioPower(boolean ), 0, this, bl);
    }

    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$android_telephony_TelephonyManager$updateServiceLocation(), 0, this);
    }

    public boolean enableDataConnectivity() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableDataConnectivity", $$robo$$android_telephony_TelephonyManager$enableDataConnectivity(), 0, this);
    }

    public boolean disableDataConnectivity() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableDataConnectivity", $$robo$$android_telephony_TelephonyManager$disableDataConnectivity(), 0, this);
    }

    public boolean isDataConnectivityPossible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$android_telephony_TelephonyManager$isDataConnectivityPossible(), 0, this);
    }

    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$android_telephony_TelephonyManager$needsOtaServiceProvisioning(), 0, this);
    }

    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$android_telephony_TelephonyManager$setDataEnabled(boolean ), 0, this, bl);
    }

    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$android_telephony_TelephonyManager$getDataEnabled(), 0, this);
    }

    public void enableSimplifiedNetworkSettings(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableSimplifiedNetworkSettings", $$robo$$android_telephony_TelephonyManager$enableSimplifiedNetworkSettings(boolean ), 0, this, bl);
    }

    public void enableSimplifiedNetworkSettingsForSubscriber(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("enableSimplifiedNetworkSettingsForSubscriber", $$robo$$android_telephony_TelephonyManager$enableSimplifiedNetworkSettingsForSubscriber(long boolean ), 0, this, l, bl);
    }

    public boolean getSimplifiedNetworkSettingsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSimplifiedNetworkSettingsEnabled", $$robo$$android_telephony_TelephonyManager$getSimplifiedNetworkSettingsEnabled(), 0, this);
    }

    public boolean getSimplifiedNetworkSettingsEnabledForSubscriber(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSimplifiedNetworkSettingsEnabledForSubscriber", $$robo$$android_telephony_TelephonyManager$getSimplifiedNetworkSettingsEnabledForSubscriber(long ), 0, this, l);
    }

    public int invokeOemRilRequestRaw(byte[] byArray, byte[] byArray2) {
        return (int)InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$android_telephony_TelephonyManager$invokeOemRilRequestRaw(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$android$telephony$TelephonyManager$MultiSimVariants;

        static void __staticInitializer__() {
            $SwitchMap$android$telephony$TelephonyManager$MultiSimVariants = new int[MultiSimVariants.values().length];
            try {
                1.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[MultiSimVariants.DSDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[MultiSimVariants.DSDA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[MultiSimVariants.TSTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MultiSimVariants
    extends Enum<MultiSimVariants> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ MultiSimVariants DSDS;
        public static /* enum */ MultiSimVariants DSDA;
        public static /* enum */ MultiSimVariants TSTS;
        public static /* enum */ MultiSimVariants UNKNOWN;
        private static /* synthetic */ MultiSimVariants[] $VALUES;

        private static final MultiSimVariants[] $$robo$$android_telephony_TelephonyManager_MultiSimVariants$values() {
            return (MultiSimVariants[])$VALUES.clone();
        }

        private static final MultiSimVariants $$robo$$android_telephony_TelephonyManager_MultiSimVariants$valueOf(String name) {
            return Enum.valueOf(MultiSimVariants.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DSDS = new MultiSimVariants();
            DSDA = new MultiSimVariants();
            TSTS = new MultiSimVariants();
            UNKNOWN = new MultiSimVariants();
            $VALUES = new MultiSimVariants[]{DSDS, DSDA, TSTS, UNKNOWN};
        }

        public static MultiSimVariants[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$values(), 0);
        }

        public static MultiSimVariants valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(string2, n);
        }

        private MultiSimVariants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(MultiSimVariants.class);
        }

        public /* synthetic */ MultiSimVariants() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiSimVariants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface WifiCallingChoices
    extends InstrumentedInterface {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

