/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.drawable.Drawable;
import android.text.AndroidBidi;
import android.text.Editable;
import android.text.HtmlToSpannedConverter;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import com.android.internal.util.ArrayUtils;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Html
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_text_Html$__constructor__() {
    }

    private static final Spanned $$robo$$android_text_Html$fromHtml(String source) {
        return Html.fromHtml(source, null, null);
    }

    private static final Spanned $$robo$$android_text_Html$fromHtml(String source, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", HtmlParser.schema);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(source, imageGetter, tagHandler, parser);
        return converter.convert();
    }

    private static final String $$robo$$android_text_Html$toHtml(Spanned text) {
        StringBuilder out = new StringBuilder();
        Html.withinHtml(out, text);
        return out.toString();
    }

    private static final String $$robo$$android_text_Html$escapeHtml(CharSequence text) {
        StringBuilder out = new StringBuilder();
        Html.withinStyle(out, text, 0, text.length());
        return out.toString();
    }

    private static final void $$robo$$android_text_Html$withinHtml(StringBuilder out, Spanned text) {
        int len = text.length();
        int i = 0;
        while (i < text.length()) {
            int next = text.nextSpanTransition(i, len, ParagraphStyle.class);
            ParagraphStyle[] style2 = text.getSpans(i, next, ParagraphStyle.class);
            String elements = " ";
            boolean needDiv = false;
            for (int j = 0; j < style2.length; ++j) {
                if (!(style2[j] instanceof AlignmentSpan)) continue;
                Layout.Alignment align = ((AlignmentSpan)style2[j]).getAlignment();
                needDiv = true;
                elements = align == Layout.Alignment.ALIGN_CENTER ? "align=\"center\" " + elements : (align == Layout.Alignment.ALIGN_OPPOSITE ? "align=\"right\" " + elements : "align=\"left\" " + elements);
            }
            if (needDiv) {
                out.append("<div ").append(elements).append(">");
            }
            Html.withinDiv(out, text, i, next);
            if (needDiv) {
                out.append("</div>");
            }
            i = next;
        }
    }

    private static final void $$robo$$android_text_Html$withinDiv(StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            QuoteSpan[] quotes;
            int next = text.nextSpanTransition(i, end, QuoteSpan.class);
            for (QuoteSpan quote : quotes = text.getSpans(i, next, QuoteSpan.class)) {
                out.append("<blockquote>");
            }
            Html.withinBlockquote(out, text, i, next);
            for (QuoteSpan quote : quotes) {
                out.append("</blockquote>\n");
            }
            i = next;
        }
    }

    private static final String $$robo$$android_text_Html$getOpenParaTagWithDirection(Spanned text, int start, int end) {
        int len = end - start;
        byte[] levels = ArrayUtils.newUnpaddedByteArray(len);
        char[] buffer = TextUtils.obtain(len);
        TextUtils.getChars(text, start, end, buffer, 0);
        int paraDir = AndroidBidi.bidi(2, buffer, levels, len, false);
        switch (paraDir) {
            case -1: {
                return "<p dir=\"rtl\">";
            }
        }
        return "<p dir=\"ltr\">";
    }

    private static final void $$robo$$android_text_Html$withinBlockquote(StringBuilder out, Spanned text, int start, int end) {
        out.append(Html.getOpenParaTagWithDirection(text, start, end));
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)text, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                ++nl;
                ++next;
            }
            Html.withinParagraph(out, text, i, next - nl, nl, next == end);
            i = next;
        }
        out.append("</p>\n");
    }

    private static final void $$robo$$android_text_Html$withinParagraph(StringBuilder out, Spanned text, int start, int end, int nl, boolean last) {
        String p;
        int i = start;
        while (i < end) {
            int j;
            int next = text.nextSpanTransition(i, end, CharacterStyle.class);
            CharacterStyle[] style2 = text.getSpans(i, next, CharacterStyle.class);
            for (j = 0; j < style2.length; ++j) {
                String s;
                if (style2[j] instanceof StyleSpan) {
                    int s2 = ((StyleSpan)style2[j]).getStyle();
                    if ((s2 & 1) != 0) {
                        out.append("<b>");
                    }
                    if ((s2 & 2) != 0) {
                        out.append("<i>");
                    }
                }
                if (style2[j] instanceof TypefaceSpan && (s = ((TypefaceSpan)style2[j]).getFamily()).equals("monospace")) {
                    out.append("<tt>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("<sup>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("<sub>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("<u>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("<strike>");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("<a href=\"");
                    out.append(((URLSpan)style2[j]).getURL());
                    out.append("\">");
                }
                if (style2[j] instanceof ImageSpan) {
                    out.append("<img src=\"");
                    out.append(((ImageSpan)style2[j]).getSource());
                    out.append("\">");
                    i = next;
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    out.append("<font size =\"");
                    out.append(((AbsoluteSizeSpan)style2[j]).getSize() / 6);
                    out.append("\">");
                }
                if (!(style2[j] instanceof ForegroundColorSpan)) continue;
                out.append("<font color =\"#");
                String color2 = Integer.toHexString(((ForegroundColorSpan)style2[j]).getForegroundColor() + 0x1000000);
                while (color2.length() < 6) {
                    color2 = "0" + color2;
                }
                out.append(color2);
                out.append("\">");
            }
            Html.withinStyle(out, text, i, next);
            for (j = style2.length - 1; j >= 0; --j) {
                String s;
                if (style2[j] instanceof ForegroundColorSpan) {
                    out.append("</font>");
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    out.append("</font>");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("</a>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("</strike>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("</u>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("</sub>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("</sup>");
                }
                if (style2[j] instanceof TypefaceSpan && (s = ((TypefaceSpan)style2[j]).getFamily()).equals("monospace")) {
                    out.append("</tt>");
                }
                if (!(style2[j] instanceof StyleSpan)) continue;
                int s2 = ((StyleSpan)style2[j]).getStyle();
                if ((s2 & 1) != 0) {
                    out.append("</b>");
                }
                if ((s2 & 2) == 0) continue;
                out.append("</i>");
            }
            i = next;
        }
        String string2 = p = last ? "" : "</p>\n" + Html.getOpenParaTagWithDirection(text, start, end);
        if (nl == 1) {
            out.append("<br>\n");
        } else if (nl == 2) {
            out.append(p);
        } else {
            for (int i2 = 2; i2 < nl; ++i2) {
                out.append("<br>");
            }
            out.append(p);
        }
    }

    private static final void $$robo$$android_text_Html$withinStyle(StringBuilder out, CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c >= '\udc00' || i + 1 >= end || (d = text.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                ++i;
                int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                out.append("&#").append(codepoint).append(";");
                continue;
            }
            if (c > '~' || c < ' ') {
                out.append("&#").append((int)c).append(";");
                continue;
            }
            if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    ++i;
                }
                out.append(' ');
                continue;
            }
            out.append(c);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_text_Html$__constructor__();
    }

    private Html() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Html$__constructor__(), 0, this);
    }

    public static Spanned fromHtml(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String ), 0, (String)string2);
    }

    public static Spanned fromHtml(String string2, ImageGetter imageGetter, TagHandler tagHandler) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String android.text.Html$ImageGetter android.text.Html$TagHandler ), 0, (String)string2, (ImageGetter)imageGetter, (TagHandler)tagHandler);
    }

    public static String toHtml(Spanned spanned) {
        return InvokeDynamicSupport.bootstrapStatic("toHtml", $$robo$$android_text_Html$toHtml(android.text.Spanned ), 0, (Spanned)spanned);
    }

    public static String escapeHtml(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("escapeHtml", $$robo$$android_text_Html$escapeHtml(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    private static void withinHtml(StringBuilder stringBuilder, Spanned spanned) {
        InvokeDynamicSupport.bootstrapStatic("withinHtml", $$robo$$android_text_Html$withinHtml(java.lang.StringBuilder android.text.Spanned ), 0, (StringBuilder)stringBuilder, (Spanned)spanned);
    }

    private static void withinDiv(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinDiv", $$robo$$android_text_Html$withinDiv(java.lang.StringBuilder android.text.Spanned int int ), 0, (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2);
    }

    private static String getOpenParaTagWithDirection(Spanned spanned, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getOpenParaTagWithDirection", $$robo$$android_text_Html$getOpenParaTagWithDirection(android.text.Spanned int int ), 0, (Spanned)spanned, (int)n, (int)n2);
    }

    private static void withinBlockquote(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinBlockquote", $$robo$$android_text_Html$withinBlockquote(java.lang.StringBuilder android.text.Spanned int int ), 0, (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2);
    }

    private static void withinParagraph(StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("withinParagraph", $$robo$$android_text_Html$withinParagraph(java.lang.StringBuilder android.text.Spanned int int int boolean ), 0, (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    private static void withinStyle(StringBuilder stringBuilder, CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinStyle", $$robo$$android_text_Html$withinStyle(java.lang.StringBuilder java.lang.CharSequence int int ), 0, (StringBuilder)stringBuilder, (CharSequence)charSequence, (int)n, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Html)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class HtmlParser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static HTMLSchema schema;

        private void $$robo$$android_text_Html_HtmlParser$__constructor__() {
        }

        static void __staticInitializer__() {
            schema = new HTMLSchema();
        }

        private void __constructor__() {
            this.$$robo$$android_text_Html_HtmlParser$__constructor__();
        }

        private HtmlParser() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Html_HtmlParser$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(HtmlParser.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HtmlParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TagHandler
    extends InstrumentedInterface {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }

    public static interface ImageGetter
    extends InstrumentedInterface {
        public Drawable getDrawable(String var1);
    }
}

