/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import java.io.IOException;
import java.io.StringReader;
import org.ccil.cowan.tagsoup.Parser;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlToSpannedConverter
implements ContentHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float[] HEADER_SIZES;
    private String mSource;
    private XMLReader mReader;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.ImageGetter mImageGetter;
    private Html.TagHandler mTagHandler;

    private void $$robo$$android_text_HtmlToSpannedConverter$__constructor__(String source, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
    }

    private final Spanned $$robo$$android_text_HtmlToSpannedConverter$convert() {
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        ParagraphStyle[] obj = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class);
        for (int i = 0; i < obj.length; ++i) {
            int start = this.mSpannableStringBuilder.getSpanStart(obj[i]);
            int end = this.mSpannableStringBuilder.getSpanEnd(obj[i]);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(obj[i]);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(obj[i], start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            } else if (tag.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold());
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic());
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Big());
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Small());
            } else if (tag.equalsIgnoreCase("font")) {
                HtmlToSpannedConverter.startFont(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Blockquote());
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Monospace());
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Underline());
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Super());
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Sub());
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Header(tag.charAt(1) - 49));
            } else if (tag.equalsIgnoreCase("img")) {
                HtmlToSpannedConverter.startImg(this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag, this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Blockquote.class, new QuoteSpan());
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            HtmlToSpannedConverter.handleP(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endHeader(this.mSpannableStringBuilder);
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag, this.mSpannableStringBuilder, this.mReader);
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$handleP(SpannableStringBuilder text) {
        int len = text.length();
        if (len >= 1 && text.charAt(len - 1) == '\n') {
            if (len >= 2 && text.charAt(len - 2) == '\n') {
                return;
            }
            text.append("\n");
            return;
        }
        if (len != 0) {
            text.append("\n\n");
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$handleBr(SpannableStringBuilder text) {
        text.append("\n");
    }

    private static final Object $$robo$$android_text_HtmlToSpannedConverter$getLast(Spanned text, Class kind) {
        T[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$start(SpannableStringBuilder text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$end(SpannableStringBuilder text, Class kind, Object repl) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, kind);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            text.setSpan(repl, where, len, 33);
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startImg(SpannableStringBuilder text, Attributes attributes, Html.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src);
        }
        if (d == null) {
            d = Resources.getSystem().getDrawable(17303371);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        }
        int len = text.length();
        text.append("\ufffc");
        text.setSpan(new ImageSpan(d, src), len, text.length(), 33);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startFont(SpannableStringBuilder text, Attributes attributes) {
        String color2 = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        int len = text.length();
        text.setSpan(new Font(color2, face), len, len, 17);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endFont(SpannableStringBuilder text) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, Font.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            Font f = (Font)obj;
            if (!TextUtils.isEmpty(f.mColor)) {
                if (f.mColor.startsWith("@")) {
                    String name;
                    Resources res = Resources.getSystem();
                    int colorRes = res.getIdentifier(name = f.mColor.substring(1), "color", "android");
                    if (colorRes != 0) {
                        ColorStateList colors = res.getColorStateList(colorRes);
                        text.setSpan(new TextAppearanceSpan(null, 0, 0, colors, null), where, len, 33);
                    }
                } else {
                    int c = Color.getHtmlColor(f.mColor);
                    if (c != -1) {
                        text.setSpan(new ForegroundColorSpan(c | 0xFF000000), where, len, 33);
                    }
                }
            }
            if (f.mFace != null) {
                text.setSpan(new TypefaceSpan(f.mFace), where, len, 33);
            }
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startA(SpannableStringBuilder text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        int len = text.length();
        text.setSpan(new Href(href), len, len, 17);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endA(SpannableStringBuilder text) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, Href.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            Href h = (Href)obj;
            if (h.mHref != null) {
                text.setSpan(new URLSpan(h.mHref), where, len, 33);
            }
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endHeader(SpannableStringBuilder text) {
        int len;
        Object obj = HtmlToSpannedConverter.getLast(text, Header.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        for (len = text.length(); len > where && text.charAt(len - 1) == '\n'; --len) {
        }
        if (where != len) {
            Header h = (Header)obj;
            text.setSpan(new RelativeSizeSpan(HEADER_SIZES[h.mLevel]), where, len, 33);
            text.setSpan(new StyleSpan(1), where, len, 33);
        }
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$setDocumentLocator(Locator locator) {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startDocument() throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endDocument() throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endPrefixMapping(String prefix) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append(sb);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$processingInstruction(String target, String data) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$skippedEntity(String name) throws SAXException {
    }

    static void __staticInitializer__() {
        HEADER_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    }

    private void __constructor__(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        this.$$robo$$android_text_HtmlToSpannedConverter$__constructor__(string2, imageGetter, tagHandler, parser);
    }

    public HtmlToSpannedConverter(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter$__constructor__(java.lang.String android.text.Html$ImageGetter android.text.Html$TagHandler org.ccil.cowan.tagsoup.Parser ), 0, this, string2, imageGetter, tagHandler, parser);
    }

    public Spanned convert() {
        return InvokeDynamicSupport.bootstrap("convert", $$robo$$android_text_HtmlToSpannedConverter$convert(), 0, this);
    }

    private void handleStartTag(String string2, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("handleStartTag", $$robo$$android_text_HtmlToSpannedConverter$handleStartTag(java.lang.String org.xml.sax.Attributes ), 0, this, string2, attributes);
    }

    private void handleEndTag(String string2) {
        InvokeDynamicSupport.bootstrap("handleEndTag", $$robo$$android_text_HtmlToSpannedConverter$handleEndTag(java.lang.String ), 0, this, string2);
    }

    private static void handleP(SpannableStringBuilder spannableStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("handleP", $$robo$$android_text_HtmlToSpannedConverter$handleP(android.text.SpannableStringBuilder ), 0, (SpannableStringBuilder)spannableStringBuilder);
    }

    private static void handleBr(SpannableStringBuilder spannableStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("handleBr", $$robo$$android_text_HtmlToSpannedConverter$handleBr(android.text.SpannableStringBuilder ), 0, (SpannableStringBuilder)spannableStringBuilder);
    }

    private static Object getLast(Spanned spanned, Class clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getLast", $$robo$$android_text_HtmlToSpannedConverter$getLast(android.text.Spanned java.lang.Class ), 0, (Spanned)spanned, (Class)clazz);
    }

    private static void start(SpannableStringBuilder spannableStringBuilder, Object object) {
        InvokeDynamicSupport.bootstrapStatic("start", $$robo$$android_text_HtmlToSpannedConverter$start(android.text.SpannableStringBuilder java.lang.Object ), 0, (SpannableStringBuilder)spannableStringBuilder, (Object)object);
    }

    private static void end(SpannableStringBuilder spannableStringBuilder, Class clazz, Object object) {
        InvokeDynamicSupport.bootstrapStatic("end", $$robo$$android_text_HtmlToSpannedConverter$end(android.text.SpannableStringBuilder java.lang.Class java.lang.Object ), 0, (SpannableStringBuilder)spannableStringBuilder, (Class)clazz, (Object)object);
    }

    private static void startImg(SpannableStringBuilder spannableStringBuilder, Attributes attributes, Html.ImageGetter imageGetter) {
        InvokeDynamicSupport.bootstrapStatic("startImg", $$robo$$android_text_HtmlToSpannedConverter$startImg(android.text.SpannableStringBuilder org.xml.sax.Attributes android.text.Html$ImageGetter ), 0, (SpannableStringBuilder)spannableStringBuilder, (Attributes)attributes, (Html.ImageGetter)imageGetter);
    }

    private static void startFont(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        InvokeDynamicSupport.bootstrapStatic("startFont", $$robo$$android_text_HtmlToSpannedConverter$startFont(android.text.SpannableStringBuilder org.xml.sax.Attributes ), 0, (SpannableStringBuilder)spannableStringBuilder, (Attributes)attributes);
    }

    private static void endFont(SpannableStringBuilder spannableStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("endFont", $$robo$$android_text_HtmlToSpannedConverter$endFont(android.text.SpannableStringBuilder ), 0, (SpannableStringBuilder)spannableStringBuilder);
    }

    private static void startA(SpannableStringBuilder spannableStringBuilder, Attributes attributes) {
        InvokeDynamicSupport.bootstrapStatic("startA", $$robo$$android_text_HtmlToSpannedConverter$startA(android.text.SpannableStringBuilder org.xml.sax.Attributes ), 0, (SpannableStringBuilder)spannableStringBuilder, (Attributes)attributes);
    }

    private static void endA(SpannableStringBuilder spannableStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("endA", $$robo$$android_text_HtmlToSpannedConverter$endA(android.text.SpannableStringBuilder ), 0, (SpannableStringBuilder)spannableStringBuilder);
    }

    private static void endHeader(SpannableStringBuilder spannableStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("endHeader", $$robo$$android_text_HtmlToSpannedConverter$endHeader(android.text.SpannableStringBuilder ), 0, (SpannableStringBuilder)spannableStringBuilder);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        InvokeDynamicSupport.bootstrap("setDocumentLocator", $$robo$$android_text_HtmlToSpannedConverter$setDocumentLocator(org.xml.sax.Locator ), 0, this, locator);
    }

    @Override
    public void startDocument() throws SAXException {
        InvokeDynamicSupport.bootstrap("startDocument", $$robo$$android_text_HtmlToSpannedConverter$startDocument(), 0, this);
    }

    @Override
    public void endDocument() throws SAXException {
        InvokeDynamicSupport.bootstrap("endDocument", $$robo$$android_text_HtmlToSpannedConverter$endDocument(), 0, this);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
        InvokeDynamicSupport.bootstrap("startPrefixMapping", $$robo$$android_text_HtmlToSpannedConverter$startPrefixMapping(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
        InvokeDynamicSupport.bootstrap("endPrefixMapping", $$robo$$android_text_HtmlToSpannedConverter$endPrefixMapping(java.lang.String ), 0, this, string2);
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        InvokeDynamicSupport.bootstrap("startElement", $$robo$$android_text_HtmlToSpannedConverter$startElement(java.lang.String java.lang.String java.lang.String org.xml.sax.Attributes ), 0, this, string2, string3, string4, attributes);
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        InvokeDynamicSupport.bootstrap("endElement", $$robo$$android_text_HtmlToSpannedConverter$endElement(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        InvokeDynamicSupport.bootstrap("characters", $$robo$$android_text_HtmlToSpannedConverter$characters(char[] int int ), 0, this, cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        InvokeDynamicSupport.bootstrap("ignorableWhitespace", $$robo$$android_text_HtmlToSpannedConverter$ignorableWhitespace(char[] int int ), 0, this, cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
        InvokeDynamicSupport.bootstrap("processingInstruction", $$robo$$android_text_HtmlToSpannedConverter$processingInstruction(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
        InvokeDynamicSupport.bootstrap("skippedEntity", $$robo$$android_text_HtmlToSpannedConverter$skippedEntity(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(HtmlToSpannedConverter.class);
    }

    public /* synthetic */ HtmlToSpannedConverter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HtmlToSpannedConverter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Header
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mLevel;

        private void $$robo$$android_text_HtmlToSpannedConverter_Header$__constructor__(int level) {
            this.mLevel = level;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Header$__constructor__(n);
        }

        public Header(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Header$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ Header() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Header)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Href
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mHref;

        private void $$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(String href) {
            this.mHref = href;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(string2);
        }

        public Href(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Href() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Href)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Font
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mColor;
        public String mFace;

        private void $$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(String color2, String face) {
            this.mColor = color2;
            this.mFace = face;
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(string2, string3);
        }

        public Font(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public /* synthetic */ Font() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Font)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Sub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__();
        }

        private Sub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sub)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Super
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__();
        }

        private Super() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Super)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Blockquote
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__();
        }

        private Blockquote() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Blockquote)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Monospace
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__();
        }

        private Monospace() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Monospace)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Small
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__();
        }

        private Small() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Small)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Big
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__();
        }

        private Big() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Big)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Underline
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__();
        }

        private Underline() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Underline)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Italic
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__();
        }

        private Italic() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Italic)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Bold
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__();
        }

        private Bold() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bold)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

