/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SpannableStringBuilder
implements CharSequence,
GetChars,
Spannable,
Editable,
Appendable,
GraphicsOperations,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SpannableStringBuilder";
    private static InputFilter[] NO_FILTERS;
    private InputFilter[] mFilters;
    private char[] mText;
    private int mGapStart;
    private int mGapLength;
    private Object[] mSpans;
    private int[] mSpanStarts;
    private int[] mSpanEnds;
    private int[] mSpanFlags;
    private int mSpanCount;
    private int mSpanCountBeforeAdd;
    private static int MARK = 1;
    private static int POINT = 2;
    private static int PARAGRAPH = 3;
    private static int START_MASK = 240;
    private static int END_MASK = 15;
    private static int START_SHIFT = 4;
    private static int SPAN_START_AT_START = 4096;
    private static int SPAN_START_AT_END = 8192;
    private static int SPAN_END_AT_START = 16384;
    private static int SPAN_END_AT_END = 32768;
    private static int SPAN_START_END_MASK = 61440;

    private void $$robo$$android_text_SpannableStringBuilder$__constructor__() {
    }

    private void $$robo$$android_text_SpannableStringBuilder$__constructor__(CharSequence text) {
    }

    private void $$robo$$android_text_SpannableStringBuilder$__constructor__(CharSequence text, int start, int end) {
        this.mFilters = NO_FILTERS;
        int srclen = end - start;
        if (srclen < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        this.mText = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(srclen));
        this.mGapStart = srclen;
        this.mGapLength = this.mText.length - srclen;
        TextUtils.getChars(text, start, end, this.mText, 0);
        this.mSpanCount = 0;
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanStarts = EmptyArray.INT;
        this.mSpanEnds = EmptyArray.INT;
        this.mSpanFlags = EmptyArray.INT;
        if (text instanceof Spanned) {
            Spanned sp = (Spanned)text;
            Object[] spans = sp.getSpans(start, end, Object.class);
            for (int i = 0; i < spans.length; ++i) {
                if (spans[i] instanceof NoCopySpan) continue;
                int st = sp.getSpanStart(spans[i]) - start;
                int en = sp.getSpanEnd(spans[i]) - start;
                int fl = sp.getSpanFlags(spans[i]);
                if (st < 0) {
                    st = 0;
                }
                if (st > end - start) {
                    st = end - start;
                }
                if (en < 0) {
                    en = 0;
                }
                if (en > end - start) {
                    en = end - start;
                }
                this.setSpan(false, spans[i], st, en, fl);
            }
        }
    }

    private static final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$valueOf(CharSequence source) {
        if (source instanceof SpannableStringBuilder) {
            return (SpannableStringBuilder)source;
        }
        return new SpannableStringBuilder(source);
    }

    private final char $$robo$$android_text_SpannableStringBuilder$charAt(int where) {
        int len = this.length();
        if (where < 0) {
            throw new IndexOutOfBoundsException("charAt: " + where + " < 0");
        }
        if (where >= len) {
            throw new IndexOutOfBoundsException("charAt: " + where + " >= length " + len);
        }
        if (where >= this.mGapStart) {
            return this.mText[where + this.mGapLength];
        }
        return this.mText[where];
    }

    private final int $$robo$$android_text_SpannableStringBuilder$length() {
        return this.mText.length - this.mGapLength;
    }

    private final void $$robo$$android_text_SpannableStringBuilder$resizeFor(int size) {
        int oldLength = this.mText.length;
        if (size + 1 <= oldLength) {
            return;
        }
        char[] newText = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(size));
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)0, (char[])newText, (int)0, (int)this.mGapStart);
        int newLength = newText.length;
        int delta = newLength - oldLength;
        int after = oldLength - (this.mGapStart + this.mGapLength);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)(oldLength - after), (char[])newText, (int)(newLength - after), (int)after);
        this.mText = newText;
        this.mGapLength += delta;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            if (this.mSpanStarts[i] > this.mGapStart) {
                int n = i;
                this.mSpanStarts[n] = this.mSpanStarts[n] + delta;
            }
            if (this.mSpanEnds[i] <= this.mGapStart) continue;
            int n = i;
            this.mSpanEnds[n] = this.mSpanEnds[n] + delta;
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$moveGapTo(int where) {
        int overlap;
        boolean atEnd;
        if (where == this.mGapStart) {
            return;
        }
        boolean bl = atEnd = where == this.length();
        if (where < this.mGapStart) {
            overlap = this.mGapStart - where;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)where, (char[])this.mText, (int)(this.mGapStart + this.mGapLength - overlap), (int)overlap);
        } else {
            overlap = where - this.mGapStart;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)(where + this.mGapLength - overlap), (char[])this.mText, (int)this.mGapStart, (int)overlap);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            int flag;
            int start = this.mSpanStarts[i];
            int end = this.mSpanEnds[i];
            if (start > this.mGapStart) {
                start -= this.mGapLength;
            }
            if (start > where) {
                start += this.mGapLength;
            } else if (start == where && ((flag = (this.mSpanFlags[i] & 0xF0) >> 4) == 2 || atEnd && flag == 3)) {
                start += this.mGapLength;
            }
            if (end > this.mGapStart) {
                end -= this.mGapLength;
            }
            if (end > where) {
                end += this.mGapLength;
            } else if (end == where && ((flag = this.mSpanFlags[i] & 0xF) == 2 || atEnd && flag == 3)) {
                end += this.mGapLength;
            }
            this.mSpanStarts[i] = start;
            this.mSpanEnds[i] = end;
        }
        this.mGapStart = where;
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$insert(int where, CharSequence tb, int start, int end) {
        return this.replace(where, where, tb, start, end);
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$insert(int where, CharSequence tb) {
        return this.replace(where, where, tb, 0, tb.length());
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$delete(int start, int end) {
        Editable ret = this.replace(start, end, "", 0, 0);
        if (this.mGapLength > 2 * this.length()) {
            this.resizeFor(this.length());
        }
        return ret;
    }

    private final void $$robo$$android_text_SpannableStringBuilder$clear() {
        this.replace(0, this.length(), "", 0, 0);
    }

    private final void $$robo$$android_text_SpannableStringBuilder$clearSpans() {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            Object what = this.mSpans[i];
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanCount = i;
            this.mSpans[i] = null;
            this.sendSpanRemoved(what, ostart, oend);
        }
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$append(CharSequence text) {
        int length = this.length();
        return this.replace(length, length, text, 0, text.length());
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$append(CharSequence text, Object what, int flags) {
        int start = this.length();
        this.append(text);
        this.setSpan(what, start, this.length(), flags);
        return this;
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$append(CharSequence text, int start, int end) {
        int length = this.length();
        return this.replace(length, length, text, start, end);
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$append(char text) {
        return this.append(String.valueOf(text));
    }

    private final void $$robo$$android_text_SpannableStringBuilder$change(int start, int end, CharSequence cs, int csStart, int csEnd) {
        boolean textIsRemoved;
        int replacedLength = end - start;
        int replacementLength = csEnd - csStart;
        int nbNewChars = replacementLength - replacedLength;
        int i = this.mSpanCount - 1;
        while (i >= 0) {
            int spanEnd;
            int spanStart = this.mSpanStarts[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if ((spanEnd = this.mSpanEnds[i]) > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            if ((this.mSpanFlags[i] & 0x33) == 51) {
                int ost = spanStart;
                int oen = spanEnd;
                int clen = this.length();
                if (spanStart > start && spanStart <= end) {
                    for (spanStart = end; spanStart < clen && (spanStart <= end || this.charAt(spanStart - 1) != '\n'); ++spanStart) {
                    }
                }
                if (spanEnd > start && spanEnd <= end) {
                    for (spanEnd = end; spanEnd < clen && (spanEnd <= end || this.charAt(spanEnd - 1) != '\n'); ++spanEnd) {
                    }
                }
                if (spanStart != ost || spanEnd != oen) {
                    this.setSpan(false, this.mSpans[i], spanStart, spanEnd, this.mSpanFlags[i]);
                }
            }
            int flags = 0;
            if (spanStart == start) {
                flags |= 0x1000;
            } else if (spanStart == end + nbNewChars) {
                flags |= 0x2000;
            }
            if (spanEnd == start) {
                flags |= 0x4000;
            } else if (spanEnd == end + nbNewChars) {
                flags |= 0x8000;
            }
            int n = i--;
            this.mSpanFlags[n] = this.mSpanFlags[n] | flags;
        }
        this.moveGapTo(end);
        if (nbNewChars >= this.mGapLength) {
            this.resizeFor(this.mText.length + nbNewChars - this.mGapLength);
        }
        boolean bl = textIsRemoved = replacementLength == 0;
        if (replacedLength > 0) {
            int i2 = 0;
            while (i2 < this.mSpanCount) {
                if ((this.mSpanFlags[i2] & 0x21) == 33 && this.mSpanStarts[i2] >= start && this.mSpanStarts[i2] < this.mGapStart + this.mGapLength && this.mSpanEnds[i2] >= start && this.mSpanEnds[i2] < this.mGapStart + this.mGapLength && (textIsRemoved || this.mSpanStarts[i2] > start || this.mSpanEnds[i2] < this.mGapStart)) {
                    this.removeSpan(i2);
                    continue;
                }
                ++i2;
            }
        }
        this.mGapStart += nbNewChars;
        this.mGapLength -= nbNewChars;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        TextUtils.getChars(cs, csStart, csEnd, this.mText, start);
        if (replacedLength > 0) {
            boolean atEnd = this.mGapStart + this.mGapLength == this.mText.length;
            for (int i3 = 0; i3 < this.mSpanCount; ++i3) {
                int startFlag = (this.mSpanFlags[i3] & 0xF0) >> 4;
                this.mSpanStarts[i3] = this.updatedIntervalBound(this.mSpanStarts[i3], start, nbNewChars, startFlag, atEnd, textIsRemoved);
                int endFlag = this.mSpanFlags[i3] & 0xF;
                this.mSpanEnds[i3] = this.updatedIntervalBound(this.mSpanEnds[i3], start, nbNewChars, endFlag, atEnd, textIsRemoved);
            }
        }
        this.mSpanCountBeforeAdd = this.mSpanCount;
        if (cs instanceof Spanned) {
            Spanned sp = (Spanned)cs;
            Object[] spans = sp.getSpans(csStart, csEnd, Object.class);
            for (int i4 = 0; i4 < spans.length; ++i4) {
                int st = sp.getSpanStart(spans[i4]);
                int en = sp.getSpanEnd(spans[i4]);
                if (st < csStart) {
                    st = csStart;
                }
                if (en > csEnd) {
                    en = csEnd;
                }
                if (this.getSpanStart(spans[i4]) >= 0) continue;
                this.setSpan(false, spans[i4], st - csStart + start, en - csStart + start, sp.getSpanFlags(spans[i4]));
            }
        }
    }

    private final int $$robo$$android_text_SpannableStringBuilder$updatedIntervalBound(int offset, int start, int nbNewChars, int flag, boolean atEnd, boolean textIsRemoved) {
        if (offset >= start && offset < this.mGapStart + this.mGapLength) {
            if (flag == 2) {
                if (textIsRemoved || offset > start) {
                    return this.mGapStart + this.mGapLength;
                }
            } else if (flag == 3) {
                if (atEnd) {
                    return this.mGapStart + this.mGapLength;
                }
            } else {
                if (textIsRemoved || offset < this.mGapStart - nbNewChars) {
                    return start;
                }
                return this.mGapStart;
            }
        }
        return offset;
    }

    private final void $$robo$$android_text_SpannableStringBuilder$removeSpan(int i) {
        Object object = this.mSpans[i];
        int start = this.mSpanStarts[i];
        int end = this.mSpanEnds[i];
        if (start > this.mGapStart) {
            start -= this.mGapLength;
        }
        if (end > this.mGapStart) {
            end -= this.mGapLength;
        }
        int count = this.mSpanCount - (i + 1);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mSpans, (int)(i + 1), (Object)this.mSpans, (int)i, (int)count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mSpanStarts, (int)(i + 1), (int[])this.mSpanStarts, (int)i, (int)count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mSpanEnds, (int)(i + 1), (int[])this.mSpanEnds, (int)i, (int)count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mSpanFlags, (int)(i + 1), (int[])this.mSpanFlags, (int)i, (int)count);
        --this.mSpanCount;
        this.mSpans[this.mSpanCount] = null;
        this.sendSpanRemoved(object, start, end);
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$replace(int start, int end, CharSequence tb) {
        return this.replace(start, end, tb, 0, tb.length());
    }

    private final SpannableStringBuilder $$robo$$android_text_SpannableStringBuilder$replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        this.checkRange("replace", start, end);
        int filtercount = this.mFilters.length;
        for (int i = 0; i < filtercount; ++i) {
            CharSequence repl = this.mFilters[i].filter(tb, tbstart, tbend, this, start, end);
            if (repl == null) continue;
            tb = repl;
            tbstart = 0;
            tbend = repl.length();
        }
        int origLen = end - start;
        int newLen = tbend - tbstart;
        if (origLen == 0 && newLen == 0 && !SpannableStringBuilder.hasNonExclusiveExclusiveSpanAt(tb, tbstart)) {
            return this;
        }
        TextWatcher[] textWatchers = this.getSpans(start, start + origLen, TextWatcher.class);
        this.sendBeforeTextChanged(textWatchers, start, origLen, newLen);
        boolean adjustSelection = origLen != 0 && newLen != 0;
        int selectionStart = 0;
        int selectionEnd = 0;
        if (adjustSelection) {
            selectionStart = Selection.getSelectionStart(this);
            selectionEnd = Selection.getSelectionEnd(this);
        }
        this.change(start, end, tb, tbstart, tbend);
        if (adjustSelection) {
            int offset;
            if (selectionStart > start && selectionStart < end) {
                offset = (selectionStart - start) * newLen / origLen;
                selectionStart = start + offset;
                this.setSpan(false, Selection.SELECTION_START, selectionStart, selectionStart, 34);
            }
            if (selectionEnd > start && selectionEnd < end) {
                offset = (selectionEnd - start) * newLen / origLen;
                selectionEnd = start + offset;
                this.setSpan(false, Selection.SELECTION_END, selectionEnd, selectionEnd, 34);
            }
        }
        this.sendTextChanged(textWatchers, start, origLen, newLen);
        this.sendAfterTextChanged(textWatchers);
        this.sendToSpanWatchers(start, end, newLen - origLen);
        return this;
    }

    private static final boolean $$robo$$android_text_SpannableStringBuilder$hasNonExclusiveExclusiveSpanAt(CharSequence text, int offset) {
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            for (Object span : spanned.getSpans(offset, offset, Object.class)) {
                int flags = spanned.getSpanFlags(span);
                if (flags == 33) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendToSpanWatchers(int replaceStart, int replaceEnd, int nbNewChars) {
        int spanEnd;
        int spanStart;
        int i = 0;
        while (i < this.mSpanCountBeforeAdd) {
            spanStart = this.mSpanStarts[i];
            spanEnd = this.mSpanEnds[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if (spanEnd > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            int spanFlags = this.mSpanFlags[i];
            int newReplaceEnd = replaceEnd + nbNewChars;
            boolean spanChanged = false;
            int previousSpanStart = spanStart;
            if (spanStart > newReplaceEnd) {
                if (nbNewChars != 0) {
                    previousSpanStart -= nbNewChars;
                    spanChanged = true;
                }
            } else if (!(spanStart < replaceStart || spanStart == replaceStart && (spanFlags & 0x1000) == 4096 || spanStart == newReplaceEnd && (spanFlags & 0x2000) == 8192)) {
                spanChanged = true;
            }
            int previousSpanEnd = spanEnd;
            if (spanEnd > newReplaceEnd) {
                if (nbNewChars != 0) {
                    previousSpanEnd -= nbNewChars;
                    spanChanged = true;
                }
            } else if (!(spanEnd < replaceStart || spanEnd == replaceStart && (spanFlags & 0x4000) == 16384 || spanEnd == newReplaceEnd && (spanFlags & 0x8000) == 32768)) {
                spanChanged = true;
            }
            if (spanChanged) {
                this.sendSpanChanged(this.mSpans[i], previousSpanStart, previousSpanEnd, spanStart, spanEnd);
            }
            int n = i++;
            this.mSpanFlags[n] = this.mSpanFlags[n] & 0xFFFF0FFF;
        }
        for (i = this.mSpanCountBeforeAdd; i < this.mSpanCount; ++i) {
            spanStart = this.mSpanStarts[i];
            spanEnd = this.mSpanEnds[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if (spanEnd > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            this.sendSpanAdded(this.mSpans[i], spanStart, spanEnd);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$setSpan(Object what, int start, int end, int flags) {
        this.setSpan(true, what, start, end, flags);
    }

    private final void $$robo$$android_text_SpannableStringBuilder$setSpan(boolean send, Object what, int start, int end, int flags) {
        char c;
        char c2;
        this.checkRange("setSpan", start, end);
        int flagsStart = (flags & 0xF0) >> 4;
        if (flagsStart == 3 && start != 0 && start != this.length() && (c2 = this.charAt(start - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must start at paragraph boundary");
        }
        int flagsEnd = flags & 0xF;
        if (flagsEnd == 3 && end != 0 && end != this.length() && (c = this.charAt(end - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must end at paragraph boundary");
        }
        if (flagsStart == 2 && flagsEnd == 1 && start == end) {
            if (send) {
                Log.e("SpannableStringBuilder", "SPAN_EXCLUSIVE_EXCLUSIVE spans cannot have a zero length");
            }
            return;
        }
        int nstart = start;
        int nend = end;
        if (start > this.mGapStart) {
            start += this.mGapLength;
        } else if (start == this.mGapStart && (flagsStart == 2 || flagsStart == 3 && start == this.length())) {
            start += this.mGapLength;
        }
        if (end > this.mGapStart) {
            end += this.mGapLength;
        } else if (end == this.mGapStart && (flagsEnd == 2 || flagsEnd == 3 && end == this.length())) {
            end += this.mGapLength;
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != what) continue;
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanStarts[i] = start;
            this.mSpanEnds[i] = end;
            this.mSpanFlags[i] = flags;
            if (send) {
                this.sendSpanChanged(what, ostart, oend, nstart, nend);
            }
            return;
        }
        this.mSpans = GrowingArrayUtils.append(this.mSpans, this.mSpanCount, what);
        this.mSpanStarts = GrowingArrayUtils.append(this.mSpanStarts, this.mSpanCount, start);
        this.mSpanEnds = GrowingArrayUtils.append(this.mSpanEnds, this.mSpanCount, end);
        this.mSpanFlags = GrowingArrayUtils.append(this.mSpanFlags, this.mSpanCount, flags);
        ++this.mSpanCount;
        if (send) {
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$removeSpan(Object what) {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            if (this.mSpans[i] != what) continue;
            this.removeSpan(i);
            return;
        }
    }

    private final int $$robo$$android_text_SpannableStringBuilder$getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int where = this.mSpanStarts[i];
            if (where > this.mGapStart) {
                where -= this.mGapLength;
            }
            return where;
        }
        return -1;
    }

    private final int $$robo$$android_text_SpannableStringBuilder$getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int where = this.mSpanEnds[i];
            if (where > this.mGapStart) {
                where -= this.mGapLength;
            }
            return where;
        }
        return -1;
    }

    private final int $$robo$$android_text_SpannableStringBuilder$getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return this.mSpanFlags[i];
        }
        return 0;
    }

    private final <T> T[] $$robo$$android_text_SpannableStringBuilder$getSpans(int queryStart, int queryEnd, Class<T> kind) {
        if (kind == null) {
            return ArrayUtils.emptyArray(kind);
        }
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] starts = this.mSpanStarts;
        int[] ends = this.mSpanEnds;
        int[] flags = this.mSpanFlags;
        int gapstart = this.mGapStart;
        int gaplen = this.mGapLength;
        int count = 0;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            int spanStart = starts[i];
            if (spanStart > gapstart) {
                spanStart -= gaplen;
            }
            if (spanStart > queryEnd) continue;
            int spanEnd = ends[i];
            if (spanEnd > gapstart) {
                spanEnd -= gaplen;
            }
            if (spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart) || !kind.isInstance(spans[i])) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = flags[i] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ret, (int)j, (Object)ret, (int)(j + 1), (int)(count - j));
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ret, (int)0, (Object)nret, (int)0, (int)count);
        return nret;
    }

    private final int $$robo$$android_text_SpannableStringBuilder$nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] starts = this.mSpanStarts;
        int[] ends = this.mSpanEnds;
        int gapstart = this.mGapStart;
        int gaplen = this.mGapLength;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = starts[i];
            int en = ends[i];
            if (st > gapstart) {
                st -= gaplen;
            }
            if (en > gapstart) {
                en -= gaplen;
            }
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    private final CharSequence $$robo$$android_text_SpannableStringBuilder$subSequence(int start, int end) {
        return new SpannableStringBuilder(this, start, end);
    }

    private final void $$robo$$android_text_SpannableStringBuilder$getChars(int start, int end, char[] dest, int destoff) {
        this.checkRange("getChars", start, end);
        if (end <= this.mGapStart) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)start, (char[])dest, (int)destoff, (int)(end - start));
        } else if (start >= this.mGapStart) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)(start + this.mGapLength), (char[])dest, (int)destoff, (int)(end - start));
        } else {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)start, (char[])dest, (int)destoff, (int)(this.mGapStart - start));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.mText, (int)(this.mGapStart + this.mGapLength), (char[])dest, (int)(destoff + (this.mGapStart - start)), (int)(end - this.mGapStart));
        }
    }

    private final String $$robo$$android_text_SpannableStringBuilder$toString() {
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        return new String(buf);
    }

    private final String $$robo$$android_text_SpannableStringBuilder$substring(int start, int end) {
        char[] buf = new char[end - start];
        this.getChars(start, end, buf, 0);
        return new String(buf);
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendBeforeTextChanged(TextWatcher[] watchers, int start, int before, int after) {
        int n = watchers.length;
        for (int i = 0; i < n; ++i) {
            watchers[i].beforeTextChanged(this, start, before, after);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendTextChanged(TextWatcher[] watchers, int start, int before, int after) {
        int n = watchers.length;
        for (int i = 0; i < n; ++i) {
            watchers[i].onTextChanged(this, start, before, after);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendAfterTextChanged(TextWatcher[] watchers) {
        int n = watchers.length;
        for (int i = 0; i < n; ++i) {
            watchers[i].afterTextChanged(this);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded(this, what, start, end);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved(this, what, start, end);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$sendSpanChanged(Object what, int oldStart, int oldEnd, int start, int end) {
        SpanWatcher[] spanWatchers = this.getSpans(Math.min(oldStart, start), Math.min(Math.max(oldEnd, end), this.length()), SpanWatcher.class);
        int n = spanWatchers.length;
        for (int i = 0; i < n; ++i) {
            spanWatchers[i].onSpanChanged(this, what, oldStart, oldEnd, start, end);
        }
    }

    private static final String $$robo$$android_text_SpannableStringBuilder$region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    private final void $$robo$$android_text_SpannableStringBuilder$checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " starts before 0");
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$drawText(Canvas c, int start, int end, float x, float y, Paint p) {
        this.checkRange("drawText", start, end);
        if (end <= this.mGapStart) {
            c.drawText(this.mText, start, end - start, x, y, p);
        } else if (start >= this.mGapStart) {
            c.drawText(this.mText, start + this.mGapLength, end - start, x, y, p);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            c.drawText(buf, 0, end - start, x, y, p);
            TextUtils.recycle(buf);
        }
    }

    private final void $$robo$$android_text_SpannableStringBuilder$drawTextRun(Canvas c, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint p) {
        this.checkRange("drawTextRun", start, end);
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (contextEnd <= this.mGapStart) {
            c.drawTextRun(this.mText, start, len, contextStart, contextLen, x, y, isRtl, p);
        } else if (contextStart >= this.mGapStart) {
            c.drawTextRun(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, x, y, isRtl, p);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            c.drawTextRun(buf, start - contextStart, len, 0, contextLen, x, y, isRtl, p);
            TextUtils.recycle(buf);
        }
    }

    private final float $$robo$$android_text_SpannableStringBuilder$measureText(int start, int end, Paint p) {
        float ret;
        this.checkRange("measureText", start, end);
        if (end <= this.mGapStart) {
            ret = p.measureText(this.mText, start, end - start);
        } else if (start >= this.mGapStart) {
            ret = p.measureText(this.mText, start + this.mGapLength, end - start);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.measureText(buf, 0, end - start);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    private final int $$robo$$android_text_SpannableStringBuilder$getTextWidths(int start, int end, float[] widths, Paint p) {
        int ret;
        this.checkRange("getTextWidths", start, end);
        if (end <= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start, end - start, widths);
        } else if (start >= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start + this.mGapLength, end - start, widths);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.getTextWidths(buf, 0, end - start, widths);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    private final float $$robo$$android_text_SpannableStringBuilder$getTextRunAdvances(int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesPos, Paint p) {
        float ret;
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (end <= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start, len, contextStart, contextLen, isRtl, advances, advancesPos);
        } else if (start >= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, isRtl, advances, advancesPos);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesPos);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Deprecated
    private final int $$robo$$android_text_SpannableStringBuilder$getTextRunCursor(int contextStart, int contextEnd, int dir, int offset, int cursorOpt, Paint p) {
        int ret;
        int contextLen = contextEnd - contextStart;
        if (contextEnd <= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart, contextLen, dir, offset, cursorOpt);
        } else if (contextStart >= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart + this.mGapLength, contextLen, dir, offset + this.mGapLength, cursorOpt) - this.mGapLength;
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunCursor(buf, 0, contextLen, dir, offset - contextStart, cursorOpt) + contextStart;
            TextUtils.recycle(buf);
        }
        return ret;
    }

    private final void $$robo$$android_text_SpannableStringBuilder$setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
    }

    private final InputFilter[] $$robo$$android_text_SpannableStringBuilder$getFilters() {
        return this.mFilters;
    }

    private final boolean $$robo$$android_text_SpannableStringBuilder$equals(Object o) {
        Spanned other;
        Object[] otherSpans;
        if (o instanceof Spanned && this.toString().equals(o.toString()) && this.mSpanCount == (otherSpans = (other = (Spanned)o).getSpans(0, other.length(), Object.class)).length) {
            for (int i = 0; i < this.mSpanCount; ++i) {
                Object thisSpan = this.mSpans[i];
                Object otherSpan = otherSpans[i];
                if (!(thisSpan == this ? other != otherSpan || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan) : !thisSpan.equals(otherSpan) || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_text_SpannableStringBuilder$hashCode() {
        int hash = this.toString().hashCode();
        hash = hash * 31 + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object span = this.mSpans[i];
            if (span != this) {
                hash = hash * 31 + span.hashCode();
            }
            hash = hash * 31 + this.getSpanStart(span);
            hash = hash * 31 + this.getSpanEnd(span);
            hash = hash * 31 + this.getSpanFlags(span);
        }
        return hash;
    }

    static void __staticInitializer__() {
        NO_FILTERS = new InputFilter[0];
    }

    private void __constructor__() {
        this.$$robo$$android_text_SpannableStringBuilder$__constructor__();
    }

    public SpannableStringBuilder() {
        this("");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_SpannableStringBuilder$__constructor__(), 0, this);
    }

    private void __constructor__(CharSequence charSequence) {
        this.$$robo$$android_text_SpannableStringBuilder$__constructor__(charSequence);
    }

    public SpannableStringBuilder(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_SpannableStringBuilder$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2) {
        this.$$robo$$android_text_SpannableStringBuilder$__constructor__(charSequence, n, n2);
    }

    public SpannableStringBuilder(CharSequence charSequence, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_SpannableStringBuilder$__constructor__(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    public static SpannableStringBuilder valueOf(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_text_SpannableStringBuilder$valueOf(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Override
    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_SpannableStringBuilder$charAt(int ), 0, this, n);
    }

    @Override
    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_SpannableStringBuilder$length(), 0, this);
    }

    private void resizeFor(int n) {
        InvokeDynamicSupport.bootstrap("resizeFor", $$robo$$android_text_SpannableStringBuilder$resizeFor(int ), 0, this, n);
    }

    private void moveGapTo(int n) {
        InvokeDynamicSupport.bootstrap("moveGapTo", $$robo$$android_text_SpannableStringBuilder$moveGapTo(int ), 0, this, n);
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_text_SpannableStringBuilder$insert(int java.lang.CharSequence int int ), 0, this, n, charSequence, n2, n3);
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_text_SpannableStringBuilder$insert(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    @Override
    public SpannableStringBuilder delete(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("delete", $$robo$$android_text_SpannableStringBuilder$delete(int int ), 0, this, n, n2);
    }

    @Override
    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_text_SpannableStringBuilder$clear(), 0, this);
    }

    @Override
    public void clearSpans() {
        InvokeDynamicSupport.bootstrap("clearSpans", $$robo$$android_text_SpannableStringBuilder$clearSpans(), 0, this);
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_text_SpannableStringBuilder$append(java.lang.CharSequence ), 0, this, charSequence);
    }

    public SpannableStringBuilder append(CharSequence charSequence, Object object, int n) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_text_SpannableStringBuilder$append(java.lang.CharSequence java.lang.Object int ), 0, this, charSequence, object, n);
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_text_SpannableStringBuilder$append(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    @Override
    public SpannableStringBuilder append(char c) {
        return InvokeDynamicSupport.bootstrap("append", $$robo$$android_text_SpannableStringBuilder$append(char ), 0, this, c);
    }

    private void change(int n, int n2, CharSequence charSequence, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("change", $$robo$$android_text_SpannableStringBuilder$change(int int java.lang.CharSequence int int ), 0, this, n, n2, charSequence, n3, n4);
    }

    private int updatedIntervalBound(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("updatedIntervalBound", $$robo$$android_text_SpannableStringBuilder$updatedIntervalBound(int int int int boolean boolean ), 0, this, n, n2, n3, n4, bl, bl2);
    }

    private void removeSpan(int n) {
        InvokeDynamicSupport.bootstrap("removeSpan", $$robo$$android_text_SpannableStringBuilder$removeSpan(int ), 0, this, n);
    }

    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("replace", $$robo$$android_text_SpannableStringBuilder$replace(int int java.lang.CharSequence ), 0, this, n, n2, charSequence);
    }

    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("replace", $$robo$$android_text_SpannableStringBuilder$replace(int int java.lang.CharSequence int int ), 0, this, n, n2, charSequence, n3, n4);
    }

    private static boolean hasNonExclusiveExclusiveSpanAt(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasNonExclusiveExclusiveSpanAt", $$robo$$android_text_SpannableStringBuilder$hasNonExclusiveExclusiveSpanAt(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    private void sendToSpanWatchers(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendToSpanWatchers", $$robo$$android_text_SpannableStringBuilder$sendToSpanWatchers(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void setSpan(Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSpan", $$robo$$android_text_SpannableStringBuilder$setSpan(java.lang.Object int int int ), 0, this, object, n, n2, n3);
    }

    private void setSpan(boolean bl, Object object, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setSpan", $$robo$$android_text_SpannableStringBuilder$setSpan(boolean java.lang.Object int int int ), 0, this, bl, object, n, n2, n3);
    }

    @Override
    public void removeSpan(Object object) {
        InvokeDynamicSupport.bootstrap("removeSpan", $$robo$$android_text_SpannableStringBuilder$removeSpan(java.lang.Object ), 0, this, object);
    }

    @Override
    public int getSpanStart(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanStart", $$robo$$android_text_SpannableStringBuilder$getSpanStart(java.lang.Object ), 0, this, object);
    }

    @Override
    public int getSpanEnd(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanEnd", $$robo$$android_text_SpannableStringBuilder$getSpanEnd(java.lang.Object ), 0, this, object);
    }

    @Override
    public int getSpanFlags(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getSpanFlags", $$robo$$android_text_SpannableStringBuilder$getSpanFlags(java.lang.Object ), 0, this, object);
    }

    @Override
    public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("getSpans", $$robo$$android_text_SpannableStringBuilder$getSpans(int int java.lang.Class<T> ), 0, this, n, n2, clazz);
    }

    @Override
    public int nextSpanTransition(int n, int n2, Class clazz) {
        return (int)InvokeDynamicSupport.bootstrap("nextSpanTransition", $$robo$$android_text_SpannableStringBuilder$nextSpanTransition(int int java.lang.Class ), 0, this, n, n2, clazz);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_SpannableStringBuilder$subSequence(int int ), 0, this, n, n2);
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_text_SpannableStringBuilder$getChars(int int char[] int ), 0, this, n, n2, cArray, n3);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_SpannableStringBuilder$toString(), 0, this);
    }

    public String substring(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("substring", $$robo$$android_text_SpannableStringBuilder$substring(int int ), 0, this, n, n2);
    }

    private void sendBeforeTextChanged(TextWatcher[] textWatcherArray, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendBeforeTextChanged", $$robo$$android_text_SpannableStringBuilder$sendBeforeTextChanged(android.text.TextWatcher[] int int int ), 0, this, textWatcherArray, n, n2, n3);
    }

    private void sendTextChanged(TextWatcher[] textWatcherArray, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendTextChanged", $$robo$$android_text_SpannableStringBuilder$sendTextChanged(android.text.TextWatcher[] int int int ), 0, this, textWatcherArray, n, n2, n3);
    }

    private void sendAfterTextChanged(TextWatcher[] textWatcherArray) {
        InvokeDynamicSupport.bootstrap("sendAfterTextChanged", $$robo$$android_text_SpannableStringBuilder$sendAfterTextChanged(android.text.TextWatcher[] ), 0, this, textWatcherArray);
    }

    private void sendSpanAdded(Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendSpanAdded", $$robo$$android_text_SpannableStringBuilder$sendSpanAdded(java.lang.Object int int ), 0, this, object, n, n2);
    }

    private void sendSpanRemoved(Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendSpanRemoved", $$robo$$android_text_SpannableStringBuilder$sendSpanRemoved(java.lang.Object int int ), 0, this, object, n, n2);
    }

    private void sendSpanChanged(Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("sendSpanChanged", $$robo$$android_text_SpannableStringBuilder$sendSpanChanged(java.lang.Object int int int int ), 0, this, object, n, n2, n3, n4);
    }

    private static String region(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("region", $$robo$$android_text_SpannableStringBuilder$region(int int ), 0, (int)n, (int)n2);
    }

    private void checkRange(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("checkRange", $$robo$$android_text_SpannableStringBuilder$checkRange(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public void drawText(Canvas canvas, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_text_SpannableStringBuilder$drawText(android.graphics.Canvas int int float float android.graphics.Paint ), 0, this, canvas, n, n2, f, f2, paint);
    }

    @Override
    public void drawTextRun(Canvas canvas, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_text_SpannableStringBuilder$drawTextRun(android.graphics.Canvas int int int int float float boolean android.graphics.Paint ), 0, this, canvas, n, n2, n3, n4, f, f2, bl, paint);
    }

    @Override
    public float measureText(int n, int n2, Paint paint) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_text_SpannableStringBuilder$measureText(int int android.graphics.Paint ), 0, this, n, n2, paint);
    }

    @Override
    public int getTextWidths(int n, int n2, float[] fArray, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_text_SpannableStringBuilder$getTextWidths(int int float[] android.graphics.Paint ), 0, this, n, n2, fArray, paint);
    }

    @Override
    public float getTextRunAdvances(int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5, Paint paint) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_text_SpannableStringBuilder$getTextRunAdvances(int int int int boolean float[] int android.graphics.Paint ), 0, this, n, n2, n3, n4, bl, fArray, n5, paint);
    }

    @Override
    @Deprecated
    public int getTextRunCursor(int n, int n2, int n3, int n4, int n5, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_text_SpannableStringBuilder$getTextRunCursor(int int int int int android.graphics.Paint ), 0, this, n, n2, n3, n4, n5, paint);
    }

    @Override
    public void setFilters(InputFilter[] inputFilterArray) {
        InvokeDynamicSupport.bootstrap("setFilters", $$robo$$android_text_SpannableStringBuilder$setFilters(android.text.InputFilter[] ), 0, this, inputFilterArray);
    }

    @Override
    public InputFilter[] getFilters() {
        return InvokeDynamicSupport.bootstrap("getFilters", $$robo$$android_text_SpannableStringBuilder$getFilters(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_text_SpannableStringBuilder$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_text_SpannableStringBuilder$hashCode(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SpannableStringBuilder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpannableStringBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

