/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StaticLayout
extends Layout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "StaticLayout";
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private int mColumns;
    private int mEllipsizedWidth;
    private static int COLUMNS_NORMAL = 3;
    private static int COLUMNS_ELLIPSIZE = 5;
    private static int START = 0;
    private static int DIR = 0;
    private static int TAB = 0;
    private static int TOP = 1;
    private static int DESCENT = 2;
    private static int ELLIPSIS_START = 3;
    private static int ELLIPSIS_COUNT = 4;
    private int[] mLines;
    private Layout.Directions[] mLineDirections;
    private int mMaximumVisibleLineCount;
    private static int START_MASK = 0x1FFFFFFF;
    private static int DIR_SHIFT = 30;
    private static int TAB_MASK = 0x20000000;
    private static int TAB_INCREMENT = 20;
    private static char CHAR_NEW_LINE = '\n';
    private static char CHAR_TAB = '\t';
    private static char CHAR_SPACE = ' ';
    private static char CHAR_ZWSP = '\u200b';
    private static double EXTRA_ROUNDING = 0.5;
    private static int CHAR_FIRST_HIGH_SURROGATE = 55296;
    private static int CHAR_LAST_LOW_SURROGATE = 57343;
    private MeasuredText mMeasured;
    private Paint.FontMetricsInt mFontMetricsInt;

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, int maxLines) {
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        this.mFontMetricsInt = new Paint.FontMetricsInt();
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 5;
        } else {
            this.mColumns = 3;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMaximumVisibleLineCount = maxLines;
        this.mMeasured = MeasuredText.obtain();
        this.generate(source, bufstart, bufend, paint, outerwidth, textDir, spacingmult, spacingadd, includepad, includepad, ellipsizedWidth, ellipsize);
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
        this.mFontMetricsInt = null;
    }

    private void $$robo$$android_text_StaticLayout$__constructor__(CharSequence text) {
        this.mMaximumVisibleLineCount = Integer.MAX_VALUE;
        this.mFontMetricsInt = new Paint.FontMetricsInt();
        this.mColumns = 5;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2 * this.mColumns);
        this.mLines = new int[this.mLineDirections.length];
        this.mMeasured = MeasuredText.obtain();
    }

    private final void $$robo$$android_text_StaticLayout$generate(CharSequence source, int bufStart, int bufEnd, TextPaint paint, int outerWidth, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, boolean trackpad, float ellipsizedWidth, TextUtils.TruncateAt ellipsize) {
        int[] breakOpp = null;
        String localeLanguageTag = paint.getTextLocale().toLanguageTag();
        this.mLineCount = 0;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = this.mFontMetricsInt;
        int[] chooseHtv = null;
        MeasuredText measured = this.mMeasured;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        int paraStart = bufStart;
        while (paraStart <= bufEnd) {
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufEnd);
            paraEnd = paraEnd < 0 ? bufEnd : ++paraEnd;
            int firstWidthLineLimit = this.mLineCount + 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    int lmsFirstLine = this.getLineForOffset(spanned.getSpanStart(lms2));
                    firstWidthLineLimit = Math.max(firstWidthLineLimit, lmsFirstLine + lms2.getLeadingMarginLineCount());
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length != 0) {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = ArrayUtils.newUnpaddedIntArray(chooseHt.length);
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, textDir);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            breakOpp = StaticLayout.nLineBreakOpportunities(localeLanguageTag, chs, paraEnd - paraStart, breakOpp);
            int breakOppIndex = 0;
            int width = firstWidth;
            float w = 0.0f;
            int here = paraStart;
            int ok = paraStart;
            float okWidth = w;
            int okAscent = 0;
            int okDescent = 0;
            int okTop = 0;
            int okBottom = 0;
            int fit = paraStart;
            float fitWidth = w;
            int fitAscent = 0;
            int fitDescent = 0;
            int fitTop = 0;
            int fitBottom = 0;
            float fitWidthGraphing = w;
            boolean hasTabOrEmoji = false;
            boolean hasTab = false;
            Layout.TabStops tabStops = null;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanLen;
                int spanEnd;
                if (spanned == null) {
                    spanEnd = paraEnd;
                    spanLen = spanEnd - spanStart;
                    measured.addStyleRun(paint, spanLen, fm);
                } else {
                    spanEnd = spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    spanLen = spanEnd - spanStart;
                    MetricAffectingSpan[] spans = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, spanned, MetricAffectingSpan.class);
                    measured.addStyleRun(paint, spans, spanLen, fm);
                }
                int fmTop = fm.top;
                int fmBottom = fm.bottom;
                int fmAscent = fm.ascent;
                int fmDescent = fm.descent;
                for (int j = spanStart; j < spanEnd; ++j) {
                    boolean moreChars;
                    float currentTextWidth;
                    int bottom;
                    int top;
                    int below;
                    int above;
                    int endPos;
                    boolean isSpaceOrTab;
                    char c = chs[j - paraStart];
                    if (c != '\n') {
                        if (c == '\t') {
                            if (!hasTab) {
                                Object[] spans;
                                hasTab = true;
                                hasTabOrEmoji = true;
                                if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                                    tabStops = new Layout.TabStops(20, spans);
                                }
                            }
                            w = tabStops != null ? tabStops.nextTab(w) : Layout.TabStops.nextDefaultStop(w, 20);
                        } else if (c >= '\ud800' && c <= '\udfff' && j + 1 < spanEnd) {
                            int emoji = Character.codePointAt(chs, j - paraStart);
                            if (emoji >= MIN_EMOJI && emoji <= MAX_EMOJI) {
                                Bitmap bm = EMOJI_FACTORY.getBitmapFromAndroidPua(emoji);
                                if (bm != null) {
                                    TextPaint whichPaint = spanned == null ? paint : this.mWorkPaint;
                                    float wid = (float)bm.getWidth() * -whichPaint.ascent() / (float)bm.getHeight();
                                    w += wid;
                                    hasTabOrEmoji = true;
                                    ++j;
                                } else {
                                    w += widths[j - paraStart];
                                }
                            } else {
                                w += widths[j - paraStart];
                            }
                        } else {
                            w += widths[j - paraStart];
                        }
                    }
                    boolean bl = isSpaceOrTab = c == ' ' || c == '\t' || c == '\u200b';
                    if (w <= (float)width || isSpaceOrTab) {
                        boolean isLineBreak;
                        fitWidth = w;
                        if (!isSpaceOrTab) {
                            fitWidthGraphing = w;
                        }
                        fit = j + 1;
                        if (fmTop < fitTop) {
                            fitTop = fmTop;
                        }
                        if (fmAscent < fitAscent) {
                            fitAscent = fmAscent;
                        }
                        if (fmDescent > fitDescent) {
                            fitDescent = fmDescent;
                        }
                        if (fmBottom > fitBottom) {
                            fitBottom = fmBottom;
                        }
                        while (breakOpp[breakOppIndex] != -1 && breakOpp[breakOppIndex] < j - paraStart + 1) {
                            ++breakOppIndex;
                        }
                        boolean bl2 = isLineBreak = breakOppIndex < breakOpp.length && breakOpp[breakOppIndex] == j - paraStart + 1;
                        if (!isLineBreak) continue;
                        okWidth = fitWidthGraphing;
                        ok = j + 1;
                        if (fitTop < okTop) {
                            okTop = fitTop;
                        }
                        if (fitAscent < okAscent) {
                            okAscent = fitAscent;
                        }
                        if (fitDescent > okDescent) {
                            okDescent = fitDescent;
                        }
                        if (fitBottom <= okBottom) continue;
                        okBottom = fitBottom;
                        continue;
                    }
                    if (ok != here) {
                        endPos = ok;
                        above = okAscent;
                        below = okDescent;
                        top = okTop;
                        bottom = okBottom;
                        currentTextWidth = okWidth;
                        moreChars = j + 1 < spanEnd;
                    } else if (fit != here) {
                        endPos = fit;
                        above = fitAscent;
                        below = fitDescent;
                        top = fitTop;
                        bottom = fitBottom;
                        currentTextWidth = fitWidth;
                        moreChars = j + 1 < spanEnd;
                    } else {
                        for (endPos = here + 1; endPos < spanEnd && widths[endPos - paraStart] == 0.0f; ++endPos) {
                        }
                        above = fmAscent;
                        below = fmDescent;
                        top = fmTop;
                        bottom = fmBottom;
                        currentTextWidth = widths[here - paraStart];
                        moreChars = endPos < spanEnd;
                    }
                    v = this.out(source, here, endPos, above, below, top, bottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, chdirs, dir, easy, bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, currentTextWidth, paint, moreChars);
                    here = endPos;
                    j = here - 1;
                    ok = fit = here;
                    fitWidthGraphing = w = 0.0f;
                    fitBottom = 0;
                    fitTop = 0;
                    fitDescent = 0;
                    fitAscent = 0;
                    okBottom = 0;
                    okTop = 0;
                    okDescent = 0;
                    okAscent = 0;
                    if (--firstWidthLineLimit <= 0) {
                        width = restWidth;
                    }
                    if (here < spanStart) {
                        measured.setPos(here);
                        spanEnd = here;
                        break;
                    }
                    if (this.mLineCount < this.mMaximumVisibleLineCount) continue;
                    return;
                }
                spanStart = spanEnd;
            }
            if (paraEnd != here && this.mLineCount < this.mMaximumVisibleLineCount) {
                if (!(fitTop | fitBottom | fitDescent | fitAscent)) {
                    paint.getFontMetricsInt(fm);
                    fitTop = fm.top;
                    fitBottom = fm.bottom;
                    fitAscent = fm.ascent;
                    fitDescent = fm.descent;
                }
                v = this.out(source, here, paraEnd, fitAscent, fitDescent, fitTop, fitBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, chdirs, dir, easy, bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, w, paint, paraEnd != bufEnd);
            }
            paraStart = paraEnd;
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            measured.setPara(source, bufStart, bufEnd, textDir);
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, false, needMultiply, measured.mLevels, measured.mDir, measured.mEasy, bufEnd, includepad, trackpad, null, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private final int $$robo$$android_text_StaticLayout$out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, boolean hasTabOrEmoji, boolean needMultiply, byte[] chdirs, int dir, boolean easy, int bufEnd, boolean includePad, boolean trackPad, char[] chs, float[] widths, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            Layout.Directions[] grow2 = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(want));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mLineDirections, (int)0, (Object)grow2, (int)0, (int)this.mLineDirections.length);
            this.mLineDirections = grow2;
            int[] grow = new int[grow2.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])lines, (int)0, (int[])grow, (int)0, (int)lines.length);
            this.mLines = grow;
            lines = grow;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        boolean firstLine = j == 0;
        boolean currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        boolean bl = lastLine = currentLineIsTheLastVisibleOne || end == bufEnd;
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && !lastLine ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        if (hasTabOrEmoji) {
            int n = off + 0;
            lines[n] = lines[n] | 0x20000000;
        }
        int n = off + 0;
        lines[n] = lines[n] | dir << 30;
        Layout.Directions linedirs = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[j] = easy ? linedirs : AndroidBidi.directions(dir, chdirs, start - widthStart, chs, start - widthStart, end - start);
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(start, end, widths, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint, forceEllipsis);
            }
        }
        ++this.mLineCount;
        return v;
    }

    private final void $$robo$$android_text_StaticLayout$calculateEllipsis(int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis) {
        if (textWidth <= avail && !forceEllipsis) {
            this.mLines[this.mColumns * line + 3] = 0;
            this.mLines[this.mColumns * line + 4] = 0;
            return;
        }
        float ellipsisWidth = paint.measureText(where == TextUtils.TruncateAt.END_SMALL ? ELLIPSIS_TWO_DOTS : ELLIPSIS_NORMAL, 0, 1);
        int ellipsisStart = 0;
        int ellipsisCount = 0;
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                float w;
                int i;
                float sum = 0.0f;
                for (i = len; i >= 0 && !((w = widths[i - 1 + lineStart - widthStart]) + sum + ellipsisWidth > avail); --i) {
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
            } else if (Log.isLoggable("StaticLayout", 5)) {
                Log.w("StaticLayout", "Start Ellipsis only supported with one line");
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE || where == TextUtils.TruncateAt.END_SMALL) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + lineStart - widthStart]) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
            if (forceEllipsis && ellipsisCount == 0 && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            }
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            float w2;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right >= 0 && !((w2 = widths[right - 1 + lineStart - widthStart]) + rsum > ravail); --right) {
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = widths[left + lineStart - widthStart]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else if (Log.isLoggable("StaticLayout", 5)) {
            Log.w("StaticLayout", "Middle Ellipsis only supported with one line");
        }
        this.mLines[this.mColumns * line + 3] = ellipsisStart;
        this.mLines[this.mColumns * line + 4] = ellipsisCount;
    }

    private final int $$robo$$android_text_StaticLayout$getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    private final int $$robo$$android_text_StaticLayout$getLineCount() {
        return this.mLineCount;
    }

    private final int $$robo$$android_text_StaticLayout$getLineTop(int line) {
        int top = this.mLines[this.mColumns * line + 1];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount && line != this.mLineCount) {
            top += this.getBottomPadding();
        }
        return top;
    }

    private final int $$robo$$android_text_StaticLayout$getLineDescent(int line) {
        int descent = this.mLines[this.mColumns * line + 2];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount - 1 && line != this.mLineCount) {
            descent += this.getBottomPadding();
        }
        return descent;
    }

    private final int $$robo$$android_text_StaticLayout$getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    private final int $$robo$$android_text_StaticLayout$getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    private final boolean $$robo$$android_text_StaticLayout$getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    private final Layout.Directions $$robo$$android_text_StaticLayout$getLineDirections(int line) {
        return this.mLineDirections[line];
    }

    private final int $$robo$$android_text_StaticLayout$getTopPadding() {
        return this.mTopPadding;
    }

    private final int $$robo$$android_text_StaticLayout$getBottomPadding() {
        return this.mBottomPadding;
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsisCount(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsisStart(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 3];
    }

    private final int $$robo$$android_text_StaticLayout$getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    private final void $$robo$$android_text_StaticLayout$prepare() {
        this.mMeasured = MeasuredText.obtain();
    }

    private final void $$robo$$android_text_StaticLayout$finish() {
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
    }

    private static final int[] $$robo$$android_text_StaticLayout$nLineBreakOpportunities(String string2, char[] cArray, int n, int[] nArray) {
        return null;
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, textPaint, n, alignment, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, f, f2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float boolean ), 0, this, charSequence, textPaint, n, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, 0, charSequence.length(), textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean ), 0, this, charSequence, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, null, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment float float boolean ), 0, this, charSequence, n, n2, textPaint, n3, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl) {
        this(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, null, 0, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean ), 0, this, charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, truncateAt, n4);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4) {
        this(charSequence, n, n2, textPaint, n3, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2, bl, truncateAt, n4, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment float float boolean android.text.TextUtils$TruncateAt int ), 0, this, charSequence, n, n2, textPaint, n3, alignment, f, f2, bl, truncateAt, n4);
    }

    private void __constructor__(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4, int n5) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, truncateAt, n4, n5);
    }

    public StaticLayout(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n4, int n5) {
        super(truncateAt == null ? charSequence : (charSequence instanceof Spanned ? new Layout.SpannedEllipsizer(charSequence) : new Layout.Ellipsizer(charSequence)), textPaint, n3, alignment, textDirectionHeuristic, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence int int android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean android.text.TextUtils$TruncateAt int int ), 0, this, charSequence, n, n2, textPaint, n3, alignment, textDirectionHeuristic, f, f2, bl, truncateAt, n4, n5);
    }

    private void __constructor__(CharSequence charSequence) {
        this.$$robo$$android_text_StaticLayout$__constructor__(charSequence);
    }

    StaticLayout(CharSequence charSequence) {
        super(charSequence, null, 0, null, 0.0f, 0.0f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_StaticLayout$__constructor__(java.lang.CharSequence ), 0, this, charSequence);
    }

    void generate(CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, boolean bl2, float f3, TextUtils.TruncateAt truncateAt) {
        InvokeDynamicSupport.bootstrap("generate", $$robo$$android_text_StaticLayout$generate(java.lang.CharSequence int int android.text.TextPaint int android.text.TextDirectionHeuristic float float boolean boolean float android.text.TextUtils$TruncateAt ), 0, this, charSequence, n, n2, textPaint, n3, textDirectionHeuristic, f, f2, bl, bl2, f3, truncateAt);
    }

    private int out(CharSequence charSequence, int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, LineHeightSpan[] lineHeightSpanArray, int[] nArray, Paint.FontMetricsInt fontMetricsInt, boolean bl, boolean bl2, byte[] byArray, int n8, boolean bl3, int n9, boolean bl4, boolean bl5, char[] cArray, float[] fArray, int n10, TextUtils.TruncateAt truncateAt, float f3, float f4, TextPaint textPaint, boolean bl6) {
        return (int)InvokeDynamicSupport.bootstrap("out", $$robo$$android_text_StaticLayout$out(java.lang.CharSequence int int int int int int int float float android.text.style.LineHeightSpan[] int[] android.graphics.Paint$FontMetricsInt boolean boolean byte[] int boolean int boolean boolean char[] float[] int android.text.TextUtils$TruncateAt float float android.text.TextPaint boolean ), 0, this, charSequence, n, n2, n3, n4, n5, n6, n7, f, f2, lineHeightSpanArray, nArray, fontMetricsInt, bl, bl2, byArray, n8, bl3, n9, bl4, bl5, cArray, fArray, n10, truncateAt, f3, f4, textPaint, bl6);
    }

    private void calculateEllipsis(int n, int n2, float[] fArray, int n3, float f, TextUtils.TruncateAt truncateAt, int n4, float f2, TextPaint textPaint, boolean bl) {
        InvokeDynamicSupport.bootstrap("calculateEllipsis", $$robo$$android_text_StaticLayout$calculateEllipsis(int int float[] int float android.text.TextUtils$TruncateAt int float android.text.TextPaint boolean ), 0, this, n, n2, fArray, n3, f, truncateAt, n4, f2, textPaint, bl);
    }

    @Override
    public int getLineForVertical(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineForVertical", $$robo$$android_text_StaticLayout$getLineForVertical(int ), 0, this, n);
    }

    @Override
    public int getLineCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLineCount", $$robo$$android_text_StaticLayout$getLineCount(), 0, this);
    }

    @Override
    public int getLineTop(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineTop", $$robo$$android_text_StaticLayout$getLineTop(int ), 0, this, n);
    }

    @Override
    public int getLineDescent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineDescent", $$robo$$android_text_StaticLayout$getLineDescent(int ), 0, this, n);
    }

    @Override
    public int getLineStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineStart", $$robo$$android_text_StaticLayout$getLineStart(int ), 0, this, n);
    }

    @Override
    public int getParagraphDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphDirection", $$robo$$android_text_StaticLayout$getParagraphDirection(int ), 0, this, n);
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLineContainsTab", $$robo$$android_text_StaticLayout$getLineContainsTab(int ), 0, this, n);
    }

    @Override
    public Layout.Directions getLineDirections(int n) {
        return InvokeDynamicSupport.bootstrap("getLineDirections", $$robo$$android_text_StaticLayout$getLineDirections(int ), 0, this, n);
    }

    @Override
    public int getTopPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPadding", $$robo$$android_text_StaticLayout$getTopPadding(), 0, this);
    }

    @Override
    public int getBottomPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPadding", $$robo$$android_text_StaticLayout$getBottomPadding(), 0, this);
    }

    @Override
    public int getEllipsisCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisCount", $$robo$$android_text_StaticLayout$getEllipsisCount(int ), 0, this, n);
    }

    @Override
    public int getEllipsisStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisStart", $$robo$$android_text_StaticLayout$getEllipsisStart(int ), 0, this, n);
    }

    @Override
    public int getEllipsizedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsizedWidth", $$robo$$android_text_StaticLayout$getEllipsizedWidth(), 0, this);
    }

    void prepare() {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_text_StaticLayout$prepare(), 0, this);
    }

    void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_text_StaticLayout$finish(), 0, this);
    }

    private static final native /* synthetic */ int[] $$robo$$nLineBreakOpportunities$nativeBinding(String var0, char[] var1, int var2, int[] var3);

    private static int[] nLineBreakOpportunities(String string2, char[] cArray, int n, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("nLineBreakOpportunities", $$robo$$android_text_StaticLayout$nLineBreakOpportunities(java.lang.String char[] int int[] ), 1, (String)string2, (char[])cArray, (int)n, (int[])nArray);
    }

    public /* synthetic */ StaticLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StaticLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

