/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.SpanSet;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextLine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private TextPaint mPaint;
    private CharSequence mText;
    private int mStart;
    private int mLen;
    private int mDir;
    private Layout.Directions mDirections;
    private boolean mHasTabs;
    private Layout.TabStops mTabs;
    private char[] mChars;
    private boolean mCharsValid;
    private Spanned mSpanned;
    private TextPaint mWorkPaint;
    private SpanSet<MetricAffectingSpan> mMetricAffectingSpanSpanSet;
    private SpanSet<CharacterStyle> mCharacterStyleSpanSet;
    private SpanSet<ReplacementSpan> mReplacementSpanSpanSet;
    private static TextLine[] sCached;
    private static int TAB_INCREMENT = 20;

    private void $$robo$$android_text_TextLine$__constructor__() {
        this.mWorkPaint = new TextPaint();
        this.mMetricAffectingSpanSpanSet = new SpanSet<MetricAffectingSpan>(MetricAffectingSpan.class);
        this.mCharacterStyleSpanSet = new SpanSet<CharacterStyle>(CharacterStyle.class);
        this.mReplacementSpanSpanSet = new SpanSet<ReplacementSpan>(ReplacementSpan.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TextLine $$robo$$android_text_TextLine$obtain() {
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            int i = sCached.length;
            while (--i >= 0) {
                if (sCached[i] == null) continue;
                TextLine tl = sCached[i];
                TextLine.sCached[i] = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                return tl;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            TextLine tl = new TextLine();
            return tl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TextLine $$robo$$android_text_TextLine$recycle(TextLine tl) {
        tl.mText = null;
        tl.mPaint = null;
        tl.mDirections = null;
        tl.mMetricAffectingSpanSpanSet.recycle();
        tl.mCharacterStyleSpanSet.recycle();
        tl.mReplacementSpanSpanSet.recycle();
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            for (int i = 0; i < sCached.length; ++i) {
                if (sCached[i] != null) continue;
                TextLine.sCached[i] = tl;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    private final void $$robo$$android_text_TextLine$set(TextPaint paint, CharSequence text, int start, int limit, int dir, Layout.Directions directions, boolean hasTabs, Layout.TabStops tabStops) {
        this.mPaint = paint;
        this.mText = text;
        this.mStart = start;
        this.mLen = limit - start;
        this.mDir = dir;
        this.mDirections = directions;
        if (this.mDirections == null) {
            throw new IllegalArgumentException("Directions cannot be null");
        }
        this.mHasTabs = hasTabs;
        this.mSpanned = null;
        boolean hasReplacement = false;
        if (text instanceof Spanned) {
            this.mSpanned = (Spanned)text;
            this.mReplacementSpanSpanSet.init(this.mSpanned, start, limit);
            hasReplacement = this.mReplacementSpanSpanSet.numberOfSpans > 0;
        }
        boolean bl = this.mCharsValid = hasReplacement || hasTabs || directions != Layout.DIRS_ALL_LEFT_TO_RIGHT;
        if (this.mCharsValid) {
            if (this.mChars == null || this.mChars.length < this.mLen) {
                this.mChars = ArrayUtils.newUnpaddedCharArray(this.mLen);
            }
            TextUtils.getChars(text, start, limit, this.mChars, 0);
            if (hasReplacement) {
                char[] chars = this.mChars;
                int i = start;
                while (i < limit) {
                    int inext = this.mReplacementSpanSpanSet.getNextTransition(i, limit);
                    if (this.mReplacementSpanSpanSet.hasSpansIntersecting(i, inext)) {
                        chars[i - start] = 65532;
                        int e = inext - start;
                        for (int j = i - start + 1; j < e; ++j) {
                            chars[j] = 65279;
                        }
                    }
                    i = inext;
                }
            }
        }
        this.mTabs = tabStops;
    }

    /*
     * Unable to fully structure code
     */
    private final void $$robo$$android_text_TextLine$draw(Canvas c, float x, int top, int y, int bottom) {
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                this.drawRun(c, 0, this.mLen, false, x, top, y, bottom, false);
                return;
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                this.drawRun(c, 0, this.mLen, true, x, top, y, bottom, false);
                return;
            }
        }
        h = 0.0f;
        runs = this.mDirections.mDirections;
        emojiRect = null;
        lastRunIndex = runs.length - 2;
        for (i = 0; i < runs.length; i += 2) {
            runStart = runs[i];
            runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            segstart = runStart;
            v0 = j = this.mHasTabs != false ? runStart : runLimit;
            while (j <= runLimit) {
                block13: {
                    codept = 0;
                    bm = null;
                    if (!this.mHasTabs || j >= runLimit || (codept = this.mChars[j]) < 55296 || codept >= 56320 || j + 1 >= runLimit) ** GOTO lbl-1000
                    codept = Character.codePointAt(this.mChars, j);
                    if (codept < Layout.MIN_EMOJI || codept > Layout.MAX_EMOJI) break block13;
                    bm = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
                    ** GOTO lbl-1000
                }
                if (codept > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9 || bm != null) {
                    h += this.drawRun(c, segstart, j, runIsRtl, x + h, top, y, bottom, i != lastRunIndex || j != this.mLen);
                    if (codept == 9) {
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                    } else if (bm != null) {
                        bmAscent = this.ascent(j);
                        bitmapHeight = bm.getHeight();
                        scale = -bmAscent / bitmapHeight;
                        width = (float)bm.getWidth() * scale;
                        if (emojiRect == null) {
                            emojiRect = new RectF();
                        }
                        emojiRect.set(x + h, (float)y + bmAscent, x + h + width, y);
                        c.drawBitmap(bm, null, emojiRect, (Paint)this.mPaint);
                        h += width;
                        ++j;
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
    }

    private final float $$robo$$android_text_TextLine$metrics(Paint.FontMetricsInt fmi) {
        return this.measure(this.mLen, false, fmi);
    }

    /*
     * Unable to fully structure code
     */
    private final float $$robo$$android_text_TextLine$measure(int offset, boolean trailing, Paint.FontMetricsInt fmi) {
        v0 = target = trailing != false ? offset - 1 : offset;
        if (target < 0) {
            return 0.0f;
        }
        h = 0.0f;
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                return this.measureRun(0, offset, this.mLen, false, fmi);
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                return this.measureRun(0, offset, this.mLen, true, fmi);
            }
        }
        chars = this.mChars;
        runs = this.mDirections.mDirections;
        for (i = 0; i < runs.length; i += 2) {
            runStart = runs[i];
            runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            segstart = runStart;
            v1 = j = this.mHasTabs != false ? runStart : runLimit;
            while (j <= runLimit) {
                block16: {
                    codept = 0;
                    bm = null;
                    if (!this.mHasTabs || j >= runLimit || (codept = chars[j]) < 55296 || codept >= 56320 || j + 1 >= runLimit) ** GOTO lbl-1000
                    codept = Character.codePointAt(chars, j);
                    if (codept < Layout.MIN_EMOJI || codept > Layout.MAX_EMOJI) break block16;
                    bm = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
                    ** GOTO lbl-1000
                }
                if (codept > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9 || bm != null) {
                    inSegment = target >= segstart && target < j;
                    v2 = advance = this.mDir == -1 == runIsRtl;
                    if (inSegment && advance) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, fmi);
                    }
                    w = this.measureRun(segstart, j, j, runIsRtl, fmi);
                    h += advance != false ? w : -w;
                    if (inSegment) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, null);
                    }
                    if (codept == 9) {
                        if (offset == j) {
                            return h;
                        }
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                        if (target == j) {
                            return h;
                        }
                    }
                    if (bm != null) {
                        bmAscent = this.ascent(j);
                        wid = (float)bm.getWidth() * -bmAscent / (float)bm.getHeight();
                        h += (float)this.mDir * wid;
                        ++j;
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
        return h;
    }

    private final float $$robo$$android_text_TextLine$drawRun(Canvas c, int start, int limit, boolean runIsRtl, float x, int top, int y, int bottom, boolean needWidth) {
        if (this.mDir == 1 == runIsRtl) {
            float w = -this.measureRun(start, limit, limit, runIsRtl, null);
            this.handleRun(start, limit, limit, runIsRtl, c, x + w, top, y, bottom, null, false);
            return w;
        }
        return this.handleRun(start, limit, limit, runIsRtl, c, x, top, y, bottom, null, needWidth);
    }

    private final float $$robo$$android_text_TextLine$measureRun(int start, int offset, int limit, boolean runIsRtl, Paint.FontMetricsInt fmi) {
        return this.handleRun(start, offset, limit, runIsRtl, null, 0.0f, 0, 0, 0, fmi, true);
    }

    private final int $$robo$$android_text_TextLine$getOffsetToLeftRightOf(int cursor, boolean toLeft) {
        int newCaret;
        block13: {
            boolean advance;
            int lineEnd;
            int lineStart;
            block14: {
                int otherRunIndex;
                int runIndex;
                lineStart = 0;
                lineEnd = this.mLen;
                boolean paraIsRtl = this.mDir == -1;
                int[] runs = this.mDirections.mDirections;
                int runLevel = 0;
                int runStart = lineStart;
                int runLimit = lineEnd;
                newCaret = -1;
                boolean trailing = false;
                if (cursor == lineStart) {
                    runIndex = -2;
                } else if (cursor == lineEnd) {
                    runIndex = runs.length;
                } else {
                    boolean runIsRtl;
                    boolean advance2;
                    block0: for (runIndex = 0; runIndex < runs.length; runIndex += 2) {
                        runStart = lineStart + runs[runIndex];
                        if (cursor < runStart) continue;
                        runLimit = runStart + (runs[runIndex + 1] & 0x3FFFFFF);
                        if (runLimit > lineEnd) {
                            runLimit = lineEnd;
                        }
                        if (cursor >= runLimit) continue;
                        runLevel = runs[runIndex + 1] >>> 26 & 0x3F;
                        if (cursor != runStart) break;
                        int pos = cursor - 1;
                        for (int prevRunIndex = 0; prevRunIndex < runs.length; prevRunIndex += 2) {
                            int prevRunLevel;
                            int prevRunStart = lineStart + runs[prevRunIndex];
                            if (pos < prevRunStart) continue;
                            int prevRunLimit = prevRunStart + (runs[prevRunIndex + 1] & 0x3FFFFFF);
                            if (prevRunLimit > lineEnd) {
                                prevRunLimit = lineEnd;
                            }
                            if (pos >= prevRunLimit || (prevRunLevel = runs[prevRunIndex + 1] >>> 26 & 0x3F) >= runLevel) continue;
                            runIndex = prevRunIndex;
                            runLevel = prevRunLevel;
                            runStart = prevRunStart;
                            runLimit = prevRunLimit;
                            trailing = true;
                            break block0;
                        }
                        break;
                    }
                    if (runIndex != runs.length && (cursor != ((advance2 = toLeft == (runIsRtl = runLevel & true)) ? runLimit : runStart) || advance2 != trailing) && (newCaret = this.getOffsetBeforeAfter(runIndex, runStart, runLimit, runIsRtl, cursor, advance2)) != (advance2 ? runLimit : runStart)) {
                        return newCaret;
                    }
                }
                while ((otherRunIndex = runIndex + ((advance = toLeft == paraIsRtl) ? 2 : -2)) >= 0 && otherRunIndex < runs.length) {
                    int otherRunLevel;
                    int otherRunStart = lineStart + runs[otherRunIndex];
                    int otherRunLimit = otherRunStart + (runs[otherRunIndex + 1] & 0x3FFFFFF);
                    if (otherRunLimit > lineEnd) {
                        otherRunLimit = lineEnd;
                    }
                    boolean otherRunIsRtl = ((otherRunLevel = runs[otherRunIndex + 1] >>> 26 & 0x3F) & 1) != 0;
                    boolean bl = advance = toLeft == otherRunIsRtl;
                    if (newCaret == -1) {
                        newCaret = this.getOffsetBeforeAfter(otherRunIndex, otherRunStart, otherRunLimit, otherRunIsRtl, advance ? otherRunStart : otherRunLimit, advance);
                        if (newCaret == (advance ? otherRunLimit : otherRunStart)) {
                            runIndex = otherRunIndex;
                            runLevel = otherRunLevel;
                            continue;
                        }
                        break block13;
                    }
                    if (otherRunLevel >= runLevel) break block13;
                    newCaret = advance ? otherRunStart : otherRunLimit;
                    break block13;
                }
                if (newCaret != -1) break block14;
                newCaret = advance ? this.mLen + 1 : -1;
                break block13;
            }
            if (newCaret > lineEnd) break block13;
            newCaret = advance ? lineEnd : lineStart;
        }
        return newCaret;
    }

    private final int $$robo$$android_text_TextLine$getOffsetBeforeAfter(int runIndex, int runStart, int runLimit, boolean runIsRtl, int offset, boolean after) {
        int cursorOpt;
        int spanLimit;
        if (runIndex < 0 || offset == (after ? this.mLen : 0)) {
            if (after) {
                return TextUtils.getOffsetAfter(this.mText, offset + this.mStart) - this.mStart;
            }
            return TextUtils.getOffsetBefore(this.mText, offset + this.mStart) - this.mStart;
        }
        TextPaint wp = this.mWorkPaint;
        wp.set(this.mPaint);
        int spanStart = runStart;
        if (this.mSpanned == null) {
            spanLimit = runLimit;
        } else {
            int target = after ? offset + 1 : offset;
            int limit = this.mStart + runLimit;
            while ((spanLimit = this.mSpanned.nextSpanTransition(this.mStart + spanStart, limit, MetricAffectingSpan.class) - this.mStart) < target) {
                spanStart = spanLimit;
            }
            MetricAffectingSpan[] spans = this.mSpanned.getSpans(this.mStart + spanStart, this.mStart + spanLimit, MetricAffectingSpan.class);
            spans = TextUtils.removeEmptySpans(spans, this.mSpanned, MetricAffectingSpan.class);
            if (spans.length > 0) {
                ReplacementSpan replacement = null;
                for (int j = 0; j < spans.length; ++j) {
                    MetricAffectingSpan span = spans[j];
                    if (span instanceof ReplacementSpan) {
                        replacement = (ReplacementSpan)span;
                        continue;
                    }
                    span.updateMeasureState(wp);
                }
                if (replacement != null) {
                    return after ? spanLimit : spanStart;
                }
            }
        }
        int dir = runIsRtl ? 1 : 0;
        int n = cursorOpt = after ? 0 : 2;
        if (this.mCharsValid) {
            return wp.getTextRunCursor(this.mChars, spanStart, spanLimit - spanStart, dir, offset, cursorOpt);
        }
        return wp.getTextRunCursor(this.mText, this.mStart + spanStart, this.mStart + spanLimit, dir, this.mStart + offset, cursorOpt) - this.mStart;
    }

    private static final void $$robo$$android_text_TextLine$expandMetricsFromPaint(Paint.FontMetricsInt fmi, TextPaint wp) {
        int previousTop = fmi.top;
        int previousAscent = fmi.ascent;
        int previousDescent = fmi.descent;
        int previousBottom = fmi.bottom;
        int previousLeading = fmi.leading;
        wp.getFontMetricsInt(fmi);
        TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
    }

    private static final void $$robo$$android_text_TextLine$updateMetrics(Paint.FontMetricsInt fmi, int previousTop, int previousAscent, int previousDescent, int previousBottom, int previousLeading) {
        fmi.top = Math.min(fmi.top, previousTop);
        fmi.ascent = Math.min(fmi.ascent, previousAscent);
        fmi.descent = Math.max(fmi.descent, previousDescent);
        fmi.bottom = Math.max(fmi.bottom, previousBottom);
        fmi.leading = Math.max(fmi.leading, previousLeading);
    }

    private final float $$robo$$android_text_TextLine$handleText(TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        int runLen;
        if (fmi != null) {
            TextLine.expandMetricsFromPaint(fmi, wp);
        }
        if ((runLen = end - start) == 0) {
            return 0.0f;
        }
        float ret = 0.0f;
        int contextLen = contextEnd - contextStart;
        if (needWidth || c != null && (wp.bgColor != 0 || wp.underlineColor != 0 || runIsRtl)) {
            if (this.mCharsValid) {
                ret = wp.getTextRunAdvances(this.mChars, start, runLen, contextStart, contextLen, runIsRtl, null, 0);
            } else {
                int delta = this.mStart;
                ret = wp.getTextRunAdvances(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, runIsRtl, null, 0);
            }
        }
        if (c != null) {
            if (runIsRtl) {
                x -= ret;
            }
            if (wp.bgColor != 0) {
                int previousColor = wp.getColor();
                Paint.Style previousStyle = wp.getStyle();
                wp.setColor(wp.bgColor);
                wp.setStyle(Paint.Style.FILL);
                c.drawRect(x, top, x + ret, bottom, wp);
                wp.setStyle(previousStyle);
                wp.setColor(previousColor);
            }
            if (wp.underlineColor != 0) {
                float underlineTop = (float)(y + wp.baselineShift) + 0.11111111f * wp.getTextSize();
                int previousColor = wp.getColor();
                Paint.Style previousStyle = wp.getStyle();
                boolean previousAntiAlias = wp.isAntiAlias();
                wp.setStyle(Paint.Style.FILL);
                wp.setAntiAlias(true);
                wp.setColor(wp.underlineColor);
                c.drawRect(x, underlineTop, x + ret, underlineTop + wp.underlineThickness, wp);
                wp.setStyle(previousStyle);
                wp.setColor(previousColor);
                wp.setAntiAlias(previousAntiAlias);
            }
            this.drawTextRun(c, wp, start, end, contextStart, contextEnd, runIsRtl, x, y + wp.baselineShift);
        }
        return runIsRtl ? -ret : ret;
    }

    private final float $$robo$$android_text_TextLine$handleReplacement(ReplacementSpan replacement, TextPaint wp, int start, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        float ret = 0.0f;
        int textStart = this.mStart + start;
        int textLimit = this.mStart + limit;
        if (needWidth || c != null && runIsRtl) {
            boolean needUpdateMetrics;
            int previousTop = 0;
            int previousAscent = 0;
            int previousDescent = 0;
            int previousBottom = 0;
            int previousLeading = 0;
            boolean bl = needUpdateMetrics = fmi != null;
            if (needUpdateMetrics) {
                previousTop = fmi.top;
                previousAscent = fmi.ascent;
                previousDescent = fmi.descent;
                previousBottom = fmi.bottom;
                previousLeading = fmi.leading;
            }
            ret = replacement.getSize(wp, this.mText, textStart, textLimit, fmi);
            if (needUpdateMetrics) {
                TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
            }
        }
        if (c != null) {
            if (runIsRtl) {
                x -= ret;
            }
            replacement.draw(c, this.mText, textStart, textLimit, x, top, y, bottom, wp);
        }
        return runIsRtl ? -ret : ret;
    }

    private final float $$robo$$android_text_TextLine$handleRun(int start, int measureLimit, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        if (start == measureLimit) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            if (fmi != null) {
                TextLine.expandMetricsFromPaint(fmi, wp);
            }
            return 0.0f;
        }
        if (this.mSpanned == null) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            int mlimit = measureLimit;
            return this.handleText(wp, start, mlimit, start, limit, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
        }
        this.mMetricAffectingSpanSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
        this.mCharacterStyleSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
        float originalX = x;
        int i = start;
        while (i < measureLimit) {
            int j;
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            int inext = this.mMetricAffectingSpanSpanSet.getNextTransition(this.mStart + i, this.mStart + limit) - this.mStart;
            int mlimit = Math.min(inext, measureLimit);
            ReplacementSpan replacement = null;
            for (j = 0; j < this.mMetricAffectingSpanSpanSet.numberOfSpans; ++j) {
                if (this.mMetricAffectingSpanSpanSet.spanStarts[j] >= this.mStart + mlimit || this.mMetricAffectingSpanSpanSet.spanEnds[j] <= this.mStart + i) continue;
                MetricAffectingSpan span = ((MetricAffectingSpan[])this.mMetricAffectingSpanSpanSet.spans)[j];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateDrawState(wp);
            }
            if (replacement != null) {
                x += this.handleReplacement(replacement, wp, i, mlimit, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
            } else {
                j = i;
                while (j < mlimit) {
                    int jnext = this.mCharacterStyleSpanSet.getNextTransition(this.mStart + j, this.mStart + mlimit) - this.mStart;
                    wp.set(this.mPaint);
                    for (int k = 0; k < this.mCharacterStyleSpanSet.numberOfSpans; ++k) {
                        if (this.mCharacterStyleSpanSet.spanStarts[k] >= this.mStart + jnext || this.mCharacterStyleSpanSet.spanEnds[k] <= this.mStart + j) continue;
                        CharacterStyle span = ((CharacterStyle[])this.mCharacterStyleSpanSet.spans)[k];
                        span.updateDrawState(wp);
                    }
                    x += this.handleText(wp, j, jnext, i, inext, runIsRtl, c, x, top, y, bottom, fmi, needWidth || jnext < measureLimit);
                    j = jnext;
                }
            }
            i = inext;
        }
        return x - originalX;
    }

    private final void $$robo$$android_text_TextLine$drawTextRun(Canvas c, TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, float x, int y) {
        if (this.mCharsValid) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start, count, contextStart, contextCount, x, (float)y, runIsRtl, (Paint)wp);
        } else {
            int delta = this.mStart;
            c.drawTextRun(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, x, (float)y, runIsRtl, (Paint)wp);
        }
    }

    private final float $$robo$$android_text_TextLine$ascent(int pos) {
        MetricAffectingSpan[] spans;
        if (this.mSpanned == null) {
            return this.mPaint.ascent();
        }
        if ((spans = this.mSpanned.getSpans(pos += this.mStart, pos + 1, MetricAffectingSpan.class)).length == 0) {
            return this.mPaint.ascent();
        }
        TextPaint wp = this.mWorkPaint;
        wp.set(this.mPaint);
        for (MetricAffectingSpan span : spans) {
            span.updateMeasureState(wp);
        }
        return wp.ascent();
    }

    private final float $$robo$$android_text_TextLine$nextTab(float h) {
        if (this.mTabs != null) {
            return this.mTabs.nextTab(h);
        }
        return Layout.TabStops.nextDefaultStop(h, 20);
    }

    static void __staticInitializer__() {
        sCached = new TextLine[3];
    }

    private void __constructor__() {
        this.$$robo$$android_text_TextLine$__constructor__();
    }

    TextLine() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextLine$__constructor__(), 0, this);
    }

    static TextLine obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_text_TextLine$obtain(), 0);
    }

    static TextLine recycle(TextLine textLine) {
        return InvokeDynamicSupport.bootstrapStatic("recycle", $$robo$$android_text_TextLine$recycle(android.text.TextLine ), 0, (TextLine)textLine);
    }

    void set(TextPaint textPaint, CharSequence charSequence, int n, int n2, int n3, Layout.Directions directions, boolean bl, Layout.TabStops tabStops) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_text_TextLine$set(android.text.TextPaint java.lang.CharSequence int int int android.text.Layout$Directions boolean android.text.Layout$TabStops ), 0, this, textPaint, charSequence, n, n2, n3, directions, bl, tabStops);
    }

    void draw(Canvas canvas, float f, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_text_TextLine$draw(android.graphics.Canvas float int int int ), 0, this, canvas, f, n, n2, n3);
    }

    float metrics(Paint.FontMetricsInt fontMetricsInt) {
        return (float)InvokeDynamicSupport.bootstrap("metrics", $$robo$$android_text_TextLine$metrics(android.graphics.Paint$FontMetricsInt ), 0, this, fontMetricsInt);
    }

    float measure(int n, boolean bl, Paint.FontMetricsInt fontMetricsInt) {
        return (float)InvokeDynamicSupport.bootstrap("measure", $$robo$$android_text_TextLine$measure(int boolean android.graphics.Paint$FontMetricsInt ), 0, this, n, bl, fontMetricsInt);
    }

    private float drawRun(Canvas canvas, int n, int n2, boolean bl, float f, int n3, int n4, int n5, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("drawRun", $$robo$$android_text_TextLine$drawRun(android.graphics.Canvas int int boolean float int int int boolean ), 0, this, canvas, n, n2, bl, f, n3, n4, n5, bl2);
    }

    private float measureRun(int n, int n2, int n3, boolean bl, Paint.FontMetricsInt fontMetricsInt) {
        return (float)InvokeDynamicSupport.bootstrap("measureRun", $$robo$$android_text_TextLine$measureRun(int int int boolean android.graphics.Paint$FontMetricsInt ), 0, this, n, n2, n3, bl, fontMetricsInt);
    }

    int getOffsetToLeftRightOf(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetToLeftRightOf", $$robo$$android_text_TextLine$getOffsetToLeftRightOf(int boolean ), 0, this, n, bl);
    }

    private int getOffsetBeforeAfter(int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("getOffsetBeforeAfter", $$robo$$android_text_TextLine$getOffsetBeforeAfter(int int int boolean int boolean ), 0, this, n, n2, n3, bl, n4, bl2);
    }

    private static void expandMetricsFromPaint(Paint.FontMetricsInt fontMetricsInt, TextPaint textPaint) {
        InvokeDynamicSupport.bootstrapStatic("expandMetricsFromPaint", $$robo$$android_text_TextLine$expandMetricsFromPaint(android.graphics.Paint$FontMetricsInt android.text.TextPaint ), 0, (Paint.FontMetricsInt)fontMetricsInt, (TextPaint)textPaint);
    }

    static void updateMetrics(Paint.FontMetricsInt fontMetricsInt, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrapStatic("updateMetrics", $$robo$$android_text_TextLine$updateMetrics(android.graphics.Paint$FontMetricsInt int int int int int ), 0, (Paint.FontMetricsInt)fontMetricsInt, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    private float handleText(TextPaint textPaint, int n, int n2, int n3, int n4, boolean bl, Canvas canvas, float f, int n5, int n6, int n7, Paint.FontMetricsInt fontMetricsInt, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("handleText", $$robo$$android_text_TextLine$handleText(android.text.TextPaint int int int int boolean android.graphics.Canvas float int int int android.graphics.Paint$FontMetricsInt boolean ), 0, this, textPaint, n, n2, n3, n4, bl, canvas, f, n5, n6, n7, fontMetricsInt, bl2);
    }

    private float handleReplacement(ReplacementSpan replacementSpan, TextPaint textPaint, int n, int n2, boolean bl, Canvas canvas, float f, int n3, int n4, int n5, Paint.FontMetricsInt fontMetricsInt, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("handleReplacement", $$robo$$android_text_TextLine$handleReplacement(android.text.style.ReplacementSpan android.text.TextPaint int int boolean android.graphics.Canvas float int int int android.graphics.Paint$FontMetricsInt boolean ), 0, this, replacementSpan, textPaint, n, n2, bl, canvas, f, n3, n4, n5, fontMetricsInt, bl2);
    }

    private float handleRun(int n, int n2, int n3, boolean bl, Canvas canvas, float f, int n4, int n5, int n6, Paint.FontMetricsInt fontMetricsInt, boolean bl2) {
        return (float)InvokeDynamicSupport.bootstrap("handleRun", $$robo$$android_text_TextLine$handleRun(int int int boolean android.graphics.Canvas float int int int android.graphics.Paint$FontMetricsInt boolean ), 0, this, n, n2, n3, bl, canvas, f, n4, n5, n6, fontMetricsInt, bl2);
    }

    private void drawTextRun(Canvas canvas, TextPaint textPaint, int n, int n2, int n3, int n4, boolean bl, float f, int n5) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_text_TextLine$drawTextRun(android.graphics.Canvas android.text.TextPaint int int int int boolean float int ), 0, this, canvas, textPaint, n, n2, n3, n4, bl, f, n5);
    }

    float ascent(int n) {
        return (float)InvokeDynamicSupport.bootstrap("ascent", $$robo$$android_text_TextLine$ascent(int ), 0, this, n);
    }

    float nextTab(float f) {
        return (float)InvokeDynamicSupport.bootstrap("nextTab", $$robo$$android_text_TextLine$nextTab(float ), 0, this, f);
    }

    static {
        RobolectricInternals.classInitializing(TextLine.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextLine)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

