/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.provider.Settings;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.ICU;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static char QUOTE = '\'';
    @Deprecated
    public static char AM_PM = 'a';
    @Deprecated
    public static char CAPITAL_AM_PM = 'A';
    @Deprecated
    public static char DATE = 'd';
    @Deprecated
    public static char DAY = 'E';
    @Deprecated
    public static char HOUR = 'h';
    @Deprecated
    public static char HOUR_OF_DAY = 'k';
    @Deprecated
    public static char MINUTE = 'm';
    @Deprecated
    public static char MONTH = 'M';
    @Deprecated
    public static char STANDALONE_MONTH = 'L';
    @Deprecated
    public static char SECONDS = 's';
    @Deprecated
    public static char TIME_ZONE = 'z';
    @Deprecated
    public static char YEAR = 'y';
    private static Object sLocaleLock;
    private static Locale sIs24HourLocale;
    private static boolean sIs24Hour;

    private void $$robo$$android_text_format_DateFormat$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_text_format_DateFormat$is24HourFormat(Context context) {
        String value = Settings.System.getString(context.getContentResolver(), "time_12_24");
        if (value == null) {
            SimpleDateFormat sdf;
            String pattern;
            Locale locale = context.getResources().getConfiguration().locale;
            Object object = sLocaleLock;
            synchronized (object) {
                if (sIs24HourLocale != null && sIs24HourLocale.equals(locale)) {
                    return sIs24Hour;
                }
            }
            java.text.DateFormat natural = java.text.DateFormat.getTimeInstance(1, locale);
            value = natural instanceof SimpleDateFormat ? ((pattern = (sdf = (SimpleDateFormat)natural).toPattern()).indexOf(72) >= 0 ? "24" : "12") : "12";
            Object object2 = sLocaleLock;
            synchronized (object2) {
                sIs24HourLocale = locale;
                sIs24Hour = value.equals("24");
            }
            return sIs24Hour;
        }
        return value.equals("24");
    }

    private static final String $$robo$$android_text_format_DateFormat$getBestDateTimePattern(Locale locale, String skeleton) {
        return ICU.getBestDateTimePattern(skeleton, locale);
    }

    private static final java.text.DateFormat $$robo$$android_text_format_DateFormat$getTimeFormat(Context context) {
        return new SimpleDateFormat(DateFormat.getTimeFormatString(context));
    }

    private static final String $$robo$$android_text_format_DateFormat$getTimeFormatString(Context context) {
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        return DateFormat.is24HourFormat(context) ? d.timeFormat24 : d.timeFormat12;
    }

    private static final java.text.DateFormat $$robo$$android_text_format_DateFormat$getDateFormat(Context context) {
        String value = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatForSetting(context, value);
    }

    private static final java.text.DateFormat $$robo$$android_text_format_DateFormat$getDateFormatForSetting(Context context, String value) {
        String format = DateFormat.getDateFormatStringForSetting(context, value);
        return new SimpleDateFormat(format);
    }

    private static final String $$robo$$android_text_format_DateFormat$getDateFormatStringForSetting(Context context, String value) {
        if (value != null) {
            int month = value.indexOf(77);
            int day = value.indexOf(100);
            int year = value.indexOf(121);
            if (month >= 0 && day >= 0 && year >= 0) {
                String template = context.getString(17039443);
                value = year < month && year < day ? (month < day ? String.format(template, "yyyy", "MM", "dd") : String.format(template, "yyyy", "dd", "MM")) : (month < day ? (day < year ? String.format(template, "MM", "dd", "yyyy") : String.format(template, "MM", "yyyy", "dd")) : (month < year ? String.format(template, "dd", "MM", "yyyy") : String.format(template, "dd", "yyyy", "MM")));
                return value;
            }
        }
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        return d.shortDateFormat4;
    }

    private static final java.text.DateFormat $$robo$$android_text_format_DateFormat$getLongDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(1);
    }

    private static final java.text.DateFormat $$robo$$android_text_format_DateFormat$getMediumDateFormat(Context context) {
        return java.text.DateFormat.getDateInstance(2);
    }

    private static final char[] $$robo$$android_text_format_DateFormat$getDateFormatOrder(Context context) {
        return ICU.getDateFormatOrder(DateFormat.getDateFormatString(context));
    }

    private static final String $$robo$$android_text_format_DateFormat$getDateFormatString(Context context) {
        String value = Settings.System.getString(context.getContentResolver(), "date_format");
        return DateFormat.getDateFormatStringForSetting(context, value);
    }

    private static final CharSequence $$robo$$android_text_format_DateFormat$format(CharSequence inFormat, long inTimeInMillis) {
        return DateFormat.format(inFormat, new Date(inTimeInMillis));
    }

    private static final CharSequence $$robo$$android_text_format_DateFormat$format(CharSequence inFormat, Date inDate) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(inDate);
        return DateFormat.format(inFormat, c);
    }

    private static final boolean $$robo$$android_text_format_DateFormat$hasSeconds(CharSequence inFormat) {
        return DateFormat.hasDesignator(inFormat, 's');
    }

    private static final boolean $$robo$$android_text_format_DateFormat$hasDesignator(CharSequence inFormat, char designator) {
        int count;
        if (inFormat == null) {
            return false;
        }
        int length = inFormat.length();
        for (int i = 0; i < length; i += count) {
            count = 1;
            char c = inFormat.charAt(i);
            if (c == '\'') {
                count = DateFormat.skipQuotedText(inFormat, i, length);
                continue;
            }
            if (c != designator) continue;
            return true;
        }
        return false;
    }

    private static final int $$robo$$android_text_format_DateFormat$skipQuotedText(CharSequence s, int i, int len) {
        if (i + 1 < len && s.charAt(i + 1) == '\'') {
            return 2;
        }
        int count = 1;
        ++i;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\'') {
                ++count;
                if (i + 1 >= len || s.charAt(i + 1) != '\'') break;
                ++i;
                continue;
            }
            ++i;
            ++count;
        }
        return count;
    }

    private static final CharSequence $$robo$$android_text_format_DateFormat$format(CharSequence inFormat, Calendar inDate) {
        int count;
        SpannableStringBuilder s = new SpannableStringBuilder(inFormat);
        LocaleData localeData = LocaleData.get(Locale.getDefault());
        int len = inFormat.length();
        for (int i = 0; i < len; i += count) {
            String replacement;
            count = 1;
            char c = s.charAt(i);
            if (c == '\'') {
                count = DateFormat.appendQuotedText(s, i, len);
                len = s.length();
                continue;
            }
            while (i + count < len && s.charAt(i + count) == c) {
                ++count;
            }
            switch (c) {
                case 'A': 
                case 'a': {
                    replacement = localeData.amPm[inDate.get(9) - 0];
                    break;
                }
                case 'd': {
                    replacement = DateFormat.zeroPad(inDate.get(5), count);
                    break;
                }
                case 'E': 
                case 'c': {
                    replacement = DateFormat.getDayOfWeekString(localeData, inDate.get(7), count, c);
                    break;
                }
                case 'K': 
                case 'h': {
                    int hour = inDate.get(10);
                    if (c == 'h' && hour == 0) {
                        hour = 12;
                    }
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'H': 
                case 'k': {
                    int hour = inDate.get(11);
                    replacement = DateFormat.zeroPad(hour, count);
                    break;
                }
                case 'L': 
                case 'M': {
                    replacement = DateFormat.getMonthString(localeData, inDate.get(2), count, c);
                    break;
                }
                case 'm': {
                    replacement = DateFormat.zeroPad(inDate.get(12), count);
                    break;
                }
                case 's': {
                    replacement = DateFormat.zeroPad(inDate.get(13), count);
                    break;
                }
                case 'y': {
                    replacement = DateFormat.getYearString(inDate.get(1), count);
                    break;
                }
                case 'z': {
                    replacement = DateFormat.getTimeZoneString(inDate, count);
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement == null) continue;
            s.replace(i, i + count, replacement);
            count = replacement.length();
            len = s.length();
        }
        if (inFormat instanceof Spanned) {
            return new SpannedString(s);
        }
        return s.toString();
    }

    private static final String $$robo$$android_text_format_DateFormat$getDayOfWeekString(LocaleData ld, int day, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 99;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneWeekdayNames[day] : ld.tinyWeekdayNames[day];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneWeekdayNames[day] : ld.longWeekdayNames[day];
        }
        return standalone ? ld.shortStandAloneWeekdayNames[day] : ld.shortWeekdayNames[day];
    }

    private static final String $$robo$$android_text_format_DateFormat$getMonthString(LocaleData ld, int month, int count, int kind) {
        boolean standalone;
        boolean bl = standalone = kind == 76;
        if (count == 5) {
            return standalone ? ld.tinyStandAloneMonthNames[month] : ld.tinyMonthNames[month];
        }
        if (count == 4) {
            return standalone ? ld.longStandAloneMonthNames[month] : ld.longMonthNames[month];
        }
        if (count == 3) {
            return standalone ? ld.shortStandAloneMonthNames[month] : ld.shortMonthNames[month];
        }
        return DateFormat.zeroPad(month + 1, count);
    }

    private static final String $$robo$$android_text_format_DateFormat$getTimeZoneString(Calendar inDate, int count) {
        TimeZone tz = inDate.getTimeZone();
        if (count < 2) {
            return DateFormat.formatZoneOffset(inDate.get(16) + inDate.get(15), count);
        }
        boolean dst = inDate.get(16) != 0;
        return tz.getDisplayName(dst, 0);
    }

    private static final String $$robo$$android_text_format_DateFormat$formatZoneOffset(int offset, int count) {
        StringBuilder tb = new StringBuilder();
        if ((offset /= 1000) < 0) {
            tb.insert(0, "-");
            offset = -offset;
        } else {
            tb.insert(0, "+");
        }
        int hours = offset / 3600;
        int minutes = offset % 3600 / 60;
        tb.append(DateFormat.zeroPad(hours, 2));
        tb.append(DateFormat.zeroPad(minutes, 2));
        return tb.toString();
    }

    private static final String $$robo$$android_text_format_DateFormat$getYearString(int year, int count) {
        return count <= 2 ? DateFormat.zeroPad(year % 100, 2) : String.format(Locale.getDefault(), "%d", year);
    }

    private static final int $$robo$$android_text_format_DateFormat$appendQuotedText(SpannableStringBuilder s, int i, int len) {
        if (i + 1 < len && s.charAt(i + 1) == '\'') {
            s.delete(i, i + 1);
            return 1;
        }
        int count = 0;
        s.delete(i, i + 1);
        --len;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\'') {
                if (i + 1 < len && s.charAt(i + 1) == '\'') {
                    s.delete(i, i + 1);
                    --len;
                    ++count;
                    ++i;
                    continue;
                }
                s.delete(i, i + 1);
                break;
            }
            ++i;
            ++count;
        }
        return count;
    }

    private static final String $$robo$$android_text_format_DateFormat$zeroPad(int inValue, int inMinDigits) {
        return String.format(Locale.getDefault(), "%0" + inMinDigits + "d", inValue);
    }

    static void __staticInitializer__() {
        sLocaleLock = new Object();
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_DateFormat$__constructor__();
    }

    public DateFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_DateFormat$__constructor__(), 0, this);
    }

    public static boolean is24HourFormat(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is24HourFormat", $$robo$$android_text_format_DateFormat$is24HourFormat(android.content.Context ), 0, (Context)context);
    }

    public static String getBestDateTimePattern(Locale locale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getBestDateTimePattern", $$robo$$android_text_format_DateFormat$getBestDateTimePattern(java.util.Locale java.lang.String ), 0, (Locale)locale, (String)string2);
    }

    public static java.text.DateFormat getTimeFormat(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeFormat", $$robo$$android_text_format_DateFormat$getTimeFormat(android.content.Context ), 0, (Context)context);
    }

    public static String getTimeFormatString(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeFormatString", $$robo$$android_text_format_DateFormat$getTimeFormatString(android.content.Context ), 0, (Context)context);
    }

    public static java.text.DateFormat getDateFormat(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormat", $$robo$$android_text_format_DateFormat$getDateFormat(android.content.Context ), 0, (Context)context);
    }

    public static java.text.DateFormat getDateFormatForSetting(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatForSetting", $$robo$$android_text_format_DateFormat$getDateFormatForSetting(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private static String getDateFormatStringForSetting(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatStringForSetting", $$robo$$android_text_format_DateFormat$getDateFormatStringForSetting(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static java.text.DateFormat getLongDateFormat(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getLongDateFormat", $$robo$$android_text_format_DateFormat$getLongDateFormat(android.content.Context ), 0, (Context)context);
    }

    public static java.text.DateFormat getMediumDateFormat(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getMediumDateFormat", $$robo$$android_text_format_DateFormat$getMediumDateFormat(android.content.Context ), 0, (Context)context);
    }

    public static char[] getDateFormatOrder(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatOrder", $$robo$$android_text_format_DateFormat$getDateFormatOrder(android.content.Context ), 0, (Context)context);
    }

    private static String getDateFormatString(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatString", $$robo$$android_text_format_DateFormat$getDateFormatString(android.content.Context ), 0, (Context)context);
    }

    public static CharSequence format(CharSequence charSequence, long l) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_text_format_DateFormat$format(java.lang.CharSequence long ), 0, (CharSequence)charSequence, (long)l);
    }

    public static CharSequence format(CharSequence charSequence, Date date) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_text_format_DateFormat$format(java.lang.CharSequence java.util.Date ), 0, (CharSequence)charSequence, (Date)date);
    }

    public static boolean hasSeconds(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSeconds", $$robo$$android_text_format_DateFormat$hasSeconds(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static boolean hasDesignator(CharSequence charSequence, char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasDesignator", $$robo$$android_text_format_DateFormat$hasDesignator(java.lang.CharSequence char ), 0, (CharSequence)charSequence, (char)c);
    }

    private static int skipQuotedText(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipQuotedText", $$robo$$android_text_format_DateFormat$skipQuotedText(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static CharSequence format(CharSequence charSequence, Calendar calendar) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_text_format_DateFormat$format(java.lang.CharSequence java.util.Calendar ), 0, (CharSequence)charSequence, (Calendar)calendar);
    }

    private static String getDayOfWeekString(LocaleData localeData, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("getDayOfWeekString", $$robo$$android_text_format_DateFormat$getDayOfWeekString(libcore.icu.LocaleData int int int ), 0, (LocaleData)localeData, (int)n, (int)n2, (int)n3);
    }

    private static String getMonthString(LocaleData localeData, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("getMonthString", $$robo$$android_text_format_DateFormat$getMonthString(libcore.icu.LocaleData int int int ), 0, (LocaleData)localeData, (int)n, (int)n2, (int)n3);
    }

    private static String getTimeZoneString(Calendar calendar, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZoneString", $$robo$$android_text_format_DateFormat$getTimeZoneString(java.util.Calendar int ), 0, (Calendar)calendar, (int)n);
    }

    private static String formatZoneOffset(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("formatZoneOffset", $$robo$$android_text_format_DateFormat$formatZoneOffset(int int ), 0, (int)n, (int)n2);
    }

    private static String getYearString(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getYearString", $$robo$$android_text_format_DateFormat$getYearString(int int ), 0, (int)n, (int)n2);
    }

    private static int appendQuotedText(SpannableStringBuilder spannableStringBuilder, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("appendQuotedText", $$robo$$android_text_format_DateFormat$appendQuotedText(android.text.SpannableStringBuilder int int ), 0, (SpannableStringBuilder)spannableStringBuilder, (int)n, (int)n2);
    }

    private static String zeroPad(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("zeroPad", $$robo$$android_text_format_DateFormat$zeroPad(int int ), 0, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(DateFormat.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateFormat)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

