/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.telephony.PhoneNumberUtils;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.LinkSpec;
import android.util.Patterns;
import android.webkit.WebView;
import android.widget.TextView;
import com.android.i18n.phonenumbers.PhoneNumberMatch;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Linkify
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int WEB_URLS = 1;
    public static int EMAIL_ADDRESSES = 2;
    public static int PHONE_NUMBERS = 4;
    public static int MAP_ADDRESSES = 8;
    public static int ALL = 15;
    private static int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    public static MatchFilter sUrlMatchFilter;
    public static MatchFilter sPhoneNumberMatchFilter;
    public static TransformFilter sPhoneNumberTransformFilter;

    private void $$robo$$android_text_util_Linkify$__constructor__() {
    }

    private static final boolean $$robo$$android_text_util_Linkify$addLinks(Spannable text, int mask) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan(old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            Linkify.gatherLinks(links, text, Patterns.WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            Linkify.gatherLinks(links, text, Patterns.EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 4) != 0) {
            Linkify.gatherTelLinks(links, text);
        }
        if ((mask & 8) != 0) {
            Linkify.gatherMapLinks(links, text);
        }
        Linkify.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            Linkify.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    private static final boolean $$robo$$android_text_util_Linkify$addLinks(TextView text, int mask) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (Linkify.addLinks((Spannable)t, mask)) {
                Linkify.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf(t);
        if (Linkify.addLinks(s, mask)) {
            Linkify.addLinkMovementMethod(text);
            text.setText(s);
            return true;
        }
        return false;
    }

    private static final void $$robo$$android_text_util_Linkify$addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private static final void $$robo$$android_text_util_Linkify$addLinks(TextView text, Pattern pattern, String scheme) {
        Linkify.addLinks(text, pattern, scheme, null, null);
    }

    private static final void $$robo$$android_text_util_Linkify$addLinks(TextView text, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        SpannableString s = SpannableString.valueOf(text.getText());
        if (Linkify.addLinks(s, p, scheme, matchFilter, transformFilter)) {
            text.setText(s);
            Linkify.addLinkMovementMethod(text);
        }
    }

    private static final boolean $$robo$$android_text_util_Linkify$addLinks(Spannable text, Pattern pattern, String scheme) {
        return Linkify.addLinks(text, pattern, scheme, null, null);
    }

    private static final boolean $$robo$$android_text_util_Linkify$addLinks(Spannable s, Pattern p, String scheme, MatchFilter matchFilter, TransformFilter transformFilter) {
        boolean hasMatches = false;
        String prefix = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        Matcher m = p.matcher(s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch(s, start, end);
            }
            if (!allowed) continue;
            String url = Linkify.makeUrl(m.group(0), new String[]{prefix}, m, transformFilter);
            Linkify.applyLink(url, start, end, s);
            hasMatches = true;
        }
        return hasMatches;
    }

    private static final void $$robo$$android_text_util_Linkify$applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan(span, start, end, 33);
    }

    private static final String $$robo$$android_text_util_Linkify$makeUrl(String url, String[] prefixes, Matcher m, TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(m, url);
        }
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static final void $$robo$$android_text_util_Linkify$gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, MatchFilter matchFilter, TransformFilter transformFilter) {
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch(s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = url = Linkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static final void $$robo$$android_text_util_Linkify$gatherTelLinks(ArrayList<LinkSpec> links, Spannable s) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        Iterable<PhoneNumberMatch> matches = phoneUtil.findNumbers(s.toString(), Locale.getDefault().getCountry(), PhoneNumberUtil.Leniency.POSSIBLE, Long.MAX_VALUE);
        for (PhoneNumberMatch match : matches) {
            LinkSpec spec = new LinkSpec();
            spec.url = "tel:" + PhoneNumberUtils.normalizeNumber(match.rawString());
            spec.start = match.start();
            spec.end = match.end();
            links.add(spec);
        }
    }

    private static final void $$robo$$android_text_util_Linkify$gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string2 = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = WebView.findAddress(string2)) != null && (start = string2.indexOf(address)) >= 0) {
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string2 = string2.substring(end);
                base += end;
                String encodedAddress = null;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException e) {
            return;
        }
    }

    private static final void $$robo$$android_text_util_Linkify$pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_util_Linkify_4$__constructor__() {
            }

            private final int $$robo$$android_text_util_Linkify_4$compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }

            private final boolean $$robo$$android_text_util_Linkify_4$equals(Object o) {
                return false;
            }

            private void __constructor__() {
                this.$$robo$$android_text_util_Linkify_4$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_util_Linkify_4$__constructor__(), 0, this);
            }

            @Override
            public int compare(LinkSpec linkSpec, LinkSpec linkSpec2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_text_util_Linkify_4$compare(android.text.util.LinkSpec android.text.util.LinkSpec ), 0, this, linkSpec, linkSpec2);
            }

            @Override
            public boolean equals(Object object) {
                return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_text_util_Linkify_4$equals(java.lang.Object ), 0, this, object);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    static void __staticInitializer__() {
        sUrlMatchFilter = new MatchFilter(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_util_Linkify_1$__constructor__() {
            }

            private final boolean $$robo$$android_text_util_Linkify_1$acceptMatch(CharSequence s, int start, int end) {
                if (start == 0) {
                    return true;
                }
                return s.charAt(start - 1) != '@';
            }

            private void __constructor__() {
                this.$$robo$$android_text_util_Linkify_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_util_Linkify_1$__constructor__(), 0, this);
            }

            @Override
            public boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                return (boolean)InvokeDynamicSupport.bootstrap("acceptMatch", $$robo$$android_text_util_Linkify_1$acceptMatch(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sPhoneNumberMatchFilter = new MatchFilter(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_util_Linkify_2$__constructor__() {
            }

            private final boolean $$robo$$android_text_util_Linkify_2$acceptMatch(CharSequence s, int start, int end) {
                int digitCount = 0;
                for (int i = start; i < end; ++i) {
                    if (!Character.isDigit(s.charAt(i)) || ++digitCount < 5) continue;
                    return true;
                }
                return false;
            }

            private void __constructor__() {
                this.$$robo$$android_text_util_Linkify_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_util_Linkify_2$__constructor__(), 0, this);
            }

            @Override
            public boolean acceptMatch(CharSequence charSequence, int n, int n2) {
                return (boolean)InvokeDynamicSupport.bootstrap("acceptMatch", $$robo$$android_text_util_Linkify_2$acceptMatch(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sPhoneNumberTransformFilter = new TransformFilter(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_util_Linkify_3$__constructor__() {
            }

            private final String $$robo$$android_text_util_Linkify_3$transformUrl(Matcher match, String url) {
                return Patterns.digitsAndPlusOnly(match);
            }

            private void __constructor__() {
                this.$$robo$$android_text_util_Linkify_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_util_Linkify_3$__constructor__(), 0, this);
            }

            @Override
            public String transformUrl(Matcher matcher, String string2) {
                return InvokeDynamicSupport.bootstrap("transformUrl", $$robo$$android_text_util_Linkify_3$transformUrl(java.util.regex.Matcher java.lang.String ), 0, this, matcher, string2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_text_util_Linkify$__constructor__();
    }

    public Linkify() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_util_Linkify$__constructor__(), 0, this);
    }

    public static boolean addLinks(Spannable spannable, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.text.Spannable int ), 0, (Spannable)spannable, (int)n);
    }

    public static boolean addLinks(TextView textView, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.widget.TextView int ), 0, (TextView)textView, (int)n);
    }

    private static void addLinkMovementMethod(TextView textView) {
        InvokeDynamicSupport.bootstrapStatic("addLinkMovementMethod", $$robo$$android_text_util_Linkify$addLinkMovementMethod(android.widget.TextView ), 0, (TextView)textView);
    }

    public static void addLinks(TextView textView, Pattern pattern, String string2) {
        InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.widget.TextView java.util.regex.Pattern java.lang.String ), 0, (TextView)textView, (Pattern)pattern, (String)string2);
    }

    public static void addLinks(TextView textView, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.widget.TextView java.util.regex.Pattern java.lang.String android.text.util.Linkify$MatchFilter android.text.util.Linkify$TransformFilter ), 0, (TextView)textView, (Pattern)pattern, (String)string2, (MatchFilter)matchFilter, (TransformFilter)transformFilter);
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.text.Spannable java.util.regex.Pattern java.lang.String ), 0, (Spannable)spannable, (Pattern)pattern, (String)string2);
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String string2, MatchFilter matchFilter, TransformFilter transformFilter) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("addLinks", $$robo$$android_text_util_Linkify$addLinks(android.text.Spannable java.util.regex.Pattern java.lang.String android.text.util.Linkify$MatchFilter android.text.util.Linkify$TransformFilter ), 0, (Spannable)spannable, (Pattern)pattern, (String)string2, (MatchFilter)matchFilter, (TransformFilter)transformFilter);
    }

    private static void applyLink(String string2, int n, int n2, Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("applyLink", $$robo$$android_text_util_Linkify$applyLink(java.lang.String int int android.text.Spannable ), 0, (String)string2, (int)n, (int)n2, (Spannable)spannable);
    }

    private static String makeUrl(String string2, String[] stringArray, Matcher matcher, TransformFilter transformFilter) {
        return InvokeDynamicSupport.bootstrapStatic("makeUrl", $$robo$$android_text_util_Linkify$makeUrl(java.lang.String java.lang.String[] java.util.regex.Matcher android.text.util.Linkify$TransformFilter ), 0, (String)string2, (String[])stringArray, (Matcher)matcher, (TransformFilter)transformFilter);
    }

    private static void gatherLinks(ArrayList<LinkSpec> arrayList, Spannable spannable, Pattern pattern, String[] stringArray, MatchFilter matchFilter, TransformFilter transformFilter) {
        InvokeDynamicSupport.bootstrapStatic("gatherLinks", $$robo$$android_text_util_Linkify$gatherLinks(java.util.ArrayList<android.text.util.LinkSpec> android.text.Spannable java.util.regex.Pattern java.lang.String[] android.text.util.Linkify$MatchFilter android.text.util.Linkify$TransformFilter ), 0, arrayList, (Spannable)spannable, (Pattern)pattern, (String[])stringArray, (MatchFilter)matchFilter, (TransformFilter)transformFilter);
    }

    private static void gatherTelLinks(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("gatherTelLinks", $$robo$$android_text_util_Linkify$gatherTelLinks(java.util.ArrayList<android.text.util.LinkSpec> android.text.Spannable ), 0, arrayList, (Spannable)spannable);
    }

    private static void gatherMapLinks(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("gatherMapLinks", $$robo$$android_text_util_Linkify$gatherMapLinks(java.util.ArrayList<android.text.util.LinkSpec> android.text.Spannable ), 0, arrayList, (Spannable)spannable);
    }

    private static void pruneOverlaps(ArrayList<LinkSpec> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("pruneOverlaps", $$robo$$android_text_util_Linkify$pruneOverlaps(java.util.ArrayList<android.text.util.LinkSpec> ), 0, arrayList);
    }

    static {
        RobolectricInternals.classInitializing(Linkify.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Linkify)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface TransformFilter
    extends InstrumentedInterface {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter
    extends InstrumentedInterface {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

