/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.RectEvaluator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChangeBounds
extends Transition
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static String PROPNAME_PARENT = "android:changeBounds:parent";
    private static String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static String[] sTransitionProperties;
    private static Property<Drawable, PointF> DRAWABLE_ORIGIN_PROPERTY;
    int[] tempLocation;
    boolean mResizeClip;
    boolean mReparent;
    private static String LOG_TAG = "ChangeBounds";
    private static RectEvaluator sRectEvaluator;

    private void $$robo$$android_transition_ChangeBounds$__constructor__() {
        this.tempLocation = new int[2];
        this.mResizeClip = false;
        this.mReparent = false;
    }

    private void $$robo$$android_transition_ChangeBounds$__constructor__(Context context, AttributeSet attrs) {
        this.tempLocation = new int[2];
        this.mResizeClip = false;
        this.mReparent = false;
    }

    private final String[] $$robo$$android_transition_ChangeBounds$getTransitionProperties() {
        return sTransitionProperties;
    }

    private final void $$robo$$android_transition_ChangeBounds$setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    private final void $$robo$$android_transition_ChangeBounds$setReparent(boolean reparent) {
        this.mReparent = reparent;
    }

    private final void $$robo$$android_transition_ChangeBounds$captureValues(TransitionValues values) {
        View view = values.view;
        if (view.isLaidOut() || view.getWidth() != 0 || view.getHeight() != 0) {
            values.values.put("android:changeBounds:bounds", new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            values.values.put("android:changeBounds:parent", values.view.getParent());
            if (this.mReparent) {
                values.view.getLocationInWindow(this.tempLocation);
                values.values.put("android:changeBounds:windowX", this.tempLocation[0]);
                values.values.put("android:changeBounds:windowY", this.tempLocation[1]);
            }
        }
    }

    private final void $$robo$$android_transition_ChangeBounds$captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final void $$robo$$android_transition_ChangeBounds$captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final boolean $$robo$$android_transition_ChangeBounds$parentMatches(View startParent, View endParent) {
        boolean parentMatches = true;
        if (this.mReparent) {
            TransitionValues endValues = this.getMatchedTransitionValues(startParent, true);
            parentMatches = endValues == null ? startParent == endParent : endParent == endValues.view;
        }
        return parentMatches;
    }

    private final Animator $$robo$$android_transition_ChangeBounds$createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get("android:changeBounds:parent");
        ViewGroup endParent = (ViewGroup)endParentVals.get("android:changeBounds:parent");
        if (startParent == null || endParent == null) {
            return null;
        }
        View view = endValues.view;
        if (this.parentMatches(startParent, endParent)) {
            Rect startBounds = (Rect)startValues.values.get("android:changeBounds:bounds");
            Rect endBounds = (Rect)endValues.values.get("android:changeBounds:bounds");
            int startLeft = startBounds.left;
            int endLeft = endBounds.left;
            int startTop = startBounds.top;
            int endTop = endBounds.top;
            int startRight = startBounds.right;
            int endRight = endBounds.right;
            int startBottom = startBounds.bottom;
            int endBottom = endBounds.bottom;
            int startWidth = startRight - startLeft;
            int startHeight = startBottom - startTop;
            int endWidth = endRight - endLeft;
            int endHeight = endBottom - endTop;
            int numChanges = 0;
            if (startWidth != 0 && startHeight != 0 || endWidth != 0 && endHeight != 0) {
                if (startLeft != endLeft || startTop != endTop) {
                    ++numChanges;
                }
                if (startRight != endRight || startBottom != endBottom) {
                    ++numChanges;
                }
            }
            if (numChanges > 0) {
                if (!this.mResizeClip) {
                    Animator anim2;
                    if (startWidth == endWidth && startHeight == endHeight) {
                        view.offsetLeftAndRight(startLeft - view.getLeft());
                        view.offsetTopAndBottom(startTop - view.getTop());
                        Path positionPath = this.getPathMotion().getPath(0.0f, 0.0f, endLeft - startLeft, endTop - startTop);
                        anim2 = ObjectAnimator.ofInt(view, new HorizontalOffsetProperty(), new VerticalOffsetProperty(), positionPath);
                    } else {
                        if (startLeft != endLeft) {
                            view.setLeft(startLeft);
                        }
                        if (startTop != endTop) {
                            view.setTop(startTop);
                        }
                        if (startRight != endRight) {
                            view.setRight(startRight);
                        }
                        if (startBottom != endBottom) {
                            view.setBottom(startBottom);
                        }
                        ObjectAnimator topLeftAnimator = null;
                        if (startLeft != endLeft || startTop != endTop) {
                            Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                            topLeftAnimator = ObjectAnimator.ofInt((Object)view, "left", "top", topLeftPath);
                        }
                        ObjectAnimator bottomRightAnimator = null;
                        if (startRight != endRight || startBottom != endBottom) {
                            Path bottomRightPath = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                            bottomRightAnimator = ObjectAnimator.ofInt((Object)view, "right", "bottom", bottomRightPath);
                        }
                        anim2 = TransitionUtils.mergeAnimators(topLeftAnimator, bottomRightAnimator);
                    }
                    if (view.getParent() instanceof ViewGroup) {
                        ViewGroup parent = (ViewGroup)view.getParent();
                        parent.suppressLayout(true);
                        ShadowedObject transitionListener = new ShadowedObject(this, parent){
                            public transient /* synthetic */ Object __robo_data__;
                            boolean mCanceled;
                            /* synthetic */ ViewGroup val$parent;
                            /* synthetic */ ChangeBounds this$0;

                            private void $$robo$$android_transition_ChangeBounds_2$__constructor__(ChangeBounds changeBounds, ViewGroup viewGroup) {
                                this.mCanceled = false;
                            }

                            private final void $$robo$$android_transition_ChangeBounds_2$onTransitionCancel(Transition transition2) {
                                this.val$parent.suppressLayout(false);
                                this.mCanceled = true;
                            }

                            private final void $$robo$$android_transition_ChangeBounds_2$onTransitionEnd(Transition transition2) {
                                if (!this.mCanceled) {
                                    this.val$parent.suppressLayout(false);
                                }
                            }

                            private final void $$robo$$android_transition_ChangeBounds_2$onTransitionPause(Transition transition2) {
                                this.val$parent.suppressLayout(false);
                            }

                            private final void $$robo$$android_transition_ChangeBounds_2$onTransitionResume(Transition transition2) {
                                this.val$parent.suppressLayout(true);
                            }

                            private void __constructor__(ChangeBounds changeBounds, ViewGroup viewGroup) {
                                this.$$robo$$android_transition_ChangeBounds_2$__constructor__(changeBounds, viewGroup);
                            }
                            {
                                this.this$0 = changeBounds;
                                this.val$parent = viewGroup;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_2$__constructor__(android.transition.ChangeBounds android.view.ViewGroup ), 0, this, changeBounds, viewGroup);
                            }

                            @Override
                            public void onTransitionCancel(Transition transition2) {
                                InvokeDynamicSupport.bootstrap("onTransitionCancel", $$robo$$android_transition_ChangeBounds_2$onTransitionCancel(android.transition.Transition ), 0, this, transition2);
                            }

                            @Override
                            public void onTransitionEnd(Transition transition2) {
                                InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_ChangeBounds_2$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
                            }

                            @Override
                            public void onTransitionPause(Transition transition2) {
                                InvokeDynamicSupport.bootstrap("onTransitionPause", $$robo$$android_transition_ChangeBounds_2$onTransitionPause(android.transition.Transition ), 0, this, transition2);
                            }

                            @Override
                            public void onTransitionResume(Transition transition2) {
                                InvokeDynamicSupport.bootstrap("onTransitionResume", $$robo$$android_transition_ChangeBounds_2$onTransitionResume(android.transition.Transition ), 0, this, transition2);
                            }
                            {
                                this.$$robo$init();
                            }

                            @Override
                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            @Override
                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        };
                        this.addListener((Transition.TransitionListener)transitionListener);
                    }
                    return anim2;
                }
                if (startWidth != endWidth) {
                    view.setRight(endLeft + Math.max(startWidth, endWidth));
                }
                if (startHeight != endHeight) {
                    view.setBottom(endTop + Math.max(startHeight, endHeight));
                }
                if (startLeft != endLeft) {
                    view.setTranslationX(startLeft - endLeft);
                }
                if (startTop != endTop) {
                    view.setTranslationY(startTop - endTop);
                }
                float transXDelta = endLeft - startLeft;
                float transYDelta = endTop - startTop;
                int widthDelta = endWidth - startWidth;
                int heightDelta = endHeight - startHeight;
                numChanges = 0;
                if (transXDelta != 0.0f) {
                    ++numChanges;
                }
                if (transYDelta != 0.0f) {
                    ++numChanges;
                }
                if (widthDelta != 0 || heightDelta != 0) {
                    ++numChanges;
                }
                ObjectAnimator translationAnimator = null;
                if (transXDelta != 0.0f || transYDelta != 0.0f) {
                    Path topLeftPath = this.getPathMotion().getPath(0.0f, 0.0f, transXDelta, transYDelta);
                    translationAnimator = ObjectAnimator.ofFloat(view, View.TRANSLATION_X, View.TRANSLATION_Y, topLeftPath);
                }
                ObjectAnimator clipAnimator = null;
                if (widthDelta != 0 || heightDelta != 0) {
                    Rect tempStartBounds = new Rect(0, 0, startWidth, startHeight);
                    Rect tempEndBounds = new Rect(0, 0, endWidth, endHeight);
                    clipAnimator = ObjectAnimator.ofObject((Object)view, "clipBounds", (TypeEvaluator)sRectEvaluator, tempStartBounds, tempEndBounds);
                }
                Animator anim3 = TransitionUtils.mergeAnimators(translationAnimator, clipAnimator);
                if (view.getParent() instanceof ViewGroup) {
                    ViewGroup parent = (ViewGroup)view.getParent();
                    parent.suppressLayout(true);
                    ShadowedObject transitionListener = new ShadowedObject(this, parent){
                        public transient /* synthetic */ Object __robo_data__;
                        boolean mCanceled;
                        /* synthetic */ ViewGroup val$parent;
                        /* synthetic */ ChangeBounds this$0;

                        private void $$robo$$android_transition_ChangeBounds_3$__constructor__(ChangeBounds changeBounds, ViewGroup viewGroup) {
                            this.mCanceled = false;
                        }

                        private final void $$robo$$android_transition_ChangeBounds_3$onTransitionCancel(Transition transition2) {
                            this.val$parent.suppressLayout(false);
                            this.mCanceled = true;
                        }

                        private final void $$robo$$android_transition_ChangeBounds_3$onTransitionEnd(Transition transition2) {
                            if (!this.mCanceled) {
                                this.val$parent.suppressLayout(false);
                            }
                        }

                        private final void $$robo$$android_transition_ChangeBounds_3$onTransitionPause(Transition transition2) {
                            this.val$parent.suppressLayout(false);
                        }

                        private final void $$robo$$android_transition_ChangeBounds_3$onTransitionResume(Transition transition2) {
                            this.val$parent.suppressLayout(true);
                        }

                        private void __constructor__(ChangeBounds changeBounds, ViewGroup viewGroup) {
                            this.$$robo$$android_transition_ChangeBounds_3$__constructor__(changeBounds, viewGroup);
                        }
                        {
                            this.this$0 = changeBounds;
                            this.val$parent = viewGroup;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_3$__constructor__(android.transition.ChangeBounds android.view.ViewGroup ), 0, this, changeBounds, viewGroup);
                        }

                        @Override
                        public void onTransitionCancel(Transition transition2) {
                            InvokeDynamicSupport.bootstrap("onTransitionCancel", $$robo$$android_transition_ChangeBounds_3$onTransitionCancel(android.transition.Transition ), 0, this, transition2);
                        }

                        @Override
                        public void onTransitionEnd(Transition transition2) {
                            InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_ChangeBounds_3$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
                        }

                        @Override
                        public void onTransitionPause(Transition transition2) {
                            InvokeDynamicSupport.bootstrap("onTransitionPause", $$robo$$android_transition_ChangeBounds_3$onTransitionPause(android.transition.Transition ), 0, this, transition2);
                        }

                        @Override
                        public void onTransitionResume(Transition transition2) {
                            InvokeDynamicSupport.bootstrap("onTransitionResume", $$robo$$android_transition_ChangeBounds_3$onTransitionResume(android.transition.Transition ), 0, this, transition2);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    this.addListener((Transition.TransitionListener)transitionListener);
                }
                anim3.addListener((Animator.AnimatorListener)new ShadowedObject(this, view){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ View val$view;
                    /* synthetic */ ChangeBounds this$0;

                    private void $$robo$$android_transition_ChangeBounds_4$__constructor__(ChangeBounds changeBounds, View view) {
                    }

                    private final void $$robo$$android_transition_ChangeBounds_4$onAnimationEnd(Animator animation) {
                        this.val$view.setClipBounds(null);
                    }

                    private void __constructor__(ChangeBounds changeBounds, View view) {
                        this.$$robo$$android_transition_ChangeBounds_4$__constructor__(changeBounds, view);
                    }
                    {
                        this.this$0 = changeBounds;
                        this.val$view = view;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_4$__constructor__(android.transition.ChangeBounds android.view.View ), 0, this, changeBounds, view);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_ChangeBounds_4$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                return anim3;
            }
        } else {
            int startX = (Integer)startValues.values.get("android:changeBounds:windowX");
            int startY = (Integer)startValues.values.get("android:changeBounds:windowY");
            int endX = (Integer)endValues.values.get("android:changeBounds:windowX");
            int endY = (Integer)endValues.values.get("android:changeBounds:windowY");
            if (startX != endX || startY != endY) {
                sceneRoot.getLocationInWindow(this.tempLocation);
                Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
                BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                float transitionAlpha = view.getTransitionAlpha();
                view.setTransitionAlpha(0.0f);
                sceneRoot.getOverlay().add(drawable2);
                Path topLeftPath = this.getPathMotion().getPath(startX - this.tempLocation[0], startY - this.tempLocation[1], endX - this.tempLocation[0], endY - this.tempLocation[1]);
                PropertyValuesHolder origin = PropertyValuesHolder.ofObject(DRAWABLE_ORIGIN_PROPERTY, null, topLeftPath);
                ObjectAnimator anim4 = ObjectAnimator.ofPropertyValuesHolder(drawable2, origin);
                anim4.addListener((Animator.AnimatorListener)new ShadowedObject(this, sceneRoot, drawable2, view, transitionAlpha){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ViewGroup val$sceneRoot;
                    /* synthetic */ BitmapDrawable val$drawable;
                    /* synthetic */ View val$view;
                    /* synthetic */ float val$transitionAlpha;
                    /* synthetic */ ChangeBounds this$0;

                    private void $$robo$$android_transition_ChangeBounds_5$__constructor__(ChangeBounds changeBounds, ViewGroup viewGroup, BitmapDrawable bitmapDrawable, View view, float f) {
                    }

                    private final void $$robo$$android_transition_ChangeBounds_5$onAnimationEnd(Animator animation) {
                        this.val$sceneRoot.getOverlay().remove(this.val$drawable);
                        this.val$view.setTransitionAlpha(this.val$transitionAlpha);
                    }

                    private void __constructor__(ChangeBounds changeBounds, ViewGroup viewGroup, BitmapDrawable bitmapDrawable, View view, float f) {
                        this.$$robo$$android_transition_ChangeBounds_5$__constructor__(changeBounds, viewGroup, bitmapDrawable, view, f);
                    }
                    {
                        this.this$0 = changeBounds;
                        this.val$sceneRoot = viewGroup;
                        this.val$drawable = bitmapDrawable;
                        this.val$view = view;
                        this.val$transitionAlpha = f;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_5$__constructor__(android.transition.ChangeBounds android.view.ViewGroup android.graphics.drawable.BitmapDrawable android.view.View float ), 0, this, changeBounds, viewGroup, bitmapDrawable, view, f);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_ChangeBounds_5$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                return anim4;
            }
        }
        return null;
    }

    static void __staticInitializer__() {
        sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
        DRAWABLE_ORIGIN_PROPERTY = new Property<Drawable, PointF>(PointF.class, "boundsOrigin"){
            public transient /* synthetic */ Object __robo_data__;
            private Rect mBounds;

            private void $$robo$$android_transition_ChangeBounds_1$__constructor__(Class x0, String x1) {
                this.mBounds = new Rect();
            }

            private final void $$robo$$android_transition_ChangeBounds_1$set(Drawable object, PointF value) {
                object.copyBounds(this.mBounds);
                this.mBounds.offsetTo(Math.round(value.x), Math.round(value.y));
                object.setBounds(this.mBounds);
            }

            private final PointF $$robo$$android_transition_ChangeBounds_1$get(Drawable object) {
                object.copyBounds(this.mBounds);
                return new PointF(this.mBounds.left, this.mBounds.top);
            }

            private void __constructor__(Class clazz, String string2) {
                this.$$robo$$android_transition_ChangeBounds_1$__constructor__(clazz, string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_1$__constructor__(java.lang.Class java.lang.String ), 0, this, clazz, string2);
            }

            @Override
            public void set(Drawable drawable2, PointF pointF) {
                InvokeDynamicSupport.bootstrap("set", $$robo$$android_transition_ChangeBounds_1$set(android.graphics.drawable.Drawable android.graphics.PointF ), 0, this, drawable2, pointF);
            }

            @Override
            public PointF get(Drawable drawable2) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_transition_ChangeBounds_1$get(android.graphics.drawable.Drawable ), 0, this, drawable2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sRectEvaluator = new RectEvaluator();
    }

    private void __constructor__() {
        this.$$robo$$android_transition_ChangeBounds$__constructor__();
    }

    public ChangeBounds() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_ChangeBounds$__constructor__(context, attributeSet);
    }

    public ChangeBounds(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    public String[] getTransitionProperties() {
        return InvokeDynamicSupport.bootstrap("getTransitionProperties", $$robo$$android_transition_ChangeBounds$getTransitionProperties(), 0, this);
    }

    public void setResizeClip(boolean bl) {
        InvokeDynamicSupport.bootstrap("setResizeClip", $$robo$$android_transition_ChangeBounds$setResizeClip(boolean ), 0, this, bl);
    }

    public void setReparent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setReparent", $$robo$$android_transition_ChangeBounds$setReparent(boolean ), 0, this, bl);
    }

    private void captureValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_ChangeBounds$captureValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_ChangeBounds$captureStartValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_ChangeBounds$captureEndValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    private boolean parentMatches(View view, View view2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parentMatches", $$robo$$android_transition_ChangeBounds$parentMatches(android.view.View android.view.View ), 0, this, view, view2);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_transition_ChangeBounds$createAnimator(android.view.ViewGroup android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transitionValues, transitionValues2);
    }

    static {
        RobolectricInternals.classInitializing(ChangeBounds.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeBounds)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class VerticalOffsetProperty
    extends OffsetProperty
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_transition_ChangeBounds_VerticalOffsetProperty$__constructor__() {
        }

        private final void $$robo$$android_transition_ChangeBounds_VerticalOffsetProperty$offsetBy(View view, int by) {
            view.offsetTopAndBottom(by);
        }

        private void __constructor__() {
            this.$$robo$$android_transition_ChangeBounds_VerticalOffsetProperty$__constructor__();
        }

        public VerticalOffsetProperty() {
            super("offsetTopAndBottom");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_VerticalOffsetProperty$__constructor__(), 0, this);
        }

        @Override
        protected void offsetBy(View view, int n) {
            InvokeDynamicSupport.bootstrap("offsetBy", $$robo$$android_transition_ChangeBounds_VerticalOffsetProperty$offsetBy(android.view.View int ), 0, this, view, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VerticalOffsetProperty)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class HorizontalOffsetProperty
    extends OffsetProperty
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_transition_ChangeBounds_HorizontalOffsetProperty$__constructor__() {
        }

        private final void $$robo$$android_transition_ChangeBounds_HorizontalOffsetProperty$offsetBy(View view, int by) {
            view.offsetLeftAndRight(by);
        }

        private void __constructor__() {
            this.$$robo$$android_transition_ChangeBounds_HorizontalOffsetProperty$__constructor__();
        }

        public HorizontalOffsetProperty() {
            super("offsetLeftAndRight");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_HorizontalOffsetProperty$__constructor__(), 0, this);
        }

        @Override
        protected void offsetBy(View view, int n) {
            InvokeDynamicSupport.bootstrap("offsetBy", $$robo$$android_transition_ChangeBounds_HorizontalOffsetProperty$offsetBy(android.view.View int ), 0, this, view, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HorizontalOffsetProperty)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class OffsetProperty
    extends IntProperty<View> {
        public transient /* synthetic */ Object __robo_data__;
        int mPreviousValue;

        private void $$robo$$android_transition_ChangeBounds_OffsetProperty$__constructor__(String name) {
        }

        private final void $$robo$$android_transition_ChangeBounds_OffsetProperty$setValue(View view, int value) {
            int offset = value - this.mPreviousValue;
            this.offsetBy(view, offset);
            this.mPreviousValue = value;
        }

        private final Integer $$robo$$android_transition_ChangeBounds_OffsetProperty$get(View object) {
            return null;
        }

        protected abstract void offsetBy(View var1, int var2);

        private void __constructor__(String string2) {
            this.$$robo$$android_transition_ChangeBounds_OffsetProperty$__constructor__(string2);
        }

        public OffsetProperty(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeBounds_OffsetProperty$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        public void setValue(View view, int n) {
            InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_transition_ChangeBounds_OffsetProperty$setValue(android.view.View int ), 0, this, view, n);
        }

        @Override
        public Integer get(View view) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_transition_ChangeBounds_OffsetProperty$get(android.view.View ), 0, this, view);
        }

        public /* synthetic */ OffsetProperty() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetProperty)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

