/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.PathMotion;
import android.transition.Transition;
import android.transition.TransitionPropagation;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransitionSet
extends Transition
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    ArrayList<Transition> mTransitions;
    private boolean mPlayTogether;
    int mCurrentListeners;
    boolean mStarted;
    public static int ORDERING_TOGETHER = 0;
    public static int ORDERING_SEQUENTIAL = 1;

    private void $$robo$$android_transition_TransitionSet$__constructor__() {
        this.mTransitions = new ArrayList();
        this.mPlayTogether = true;
        this.mStarted = false;
    }

    private void $$robo$$android_transition_TransitionSet$__constructor__(Context context, AttributeSet attrs) {
        this.mTransitions = new ArrayList();
        this.mPlayTogether = true;
        this.mStarted = false;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TransitionSet);
        int ordering = a.getInt(0, 0);
        this.setOrdering(ordering);
        a.recycle();
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$setOrdering(int ordering) {
        switch (ordering) {
            case 1: {
                this.mPlayTogether = false;
                break;
            }
            case 0: {
                this.mPlayTogether = true;
                break;
            }
            default: {
                throw new AndroidRuntimeException("Invalid parameter for TransitionSet ordering: " + ordering);
            }
        }
        return this;
    }

    private final int $$robo$$android_transition_TransitionSet$getOrdering() {
        return this.mPlayTogether ? 0 : 1;
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addTransition(Transition transition2) {
        if (transition2 != null) {
            this.mTransitions.add(transition2);
            transition2.mParent = this;
            if (this.mDuration >= 0L) {
                transition2.setDuration(this.mDuration);
            }
        }
        return this;
    }

    private final int $$robo$$android_transition_TransitionSet$getTransitionCount() {
        return this.mTransitions.size();
    }

    private final Transition $$robo$$android_transition_TransitionSet$getTransitionAt(int index) {
        if (index < 0 || index >= this.mTransitions.size()) {
            return null;
        }
        return this.mTransitions.get(index);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$setDuration(long duration) {
        super.setDuration(duration);
        if (this.mDuration >= 0L && this.mTransitions != null) {
            int numTransitions = this.mTransitions.size();
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).setDuration(duration);
            }
        }
        return this;
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$setStartDelay(long startDelay) {
        return (TransitionSet)super.setStartDelay(startDelay);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$setInterpolator(TimeInterpolator interpolator2) {
        return (TransitionSet)super.setInterpolator(interpolator2);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addTarget(View target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(target);
        }
        return (TransitionSet)super.addTarget(target);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addTarget(int targetId) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetId);
        }
        return (TransitionSet)super.addTarget(targetId);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addTarget(String targetName) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetName);
        }
        return (TransitionSet)super.addTarget(targetName);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addTarget(Class targetType) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetType);
        }
        return (TransitionSet)super.addTarget(targetType);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$addListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.addListener(listener);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeTarget(int targetId) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(targetId);
        }
        return (TransitionSet)super.removeTarget(targetId);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeTarget(View target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeTarget(Class target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeTarget(String target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    private final Transition $$robo$$android_transition_TransitionSet$excludeTarget(View target, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(target, exclude);
        }
        return super.excludeTarget(target, exclude);
    }

    private final Transition $$robo$$android_transition_TransitionSet$excludeTarget(String targetName, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(targetName, exclude);
        }
        return super.excludeTarget(targetName, exclude);
    }

    private final Transition $$robo$$android_transition_TransitionSet$excludeTarget(int targetId, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(targetId, exclude);
        }
        return super.excludeTarget(targetId, exclude);
    }

    private final Transition $$robo$$android_transition_TransitionSet$excludeTarget(Class type, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(type, exclude);
        }
        return super.excludeTarget(type, exclude);
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.removeListener(listener);
    }

    private final void $$robo$$android_transition_TransitionSet$setPathMotion(PathMotion pathMotion) {
        super.setPathMotion(pathMotion);
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).setPathMotion(pathMotion);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$forceVisibility(int visibility, boolean isStartValue) {
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).forceVisibility(visibility, isStartValue);
        }
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$removeTransition(Transition transition2) {
        this.mTransitions.remove(transition2);
        transition2.mParent = null;
        return this;
    }

    private final void $$robo$$android_transition_TransitionSet$setupStartEndListeners() {
        TransitionSetListener listener = new TransitionSetListener(this);
        for (Transition childTransition : this.mTransitions) {
            childTransition.addListener(listener);
        }
        this.mCurrentListeners = this.mTransitions.size();
    }

    private final void $$robo$$android_transition_TransitionSet$createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues, ArrayList<TransitionValues> startValuesList, ArrayList<TransitionValues> endValuesList) {
        long startDelay = this.getStartDelay();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            Transition childTransition = this.mTransitions.get(i);
            if (startDelay > 0L && (this.mPlayTogether || i == 0)) {
                long childStartDelay = childTransition.getStartDelay();
                if (childStartDelay > 0L) {
                    childTransition.setStartDelay(startDelay + childStartDelay);
                } else {
                    childTransition.setStartDelay(startDelay);
                }
            }
            childTransition.createAnimators(sceneRoot, startValues, endValues, startValuesList, endValuesList);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$runAnimators() {
        if (this.mTransitions.isEmpty()) {
            this.start();
            this.end();
            return;
        }
        this.setupStartEndListeners();
        int numTransitions = this.mTransitions.size();
        if (!this.mPlayTogether) {
            for (int i = 1; i < numTransitions; ++i) {
                Transition previousTransition = this.mTransitions.get(i - 1);
                Transition nextTransition = this.mTransitions.get(i);
                previousTransition.addListener((Transition.TransitionListener)new ShadowedObject(this, nextTransition){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Transition val$nextTransition;
                    /* synthetic */ TransitionSet this$0;

                    private void $$robo$$android_transition_TransitionSet_1$__constructor__(TransitionSet transitionSet, Transition transition2) {
                    }

                    private final void $$robo$$android_transition_TransitionSet_1$onTransitionEnd(Transition transition2) {
                        this.val$nextTransition.runAnimators();
                        transition2.removeListener(this);
                    }

                    private void __constructor__(TransitionSet transitionSet, Transition transition2) {
                        this.$$robo$$android_transition_TransitionSet_1$__constructor__(transitionSet, transition2);
                    }
                    {
                        this.this$0 = transitionSet;
                        this.val$nextTransition = transition2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionSet_1$__constructor__(android.transition.TransitionSet android.transition.Transition ), 0, this, transitionSet, transition2);
                    }

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_TransitionSet_1$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            Transition firstTransition = this.mTransitions.get(0);
            if (firstTransition != null) {
                firstTransition.runAnimators();
            }
        } else {
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).runAnimators();
            }
        }
    }

    private final void $$robo$$android_transition_TransitionSet$captureStartValues(TransitionValues transitionValues) {
        if (this.isValidTarget(transitionValues.view)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view)) continue;
                childTransition.captureStartValues(transitionValues);
                transitionValues.targetedTransitions.add(childTransition);
            }
        }
    }

    private final void $$robo$$android_transition_TransitionSet$captureEndValues(TransitionValues transitionValues) {
        if (this.isValidTarget(transitionValues.view)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view)) continue;
                childTransition.captureEndValues(transitionValues);
                transitionValues.targetedTransitions.add(childTransition);
            }
        }
    }

    private final void $$robo$$android_transition_TransitionSet$capturePropagationValues(TransitionValues transitionValues) {
        super.capturePropagationValues(transitionValues);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).capturePropagationValues(transitionValues);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$pause(View sceneRoot) {
        super.pause(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).pause(sceneRoot);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$resume(View sceneRoot) {
        super.resume(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).resume(sceneRoot);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$cancel() {
        super.cancel();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).cancel();
        }
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$setSceneRoot(ViewGroup sceneRoot) {
        super.setSceneRoot(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setSceneRoot(sceneRoot);
        }
        return this;
    }

    private final void $$robo$$android_transition_TransitionSet$setCanRemoveViews(boolean canRemoveViews) {
        super.setCanRemoveViews(canRemoveViews);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setCanRemoveViews(canRemoveViews);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$setPropagation(TransitionPropagation propagation) {
        super.setPropagation(propagation);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setPropagation(propagation);
        }
    }

    private final void $$robo$$android_transition_TransitionSet$setEpicenterCallback(Transition.EpicenterCallback epicenterCallback) {
        super.setEpicenterCallback(epicenterCallback);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setEpicenterCallback(epicenterCallback);
        }
    }

    private final String $$robo$$android_transition_TransitionSet$toString(String indent) {
        String result = super.toString(indent);
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            result = result + "\n" + this.mTransitions.get(i).toString(indent + "  ");
        }
        return result;
    }

    private final TransitionSet $$robo$$android_transition_TransitionSet$clone() {
        TransitionSet clone = (TransitionSet)super.clone();
        clone.mTransitions = new ArrayList();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            clone.addTransition((Transition)this.mTransitions.get(i).clone());
        }
        return clone;
    }

    private void __constructor__() {
        this.$$robo$$android_transition_TransitionSet$__constructor__();
    }

    public TransitionSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionSet$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_TransitionSet$__constructor__(context, attributeSet);
    }

    public TransitionSet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionSet$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    public TransitionSet setOrdering(int n) {
        return InvokeDynamicSupport.bootstrap("setOrdering", $$robo$$android_transition_TransitionSet$setOrdering(int ), 0, this, n);
    }

    public int getOrdering() {
        return (int)InvokeDynamicSupport.bootstrap("getOrdering", $$robo$$android_transition_TransitionSet$getOrdering(), 0, this);
    }

    public TransitionSet addTransition(Transition transition2) {
        return InvokeDynamicSupport.bootstrap("addTransition", $$robo$$android_transition_TransitionSet$addTransition(android.transition.Transition ), 0, this, transition2);
    }

    public int getTransitionCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTransitionCount", $$robo$$android_transition_TransitionSet$getTransitionCount(), 0, this);
    }

    public Transition getTransitionAt(int n) {
        return InvokeDynamicSupport.bootstrap("getTransitionAt", $$robo$$android_transition_TransitionSet$getTransitionAt(int ), 0, this, n);
    }

    @Override
    public TransitionSet setDuration(long l) {
        return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_transition_TransitionSet$setDuration(long ), 0, this, l);
    }

    @Override
    public TransitionSet setStartDelay(long l) {
        return InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_transition_TransitionSet$setStartDelay(long ), 0, this, l);
    }

    @Override
    public TransitionSet setInterpolator(TimeInterpolator timeInterpolator) {
        return InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_transition_TransitionSet$setInterpolator(android.animation.TimeInterpolator ), 0, this, timeInterpolator);
    }

    @Override
    public TransitionSet addTarget(View view) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_TransitionSet$addTarget(android.view.View ), 0, this, view);
    }

    @Override
    public TransitionSet addTarget(int n) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_TransitionSet$addTarget(int ), 0, this, n);
    }

    @Override
    public TransitionSet addTarget(String string2) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_TransitionSet$addTarget(java.lang.String ), 0, this, string2);
    }

    @Override
    public TransitionSet addTarget(Class clazz) {
        return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$android_transition_TransitionSet$addTarget(java.lang.Class ), 0, this, clazz);
    }

    @Override
    public TransitionSet addListener(Transition.TransitionListener transitionListener) {
        return InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_transition_TransitionSet$addListener(android.transition.Transition$TransitionListener ), 0, this, transitionListener);
    }

    @Override
    public TransitionSet removeTarget(int n) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_TransitionSet$removeTarget(int ), 0, this, n);
    }

    @Override
    public TransitionSet removeTarget(View view) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_TransitionSet$removeTarget(android.view.View ), 0, this, view);
    }

    @Override
    public TransitionSet removeTarget(Class clazz) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_TransitionSet$removeTarget(java.lang.Class ), 0, this, clazz);
    }

    @Override
    public TransitionSet removeTarget(String string2) {
        return InvokeDynamicSupport.bootstrap("removeTarget", $$robo$$android_transition_TransitionSet$removeTarget(java.lang.String ), 0, this, string2);
    }

    @Override
    public Transition excludeTarget(View view, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_TransitionSet$excludeTarget(android.view.View boolean ), 0, this, view, bl);
    }

    @Override
    public Transition excludeTarget(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_TransitionSet$excludeTarget(java.lang.String boolean ), 0, this, string2, bl);
    }

    @Override
    public Transition excludeTarget(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_TransitionSet$excludeTarget(int boolean ), 0, this, n, bl);
    }

    @Override
    public Transition excludeTarget(Class clazz, boolean bl) {
        return InvokeDynamicSupport.bootstrap("excludeTarget", $$robo$$android_transition_TransitionSet$excludeTarget(java.lang.Class boolean ), 0, this, clazz, bl);
    }

    @Override
    public TransitionSet removeListener(Transition.TransitionListener transitionListener) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_transition_TransitionSet$removeListener(android.transition.Transition$TransitionListener ), 0, this, transitionListener);
    }

    @Override
    public void setPathMotion(PathMotion pathMotion) {
        InvokeDynamicSupport.bootstrap("setPathMotion", $$robo$$android_transition_TransitionSet$setPathMotion(android.transition.PathMotion ), 0, this, pathMotion);
    }

    @Override
    public void forceVisibility(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("forceVisibility", $$robo$$android_transition_TransitionSet$forceVisibility(int boolean ), 0, this, n, bl);
    }

    public TransitionSet removeTransition(Transition transition2) {
        return InvokeDynamicSupport.bootstrap("removeTransition", $$robo$$android_transition_TransitionSet$removeTransition(android.transition.Transition ), 0, this, transition2);
    }

    private void setupStartEndListeners() {
        InvokeDynamicSupport.bootstrap("setupStartEndListeners", $$robo$$android_transition_TransitionSet$setupStartEndListeners(), 0, this);
    }

    @Override
    protected void createAnimators(ViewGroup viewGroup, TransitionValuesMaps transitionValuesMaps, TransitionValuesMaps transitionValuesMaps2, ArrayList<TransitionValues> arrayList, ArrayList<TransitionValues> arrayList2) {
        InvokeDynamicSupport.bootstrap("createAnimators", $$robo$$android_transition_TransitionSet$createAnimators(android.view.ViewGroup android.transition.TransitionValuesMaps android.transition.TransitionValuesMaps java.util.ArrayList<android.transition.TransitionValues> java.util.ArrayList<android.transition.TransitionValues> ), 0, this, viewGroup, transitionValuesMaps, transitionValuesMaps2, arrayList, arrayList2);
    }

    @Override
    protected void runAnimators() {
        InvokeDynamicSupport.bootstrap("runAnimators", $$robo$$android_transition_TransitionSet$runAnimators(), 0, this);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_TransitionSet$captureStartValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_TransitionSet$captureEndValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    void capturePropagationValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("capturePropagationValues", $$robo$$android_transition_TransitionSet$capturePropagationValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void pause(View view) {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_transition_TransitionSet$pause(android.view.View ), 0, this, view);
    }

    @Override
    public void resume(View view) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_transition_TransitionSet$resume(android.view.View ), 0, this, view);
    }

    @Override
    protected void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_transition_TransitionSet$cancel(), 0, this);
    }

    @Override
    TransitionSet setSceneRoot(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("setSceneRoot", $$robo$$android_transition_TransitionSet$setSceneRoot(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    void setCanRemoveViews(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanRemoveViews", $$robo$$android_transition_TransitionSet$setCanRemoveViews(boolean ), 0, this, bl);
    }

    @Override
    public void setPropagation(TransitionPropagation transitionPropagation) {
        InvokeDynamicSupport.bootstrap("setPropagation", $$robo$$android_transition_TransitionSet$setPropagation(android.transition.TransitionPropagation ), 0, this, transitionPropagation);
    }

    @Override
    public void setEpicenterCallback(Transition.EpicenterCallback epicenterCallback) {
        InvokeDynamicSupport.bootstrap("setEpicenterCallback", $$robo$$android_transition_TransitionSet$setEpicenterCallback(android.transition.Transition$EpicenterCallback ), 0, this, epicenterCallback);
    }

    @Override
    String toString(String string2) {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_transition_TransitionSet$toString(java.lang.String ), 0, this, string2);
    }

    @Override
    public TransitionSet clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_transition_TransitionSet$clone(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TransitionSetListener
    extends Transition.TransitionListenerAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        TransitionSet mTransitionSet;

        private void $$robo$$android_transition_TransitionSet_TransitionSetListener$__constructor__(TransitionSet transitionSet) {
            this.mTransitionSet = transitionSet;
        }

        private final void $$robo$$android_transition_TransitionSet_TransitionSetListener$onTransitionStart(Transition transition2) {
            if (!this.mTransitionSet.mStarted) {
                this.mTransitionSet.start();
                this.mTransitionSet.mStarted = true;
            }
        }

        private final void $$robo$$android_transition_TransitionSet_TransitionSetListener$onTransitionEnd(Transition transition2) {
            --this.mTransitionSet.mCurrentListeners;
            if (this.mTransitionSet.mCurrentListeners == 0) {
                this.mTransitionSet.mStarted = false;
                this.mTransitionSet.end();
            }
            transition2.removeListener(this);
        }

        private void __constructor__(TransitionSet transitionSet) {
            this.$$robo$$android_transition_TransitionSet_TransitionSetListener$__constructor__(transitionSet);
        }

        TransitionSetListener(TransitionSet transitionSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionSet_TransitionSetListener$__constructor__(android.transition.TransitionSet ), 0, this, transitionSet);
        }

        @Override
        public void onTransitionStart(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionStart", $$robo$$android_transition_TransitionSet_TransitionSetListener$onTransitionStart(android.transition.Transition ), 0, this, transition2);
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_TransitionSet_TransitionSetListener$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
        }

        public /* synthetic */ TransitionSetListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionSetListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

