/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Visibility
extends Transition
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static String PROPNAME_PARENT = "android:visibility:parent";
    private static String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    public static int MODE_IN = 1;
    public static int MODE_OUT = 2;
    private static String[] sTransitionProperties;
    private int mMode;
    private int mForcedStartVisibility;
    private int mForcedEndVisibility;

    private void $$robo$$android_transition_Visibility$__constructor__() {
        this.mMode = 3;
        this.mForcedStartVisibility = -1;
        this.mForcedEndVisibility = -1;
    }

    private void $$robo$$android_transition_Visibility$__constructor__(Context context, AttributeSet attrs) {
        this.mMode = 3;
        this.mForcedStartVisibility = -1;
        this.mForcedEndVisibility = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VisibilityTransition);
        int mode = a.getInt(0, 0);
        a.recycle();
        if (mode != 0) {
            this.setMode(mode);
        }
    }

    private final void $$robo$$android_transition_Visibility$setMode(int mode) {
        if ((mode & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = mode;
    }

    private final int $$robo$$android_transition_Visibility$getMode() {
        return this.mMode;
    }

    private final String[] $$robo$$android_transition_Visibility$getTransitionProperties() {
        return sTransitionProperties;
    }

    private final void $$robo$$android_transition_Visibility$captureValues(TransitionValues transitionValues, int forcedVisibility) {
        int visibility = forcedVisibility != -1 ? forcedVisibility : transitionValues.view.getVisibility();
        transitionValues.values.put("android:visibility:visibility", visibility);
        transitionValues.values.put("android:visibility:parent", transitionValues.view.getParent());
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put("android:visibility:screenLocation", loc);
    }

    private final void $$robo$$android_transition_Visibility$captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedStartVisibility);
    }

    private final void $$robo$$android_transition_Visibility$captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedEndVisibility);
    }

    private final void $$robo$$android_transition_Visibility$forceVisibility(int visibility, boolean isStartValue) {
        if (isStartValue) {
            this.mForcedStartVisibility = visibility;
        } else {
            this.mForcedEndVisibility = visibility;
        }
    }

    private final boolean $$robo$$android_transition_Visibility$isVisible(TransitionValues values) {
        if (values == null) {
            return false;
        }
        int visibility = (Integer)values.values.get("android:visibility:visibility");
        View parent = (View)values.values.get("android:visibility:parent");
        return visibility == 0 && parent != null;
    }

    private final VisibilityInfo $$robo$$android_transition_Visibility$getVisibilityChangeInfo(TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = new VisibilityInfo();
        visInfo.visibilityChange = false;
        visInfo.fadeIn = false;
        if (startValues != null && startValues.values.containsKey("android:visibility:visibility")) {
            visInfo.startVisibility = (Integer)startValues.values.get("android:visibility:visibility");
            visInfo.startParent = (ViewGroup)startValues.values.get("android:visibility:parent");
        } else {
            visInfo.startVisibility = -1;
            visInfo.startParent = null;
        }
        if (endValues != null && endValues.values.containsKey("android:visibility:visibility")) {
            visInfo.endVisibility = (Integer)endValues.values.get("android:visibility:visibility");
            visInfo.endParent = (ViewGroup)endValues.values.get("android:visibility:parent");
        } else {
            visInfo.endVisibility = -1;
            visInfo.endParent = null;
        }
        if (startValues != null && endValues != null) {
            if (visInfo.startVisibility == visInfo.endVisibility && visInfo.startParent == visInfo.endParent) {
                return visInfo;
            }
            if (visInfo.startVisibility != visInfo.endVisibility) {
                if (visInfo.startVisibility == 0) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.endVisibility == 0) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            } else if (visInfo.startParent != visInfo.endParent) {
                if (visInfo.endParent == null) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.startParent == null) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            }
        } else if (startValues == null && visInfo.endVisibility == 0) {
            visInfo.fadeIn = true;
            visInfo.visibilityChange = true;
        } else if (endValues == null && visInfo.startVisibility == 0) {
            visInfo.fadeIn = false;
            visInfo.visibilityChange = true;
        }
        return visInfo;
    }

    private final Animator $$robo$$android_transition_Visibility$createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = this.getVisibilityChangeInfo(startValues, endValues);
        if (visInfo.visibilityChange && (visInfo.startParent != null || visInfo.endParent != null)) {
            if (visInfo.fadeIn) {
                return this.onAppear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
            }
            return this.onDisappear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
        }
        return null;
    }

    private final Animator $$robo$$android_transition_Visibility$onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 1) != 1 || endValues == null) {
            return null;
        }
        if (startValues == null) {
            VisibilityInfo parentVisibilityInfo = null;
            View endParent = (View)((Object)endValues.view.getParent());
            TransitionValues startParentValues = this.getMatchedTransitionValues(endParent, false);
            TransitionValues endParentValues = this.getTransitionValues(endParent, false);
            parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
            if (parentVisibilityInfo.visibilityChange) {
                return null;
            }
        }
        return this.onAppear(sceneRoot, endValues.view, startValues, endValues);
    }

    private final Animator $$robo$$android_transition_Visibility$onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    private final Animator $$robo$$android_transition_Visibility$onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 2) != 2) {
            return null;
        }
        View startView = startValues != null ? startValues.view : null;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                overlayView = endView;
            } else if (startView != null) {
                if (startView.getParent() == null) {
                    overlayView = startView;
                } else if (startView.getParent() instanceof View) {
                    int id2;
                    View startParent = (View)((Object)startView.getParent());
                    TransitionValues startParentValues = this.getTransitionValues(startParent, true);
                    TransitionValues endParentValues = this.getMatchedTransitionValues(startParent, true);
                    VisibilityInfo parentVisibilityInfo = this.getVisibilityChangeInfo(startParentValues, endParentValues);
                    if (!parentVisibilityInfo.visibilityChange) {
                        overlayView = TransitionUtils.copyViewImage(sceneRoot, startView, startParent);
                    } else if (startParent.getParent() == null && (id2 = startParent.getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                        overlayView = startView;
                    }
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = endView;
        } else if (startView == endView) {
            viewToKeep = endView;
        } else {
            overlayView = startView;
        }
        int finalVisibility = endVisibility;
        ViewGroup finalSceneRoot = sceneRoot;
        if (overlayView != null) {
            int[] screenLoc = (int[])startValues.values.get("android:visibility:screenLocation");
            int screenX = screenLoc[0];
            int screenY = screenLoc[1];
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
            overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
            ((ViewGroupOverlay)sceneRoot.getOverlay()).add(overlayView);
            Animator animator2 = this.onDisappear(sceneRoot, overlayView, startValues, endValues);
            if (animator2 == null) {
                ((ViewGroupOverlay)sceneRoot.getOverlay()).remove(overlayView);
            } else {
                View finalOverlayView = overlayView;
                animator2.addListener((Animator.AnimatorListener)new ShadowedObject(this, finalSceneRoot, finalOverlayView){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ViewGroup val$finalSceneRoot;
                    /* synthetic */ View val$finalOverlayView;
                    /* synthetic */ Visibility this$0;

                    private void $$robo$$android_transition_Visibility_1$__constructor__(Visibility visibility, ViewGroup viewGroup, View view) {
                    }

                    private final void $$robo$$android_transition_Visibility_1$onAnimationEnd(Animator animation) {
                        ((ViewGroupOverlay)this.val$finalSceneRoot.getOverlay()).remove(this.val$finalOverlayView);
                    }

                    private void __constructor__(Visibility visibility, ViewGroup viewGroup, View view) {
                        this.$$robo$$android_transition_Visibility_1$__constructor__(visibility, viewGroup, view);
                    }
                    {
                        this.this$0 = visibility;
                        this.val$finalSceneRoot = viewGroup;
                        this.val$finalOverlayView = view;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_1$__constructor__(android.transition.Visibility android.view.ViewGroup android.view.View ), 0, this, visibility, viewGroup, view);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_Visibility_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            return animator2;
        }
        if (viewToKeep != null) {
            Animator animator3;
            boolean isForcedVisibility;
            int originalVisibility = -1;
            boolean bl = isForcedVisibility = this.mForcedStartVisibility != -1 || this.mForcedEndVisibility != -1;
            if (!isForcedVisibility) {
                originalVisibility = viewToKeep.getVisibility();
                viewToKeep.setVisibility(0);
            }
            if ((animator3 = this.onDisappear(sceneRoot, viewToKeep, startValues, endValues)) != null) {
                View finalViewToKeep = viewToKeep;
                animator3.addListener((Animator.AnimatorListener)new ShadowedObject(this, isForcedVisibility, finalViewToKeep, finalVisibility){
                    public transient /* synthetic */ Object __robo_data__;
                    boolean mCanceled;
                    /* synthetic */ boolean val$isForcedVisibility;
                    /* synthetic */ View val$finalViewToKeep;
                    /* synthetic */ int val$finalVisibility;
                    /* synthetic */ Visibility this$0;

                    private void $$robo$$android_transition_Visibility_2$__constructor__(Visibility visibility, boolean bl, View view, int n) {
                        this.mCanceled = false;
                    }

                    private final void $$robo$$android_transition_Visibility_2$onAnimationPause(Animator animation) {
                        if (!this.mCanceled && !this.val$isForcedVisibility) {
                            this.val$finalViewToKeep.setVisibility(this.val$finalVisibility);
                        }
                    }

                    private final void $$robo$$android_transition_Visibility_2$onAnimationResume(Animator animation) {
                        if (!this.mCanceled && !this.val$isForcedVisibility) {
                            this.val$finalViewToKeep.setVisibility(0);
                        }
                    }

                    private final void $$robo$$android_transition_Visibility_2$onAnimationCancel(Animator animation) {
                        this.mCanceled = true;
                    }

                    private final void $$robo$$android_transition_Visibility_2$onAnimationEnd(Animator animation) {
                        if (!this.mCanceled) {
                            if (this.val$isForcedVisibility) {
                                this.val$finalViewToKeep.setTransitionAlpha(0.0f);
                            } else {
                                this.val$finalViewToKeep.setVisibility(this.val$finalVisibility);
                            }
                        }
                    }

                    private void __constructor__(Visibility visibility, boolean bl, View view, int n) {
                        this.$$robo$$android_transition_Visibility_2$__constructor__(visibility, bl, view, n);
                    }
                    {
                        this.this$0 = visibility;
                        this.val$isForcedVisibility = bl;
                        this.val$finalViewToKeep = view;
                        this.val$finalVisibility = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_2$__constructor__(android.transition.Visibility boolean android.view.View int ), 0, this, visibility, bl, view, n);
                    }

                    @Override
                    public void onAnimationPause(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationPause", $$robo$$android_transition_Visibility_2$onAnimationPause(android.animation.Animator ), 0, this, animator2);
                    }

                    @Override
                    public void onAnimationResume(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationResume", $$robo$$android_transition_Visibility_2$onAnimationResume(android.animation.Animator ), 0, this, animator2);
                    }

                    @Override
                    public void onAnimationCancel(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_transition_Visibility_2$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_Visibility_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else if (!isForcedVisibility) {
                viewToKeep.setVisibility(originalVisibility);
            }
            return animator3;
        }
        return null;
    }

    private final boolean $$robo$$android_transition_Visibility$areValuesChanged(TransitionValues oldValues, TransitionValues newValues) {
        VisibilityInfo changeInfo = this.getVisibilityChangeInfo(oldValues, newValues);
        if (oldValues == null && newValues == null) {
            return false;
        }
        return changeInfo.visibilityChange && (changeInfo.startVisibility == 0 || changeInfo.endVisibility == 0);
    }

    private final Animator $$robo$$android_transition_Visibility$onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    static void __staticInitializer__() {
        sTransitionProperties = new String[]{"android:visibility:visibility"};
    }

    private void __constructor__() {
        this.$$robo$$android_transition_Visibility$__constructor__();
    }

    public Visibility() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_Visibility$__constructor__(context, attributeSet);
    }

    public Visibility(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    public void setMode(int n) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_transition_Visibility$setMode(int ), 0, this, n);
    }

    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_transition_Visibility$getMode(), 0, this);
    }

    @Override
    public String[] getTransitionProperties() {
        return InvokeDynamicSupport.bootstrap("getTransitionProperties", $$robo$$android_transition_Visibility$getTransitionProperties(), 0, this);
    }

    private void captureValues(TransitionValues transitionValues, int n) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_Visibility$captureValues(android.transition.TransitionValues int ), 0, this, transitionValues, n);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_Visibility$captureStartValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_Visibility$captureEndValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void forceVisibility(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("forceVisibility", $$robo$$android_transition_Visibility$forceVisibility(int boolean ), 0, this, n, bl);
    }

    public boolean isVisible(TransitionValues transitionValues) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_transition_Visibility$isVisible(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    private VisibilityInfo getVisibilityChangeInfo(TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("getVisibilityChangeInfo", $$robo$$android_transition_Visibility$getVisibilityChangeInfo(android.transition.TransitionValues android.transition.TransitionValues ), 0, this, transitionValues, transitionValues2);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_transition_Visibility$createAnimator(android.view.ViewGroup android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transitionValues, transitionValues2);
    }

    public Animator onAppear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        return InvokeDynamicSupport.bootstrap("onAppear", $$robo$$android_transition_Visibility$onAppear(android.view.ViewGroup android.transition.TransitionValues int android.transition.TransitionValues int ), 0, this, viewGroup, transitionValues, n, transitionValues2, n2);
    }

    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onAppear", $$robo$$android_transition_Visibility$onAppear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, view, transitionValues, transitionValues2);
    }

    public Animator onDisappear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        return InvokeDynamicSupport.bootstrap("onDisappear", $$robo$$android_transition_Visibility$onDisappear(android.view.ViewGroup android.transition.TransitionValues int android.transition.TransitionValues int ), 0, this, viewGroup, transitionValues, n, transitionValues2, n2);
    }

    @Override
    boolean areValuesChanged(TransitionValues transitionValues, TransitionValues transitionValues2) {
        return (boolean)InvokeDynamicSupport.bootstrap("areValuesChanged", $$robo$$android_transition_Visibility$areValuesChanged(android.transition.TransitionValues android.transition.TransitionValues ), 0, this, transitionValues, transitionValues2);
    }

    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onDisappear", $$robo$$android_transition_Visibility$onDisappear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, view, transitionValues, transitionValues2);
    }

    static {
        RobolectricInternals.classInitializing(Visibility.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Visibility)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class VisibilityInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean visibilityChange;
        boolean fadeIn;
        int startVisibility;
        int endVisibility;
        ViewGroup startParent;
        ViewGroup endParent;

        private void $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_transition_Visibility_VisibilityInfo$__constructor__();
        }

        private VisibilityInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VisibilityInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

