/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Range<T extends Comparable<? super T>> {
    public transient /* synthetic */ Object __robo_data__;
    private T mLower;
    private T mUpper;

    private void $$robo$$android_util_Range$__constructor__(T lower, T upper) {
        this.mLower = (Comparable)Preconditions.checkNotNull(lower, "lower must not be null");
        this.mUpper = (Comparable)Preconditions.checkNotNull(upper, "upper must not be null");
        if (lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("lower must be less than or equal to upper");
        }
    }

    private static final <T extends Comparable<? super T>> Range<T> $$robo$$android_util_Range$create(T lower, T upper) {
        return new Range<T>(lower, upper);
    }

    private final T $$robo$$android_util_Range$getLower() {
        return this.mLower;
    }

    private final T $$robo$$android_util_Range$getUpper() {
        return this.mUpper;
    }

    private final boolean $$robo$$android_util_Range$contains(T value) {
        Preconditions.checkNotNull(value, "value must not be null");
        boolean gteLower = value.compareTo(this.mLower) >= 0;
        boolean lteUpper = value.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    private final boolean $$robo$$android_util_Range$contains(Range<T> range) {
        Preconditions.checkNotNull(range, "value must not be null");
        boolean gteLower = range.mLower.compareTo(this.mLower) >= 0;
        boolean lteUpper = range.mUpper.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    private final boolean $$robo$$android_util_Range$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return this.mLower.equals(other.mLower) && this.mUpper.equals(other.mUpper);
        }
        return false;
    }

    private final T $$robo$$android_util_Range$clamp(T value) {
        Preconditions.checkNotNull(value, "value must not be null");
        if (value.compareTo(this.mLower) < 0) {
            return this.mLower;
        }
        if (value.compareTo(this.mUpper) > 0) {
            return this.mUpper;
        }
        return value;
    }

    private final Range<T> $$robo$$android_util_Range$intersect(Range<T> range) {
        Preconditions.checkNotNull(range, "range must not be null");
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return range;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : range.mLower, cmpUpper >= 0 ? this.mUpper : range.mUpper);
    }

    private final Range<T> $$robo$$android_util_Range$intersect(T lower, T upper) {
        Preconditions.checkNotNull(lower, "lower must not be null");
        Preconditions.checkNotNull(upper, "upper must not be null");
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : lower, cmpUpper >= 0 ? this.mUpper : upper);
    }

    private final Range<T> $$robo$$android_util_Range$extend(Range<T> range) {
        Preconditions.checkNotNull(range, "range must not be null");
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return range;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : range.mLower, cmpUpper <= 0 ? this.mUpper : range.mUpper);
    }

    private final Range<T> $$robo$$android_util_Range$extend(T lower, T upper) {
        Preconditions.checkNotNull(lower, "lower must not be null");
        Preconditions.checkNotNull(upper, "upper must not be null");
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : lower, cmpUpper <= 0 ? this.mUpper : upper);
    }

    private final Range<T> $$robo$$android_util_Range$extend(T value) {
        Preconditions.checkNotNull(value, "value must not be null");
        return this.extend(value, value);
    }

    private final String $$robo$$android_util_Range$toString() {
        return String.format("[%s, %s]", this.mLower, this.mUpper);
    }

    private final int $$robo$$android_util_Range$hashCode() {
        return HashCodeHelpers.hashCode(this.mLower, this.mUpper);
    }

    private void __constructor__(T t, T t2) {
        this.$$robo$$android_util_Range$__constructor__(t, t2);
    }

    public Range(T t, T t2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_Range$__constructor__(T T ), 0, this, t, t2);
    }

    public static <T extends Comparable<? super T>> Range<T> create(T t, T t2) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_util_Range$create(T T ), 0, t, t2);
    }

    public T getLower() {
        return (T)InvokeDynamicSupport.bootstrap("getLower", $$robo$$android_util_Range$getLower(), 0, this);
    }

    public T getUpper() {
        return (T)InvokeDynamicSupport.bootstrap("getUpper", $$robo$$android_util_Range$getUpper(), 0, this);
    }

    public boolean contains(T t) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_util_Range$contains(T ), 0, this, t);
    }

    public boolean contains(Range<T> range) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_util_Range$contains(android.util.Range<T> ), 0, this, range);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_Range$equals(java.lang.Object ), 0, this, object);
    }

    public T clamp(T t) {
        return (T)InvokeDynamicSupport.bootstrap("clamp", $$robo$$android_util_Range$clamp(T ), 0, this, t);
    }

    public Range<T> intersect(Range<T> range) {
        return InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_util_Range$intersect(android.util.Range<T> ), 0, this, range);
    }

    public Range<T> intersect(T t, T t2) {
        return InvokeDynamicSupport.bootstrap("intersect", $$robo$$android_util_Range$intersect(T T ), 0, this, t, t2);
    }

    public Range<T> extend(Range<T> range) {
        return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_util_Range$extend(T ), 0, this, range);
    }

    public Range<T> extend(T t, T t2) {
        return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_util_Range$extend(T T ), 0, this, t, t2);
    }

    public Range<T> extend(T t) {
        return InvokeDynamicSupport.bootstrap("extend", $$robo$$android_util_Range$extend(T ), 0, this, t);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_Range$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_Range$hashCode(), 0, this);
    }

    public /* synthetic */ Range() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Range)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

