/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.ViewRootImpl;
import com.google.errorprone.annotations.DoNotMock;
import java.text.BreakIterator;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityIterators
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_view_AccessibilityIterators$__constructor__() {
    }

    private void __constructor__() {
        this.$$robo$$android_view_AccessibilityIterators$__constructor__();
    }

    public AccessibilityIterators() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityIterators$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityIterators)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ParagraphTextSegmentIterator
    extends AbstractTextSegmentIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static ParagraphTextSegmentIterator sInstance;

        private void $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$__constructor__() {
        }

        private static final ParagraphTextSegmentIterator $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$getInstance() {
            if (sInstance == null) {
                sInstance = new ParagraphTextSegmentIterator();
            }
            return sInstance;
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$following(int offset) {
            int end;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset >= textLength) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (start < textLength && this.mText.charAt(start) == '\n' && !this.isStartBoundary(start)) {
                ++start;
            }
            if (start >= textLength) {
                return null;
            }
            for (end = start + 1; end < textLength && !this.isEndBoundary(end); ++end) {
            }
            return this.getRange(start, end);
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$preceding(int offset) {
            int start;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLength) {
                end = textLength;
            }
            while (end > 0 && this.mText.charAt(end - 1) == '\n' && !this.isEndBoundary(end)) {
                --end;
            }
            if (end <= 0) {
                return null;
            }
            for (start = end - 1; start > 0 && !this.isStartBoundary(start); --start) {
            }
            return this.getRange(start, end);
        }

        private final boolean $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$isStartBoundary(int index) {
            return this.mText.charAt(index) != '\n' && (index == 0 || this.mText.charAt(index - 1) == '\n');
        }

        private final boolean $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$isEndBoundary(int index) {
            return index > 0 && this.mText.charAt(index - 1) != '\n' && (index == this.mText.length() || this.mText.charAt(index) == '\n');
        }

        private void __constructor__() {
            this.$$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$__constructor__();
        }

        ParagraphTextSegmentIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$__constructor__(), 0, this);
        }

        public static ParagraphTextSegmentIterator getInstance() {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$getInstance(), 0);
        }

        @Override
        public int[] following(int n) {
            return InvokeDynamicSupport.bootstrap("following", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$following(int ), 0, this, n);
        }

        @Override
        public int[] preceding(int n) {
            return InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$preceding(int ), 0, this, n);
        }

        private boolean isStartBoundary(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isStartBoundary", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$isStartBoundary(int ), 0, this, n);
        }

        private boolean isEndBoundary(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEndBoundary", $$robo$$android_view_AccessibilityIterators_ParagraphTextSegmentIterator$isEndBoundary(int ), 0, this, n);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParagraphTextSegmentIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WordTextSegmentIterator
    extends CharacterTextSegmentIterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static WordTextSegmentIterator sInstance;

        private static final WordTextSegmentIterator $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new WordTextSegmentIterator(locale);
            }
            return sInstance;
        }

        private void $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$__constructor__(Locale locale) {
        }

        private final void $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getWordInstance(locale);
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$following(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (!this.isLetterOrDigit(start) && !this.isStartBoundary(start)) {
                if ((start = this.mImpl.following(start)) != -1) continue;
                return null;
            }
            int end = this.mImpl.following(start);
            if (end == -1 || !this.isEndBoundary(end)) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$preceding(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLegth) {
                end = textLegth;
            }
            while (end > 0 && !this.isLetterOrDigit(end - 1) && !this.isEndBoundary(end)) {
                if ((end = this.mImpl.preceding(end)) != -1) continue;
                return null;
            }
            int start = this.mImpl.preceding(end);
            if (start == -1 || !this.isStartBoundary(start)) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final boolean $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isStartBoundary(int index) {
            return this.isLetterOrDigit(index) && (index == 0 || !this.isLetterOrDigit(index - 1));
        }

        private final boolean $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isEndBoundary(int index) {
            return index > 0 && this.isLetterOrDigit(index - 1) && (index == this.mText.length() || !this.isLetterOrDigit(index));
        }

        private final boolean $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isLetterOrDigit(int index) {
            if (index >= 0 && index < this.mText.length()) {
                int codePoint = this.mText.codePointAt(index);
                return Character.isLetterOrDigit(codePoint);
            }
            return false;
        }

        public static WordTextSegmentIterator getInstance(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$getInstance(java.util.Locale ), 0, (Locale)locale);
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$__constructor__(locale);
        }

        private WordTextSegmentIterator(Locale locale) {
            super(locale);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$__constructor__(java.util.Locale ), 0, this, locale);
        }

        @Override
        protected void onLocaleChanged(Locale locale) {
            InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$onLocaleChanged(java.util.Locale ), 0, this, locale);
        }

        @Override
        public int[] following(int n) {
            return InvokeDynamicSupport.bootstrap("following", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$following(int ), 0, this, n);
        }

        @Override
        public int[] preceding(int n) {
            return InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$preceding(int ), 0, this, n);
        }

        private boolean isStartBoundary(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isStartBoundary", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isStartBoundary(int ), 0, this, n);
        }

        private boolean isEndBoundary(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEndBoundary", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isEndBoundary(int ), 0, this, n);
        }

        private boolean isLetterOrDigit(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isLetterOrDigit", $$robo$$android_view_AccessibilityIterators_WordTextSegmentIterator$isLetterOrDigit(int ), 0, this, n);
        }

        public /* synthetic */ WordTextSegmentIterator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WordTextSegmentIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CharacterTextSegmentIterator
    extends AbstractTextSegmentIterator
    implements ComponentCallbacks,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static CharacterTextSegmentIterator sInstance;
        private Locale mLocale;
        protected BreakIterator mImpl;

        private static final CharacterTextSegmentIterator $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new CharacterTextSegmentIterator(locale);
            }
            return sInstance;
        }

        private void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$__constructor__(Locale locale) {
            this.mLocale = locale;
            this.onLocaleChanged(locale);
            ViewRootImpl.addConfigCallback(this);
        }

        private final void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$initialize(String text) {
            super.initialize(text);
            this.mImpl.setText(text);
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$following(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= textLegth) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (!this.mImpl.isBoundary(start)) {
                if ((start = this.mImpl.following(start)) != -1) continue;
                return null;
            }
            int end = this.mImpl.following(start);
            if (end == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$preceding(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLegth) {
                end = textLegth;
            }
            while (!this.mImpl.isBoundary(end)) {
                if ((end = this.mImpl.preceding(end)) != -1) continue;
                return null;
            }
            int start = this.mImpl.preceding(end);
            if (start == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        private final void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onConfigurationChanged(Configuration newConfig) {
            Locale locale = newConfig.locale;
            if (!this.mLocale.equals(locale)) {
                this.mLocale = locale;
                this.onLocaleChanged(locale);
            }
        }

        private final void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onLowMemory() {
        }

        private final void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getCharacterInstance(locale);
        }

        private /* synthetic */ void $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$__constructor__(Locale x0, 1 x1) {
        }

        public static CharacterTextSegmentIterator getInstance(Locale locale) {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$getInstance(java.util.Locale ), 0, (Locale)locale);
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$__constructor__(locale);
        }

        private CharacterTextSegmentIterator(Locale locale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$__constructor__(java.util.Locale ), 0, this, locale);
        }

        @Override
        public void initialize(String string2) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$initialize(java.lang.String ), 0, this, string2);
        }

        @Override
        public int[] following(int n) {
            return InvokeDynamicSupport.bootstrap("following", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$following(int ), 0, this, n);
        }

        @Override
        public int[] preceding(int n) {
            return InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$preceding(int ), 0, this, n);
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
        }

        @Override
        public void onLowMemory() {
            InvokeDynamicSupport.bootstrap("onLowMemory", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onLowMemory(), 0, this);
        }

        protected void onLocaleChanged(Locale locale) {
            InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$onLocaleChanged(java.util.Locale ), 0, this, locale);
        }

        private /* synthetic */ void __constructor__(Locale locale, 1 var2_2) {
            this.$$robo$$android_view_AccessibilityIterators_CharacterTextSegmentIterator$__constructor__(locale, var2_2);
        }

        public /* synthetic */ CharacterTextSegmentIterator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharacterTextSegmentIterator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AbstractTextSegmentIterator
    implements TextSegmentIterator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected String mText;
        private int[] mSegment;

        private void $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$__constructor__() {
            this.mSegment = new int[2];
        }

        private final void $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$initialize(String text) {
            this.mText = text;
        }

        private final int[] $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$getRange(int start, int end) {
            if (start < 0 || end < 0 || start == end) {
                return null;
            }
            this.mSegment[0] = start;
            this.mSegment[1] = end;
            return this.mSegment;
        }

        private void __constructor__() {
            this.$$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$__constructor__();
        }

        public AbstractTextSegmentIterator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$__constructor__(), 0, this);
        }

        public void initialize(String string2) {
            InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$initialize(java.lang.String ), 0, this, string2);
        }

        protected int[] getRange(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getRange", $$robo$$android_view_AccessibilityIterators_AbstractTextSegmentIterator$getRange(int int ), 0, this, n, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractTextSegmentIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TextSegmentIterator
    extends InstrumentedInterface {
        public int[] following(int var1);

        public int[] preceding(int var1);
    }
}

