/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Display
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Display";
    private static boolean DEBUG = false;
    private DisplayManagerGlobal mGlobal;
    private int mDisplayId;
    private int mLayerStack;
    private int mFlags;
    private int mType;
    private String mAddress;
    private int mOwnerUid;
    private String mOwnerPackageName;
    private DisplayAdjustments mDisplayAdjustments;
    private DisplayInfo mDisplayInfo;
    private boolean mIsValid;
    private DisplayMetrics mTempMetrics;
    private static int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private long mLastCachedAppSizeUpdate;
    private int mCachedAppWidthCompat;
    private int mCachedAppHeightCompat;
    public static int DEFAULT_DISPLAY = 0;
    public static int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static int FLAG_SECURE = 2;
    public static int FLAG_PRIVATE = 4;
    public static int FLAG_PRESENTATION = 8;
    public static int TYPE_UNKNOWN = 0;
    public static int TYPE_BUILT_IN = 1;
    public static int TYPE_HDMI = 2;
    public static int TYPE_WIFI = 3;
    public static int TYPE_OVERLAY = 4;
    public static int TYPE_VIRTUAL = 5;
    public static int STATE_UNKNOWN = 0;
    public static int STATE_OFF = 1;
    public static int STATE_ON = 2;
    public static int STATE_DOZE = 3;
    public static int STATE_DOZE_SUSPEND = 4;

    private void $$robo$$android_view_Display$__constructor__(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj) {
        this.mTempMetrics = new DisplayMetrics();
        this.mGlobal = global;
        this.mDisplayId = displayId;
        this.mDisplayInfo = displayInfo;
        this.mDisplayAdjustments = new DisplayAdjustments(daj);
        this.mIsValid = true;
        this.mLayerStack = displayInfo.layerStack;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mAddress = displayInfo.address;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    private final int $$robo$$android_view_Display$getDisplayId() {
        return this.mDisplayId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$isValid() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$getDisplayInfo(DisplayInfo outDisplayInfo) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outDisplayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    private final int $$robo$$android_view_Display$getLayerStack() {
        return this.mLayerStack;
    }

    private final int $$robo$$android_view_Display$getFlags() {
        return this.mFlags;
    }

    private final int $$robo$$android_view_Display$getType() {
        return this.mType;
    }

    private final String $$robo$$android_view_Display$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_view_Display$getOwnerUid() {
        return this.mOwnerUid;
    }

    private final String $$robo$$android_view_Display$getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    private final DisplayAdjustments $$robo$$android_view_Display$getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_view_Display$getName() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            outSize.x = this.mTempMetrics.widthPixels;
            outSize.y = this.mTempMetrics.heightPixels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRectSize(Rect outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            outSize.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSmallestSize.x = this.mDisplayInfo.smallestNominalAppWidth;
            outSmallestSize.y = this.mDisplayInfo.smallestNominalAppHeight;
            outLargestSize.x = this.mDisplayInfo.largestNominalAppWidth;
            outLargestSize.y = this.mDisplayInfo.largestNominalAppHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getMaximumSizeDimension() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_view_Display$getWidth() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_view_Display$getHeight() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getOverscanInsets(Rect outRect) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outRect.set(this.mDisplayInfo.overscanLeft, this.mDisplayInfo.overscanTop, this.mDisplayInfo.overscanRight, this.mDisplayInfo.overscanBottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getRotation() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.rotation;
        }
    }

    @Deprecated
    private final int $$robo$$android_view_Display$getOrientation() {
        return this.getRotation();
    }

    @Deprecated
    private final int $$robo$$android_view_Display$getPixelFormat() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final float $$robo$$android_view_Display$getRefreshRate() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.refreshRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final float[] $$robo$$android_view_Display$getSupportedRefreshRates() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            float[] refreshRates = this.mDisplayInfo.supportedRefreshRates;
            return Arrays.copyOf(refreshRates, refreshRates.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_view_Display$getAppVsyncOffsetNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_view_Display$getPresentationDeadlineNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(outMetrics, this.mDisplayAdjustments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRealSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSize.x = this.mDisplayInfo.logicalWidth;
            outSize.y = this.mDisplayInfo.logicalHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRealMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getLogicalMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, this.mDisplayAdjustments.getActivityToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getState() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.state : 0;
        }
    }

    private final boolean $$robo$$android_view_Display$hasAccess(int uid) {
        return Display.hasAccess(uid, this.mFlags, this.mOwnerUid);
    }

    private static final boolean $$robo$$android_view_Display$hasAccess(int uid, int flags, int ownerUid) {
        return (flags & 4) == 0 || uid == ownerUid || uid == 1000 || uid == 0;
    }

    private final boolean $$robo$$android_view_Display$isPublicPresentation() {
        return (this.mFlags & 0xC) == 8;
    }

    private final void $$robo$$android_view_Display$updateDisplayInfoLocked() {
        DisplayInfo newInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (newInfo == null) {
            if (this.mIsValid) {
                this.mIsValid = false;
            }
        } else {
            this.mDisplayInfo = newInfo;
            if (!this.mIsValid) {
                this.mIsValid = true;
            }
        }
    }

    private final void $$robo$$android_view_Display$updateCachedAppSizeIfNeededLocked() {
        long now = SystemClock.uptimeMillis();
        if (now > this.mLastCachedAppSizeUpdate + 20L) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_view_Display$toString() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + ", " + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }

    private static final String $$robo$$android_view_Display$typeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "BUILT_IN";
            }
            case 2: {
                return "HDMI";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: {
                return "VIRTUAL";
            }
        }
        return Integer.toString(type);
    }

    private static final String $$robo$$android_view_Display$stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: {
                return "DOZE_SUSPEND";
            }
        }
        return Integer.toString(state);
    }

    private static final boolean $$robo$$android_view_Display$isSuspendedState(int state) {
        return state == 1 || state == 4;
    }

    private void __constructor__(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments) {
        this.$$robo$$android_view_Display$__constructor__(displayManagerGlobal, n, displayInfo, displayAdjustments);
    }

    public Display(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display$__constructor__(android.hardware.display.DisplayManagerGlobal int android.view.DisplayInfo android.view.DisplayAdjustments ), 0, this, displayManagerGlobal, n, displayInfo, displayAdjustments);
    }

    public int getDisplayId() {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayId", $$robo$$android_view_Display$getDisplayId(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_view_Display$isValid(), 0, this);
    }

    public boolean getDisplayInfo(DisplayInfo displayInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("getDisplayInfo", $$robo$$android_view_Display$getDisplayInfo(android.view.DisplayInfo ), 0, this, displayInfo);
    }

    public int getLayerStack() {
        return (int)InvokeDynamicSupport.bootstrap("getLayerStack", $$robo$$android_view_Display$getLayerStack(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_view_Display$getFlags(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_view_Display$getType(), 0, this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_view_Display$getAddress(), 0, this);
    }

    public int getOwnerUid() {
        return (int)InvokeDynamicSupport.bootstrap("getOwnerUid", $$robo$$android_view_Display$getOwnerUid(), 0, this);
    }

    public String getOwnerPackageName() {
        return InvokeDynamicSupport.bootstrap("getOwnerPackageName", $$robo$$android_view_Display$getOwnerPackageName(), 0, this);
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return InvokeDynamicSupport.bootstrap("getDisplayAdjustments", $$robo$$android_view_Display$getDisplayAdjustments(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_view_Display$getName(), 0, this);
    }

    public void getSize(Point point) {
        InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_view_Display$getSize(android.graphics.Point ), 0, this, point);
    }

    public void getRectSize(Rect rect) {
        InvokeDynamicSupport.bootstrap("getRectSize", $$robo$$android_view_Display$getRectSize(android.graphics.Rect ), 0, this, rect);
    }

    public void getCurrentSizeRange(Point point, Point point2) {
        InvokeDynamicSupport.bootstrap("getCurrentSizeRange", $$robo$$android_view_Display$getCurrentSizeRange(android.graphics.Point android.graphics.Point ), 0, this, point, point2);
    }

    public int getMaximumSizeDimension() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumSizeDimension", $$robo$$android_view_Display$getMaximumSizeDimension(), 0, this);
    }

    @Deprecated
    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_view_Display$getWidth(), 0, this);
    }

    @Deprecated
    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_view_Display$getHeight(), 0, this);
    }

    public void getOverscanInsets(Rect rect) {
        InvokeDynamicSupport.bootstrap("getOverscanInsets", $$robo$$android_view_Display$getOverscanInsets(android.graphics.Rect ), 0, this, rect);
    }

    public int getRotation() {
        return (int)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_view_Display$getRotation(), 0, this);
    }

    @Deprecated
    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_view_Display$getOrientation(), 0, this);
    }

    @Deprecated
    public int getPixelFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getPixelFormat", $$robo$$android_view_Display$getPixelFormat(), 0, this);
    }

    public float getRefreshRate() {
        return (float)InvokeDynamicSupport.bootstrap("getRefreshRate", $$robo$$android_view_Display$getRefreshRate(), 0, this);
    }

    public float[] getSupportedRefreshRates() {
        return InvokeDynamicSupport.bootstrap("getSupportedRefreshRates", $$robo$$android_view_Display$getSupportedRefreshRates(), 0, this);
    }

    public long getAppVsyncOffsetNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getAppVsyncOffsetNanos", $$robo$$android_view_Display$getAppVsyncOffsetNanos(), 0, this);
    }

    public long getPresentationDeadlineNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getPresentationDeadlineNanos", $$robo$$android_view_Display$getPresentationDeadlineNanos(), 0, this);
    }

    public void getMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_view_Display$getMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public void getRealSize(Point point) {
        InvokeDynamicSupport.bootstrap("getRealSize", $$robo$$android_view_Display$getRealSize(android.graphics.Point ), 0, this, point);
    }

    public void getRealMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("getRealMetrics", $$robo$$android_view_Display$getRealMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_view_Display$getState(), 0, this);
    }

    public boolean hasAccess(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAccess", $$robo$$android_view_Display$hasAccess(int ), 0, this, n);
    }

    public static boolean hasAccess(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasAccess", $$robo$$android_view_Display$hasAccess(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public boolean isPublicPresentation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPublicPresentation", $$robo$$android_view_Display$isPublicPresentation(), 0, this);
    }

    private void updateDisplayInfoLocked() {
        InvokeDynamicSupport.bootstrap("updateDisplayInfoLocked", $$robo$$android_view_Display$updateDisplayInfoLocked(), 0, this);
    }

    private void updateCachedAppSizeIfNeededLocked() {
        InvokeDynamicSupport.bootstrap("updateCachedAppSizeIfNeededLocked", $$robo$$android_view_Display$updateCachedAppSizeIfNeededLocked(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_Display$toString(), 0, this);
    }

    public static String typeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_view_Display$typeToString(int ), 0, (int)n);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_view_Display$stateToString(int ), 0, (int)n);
    }

    public static boolean isSuspendedState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSuspendedState", $$robo$$android_view_Display$isSuspendedState(int ), 0, (int)n);
    }

    public /* synthetic */ Display() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Display)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

