/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FocusFinder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static ThreadLocal<FocusFinder> tlFocusFinder;
    Rect mFocusedRect;
    Rect mOtherRect;
    Rect mBestCandidateRect;
    SequentialFocusComparator mSequentialFocusComparator;
    private ArrayList<View> mTempList;

    private static final FocusFinder $$robo$$android_view_FocusFinder$getInstance() {
        return tlFocusFinder.get();
    }

    private void $$robo$$android_view_FocusFinder$__constructor__() {
        this.mFocusedRect = new Rect();
        this.mOtherRect = new Rect();
        this.mBestCandidateRect = new Rect();
        this.mSequentialFocusComparator = new SequentialFocusComparator();
        this.mTempList = new ArrayList();
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, int direction) {
        return this.findNextFocus(root, focused, null, direction);
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocusFromRect(ViewGroup root, Rect focusedRect, int direction) {
        this.mFocusedRect.set(focusedRect);
        return this.findNextFocus(root, null, this.mFocusedRect, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction) {
        View next = null;
        if (focused != null) {
            next = this.findNextUserSpecifiedFocus(root, focused, direction);
        }
        if (next != null) {
            return next;
        }
        ArrayList<View> focusables = this.mTempList;
        try {
            focusables.clear();
            root.addFocusables(focusables, direction);
            if (!focusables.isEmpty()) {
                next = this.findNextFocus(root, focused, focusedRect, direction, focusables);
            }
        }
        finally {
            focusables.clear();
        }
        return next;
    }

    private final View $$robo$$android_view_FocusFinder$findNextUserSpecifiedFocus(ViewGroup root, View focused, int direction) {
        View userSetNextFocus = focused.findUserSetNextFocus(root, direction);
        if (userSetNextFocus != null && userSetNextFocus.isFocusable() && (!userSetNextFocus.isInTouchMode() || userSetNextFocus.isFocusableInTouchMode())) {
            return userSetNextFocus;
        }
        return null;
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction, ArrayList<View> focusables) {
        if (focused != null) {
            if (focusedRect == null) {
                focusedRect = this.mFocusedRect;
            }
            focused.getFocusedRect(focusedRect);
            root.offsetDescendantRectToMyCoords(focused, focusedRect);
        } else if (focusedRect == null) {
            focusedRect = this.mFocusedRect;
            switch (direction) {
                case 66: 
                case 130: {
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 2: {
                    if (root.isLayoutRtl()) {
                        this.setFocusBottomRight(root, focusedRect);
                        break;
                    }
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 17: 
                case 33: {
                    this.setFocusBottomRight(root, focusedRect);
                    break;
                }
                case 1: {
                    if (root.isLayoutRtl()) {
                        this.setFocusTopLeft(root, focusedRect);
                        break;
                    }
                    this.setFocusBottomRight(root, focusedRect);
                }
            }
        }
        switch (direction) {
            case 1: 
            case 2: {
                return this.findNextFocusInRelativeDirection(focusables, root, focused, focusedRect, direction);
            }
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return this.findNextFocusInAbsoluteDirection(focusables, root, focused, focusedRect, direction);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextFocusInRelativeDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        try {
            this.mSequentialFocusComparator.setRoot(root);
            this.mSequentialFocusComparator.setIsLayoutRtl(root.isLayoutRtl());
            Collections.sort(focusables, this.mSequentialFocusComparator);
        }
        finally {
            this.mSequentialFocusComparator.recycle();
        }
        int count = focusables.size();
        switch (direction) {
            case 2: {
                return FocusFinder.getNextFocusable(focused, focusables, count);
            }
            case 1: {
                return FocusFinder.getPreviousFocusable(focused, focusables, count);
            }
        }
        return focusables.get(count - 1);
    }

    private final void $$robo$$android_view_FocusFinder$setFocusBottomRight(ViewGroup root, Rect focusedRect) {
        int rootBottom = root.getScrollY() + root.getHeight();
        int rootRight = root.getScrollX() + root.getWidth();
        focusedRect.set(rootRight, rootBottom, rootRight, rootBottom);
    }

    private final void $$robo$$android_view_FocusFinder$setFocusTopLeft(ViewGroup root, Rect focusedRect) {
        int rootTop = root.getScrollY();
        int rootLeft = root.getScrollX();
        focusedRect.set(rootLeft, rootTop, rootLeft, rootTop);
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocusInAbsoluteDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        this.mBestCandidateRect.set(focusedRect);
        switch (direction) {
            case 17: {
                this.mBestCandidateRect.offset(focusedRect.width() + 1, 0);
                break;
            }
            case 66: {
                this.mBestCandidateRect.offset(-(focusedRect.width() + 1), 0);
                break;
            }
            case 33: {
                this.mBestCandidateRect.offset(0, focusedRect.height() + 1);
                break;
            }
            case 130: {
                this.mBestCandidateRect.offset(0, -(focusedRect.height() + 1));
            }
        }
        View closest = null;
        int numFocusables = focusables.size();
        for (int i = 0; i < numFocusables; ++i) {
            View focusable = focusables.get(i);
            if (focusable == focused || focusable == root) continue;
            focusable.getFocusedRect(this.mOtherRect);
            root.offsetDescendantRectToMyCoords(focusable, this.mOtherRect);
            if (!this.isBetterCandidate(direction, focusedRect, this.mOtherRect, this.mBestCandidateRect)) continue;
            this.mBestCandidateRect.set(this.mOtherRect);
            closest = focusable;
        }
        return closest;
    }

    private static final View $$robo$$android_view_FocusFinder$getNextFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.lastIndexOf(focused)) >= 0 && position + 1 < count) {
            return focusables.get(position + 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(0);
        }
        return null;
    }

    private static final View $$robo$$android_view_FocusFinder$getPreviousFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.indexOf(focused)) > 0) {
            return focusables.get(position - 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(count - 1);
        }
        return null;
    }

    private final boolean $$robo$$android_view_FocusFinder$isBetterCandidate(int direction, Rect source, Rect rect1, Rect rect2) {
        if (!this.isCandidate(source, rect1, direction)) {
            return false;
        }
        if (!this.isCandidate(source, rect2, direction)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect1, rect2)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect2, rect1)) {
            return false;
        }
        return this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect1), FocusFinder.minorAxisDistance(direction, source, rect1)) < this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect2), FocusFinder.minorAxisDistance(direction, source, rect2));
    }

    private final boolean $$robo$$android_view_FocusFinder$beamBeats(int direction, Rect source, Rect rect1, Rect rect2) {
        boolean rect1InSrcBeam = this.beamsOverlap(direction, source, rect1);
        boolean rect2InSrcBeam = this.beamsOverlap(direction, source, rect2);
        if (rect2InSrcBeam || !rect1InSrcBeam) {
            return false;
        }
        if (!this.isToDirectionOf(direction, source, rect2)) {
            return true;
        }
        if (direction == 17 || direction == 66) {
            return true;
        }
        return FocusFinder.majorAxisDistance(direction, source, rect1) < FocusFinder.majorAxisDistanceToFarEdge(direction, source, rect2);
    }

    private final int $$robo$$android_view_FocusFinder$getWeightedDistanceFor(int majorAxisDistance, int minorAxisDistance) {
        return 13 * majorAxisDistance * majorAxisDistance + minorAxisDistance * minorAxisDistance;
    }

    private final boolean $$robo$$android_view_FocusFinder$isCandidate(Rect srcRect, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final boolean $$robo$$android_view_FocusFinder$beamsOverlap(int direction, Rect rect1, Rect rect2) {
        switch (direction) {
            case 17: 
            case 66: {
                return rect2.bottom >= rect1.top && rect2.top <= rect1.bottom;
            }
            case 33: 
            case 130: {
                return rect2.right >= rect1.left && rect2.left <= rect1.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final boolean $$robo$$android_view_FocusFinder$isToDirectionOf(int direction, Rect src, Rect dest) {
        switch (direction) {
            case 17: {
                return src.left >= dest.right;
            }
            case 66: {
                return src.right <= dest.left;
            }
            case 33: {
                return src.top >= dest.bottom;
            }
            case 130: {
                return src.bottom <= dest.top;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistance(int direction, Rect source, Rect dest) {
        return Math.max(0, FocusFinder.majorAxisDistanceRaw(direction, source, dest));
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.right;
            }
            case 66: {
                return dest.left - source.right;
            }
            case 33: {
                return source.top - dest.bottom;
            }
            case 130: {
                return dest.top - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdge(int direction, Rect source, Rect dest) {
        return Math.max(1, FocusFinder.majorAxisDistanceToFarEdgeRaw(direction, source, dest));
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdgeRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.left;
            }
            case 66: {
                return dest.right - source.right;
            }
            case 33: {
                return source.top - dest.top;
            }
            case 130: {
                return dest.bottom - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$minorAxisDistance(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: 
            case 66: {
                return Math.abs(source.top + source.height() / 2 - (dest.top + dest.height() / 2));
            }
            case 33: 
            case 130: {
                return Math.abs(source.left + source.width() / 2 - (dest.left + dest.width() / 2));
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final View $$robo$$android_view_FocusFinder$findNearestTouchable(ViewGroup root, int x, int y, int direction, int[] deltas) {
        ArrayList<View> touchables = root.getTouchables();
        int minDistance = Integer.MAX_VALUE;
        View closest = null;
        int numTouchables = touchables.size();
        int edgeSlop = ViewConfiguration.get(root.mContext).getScaledEdgeSlop();
        Rect closestBounds = new Rect();
        Rect touchableBounds = this.mOtherRect;
        block12: for (int i = 0; i < numTouchables; ++i) {
            View touchable = touchables.get(i);
            touchable.getDrawingRect(touchableBounds);
            root.offsetRectBetweenParentAndChild(touchable, touchableBounds, true, true);
            if (!this.isTouchCandidate(x, y, touchableBounds, direction)) continue;
            int distance = Integer.MAX_VALUE;
            switch (direction) {
                case 17: {
                    distance = x - touchableBounds.right + 1;
                    break;
                }
                case 66: {
                    distance = touchableBounds.left;
                    break;
                }
                case 33: {
                    distance = y - touchableBounds.bottom + 1;
                    break;
                }
                case 130: {
                    distance = touchableBounds.top;
                }
            }
            if (distance >= edgeSlop || closest != null && !closestBounds.contains(touchableBounds) && (touchableBounds.contains(closestBounds) || distance >= minDistance)) continue;
            minDistance = distance;
            closest = touchable;
            closestBounds.set(touchableBounds);
            switch (direction) {
                case 17: {
                    deltas[0] = -distance;
                    continue block12;
                }
                case 66: {
                    deltas[0] = distance;
                    continue block12;
                }
                case 33: {
                    deltas[1] = -distance;
                    continue block12;
                }
                case 130: {
                    deltas[1] = distance;
                }
            }
        }
        return closest;
    }

    private final boolean $$robo$$android_view_FocusFinder$isTouchCandidate(int x, int y, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return destRect.left <= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 66: {
                return destRect.left >= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 33: {
                return destRect.top <= y && destRect.left <= x && x <= destRect.right;
            }
            case 130: {
                return destRect.top >= y && destRect.left <= x && x <= destRect.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private /* synthetic */ void $$robo$$android_view_FocusFinder$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        tlFocusFinder = new ThreadLocal<FocusFinder>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_FocusFinder_1$__constructor__() {
            }

            private final FocusFinder $$robo$$android_view_FocusFinder_1$initialValue() {
                return new FocusFinder();
            }

            private void __constructor__() {
                this.$$robo$$android_view_FocusFinder_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder_1$__constructor__(), 0, this);
            }

            @Override
            protected FocusFinder initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_view_FocusFinder_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static FocusFinder getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_FocusFinder$getInstance(), 0);
    }

    private void __constructor__() {
        this.$$robo$$android_view_FocusFinder$__constructor__();
    }

    private FocusFinder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder$__constructor__(), 0, this);
    }

    public View findNextFocus(ViewGroup viewGroup, View view, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View int ), 0, this, viewGroup, view, n);
    }

    public View findNextFocusFromRect(ViewGroup viewGroup, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusFromRect", $$robo$$android_view_FocusFinder$findNextFocusFromRect(android.view.ViewGroup android.graphics.Rect int ), 0, this, viewGroup, rect, n);
    }

    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View android.graphics.Rect int ), 0, this, viewGroup, view, rect, n);
    }

    private View findNextUserSpecifiedFocus(ViewGroup viewGroup, View view, int n) {
        return InvokeDynamicSupport.bootstrap("findNextUserSpecifiedFocus", $$robo$$android_view_FocusFinder$findNextUserSpecifiedFocus(android.view.ViewGroup android.view.View int ), 0, this, viewGroup, view, n);
    }

    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n, ArrayList<View> arrayList) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View android.graphics.Rect int java.util.ArrayList<android.view.View> ), 0, this, viewGroup, view, rect, n, arrayList);
    }

    private View findNextFocusInRelativeDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusInRelativeDirection", $$robo$$android_view_FocusFinder$findNextFocusInRelativeDirection(java.util.ArrayList<android.view.View> android.view.ViewGroup android.view.View android.graphics.Rect int ), 0, this, arrayList, viewGroup, view, rect, n);
    }

    private void setFocusBottomRight(ViewGroup viewGroup, Rect rect) {
        InvokeDynamicSupport.bootstrap("setFocusBottomRight", $$robo$$android_view_FocusFinder$setFocusBottomRight(android.view.ViewGroup android.graphics.Rect ), 0, this, viewGroup, rect);
    }

    private void setFocusTopLeft(ViewGroup viewGroup, Rect rect) {
        InvokeDynamicSupport.bootstrap("setFocusTopLeft", $$robo$$android_view_FocusFinder$setFocusTopLeft(android.view.ViewGroup android.graphics.Rect ), 0, this, viewGroup, rect);
    }

    View findNextFocusInAbsoluteDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusInAbsoluteDirection", $$robo$$android_view_FocusFinder$findNextFocusInAbsoluteDirection(java.util.ArrayList<android.view.View> android.view.ViewGroup android.view.View android.graphics.Rect int ), 0, this, arrayList, viewGroup, view, rect, n);
    }

    private static View getNextFocusable(View view, ArrayList<View> arrayList, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNextFocusable", $$robo$$android_view_FocusFinder$getNextFocusable(android.view.View java.util.ArrayList<android.view.View> int ), 0, (View)view, arrayList, (int)n);
    }

    private static View getPreviousFocusable(View view, ArrayList<View> arrayList, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPreviousFocusable", $$robo$$android_view_FocusFinder$getPreviousFocusable(android.view.View java.util.ArrayList<android.view.View> int ), 0, (View)view, arrayList, (int)n);
    }

    boolean isBetterCandidate(int n, Rect rect, Rect rect2, Rect rect3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBetterCandidate", $$robo$$android_view_FocusFinder$isBetterCandidate(int android.graphics.Rect android.graphics.Rect android.graphics.Rect ), 0, this, n, rect, rect2, rect3);
    }

    boolean beamBeats(int n, Rect rect, Rect rect2, Rect rect3) {
        return (boolean)InvokeDynamicSupport.bootstrap("beamBeats", $$robo$$android_view_FocusFinder$beamBeats(int android.graphics.Rect android.graphics.Rect android.graphics.Rect ), 0, this, n, rect, rect2, rect3);
    }

    int getWeightedDistanceFor(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWeightedDistanceFor", $$robo$$android_view_FocusFinder$getWeightedDistanceFor(int int ), 0, this, n, n2);
    }

    boolean isCandidate(Rect rect, Rect rect2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCandidate", $$robo$$android_view_FocusFinder$isCandidate(android.graphics.Rect android.graphics.Rect int ), 0, this, rect, rect2, n);
    }

    boolean beamsOverlap(int n, Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrap("beamsOverlap", $$robo$$android_view_FocusFinder$beamsOverlap(int android.graphics.Rect android.graphics.Rect ), 0, this, n, rect, rect2);
    }

    boolean isToDirectionOf(int n, Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isToDirectionOf", $$robo$$android_view_FocusFinder$isToDirectionOf(int android.graphics.Rect android.graphics.Rect ), 0, this, n, rect, rect2);
    }

    static int majorAxisDistance(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistance", $$robo$$android_view_FocusFinder$majorAxisDistance(int android.graphics.Rect android.graphics.Rect ), 0, (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceRaw(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceRaw", $$robo$$android_view_FocusFinder$majorAxisDistanceRaw(int android.graphics.Rect android.graphics.Rect ), 0, (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceToFarEdge(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceToFarEdge", $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdge(int android.graphics.Rect android.graphics.Rect ), 0, (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceToFarEdgeRaw(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceToFarEdgeRaw", $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdgeRaw(int android.graphics.Rect android.graphics.Rect ), 0, (int)n, (Rect)rect, (Rect)rect2);
    }

    static int minorAxisDistance(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("minorAxisDistance", $$robo$$android_view_FocusFinder$minorAxisDistance(int android.graphics.Rect android.graphics.Rect ), 0, (int)n, (Rect)rect, (Rect)rect2);
    }

    public View findNearestTouchable(ViewGroup viewGroup, int n, int n2, int n3, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("findNearestTouchable", $$robo$$android_view_FocusFinder$findNearestTouchable(android.view.ViewGroup int int int int[] ), 0, this, viewGroup, n, n2, n3, nArray);
    }

    private boolean isTouchCandidate(int n, int n2, Rect rect, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchCandidate", $$robo$$android_view_FocusFinder$isTouchCandidate(int int android.graphics.Rect int ), 0, this, n, n2, rect, n3);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_view_FocusFinder$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(FocusFinder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusFinder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SequentialFocusComparator
    implements Comparator<View> {
        public transient /* synthetic */ Object __robo_data__;
        private Rect mFirstRect;
        private Rect mSecondRect;
        private ViewGroup mRoot;
        private boolean mIsLayoutRtl;

        private void $$robo$$android_view_FocusFinder_SequentialFocusComparator$__constructor__() {
            this.mFirstRect = new Rect();
            this.mSecondRect = new Rect();
        }

        private final void $$robo$$android_view_FocusFinder_SequentialFocusComparator$recycle() {
            this.mRoot = null;
        }

        private final void $$robo$$android_view_FocusFinder_SequentialFocusComparator$setRoot(ViewGroup root) {
            this.mRoot = root;
        }

        private final void $$robo$$android_view_FocusFinder_SequentialFocusComparator$setIsLayoutRtl(boolean b) {
            this.mIsLayoutRtl = b;
        }

        private final int $$robo$$android_view_FocusFinder_SequentialFocusComparator$compare(View first, View second) {
            if (first == second) {
                return 0;
            }
            this.getRect(first, this.mFirstRect);
            this.getRect(second, this.mSecondRect);
            if (this.mFirstRect.top < this.mSecondRect.top) {
                return -1;
            }
            if (this.mFirstRect.top > this.mSecondRect.top) {
                return 1;
            }
            if (this.mFirstRect.left < this.mSecondRect.left) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (this.mFirstRect.left > this.mSecondRect.left) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            if (this.mFirstRect.bottom < this.mSecondRect.bottom) {
                return -1;
            }
            if (this.mFirstRect.bottom > this.mSecondRect.bottom) {
                return 1;
            }
            if (this.mFirstRect.right < this.mSecondRect.right) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (this.mFirstRect.right > this.mSecondRect.right) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            return 0;
        }

        private final void $$robo$$android_view_FocusFinder_SequentialFocusComparator$getRect(View view, Rect rect) {
            view.getDrawingRect(rect);
            this.mRoot.offsetDescendantRectToMyCoords(view, rect);
        }

        private /* synthetic */ void $$robo$$android_view_FocusFinder_SequentialFocusComparator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_FocusFinder_SequentialFocusComparator$__constructor__();
        }

        private SequentialFocusComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder_SequentialFocusComparator$__constructor__(), 0, this);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_FocusFinder_SequentialFocusComparator$recycle(), 0, this);
        }

        public void setRoot(ViewGroup viewGroup) {
            InvokeDynamicSupport.bootstrap("setRoot", $$robo$$android_view_FocusFinder_SequentialFocusComparator$setRoot(android.view.ViewGroup ), 0, this, viewGroup);
        }

        public void setIsLayoutRtl(boolean bl) {
            InvokeDynamicSupport.bootstrap("setIsLayoutRtl", $$robo$$android_view_FocusFinder_SequentialFocusComparator$setIsLayoutRtl(boolean ), 0, this, bl);
        }

        @Override
        public int compare(View view, View view2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_view_FocusFinder_SequentialFocusComparator$compare(android.view.View android.view.View ), 0, this, view, view2);
        }

        private void getRect(View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("getRect", $$robo$$android_view_FocusFinder_SequentialFocusComparator$getRect(android.view.View android.graphics.Rect ), 0, this, view, rect);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_FocusFinder_SequentialFocusComparator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SequentialFocusComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

