/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.GLES20Canvas;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;
import android.view.Surface;
import android.view.ThreadedRenderer;
import android.view.View;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class HardwareRenderer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "HardwareRenderer";
    private static String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    static String RENDER_DIRTY_REGIONS_PROPERTY = "debug.hwui.render_dirty_regions";
    public static String PROFILE_PROPERTY = "debug.hwui.profile";
    public static String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static String OVERDRAW_PROPERTY_SHOW = "show";
    public static String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled;
    public static boolean sSystemRendererDisabled;
    private boolean mEnabled;
    private boolean mRequested;
    public static boolean sTrimForeground;

    private void $$robo$$android_view_HardwareRenderer$__constructor__() {
        this.mRequested = true;
    }

    private static final void $$robo$$android_view_HardwareRenderer$disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    private static final void $$robo$$android_view_HardwareRenderer$enableForegroundTrimming() {
        sTrimForeground = true;
    }

    private static final boolean $$robo$$android_view_HardwareRenderer$isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    abstract void destroy();

    abstract boolean initialize(Surface var1) throws Surface.OutOfResourcesException;

    abstract void updateSurface(Surface var1) throws Surface.OutOfResourcesException;

    abstract void pauseSurface(Surface var1);

    abstract void destroyHardwareResources(View var1);

    abstract void invalidate(Surface var1);

    abstract void detachSurfaceTexture(long var1);

    abstract int getWidth();

    abstract int getHeight();

    abstract void dumpGfxInfo(PrintWriter var1, FileDescriptor var2);

    abstract boolean loadSystemProperties();

    private static final void $$robo$$android_view_HardwareRenderer$setupDiskCache(File cacheDir) {
        ThreadedRenderer.setupShadersDiskCache(new File(cacheDir, "com.android.opengl.shaders_cache").getAbsolutePath());
    }

    abstract void pushLayerUpdate(HardwareLayer var1);

    abstract void onLayerDestroyed(HardwareLayer var1);

    abstract void invalidateRoot();

    abstract void draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3);

    abstract HardwareLayer createTextureLayer();

    abstract void buildLayer(RenderNode var1);

    abstract boolean copyLayerInto(HardwareLayer var1, Bitmap var2);

    private final boolean $$robo$$android_view_HardwareRenderer$initializeIfNeeded(int width, int height, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, surfaceInsets);
            return true;
        }
        return false;
    }

    abstract void setup(int var1, int var2, Rect var3);

    abstract void setName(String var1);

    abstract void setOpaque(boolean var1);

    private static final HardwareRenderer $$robo$$android_view_HardwareRenderer$create(Context context, boolean translucent) {
        ThreadedRenderer renderer = null;
        if (GLES20Canvas.isAvailable()) {
            renderer = new ThreadedRenderer(context, translucent);
        }
        return renderer;
    }

    private static final void $$robo$$android_view_HardwareRenderer$trimMemory(int level) {
        ThreadedRenderer.trimMemory(level);
    }

    private final boolean $$robo$$android_view_HardwareRenderer$isEnabled() {
        return this.mEnabled;
    }

    private final void $$robo$$android_view_HardwareRenderer$setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    private final boolean $$robo$$android_view_HardwareRenderer$isRequested() {
        return this.mRequested;
    }

    private final void $$robo$$android_view_HardwareRenderer$setRequested(boolean requested) {
        this.mRequested = requested;
    }

    abstract void fence();

    abstract void stopDrawing();

    abstract void notifyFramePending();

    abstract void registerAnimatingRenderNode(RenderNode var1);

    static void __staticInitializer__() {
        sRendererDisabled = false;
        sSystemRendererDisabled = false;
        sTrimForeground = false;
    }

    private void __constructor__() {
        this.$$robo$$android_view_HardwareRenderer$__constructor__();
    }

    public HardwareRenderer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_HardwareRenderer$__constructor__(), 0, this);
    }

    public static void disable(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("disable", $$robo$$android_view_HardwareRenderer$disable(boolean ), 0, (boolean)bl);
    }

    public static void enableForegroundTrimming() {
        InvokeDynamicSupport.bootstrapStatic("enableForegroundTrimming", $$robo$$android_view_HardwareRenderer$enableForegroundTrimming(), 0);
    }

    public static boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_view_HardwareRenderer$isAvailable(), 0);
    }

    public static void setupDiskCache(File file) {
        InvokeDynamicSupport.bootstrapStatic("setupDiskCache", $$robo$$android_view_HardwareRenderer$setupDiskCache(java.io.File ), 0, (File)file);
    }

    boolean initializeIfNeeded(int n, int n2, Surface surface, Rect rect) throws Surface.OutOfResourcesException {
        return (boolean)InvokeDynamicSupport.bootstrap("initializeIfNeeded", $$robo$$android_view_HardwareRenderer$initializeIfNeeded(int int android.view.Surface android.graphics.Rect ), 0, this, n, n2, surface, rect);
    }

    static HardwareRenderer create(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_HardwareRenderer$create(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    static void trimMemory(int n) {
        InvokeDynamicSupport.bootstrapStatic("trimMemory", $$robo$$android_view_HardwareRenderer$trimMemory(int ), 0, (int)n);
    }

    boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_HardwareRenderer$isEnabled(), 0, this);
    }

    void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_view_HardwareRenderer$setEnabled(boolean ), 0, this, bl);
    }

    boolean isRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequested", $$robo$$android_view_HardwareRenderer$isRequested(), 0, this);
    }

    void setRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRequested", $$robo$$android_view_HardwareRenderer$setRequested(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(HardwareRenderer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HardwareRenderer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface HardwareDrawCallbacks
    extends InstrumentedInterface {
        public void onHardwarePreDraw(HardwareCanvas var1);

        public void onHardwarePostDraw(HardwareCanvas var1);
    }
}

