/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputManager;
import android.os.NullVibrator;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Vibrator;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InputDevice
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mId;
    private int mGeneration;
    private int mControllerNumber;
    private String mName;
    private int mVendorId;
    private int mProductId;
    private String mDescriptor;
    private InputDeviceIdentifier mIdentifier;
    private boolean mIsExternal;
    private int mSources;
    private int mKeyboardType;
    private KeyCharacterMap mKeyCharacterMap;
    private boolean mHasVibrator;
    private boolean mHasButtonUnderPad;
    private ArrayList<MotionRange> mMotionRanges;
    private Vibrator mVibrator;
    public static int SOURCE_CLASS_MASK = 255;
    public static int SOURCE_CLASS_NONE = 0;
    public static int SOURCE_CLASS_BUTTON = 1;
    public static int SOURCE_CLASS_POINTER = 2;
    public static int SOURCE_CLASS_TRACKBALL = 4;
    public static int SOURCE_CLASS_POSITION = 8;
    public static int SOURCE_CLASS_JOYSTICK = 16;
    public static int SOURCE_UNKNOWN = 0;
    public static int SOURCE_KEYBOARD = 257;
    public static int SOURCE_DPAD = 513;
    public static int SOURCE_GAMEPAD = 1025;
    public static int SOURCE_TOUCHSCREEN = 4098;
    public static int SOURCE_MOUSE = 8194;
    public static int SOURCE_STYLUS = 16386;
    public static int SOURCE_TRACKBALL = 65540;
    public static int SOURCE_TOUCHPAD = 0x100008;
    public static int SOURCE_TOUCH_NAVIGATION = 0x200000;
    public static int SOURCE_JOYSTICK = 0x1000010;
    public static int SOURCE_HDMI = 0x2000001;
    public static int SOURCE_ANY = -256;
    @Deprecated
    public static int MOTION_RANGE_X = 0;
    @Deprecated
    public static int MOTION_RANGE_Y = 1;
    @Deprecated
    public static int MOTION_RANGE_PRESSURE = 2;
    @Deprecated
    public static int MOTION_RANGE_SIZE = 3;
    @Deprecated
    public static int MOTION_RANGE_TOUCH_MAJOR = 4;
    @Deprecated
    public static int MOTION_RANGE_TOUCH_MINOR = 5;
    @Deprecated
    public static int MOTION_RANGE_TOOL_MAJOR = 6;
    @Deprecated
    public static int MOTION_RANGE_TOOL_MINOR = 7;
    @Deprecated
    public static int MOTION_RANGE_ORIENTATION = 8;
    public static int KEYBOARD_TYPE_NONE = 0;
    public static int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    public static int KEYBOARD_TYPE_ALPHABETIC = 2;
    public static Parcelable.Creator<InputDevice> CREATOR;

    private void $$robo$$android_view_InputDevice$__constructor__(int id2, int generation, int controllerNumber, String name, int vendorId, int productId, String descriptor, boolean isExternal, int sources, int keyboardType, KeyCharacterMap keyCharacterMap, boolean hasVibrator, boolean hasButtonUnderPad) {
        this.mMotionRanges = new ArrayList();
        this.mId = id2;
        this.mGeneration = generation;
        this.mControllerNumber = controllerNumber;
        this.mName = name;
        this.mVendorId = vendorId;
        this.mProductId = productId;
        this.mDescriptor = descriptor;
        this.mIsExternal = isExternal;
        this.mSources = sources;
        this.mKeyboardType = keyboardType;
        this.mKeyCharacterMap = keyCharacterMap;
        this.mHasVibrator = hasVibrator;
        this.mHasButtonUnderPad = hasButtonUnderPad;
        this.mIdentifier = new InputDeviceIdentifier(descriptor, vendorId, productId);
    }

    private void $$robo$$android_view_InputDevice$__constructor__(Parcel in) {
        int axis;
        this.mMotionRanges = new ArrayList();
        this.mId = in.readInt();
        this.mGeneration = in.readInt();
        this.mControllerNumber = in.readInt();
        this.mName = in.readString();
        this.mVendorId = in.readInt();
        this.mProductId = in.readInt();
        this.mDescriptor = in.readString();
        this.mIsExternal = in.readInt() != 0;
        this.mSources = in.readInt();
        this.mKeyboardType = in.readInt();
        this.mKeyCharacterMap = KeyCharacterMap.CREATOR.createFromParcel(in);
        this.mHasVibrator = in.readInt() != 0;
        this.mHasButtonUnderPad = in.readInt() != 0;
        this.mIdentifier = new InputDeviceIdentifier(this.mDescriptor, this.mVendorId, this.mProductId);
        while ((axis = in.readInt()) >= 0) {
            this.addMotionRange(axis, in.readInt(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        }
    }

    private static final InputDevice $$robo$$android_view_InputDevice$getDevice(int id2) {
        return InputManager.getInstance().getInputDevice(id2);
    }

    private static final int[] $$robo$$android_view_InputDevice$getDeviceIds() {
        return InputManager.getInstance().getInputDeviceIds();
    }

    private final int $$robo$$android_view_InputDevice$getId() {
        return this.mId;
    }

    private final int $$robo$$android_view_InputDevice$getControllerNumber() {
        return this.mControllerNumber;
    }

    private final InputDeviceIdentifier $$robo$$android_view_InputDevice$getIdentifier() {
        return this.mIdentifier;
    }

    private final int $$robo$$android_view_InputDevice$getGeneration() {
        return this.mGeneration;
    }

    private final int $$robo$$android_view_InputDevice$getVendorId() {
        return this.mVendorId;
    }

    private final int $$robo$$android_view_InputDevice$getProductId() {
        return this.mProductId;
    }

    private final String $$robo$$android_view_InputDevice$getDescriptor() {
        return this.mDescriptor;
    }

    private final boolean $$robo$$android_view_InputDevice$isVirtual() {
        return this.mId < 0;
    }

    private final boolean $$robo$$android_view_InputDevice$isExternal() {
        return this.mIsExternal;
    }

    private final boolean $$robo$$android_view_InputDevice$isFullKeyboard() {
        return (this.mSources & 0x101) == 257 && this.mKeyboardType == 2;
    }

    private final String $$robo$$android_view_InputDevice$getName() {
        return this.mName;
    }

    private final int $$robo$$android_view_InputDevice$getSources() {
        return this.mSources;
    }

    private final boolean $$robo$$android_view_InputDevice$supportsSource(int source) {
        return (this.mSources & source) == source;
    }

    private final int $$robo$$android_view_InputDevice$getKeyboardType() {
        return this.mKeyboardType;
    }

    private final KeyCharacterMap $$robo$$android_view_InputDevice$getKeyCharacterMap() {
        return this.mKeyCharacterMap;
    }

    private final boolean[] $$robo$$android_view_InputDevice$hasKeys(int ... keys) {
        return InputManager.getInstance().deviceHasKeys(this.mId, keys);
    }

    private final MotionRange $$robo$$android_view_InputDevice$getMotionRange(int axis) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis) continue;
            return range;
        }
        return null;
    }

    private final MotionRange $$robo$$android_view_InputDevice$getMotionRange(int axis, int source) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis || range.mSource != source) continue;
            return range;
        }
        return null;
    }

    private final List<MotionRange> $$robo$$android_view_InputDevice$getMotionRanges() {
        return this.mMotionRanges;
    }

    private final void $$robo$$android_view_InputDevice$addMotionRange(int axis, int source, float min, float max, float flat, float fuzz, float resolution) {
        this.mMotionRanges.add(new MotionRange(axis, source, min, max, flat, fuzz, resolution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Vibrator $$robo$$android_view_InputDevice$getVibrator() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mVibrator == null) {
                this.mVibrator = this.mHasVibrator ? InputManager.getInstance().getInputDeviceVibrator(this.mId) : NullVibrator.getInstance();
            }
            return this.mVibrator;
        }
    }

    private final boolean $$robo$$android_view_InputDevice$hasButtonUnderPad() {
        return this.mHasButtonUnderPad;
    }

    private final void $$robo$$android_view_InputDevice$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mId);
        out.writeInt(this.mGeneration);
        out.writeInt(this.mControllerNumber);
        out.writeString(this.mName);
        out.writeInt(this.mVendorId);
        out.writeInt(this.mProductId);
        out.writeString(this.mDescriptor);
        out.writeInt(this.mIsExternal ? 1 : 0);
        out.writeInt(this.mSources);
        out.writeInt(this.mKeyboardType);
        this.mKeyCharacterMap.writeToParcel(out, flags);
        out.writeInt(this.mHasVibrator ? 1 : 0);
        out.writeInt(this.mHasButtonUnderPad ? 1 : 0);
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            out.writeInt(range.mAxis);
            out.writeInt(range.mSource);
            out.writeFloat(range.mMin);
            out.writeFloat(range.mMax);
            out.writeFloat(range.mFlat);
            out.writeFloat(range.mFuzz);
            out.writeFloat(range.mResolution);
        }
        out.writeInt(-1);
    }

    private final int $$robo$$android_view_InputDevice$describeContents() {
        return 0;
    }

    private final String $$robo$$android_view_InputDevice$toString() {
        StringBuilder description = new StringBuilder();
        description.append("Input Device ").append(this.mId).append(": ").append(this.mName).append("\n");
        description.append("  Descriptor: ").append(this.mDescriptor).append("\n");
        description.append("  Generation: ").append(this.mGeneration).append("\n");
        description.append("  Location: ").append(this.mIsExternal ? "external" : "built-in").append("\n");
        description.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                description.append("none");
                break;
            }
            case 1: {
                description.append("non-alphabetic");
                break;
            }
            case 2: {
                description.append("alphabetic");
            }
        }
        description.append("\n");
        description.append("  Has Vibrator: ").append(this.mHasVibrator).append("\n");
        description.append("  Sources: 0x").append(Integer.toHexString(this.mSources)).append(" (");
        this.appendSourceDescriptionIfApplicable(description, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(description, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(description, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(description, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(description, 16386, "stylus");
        this.appendSourceDescriptionIfApplicable(description, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(description, 0x100008, "touchpad");
        this.appendSourceDescriptionIfApplicable(description, 0x1000010, "joystick");
        this.appendSourceDescriptionIfApplicable(description, 1025, "gamepad");
        description.append(" )\n");
        int numAxes = this.mMotionRanges.size();
        for (int i = 0; i < numAxes; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            description.append("    ").append(MotionEvent.axisToString(range.mAxis));
            description.append(": source=0x").append(Integer.toHexString(range.mSource));
            description.append(" min=").append(range.mMin);
            description.append(" max=").append(range.mMax);
            description.append(" flat=").append(range.mFlat);
            description.append(" fuzz=").append(range.mFuzz);
            description.append(" resolution=").append(range.mResolution);
            description.append("\n");
        }
        return description.toString();
    }

    private final void $$robo$$android_view_InputDevice$appendSourceDescriptionIfApplicable(StringBuilder description, int source, String sourceName) {
        if ((this.mSources & source) == source) {
            description.append(" ");
            description.append(sourceName);
        }
    }

    private /* synthetic */ void $$robo$$android_view_InputDevice$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<InputDevice>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_InputDevice_1$__constructor__() {
            }

            private final InputDevice $$robo$$android_view_InputDevice_1$createFromParcel(Parcel in) {
                return new InputDevice(in);
            }

            private final InputDevice[] $$robo$$android_view_InputDevice_1$newArray(int size) {
                return new InputDevice[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_InputDevice_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputDevice_1$__constructor__(), 0, this);
            }

            @Override
            public InputDevice createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_InputDevice_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public InputDevice[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_InputDevice_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, String string2, int n4, int n5, String string3, boolean bl, int n6, int n7, KeyCharacterMap keyCharacterMap, boolean bl2, boolean bl3) {
        this.$$robo$$android_view_InputDevice$__constructor__(n, n2, n3, string2, n4, n5, string3, bl, n6, n7, keyCharacterMap, bl2, bl3);
    }

    private InputDevice(int n, int n2, int n3, String string2, int n4, int n5, String string3, boolean bl, int n6, int n7, KeyCharacterMap keyCharacterMap, boolean bl2, boolean bl3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputDevice$__constructor__(int int int java.lang.String int int java.lang.String boolean int int android.view.KeyCharacterMap boolean boolean ), 0, this, n, n2, n3, string2, n4, n5, string3, bl, n6, n7, keyCharacterMap, bl2, bl3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_InputDevice$__constructor__(parcel);
    }

    private InputDevice(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputDevice$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public static InputDevice getDevice(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDevice", $$robo$$android_view_InputDevice$getDevice(int ), 0, (int)n);
    }

    public static int[] getDeviceIds() {
        return InvokeDynamicSupport.bootstrapStatic("getDeviceIds", $$robo$$android_view_InputDevice$getDeviceIds(), 0);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_InputDevice$getId(), 0, this);
    }

    public int getControllerNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getControllerNumber", $$robo$$android_view_InputDevice$getControllerNumber(), 0, this);
    }

    public InputDeviceIdentifier getIdentifier() {
        return InvokeDynamicSupport.bootstrap("getIdentifier", $$robo$$android_view_InputDevice$getIdentifier(), 0, this);
    }

    public int getGeneration() {
        return (int)InvokeDynamicSupport.bootstrap("getGeneration", $$robo$$android_view_InputDevice$getGeneration(), 0, this);
    }

    public int getVendorId() {
        return (int)InvokeDynamicSupport.bootstrap("getVendorId", $$robo$$android_view_InputDevice$getVendorId(), 0, this);
    }

    public int getProductId() {
        return (int)InvokeDynamicSupport.bootstrap("getProductId", $$robo$$android_view_InputDevice$getProductId(), 0, this);
    }

    public String getDescriptor() {
        return InvokeDynamicSupport.bootstrap("getDescriptor", $$robo$$android_view_InputDevice$getDescriptor(), 0, this);
    }

    public boolean isVirtual() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVirtual", $$robo$$android_view_InputDevice$isVirtual(), 0, this);
    }

    public boolean isExternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExternal", $$robo$$android_view_InputDevice$isExternal(), 0, this);
    }

    public boolean isFullKeyboard() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFullKeyboard", $$robo$$android_view_InputDevice$isFullKeyboard(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_view_InputDevice$getName(), 0, this);
    }

    public int getSources() {
        return (int)InvokeDynamicSupport.bootstrap("getSources", $$robo$$android_view_InputDevice$getSources(), 0, this);
    }

    public boolean supportsSource(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsSource", $$robo$$android_view_InputDevice$supportsSource(int ), 0, this, n);
    }

    public int getKeyboardType() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyboardType", $$robo$$android_view_InputDevice$getKeyboardType(), 0, this);
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return InvokeDynamicSupport.bootstrap("getKeyCharacterMap", $$robo$$android_view_InputDevice$getKeyCharacterMap(), 0, this);
    }

    public boolean[] hasKeys(int ... nArray) {
        return InvokeDynamicSupport.bootstrap("hasKeys", $$robo$$android_view_InputDevice$hasKeys(int[] ), 0, this, nArray);
    }

    public MotionRange getMotionRange(int n) {
        return InvokeDynamicSupport.bootstrap("getMotionRange", $$robo$$android_view_InputDevice$getMotionRange(int ), 0, this, n);
    }

    public MotionRange getMotionRange(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getMotionRange", $$robo$$android_view_InputDevice$getMotionRange(int int ), 0, this, n, n2);
    }

    public List<MotionRange> getMotionRanges() {
        return InvokeDynamicSupport.bootstrap("getMotionRanges", $$robo$$android_view_InputDevice$getMotionRanges(), 0, this);
    }

    private void addMotionRange(int n, int n2, float f, float f2, float f3, float f4, float f5) {
        InvokeDynamicSupport.bootstrap("addMotionRange", $$robo$$android_view_InputDevice$addMotionRange(int int float float float float float ), 0, this, n, n2, f, f2, f3, f4, f5);
    }

    public Vibrator getVibrator() {
        return InvokeDynamicSupport.bootstrap("getVibrator", $$robo$$android_view_InputDevice$getVibrator(), 0, this);
    }

    public boolean hasButtonUnderPad() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasButtonUnderPad", $$robo$$android_view_InputDevice$hasButtonUnderPad(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_InputDevice$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_InputDevice$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_InputDevice$toString(), 0, this);
    }

    private void appendSourceDescriptionIfApplicable(StringBuilder stringBuilder, int n, String string2) {
        InvokeDynamicSupport.bootstrap("appendSourceDescriptionIfApplicable", $$robo$$android_view_InputDevice$appendSourceDescriptionIfApplicable(java.lang.StringBuilder int java.lang.String ), 0, this, stringBuilder, n, string2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_InputDevice$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(InputDevice.class);
    }

    public /* synthetic */ InputDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MotionRange
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mAxis;
        private int mSource;
        private float mMin;
        private float mMax;
        private float mFlat;
        private float mFuzz;
        private float mResolution;

        private void $$robo$$android_view_InputDevice_MotionRange$__constructor__(int axis, int source, float min, float max, float flat, float fuzz, float resolution) {
            this.mAxis = axis;
            this.mSource = source;
            this.mMin = min;
            this.mMax = max;
            this.mFlat = flat;
            this.mFuzz = fuzz;
            this.mResolution = resolution;
        }

        private final int $$robo$$android_view_InputDevice_MotionRange$getAxis() {
            return this.mAxis;
        }

        private final int $$robo$$android_view_InputDevice_MotionRange$getSource() {
            return this.mSource;
        }

        private final boolean $$robo$$android_view_InputDevice_MotionRange$isFromSource(int source) {
            return (this.getSource() & source) == source;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getMin() {
            return this.mMin;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getMax() {
            return this.mMax;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getRange() {
            return this.mMax - this.mMin;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getFlat() {
            return this.mFlat;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getFuzz() {
            return this.mFuzz;
        }

        private final float $$robo$$android_view_InputDevice_MotionRange$getResolution() {
            return this.mResolution;
        }

        private /* synthetic */ void $$robo$$android_view_InputDevice_MotionRange$__constructor__(int x0, int x1, float x2, float x3, float x4, float x5, float x6, 1 x7) {
        }

        private void __constructor__(int n, int n2, float f, float f2, float f3, float f4, float f5) {
            this.$$robo$$android_view_InputDevice_MotionRange$__constructor__(n, n2, f, f2, f3, f4, f5);
        }

        private MotionRange(int n, int n2, float f, float f2, float f3, float f4, float f5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputDevice_MotionRange$__constructor__(int int float float float float float ), 0, this, n, n2, f, f2, f3, f4, f5);
        }

        public int getAxis() {
            return (int)InvokeDynamicSupport.bootstrap("getAxis", $$robo$$android_view_InputDevice_MotionRange$getAxis(), 0, this);
        }

        public int getSource() {
            return (int)InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_view_InputDevice_MotionRange$getSource(), 0, this);
        }

        public boolean isFromSource(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFromSource", $$robo$$android_view_InputDevice_MotionRange$isFromSource(int ), 0, this, n);
        }

        public float getMin() {
            return (float)InvokeDynamicSupport.bootstrap("getMin", $$robo$$android_view_InputDevice_MotionRange$getMin(), 0, this);
        }

        public float getMax() {
            return (float)InvokeDynamicSupport.bootstrap("getMax", $$robo$$android_view_InputDevice_MotionRange$getMax(), 0, this);
        }

        public float getRange() {
            return (float)InvokeDynamicSupport.bootstrap("getRange", $$robo$$android_view_InputDevice_MotionRange$getRange(), 0, this);
        }

        public float getFlat() {
            return (float)InvokeDynamicSupport.bootstrap("getFlat", $$robo$$android_view_InputDevice_MotionRange$getFlat(), 0, this);
        }

        public float getFuzz() {
            return (float)InvokeDynamicSupport.bootstrap("getFuzz", $$robo$$android_view_InputDevice_MotionRange$getFuzz(), 0, this);
        }

        public float getResolution() {
            return (float)InvokeDynamicSupport.bootstrap("getResolution", $$robo$$android_view_InputDevice_MotionRange$getResolution(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, int n2, float f, float f2, float f3, float f4, float f5, 1 var8_8) {
            this.$$robo$$android_view_InputDevice_MotionRange$__constructor__(n, n2, f, f2, f3, f4, f5, var8_8);
        }

        public /* synthetic */ MotionRange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MotionRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

