/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.InputChannel;
import android.view.InputEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InputEventReceiver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputEventReceiver";
    private CloseGuard mCloseGuard;
    private long mReceiverPtr;
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;
    private SparseIntArray mSeqMap;

    private static final long $$robo$$android_view_InputEventReceiver$nativeInit(WeakReference<InputEventReceiver> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return 0L;
    }

    private static final void $$robo$$android_view_InputEventReceiver$nativeDispose(long l) {
    }

    private static final void $$robo$$android_view_InputEventReceiver$nativeFinishInputEvent(long l, int n, boolean bl) {
    }

    private static final boolean $$robo$$android_view_InputEventReceiver$nativeConsumeBatchedInputEvents(long l, long l2) {
        return false;
    }

    private void $$robo$$android_view_InputEventReceiver$__constructor__(InputChannel inputChannel, Looper looper) {
        this.mCloseGuard = CloseGuard.get();
        this.mSeqMap = new SparseIntArray();
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = InputEventReceiver.nativeInit(new WeakReference<InputEventReceiver>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_InputEventReceiver$finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_view_InputEventReceiver$dispose() {
        this.dispose(false);
    }

    private final void $$robo$$android_view_InputEventReceiver$dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            InputEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    private final void $$robo$$android_view_InputEventReceiver$onInputEvent(InputEvent event) {
        this.finishInputEvent(event, false);
    }

    private final void $$robo$$android_view_InputEventReceiver$onBatchedInputEventPending() {
        this.consumeBatchedInputEvents(-1L);
    }

    private final void $$robo$$android_view_InputEventReceiver$finishInputEvent(InputEvent event, boolean handled) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mReceiverPtr == 0L) {
            Log.w("InputEventReceiver", "Attempted to finish an input event but the input event receiver has already been disposed.");
        } else {
            int index = this.mSeqMap.indexOfKey(event.getSequenceNumber());
            if (index < 0) {
                Log.w("InputEventReceiver", "Attempted to finish an input event that is not in progress.");
            } else {
                int seq = this.mSeqMap.valueAt(index);
                this.mSeqMap.removeAt(index);
                InputEventReceiver.nativeFinishInputEvent(this.mReceiverPtr, seq, handled);
            }
        }
        event.recycleIfNeededAfterDispatch();
    }

    private final boolean $$robo$$android_view_InputEventReceiver$consumeBatchedInputEvents(long frameTimeNanos) {
        if (this.mReceiverPtr != 0L) {
            return InputEventReceiver.nativeConsumeBatchedInputEvents(this.mReceiverPtr, frameTimeNanos);
        }
        Log.w("InputEventReceiver", "Attempted to consume batched input events but the input event receiver has already been disposed.");
        return false;
    }

    private final void $$robo$$android_view_InputEventReceiver$dispatchInputEvent(int seq, InputEvent event) {
        this.mSeqMap.put(event.getSequenceNumber(), seq);
        this.onInputEvent(event);
    }

    private final void $$robo$$android_view_InputEventReceiver$dispatchBatchedInputEventPending() {
        this.onBatchedInputEventPending();
    }

    private static final native /* synthetic */ long $$robo$$nativeInit$nativeBinding(WeakReference<InputEventReceiver> var0, InputChannel var1, MessageQueue var2);

    private static long nativeInit(WeakReference<InputEventReceiver> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInit", $$robo$$android_view_InputEventReceiver$nativeInit(java.lang.ref.WeakReference<android.view.InputEventReceiver> android.view.InputChannel android.os.MessageQueue ), 1, weakReference, (InputChannel)inputChannel, (MessageQueue)messageQueue);
    }

    private static final native /* synthetic */ void $$robo$$nativeDispose$nativeBinding(long var0);

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_view_InputEventReceiver$nativeDispose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeFinishInputEvent$nativeBinding(long var0, int var2, boolean var3);

    private static void nativeFinishInputEvent(long l, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeFinishInputEvent", $$robo$$android_view_InputEventReceiver$nativeFinishInputEvent(long int boolean ), 1, (long)l, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeConsumeBatchedInputEvents$nativeBinding(long var0, long var2);

    private static boolean nativeConsumeBatchedInputEvents(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeConsumeBatchedInputEvents", $$robo$$android_view_InputEventReceiver$nativeConsumeBatchedInputEvents(long long ), 1, (long)l, (long)l2);
    }

    private void __constructor__(InputChannel inputChannel, Looper looper) {
        this.$$robo$$android_view_InputEventReceiver$__constructor__(inputChannel, looper);
    }

    public InputEventReceiver(InputChannel inputChannel, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventReceiver$__constructor__(android.view.InputChannel android.os.Looper ), 0, this, inputChannel, looper);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_InputEventReceiver$finalize(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventReceiver$dispose(), 0, this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventReceiver$dispose(boolean ), 0, this, bl);
    }

    public void onInputEvent(InputEvent inputEvent) {
        InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_view_InputEventReceiver$onInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    public void onBatchedInputEventPending() {
        InvokeDynamicSupport.bootstrap("onBatchedInputEventPending", $$robo$$android_view_InputEventReceiver$onBatchedInputEventPending(), 0, this);
    }

    public void finishInputEvent(InputEvent inputEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("finishInputEvent", $$robo$$android_view_InputEventReceiver$finishInputEvent(android.view.InputEvent boolean ), 0, this, inputEvent, bl);
    }

    public boolean consumeBatchedInputEvents(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("consumeBatchedInputEvents", $$robo$$android_view_InputEventReceiver$consumeBatchedInputEvents(long ), 0, this, l);
    }

    private void dispatchInputEvent(int n, InputEvent inputEvent) {
        InvokeDynamicSupport.bootstrap("dispatchInputEvent", $$robo$$android_view_InputEventReceiver$dispatchInputEvent(int android.view.InputEvent ), 0, this, n, inputEvent);
    }

    private void dispatchBatchedInputEventPending() {
        InvokeDynamicSupport.bootstrap("dispatchBatchedInputEventPending", $$robo$$android_view_InputEventReceiver$dispatchBatchedInputEventPending(), 0, this);
    }

    public /* synthetic */ InputEventReceiver() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputEventReceiver)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Factory
    extends InstrumentedInterface {
        public InputEventReceiver createInputEventReceiver(InputChannel var1, Looper var2);
    }
}

