/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InputEventSender
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputEventSender";
    private CloseGuard mCloseGuard;
    private long mSenderPtr;
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;

    private static final long $$robo$$android_view_InputEventSender$nativeInit(WeakReference<InputEventSender> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return 0L;
    }

    private static final void $$robo$$android_view_InputEventSender$nativeDispose(long l) {
    }

    private static final boolean $$robo$$android_view_InputEventSender$nativeSendKeyEvent(long l, int n, KeyEvent keyEvent) {
        return false;
    }

    private static final boolean $$robo$$android_view_InputEventSender$nativeSendMotionEvent(long l, int n, MotionEvent motionEvent) {
        return false;
    }

    private void $$robo$$android_view_InputEventSender$__constructor__(InputChannel inputChannel, Looper looper) {
        this.mCloseGuard = CloseGuard.get();
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mSenderPtr = InputEventSender.nativeInit(new WeakReference<InputEventSender>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_InputEventSender$finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_view_InputEventSender$dispose() {
        this.dispose(false);
    }

    private final void $$robo$$android_view_InputEventSender$dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mSenderPtr != 0L) {
            InputEventSender.nativeDispose(this.mSenderPtr);
            this.mSenderPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    private final void $$robo$$android_view_InputEventSender$onInputEventFinished(int seq, boolean handled) {
    }

    private final boolean $$robo$$android_view_InputEventSender$sendInputEvent(int seq, InputEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mSenderPtr == 0L) {
            Log.w("InputEventSender", "Attempted to send an input event but the input event sender has already been disposed.");
            return false;
        }
        if (event instanceof KeyEvent) {
            return InputEventSender.nativeSendKeyEvent(this.mSenderPtr, seq, (KeyEvent)event);
        }
        return InputEventSender.nativeSendMotionEvent(this.mSenderPtr, seq, (MotionEvent)event);
    }

    private final void $$robo$$android_view_InputEventSender$dispatchInputEventFinished(int seq, boolean handled) {
        this.onInputEventFinished(seq, handled);
    }

    private static final native /* synthetic */ long $$robo$$nativeInit$nativeBinding(WeakReference<InputEventSender> var0, InputChannel var1, MessageQueue var2);

    private static long nativeInit(WeakReference<InputEventSender> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInit", $$robo$$android_view_InputEventSender$nativeInit(java.lang.ref.WeakReference<android.view.InputEventSender> android.view.InputChannel android.os.MessageQueue ), 1, weakReference, (InputChannel)inputChannel, (MessageQueue)messageQueue);
    }

    private static final native /* synthetic */ void $$robo$$nativeDispose$nativeBinding(long var0);

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_view_InputEventSender$nativeDispose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeSendKeyEvent$nativeBinding(long var0, int var2, KeyEvent var3);

    private static boolean nativeSendKeyEvent(long l, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeSendKeyEvent", $$robo$$android_view_InputEventSender$nativeSendKeyEvent(long int android.view.KeyEvent ), 1, (long)l, (int)n, (KeyEvent)keyEvent);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeSendMotionEvent$nativeBinding(long var0, int var2, MotionEvent var3);

    private static boolean nativeSendMotionEvent(long l, int n, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeSendMotionEvent", $$robo$$android_view_InputEventSender$nativeSendMotionEvent(long int android.view.MotionEvent ), 1, (long)l, (int)n, (MotionEvent)motionEvent);
    }

    private void __constructor__(InputChannel inputChannel, Looper looper) {
        this.$$robo$$android_view_InputEventSender$__constructor__(inputChannel, looper);
    }

    public InputEventSender(InputChannel inputChannel, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventSender$__constructor__(android.view.InputChannel android.os.Looper ), 0, this, inputChannel, looper);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_InputEventSender$finalize(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventSender$dispose(), 0, this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventSender$dispose(boolean ), 0, this, bl);
    }

    public void onInputEventFinished(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onInputEventFinished", $$robo$$android_view_InputEventSender$onInputEventFinished(int boolean ), 0, this, n, bl);
    }

    public boolean sendInputEvent(int n, InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendInputEvent", $$robo$$android_view_InputEventSender$sendInputEvent(int android.view.InputEvent ), 0, this, n, inputEvent);
    }

    private void dispatchInputEventFinished(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchInputEventFinished", $$robo$$android_view_InputEventSender$dispatchInputEventFinished(int boolean ), 0, this, n, bl);
    }

    public /* synthetic */ InputEventSender() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputEventSender)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

