/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PointerIcon
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PointerIcon";
    public static int STYLE_CUSTOM = -1;
    public static int STYLE_NULL = 0;
    public static int STYLE_ARROW = 1000;
    public static int STYLE_SPOT_HOVER = 2000;
    public static int STYLE_SPOT_TOUCH = 2001;
    public static int STYLE_SPOT_ANCHOR = 2002;
    private static int STYLE_OEM_FIRST = 10000;
    private static int STYLE_DEFAULT = 1000;
    private static PointerIcon gNullIcon;
    private int mStyle;
    private int mSystemIconResourceId;
    private Bitmap mBitmap;
    private float mHotSpotX;
    private float mHotSpotY;
    public static Parcelable.Creator<PointerIcon> CREATOR;

    private void $$robo$$android_view_PointerIcon$__constructor__(int style2) {
        this.mStyle = style2;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getNullIcon() {
        return gNullIcon;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getDefaultIcon(Context context) {
        return PointerIcon.getSystemIcon(context, 1000);
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getSystemIcon(Context context, int style2) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (style2 == 0) {
            return gNullIcon;
        }
        int styleIndex = PointerIcon.getSystemIconStyleIndex(style2);
        if (styleIndex == 0) {
            styleIndex = PointerIcon.getSystemIconStyleIndex(1000);
        }
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Pointer, 16844043, 0);
        int resourceId = a.getResourceId(styleIndex, -1);
        a.recycle();
        if (resourceId == -1) {
            Log.w("PointerIcon", "Missing theme resources for pointer icon style " + style2);
            return style2 == 1000 ? gNullIcon : PointerIcon.getSystemIcon(context, 1000);
        }
        PointerIcon icon = new PointerIcon(style2);
        if ((resourceId & 0xFF000000) == 0x1000000) {
            icon.mSystemIconResourceId = resourceId;
        } else {
            icon.loadResource(context, context.getResources(), resourceId);
        }
        return icon;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$createCustomIcon(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY);
        PointerIcon icon = new PointerIcon(-1);
        icon.mBitmap = bitmap;
        icon.mHotSpotX = hotSpotX;
        icon.mHotSpotY = hotSpotY;
        return icon;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$loadCustomIcon(Resources resources, int resourceId) {
        if (resources == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        PointerIcon icon = new PointerIcon(-1);
        icon.loadResource(null, resources, resourceId);
        return icon;
    }

    private final PointerIcon $$robo$$android_view_PointerIcon$load(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (this.mSystemIconResourceId == 0 || this.mBitmap != null) {
            return this;
        }
        PointerIcon result = new PointerIcon(this.mStyle);
        result.mSystemIconResourceId = this.mSystemIconResourceId;
        result.loadResource(context, context.getResources(), this.mSystemIconResourceId);
        return result;
    }

    private final boolean $$robo$$android_view_PointerIcon$isNullIcon() {
        return this.mStyle == 0;
    }

    private final boolean $$robo$$android_view_PointerIcon$isLoaded() {
        return this.mBitmap != null || this.mStyle == 0;
    }

    private final int $$robo$$android_view_PointerIcon$getStyle() {
        return this.mStyle;
    }

    private final Bitmap $$robo$$android_view_PointerIcon$getBitmap() {
        this.throwIfIconIsNotLoaded();
        return this.mBitmap;
    }

    private final float $$robo$$android_view_PointerIcon$getHotSpotX() {
        this.throwIfIconIsNotLoaded();
        return this.mHotSpotX;
    }

    private final float $$robo$$android_view_PointerIcon$getHotSpotY() {
        this.throwIfIconIsNotLoaded();
        return this.mHotSpotY;
    }

    private final void $$robo$$android_view_PointerIcon$throwIfIconIsNotLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("The icon is not loaded.");
        }
    }

    private final int $$robo$$android_view_PointerIcon$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_PointerIcon$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStyle);
        if (this.mStyle != 0) {
            out.writeInt(this.mSystemIconResourceId);
            if (this.mSystemIconResourceId == 0) {
                this.mBitmap.writeToParcel(out, flags);
                out.writeFloat(this.mHotSpotX);
                out.writeFloat(this.mHotSpotY);
            }
        }
    }

    private final boolean $$robo$$android_view_PointerIcon$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PointerIcon)) {
            return false;
        }
        PointerIcon otherIcon = (PointerIcon)other;
        if (this.mStyle != otherIcon.mStyle || this.mSystemIconResourceId != otherIcon.mSystemIconResourceId) {
            return false;
        }
        return this.mSystemIconResourceId != 0 || this.mBitmap == otherIcon.mBitmap && this.mHotSpotX == otherIcon.mHotSpotX && this.mHotSpotY == otherIcon.mHotSpotY;
    }

    private final void $$robo$$android_view_PointerIcon$loadResource(Context context, Resources resources, int resourceId) {
        float hotSpotY;
        float hotSpotX;
        int bitmapRes;
        try (XmlResourceParser parser = resources.getXml(resourceId);){
            XmlUtils.beginDocument(parser, "pointer-icon");
            TypedArray a = resources.obtainAttributes(parser, R.styleable.PointerIcon);
            bitmapRes = a.getResourceId(0, 0);
            hotSpotX = a.getDimension(1, 0.0f);
            hotSpotY = a.getDimension(2, 0.0f);
            a.recycle();
        }
        if (bitmapRes == 0) {
            throw new IllegalArgumentException("<pointer-icon> is missing bitmap attribute.");
        }
        Drawable drawable2 = context == null ? resources.getDrawable(bitmapRes) : context.getDrawable(bitmapRes);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("<pointer-icon> bitmap attribute must refer to a bitmap drawable.");
        }
        this.mBitmap = ((BitmapDrawable)drawable2).getBitmap();
        this.mHotSpotX = hotSpotX;
        this.mHotSpotY = hotSpotY;
    }

    private static final void $$robo$$android_view_PointerIcon$validateHotSpot(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (hotSpotX < 0.0f || hotSpotX >= (float)bitmap.getWidth()) {
            throw new IllegalArgumentException("x hotspot lies outside of the bitmap area");
        }
        if (hotSpotY < 0.0f || hotSpotY >= (float)bitmap.getHeight()) {
            throw new IllegalArgumentException("y hotspot lies outside of the bitmap area");
        }
    }

    private static final int $$robo$$android_view_PointerIcon$getSystemIconStyleIndex(int style2) {
        switch (style2) {
            case 1000: {
                return 0;
            }
            case 2000: {
                return 1;
            }
            case 2001: {
                return 2;
            }
            case 2002: {
                return 3;
            }
        }
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_PointerIcon$__constructor__(int x0, 1 x1) {
    }

    static void __staticInitializer__() {
        gNullIcon = new PointerIcon(0);
        CREATOR = new Parcelable.Creator<PointerIcon>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_PointerIcon_1$__constructor__() {
            }

            private final PointerIcon $$robo$$android_view_PointerIcon_1$createFromParcel(Parcel in) {
                int style2 = in.readInt();
                if (style2 == 0) {
                    return PointerIcon.getNullIcon();
                }
                int systemIconResourceId = in.readInt();
                if (systemIconResourceId != 0) {
                    PointerIcon icon = new PointerIcon(style2);
                    icon.mSystemIconResourceId = systemIconResourceId;
                    return icon;
                }
                Bitmap bitmap = Bitmap.CREATOR.createFromParcel(in);
                float hotSpotX = in.readFloat();
                float hotSpotY = in.readFloat();
                return PointerIcon.createCustomIcon(bitmap, hotSpotX, hotSpotY);
            }

            private final PointerIcon[] $$robo$$android_view_PointerIcon_1$newArray(int size) {
                return new PointerIcon[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_PointerIcon_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_PointerIcon_1$__constructor__(), 0, this);
            }

            @Override
            public PointerIcon createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_PointerIcon_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PointerIcon[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_PointerIcon_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_view_PointerIcon$__constructor__(n);
    }

    private PointerIcon(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_PointerIcon$__constructor__(int ), 0, this, n);
    }

    public static PointerIcon getNullIcon() {
        return InvokeDynamicSupport.bootstrapStatic("getNullIcon", $$robo$$android_view_PointerIcon$getNullIcon(), 0);
    }

    public static PointerIcon getDefaultIcon(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultIcon", $$robo$$android_view_PointerIcon$getDefaultIcon(android.content.Context ), 0, (Context)context);
    }

    public static PointerIcon getSystemIcon(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSystemIcon", $$robo$$android_view_PointerIcon$getSystemIcon(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static PointerIcon createCustomIcon(Bitmap bitmap, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("createCustomIcon", $$robo$$android_view_PointerIcon$createCustomIcon(android.graphics.Bitmap float float ), 0, (Bitmap)bitmap, (float)f, (float)f2);
    }

    public static PointerIcon loadCustomIcon(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("loadCustomIcon", $$robo$$android_view_PointerIcon$loadCustomIcon(android.content.res.Resources int ), 0, (Resources)resources, (int)n);
    }

    public PointerIcon load(Context context) {
        return InvokeDynamicSupport.bootstrap("load", $$robo$$android_view_PointerIcon$load(android.content.Context ), 0, this, context);
    }

    public boolean isNullIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNullIcon", $$robo$$android_view_PointerIcon$isNullIcon(), 0, this);
    }

    public boolean isLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLoaded", $$robo$$android_view_PointerIcon$isLoaded(), 0, this);
    }

    public int getStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_view_PointerIcon$getStyle(), 0, this);
    }

    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_view_PointerIcon$getBitmap(), 0, this);
    }

    public float getHotSpotX() {
        return (float)InvokeDynamicSupport.bootstrap("getHotSpotX", $$robo$$android_view_PointerIcon$getHotSpotX(), 0, this);
    }

    public float getHotSpotY() {
        return (float)InvokeDynamicSupport.bootstrap("getHotSpotY", $$robo$$android_view_PointerIcon$getHotSpotY(), 0, this);
    }

    private void throwIfIconIsNotLoaded() {
        InvokeDynamicSupport.bootstrap("throwIfIconIsNotLoaded", $$robo$$android_view_PointerIcon$throwIfIconIsNotLoaded(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_PointerIcon$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_PointerIcon$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_PointerIcon$equals(java.lang.Object ), 0, this, object);
    }

    private void loadResource(Context context, Resources resources, int n) {
        InvokeDynamicSupport.bootstrap("loadResource", $$robo$$android_view_PointerIcon$loadResource(android.content.Context android.content.res.Resources int ), 0, this, context, resources, n);
    }

    private static void validateHotSpot(Bitmap bitmap, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("validateHotSpot", $$robo$$android_view_PointerIcon$validateHotSpot(android.graphics.Bitmap float float ), 0, (Bitmap)bitmap, (float)f, (float)f2);
    }

    private static int getSystemIconStyleIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSystemIconStyleIndex", $$robo$$android_view_PointerIcon$getSystemIconStyleIndex(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(int n, 1 var2_2) {
        this.$$robo$$android_view_PointerIcon$__constructor__(n, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PointerIcon.class);
    }

    public /* synthetic */ PointerIcon() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerIcon)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

