/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import android.util.FloatMath;
import android.view.GestureDetector;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScaleGestureDetector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ScaleGestureDetector";
    private Context mContext;
    private OnScaleGestureListener mListener;
    private float mFocusX;
    private float mFocusY;
    private boolean mQuickScaleEnabled;
    private float mCurrSpan;
    private float mPrevSpan;
    private float mInitialSpan;
    private float mCurrSpanX;
    private float mCurrSpanY;
    private float mPrevSpanX;
    private float mPrevSpanY;
    private long mCurrTime;
    private long mPrevTime;
    private boolean mInProgress;
    private int mSpanSlop;
    private int mMinSpan;
    private float mTouchUpper;
    private float mTouchLower;
    private float mTouchHistoryLastAccepted;
    private int mTouchHistoryDirection;
    private long mTouchHistoryLastAcceptedTime;
    private int mTouchMinMajor;
    private MotionEvent mDoubleTapEvent;
    private int mDoubleTapMode;
    private Handler mHandler;
    private static long TOUCH_STABILIZE_TIME = 128L;
    private static int DOUBLE_TAP_MODE_NONE = 0;
    private static int DOUBLE_TAP_MODE_IN_PROGRESS = 1;
    private static float SCALE_FACTOR = 0.5f;
    private InputEventConsistencyVerifier mInputEventConsistencyVerifier;
    private GestureDetector mGestureDetector;
    private boolean mEventBeforeOrAboveStartingGestureEvent;

    private void $$robo$$android_view_ScaleGestureDetector$__constructor__(Context context, OnScaleGestureListener listener) {
    }

    private void $$robo$$android_view_ScaleGestureDetector$__constructor__(Context context, OnScaleGestureListener listener, Handler handler) {
        this.mDoubleTapMode = 0;
        this.mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
        this.mContext = context;
        this.mListener = listener;
        this.mSpanSlop = ViewConfiguration.get(context).getScaledTouchSlop() * 2;
        Resources res = context.getResources();
        this.mTouchMinMajor = res.getDimensionPixelSize(17104910);
        this.mMinSpan = res.getDimensionPixelSize(17104909);
        this.mHandler = handler;
        if (context.getApplicationInfo().targetSdkVersion > 18) {
            this.setQuickScaleEnabled(true);
        }
    }

    private final void $$robo$$android_view_ScaleGestureDetector$addTouchHistory(MotionEvent ev) {
        long currentTime = SystemClock.uptimeMillis();
        int count = ev.getPointerCount();
        boolean accept = currentTime - this.mTouchHistoryLastAcceptedTime >= 128L;
        float total = 0.0f;
        int sampleCount = 0;
        for (int i = 0; i < count; ++i) {
            boolean hasLastAccepted = !Float.isNaN(this.mTouchHistoryLastAccepted);
            int historySize = ev.getHistorySize();
            int pointerSampleCount = historySize + 1;
            for (int h = 0; h < pointerSampleCount; ++h) {
                long time;
                int directionSig;
                float major = h < historySize ? ev.getHistoricalTouchMajor(i, h) : ev.getTouchMajor(i);
                if (major < (float)this.mTouchMinMajor) {
                    major = this.mTouchMinMajor;
                }
                total += major;
                if (Float.isNaN(this.mTouchUpper) || major > this.mTouchUpper) {
                    this.mTouchUpper = major;
                }
                if (Float.isNaN(this.mTouchLower) || major < this.mTouchLower) {
                    this.mTouchLower = major;
                }
                if (!hasLastAccepted || (directionSig = (int)Math.signum(major - this.mTouchHistoryLastAccepted)) == this.mTouchHistoryDirection && (directionSig != 0 || this.mTouchHistoryDirection != 0)) continue;
                this.mTouchHistoryDirection = directionSig;
                this.mTouchHistoryLastAcceptedTime = time = h < historySize ? ev.getHistoricalEventTime(h) : ev.getEventTime();
                accept = false;
            }
            sampleCount += pointerSampleCount;
        }
        float avg = total / (float)sampleCount;
        if (accept) {
            float newAccepted = (this.mTouchUpper + this.mTouchLower + avg) / 3.0f;
            this.mTouchUpper = (this.mTouchUpper + newAccepted) / 2.0f;
            this.mTouchLower = (this.mTouchLower + newAccepted) / 2.0f;
            this.mTouchHistoryLastAccepted = newAccepted;
            this.mTouchHistoryDirection = 0;
            this.mTouchHistoryLastAcceptedTime = ev.getEventTime();
        }
    }

    private final void $$robo$$android_view_ScaleGestureDetector$clearTouchHistory() {
        this.mTouchUpper = Float.NaN;
        this.mTouchLower = Float.NaN;
        this.mTouchHistoryLastAccepted = Float.NaN;
        this.mTouchHistoryDirection = 0;
        this.mTouchHistoryLastAcceptedTime = 0L;
    }

    private final boolean $$robo$$android_view_ScaleGestureDetector$onTouchEvent(MotionEvent event) {
        int minSpan;
        float focusY;
        float focusX;
        int div;
        boolean streamComplete;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
        }
        this.mCurrTime = event.getEventTime();
        int action = event.getActionMasked();
        if (this.mQuickScaleEnabled) {
            this.mGestureDetector.onTouchEvent(event);
        }
        boolean bl = streamComplete = action == 1 || action == 3;
        if (action == 0 || streamComplete) {
            if (this.mInProgress) {
                this.mListener.onScaleEnd(this);
                this.mInProgress = false;
                this.mInitialSpan = 0.0f;
                this.mDoubleTapMode = 0;
            } else if (this.mDoubleTapMode == 1 && streamComplete) {
                this.mInProgress = false;
                this.mInitialSpan = 0.0f;
                this.mDoubleTapMode = 0;
            }
            if (streamComplete) {
                this.clearTouchHistory();
                return true;
            }
        }
        boolean configChanged = action == 0 || action == 6 || action == 5;
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = event.getPointerCount();
        int n = div = pointerUp ? count - 1 : count;
        if (this.mDoubleTapMode == 1) {
            focusX = this.mDoubleTapEvent.getX();
            focusY = this.mDoubleTapEvent.getY();
            this.mEventBeforeOrAboveStartingGestureEvent = event.getY() < focusY;
        } else {
            for (int i = 0; i < count; ++i) {
                if (skipIndex == i) continue;
                sumX += event.getX(i);
                sumY += event.getY(i);
            }
            focusX = sumX / (float)div;
            focusY = sumY / (float)div;
        }
        this.addTouchHistory(event);
        float devSumX = 0.0f;
        float devSumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            float touchSize = this.mTouchHistoryLastAccepted / 2.0f;
            devSumX += Math.abs(event.getX(i) - focusX) + touchSize;
            devSumY += Math.abs(event.getY(i) - focusY) + touchSize;
        }
        float devX = devSumX / (float)div;
        float devY = devSumY / (float)div;
        float spanX = devX * 2.0f;
        float spanY = devY * 2.0f;
        float span = this.inDoubleTapMode() ? spanY : FloatMath.sqrt(spanX * spanX + spanY * spanY);
        boolean wasInProgress = this.mInProgress;
        this.mFocusX = focusX;
        this.mFocusY = focusY;
        if (!this.inDoubleTapMode() && this.mInProgress && (span < (float)this.mMinSpan || configChanged)) {
            this.mListener.onScaleEnd(this);
            this.mInProgress = false;
            this.mInitialSpan = span;
            this.mDoubleTapMode = 0;
        }
        if (configChanged) {
            this.mPrevSpanX = this.mCurrSpanX = spanX;
            this.mPrevSpanY = this.mCurrSpanY = spanY;
            this.mPrevSpan = this.mCurrSpan = span;
            this.mInitialSpan = this.mCurrSpan;
        }
        int n2 = minSpan = this.inDoubleTapMode() ? this.mSpanSlop : this.mMinSpan;
        if (!this.mInProgress && span >= (float)minSpan && (wasInProgress || Math.abs(span - this.mInitialSpan) > (float)this.mSpanSlop)) {
            this.mPrevSpanX = this.mCurrSpanX = spanX;
            this.mPrevSpanY = this.mCurrSpanY = spanY;
            this.mPrevSpan = this.mCurrSpan = span;
            this.mPrevTime = this.mCurrTime;
            this.mInProgress = this.mListener.onScaleBegin(this);
        }
        if (action == 2) {
            this.mCurrSpanX = spanX;
            this.mCurrSpanY = spanY;
            this.mCurrSpan = span;
            boolean updatePrev = true;
            if (this.mInProgress) {
                updatePrev = this.mListener.onScale(this);
            }
            if (updatePrev) {
                this.mPrevSpanX = this.mCurrSpanX;
                this.mPrevSpanY = this.mCurrSpanY;
                this.mPrevSpan = this.mCurrSpan;
                this.mPrevTime = this.mCurrTime;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_view_ScaleGestureDetector$inDoubleTapMode() {
        return this.mDoubleTapMode == 1;
    }

    private final void $$robo$$android_view_ScaleGestureDetector$setQuickScaleEnabled(boolean scales) {
        this.mQuickScaleEnabled = scales;
        if (this.mQuickScaleEnabled && this.mGestureDetector == null) {
            ShadowedObject gestureListener = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ScaleGestureDetector this$0;

                private void $$robo$$android_view_ScaleGestureDetector_1$__constructor__(ScaleGestureDetector scaleGestureDetector) {
                }

                private final boolean $$robo$$android_view_ScaleGestureDetector_1$onDoubleTap(MotionEvent e) {
                    this.this$0.mDoubleTapEvent = e;
                    this.this$0.mDoubleTapMode = 1;
                    return true;
                }

                private void __constructor__(ScaleGestureDetector scaleGestureDetector) {
                    this.$$robo$$android_view_ScaleGestureDetector_1$__constructor__(scaleGestureDetector);
                }
                {
                    this.this$0 = scaleGestureDetector;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ScaleGestureDetector_1$__constructor__(android.view.ScaleGestureDetector ), 0, this, scaleGestureDetector);
                }

                @Override
                public boolean onDoubleTap(MotionEvent motionEvent) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onDoubleTap", $$robo$$android_view_ScaleGestureDetector_1$onDoubleTap(android.view.MotionEvent ), 0, this, motionEvent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mGestureDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)gestureListener, this.mHandler);
        }
    }

    private final boolean $$robo$$android_view_ScaleGestureDetector$isQuickScaleEnabled() {
        return this.mQuickScaleEnabled;
    }

    private final boolean $$robo$$android_view_ScaleGestureDetector$isInProgress() {
        return this.mInProgress;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getFocusX() {
        return this.mFocusX;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getFocusY() {
        return this.mFocusY;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getCurrentSpan() {
        return this.mCurrSpan;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getCurrentSpanX() {
        return this.mCurrSpanX;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getCurrentSpanY() {
        return this.mCurrSpanY;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getPreviousSpan() {
        return this.mPrevSpan;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getPreviousSpanX() {
        return this.mPrevSpanX;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getPreviousSpanY() {
        return this.mPrevSpanY;
    }

    private final float $$robo$$android_view_ScaleGestureDetector$getScaleFactor() {
        if (this.inDoubleTapMode()) {
            boolean scaleUp = this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan < this.mPrevSpan || !this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan > this.mPrevSpan;
            float spanDiff = Math.abs(1.0f - this.mCurrSpan / this.mPrevSpan) * 0.5f;
            return this.mPrevSpan <= 0.0f ? 1.0f : (scaleUp ? 1.0f + spanDiff : 1.0f - spanDiff);
        }
        return this.mPrevSpan > 0.0f ? this.mCurrSpan / this.mPrevSpan : 1.0f;
    }

    private final long $$robo$$android_view_ScaleGestureDetector$getTimeDelta() {
        return this.mCurrTime - this.mPrevTime;
    }

    private final long $$robo$$android_view_ScaleGestureDetector$getEventTime() {
        return this.mCurrTime;
    }

    private void __constructor__(Context context, OnScaleGestureListener onScaleGestureListener) {
        this.$$robo$$android_view_ScaleGestureDetector$__constructor__(context, onScaleGestureListener);
    }

    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener) {
        this(context, onScaleGestureListener, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ScaleGestureDetector$__constructor__(android.content.Context android.view.ScaleGestureDetector$OnScaleGestureListener ), 0, this, context, onScaleGestureListener);
    }

    private void __constructor__(Context context, OnScaleGestureListener onScaleGestureListener, Handler handler) {
        this.$$robo$$android_view_ScaleGestureDetector$__constructor__(context, onScaleGestureListener, handler);
    }

    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ScaleGestureDetector$__constructor__(android.content.Context android.view.ScaleGestureDetector$OnScaleGestureListener android.os.Handler ), 0, this, context, onScaleGestureListener, handler);
    }

    private void addTouchHistory(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("addTouchHistory", $$robo$$android_view_ScaleGestureDetector$addTouchHistory(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void clearTouchHistory() {
        InvokeDynamicSupport.bootstrap("clearTouchHistory", $$robo$$android_view_ScaleGestureDetector$clearTouchHistory(), 0, this);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_view_ScaleGestureDetector$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean inDoubleTapMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("inDoubleTapMode", $$robo$$android_view_ScaleGestureDetector$inDoubleTapMode(), 0, this);
    }

    public void setQuickScaleEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setQuickScaleEnabled", $$robo$$android_view_ScaleGestureDetector$setQuickScaleEnabled(boolean ), 0, this, bl);
    }

    public boolean isQuickScaleEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isQuickScaleEnabled", $$robo$$android_view_ScaleGestureDetector$isQuickScaleEnabled(), 0, this);
    }

    public boolean isInProgress() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInProgress", $$robo$$android_view_ScaleGestureDetector$isInProgress(), 0, this);
    }

    public float getFocusX() {
        return (float)InvokeDynamicSupport.bootstrap("getFocusX", $$robo$$android_view_ScaleGestureDetector$getFocusX(), 0, this);
    }

    public float getFocusY() {
        return (float)InvokeDynamicSupport.bootstrap("getFocusY", $$robo$$android_view_ScaleGestureDetector$getFocusY(), 0, this);
    }

    public float getCurrentSpan() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentSpan", $$robo$$android_view_ScaleGestureDetector$getCurrentSpan(), 0, this);
    }

    public float getCurrentSpanX() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentSpanX", $$robo$$android_view_ScaleGestureDetector$getCurrentSpanX(), 0, this);
    }

    public float getCurrentSpanY() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentSpanY", $$robo$$android_view_ScaleGestureDetector$getCurrentSpanY(), 0, this);
    }

    public float getPreviousSpan() {
        return (float)InvokeDynamicSupport.bootstrap("getPreviousSpan", $$robo$$android_view_ScaleGestureDetector$getPreviousSpan(), 0, this);
    }

    public float getPreviousSpanX() {
        return (float)InvokeDynamicSupport.bootstrap("getPreviousSpanX", $$robo$$android_view_ScaleGestureDetector$getPreviousSpanX(), 0, this);
    }

    public float getPreviousSpanY() {
        return (float)InvokeDynamicSupport.bootstrap("getPreviousSpanY", $$robo$$android_view_ScaleGestureDetector$getPreviousSpanY(), 0, this);
    }

    public float getScaleFactor() {
        return (float)InvokeDynamicSupport.bootstrap("getScaleFactor", $$robo$$android_view_ScaleGestureDetector$getScaleFactor(), 0, this);
    }

    public long getTimeDelta() {
        return (long)InvokeDynamicSupport.bootstrap("getTimeDelta", $$robo$$android_view_ScaleGestureDetector$getTimeDelta(), 0, this);
    }

    public long getEventTime() {
        return (long)InvokeDynamicSupport.bootstrap("getEventTime", $$robo$$android_view_ScaleGestureDetector$getEventTime(), 0, this);
    }

    public /* synthetic */ ScaleGestureDetector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleGestureDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$__constructor__() {
        }

        private final boolean $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScale(ScaleGestureDetector detector) {
            return false;
        }

        private final boolean $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        private final void $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScaleEnd(ScaleGestureDetector detector) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$__constructor__();
        }

        public SimpleOnScaleGestureListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$__constructor__(), 0, this);
        }

        @Override
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            return (boolean)InvokeDynamicSupport.bootstrap("onScale", $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScale(android.view.ScaleGestureDetector ), 0, this, scaleGestureDetector);
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            return (boolean)InvokeDynamicSupport.bootstrap("onScaleBegin", $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScaleBegin(android.view.ScaleGestureDetector ), 0, this, scaleGestureDetector);
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            InvokeDynamicSupport.bootstrap("onScaleEnd", $$robo$$android_view_ScaleGestureDetector_SimpleOnScaleGestureListener$onScaleEnd(android.view.ScaleGestureDetector ), 0, this, scaleGestureDetector);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleOnScaleGestureListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnScaleGestureListener
    extends InstrumentedInterface {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

