/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.Choreographer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IAssetAtlas;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ThreadedRenderer
extends HardwareRenderer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "ThreadedRenderer";
    private static int SYNC_OK = 0;
    private static int SYNC_INVALIDATE_REQUIRED = 1;
    private static String[] VISUALIZERS;
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private float mLightY;
    private float mLightZ;
    private float mLightRadius;
    private int mAmbientShadowAlpha;
    private int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized;
    private RenderNode mRootNode;
    private Choreographer mChoreographer;
    private boolean mProfilingEnabled;
    private boolean mRootNodeNeedsUpdate;

    private void $$robo$$android_view_ThreadedRenderer$__constructor__(Context context, boolean translucent) {
        this.mInitialized = false;
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(2, 0.0f);
        this.mLightZ = a.getDimension(3, 0.0f);
        this.mLightRadius = a.getDimension(4, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        AtlasInitializer.sInstance.init(context, this.mNativeProxy);
        this.mChoreographer = Choreographer.getInstance();
        ThreadedRenderer.nSetFrameInterval(this.mNativeProxy, this.mChoreographer.getFrameIntervalNanos());
        this.loadSystemProperties();
    }

    private final void $$robo$$android_view_ThreadedRenderer$destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$initialize(Surface surface) throws Surface.OutOfResourcesException {
        this.mInitialized = true;
        this.updateEnabledState(surface);
        boolean status = ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        surface.allocateBuffers();
        return status;
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    private final void $$robo$$android_view_ThreadedRenderer$pauseSurface(Surface surface) {
        ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    private final void $$robo$$android_view_ThreadedRenderer$destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static final void $$robo$$android_view_ThreadedRenderer$destroyResources(View view) {
        view.destroyHardwareResources();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ThreadedRenderer.destroyResources(group.getChildAt(i));
            }
        }
    }

    private final void $$robo$$android_view_ThreadedRenderer$invalidate(Surface surface) {
        this.updateSurface(surface);
    }

    private final void $$robo$$android_view_ThreadedRenderer$detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setup(int width, int height, Rect surfaceInsets) {
        float lightX = (float)width / 2.0f;
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && !surfaceInsets.isEmpty()) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mSurfaceWidth, this.mSurfaceHeight, lightX, this.mLightY, this.mLightZ, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setOpaque(boolean opaque) {
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, opaque && !this.mHasInsets);
    }

    private final int $$robo$$android_view_ThreadedRenderer$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_view_ThreadedRenderer$getHeight() {
        return this.mHeight;
    }

    private final void $$robo$$android_view_ThreadedRenderer$dumpGfxInfo(PrintWriter pw, FileDescriptor fd) {
        pw.flush();
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd);
    }

    private static final int $$robo$$android_view_ThreadedRenderer$search(String[] values, String value) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$checkIfProfilingRequested() {
        String profiling = SystemProperties.get("debug.hwui.profile");
        int graphType = ThreadedRenderer.search(VISUALIZERS, profiling);
        return graphType >= 0 || Boolean.parseBoolean(profiling);
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        boolean wantProfiling = ThreadedRenderer.checkIfProfilingRequested();
        if (wantProfiling != this.mProfilingEnabled) {
            this.mProfilingEnabled = wantProfiling;
            changed = true;
        }
        return changed;
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.getDisplayList();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_ThreadedRenderer$updateRootDisplayList(View view, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        Trace.traceBegin(8L, "getDisplayList");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            HardwareCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onHardwarePreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.getDisplayList());
                canvas.insertInorderBarrier();
                callbacks.onHardwarePostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    private final void $$robo$$android_view_ThreadedRenderer$invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    private final void $$robo$$android_view_ThreadedRenderer$draw(View view, View.AttachInfo attachInfo, HardwareRenderer.HardwareDrawCallbacks callbacks) {
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        long frameTimeNanos = this.mChoreographer.getFrameTimeNanos();
        attachInfo.mDrawingTime = frameTimeNanos / 1000000L;
        Object recordDuration = 0L;
        if (this.mProfilingEnabled) {
            recordDuration = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        }
        this.updateRootDisplayList(view, callbacks);
        if (this.mProfilingEnabled) {
            recordDuration = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - recordDuration;
        }
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameTimeNanos, recordDuration, view.getResources().getDisplayMetrics().density)) & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    private static final void $$robo$$android_view_ThreadedRenderer$invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    private final HardwareLayer $$robo$$android_view_ThreadedRenderer$createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    private final void $$robo$$android_view_ThreadedRenderer$buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap.mNativeBitmap);
    }

    private final void $$robo$$android_view_ThreadedRenderer$pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    private final void $$robo$$android_view_ThreadedRenderer$onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    private final void $$robo$$android_view_ThreadedRenderer$setName(String name) {
    }

    private final void $$robo$$android_view_ThreadedRenderer$fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_ThreadedRenderer$finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private static final void $$robo$$android_view_ThreadedRenderer$trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    private static final void $$robo$$android_view_ThreadedRenderer$setupShadersDiskCache(String string2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetAtlas(long l, GraphicBuffer graphicBuffer, long[] lArray) {
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateRootRenderNode() {
        return 0L;
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateProxy(boolean bl, long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDeleteProxy(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetFrameInterval(long l, long l2) {
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nLoadSystemProperties(long l) {
        return false;
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nInitialize(long l, Surface surface) {
        return false;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nUpdateSurface(long l, Surface surface) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nPauseSurface(long l, Surface surface) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetup(long l, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetOpaque(long l, boolean bl) {
    }

    private static final int $$robo$$android_view_ThreadedRenderer$nSyncAndDrawFrame(long l, long l2, long l3, float f) {
        return 0;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDestroy(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRegisterAnimatingRenderNode(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nInvokeFunctor(long l, boolean bl) {
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateTextureLayer(long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nBuildLayer(long l, long l2) {
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nCopyLayerInto(long l, long l2, long l3) {
        return false;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nPushLayerUpdate(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nCancelLayerUpdate(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDetachSurfaceTexture(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDestroyHardwareResources(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nTrimMemory(int n) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nFence(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nStopDrawing(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nNotifyFramePending(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDumpProfileInfo(long l, FileDescriptor fileDescriptor) {
    }

    static void __staticInitializer__() {
        VISUALIZERS = new String[]{"visual_bars"};
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_view_ThreadedRenderer$__constructor__(context, bl);
    }

    ThreadedRenderer(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ThreadedRenderer$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    @Override
    void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_ThreadedRenderer$destroy(), 0, this);
    }

    private void updateEnabledState(Surface surface) {
        InvokeDynamicSupport.bootstrap("updateEnabledState", $$robo$$android_view_ThreadedRenderer$updateEnabledState(android.view.Surface ), 0, this, surface);
    }

    @Override
    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        return (boolean)InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_ThreadedRenderer$initialize(android.view.Surface ), 0, this, surface);
    }

    @Override
    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        InvokeDynamicSupport.bootstrap("updateSurface", $$robo$$android_view_ThreadedRenderer$updateSurface(android.view.Surface ), 0, this, surface);
    }

    @Override
    void pauseSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("pauseSurface", $$robo$$android_view_ThreadedRenderer$pauseSurface(android.view.Surface ), 0, this, surface);
    }

    @Override
    void destroyHardwareResources(View view) {
        InvokeDynamicSupport.bootstrap("destroyHardwareResources", $$robo$$android_view_ThreadedRenderer$destroyHardwareResources(android.view.View ), 0, this, view);
    }

    private static void destroyResources(View view) {
        InvokeDynamicSupport.bootstrapStatic("destroyResources", $$robo$$android_view_ThreadedRenderer$destroyResources(android.view.View ), 0, (View)view);
    }

    @Override
    void invalidate(Surface surface) {
        InvokeDynamicSupport.bootstrap("invalidate", $$robo$$android_view_ThreadedRenderer$invalidate(android.view.Surface ), 0, this, surface);
    }

    @Override
    void detachSurfaceTexture(long l) {
        InvokeDynamicSupport.bootstrap("detachSurfaceTexture", $$robo$$android_view_ThreadedRenderer$detachSurfaceTexture(long ), 0, this, l);
    }

    @Override
    void setup(int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_view_ThreadedRenderer$setup(int int android.graphics.Rect ), 0, this, n, n2, rect);
    }

    @Override
    void setOpaque(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOpaque", $$robo$$android_view_ThreadedRenderer$setOpaque(boolean ), 0, this, bl);
    }

    @Override
    int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_view_ThreadedRenderer$getWidth(), 0, this);
    }

    @Override
    int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_view_ThreadedRenderer$getHeight(), 0, this);
    }

    @Override
    void dumpGfxInfo(PrintWriter printWriter, FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("dumpGfxInfo", $$robo$$android_view_ThreadedRenderer$dumpGfxInfo(java.io.PrintWriter java.io.FileDescriptor ), 0, this, printWriter, fileDescriptor);
    }

    private static int search(String[] stringArray, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("search", $$robo$$android_view_ThreadedRenderer$search(java.lang.String[] java.lang.String ), 0, (String[])stringArray, (String)string2);
    }

    private static boolean checkIfProfilingRequested() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkIfProfilingRequested", $$robo$$android_view_ThreadedRenderer$checkIfProfilingRequested(), 0);
    }

    @Override
    boolean loadSystemProperties() {
        return (boolean)InvokeDynamicSupport.bootstrap("loadSystemProperties", $$robo$$android_view_ThreadedRenderer$loadSystemProperties(), 0, this);
    }

    private void updateViewTreeDisplayList(View view) {
        InvokeDynamicSupport.bootstrap("updateViewTreeDisplayList", $$robo$$android_view_ThreadedRenderer$updateViewTreeDisplayList(android.view.View ), 0, this, view);
    }

    private void updateRootDisplayList(View view, HardwareRenderer.HardwareDrawCallbacks hardwareDrawCallbacks) {
        InvokeDynamicSupport.bootstrap("updateRootDisplayList", $$robo$$android_view_ThreadedRenderer$updateRootDisplayList(android.view.View android.view.HardwareRenderer$HardwareDrawCallbacks ), 0, this, view, hardwareDrawCallbacks);
    }

    @Override
    void invalidateRoot() {
        InvokeDynamicSupport.bootstrap("invalidateRoot", $$robo$$android_view_ThreadedRenderer$invalidateRoot(), 0, this);
    }

    @Override
    void draw(View view, View.AttachInfo attachInfo, HardwareRenderer.HardwareDrawCallbacks hardwareDrawCallbacks) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_view_ThreadedRenderer$draw(android.view.View android.view.View$AttachInfo android.view.HardwareRenderer$HardwareDrawCallbacks ), 0, this, view, attachInfo, hardwareDrawCallbacks);
    }

    static void invokeFunctor(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("invokeFunctor", $$robo$$android_view_ThreadedRenderer$invokeFunctor(long boolean ), 0, (long)l, (boolean)bl);
    }

    @Override
    HardwareLayer createTextureLayer() {
        return InvokeDynamicSupport.bootstrap("createTextureLayer", $$robo$$android_view_ThreadedRenderer$createTextureLayer(), 0, this);
    }

    @Override
    void buildLayer(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("buildLayer", $$robo$$android_view_ThreadedRenderer$buildLayer(android.view.RenderNode ), 0, this, renderNode);
    }

    @Override
    boolean copyLayerInto(HardwareLayer hardwareLayer, Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("copyLayerInto", $$robo$$android_view_ThreadedRenderer$copyLayerInto(android.view.HardwareLayer android.graphics.Bitmap ), 0, this, hardwareLayer, bitmap);
    }

    @Override
    void pushLayerUpdate(HardwareLayer hardwareLayer) {
        InvokeDynamicSupport.bootstrap("pushLayerUpdate", $$robo$$android_view_ThreadedRenderer$pushLayerUpdate(android.view.HardwareLayer ), 0, this, hardwareLayer);
    }

    @Override
    void onLayerDestroyed(HardwareLayer hardwareLayer) {
        InvokeDynamicSupport.bootstrap("onLayerDestroyed", $$robo$$android_view_ThreadedRenderer$onLayerDestroyed(android.view.HardwareLayer ), 0, this, hardwareLayer);
    }

    @Override
    void setName(String string2) {
        InvokeDynamicSupport.bootstrap("setName", $$robo$$android_view_ThreadedRenderer$setName(java.lang.String ), 0, this, string2);
    }

    @Override
    void fence() {
        InvokeDynamicSupport.bootstrap("fence", $$robo$$android_view_ThreadedRenderer$fence(), 0, this);
    }

    @Override
    void stopDrawing() {
        InvokeDynamicSupport.bootstrap("stopDrawing", $$robo$$android_view_ThreadedRenderer$stopDrawing(), 0, this);
    }

    @Override
    public void notifyFramePending() {
        InvokeDynamicSupport.bootstrap("notifyFramePending", $$robo$$android_view_ThreadedRenderer$notifyFramePending(), 0, this);
    }

    @Override
    void registerAnimatingRenderNode(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("registerAnimatingRenderNode", $$robo$$android_view_ThreadedRenderer$registerAnimatingRenderNode(android.view.RenderNode ), 0, this, renderNode);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_ThreadedRenderer$finalize(), 0, this);
    }

    static void trimMemory(int n) {
        InvokeDynamicSupport.bootstrapStatic("trimMemory", $$robo$$android_view_ThreadedRenderer$trimMemory(int ), 0, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$setupShadersDiskCache$nativeBinding(String var0);

    static void setupShadersDiskCache(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setupShadersDiskCache", $$robo$$android_view_ThreadedRenderer$setupShadersDiskCache(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nSetAtlas$nativeBinding(long var0, GraphicBuffer var2, long[] var3);

    private static void nSetAtlas(long l, GraphicBuffer graphicBuffer, long[] lArray) {
        InvokeDynamicSupport.bootstrapStatic("nSetAtlas", $$robo$$android_view_ThreadedRenderer$nSetAtlas(long android.view.GraphicBuffer long[] ), 1, (long)l, (GraphicBuffer)graphicBuffer, (long[])lArray);
    }

    private static final native /* synthetic */ long $$robo$$nCreateRootRenderNode$nativeBinding();

    private static long nCreateRootRenderNode() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateRootRenderNode", $$robo$$android_view_ThreadedRenderer$nCreateRootRenderNode(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nCreateProxy$nativeBinding(boolean var0, long var1);

    private static long nCreateProxy(boolean bl, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateProxy", $$robo$$android_view_ThreadedRenderer$nCreateProxy(boolean long ), 1, (boolean)bl, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nDeleteProxy$nativeBinding(long var0);

    private static void nDeleteProxy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nDeleteProxy", $$robo$$android_view_ThreadedRenderer$nDeleteProxy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetFrameInterval$nativeBinding(long var0, long var2);

    private static void nSetFrameInterval(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetFrameInterval", $$robo$$android_view_ThreadedRenderer$nSetFrameInterval(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nLoadSystemProperties$nativeBinding(long var0);

    private static boolean nLoadSystemProperties(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nLoadSystemProperties", $$robo$$android_view_ThreadedRenderer$nLoadSystemProperties(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nInitialize$nativeBinding(long var0, Surface var2);

    private static boolean nInitialize(long l, Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nInitialize", $$robo$$android_view_ThreadedRenderer$nInitialize(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ void $$robo$$nUpdateSurface$nativeBinding(long var0, Surface var2);

    private static void nUpdateSurface(long l, Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateSurface", $$robo$$android_view_ThreadedRenderer$nUpdateSurface(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ void $$robo$$nPauseSurface$nativeBinding(long var0, Surface var2);

    private static void nPauseSurface(long l, Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("nPauseSurface", $$robo$$android_view_ThreadedRenderer$nPauseSurface(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ void $$robo$$nSetup$nativeBinding(long var0, int var2, int var3, float var4, float var5, float var6, float var7, int var8, int var9);

    private static void nSetup(long l, int n, int n2, float f, float f2, float f3, float f4, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("nSetup", $$robo$$android_view_ThreadedRenderer$nSetup(long int int float float float float int int ), 1, (long)l, (int)n, (int)n2, (float)f, (float)f2, (float)f3, (float)f4, (int)n3, (int)n4);
    }

    private static final native /* synthetic */ void $$robo$$nSetOpaque$nativeBinding(long var0, boolean var2);

    private static void nSetOpaque(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetOpaque", $$robo$$android_view_ThreadedRenderer$nSetOpaque(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nSyncAndDrawFrame$nativeBinding(long var0, long var2, long var4, float var6);

    private static int nSyncAndDrawFrame(long l, long l2, long l3, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSyncAndDrawFrame", $$robo$$android_view_ThreadedRenderer$nSyncAndDrawFrame(long long long float ), 1, (long)l, (long)l2, (long)l3, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nDestroy$nativeBinding(long var0);

    private static void nDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nDestroy", $$robo$$android_view_ThreadedRenderer$nDestroy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nRegisterAnimatingRenderNode$nativeBinding(long var0, long var2);

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nRegisterAnimatingRenderNode", $$robo$$android_view_ThreadedRenderer$nRegisterAnimatingRenderNode(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nInvokeFunctor$nativeBinding(long var0, boolean var2);

    private static void nInvokeFunctor(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nInvokeFunctor", $$robo$$android_view_ThreadedRenderer$nInvokeFunctor(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ long $$robo$$nCreateTextureLayer$nativeBinding(long var0);

    private static long nCreateTextureLayer(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateTextureLayer", $$robo$$android_view_ThreadedRenderer$nCreateTextureLayer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nBuildLayer$nativeBinding(long var0, long var2);

    private static void nBuildLayer(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nBuildLayer", $$robo$$android_view_ThreadedRenderer$nBuildLayer(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nCopyLayerInto$nativeBinding(long var0, long var2, long var4);

    private static boolean nCopyLayerInto(long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nCopyLayerInto", $$robo$$android_view_ThreadedRenderer$nCopyLayerInto(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nPushLayerUpdate$nativeBinding(long var0, long var2);

    private static void nPushLayerUpdate(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nPushLayerUpdate", $$robo$$android_view_ThreadedRenderer$nPushLayerUpdate(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nCancelLayerUpdate$nativeBinding(long var0, long var2);

    private static void nCancelLayerUpdate(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nCancelLayerUpdate", $$robo$$android_view_ThreadedRenderer$nCancelLayerUpdate(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nDetachSurfaceTexture$nativeBinding(long var0, long var2);

    private static void nDetachSurfaceTexture(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDetachSurfaceTexture", $$robo$$android_view_ThreadedRenderer$nDetachSurfaceTexture(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nDestroyHardwareResources$nativeBinding(long var0);

    private static void nDestroyHardwareResources(long l) {
        InvokeDynamicSupport.bootstrapStatic("nDestroyHardwareResources", $$robo$$android_view_ThreadedRenderer$nDestroyHardwareResources(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nTrimMemory$nativeBinding(int var0);

    private static void nTrimMemory(int n) {
        InvokeDynamicSupport.bootstrapStatic("nTrimMemory", $$robo$$android_view_ThreadedRenderer$nTrimMemory(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nFence$nativeBinding(long var0);

    private static void nFence(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFence", $$robo$$android_view_ThreadedRenderer$nFence(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nStopDrawing$nativeBinding(long var0);

    private static void nStopDrawing(long l) {
        InvokeDynamicSupport.bootstrapStatic("nStopDrawing", $$robo$$android_view_ThreadedRenderer$nStopDrawing(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nNotifyFramePending$nativeBinding(long var0);

    private static void nNotifyFramePending(long l) {
        InvokeDynamicSupport.bootstrapStatic("nNotifyFramePending", $$robo$$android_view_ThreadedRenderer$nNotifyFramePending(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nDumpProfileInfo$nativeBinding(long var0, FileDescriptor var2);

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("nDumpProfileInfo", $$robo$$android_view_ThreadedRenderer$nDumpProfileInfo(long java.io.FileDescriptor ), 1, (long)l, (FileDescriptor)fileDescriptor);
    }

    static {
        RobolectricInternals.classInitializing(ThreadedRenderer.class);
    }

    public /* synthetic */ ThreadedRenderer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadedRenderer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AtlasInitializer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static AtlasInitializer sInstance;
        private boolean mInitialized;

        private void $$robo$$android_view_ThreadedRenderer_AtlasInitializer$__constructor__() {
            this.mInitialized = false;
        }

        private final synchronized void $$robo$$android_view_ThreadedRenderer_AtlasInitializer$init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            IBinder binder = ServiceManager.getService("assetatlas");
            if (binder == null) {
                return;
            }
            IAssetAtlas atlas = IAssetAtlas.Stub.asInterface(binder);
            try {
                GraphicBuffer buffer;
                if (atlas.isCompatible(Process.myPpid()) && (buffer = atlas.getBuffer()) != null) {
                    long[] map = atlas.getMap();
                    if (map != null) {
                        AtlasInitializer.validateMap(context, map);
                        ThreadedRenderer.nSetAtlas(renderProxy, buffer, map);
                        this.mInitialized = true;
                    }
                    if (atlas.getClass() != binder.getClass()) {
                        buffer.destroy();
                    }
                }
            }
            catch (RemoteException e) {
                Log.w("HardwareRenderer", "Could not acquire atlas", e);
            }
        }

        private static final void $$robo$$android_view_ThreadedRenderer_AtlasInitializer$validateMap(Context context, long[] map) {
            int i;
            Log.d("Atlas", "Validating map...");
            HashSet<Long> preloadedPointers = new HashSet<Long>();
            Resources resources = context.getResources();
            LongSparseArray<Drawable.ConstantState> drawables = resources.getPreloadedDrawables();
            int count = drawables.size();
            for (i = 0; i < count; ++i) {
                Bitmap bitmap = drawables.valueAt(i).getBitmap();
                if (bitmap == null || bitmap.getConfig() != Bitmap.Config.ARGB_8888) continue;
                preloadedPointers.add(bitmap.mNativeBitmap);
            }
            for (i = 0; i < map.length; i += 4) {
                if (preloadedPointers.contains(map[i])) continue;
                Log.w("Atlas", String.format("Pointer 0x%X, not in getPreloadedDrawables?", map[i]));
                map[i] = 0L;
            }
        }

        static void __staticInitializer__() {
            sInstance = new AtlasInitializer();
        }

        private void __constructor__() {
            this.$$robo$$android_view_ThreadedRenderer_AtlasInitializer$__constructor__();
        }

        private AtlasInitializer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ThreadedRenderer_AtlasInitializer$__constructor__(), 0, this);
        }

        synchronized void init(Context context, long l) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_ThreadedRenderer_AtlasInitializer$init(android.content.Context long ), 0, this, context, l);
        }

        private static void validateMap(Context context, long[] lArray) {
            InvokeDynamicSupport.bootstrapStatic("validateMap", $$robo$$android_view_ThreadedRenderer_AtlasInitializer$validateMap(android.content.Context long[] ), 0, (Context)context, (long[])lArray);
        }

        static {
            RobolectricInternals.classInitializing(AtlasInitializer.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AtlasInitializer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

