/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemProperties;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.view.ActionMode;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Window
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FEATURE_OPTIONS_PANEL = 0;
    public static int FEATURE_NO_TITLE = 1;
    public static int FEATURE_PROGRESS = 2;
    public static int FEATURE_LEFT_ICON = 3;
    public static int FEATURE_RIGHT_ICON = 4;
    public static int FEATURE_INDETERMINATE_PROGRESS = 5;
    public static int FEATURE_CONTEXT_MENU = 6;
    public static int FEATURE_CUSTOM_TITLE = 7;
    public static int FEATURE_ACTION_BAR = 8;
    public static int FEATURE_ACTION_BAR_OVERLAY = 9;
    public static int FEATURE_ACTION_MODE_OVERLAY = 10;
    public static int FEATURE_SWIPE_TO_DISMISS = 11;
    public static int FEATURE_CONTENT_TRANSITIONS = 12;
    public static int FEATURE_ACTIVITY_TRANSITIONS = 13;
    public static int FEATURE_MAX = 13;
    public static int PROGRESS_VISIBILITY_ON = -1;
    public static int PROGRESS_VISIBILITY_OFF = -2;
    public static int PROGRESS_INDETERMINATE_ON = -3;
    public static int PROGRESS_INDETERMINATE_OFF = -4;
    public static int PROGRESS_START = 0;
    public static int PROGRESS_END = 10000;
    public static int PROGRESS_SECONDARY_START = 20000;
    public static int PROGRESS_SECONDARY_END = 30000;
    public static String STATUS_BAR_BACKGROUND_TRANSITION_NAME = "android:status:background";
    public static String NAVIGATION_BAR_BACKGROUND_TRANSITION_NAME = "android:navigation:background";
    protected static int DEFAULT_FEATURES = 65;
    public static int ID_ANDROID_CONTENT = 0x1020002;
    private static String PROPERTY_HARDWARE_UI = "persist.sys.ui.hw";
    private Context mContext;
    private TypedArray mWindowStyle;
    private Callback mCallback;
    private OnWindowDismissedCallback mOnWindowDismissedCallback;
    private WindowManager mWindowManager;
    private IBinder mAppToken;
    private String mAppName;
    private boolean mHardwareAccelerated;
    private Window mContainer;
    private Window mActiveChild;
    private boolean mIsActive;
    private boolean mHasChildren;
    private boolean mCloseOnTouchOutside;
    private boolean mSetCloseOnTouchOutside;
    private int mForcedWindowFlags;
    private int mFeatures;
    private int mLocalFeatures;
    private boolean mHaveWindowFormat;
    private boolean mHaveDimAmount;
    private int mDefaultWindowFormat;
    private boolean mHasSoftInputMode;
    private boolean mDestroyed;
    private WindowManager.LayoutParams mWindowAttributes;

    private void $$robo$$android_view_Window$__constructor__(Context context) {
        this.mIsActive = false;
        this.mHasChildren = false;
        this.mCloseOnTouchOutside = false;
        this.mSetCloseOnTouchOutside = false;
        this.mForcedWindowFlags = 0;
        this.mFeatures = 65;
        this.mLocalFeatures = 65;
        this.mHaveWindowFormat = false;
        this.mHaveDimAmount = false;
        this.mDefaultWindowFormat = -1;
        this.mHasSoftInputMode = false;
        this.mWindowAttributes = new WindowManager.LayoutParams();
        this.mContext = context;
    }

    private final Context $$robo$$android_view_Window$getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TypedArray $$robo$$android_view_Window$getWindowStyle() {
        Window window = this;
        synchronized (window) {
            if (this.mWindowStyle == null) {
                this.mWindowStyle = this.mContext.obtainStyledAttributes(R.styleable.Window);
            }
            return this.mWindowStyle;
        }
    }

    private final void $$robo$$android_view_Window$setContainer(Window container) {
        this.mContainer = container;
        if (container != null) {
            this.mFeatures |= 2;
            this.mLocalFeatures |= 2;
            container.mHasChildren = true;
        }
    }

    private final Window $$robo$$android_view_Window$getContainer() {
        return this.mContainer;
    }

    private final boolean $$robo$$android_view_Window$hasChildren() {
        return this.mHasChildren;
    }

    private final void $$robo$$android_view_Window$destroy() {
        this.mDestroyed = true;
    }

    private final boolean $$robo$$android_view_Window$isDestroyed() {
        return this.mDestroyed;
    }

    private final void $$robo$$android_view_Window$setWindowManager(WindowManager wm, IBinder appToken, String appName) {
        this.setWindowManager(wm, appToken, appName, false);
    }

    private final void $$robo$$android_view_Window$setWindowManager(WindowManager wm, IBinder appToken, String appName, boolean hardwareAccelerated) {
        this.mAppToken = appToken;
        this.mAppName = appName;
        boolean bl = this.mHardwareAccelerated = hardwareAccelerated || SystemProperties.getBoolean("persist.sys.ui.hw", false);
        if (wm == null) {
            wm = (WindowManager)this.mContext.getSystemService("window");
        }
        this.mWindowManager = ((WindowManagerImpl)wm).createLocalWindowManager(this);
    }

    private final void $$robo$$android_view_Window$adjustLayoutParamsForSubWindow(WindowManager.LayoutParams wp) {
        CharSequence curTitle = wp.getTitle();
        if (wp.type >= 1000 && wp.type <= 1999) {
            View decor;
            if (wp.token == null && (decor = this.peekDecorView()) != null) {
                wp.token = decor.getWindowToken();
            }
            if (curTitle == null || curTitle.length() == 0) {
                String title = wp.type == 1001 ? "Media" : (wp.type == 1004 ? "MediaOvr" : (wp.type == 1000 ? "Panel" : (wp.type == 1002 ? "SubPanel" : (wp.type == 1003 ? "AtchDlg" : Integer.toString(wp.type)))));
                if (this.mAppName != null) {
                    title = title + ":" + this.mAppName;
                }
                wp.setTitle(title);
            }
        } else {
            if (wp.token == null) {
                IBinder iBinder = wp.token = this.mContainer == null ? this.mAppToken : this.mContainer.mAppToken;
            }
            if ((curTitle == null || curTitle.length() == 0) && this.mAppName != null) {
                wp.setTitle(this.mAppName);
            }
        }
        if (wp.packageName == null) {
            wp.packageName = this.mContext.getPackageName();
        }
        if (this.mHardwareAccelerated) {
            wp.flags |= 0x1000000;
        }
    }

    private final WindowManager $$robo$$android_view_Window$getWindowManager() {
        return this.mWindowManager;
    }

    private final void $$robo$$android_view_Window$setCallback(Callback callback) {
        this.mCallback = callback;
    }

    private final Callback $$robo$$android_view_Window$getCallback() {
        return this.mCallback;
    }

    private final void $$robo$$android_view_Window$setOnWindowDismissedCallback(OnWindowDismissedCallback dcb) {
        this.mOnWindowDismissedCallback = dcb;
    }

    private final void $$robo$$android_view_Window$dispatchOnWindowDismissed() {
        if (this.mOnWindowDismissedCallback != null) {
            this.mOnWindowDismissedCallback.onWindowDismissed();
        }
    }

    public abstract void takeSurface(SurfaceHolder.Callback2 var1);

    public abstract void takeInputQueue(InputQueue.Callback var1);

    public abstract boolean isFloating();

    private final void $$robo$$android_view_Window$setLayout(int width, int height) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.width = width;
        attrs.height = height;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setGravity(int gravity) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.gravity = gravity;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setType(int type) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.type = type;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setFormat(int format) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (format != 0) {
            attrs.format = format;
            this.mHaveWindowFormat = true;
        } else {
            attrs.format = this.mDefaultWindowFormat;
            this.mHaveWindowFormat = false;
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setWindowAnimations(int resId) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.windowAnimations = resId;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setSoftInputMode(int mode) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (mode != 0) {
            attrs.softInputMode = mode;
            this.mHasSoftInputMode = true;
        } else {
            this.mHasSoftInputMode = false;
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$addFlags(int flags) {
        this.setFlags(flags, flags);
    }

    private final void $$robo$$android_view_Window$addPrivateFlags(int flags) {
        this.setPrivateFlags(flags, flags);
    }

    private final void $$robo$$android_view_Window$clearFlags(int flags) {
        this.setFlags(0, flags);
    }

    private final void $$robo$$android_view_Window$setFlags(int flags, int mask) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.flags = attrs.flags & ~mask | flags & mask;
        if ((mask & 0x40000000) != 0) {
            attrs.privateFlags |= 8;
        }
        this.mForcedWindowFlags |= mask;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setPrivateFlags(int flags, int mask) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.privateFlags = attrs.privateFlags & ~mask | flags & mask;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$dispatchWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    private final void $$robo$$android_view_Window$setDimAmount(float amount) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.dimAmount = amount;
        this.mHaveDimAmount = true;
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final void $$robo$$android_view_Window$setAttributes(WindowManager.LayoutParams a) {
        this.mWindowAttributes.copyFrom(a);
        this.dispatchWindowAttributesChanged(this.mWindowAttributes);
    }

    private final WindowManager.LayoutParams $$robo$$android_view_Window$getAttributes() {
        return this.mWindowAttributes;
    }

    private final int $$robo$$android_view_Window$getForcedWindowFlags() {
        return this.mForcedWindowFlags;
    }

    private final boolean $$robo$$android_view_Window$hasSoftInputMode() {
        return this.mHasSoftInputMode;
    }

    private final void $$robo$$android_view_Window$setCloseOnTouchOutside(boolean close) {
        this.mCloseOnTouchOutside = close;
        this.mSetCloseOnTouchOutside = true;
    }

    private final void $$robo$$android_view_Window$setCloseOnTouchOutsideIfNotSet(boolean close) {
        if (!this.mSetCloseOnTouchOutside) {
            this.mCloseOnTouchOutside = close;
            this.mSetCloseOnTouchOutside = true;
        }
    }

    public abstract void alwaysReadCloseOnTouchAttr();

    private final boolean $$robo$$android_view_Window$shouldCloseOnTouch(Context context, MotionEvent event) {
        return this.mCloseOnTouchOutside && event.getAction() == 0 && this.isOutOfBounds(context, event) && this.peekDecorView() != null;
    }

    private final boolean $$robo$$android_view_Window$isOutOfBounds(Context context, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(context).getScaledWindowTouchSlop();
        View decorView = this.getDecorView();
        return x < -slop || y < -slop || x > decorView.getWidth() + slop || y > decorView.getHeight() + slop;
    }

    private final boolean $$robo$$android_view_Window$requestFeature(int featureId) {
        int flag = 1 << featureId;
        this.mFeatures |= flag;
        this.mLocalFeatures |= this.mContainer != null ? flag & ~this.mContainer.mFeatures : flag;
        return (this.mFeatures & flag) != 0;
    }

    private final void $$robo$$android_view_Window$removeFeature(int featureId) {
        int flag = 1 << featureId;
        this.mFeatures &= ~flag;
        this.mLocalFeatures &= ~(this.mContainer != null ? flag & ~this.mContainer.mFeatures : flag);
    }

    private final void $$robo$$android_view_Window$makeActive() {
        if (this.mContainer != null) {
            if (this.mContainer.mActiveChild != null) {
                this.mContainer.mActiveChild.mIsActive = false;
            }
            this.mContainer.mActiveChild = this;
        }
        this.mIsActive = true;
        this.onActive();
    }

    private final boolean $$robo$$android_view_Window$isActive() {
        return this.mIsActive;
    }

    private final View $$robo$$android_view_Window$findViewById(int id2) {
        return this.getDecorView().findViewById(id2);
    }

    public abstract void setContentView(int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract View getCurrentFocus();

    public abstract LayoutInflater getLayoutInflater();

    public abstract void setTitle(CharSequence var1);

    @Deprecated
    public abstract void setTitleColor(int var1);

    public abstract void openPanel(int var1, KeyEvent var2);

    public abstract void closePanel(int var1);

    public abstract void togglePanel(int var1, KeyEvent var2);

    public abstract void invalidatePanelMenu(int var1);

    public abstract boolean performPanelShortcut(int var1, int var2, KeyEvent var3, int var4);

    public abstract boolean performPanelIdentifierAction(int var1, int var2, int var3);

    public abstract void closeAllPanels();

    public abstract boolean performContextMenuIdentifierAction(int var1, int var2);

    public abstract void onConfigurationChanged(Configuration var1);

    private final void $$robo$$android_view_Window$setBackgroundDrawableResource(int resid) {
        this.setBackgroundDrawable(this.mContext.getDrawable(resid));
    }

    public abstract void setBackgroundDrawable(Drawable var1);

    public abstract void setFeatureDrawableResource(int var1, int var2);

    public abstract void setFeatureDrawableUri(int var1, Uri var2);

    public abstract void setFeatureDrawable(int var1, Drawable var2);

    public abstract void setFeatureDrawableAlpha(int var1, int var2);

    public abstract void setFeatureInt(int var1, int var2);

    public abstract void takeKeyEvents(boolean var1);

    public abstract boolean superDispatchKeyEvent(KeyEvent var1);

    public abstract boolean superDispatchKeyShortcutEvent(KeyEvent var1);

    public abstract boolean superDispatchTouchEvent(MotionEvent var1);

    public abstract boolean superDispatchTrackballEvent(MotionEvent var1);

    public abstract boolean superDispatchGenericMotionEvent(MotionEvent var1);

    public abstract View getDecorView();

    public abstract View peekDecorView();

    public abstract Bundle saveHierarchyState();

    public abstract void restoreHierarchyState(Bundle var1);

    protected abstract void onActive();

    private final int $$robo$$android_view_Window$getFeatures() {
        return this.mFeatures;
    }

    private final boolean $$robo$$android_view_Window$hasFeature(int feature) {
        return (this.getFeatures() & 1 << feature) != 0;
    }

    private final int $$robo$$android_view_Window$getLocalFeatures() {
        return this.mLocalFeatures;
    }

    private final void $$robo$$android_view_Window$setDefaultWindowFormat(int format) {
        this.mDefaultWindowFormat = format;
        if (!this.mHaveWindowFormat) {
            WindowManager.LayoutParams attrs = this.getAttributes();
            attrs.format = format;
            this.dispatchWindowAttributesChanged(attrs);
        }
    }

    private final boolean $$robo$$android_view_Window$haveDimAmount() {
        return this.mHaveDimAmount;
    }

    public abstract void setChildDrawable(int var1, Drawable var2);

    public abstract void setChildInt(int var1, int var2);

    public abstract boolean isShortcutKey(int var1, KeyEvent var2);

    public abstract void setVolumeControlStream(int var1);

    public abstract int getVolumeControlStream();

    private final void $$robo$$android_view_Window$setMediaController(MediaController controller) {
    }

    private final MediaController $$robo$$android_view_Window$getMediaController() {
        return null;
    }

    private final void $$robo$$android_view_Window$setUiOptions(int uiOptions) {
    }

    private final void $$robo$$android_view_Window$setUiOptions(int uiOptions, int mask) {
    }

    private final void $$robo$$android_view_Window$setIcon(int resId) {
    }

    private final void $$robo$$android_view_Window$setDefaultIcon(int resId) {
    }

    private final void $$robo$$android_view_Window$setLogo(int resId) {
    }

    private final void $$robo$$android_view_Window$setDefaultLogo(int resId) {
    }

    private final void $$robo$$android_view_Window$setLocalFocus(boolean hasFocus, boolean inTouchMode) {
    }

    private final void $$robo$$android_view_Window$injectInputEvent(InputEvent event) {
    }

    private final TransitionManager $$robo$$android_view_Window$getTransitionManager() {
        return null;
    }

    private final void $$robo$$android_view_Window$setTransitionManager(TransitionManager tm) {
        throw new UnsupportedOperationException();
    }

    private final Scene $$robo$$android_view_Window$getContentScene() {
        return null;
    }

    private final void $$robo$$android_view_Window$setEnterTransition(Transition transition2) {
    }

    private final void $$robo$$android_view_Window$setReturnTransition(Transition transition2) {
    }

    private final void $$robo$$android_view_Window$setExitTransition(Transition transition2) {
    }

    private final void $$robo$$android_view_Window$setReenterTransition(Transition transition2) {
    }

    private final Transition $$robo$$android_view_Window$getEnterTransition() {
        return null;
    }

    private final Transition $$robo$$android_view_Window$getReturnTransition() {
        return null;
    }

    private final Transition $$robo$$android_view_Window$getExitTransition() {
        return null;
    }

    private final Transition $$robo$$android_view_Window$getReenterTransition() {
        return null;
    }

    private final void $$robo$$android_view_Window$setSharedElementEnterTransition(Transition transition2) {
    }

    private final void $$robo$$android_view_Window$setSharedElementReturnTransition(Transition transition2) {
    }

    private final Transition $$robo$$android_view_Window$getSharedElementEnterTransition() {
        return null;
    }

    private final Transition $$robo$$android_view_Window$getSharedElementReturnTransition() {
        return null;
    }

    private final void $$robo$$android_view_Window$setSharedElementExitTransition(Transition transition2) {
    }

    private final void $$robo$$android_view_Window$setSharedElementReenterTransition(Transition transition2) {
    }

    private final Transition $$robo$$android_view_Window$getSharedElementExitTransition() {
        return null;
    }

    private final Transition $$robo$$android_view_Window$getSharedElementReenterTransition() {
        return null;
    }

    private final void $$robo$$android_view_Window$setAllowEnterTransitionOverlap(boolean allow) {
    }

    private final boolean $$robo$$android_view_Window$getAllowEnterTransitionOverlap() {
        return true;
    }

    private final void $$robo$$android_view_Window$setAllowReturnTransitionOverlap(boolean allow) {
    }

    private final void $$robo$$android_view_Window$setAllowExitTransitionOverlap(boolean allow) {
        this.setAllowReturnTransitionOverlap(allow);
    }

    private final boolean $$robo$$android_view_Window$getAllowReturnTransitionOverlap() {
        return true;
    }

    private final boolean $$robo$$android_view_Window$getAllowExitTransitionOverlap() {
        return this.getAllowReturnTransitionOverlap();
    }

    private final long $$robo$$android_view_Window$getTransitionBackgroundFadeDuration() {
        return 0L;
    }

    private final void $$robo$$android_view_Window$setTransitionBackgroundFadeDuration(long fadeDurationMillis) {
    }

    private final boolean $$robo$$android_view_Window$getSharedElementsUseOverlay() {
        return true;
    }

    private final void $$robo$$android_view_Window$setSharedElementsUseOverlay(boolean sharedElementsUseOverlay) {
    }

    public abstract int getStatusBarColor();

    public abstract void setStatusBarColor(int var1);

    public abstract int getNavigationBarColor();

    public abstract void setNavigationBarColor(int var1);

    private void __constructor__(Context context) {
        this.$$robo$$android_view_Window$__constructor__(context);
    }

    public Window(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Window$__constructor__(android.content.Context ), 0, this, context);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_view_Window$getContext(), 0, this);
    }

    public TypedArray getWindowStyle() {
        return InvokeDynamicSupport.bootstrap("getWindowStyle", $$robo$$android_view_Window$getWindowStyle(), 0, this);
    }

    public void setContainer(Window window) {
        InvokeDynamicSupport.bootstrap("setContainer", $$robo$$android_view_Window$setContainer(android.view.Window ), 0, this, window);
    }

    public Window getContainer() {
        return InvokeDynamicSupport.bootstrap("getContainer", $$robo$$android_view_Window$getContainer(), 0, this);
    }

    public boolean hasChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasChildren", $$robo$$android_view_Window$hasChildren(), 0, this);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_Window$destroy(), 0, this);
    }

    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_view_Window$isDestroyed(), 0, this);
    }

    public void setWindowManager(WindowManager windowManager, IBinder iBinder, String string2) {
        InvokeDynamicSupport.bootstrap("setWindowManager", $$robo$$android_view_Window$setWindowManager(android.view.WindowManager android.os.IBinder java.lang.String ), 0, this, windowManager, iBinder, string2);
    }

    public void setWindowManager(WindowManager windowManager, IBinder iBinder, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setWindowManager", $$robo$$android_view_Window$setWindowManager(android.view.WindowManager android.os.IBinder java.lang.String boolean ), 0, this, windowManager, iBinder, string2, bl);
    }

    void adjustLayoutParamsForSubWindow(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("adjustLayoutParamsForSubWindow", $$robo$$android_view_Window$adjustLayoutParamsForSubWindow(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    public WindowManager getWindowManager() {
        return InvokeDynamicSupport.bootstrap("getWindowManager", $$robo$$android_view_Window$getWindowManager(), 0, this);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_view_Window$setCallback(android.view.Window$Callback ), 0, this, callback);
    }

    public Callback getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_view_Window$getCallback(), 0, this);
    }

    public void setOnWindowDismissedCallback(OnWindowDismissedCallback onWindowDismissedCallback) {
        InvokeDynamicSupport.bootstrap("setOnWindowDismissedCallback", $$robo$$android_view_Window$setOnWindowDismissedCallback(android.view.Window$OnWindowDismissedCallback ), 0, this, onWindowDismissedCallback);
    }

    public void dispatchOnWindowDismissed() {
        InvokeDynamicSupport.bootstrap("dispatchOnWindowDismissed", $$robo$$android_view_Window$dispatchOnWindowDismissed(), 0, this);
    }

    public void setLayout(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLayout", $$robo$$android_view_Window$setLayout(int int ), 0, this, n, n2);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_view_Window$setGravity(int ), 0, this, n);
    }

    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$android_view_Window$setType(int ), 0, this, n);
    }

    public void setFormat(int n) {
        InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_view_Window$setFormat(int ), 0, this, n);
    }

    public void setWindowAnimations(int n) {
        InvokeDynamicSupport.bootstrap("setWindowAnimations", $$robo$$android_view_Window$setWindowAnimations(int ), 0, this, n);
    }

    public void setSoftInputMode(int n) {
        InvokeDynamicSupport.bootstrap("setSoftInputMode", $$robo$$android_view_Window$setSoftInputMode(int ), 0, this, n);
    }

    public void addFlags(int n) {
        InvokeDynamicSupport.bootstrap("addFlags", $$robo$$android_view_Window$addFlags(int ), 0, this, n);
    }

    public void addPrivateFlags(int n) {
        InvokeDynamicSupport.bootstrap("addPrivateFlags", $$robo$$android_view_Window$addPrivateFlags(int ), 0, this, n);
    }

    public void clearFlags(int n) {
        InvokeDynamicSupport.bootstrap("clearFlags", $$robo$$android_view_Window$clearFlags(int ), 0, this, n);
    }

    public void setFlags(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_view_Window$setFlags(int int ), 0, this, n, n2);
    }

    private void setPrivateFlags(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPrivateFlags", $$robo$$android_view_Window$setPrivateFlags(int int ), 0, this, n, n2);
    }

    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("dispatchWindowAttributesChanged", $$robo$$android_view_Window$dispatchWindowAttributesChanged(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    public void setDimAmount(float f) {
        InvokeDynamicSupport.bootstrap("setDimAmount", $$robo$$android_view_Window$setDimAmount(float ), 0, this, f);
    }

    public void setAttributes(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setAttributes", $$robo$$android_view_Window$setAttributes(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    public WindowManager.LayoutParams getAttributes() {
        return InvokeDynamicSupport.bootstrap("getAttributes", $$robo$$android_view_Window$getAttributes(), 0, this);
    }

    protected int getForcedWindowFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getForcedWindowFlags", $$robo$$android_view_Window$getForcedWindowFlags(), 0, this);
    }

    protected boolean hasSoftInputMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSoftInputMode", $$robo$$android_view_Window$hasSoftInputMode(), 0, this);
    }

    public void setCloseOnTouchOutside(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCloseOnTouchOutside", $$robo$$android_view_Window$setCloseOnTouchOutside(boolean ), 0, this, bl);
    }

    public void setCloseOnTouchOutsideIfNotSet(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCloseOnTouchOutsideIfNotSet", $$robo$$android_view_Window$setCloseOnTouchOutsideIfNotSet(boolean ), 0, this, bl);
    }

    public boolean shouldCloseOnTouch(Context context, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldCloseOnTouch", $$robo$$android_view_Window$shouldCloseOnTouch(android.content.Context android.view.MotionEvent ), 0, this, context, motionEvent);
    }

    private boolean isOutOfBounds(Context context, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutOfBounds", $$robo$$android_view_Window$isOutOfBounds(android.content.Context android.view.MotionEvent ), 0, this, context, motionEvent);
    }

    public boolean requestFeature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestFeature", $$robo$$android_view_Window$requestFeature(int ), 0, this, n);
    }

    protected void removeFeature(int n) {
        InvokeDynamicSupport.bootstrap("removeFeature", $$robo$$android_view_Window$removeFeature(int ), 0, this, n);
    }

    public void makeActive() {
        InvokeDynamicSupport.bootstrap("makeActive", $$robo$$android_view_Window$makeActive(), 0, this);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_view_Window$isActive(), 0, this);
    }

    public View findViewById(int n) {
        return InvokeDynamicSupport.bootstrap("findViewById", $$robo$$android_view_Window$findViewById(int ), 0, this, n);
    }

    public void setBackgroundDrawableResource(int n) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawableResource", $$robo$$android_view_Window$setBackgroundDrawableResource(int ), 0, this, n);
    }

    protected int getFeatures() {
        return (int)InvokeDynamicSupport.bootstrap("getFeatures", $$robo$$android_view_Window$getFeatures(), 0, this);
    }

    public boolean hasFeature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFeature", $$robo$$android_view_Window$hasFeature(int ), 0, this, n);
    }

    protected int getLocalFeatures() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalFeatures", $$robo$$android_view_Window$getLocalFeatures(), 0, this);
    }

    protected void setDefaultWindowFormat(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultWindowFormat", $$robo$$android_view_Window$setDefaultWindowFormat(int ), 0, this, n);
    }

    protected boolean haveDimAmount() {
        return (boolean)InvokeDynamicSupport.bootstrap("haveDimAmount", $$robo$$android_view_Window$haveDimAmount(), 0, this);
    }

    public void setMediaController(MediaController mediaController) {
        InvokeDynamicSupport.bootstrap("setMediaController", $$robo$$android_view_Window$setMediaController(android.media.session.MediaController ), 0, this, mediaController);
    }

    public MediaController getMediaController() {
        return InvokeDynamicSupport.bootstrap("getMediaController", $$robo$$android_view_Window$getMediaController(), 0, this);
    }

    public void setUiOptions(int n) {
        InvokeDynamicSupport.bootstrap("setUiOptions", $$robo$$android_view_Window$setUiOptions(int ), 0, this, n);
    }

    public void setUiOptions(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUiOptions", $$robo$$android_view_Window$setUiOptions(int int ), 0, this, n, n2);
    }

    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_view_Window$setIcon(int ), 0, this, n);
    }

    public void setDefaultIcon(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultIcon", $$robo$$android_view_Window$setDefaultIcon(int ), 0, this, n);
    }

    public void setLogo(int n) {
        InvokeDynamicSupport.bootstrap("setLogo", $$robo$$android_view_Window$setLogo(int ), 0, this, n);
    }

    public void setDefaultLogo(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultLogo", $$robo$$android_view_Window$setDefaultLogo(int ), 0, this, n);
    }

    public void setLocalFocus(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setLocalFocus", $$robo$$android_view_Window$setLocalFocus(boolean boolean ), 0, this, bl, bl2);
    }

    public void injectInputEvent(InputEvent inputEvent) {
        InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_view_Window$injectInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    public TransitionManager getTransitionManager() {
        return InvokeDynamicSupport.bootstrap("getTransitionManager", $$robo$$android_view_Window$getTransitionManager(), 0, this);
    }

    public void setTransitionManager(TransitionManager transitionManager) {
        InvokeDynamicSupport.bootstrap("setTransitionManager", $$robo$$android_view_Window$setTransitionManager(android.transition.TransitionManager ), 0, this, transitionManager);
    }

    public Scene getContentScene() {
        return InvokeDynamicSupport.bootstrap("getContentScene", $$robo$$android_view_Window$getContentScene(), 0, this);
    }

    public void setEnterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setEnterTransition", $$robo$$android_view_Window$setEnterTransition(android.transition.Transition ), 0, this, transition2);
    }

    public void setReturnTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setReturnTransition", $$robo$$android_view_Window$setReturnTransition(android.transition.Transition ), 0, this, transition2);
    }

    public void setExitTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setExitTransition", $$robo$$android_view_Window$setExitTransition(android.transition.Transition ), 0, this, transition2);
    }

    public void setReenterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setReenterTransition", $$robo$$android_view_Window$setReenterTransition(android.transition.Transition ), 0, this, transition2);
    }

    public Transition getEnterTransition() {
        return InvokeDynamicSupport.bootstrap("getEnterTransition", $$robo$$android_view_Window$getEnterTransition(), 0, this);
    }

    public Transition getReturnTransition() {
        return InvokeDynamicSupport.bootstrap("getReturnTransition", $$robo$$android_view_Window$getReturnTransition(), 0, this);
    }

    public Transition getExitTransition() {
        return InvokeDynamicSupport.bootstrap("getExitTransition", $$robo$$android_view_Window$getExitTransition(), 0, this);
    }

    public Transition getReenterTransition() {
        return InvokeDynamicSupport.bootstrap("getReenterTransition", $$robo$$android_view_Window$getReenterTransition(), 0, this);
    }

    public void setSharedElementEnterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementEnterTransition", $$robo$$android_view_Window$setSharedElementEnterTransition(android.transition.Transition ), 0, this, transition2);
    }

    public void setSharedElementReturnTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementReturnTransition", $$robo$$android_view_Window$setSharedElementReturnTransition(android.transition.Transition ), 0, this, transition2);
    }

    public Transition getSharedElementEnterTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementEnterTransition", $$robo$$android_view_Window$getSharedElementEnterTransition(), 0, this);
    }

    public Transition getSharedElementReturnTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementReturnTransition", $$robo$$android_view_Window$getSharedElementReturnTransition(), 0, this);
    }

    public void setSharedElementExitTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementExitTransition", $$robo$$android_view_Window$setSharedElementExitTransition(android.transition.Transition ), 0, this, transition2);
    }

    public void setSharedElementReenterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementReenterTransition", $$robo$$android_view_Window$setSharedElementReenterTransition(android.transition.Transition ), 0, this, transition2);
    }

    public Transition getSharedElementExitTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementExitTransition", $$robo$$android_view_Window$getSharedElementExitTransition(), 0, this);
    }

    public Transition getSharedElementReenterTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementReenterTransition", $$robo$$android_view_Window$getSharedElementReenterTransition(), 0, this);
    }

    public void setAllowEnterTransitionOverlap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowEnterTransitionOverlap", $$robo$$android_view_Window$setAllowEnterTransitionOverlap(boolean ), 0, this, bl);
    }

    public boolean getAllowEnterTransitionOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowEnterTransitionOverlap", $$robo$$android_view_Window$getAllowEnterTransitionOverlap(), 0, this);
    }

    public void setAllowReturnTransitionOverlap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowReturnTransitionOverlap", $$robo$$android_view_Window$setAllowReturnTransitionOverlap(boolean ), 0, this, bl);
    }

    public void setAllowExitTransitionOverlap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowExitTransitionOverlap", $$robo$$android_view_Window$setAllowExitTransitionOverlap(boolean ), 0, this, bl);
    }

    public boolean getAllowReturnTransitionOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowReturnTransitionOverlap", $$robo$$android_view_Window$getAllowReturnTransitionOverlap(), 0, this);
    }

    public boolean getAllowExitTransitionOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowExitTransitionOverlap", $$robo$$android_view_Window$getAllowExitTransitionOverlap(), 0, this);
    }

    public long getTransitionBackgroundFadeDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTransitionBackgroundFadeDuration", $$robo$$android_view_Window$getTransitionBackgroundFadeDuration(), 0, this);
    }

    public void setTransitionBackgroundFadeDuration(long l) {
        InvokeDynamicSupport.bootstrap("setTransitionBackgroundFadeDuration", $$robo$$android_view_Window$setTransitionBackgroundFadeDuration(long ), 0, this, l);
    }

    public boolean getSharedElementsUseOverlay() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSharedElementsUseOverlay", $$robo$$android_view_Window$getSharedElementsUseOverlay(), 0, this);
    }

    public void setSharedElementsUseOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSharedElementsUseOverlay", $$robo$$android_view_Window$setSharedElementsUseOverlay(boolean ), 0, this, bl);
    }

    public /* synthetic */ Window() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Window)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnWindowDismissedCallback
    extends InstrumentedInterface {
        public void onWindowDismissed();
    }

    public static interface Callback
    extends InstrumentedInterface {
        public boolean dispatchKeyEvent(KeyEvent var1);

        public boolean dispatchKeyShortcutEvent(KeyEvent var1);

        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean dispatchTrackballEvent(MotionEvent var1);

        public boolean dispatchGenericMotionEvent(MotionEvent var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public View onCreatePanelView(int var1);

        public boolean onCreatePanelMenu(int var1, Menu var2);

        public boolean onPreparePanel(int var1, View var2, Menu var3);

        public boolean onMenuOpened(int var1, Menu var2);

        public boolean onMenuItemSelected(int var1, MenuItem var2);

        public void onWindowAttributesChanged(WindowManager.LayoutParams var1);

        public void onContentChanged();

        public void onWindowFocusChanged(boolean var1);

        public void onAttachedToWindow();

        public void onDetachedFromWindow();

        public void onPanelClosed(int var1, Menu var2);

        public boolean onSearchRequested();

        public ActionMode onWindowStartingActionMode(ActionMode.Callback var1);

        public void onActionModeStarted(ActionMode var1);

        public void onActionModeFinished(ActionMode var1);
    }
}

