/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityCache
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "AccessibilityCache";
    private static boolean DEBUG = false;
    private static boolean CHECK_INTEGRITY;
    private Object mLock;
    private SparseArray<AccessibilityWindowInfo> mWindowCache;
    private SparseArray<LongSparseArray<AccessibilityNodeInfo>> mNodeCache;
    private SparseArray<AccessibilityWindowInfo> mTempWindowArray;

    private void $$robo$$android_view_accessibility_AccessibilityCache$__constructor__() {
        this.mLock = new Object();
        this.mWindowCache = new SparseArray();
        this.mNodeCache = new SparseArray();
        this.mTempWindowArray = new SparseArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityCache$addWindow(AccessibilityWindowInfo window) {
        Object object = this.mLock;
        synchronized (object) {
            int windowId = window.getId();
            AccessibilityWindowInfo oldWindow = this.mWindowCache.get(windowId);
            if (oldWindow != null) {
                oldWindow.recycle();
            }
            this.mWindowCache.put(windowId, AccessibilityWindowInfo.obtain(window));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityCache$onAccessibilityEvent(AccessibilityEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 4: 
                case 8: 
                case 16: 
                case 8192: 
                case 32768: 
                case 65536: {
                    this.refreshCachedNodeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 2048: {
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        int windowId = event.getWindowId();
                        long sourceId = event.getSourceNodeId();
                        if ((event.getContentChangeTypes() & 1) != 0) {
                            this.clearSubTreeLocked(windowId, sourceId);
                        } else {
                            this.refreshCachedNodeLocked(windowId, sourceId);
                        }
                        break;
                    }
                }
                case 4096: {
                    this.clearSubTreeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 32: 
                case 0x400000: {
                    this.clear();
                }
            }
        }
        if (CHECK_INTEGRITY) {
            this.checkIntegrity();
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityCache$refreshCachedNodeLocked(int windowId, long sourceId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes == null) {
            return;
        }
        AccessibilityNodeInfo cachedInfo = nodes.get(sourceId);
        if (cachedInfo == null) {
            return;
        }
        if (cachedInfo.refresh(true)) {
            return;
        }
        this.clearSubTreeLocked(windowId, sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityCache$getNode(int windowId, long accessibilityNodeId) {
        Object object = this.mLock;
        synchronized (object) {
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                return null;
            }
            AccessibilityNodeInfo info = nodes.get(accessibilityNodeId);
            if (info != null) {
                info = AccessibilityNodeInfo.obtain(info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityWindowInfo> $$robo$$android_view_accessibility_AccessibilityCache$getWindows() {
        Object object = this.mLock;
        synchronized (object) {
            int windowCount = this.mWindowCache.size();
            if (windowCount > 0) {
                SparseArray<AccessibilityWindowInfo> sortedWindows = this.mTempWindowArray;
                sortedWindows.clear();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = this.mWindowCache.valueAt(i);
                    sortedWindows.put(window.getLayer(), window);
                }
                ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>(windowCount);
                for (int i = windowCount - 1; i >= 0; --i) {
                    AccessibilityWindowInfo window = sortedWindows.valueAt(i);
                    windows.add(AccessibilityWindowInfo.obtain(window));
                    sortedWindows.removeAt(i);
                }
                return windows;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityCache$getWindow(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityWindowInfo window = this.mWindowCache.get(windowId);
            if (window != null) {
                return AccessibilityWindowInfo.obtain(window);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityCache$add(AccessibilityNodeInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            long sourceId;
            AccessibilityNodeInfo oldInfo;
            int windowId = info.getWindowId();
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                nodes = new LongSparseArray();
                this.mNodeCache.put(windowId, nodes);
            }
            if ((oldInfo = nodes.get(sourceId = info.getSourceNodeId())) != null) {
                LongArray newChildrenIds = info.getChildNodeIds();
                int oldChildCount = oldInfo.getChildCount();
                for (int i = 0; i < oldChildCount; ++i) {
                    long oldChildId = oldInfo.getChildId(i);
                    if (newChildrenIds != null && newChildrenIds.indexOf(oldChildId) >= 0) continue;
                    this.clearSubTreeLocked(windowId, oldChildId);
                }
                long oldParentId = oldInfo.getParentNodeId();
                if (info.getParentNodeId() != oldParentId) {
                    this.clearSubTreeLocked(windowId, oldParentId);
                }
            }
            AccessibilityNodeInfo clone = AccessibilityNodeInfo.obtain(info);
            nodes.put(sourceId, clone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityCache$clear() {
        Object object = this.mLock;
        synchronized (object) {
            int windowCount = this.mWindowCache.size();
            for (int i = windowCount - 1; i >= 0; --i) {
                AccessibilityWindowInfo window = this.mWindowCache.valueAt(i);
                window.recycle();
                this.mWindowCache.removeAt(i);
            }
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = 0; i < nodesForWindowCount; ++i) {
                int windowId = this.mNodeCache.keyAt(i);
                this.clearNodesForWindowLocked(windowId);
            }
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityCache$clearNodesForWindowLocked(int windowId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes == null) {
            return;
        }
        int nodeCount = nodes.size();
        for (int i = nodeCount - 1; i >= 0; --i) {
            AccessibilityNodeInfo info = nodes.valueAt(i);
            nodes.removeAt(i);
            info.recycle();
        }
        this.mNodeCache.remove(windowId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityCache$clearSubTreeLocked(int windowId, long rootNodeId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes != null) {
            this.clearSubTreeRecursiveLocked(nodes, rootNodeId);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityCache$clearSubTreeRecursiveLocked(LongSparseArray<AccessibilityNodeInfo> nodes, long rootNodeId) {
        AccessibilityNodeInfo current = nodes.get(rootNodeId);
        if (current == null) {
            return;
        }
        nodes.remove(rootNodeId);
        int childCount = current.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            long childNodeId = current.getChildId(i);
            this.clearSubTreeRecursiveLocked(nodes, childNodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityCache$checkIntegrity() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWindowCache.size() <= 0 && this.mNodeCache.size() == 0) {
                return;
            }
            AccessibilityWindowInfo focusedWindow = null;
            AccessibilityWindowInfo activeWindow = null;
            int windowCount = this.mWindowCache.size();
            for (int i = 0; i < windowCount; ++i) {
                AccessibilityWindowInfo window = this.mWindowCache.valueAt(i);
                if (window.isActive()) {
                    if (activeWindow != null) {
                        Log.e("AccessibilityCache", "Duplicate active window:" + window);
                    } else {
                        activeWindow = window;
                    }
                }
                if (!window.isFocused()) continue;
                if (focusedWindow != null) {
                    Log.e("AccessibilityCache", "Duplicate focused window:" + window);
                    continue;
                }
                focusedWindow = window;
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = 0; i < nodesForWindowCount; ++i) {
                LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.valueAt(i);
                if (nodes.size() <= 0) continue;
                ArraySet<AccessibilityNodeInfo> seen = new ArraySet<AccessibilityNodeInfo>();
                int windowId = this.mNodeCache.keyAt(i);
                int nodeCount = nodes.size();
                for (int j = 0; j < nodeCount; ++j) {
                    AccessibilityNodeInfo nodeParent;
                    AccessibilityNodeInfo node = nodes.valueAt(j);
                    if (!seen.add(node)) {
                        Log.e("AccessibilityCache", "Duplicate node: " + node + " in window:" + windowId);
                        continue;
                    }
                    if (node.isAccessibilityFocused()) {
                        if (accessFocus != null) {
                            Log.e("AccessibilityCache", "Duplicate accessibility focus:" + node + " in window:" + windowId);
                        } else {
                            accessFocus = node;
                        }
                    }
                    if (node.isFocused()) {
                        if (inputFocus != null) {
                            Log.e("AccessibilityCache", "Duplicate input focus: " + node + " in window:" + windowId);
                        } else {
                            inputFocus = node;
                        }
                    }
                    if ((nodeParent = nodes.get(node.getParentNodeId())) != null) {
                        boolean childOfItsParent = false;
                        int childCount = nodeParent.getChildCount();
                        for (int k = 0; k < childCount; ++k) {
                            AccessibilityNodeInfo child = nodes.get(nodeParent.getChildId(k));
                            if (child != node) continue;
                            childOfItsParent = true;
                            break;
                        }
                        if (!childOfItsParent) {
                            Log.e("AccessibilityCache", "Invalid parent-child relation between parent: " + nodeParent + " and child: " + node);
                        }
                    }
                    int childCount = node.getChildCount();
                    for (int k = 0; k < childCount; ++k) {
                        AccessibilityNodeInfo parent;
                        AccessibilityNodeInfo child = nodes.get(node.getChildId(k));
                        if (child == null || (parent = nodes.get(child.getParentNodeId())) == node) continue;
                        Log.e("AccessibilityCache", "Invalid child-parent relation between child: " + node + " and parent: " + nodeParent);
                    }
                }
            }
        }
    }

    static void __staticInitializer__() {
        CHECK_INTEGRITY = "eng".equals(Build.TYPE);
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityCache$__constructor__();
    }

    AccessibilityCache() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityCache$__constructor__(), 0, this);
    }

    public void addWindow(AccessibilityWindowInfo accessibilityWindowInfo) {
        InvokeDynamicSupport.bootstrap("addWindow", $$robo$$android_view_accessibility_AccessibilityCache$addWindow(android.view.accessibility.AccessibilityWindowInfo ), 0, this, accessibilityWindowInfo);
    }

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_view_accessibility_AccessibilityCache$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private void refreshCachedNodeLocked(int n, long l) {
        InvokeDynamicSupport.bootstrap("refreshCachedNodeLocked", $$robo$$android_view_accessibility_AccessibilityCache$refreshCachedNodeLocked(int long ), 0, this, n, l);
    }

    public AccessibilityNodeInfo getNode(int n, long l) {
        return InvokeDynamicSupport.bootstrap("getNode", $$robo$$android_view_accessibility_AccessibilityCache$getNode(int long ), 0, this, n, l);
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return InvokeDynamicSupport.bootstrap("getWindows", $$robo$$android_view_accessibility_AccessibilityCache$getWindows(), 0, this);
    }

    public AccessibilityWindowInfo getWindow(int n) {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_view_accessibility_AccessibilityCache$getWindow(int ), 0, this, n);
    }

    public void add(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_view_accessibility_AccessibilityCache$add(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityCache$clear(), 0, this);
    }

    private void clearNodesForWindowLocked(int n) {
        InvokeDynamicSupport.bootstrap("clearNodesForWindowLocked", $$robo$$android_view_accessibility_AccessibilityCache$clearNodesForWindowLocked(int ), 0, this, n);
    }

    private void clearSubTreeLocked(int n, long l) {
        InvokeDynamicSupport.bootstrap("clearSubTreeLocked", $$robo$$android_view_accessibility_AccessibilityCache$clearSubTreeLocked(int long ), 0, this, n, l);
    }

    private void clearSubTreeRecursiveLocked(LongSparseArray<AccessibilityNodeInfo> longSparseArray, long l) {
        InvokeDynamicSupport.bootstrap("clearSubTreeRecursiveLocked", $$robo$$android_view_accessibility_AccessibilityCache$clearSubTreeRecursiveLocked(android.util.LongSparseArray<android.view.accessibility.AccessibilityNodeInfo> long ), 0, this, longSparseArray, l);
    }

    public void checkIntegrity() {
        InvokeDynamicSupport.bootstrap("checkIntegrity", $$robo$$android_view_accessibility_AccessibilityCache$checkIntegrity(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityCache.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

