/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "AccessibilityManager";
    public static int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static int DALTONIZER_DISABLED = -1;
    public static int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    static Object sInstanceSync;
    private static AccessibilityManager sInstance;
    private Object mLock;
    private IAccessibilityManager mService;
    int mUserId;
    Handler mHandler;
    boolean mIsEnabled;
    boolean mIsTouchExplorationEnabled;
    boolean mIsHighTextContrastEnabled;
    private CopyOnWriteArrayList<AccessibilityStateChangeListener> mAccessibilityStateChangeListeners;
    private CopyOnWriteArrayList<TouchExplorationStateChangeListener> mTouchExplorationStateChangeListeners;
    private CopyOnWriteArrayList<HighTextContrastChangeListener> mHighTextContrastStateChangeListeners;
    private IAccessibilityManagerClient.Stub mClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AccessibilityManager $$robo$$android_view_accessibility_AccessibilityManager$getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : UserHandle.myUserId();
                IBinder iBinder = ServiceManager.getService("accessibility");
                IAccessibilityManager service = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
                sInstance = new AccessibilityManager(context, service, userId);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(Context context, IAccessibilityManager service, int userId) {
        this.mLock = new Object();
        this.mAccessibilityStateChangeListeners = new CopyOnWriteArrayList();
        this.mTouchExplorationStateChangeListeners = new CopyOnWriteArrayList();
        this.mHighTextContrastStateChangeListeners = new CopyOnWriteArrayList();
        this.mClient = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AccessibilityManager this$0;

            private void $$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(AccessibilityManager accessibilityManager) {
            }

            private final void $$robo$$android_view_accessibility_AccessibilityManager_1$setState(int state) {
                this.this$0.mHandler.obtainMessage(4, state, 0).sendToTarget();
            }

            private void __constructor__(AccessibilityManager accessibilityManager) {
                this.$$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(accessibilityManager);
            }
            {
                this.this$0 = accessibilityManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(android.view.accessibility.AccessibilityManager ), 0, this, accessibilityManager);
            }

            @Override
            public void setState(int n) {
                InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_accessibility_AccessibilityManager_1$setState(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new MyHandler(this, context.getMainLooper());
        this.mService = service;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked();
        }
    }

    private final IAccessibilityManagerClient $$robo$$android_view_accessibility_AccessibilityManager$getClient() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighTextContrastEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                throw new IllegalStateException("Accessibility off. Did you forget to check that?");
            }
            userId = this.mUserId;
        }
        boolean doRecycle = false;
        try {
            event.setEventTime(SystemClock.uptimeMillis());
            long identityToken = Binder.clearCallingIdentity();
            doRecycle = service.sendAccessibilityEvent(event, userId);
            Binder.restoreCallingIdentity(identityToken);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error during sending " + event + " ", re);
        }
        finally {
            if (doRecycle) {
                event.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                throw new IllegalStateException("Accessibility off. Did you forget to check that?");
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    private final List<ServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.add(listener);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.remove(listener);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.add(listener);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.remove(listener);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$addHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        return this.mHighTextContrastStateChangeListeners.add(listener);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$removeHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        return this.mHighTextContrastStateChangeListeners.remove(listener);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean wasEnabled = this.mIsEnabled;
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighTextContrastEnabled = highTextContrastEnabled;
        if (wasEnabled != enabled) {
            this.mHandler.sendEmptyMessage(1);
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.mHandler.sendEmptyMessage(2);
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.mHandler.sendEmptyMessage(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, connection, userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while removing an accessibility interaction connection. ", re);
        }
    }

    private final IAccessibilityManager $$robo$$android_view_accessibility_AccessibilityManager$getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked();
        }
        return this.mService;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$tryConnectToServiceLocked() {
        IBinder iBinder = ServiceManager.getService("accessibility");
        if (iBinder == null) {
            return;
        }
        IAccessibilityManager service = IAccessibilityManager.Stub.asInterface(iBinder);
        try {
            int stateFlags = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(stateFlags);
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyAccessibilityStateChanged() {
        boolean isEnabled;
        Object object = this.mLock;
        synchronized (object) {
            isEnabled = this.mIsEnabled;
        }
        int listenerCount = this.mAccessibilityStateChangeListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            this.mAccessibilityStateChangeListeners.get(i).onAccessibilityStateChanged(isEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyTouchExplorationStateChanged() {
        boolean isTouchExplorationEnabled;
        Object object = this.mLock;
        synchronized (object) {
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        }
        int listenerCount = this.mTouchExplorationStateChangeListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            this.mTouchExplorationStateChangeListeners.get(i).onTouchExplorationStateChanged(isTouchExplorationEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyHighTextContrastStateChanged() {
        boolean isHighTextContrastEnabled;
        Object object = this.mLock;
        synchronized (object) {
            isHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        }
        int listenerCount = this.mHighTextContrastStateChangeListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            this.mHighTextContrastStateChangeListeners.get(i).onHighTextContrastStateChanged(isHighTextContrastEnabled);
        }
    }

    static void __staticInitializer__() {
        sInstanceSync = new Object();
    }

    public static AccessibilityManager getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_accessibility_AccessibilityManager$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$$android_view_accessibility_AccessibilityManager$__constructor__(context, iAccessibilityManager, n);
    }

    public AccessibilityManager(Context context, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(android.content.Context android.view.accessibility.IAccessibilityManager int ), 0, this, context, iAccessibilityManager, n);
    }

    public IAccessibilityManagerClient getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_view_accessibility_AccessibilityManager$getClient(), 0, this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isEnabled(), 0, this);
    }

    public boolean isTouchExplorationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchExplorationEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isTouchExplorationEnabled(), 0, this);
    }

    public boolean isHighTextContrastEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHighTextContrastEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isHighTextContrastEnabled(), 0, this);
    }

    public void sendAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEvent", $$robo$$android_view_accessibility_AccessibilityManager$sendAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    public void interrupt() {
        InvokeDynamicSupport.bootstrap("interrupt", $$robo$$android_view_accessibility_AccessibilityManager$interrupt(), 0, this);
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getAccessibilityServiceList(), 0, this);
    }

    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        return InvokeDynamicSupport.bootstrap("getInstalledAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getInstalledAccessibilityServiceList(), 0, this);
    }

    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getEnabledAccessibilityServiceList(int ), 0, this, n);
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAccessibilityStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener ), 0, this, accessibilityStateChangeListener);
    }

    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAccessibilityStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener ), 0, this, accessibilityStateChangeListener);
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addTouchExplorationStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener ), 0, this, touchExplorationStateChangeListener);
    }

    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeTouchExplorationStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeTouchExplorationStateChangeListener(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener ), 0, this, touchExplorationStateChangeListener);
    }

    public boolean addHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addHighTextContrastStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addHighTextContrastStateChangeListener(android.view.accessibility.AccessibilityManager$HighTextContrastChangeListener ), 0, this, highTextContrastChangeListener);
    }

    public boolean removeHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeHighTextContrastStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeHighTextContrastStateChangeListener(android.view.accessibility.AccessibilityManager$HighTextContrastChangeListener ), 0, this, highTextContrastChangeListener);
    }

    private void setStateLocked(int n) {
        InvokeDynamicSupport.bootstrap("setStateLocked", $$robo$$android_view_accessibility_AccessibilityManager$setStateLocked(int ), 0, this, n);
    }

    public int addAccessibilityInteractionConnection(IWindow iWindow, IAccessibilityInteractionConnection iAccessibilityInteractionConnection) {
        return (int)InvokeDynamicSupport.bootstrap("addAccessibilityInteractionConnection", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityInteractionConnection(android.view.IWindow android.view.accessibility.IAccessibilityInteractionConnection ), 0, this, iWindow, iAccessibilityInteractionConnection);
    }

    public void removeAccessibilityInteractionConnection(IWindow iWindow) {
        InvokeDynamicSupport.bootstrap("removeAccessibilityInteractionConnection", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityInteractionConnection(android.view.IWindow ), 0, this, iWindow);
    }

    private IAccessibilityManager getServiceLocked() {
        return InvokeDynamicSupport.bootstrap("getServiceLocked", $$robo$$android_view_accessibility_AccessibilityManager$getServiceLocked(), 0, this);
    }

    private void tryConnectToServiceLocked() {
        InvokeDynamicSupport.bootstrap("tryConnectToServiceLocked", $$robo$$android_view_accessibility_AccessibilityManager$tryConnectToServiceLocked(), 0, this);
    }

    private void handleNotifyAccessibilityStateChanged() {
        InvokeDynamicSupport.bootstrap("handleNotifyAccessibilityStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyAccessibilityStateChanged(), 0, this);
    }

    private void handleNotifyTouchExplorationStateChanged() {
        InvokeDynamicSupport.bootstrap("handleNotifyTouchExplorationStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyTouchExplorationStateChanged(), 0, this);
    }

    private void handleNotifyHighTextContrastStateChanged() {
        InvokeDynamicSupport.bootstrap("handleNotifyHighTextContrastStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$handleNotifyHighTextContrastStateChanged(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityManager.class);
    }

    public /* synthetic */ AccessibilityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MSG_NOTIFY_ACCESSIBILITY_STATE_CHANGED = 1;
        public static int MSG_NOTIFY_EXPLORATION_STATE_CHANGED = 2;
        public static int MSG_NOTIFY_HIGH_TEXT_CONTRAST_STATE_CHANGED = 3;
        public static int MSG_SET_STATE = 4;
        /* synthetic */ AccessibilityManager this$0;

        private void $$robo$$android_view_accessibility_AccessibilityManager_MyHandler$__constructor__(AccessibilityManager accessibilityManager, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_accessibility_AccessibilityManager_MyHandler$handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    this.this$0.handleNotifyAccessibilityStateChanged();
                    break;
                }
                case 2: {
                    this.this$0.handleNotifyTouchExplorationStateChanged();
                    break;
                }
                case 3: {
                    this.this$0.handleNotifyHighTextContrastStateChanged();
                    break;
                }
                case 4: {
                    int state = message.arg1;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.setStateLocked(state);
                        break;
                    }
                }
            }
        }

        private void __constructor__(AccessibilityManager accessibilityManager, Looper looper) {
            this.$$robo$$android_view_accessibility_AccessibilityManager_MyHandler$__constructor__(accessibilityManager, looper);
        }

        public MyHandler(AccessibilityManager accessibilityManager, Looper looper) {
            this.this$0 = accessibilityManager;
            super(looper, null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager_MyHandler$__constructor__(android.view.accessibility.AccessibilityManager android.os.Looper ), 0, this, accessibilityManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_accessibility_AccessibilityManager_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface HighTextContrastChangeListener
    extends InstrumentedInterface {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    public static interface TouchExplorationStateChangeListener
    extends InstrumentedInterface {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener
    extends InstrumentedInterface {
        public void onAccessibilityStateChanged(boolean var1);
    }
}

