/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.LongArray;
import android.util.Pools;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AccessibilityNodeInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    public static int UNDEFINED_CONNECTION_ID = -1;
    public static int UNDEFINED_SELECTION_INDEX = -1;
    public static int UNDEFINED_ITEM_ID = Integer.MAX_VALUE;
    public static long ROOT_NODE_ID;
    public static int ACTIVE_WINDOW_ID = Integer.MAX_VALUE;
    public static int ANY_WINDOW_ID = -2;
    public static int FLAG_PREFETCH_PREDECESSORS = 1;
    public static int FLAG_PREFETCH_SIBLINGS = 2;
    public static int FLAG_PREFETCH_DESCENDANTS = 4;
    public static int FLAG_INCLUDE_NOT_IMPORTANT_VIEWS = 8;
    public static int FLAG_REPORT_VIEW_IDS = 16;
    public static int ACTION_FOCUS = 1;
    public static int ACTION_CLEAR_FOCUS = 2;
    public static int ACTION_SELECT = 4;
    public static int ACTION_CLEAR_SELECTION = 8;
    public static int ACTION_CLICK = 16;
    public static int ACTION_LONG_CLICK = 32;
    public static int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static int ACTION_SCROLL_FORWARD = 4096;
    public static int ACTION_SCROLL_BACKWARD = 8192;
    public static int ACTION_COPY = 16384;
    public static int ACTION_PASTE = 32768;
    public static int ACTION_CUT = 65536;
    public static int ACTION_SET_SELECTION = 131072;
    public static int ACTION_EXPAND = 262144;
    public static int ACTION_COLLAPSE = 524288;
    public static int ACTION_DISMISS = 0x100000;
    public static int ACTION_SET_TEXT = 0x200000;
    private static int LAST_LEGACY_STANDARD_ACTION = 0x200000;
    private static int ACTION_TYPE_MASK = -16777216;
    public static String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static int FOCUS_INPUT = 1;
    public static int FOCUS_ACCESSIBILITY = 2;
    public static int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static int MOVEMENT_GRANULARITY_WORD = 2;
    public static int MOVEMENT_GRANULARITY_LINE = 4;
    public static int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static int MOVEMENT_GRANULARITY_PAGE = 16;
    private static int BOOLEAN_PROPERTY_CHECKABLE = 1;
    private static int BOOLEAN_PROPERTY_CHECKED = 2;
    private static int BOOLEAN_PROPERTY_FOCUSABLE = 4;
    private static int BOOLEAN_PROPERTY_FOCUSED = 8;
    private static int BOOLEAN_PROPERTY_SELECTED = 16;
    private static int BOOLEAN_PROPERTY_CLICKABLE = 32;
    private static int BOOLEAN_PROPERTY_LONG_CLICKABLE = 64;
    private static int BOOLEAN_PROPERTY_ENABLED = 128;
    private static int BOOLEAN_PROPERTY_PASSWORD = 256;
    private static int BOOLEAN_PROPERTY_SCROLLABLE = 512;
    private static int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 1024;
    private static int BOOLEAN_PROPERTY_VISIBLE_TO_USER = 2048;
    private static int BOOLEAN_PROPERTY_EDITABLE = 4096;
    private static int BOOLEAN_PROPERTY_OPENS_POPUP = 8192;
    private static int BOOLEAN_PROPERTY_DISMISSABLE = 16384;
    private static int BOOLEAN_PROPERTY_MULTI_LINE = 32768;
    private static int BOOLEAN_PROPERTY_CONTENT_INVALID = 65536;
    private static long VIRTUAL_DESCENDANT_ID_MASK = -4294967296L;
    private static int VIRTUAL_DESCENDANT_ID_SHIFT = 32;
    private static int MAX_POOL_SIZE = 50;
    private static Pools.SynchronizedPool<AccessibilityNodeInfo> sPool;
    private boolean mSealed;
    private int mWindowId;
    private long mSourceNodeId;
    private long mParentNodeId;
    private long mLabelForId;
    private long mLabeledById;
    private int mBooleanProperties;
    private Rect mBoundsInParent;
    private Rect mBoundsInScreen;
    private CharSequence mPackageName;
    private CharSequence mClassName;
    private CharSequence mText;
    private CharSequence mError;
    private CharSequence mContentDescription;
    private String mViewIdResourceName;
    private LongArray mChildNodeIds;
    private ArrayList<AccessibilityAction> mActions;
    private int mMaxTextLength;
    private int mMovementGranularities;
    private int mTextSelectionStart;
    private int mTextSelectionEnd;
    private int mInputType;
    private int mLiveRegion;
    private Bundle mExtras;
    private int mConnectionId;
    private RangeInfo mRangeInfo;
    private CollectionInfo mCollectionInfo;
    private CollectionItemInfo mCollectionItemInfo;
    public static Parcelable.Creator<AccessibilityNodeInfo> CREATOR;

    private static final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getAccessibilityViewId(long accessibilityNodeId) {
        return (int)accessibilityNodeId;
    }

    private static final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getVirtualDescendantId(long accessibilityNodeId) {
        return (int)((accessibilityNodeId & 0xFFFFFFFF00000000L) >> 32);
    }

    private static final long $$robo$$android_view_accessibility_AccessibilityNodeInfo$makeNodeId(int accessibilityViewId, int virtualDescendantId) {
        if (virtualDescendantId == -1) {
            virtualDescendantId = Integer.MAX_VALUE;
        }
        return (long)virtualDescendantId << 32 | (long)accessibilityViewId;
    }

    private void $$robo$$android_view_accessibility_AccessibilityNodeInfo$__constructor__() {
        this.mWindowId = Integer.MAX_VALUE;
        this.mSourceNodeId = ROOT_NODE_ID;
        this.mParentNodeId = ROOT_NODE_ID;
        this.mLabelForId = ROOT_NODE_ID;
        this.mLabeledById = ROOT_NODE_ID;
        this.mBoundsInParent = new Rect();
        this.mBoundsInScreen = new Rect();
        this.mMaxTextLength = -1;
        this.mTextSelectionStart = -1;
        this.mTextSelectionEnd = -1;
        this.mInputType = 0;
        this.mLiveRegion = 0;
        this.mConnectionId = -1;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSource(View source) {
        this.setSource(source, Integer.MAX_VALUE);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        this.mWindowId = root != null ? root.getAccessibilityWindowId() : Integer.MAX_VALUE;
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$findFocus(int focus) {
        this.enforceSealed();
        this.enforceValidFocusType(focus);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, this.mWindowId, this.mSourceNodeId, focus);
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$focusSearch(int direction) {
        this.enforceSealed();
        this.enforceValidFocusDirection(direction);
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().focusSearch(this.mConnectionId, this.mWindowId, this.mSourceNodeId, direction);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getWindowId() {
        return this.mWindowId;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$refresh(boolean bypassCache) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        AccessibilityNodeInfo refreshedInfo = client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, bypassCache, 0);
        if (refreshedInfo == null) {
            return false;
        }
        this.init(refreshedInfo);
        refreshedInfo.recycle();
        return true;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$refresh() {
        return this.refresh(false);
    }

    private final LongArray $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildNodeIds() {
        return this.mChildNodeIds;
    }

    private final long $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildId(int index) {
        if (this.mChildNodeIds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChildNodeIds.get(index);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildCount() {
        return this.mChildNodeIds == null ? 0 : this.mChildNodeIds.size();
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChild(int index) {
        this.enforceSealed();
        if (this.mChildNodeIds == null) {
            return null;
        }
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        long childId = this.mChildNodeIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, childId, false, 4);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChild(View child) {
        this.addChildInternal(child, Integer.MAX_VALUE, true);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChildUnchecked(View child) {
        this.addChildInternal(child, Integer.MAX_VALUE, false);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeChild(View child) {
        return this.removeChild(child, Integer.MAX_VALUE);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChild(View root, int virtualDescendantId) {
        this.addChildInternal(root, virtualDescendantId, true);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChildInternal(View root, int virtualDescendantId, boolean checked) {
        this.enforceNotSealed();
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        if (checked && this.mChildNodeIds.indexOf(childNodeId) >= 0) {
            return;
        }
        this.mChildNodeIds.add(childNodeId);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeChild(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            return false;
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        int index = childIds.indexOf(childNodeId);
        if (index < 0) {
            return false;
        }
        childIds.remove(index);
        return true;
    }

    private final List<AccessibilityAction> $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionList() {
        if (this.mActions == null) {
            return Collections.emptyList();
        }
        return this.mActions;
    }

    @Deprecated
    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActions() {
        int returnValue = 0;
        if (this.mActions == null) {
            return returnValue;
        }
        int actionSize = this.mActions.size();
        for (int i = 0; i < actionSize; ++i) {
            int actionId = this.mActions.get(i).getId();
            if (actionId > 0x200000) continue;
            returnValue |= actionId;
        }
        return returnValue;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addAction(AccessibilityAction action) {
        this.enforceNotSealed();
        if (action == null) {
            return;
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.remove(action);
        this.mActions.add(action);
    }

    @Deprecated
    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addAction(int action) {
        this.enforceNotSealed();
        if ((action & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Action is not a combination of the standard actions: " + action);
        }
        this.addLegacyStandardActions(action);
    }

    @Deprecated
    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeAction(int action) {
        this.enforceNotSealed();
        this.removeAction(AccessibilityNodeInfo.getActionSingleton(action));
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeAction(AccessibilityAction action) {
        this.enforceNotSealed();
        if (this.mActions == null || action == null) {
            return false;
        }
        return this.mActions.remove(action);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMaxTextLength(int max) {
        this.enforceNotSealed();
        this.mMaxTextLength = max;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMaxTextLength() {
        return this.mMaxTextLength;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMovementGranularities(int granularities) {
        this.enforceNotSealed();
        this.mMovementGranularities = granularities;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMovementGranularities() {
        return this.mMovementGranularities;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$performAction(int action) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, null);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$performAction(int action, Bundle arguments) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, arguments);
    }

    private final List<AccessibilityNodeInfo> $$robo$$android_view_accessibility_AccessibilityNodeInfo$findAccessibilityNodeInfosByText(String text) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByText(this.mConnectionId, this.mWindowId, this.mSourceNodeId, text);
    }

    private final List<AccessibilityNodeInfo> $$robo$$android_view_accessibility_AccessibilityNodeInfo$findAccessibilityNodeInfosByViewId(String viewId) {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByViewId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, viewId);
    }

    private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getWindow() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mSourceNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mWindowId);
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getParent() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mParentNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId, false, 7);
    }

    private final long $$robo$$android_view_accessibility_AccessibilityNodeInfo$getParentNodeId() {
        return this.mParentNodeId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setParent(View parent) {
        this.setParent(parent, Integer.MAX_VALUE);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setParent(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mParentNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBoundsInParent(Rect outBounds) {
        outBounds.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBoundsInParent(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBoundsInScreen(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isCheckable() {
        return this.getBooleanProperty(1);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCheckable(boolean checkable) {
        this.setBooleanProperty(1, checkable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isChecked() {
        return this.getBooleanProperty(2);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setChecked(boolean checked) {
        this.setBooleanProperty(2, checked);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isFocusable() {
        return this.getBooleanProperty(4);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setFocusable(boolean focusable) {
        this.setBooleanProperty(4, focusable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isFocused() {
        return this.getBooleanProperty(8);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setFocused(boolean focused) {
        this.setBooleanProperty(8, focused);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isVisibleToUser() {
        return this.getBooleanProperty(2048);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setVisibleToUser(boolean visibleToUser) {
        this.setBooleanProperty(2048, visibleToUser);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isAccessibilityFocused() {
        return this.getBooleanProperty(1024);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(1024, focused);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isSelected() {
        return this.getBooleanProperty(16);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSelected(boolean selected) {
        this.setBooleanProperty(16, selected);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isClickable() {
        return this.getBooleanProperty(32);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setClickable(boolean clickable) {
        this.setBooleanProperty(32, clickable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isLongClickable() {
        return this.getBooleanProperty(64);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLongClickable(boolean longClickable) {
        this.setBooleanProperty(64, longClickable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isEnabled() {
        return this.getBooleanProperty(128);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setEnabled(boolean enabled) {
        this.setBooleanProperty(128, enabled);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isPassword() {
        return this.getBooleanProperty(256);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setPassword(boolean password) {
        this.setBooleanProperty(256, password);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isScrollable() {
        return this.getBooleanProperty(512);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setScrollable(boolean scrollable) {
        this.setBooleanProperty(512, scrollable);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isEditable() {
        return this.getBooleanProperty(4096);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setEditable(boolean editable) {
        this.setBooleanProperty(4096, editable);
    }

    private final CollectionInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getCollectionInfo() {
        return this.mCollectionInfo;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCollectionInfo(CollectionInfo collectionInfo) {
        this.enforceNotSealed();
        this.mCollectionInfo = collectionInfo;
    }

    private final CollectionItemInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getCollectionItemInfo() {
        return this.mCollectionItemInfo;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        this.enforceNotSealed();
        this.mCollectionItemInfo = collectionItemInfo;
    }

    private final RangeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getRangeInfo() {
        return this.mRangeInfo;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setRangeInfo(RangeInfo rangeInfo) {
        this.enforceNotSealed();
        this.mRangeInfo = rangeInfo;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isContentInvalid() {
        return this.getBooleanProperty(65536);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setContentInvalid(boolean contentInvalid) {
        this.setBooleanProperty(65536, contentInvalid);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLiveRegion() {
        return this.mLiveRegion;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLiveRegion(int mode) {
        this.enforceNotSealed();
        this.mLiveRegion = mode;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isMultiLine() {
        return this.getBooleanProperty(32768);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMultiLine(boolean multiLine) {
        this.setBooleanProperty(32768, multiLine);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$canOpenPopup() {
        return this.getBooleanProperty(8192);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCanOpenPopup(boolean opensPopup) {
        this.enforceNotSealed();
        this.setBooleanProperty(8192, opensPopup);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isDismissable() {
        return this.getBooleanProperty(16384);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setDismissable(boolean dismissable) {
        this.setBooleanProperty(16384, dismissable);
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo$getPackageName() {
        return this.mPackageName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo$getClassName() {
        return this.mClassName;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo$getText() {
        return this.mText;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setText(CharSequence text) {
        this.enforceNotSealed();
        this.mText = text;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setError(CharSequence error) {
        this.enforceNotSealed();
        this.mError = error;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo$getError() {
        return this.mError;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo$getContentDescription() {
        return this.mContentDescription;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabelFor(View labeled) {
        this.setLabelFor(labeled, Integer.MAX_VALUE);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabelFor(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabelForId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLabelFor() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabelForId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabelForId, false, 7);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabeledBy(View label) {
        this.setLabeledBy(label, Integer.MAX_VALUE);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabeledBy(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLabeledBy() {
        this.enforceSealed();
        if (!this.canPerformRequestOverConnection(this.mLabeledById)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledById, false, 7);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setViewIdResourceName(String viewIdResName) {
        this.enforceNotSealed();
        this.mViewIdResourceName = viewIdResName;
    }

    private final String $$robo$$android_view_accessibility_AccessibilityNodeInfo$getViewIdResourceName() {
        return this.mViewIdResourceName;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getTextSelectionStart() {
        return this.mTextSelectionStart;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getTextSelectionEnd() {
        return this.mTextSelectionEnd;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setTextSelection(int start, int end) {
        this.enforceNotSealed();
        this.mTextSelectionStart = start;
        this.mTextSelectionEnd = end;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$getInputType() {
        return this.mInputType;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setInputType(int inputType) {
        this.enforceNotSealed();
        this.mInputType = inputType;
    }

    private final Bundle $$robo$$android_view_accessibility_AccessibilityNodeInfo$getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBooleanProperty(int property, boolean value) {
        this.enforceNotSealed();
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$describeContents() {
        return 0;
    }

    private final long $$robo$$android_view_accessibility_AccessibilityNodeInfo$getSourceNodeId() {
        return this.mSourceNodeId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isSealed() {
        return this.mSealed;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceValidFocusDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: 
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceValidFocusType(int focusType) {
        switch (focusType) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown focus type: " + focusType);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    private static final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(View source) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(source);
        return info;
    }

    private static final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(View root, int virtualDescendantId) {
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
        info.setSource(root, virtualDescendantId);
        return info;
    }

    private static final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain() {
        AccessibilityNodeInfo info = sPool.acquire();
        return info != null ? info : new AccessibilityNodeInfo();
    }

    private static final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo infoClone = AccessibilityNodeInfo.obtain();
        infoClone.init(info);
        return infoClone;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$recycle() {
        this.clear();
        sPool.release(this);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.isSealed() ? 1 : 0);
        parcel.writeLong(this.mSourceNodeId);
        parcel.writeInt(this.mWindowId);
        parcel.writeLong(this.mParentNodeId);
        parcel.writeLong(this.mLabelForId);
        parcel.writeLong(this.mLabeledById);
        parcel.writeInt(this.mConnectionId);
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            parcel.writeInt(0);
        } else {
            int childIdsSize = childIds.size();
            parcel.writeInt(childIdsSize);
            for (int i = 0; i < childIdsSize; ++i) {
                parcel.writeLong(childIds.get(i));
            }
        }
        parcel.writeInt(this.mBoundsInParent.top);
        parcel.writeInt(this.mBoundsInParent.bottom);
        parcel.writeInt(this.mBoundsInParent.left);
        parcel.writeInt(this.mBoundsInParent.right);
        parcel.writeInt(this.mBoundsInScreen.top);
        parcel.writeInt(this.mBoundsInScreen.bottom);
        parcel.writeInt(this.mBoundsInScreen.left);
        parcel.writeInt(this.mBoundsInScreen.right);
        if (this.mActions != null && !this.mActions.isEmpty()) {
            AccessibilityAction action;
            int i;
            int actionCount = this.mActions.size();
            parcel.writeInt(actionCount);
            int defaultLegacyStandardActions = 0;
            for (i = 0; i < actionCount; ++i) {
                action = this.mActions.get(i);
                if (!AccessibilityNodeInfo.isDefaultLegacyStandardAction(action)) continue;
                defaultLegacyStandardActions |= action.getId();
            }
            parcel.writeInt(defaultLegacyStandardActions);
            for (i = 0; i < actionCount; ++i) {
                action = this.mActions.get(i);
                if (AccessibilityNodeInfo.isDefaultLegacyStandardAction(action)) continue;
                parcel.writeInt(action.getId());
                parcel.writeCharSequence(action.getLabel());
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mMaxTextLength);
        parcel.writeInt(this.mMovementGranularities);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeCharSequence(this.mPackageName);
        parcel.writeCharSequence(this.mClassName);
        parcel.writeCharSequence(this.mText);
        parcel.writeCharSequence(this.mError);
        parcel.writeCharSequence(this.mContentDescription);
        parcel.writeString(this.mViewIdResourceName);
        parcel.writeInt(this.mTextSelectionStart);
        parcel.writeInt(this.mTextSelectionEnd);
        parcel.writeInt(this.mInputType);
        parcel.writeInt(this.mLiveRegion);
        if (this.mExtras != null) {
            parcel.writeInt(1);
            parcel.writeBundle(this.mExtras);
        } else {
            parcel.writeInt(0);
        }
        if (this.mRangeInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mRangeInfo.getType());
            parcel.writeFloat(this.mRangeInfo.getMin());
            parcel.writeFloat(this.mRangeInfo.getMax());
            parcel.writeFloat(this.mRangeInfo.getCurrent());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mCollectionInfo.getRowCount());
            parcel.writeInt(this.mCollectionInfo.getColumnCount());
            parcel.writeInt(this.mCollectionInfo.isHierarchical() ? 1 : 0);
            parcel.writeInt(this.mCollectionInfo.getSelectionMode());
        } else {
            parcel.writeInt(0);
        }
        if (this.mCollectionItemInfo != null) {
            parcel.writeInt(1);
            parcel.writeInt(this.mCollectionItemInfo.getColumnIndex());
            parcel.writeInt(this.mCollectionItemInfo.getColumnSpan());
            parcel.writeInt(this.mCollectionItemInfo.getRowIndex());
            parcel.writeInt(this.mCollectionItemInfo.getRowSpan());
            parcel.writeInt(this.mCollectionItemInfo.isHeading() ? 1 : 0);
            parcel.writeInt(this.mCollectionItemInfo.isSelected() ? 1 : 0);
        } else {
            parcel.writeInt(0);
        }
        this.recycle();
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$init(AccessibilityNodeInfo other) {
        this.mSealed = other.mSealed;
        this.mSourceNodeId = other.mSourceNodeId;
        this.mParentNodeId = other.mParentNodeId;
        this.mLabelForId = other.mLabelForId;
        this.mLabeledById = other.mLabeledById;
        this.mWindowId = other.mWindowId;
        this.mConnectionId = other.mConnectionId;
        this.mBoundsInParent.set(other.mBoundsInParent);
        this.mBoundsInScreen.set(other.mBoundsInScreen);
        this.mPackageName = other.mPackageName;
        this.mClassName = other.mClassName;
        this.mText = other.mText;
        this.mError = other.mError;
        this.mContentDescription = other.mContentDescription;
        this.mViewIdResourceName = other.mViewIdResourceName;
        ArrayList<AccessibilityAction> otherActions = other.mActions;
        if (otherActions != null && otherActions.size() > 0) {
            if (this.mActions == null) {
                this.mActions = new ArrayList<AccessibilityAction>(otherActions);
            } else {
                this.mActions.clear();
                this.mActions.addAll(other.mActions);
            }
        }
        this.mBooleanProperties = other.mBooleanProperties;
        this.mMaxTextLength = other.mMaxTextLength;
        this.mMovementGranularities = other.mMovementGranularities;
        LongArray otherChildNodeIds = other.mChildNodeIds;
        if (otherChildNodeIds != null && otherChildNodeIds.size() > 0) {
            if (this.mChildNodeIds == null) {
                this.mChildNodeIds = otherChildNodeIds.clone();
            } else {
                this.mChildNodeIds.clear();
                this.mChildNodeIds.addAll(otherChildNodeIds);
            }
        }
        this.mTextSelectionStart = other.mTextSelectionStart;
        this.mTextSelectionEnd = other.mTextSelectionEnd;
        this.mInputType = other.mInputType;
        this.mLiveRegion = other.mLiveRegion;
        if (other.mExtras != null && !other.mExtras.isEmpty()) {
            this.getExtras().putAll(other.mExtras);
        }
        this.mRangeInfo = other.mRangeInfo != null ? RangeInfo.obtain(other.mRangeInfo) : null;
        this.mCollectionInfo = other.mCollectionInfo != null ? CollectionInfo.obtain(other.mCollectionInfo) : null;
        this.mCollectionItemInfo = other.mCollectionItemInfo != null ? CollectionItemInfo.obtain(other.mCollectionItemInfo) : null;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$initFromParcel(Parcel parcel) {
        this.mSealed = parcel.readInt() == 1;
        this.mSourceNodeId = parcel.readLong();
        this.mWindowId = parcel.readInt();
        this.mParentNodeId = parcel.readLong();
        this.mLabelForId = parcel.readLong();
        this.mLabeledById = parcel.readLong();
        this.mConnectionId = parcel.readInt();
        int childrenSize = parcel.readInt();
        if (childrenSize <= 0) {
            this.mChildNodeIds = null;
        } else {
            this.mChildNodeIds = new LongArray(childrenSize);
            for (int i = 0; i < childrenSize; ++i) {
                long childId = parcel.readLong();
                this.mChildNodeIds.add(childId);
            }
        }
        this.mBoundsInParent.top = parcel.readInt();
        this.mBoundsInParent.bottom = parcel.readInt();
        this.mBoundsInParent.left = parcel.readInt();
        this.mBoundsInParent.right = parcel.readInt();
        this.mBoundsInScreen.top = parcel.readInt();
        this.mBoundsInScreen.bottom = parcel.readInt();
        this.mBoundsInScreen.left = parcel.readInt();
        this.mBoundsInScreen.right = parcel.readInt();
        int actionCount = parcel.readInt();
        if (actionCount > 0) {
            int legacyStandardActions = parcel.readInt();
            this.addLegacyStandardActions(legacyStandardActions);
            int nonLegacyActionCount = actionCount - Integer.bitCount(legacyStandardActions);
            for (int i = 0; i < nonLegacyActionCount; ++i) {
                AccessibilityAction action = new AccessibilityAction(parcel.readInt(), parcel.readCharSequence());
                this.addAction(action);
            }
        }
        this.mMaxTextLength = parcel.readInt();
        this.mMovementGranularities = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mPackageName = parcel.readCharSequence();
        this.mClassName = parcel.readCharSequence();
        this.mText = parcel.readCharSequence();
        this.mError = parcel.readCharSequence();
        this.mContentDescription = parcel.readCharSequence();
        this.mViewIdResourceName = parcel.readString();
        this.mTextSelectionStart = parcel.readInt();
        this.mTextSelectionEnd = parcel.readInt();
        this.mInputType = parcel.readInt();
        this.mLiveRegion = parcel.readInt();
        if (parcel.readInt() == 1) {
            this.getExtras().putAll(parcel.readBundle());
        }
        if (parcel.readInt() == 1) {
            this.mRangeInfo = RangeInfo.obtain(parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
        }
        if (parcel.readInt() == 1) {
            this.mCollectionInfo = CollectionInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt());
        }
        if (parcel.readInt() == 1) {
            this.mCollectionItemInfo = CollectionItemInfo.obtain(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt() == 1);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$clear() {
        this.mSealed = false;
        this.mSourceNodeId = ROOT_NODE_ID;
        this.mParentNodeId = ROOT_NODE_ID;
        this.mLabelForId = ROOT_NODE_ID;
        this.mLabeledById = ROOT_NODE_ID;
        this.mWindowId = Integer.MAX_VALUE;
        this.mConnectionId = -1;
        this.mMaxTextLength = -1;
        this.mMovementGranularities = 0;
        if (this.mChildNodeIds != null) {
            this.mChildNodeIds.clear();
        }
        this.mBoundsInParent.set(0, 0, 0, 0);
        this.mBoundsInScreen.set(0, 0, 0, 0);
        this.mBooleanProperties = 0;
        this.mPackageName = null;
        this.mClassName = null;
        this.mText = null;
        this.mError = null;
        this.mContentDescription = null;
        this.mViewIdResourceName = null;
        if (this.mActions != null) {
            this.mActions.clear();
        }
        this.mTextSelectionStart = -1;
        this.mTextSelectionEnd = -1;
        this.mInputType = 0;
        this.mLiveRegion = 0;
        if (this.mExtras != null) {
            this.mExtras.clear();
        }
        if (this.mRangeInfo != null) {
            this.mRangeInfo.recycle();
            this.mRangeInfo = null;
        }
        if (this.mCollectionInfo != null) {
            this.mCollectionInfo.recycle();
            this.mCollectionInfo = null;
        }
        if (this.mCollectionItemInfo != null) {
            this.mCollectionItemInfo.recycle();
            this.mCollectionItemInfo = null;
        }
    }

    private static final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$isDefaultLegacyStandardAction(AccessibilityAction action) {
        return action.getId() <= 0x200000 && TextUtils.isEmpty(action.getLabel());
    }

    private static final AccessibilityAction $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionSingleton(int actionId) {
        int actions = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions; ++i) {
            AccessibilityAction currentAction = (AccessibilityAction)AccessibilityAction.sStandardActions.valueAt(i);
            if (actionId != currentAction.getId()) continue;
            return currentAction;
        }
        return null;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo$addLegacyStandardActions(int actionMask) {
        int id2;
        for (int remainingIds = actionMask; remainingIds > 0; remainingIds &= ~id2) {
            id2 = 1 << Integer.numberOfTrailingZeros(remainingIds);
            AccessibilityAction action = AccessibilityNodeInfo.getActionSingleton(id2);
            this.addAction(action);
        }
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionSymbolicName(int action) {
        switch (action) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
        }
        return "ACTION_UNKNOWN";
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMovementGranularitySymbolicName(int granularity) {
        switch (granularity) {
            case 1: {
                return "MOVEMENT_GRANULARITY_CHARACTER";
            }
            case 2: {
                return "MOVEMENT_GRANULARITY_WORD";
            }
            case 4: {
                return "MOVEMENT_GRANULARITY_LINE";
            }
            case 8: {
                return "MOVEMENT_GRANULARITY_PARAGRAPH";
            }
            case 16: {
                return "MOVEMENT_GRANULARITY_PAGE";
            }
        }
        throw new IllegalArgumentException("Unknown movement granularity: " + granularity);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$canPerformRequestOverConnection(long accessibilityNodeId) {
        return this.mWindowId != Integer.MAX_VALUE && AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId) != Integer.MAX_VALUE && this.mConnectionId != -1;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo$equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfo other = (AccessibilityNodeInfo)object;
        if (this.mSourceNodeId != other.mSourceNodeId) {
            return false;
        }
        return this.mWindowId == other.mWindowId;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId);
        result = 31 * result + AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId);
        result = 31 * result + this.mWindowId;
        return result;
    }

    private final String $$robo$$android_view_accessibility_AccessibilityNodeInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("; boundsInParent: " + this.mBoundsInParent);
        builder.append("; boundsInScreen: " + this.mBoundsInScreen);
        builder.append("; packageName: ").append(this.mPackageName);
        builder.append("; className: ").append(this.mClassName);
        builder.append("; text: ").append(this.mText);
        builder.append("; error: ").append(this.mError);
        builder.append("; maxTextLength: ").append(this.mMaxTextLength);
        builder.append("; contentDescription: ").append(this.mContentDescription);
        builder.append("; viewIdResName: ").append(this.mViewIdResourceName);
        builder.append("; checkable: ").append(this.isCheckable());
        builder.append("; checked: ").append(this.isChecked());
        builder.append("; focusable: ").append(this.isFocusable());
        builder.append("; focused: ").append(this.isFocused());
        builder.append("; selected: ").append(this.isSelected());
        builder.append("; clickable: ").append(this.isClickable());
        builder.append("; longClickable: ").append(this.isLongClickable());
        builder.append("; enabled: ").append(this.isEnabled());
        builder.append("; password: ").append(this.isPassword());
        builder.append("; scrollable: ").append(this.isScrollable());
        builder.append("; actions: ").append(this.mActions);
        return builder.toString();
    }

    static void __staticInitializer__() {
        ROOT_NODE_ID = AccessibilityNodeInfo.makeNodeId(Integer.MAX_VALUE, Integer.MAX_VALUE);
        sPool = new Pools.SynchronizedPool(50);
        CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$__constructor__() {
            }

            private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$createFromParcel(Parcel parcel) {
                AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain();
                info.initFromParcel(parcel);
                return info;
            }

            private final AccessibilityNodeInfo[] $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$newArray(int size) {
                return new AccessibilityNodeInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_accessibility_AccessibilityNodeInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$__constructor__(), 0, this);
            }

            @Override
            public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AccessibilityNodeInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_accessibility_AccessibilityNodeInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static int getAccessibilityViewId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAccessibilityViewId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getAccessibilityViewId(long ), 0, (long)l);
    }

    public static int getVirtualDescendantId(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVirtualDescendantId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getVirtualDescendantId(long ), 0, (long)l);
    }

    public static long makeNodeId(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("makeNodeId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$makeNodeId(int int ), 0, (int)n, (int)n2);
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityNodeInfo$__constructor__();
    }

    private AccessibilityNodeInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo$__constructor__(), 0, this);
    }

    public void setSource(View view) {
        InvokeDynamicSupport.bootstrap("setSource", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSource(android.view.View ), 0, this, view);
    }

    public void setSource(View view, int n) {
        InvokeDynamicSupport.bootstrap("setSource", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSource(android.view.View int ), 0, this, view, n);
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_view_accessibility_AccessibilityNodeInfo$findFocus(int ), 0, this, n);
    }

    public AccessibilityNodeInfo focusSearch(int n) {
        return InvokeDynamicSupport.bootstrap("focusSearch", $$robo$$android_view_accessibility_AccessibilityNodeInfo$focusSearch(int ), 0, this, n);
    }

    public int getWindowId() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getWindowId(), 0, this);
    }

    public boolean refresh(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_view_accessibility_AccessibilityNodeInfo$refresh(boolean ), 0, this, bl);
    }

    public boolean refresh() {
        return (boolean)InvokeDynamicSupport.bootstrap("refresh", $$robo$$android_view_accessibility_AccessibilityNodeInfo$refresh(), 0, this);
    }

    public LongArray getChildNodeIds() {
        return InvokeDynamicSupport.bootstrap("getChildNodeIds", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildNodeIds(), 0, this);
    }

    public long getChildId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getChildId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildId(int ), 0, this, n);
    }

    public int getChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChildCount(), 0, this);
    }

    public AccessibilityNodeInfo getChild(int n) {
        return InvokeDynamicSupport.bootstrap("getChild", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getChild(int ), 0, this, n);
    }

    public void addChild(View view) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChild(android.view.View ), 0, this, view);
    }

    public void addChildUnchecked(View view) {
        InvokeDynamicSupport.bootstrap("addChildUnchecked", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChildUnchecked(android.view.View ), 0, this, view);
    }

    public boolean removeChild(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeChild", $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeChild(android.view.View ), 0, this, view);
    }

    public void addChild(View view, int n) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChild(android.view.View int ), 0, this, view, n);
    }

    private void addChildInternal(View view, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("addChildInternal", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addChildInternal(android.view.View int boolean ), 0, this, view, n, bl);
    }

    public boolean removeChild(View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeChild", $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeChild(android.view.View int ), 0, this, view, n);
    }

    public List<AccessibilityAction> getActionList() {
        return InvokeDynamicSupport.bootstrap("getActionList", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionList(), 0, this);
    }

    @Deprecated
    public int getActions() {
        return (int)InvokeDynamicSupport.bootstrap("getActions", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActions(), 0, this);
    }

    public void addAction(AccessibilityAction accessibilityAction) {
        InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addAction(android.view.accessibility.AccessibilityNodeInfo$AccessibilityAction ), 0, this, accessibilityAction);
    }

    @Deprecated
    public void addAction(int n) {
        InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addAction(int ), 0, this, n);
    }

    @Deprecated
    public void removeAction(int n) {
        InvokeDynamicSupport.bootstrap("removeAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeAction(int ), 0, this, n);
    }

    public boolean removeAction(AccessibilityAction accessibilityAction) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$removeAction(android.view.accessibility.AccessibilityNodeInfo$AccessibilityAction ), 0, this, accessibilityAction);
    }

    public void setMaxTextLength(int n) {
        InvokeDynamicSupport.bootstrap("setMaxTextLength", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMaxTextLength(int ), 0, this, n);
    }

    public int getMaxTextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxTextLength", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMaxTextLength(), 0, this);
    }

    public void setMovementGranularities(int n) {
        InvokeDynamicSupport.bootstrap("setMovementGranularities", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMovementGranularities(int ), 0, this, n);
    }

    public int getMovementGranularities() {
        return (int)InvokeDynamicSupport.bootstrap("getMovementGranularities", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMovementGranularities(), 0, this);
    }

    public boolean performAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$performAction(int ), 0, this, n);
    }

    public boolean performAction(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$performAction(int android.os.Bundle ), 0, this, n, bundle);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2) {
        return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByText", $$robo$$android_view_accessibility_AccessibilityNodeInfo$findAccessibilityNodeInfosByText(java.lang.String ), 0, this, string2);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(String string2) {
        return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByViewId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$findAccessibilityNodeInfosByViewId(java.lang.String ), 0, this, string2);
    }

    public AccessibilityWindowInfo getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getWindow(), 0, this);
    }

    public AccessibilityNodeInfo getParent() {
        return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getParent(), 0, this);
    }

    public long getParentNodeId() {
        return (long)InvokeDynamicSupport.bootstrap("getParentNodeId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getParentNodeId(), 0, this);
    }

    public void setParent(View view) {
        InvokeDynamicSupport.bootstrap("setParent", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setParent(android.view.View ), 0, this, view);
    }

    public void setParent(View view, int n) {
        InvokeDynamicSupport.bootstrap("setParent", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setParent(android.view.View int ), 0, this, view, n);
    }

    public void getBoundsInParent(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBoundsInParent", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBoundsInParent(android.graphics.Rect ), 0, this, rect);
    }

    public void setBoundsInParent(Rect rect) {
        InvokeDynamicSupport.bootstrap("setBoundsInParent", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBoundsInParent(android.graphics.Rect ), 0, this, rect);
    }

    public void getBoundsInScreen(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBoundsInScreen", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBoundsInScreen(android.graphics.Rect ), 0, this, rect);
    }

    public void setBoundsInScreen(Rect rect) {
        InvokeDynamicSupport.bootstrap("setBoundsInScreen", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBoundsInScreen(android.graphics.Rect ), 0, this, rect);
    }

    public boolean isCheckable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCheckable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isCheckable(), 0, this);
    }

    public void setCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCheckable(boolean ), 0, this, bl);
    }

    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isChecked(), 0, this);
    }

    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setChecked(boolean ), 0, this, bl);
    }

    public boolean isFocusable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocusable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isFocusable(), 0, this);
    }

    public void setFocusable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocusable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setFocusable(boolean ), 0, this, bl);
    }

    public boolean isFocused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocused", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isFocused(), 0, this);
    }

    public void setFocused(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocused", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setFocused(boolean ), 0, this, bl);
    }

    public boolean isVisibleToUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisibleToUser", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isVisibleToUser(), 0, this);
    }

    public void setVisibleToUser(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVisibleToUser", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setVisibleToUser(boolean ), 0, this, bl);
    }

    public boolean isAccessibilityFocused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityFocused", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isAccessibilityFocused(), 0, this);
    }

    public void setAccessibilityFocused(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccessibilityFocused", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setAccessibilityFocused(boolean ), 0, this, bl);
    }

    public boolean isSelected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSelected", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isSelected(), 0, this);
    }

    public void setSelected(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelected", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSelected(boolean ), 0, this, bl);
    }

    public boolean isClickable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClickable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isClickable(), 0, this);
    }

    public void setClickable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClickable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setClickable(boolean ), 0, this, bl);
    }

    public boolean isLongClickable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLongClickable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isLongClickable(), 0, this);
    }

    public void setLongClickable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLongClickable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLongClickable(boolean ), 0, this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isEnabled(), 0, this);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setEnabled(boolean ), 0, this, bl);
    }

    public boolean isPassword() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPassword", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isPassword(), 0, this);
    }

    public void setPassword(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setPassword(boolean ), 0, this, bl);
    }

    public boolean isScrollable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isScrollable(), 0, this);
    }

    public void setScrollable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScrollable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setScrollable(boolean ), 0, this, bl);
    }

    public boolean isEditable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEditable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isEditable(), 0, this);
    }

    public void setEditable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEditable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setEditable(boolean ), 0, this, bl);
    }

    public CollectionInfo getCollectionInfo() {
        return InvokeDynamicSupport.bootstrap("getCollectionInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getCollectionInfo(), 0, this);
    }

    public void setCollectionInfo(CollectionInfo collectionInfo) {
        InvokeDynamicSupport.bootstrap("setCollectionInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCollectionInfo(android.view.accessibility.AccessibilityNodeInfo$CollectionInfo ), 0, this, collectionInfo);
    }

    public CollectionItemInfo getCollectionItemInfo() {
        return InvokeDynamicSupport.bootstrap("getCollectionItemInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getCollectionItemInfo(), 0, this);
    }

    public void setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        InvokeDynamicSupport.bootstrap("setCollectionItemInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCollectionItemInfo(android.view.accessibility.AccessibilityNodeInfo$CollectionItemInfo ), 0, this, collectionItemInfo);
    }

    public RangeInfo getRangeInfo() {
        return InvokeDynamicSupport.bootstrap("getRangeInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getRangeInfo(), 0, this);
    }

    public void setRangeInfo(RangeInfo rangeInfo) {
        InvokeDynamicSupport.bootstrap("setRangeInfo", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setRangeInfo(android.view.accessibility.AccessibilityNodeInfo$RangeInfo ), 0, this, rangeInfo);
    }

    public boolean isContentInvalid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isContentInvalid", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isContentInvalid(), 0, this);
    }

    public void setContentInvalid(boolean bl) {
        InvokeDynamicSupport.bootstrap("setContentInvalid", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setContentInvalid(boolean ), 0, this, bl);
    }

    public int getLiveRegion() {
        return (int)InvokeDynamicSupport.bootstrap("getLiveRegion", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLiveRegion(), 0, this);
    }

    public void setLiveRegion(int n) {
        InvokeDynamicSupport.bootstrap("setLiveRegion", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLiveRegion(int ), 0, this, n);
    }

    public boolean isMultiLine() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiLine", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isMultiLine(), 0, this);
    }

    public void setMultiLine(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMultiLine", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setMultiLine(boolean ), 0, this, bl);
    }

    public boolean canOpenPopup() {
        return (boolean)InvokeDynamicSupport.bootstrap("canOpenPopup", $$robo$$android_view_accessibility_AccessibilityNodeInfo$canOpenPopup(), 0, this);
    }

    public void setCanOpenPopup(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanOpenPopup", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setCanOpenPopup(boolean ), 0, this, bl);
    }

    public boolean isDismissable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDismissable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isDismissable(), 0, this);
    }

    public void setDismissable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDismissable", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setDismissable(boolean ), 0, this, bl);
    }

    public CharSequence getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getPackageName(), 0, this);
    }

    public void setPackageName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPackageName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setPackageName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getClassName() {
        return InvokeDynamicSupport.bootstrap("getClassName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getClassName(), 0, this);
    }

    public void setClassName(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setClassName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setClassName(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getText(), 0, this);
    }

    public void setText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setText(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setError(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setError(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getError() {
        return InvokeDynamicSupport.bootstrap("getError", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getError(), 0, this);
    }

    public CharSequence getContentDescription() {
        return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getContentDescription(), 0, this);
    }

    public void setContentDescription(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setContentDescription(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setLabelFor(View view) {
        InvokeDynamicSupport.bootstrap("setLabelFor", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabelFor(android.view.View ), 0, this, view);
    }

    public void setLabelFor(View view, int n) {
        InvokeDynamicSupport.bootstrap("setLabelFor", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabelFor(android.view.View int ), 0, this, view, n);
    }

    public AccessibilityNodeInfo getLabelFor() {
        return InvokeDynamicSupport.bootstrap("getLabelFor", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLabelFor(), 0, this);
    }

    public void setLabeledBy(View view) {
        InvokeDynamicSupport.bootstrap("setLabeledBy", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabeledBy(android.view.View ), 0, this, view);
    }

    public void setLabeledBy(View view, int n) {
        InvokeDynamicSupport.bootstrap("setLabeledBy", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setLabeledBy(android.view.View int ), 0, this, view, n);
    }

    public AccessibilityNodeInfo getLabeledBy() {
        return InvokeDynamicSupport.bootstrap("getLabeledBy", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getLabeledBy(), 0, this);
    }

    public void setViewIdResourceName(String string2) {
        InvokeDynamicSupport.bootstrap("setViewIdResourceName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setViewIdResourceName(java.lang.String ), 0, this, string2);
    }

    public String getViewIdResourceName() {
        return InvokeDynamicSupport.bootstrap("getViewIdResourceName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getViewIdResourceName(), 0, this);
    }

    public int getTextSelectionStart() {
        return (int)InvokeDynamicSupport.bootstrap("getTextSelectionStart", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getTextSelectionStart(), 0, this);
    }

    public int getTextSelectionEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getTextSelectionEnd", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getTextSelectionEnd(), 0, this);
    }

    public void setTextSelection(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTextSelection", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setTextSelection(int int ), 0, this, n, n2);
    }

    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getInputType(), 0, this);
    }

    public void setInputType(int n) {
        InvokeDynamicSupport.bootstrap("setInputType", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setInputType(int ), 0, this, n);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getExtras(), 0, this);
    }

    private boolean getBooleanProperty(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanProperty", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getBooleanProperty(int ), 0, this, n);
    }

    private void setBooleanProperty(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBooleanProperty", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setBooleanProperty(int boolean ), 0, this, n, bl);
    }

    public void setConnectionId(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setConnectionId(int ), 0, this, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_accessibility_AccessibilityNodeInfo$describeContents(), 0, this);
    }

    public long getSourceNodeId() {
        return (long)InvokeDynamicSupport.bootstrap("getSourceNodeId", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getSourceNodeId(), 0, this);
    }

    public void setSealed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSealed", $$robo$$android_view_accessibility_AccessibilityNodeInfo$setSealed(boolean ), 0, this, bl);
    }

    public boolean isSealed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSealed", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isSealed(), 0, this);
    }

    protected void enforceSealed() {
        InvokeDynamicSupport.bootstrap("enforceSealed", $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceSealed(), 0, this);
    }

    private void enforceValidFocusDirection(int n) {
        InvokeDynamicSupport.bootstrap("enforceValidFocusDirection", $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceValidFocusDirection(int ), 0, this, n);
    }

    private void enforceValidFocusType(int n) {
        InvokeDynamicSupport.bootstrap("enforceValidFocusType", $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceValidFocusType(int ), 0, this, n);
    }

    protected void enforceNotSealed() {
        InvokeDynamicSupport.bootstrap("enforceNotSealed", $$robo$$android_view_accessibility_AccessibilityNodeInfo$enforceNotSealed(), 0, this);
    }

    public static AccessibilityNodeInfo obtain(View view) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(android.view.View ), 0, (View)view);
    }

    public static AccessibilityNodeInfo obtain(View view, int n) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(android.view.View int ), 0, (View)view, (int)n);
    }

    public static AccessibilityNodeInfo obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(), 0);
    }

    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo accessibilityNodeInfo) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo$obtain(android.view.accessibility.AccessibilityNodeInfo ), 0, (AccessibilityNodeInfo)accessibilityNodeInfo);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityNodeInfo$recycle(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_accessibility_AccessibilityNodeInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void init(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_accessibility_AccessibilityNodeInfo$init(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    private void initFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("initFromParcel", $$robo$$android_view_accessibility_AccessibilityNodeInfo$initFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    private void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityNodeInfo$clear(), 0, this);
    }

    private static boolean isDefaultLegacyStandardAction(AccessibilityAction accessibilityAction) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefaultLegacyStandardAction", $$robo$$android_view_accessibility_AccessibilityNodeInfo$isDefaultLegacyStandardAction(android.view.accessibility.AccessibilityNodeInfo$AccessibilityAction ), 0, (AccessibilityAction)accessibilityAction);
    }

    private static AccessibilityAction getActionSingleton(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getActionSingleton", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionSingleton(int ), 0, (int)n);
    }

    private void addLegacyStandardActions(int n) {
        InvokeDynamicSupport.bootstrap("addLegacyStandardActions", $$robo$$android_view_accessibility_AccessibilityNodeInfo$addLegacyStandardActions(int ), 0, this, n);
    }

    private static String getActionSymbolicName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getActionSymbolicName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getActionSymbolicName(int ), 0, (int)n);
    }

    private static String getMovementGranularitySymbolicName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getMovementGranularitySymbolicName", $$robo$$android_view_accessibility_AccessibilityNodeInfo$getMovementGranularitySymbolicName(int ), 0, (int)n);
    }

    private boolean canPerformRequestOverConnection(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("canPerformRequestOverConnection", $$robo$$android_view_accessibility_AccessibilityNodeInfo$canPerformRequestOverConnection(long ), 0, this, l);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_accessibility_AccessibilityNodeInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_accessibility_AccessibilityNodeInfo$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_accessibility_AccessibilityNodeInfo$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityNodeInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityNodeInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CollectionItemInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 20;
        private static Pools.SynchronizedPool<CollectionItemInfo> sPool;
        private boolean mHeading;
        private int mColumnIndex;
        private int mRowIndex;
        private int mColumnSpan;
        private int mRowSpan;
        private boolean mSelected;

        private static final CollectionItemInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(CollectionItemInfo other) {
            return CollectionItemInfo.obtain(other.mRowIndex, other.mRowSpan, other.mColumnIndex, other.mColumnSpan, other.mHeading, other.mSelected);
        }

        private static final CollectionItemInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            return CollectionItemInfo.obtain(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        private static final CollectionItemInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            CollectionItemInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, selected);
            }
            info.mRowIndex = rowIndex;
            info.mRowSpan = rowSpan;
            info.mColumnIndex = columnIndex;
            info.mColumnSpan = columnSpan;
            info.mHeading = heading;
            info.mSelected = selected;
            return info;
        }

        private void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$__constructor__(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            this.mRowIndex = rowIndex;
            this.mRowSpan = rowSpan;
            this.mColumnIndex = columnIndex;
            this.mColumnSpan = columnSpan;
            this.mHeading = heading;
            this.mSelected = selected;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getColumnIndex() {
            return this.mColumnIndex;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getRowIndex() {
            return this.mRowIndex;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getColumnSpan() {
            return this.mColumnSpan;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getRowSpan() {
            return this.mRowSpan;
        }

        private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$isHeading() {
            return this.mHeading;
        }

        private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$isSelected() {
            return this.mSelected;
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$recycle() {
            this.clear();
            sPool.release(this);
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$clear() {
            this.mColumnIndex = 0;
            this.mColumnSpan = 0;
            this.mRowIndex = 0;
            this.mRowSpan = 0;
            this.mHeading = false;
            this.mSelected = false;
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(20);
        }

        public static CollectionItemInfo obtain(CollectionItemInfo collectionItemInfo) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(android.view.accessibility.AccessibilityNodeInfo$CollectionItemInfo ), 0, (CollectionItemInfo)collectionItemInfo);
        }

        public static CollectionItemInfo obtain(int n, int n2, int n3, int n4, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(int int int int boolean ), 0, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl);
        }

        public static CollectionItemInfo obtain(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$obtain(int int int int boolean boolean ), 0, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl, (boolean)bl2);
        }

        private void __constructor__(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            this.$$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$__constructor__(n, n2, n3, n4, bl, bl2);
        }

        private CollectionItemInfo(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$__constructor__(int int int int boolean boolean ), 0, this, n, n2, n3, n4, bl, bl2);
        }

        public int getColumnIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getColumnIndex", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getColumnIndex(), 0, this);
        }

        public int getRowIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getRowIndex", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getRowIndex(), 0, this);
        }

        public int getColumnSpan() {
            return (int)InvokeDynamicSupport.bootstrap("getColumnSpan", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getColumnSpan(), 0, this);
        }

        public int getRowSpan() {
            return (int)InvokeDynamicSupport.bootstrap("getRowSpan", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$getRowSpan(), 0, this);
        }

        public boolean isHeading() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHeading", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$isHeading(), 0, this);
        }

        public boolean isSelected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelected", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$isSelected(), 0, this);
        }

        void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$recycle(), 0, this);
        }

        private void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionItemInfo$clear(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(CollectionItemInfo.class);
        }

        public /* synthetic */ CollectionItemInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollectionItemInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CollectionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int SELECTION_MODE_NONE = 0;
        public static int SELECTION_MODE_SINGLE = 1;
        public static int SELECTION_MODE_MULTIPLE = 2;
        private static int MAX_POOL_SIZE = 20;
        private static Pools.SynchronizedPool<CollectionInfo> sPool;
        private int mRowCount;
        private int mColumnCount;
        private boolean mHierarchical;
        private int mSelectionMode;

        private static final CollectionInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(CollectionInfo other) {
            return CollectionInfo.obtain(other.mRowCount, other.mColumnCount, other.mHierarchical, other.mSelectionMode);
        }

        private static final CollectionInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(int rowCount, int columnCount, boolean hierarchical) {
            return CollectionInfo.obtain(rowCount, columnCount, hierarchical, 0);
        }

        private static final CollectionInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            CollectionInfo info = sPool.acquire();
            if (info == null) {
                return new CollectionInfo(rowCount, columnCount, hierarchical, selectionMode);
            }
            info.mRowCount = rowCount;
            info.mColumnCount = columnCount;
            info.mHierarchical = hierarchical;
            info.mSelectionMode = selectionMode;
            return info;
        }

        private void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$__constructor__(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            this.mRowCount = rowCount;
            this.mColumnCount = columnCount;
            this.mHierarchical = hierarchical;
            this.mSelectionMode = selectionMode;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getRowCount() {
            return this.mRowCount;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getColumnCount() {
            return this.mColumnCount;
        }

        private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$isHierarchical() {
            return this.mHierarchical;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getSelectionMode() {
            return this.mSelectionMode;
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$recycle() {
            this.clear();
            sPool.release(this);
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$clear() {
            this.mRowCount = 0;
            this.mColumnCount = 0;
            this.mHierarchical = false;
            this.mSelectionMode = 0;
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(20);
        }

        public static CollectionInfo obtain(CollectionInfo collectionInfo) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(android.view.accessibility.AccessibilityNodeInfo$CollectionInfo ), 0, (CollectionInfo)collectionInfo);
        }

        public static CollectionInfo obtain(int n, int n2, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(int int boolean ), 0, (int)n, (int)n2, (boolean)bl);
        }

        public static CollectionInfo obtain(int n, int n2, boolean bl, int n3) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$obtain(int int boolean int ), 0, (int)n, (int)n2, (boolean)bl, (int)n3);
        }

        private void __constructor__(int n, int n2, boolean bl, int n3) {
            this.$$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$__constructor__(n, n2, bl, n3);
        }

        private CollectionInfo(int n, int n2, boolean bl, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$__constructor__(int int boolean int ), 0, this, n, n2, bl, n3);
        }

        public int getRowCount() {
            return (int)InvokeDynamicSupport.bootstrap("getRowCount", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getRowCount(), 0, this);
        }

        public int getColumnCount() {
            return (int)InvokeDynamicSupport.bootstrap("getColumnCount", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getColumnCount(), 0, this);
        }

        public boolean isHierarchical() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHierarchical", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$isHierarchical(), 0, this);
        }

        public int getSelectionMode() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectionMode", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$getSelectionMode(), 0, this);
        }

        void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$recycle(), 0, this);
        }

        private void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityNodeInfo_CollectionInfo$clear(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(CollectionInfo.class);
        }

        public /* synthetic */ CollectionInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollectionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RangeInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_POOL_SIZE = 10;
        public static int RANGE_TYPE_INT = 0;
        public static int RANGE_TYPE_FLOAT = 1;
        public static int RANGE_TYPE_PERCENT = 2;
        private static Pools.SynchronizedPool<RangeInfo> sPool;
        private int mType;
        private float mMin;
        private float mMax;
        private float mCurrent;

        private static final RangeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$obtain(RangeInfo other) {
            return RangeInfo.obtain(other.mType, other.mMin, other.mMax, other.mCurrent);
        }

        private static final RangeInfo $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$obtain(int type, float min, float max, float current) {
            RangeInfo info = sPool.acquire();
            return info != null ? info : new RangeInfo(type, min, max, current);
        }

        private void $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$__constructor__(int type, float min, float max, float current) {
            this.mType = type;
            this.mMin = min;
            this.mMax = max;
            this.mCurrent = current;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getType() {
            return this.mType;
        }

        private final float $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getMin() {
            return this.mMin;
        }

        private final float $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getMax() {
            return this.mMax;
        }

        private final float $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getCurrent() {
            return this.mCurrent;
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$recycle() {
            this.clear();
            sPool.release(this);
        }

        private final void $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$clear() {
            this.mType = 0;
            this.mMin = 0.0f;
            this.mMax = 0.0f;
            this.mCurrent = 0.0f;
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(10);
        }

        public static RangeInfo obtain(RangeInfo rangeInfo) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$obtain(android.view.accessibility.AccessibilityNodeInfo$RangeInfo ), 0, (RangeInfo)rangeInfo);
        }

        public static RangeInfo obtain(int n, float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$obtain(int float float float ), 0, (int)n, (float)f, (float)f2, (float)f3);
        }

        private void __constructor__(int n, float f, float f2, float f3) {
            this.$$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$__constructor__(n, f, f2, f3);
        }

        private RangeInfo(int n, float f, float f2, float f3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$__constructor__(int float float float ), 0, this, n, f, f2, f3);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getType(), 0, this);
        }

        public float getMin() {
            return (float)InvokeDynamicSupport.bootstrap("getMin", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getMin(), 0, this);
        }

        public float getMax() {
            return (float)InvokeDynamicSupport.bootstrap("getMax", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getMax(), 0, this);
        }

        public float getCurrent() {
            return (float)InvokeDynamicSupport.bootstrap("getCurrent", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$getCurrent(), 0, this);
        }

        void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$recycle(), 0, this);
        }

        private void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityNodeInfo_RangeInfo$clear(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(RangeInfo.class);
        }

        public /* synthetic */ RangeInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RangeInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AccessibilityAction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static AccessibilityAction ACTION_FOCUS;
        public static AccessibilityAction ACTION_CLEAR_FOCUS;
        public static AccessibilityAction ACTION_SELECT;
        public static AccessibilityAction ACTION_CLEAR_SELECTION;
        public static AccessibilityAction ACTION_CLICK;
        public static AccessibilityAction ACTION_LONG_CLICK;
        public static AccessibilityAction ACTION_ACCESSIBILITY_FOCUS;
        public static AccessibilityAction ACTION_CLEAR_ACCESSIBILITY_FOCUS;
        public static AccessibilityAction ACTION_NEXT_AT_MOVEMENT_GRANULARITY;
        public static AccessibilityAction ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY;
        public static AccessibilityAction ACTION_NEXT_HTML_ELEMENT;
        public static AccessibilityAction ACTION_PREVIOUS_HTML_ELEMENT;
        public static AccessibilityAction ACTION_SCROLL_FORWARD;
        public static AccessibilityAction ACTION_SCROLL_BACKWARD;
        public static AccessibilityAction ACTION_COPY;
        public static AccessibilityAction ACTION_PASTE;
        public static AccessibilityAction ACTION_CUT;
        public static AccessibilityAction ACTION_SET_SELECTION;
        public static AccessibilityAction ACTION_EXPAND;
        public static AccessibilityAction ACTION_COLLAPSE;
        public static AccessibilityAction ACTION_DISMISS;
        public static AccessibilityAction ACTION_SET_TEXT;
        private static ArraySet<AccessibilityAction> sStandardActions;
        private int mActionId;
        private CharSequence mLabel;

        private void $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$__constructor__(int actionId, CharSequence label) {
            if ((actionId & 0xFF000000) == 0 && Integer.bitCount(actionId) != 1) {
                throw new IllegalArgumentException("Invalid standard action id");
            }
            this.mActionId = actionId;
            this.mLabel = label;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$getId() {
            return this.mActionId;
        }

        private final CharSequence $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$getLabel() {
            return this.mLabel;
        }

        private final int $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$hashCode() {
            return this.mActionId;
        }

        private final boolean $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.mActionId == ((AccessibilityAction)other).mActionId;
        }

        private final String $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$toString() {
            return "AccessibilityAction: " + AccessibilityNodeInfo.getActionSymbolicName(this.mActionId) + " - " + this.mLabel;
        }

        static void __staticInitializer__() {
            ACTION_FOCUS = new AccessibilityAction(1, null);
            ACTION_CLEAR_FOCUS = new AccessibilityAction(2, null);
            ACTION_SELECT = new AccessibilityAction(4, null);
            ACTION_CLEAR_SELECTION = new AccessibilityAction(8, null);
            ACTION_CLICK = new AccessibilityAction(16, null);
            ACTION_LONG_CLICK = new AccessibilityAction(32, null);
            ACTION_ACCESSIBILITY_FOCUS = new AccessibilityAction(64, null);
            ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityAction(128, null);
            ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(256, null);
            ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(512, null);
            ACTION_NEXT_HTML_ELEMENT = new AccessibilityAction(1024, null);
            ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityAction(2048, null);
            ACTION_SCROLL_FORWARD = new AccessibilityAction(4096, null);
            ACTION_SCROLL_BACKWARD = new AccessibilityAction(8192, null);
            ACTION_COPY = new AccessibilityAction(16384, null);
            ACTION_PASTE = new AccessibilityAction(32768, null);
            ACTION_CUT = new AccessibilityAction(65536, null);
            ACTION_SET_SELECTION = new AccessibilityAction(131072, null);
            ACTION_EXPAND = new AccessibilityAction(262144, null);
            ACTION_COLLAPSE = new AccessibilityAction(524288, null);
            ACTION_DISMISS = new AccessibilityAction(0x100000, null);
            ACTION_SET_TEXT = new AccessibilityAction(0x200000, null);
            sStandardActions = new ArraySet();
            sStandardActions.add(ACTION_FOCUS);
            sStandardActions.add(ACTION_CLEAR_FOCUS);
            sStandardActions.add(ACTION_SELECT);
            sStandardActions.add(ACTION_CLEAR_SELECTION);
            sStandardActions.add(ACTION_CLICK);
            sStandardActions.add(ACTION_LONG_CLICK);
            sStandardActions.add(ACTION_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_CLEAR_ACCESSIBILITY_FOCUS);
            sStandardActions.add(ACTION_NEXT_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY);
            sStandardActions.add(ACTION_NEXT_HTML_ELEMENT);
            sStandardActions.add(ACTION_PREVIOUS_HTML_ELEMENT);
            sStandardActions.add(ACTION_SCROLL_FORWARD);
            sStandardActions.add(ACTION_SCROLL_BACKWARD);
            sStandardActions.add(ACTION_COPY);
            sStandardActions.add(ACTION_PASTE);
            sStandardActions.add(ACTION_CUT);
            sStandardActions.add(ACTION_SET_SELECTION);
            sStandardActions.add(ACTION_EXPAND);
            sStandardActions.add(ACTION_COLLAPSE);
            sStandardActions.add(ACTION_DISMISS);
            sStandardActions.add(ACTION_SET_TEXT);
        }

        private void __constructor__(int n, CharSequence charSequence) {
            this.$$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$__constructor__(n, charSequence);
        }

        public AccessibilityAction(int n, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$__constructor__(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$getId(), 0, this);
        }

        public CharSequence getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$getLabel(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_accessibility_AccessibilityNodeInfo_AccessibilityAction$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(AccessibilityAction.class);
        }

        public /* synthetic */ AccessibilityAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

