/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CaptioningManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_ENABLED = 0;
    private static int DEFAULT_PRESET = 0;
    private static float DEFAULT_FONT_SCALE = 1.0f;
    private ArrayList<CaptioningChangeListener> mListeners;
    private Handler mHandler;
    private ContentResolver mContentResolver;
    private ContentObserver mContentObserver;
    private Runnable mStyleChangedRunnable;

    private void $$robo$$android_view_accessibility_CaptioningManager$__constructor__(Context context) {
        this.mListeners = new ArrayList();
        this.mHandler = new Handler();
        this.mContentObserver = new ShadowedObject(this, this.mHandler){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CaptioningManager this$0;

            private void $$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(CaptioningManager captioningManager, Handler x0) {
            }

            private final void $$robo$$android_view_accessibility_CaptioningManager_1$onChange(boolean selfChange, Uri uri) {
                String uriPath = uri.getPath();
                String name = uriPath.substring(uriPath.lastIndexOf(47) + 1);
                if ("accessibility_captioning_enabled".equals(name)) {
                    this.this$0.notifyEnabledChanged();
                } else if ("accessibility_captioning_locale".equals(name)) {
                    this.this$0.notifyLocaleChanged();
                } else if ("accessibility_captioning_font_scale".equals(name)) {
                    this.this$0.notifyFontScaleChanged();
                } else {
                    this.this$0.mHandler.removeCallbacks(this.this$0.mStyleChangedRunnable);
                    this.this$0.mHandler.post(this.this$0.mStyleChangedRunnable);
                }
            }

            private void __constructor__(CaptioningManager captioningManager, Handler handler) {
                this.$$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(captioningManager, handler);
            }
            {
                this.this$0 = captioningManager;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_1$__constructor__(android.view.accessibility.CaptioningManager android.os.Handler ), 0, this, captioningManager, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_view_accessibility_CaptioningManager_1$onChange(boolean android.net.Uri ), 0, this, bl, uri);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mStyleChangedRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CaptioningManager this$0;

            private void $$robo$$android_view_accessibility_CaptioningManager_2$__constructor__(CaptioningManager captioningManager) {
            }

            private final void $$robo$$android_view_accessibility_CaptioningManager_2$run() {
                this.this$0.notifyUserStyleChanged();
            }

            private void __constructor__(CaptioningManager captioningManager) {
                this.$$robo$$android_view_accessibility_CaptioningManager_2$__constructor__(captioningManager);
            }
            {
                this.this$0 = captioningManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_2$__constructor__(android.view.accessibility.CaptioningManager ), 0, this, captioningManager);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_accessibility_CaptioningManager_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContentResolver = context.getContentResolver();
    }

    private final boolean $$robo$$android_view_accessibility_CaptioningManager$isEnabled() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_enabled", 0) == 1;
    }

    private final String $$robo$$android_view_accessibility_CaptioningManager$getRawLocale() {
        return Settings.Secure.getString(this.mContentResolver, "accessibility_captioning_locale");
    }

    private final Locale $$robo$$android_view_accessibility_CaptioningManager$getLocale() {
        String rawLocale = this.getRawLocale();
        if (!TextUtils.isEmpty(rawLocale)) {
            String[] splitLocale = rawLocale.split("_");
            switch (splitLocale.length) {
                case 3: {
                    return new Locale(splitLocale[0], splitLocale[1], splitLocale[2]);
                }
                case 2: {
                    return new Locale(splitLocale[0], splitLocale[1]);
                }
                case 1: {
                    return new Locale(splitLocale[0]);
                }
            }
        }
        return null;
    }

    private final float $$robo$$android_view_accessibility_CaptioningManager$getFontScale() {
        return Settings.Secure.getFloat(this.mContentResolver, "accessibility_captioning_font_scale", 1.0f);
    }

    private final int $$robo$$android_view_accessibility_CaptioningManager$getRawUserStyle() {
        return Settings.Secure.getInt(this.mContentResolver, "accessibility_captioning_preset", 0);
    }

    private final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager$getUserStyle() {
        int preset = this.getRawUserStyle();
        if (preset == -1) {
            return CaptionStyle.getCustomStyle(this.mContentResolver);
        }
        return CaptionStyle.PRESETS[preset];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$addCaptioningChangeListener(CaptioningChangeListener listener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            if (this.mListeners.isEmpty()) {
                this.registerObserver("accessibility_captioning_enabled");
                this.registerObserver("accessibility_captioning_foreground_color");
                this.registerObserver("accessibility_captioning_background_color");
                this.registerObserver("accessibility_captioning_window_color");
                this.registerObserver("accessibility_captioning_edge_type");
                this.registerObserver("accessibility_captioning_edge_color");
                this.registerObserver("accessibility_captioning_typeface");
                this.registerObserver("accessibility_captioning_font_scale");
                this.registerObserver("accessibility_captioning_locale");
                this.registerObserver("accessibility_captioning_preset");
            }
            this.mListeners.add(listener);
        }
    }

    private final void $$robo$$android_view_accessibility_CaptioningManager$registerObserver(String key) {
        this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor(key), false, this.mContentObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$removeCaptioningChangeListener(CaptioningChangeListener listener) {
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mListeners.remove(listener);
            if (this.mListeners.isEmpty()) {
                this.mContentResolver.unregisterContentObserver(this.mContentObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyEnabledChanged() {
        boolean enabled = this.isEnabled();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onEnabledChanged(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyUserStyleChanged() {
        CaptionStyle userStyle = this.getUserStyle();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onUserStyleChanged(userStyle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyLocaleChanged() {
        Locale locale = this.getLocale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onLocaleChanged(locale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_CaptioningManager$notifyFontScaleChanged() {
        float fontScale = this.getFontScale();
        ArrayList<CaptioningChangeListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (CaptioningChangeListener listener : this.mListeners) {
                listener.onFontScaleChanged(fontScale);
            }
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_accessibility_CaptioningManager$__constructor__(context);
    }

    public CaptioningManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_CaptioningManager$isEnabled(), 0, this);
    }

    public String getRawLocale() {
        return InvokeDynamicSupport.bootstrap("getRawLocale", $$robo$$android_view_accessibility_CaptioningManager$getRawLocale(), 0, this);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_view_accessibility_CaptioningManager$getLocale(), 0, this);
    }

    public float getFontScale() {
        return (float)InvokeDynamicSupport.bootstrap("getFontScale", $$robo$$android_view_accessibility_CaptioningManager$getFontScale(), 0, this);
    }

    public int getRawUserStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getRawUserStyle", $$robo$$android_view_accessibility_CaptioningManager$getRawUserStyle(), 0, this);
    }

    public CaptionStyle getUserStyle() {
        return InvokeDynamicSupport.bootstrap("getUserStyle", $$robo$$android_view_accessibility_CaptioningManager$getUserStyle(), 0, this);
    }

    public void addCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        InvokeDynamicSupport.bootstrap("addCaptioningChangeListener", $$robo$$android_view_accessibility_CaptioningManager$addCaptioningChangeListener(android.view.accessibility.CaptioningManager$CaptioningChangeListener ), 0, this, captioningChangeListener);
    }

    private void registerObserver(String string2) {
        InvokeDynamicSupport.bootstrap("registerObserver", $$robo$$android_view_accessibility_CaptioningManager$registerObserver(java.lang.String ), 0, this, string2);
    }

    public void removeCaptioningChangeListener(CaptioningChangeListener captioningChangeListener) {
        InvokeDynamicSupport.bootstrap("removeCaptioningChangeListener", $$robo$$android_view_accessibility_CaptioningManager$removeCaptioningChangeListener(android.view.accessibility.CaptioningManager$CaptioningChangeListener ), 0, this, captioningChangeListener);
    }

    private void notifyEnabledChanged() {
        InvokeDynamicSupport.bootstrap("notifyEnabledChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyEnabledChanged(), 0, this);
    }

    private void notifyUserStyleChanged() {
        InvokeDynamicSupport.bootstrap("notifyUserStyleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyUserStyleChanged(), 0, this);
    }

    private void notifyLocaleChanged() {
        InvokeDynamicSupport.bootstrap("notifyLocaleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyLocaleChanged(), 0, this);
    }

    private void notifyFontScaleChanged() {
        InvokeDynamicSupport.bootstrap("notifyFontScaleChanged", $$robo$$android_view_accessibility_CaptioningManager$notifyFontScaleChanged(), 0, this);
    }

    public /* synthetic */ CaptioningManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptioningManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class CaptioningChangeListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__() {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onEnabledChanged(boolean enabled) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onUserStyleChanged(CaptionStyle userStyle) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onLocaleChanged(Locale locale) {
        }

        private final void $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onFontScaleChanged(float fontScale) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__();
        }

        public CaptioningChangeListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$__constructor__(), 0, this);
        }

        public void onEnabledChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onEnabledChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onEnabledChanged(boolean ), 0, this, bl);
        }

        public void onUserStyleChanged(CaptionStyle captionStyle) {
            InvokeDynamicSupport.bootstrap("onUserStyleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onUserStyleChanged(android.view.accessibility.CaptioningManager$CaptionStyle ), 0, this, captionStyle);
        }

        public void onLocaleChanged(Locale locale) {
            InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onLocaleChanged(java.util.Locale ), 0, this, locale);
        }

        public void onFontScaleChanged(float f) {
            InvokeDynamicSupport.bootstrap("onFontScaleChanged", $$robo$$android_view_accessibility_CaptioningManager_CaptioningChangeListener$onFontScaleChanged(float ), 0, this, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptioningChangeListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CaptionStyle
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int COLOR_NONE_OPAQUE = 255;
        private static int COLOR_UNSPECIFIED = 511;
        private static CaptionStyle WHITE_ON_BLACK;
        private static CaptionStyle BLACK_ON_WHITE;
        private static CaptionStyle YELLOW_ON_BLACK;
        private static CaptionStyle YELLOW_ON_BLUE;
        private static CaptionStyle DEFAULT_CUSTOM;
        private static CaptionStyle UNSPECIFIED;
        public static CaptionStyle DEFAULT;
        public static CaptionStyle[] PRESETS;
        public static int PRESET_CUSTOM = -1;
        public static int EDGE_TYPE_UNSPECIFIED = -1;
        public static int EDGE_TYPE_NONE = 0;
        public static int EDGE_TYPE_OUTLINE = 1;
        public static int EDGE_TYPE_DROP_SHADOW = 2;
        public static int EDGE_TYPE_RAISED = 3;
        public static int EDGE_TYPE_DEPRESSED = 4;
        public int foregroundColor;
        public int backgroundColor;
        public int edgeType;
        public int edgeColor;
        public int windowColor;
        public String mRawTypeface;
        private boolean mHasForegroundColor;
        private boolean mHasBackgroundColor;
        private boolean mHasEdgeType;
        private boolean mHasEdgeColor;
        private boolean mHasWindowColor;
        private Typeface mParsedTypeface;

        private void $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(int foregroundColor, int backgroundColor, int edgeType, int edgeColor, int windowColor, String rawTypeface) {
            this.mHasForegroundColor = foregroundColor != 511;
            this.mHasBackgroundColor = backgroundColor != 511;
            this.mHasEdgeType = edgeType != -1;
            this.mHasEdgeColor = edgeColor != 511;
            this.mHasWindowColor = windowColor != 511;
            this.foregroundColor = this.mHasForegroundColor ? foregroundColor : -1;
            this.backgroundColor = this.mHasBackgroundColor ? backgroundColor : -16777216;
            this.edgeType = this.mHasEdgeType ? edgeType : 0;
            this.edgeColor = this.mHasEdgeColor ? edgeColor : -16777216;
            this.windowColor = this.mHasWindowColor ? windowColor : 255;
            this.mRawTypeface = rawTypeface;
        }

        private final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$applyStyle(CaptionStyle overlay) {
            int newForegroundColor = overlay.hasForegroundColor() ? overlay.foregroundColor : this.foregroundColor;
            int newBackgroundColor = overlay.hasBackgroundColor() ? overlay.backgroundColor : this.backgroundColor;
            int newEdgeType = overlay.hasEdgeType() ? overlay.edgeType : this.edgeType;
            int newEdgeColor = overlay.hasEdgeColor() ? overlay.edgeColor : this.edgeColor;
            int newWindowColor = overlay.hasWindowColor() ? overlay.windowColor : this.windowColor;
            String newRawTypeface = overlay.mRawTypeface != null ? overlay.mRawTypeface : this.mRawTypeface;
            return new CaptionStyle(newForegroundColor, newBackgroundColor, newEdgeType, newEdgeColor, newWindowColor, newRawTypeface);
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasBackgroundColor() {
            return this.mHasBackgroundColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasForegroundColor() {
            return this.mHasForegroundColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeType() {
            return this.mHasEdgeType;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeColor() {
            return this.mHasEdgeColor;
        }

        private final boolean $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasWindowColor() {
            return this.mHasWindowColor;
        }

        private final Typeface $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getTypeface() {
            if (this.mParsedTypeface == null && !TextUtils.isEmpty(this.mRawTypeface)) {
                this.mParsedTypeface = Typeface.create(this.mRawTypeface, 0);
            }
            return this.mParsedTypeface;
        }

        private static final CaptionStyle $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getCustomStyle(ContentResolver cr) {
            CaptionStyle defStyle = DEFAULT_CUSTOM;
            int foregroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_foreground_color", defStyle.foregroundColor);
            int backgroundColor = Settings.Secure.getInt(cr, "accessibility_captioning_background_color", defStyle.backgroundColor);
            int edgeType = Settings.Secure.getInt(cr, "accessibility_captioning_edge_type", defStyle.edgeType);
            int edgeColor = Settings.Secure.getInt(cr, "accessibility_captioning_edge_color", defStyle.edgeColor);
            int windowColor = Settings.Secure.getInt(cr, "accessibility_captioning_window_color", defStyle.windowColor);
            String rawTypeface = Settings.Secure.getString(cr, "accessibility_captioning_typeface");
            if (rawTypeface == null) {
                rawTypeface = defStyle.mRawTypeface;
            }
            return new CaptionStyle(foregroundColor, backgroundColor, edgeType, edgeColor, windowColor, rawTypeface);
        }

        static void __staticInitializer__() {
            WHITE_ON_BLACK = new CaptionStyle(-1, -16777216, 0, -16777216, 255, null);
            BLACK_ON_WHITE = new CaptionStyle(-16777216, -1, 0, -16777216, 255, null);
            YELLOW_ON_BLACK = new CaptionStyle(-256, -16777216, 0, -16777216, 255, null);
            YELLOW_ON_BLUE = new CaptionStyle(-256, -16776961, 0, -16777216, 255, null);
            UNSPECIFIED = new CaptionStyle(511, 511, -1, 511, 511, null);
            PRESETS = new CaptionStyle[]{WHITE_ON_BLACK, BLACK_ON_WHITE, YELLOW_ON_BLACK, YELLOW_ON_BLUE, UNSPECIFIED};
            DEFAULT_CUSTOM = WHITE_ON_BLACK;
            DEFAULT = WHITE_ON_BLACK;
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2) {
            this.$$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(n, n2, n3, n4, n5, string2);
        }

        private CaptionStyle(int n, int n2, int n3, int n4, int n5, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$__constructor__(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
        }

        public CaptionStyle applyStyle(CaptionStyle captionStyle) {
            return InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$applyStyle(android.view.accessibility.CaptioningManager$CaptionStyle ), 0, this, captionStyle);
        }

        public boolean hasBackgroundColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasBackgroundColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasBackgroundColor(), 0, this);
        }

        public boolean hasForegroundColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasForegroundColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasForegroundColor(), 0, this);
        }

        public boolean hasEdgeType() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasEdgeType", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeType(), 0, this);
        }

        public boolean hasEdgeColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasEdgeColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasEdgeColor(), 0, this);
        }

        public boolean hasWindowColor() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasWindowColor", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$hasWindowColor(), 0, this);
        }

        public Typeface getTypeface() {
            return InvokeDynamicSupport.bootstrap("getTypeface", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getTypeface(), 0, this);
        }

        public static CaptionStyle getCustomStyle(ContentResolver contentResolver) {
            return InvokeDynamicSupport.bootstrapStatic("getCustomStyle", $$robo$$android_view_accessibility_CaptioningManager_CaptionStyle$getCustomStyle(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
        }

        static {
            RobolectricInternals.classInitializing(CaptionStyle.class);
        }

        public /* synthetic */ CaptionStyle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptionStyle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

