/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.R;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LayoutAnimationController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ORDER_NORMAL = 0;
    public static int ORDER_REVERSE = 1;
    public static int ORDER_RANDOM = 2;
    protected Animation mAnimation;
    protected Random mRandomizer;
    protected Interpolator mInterpolator;
    private float mDelay;
    private int mOrder;
    private long mDuration;
    private long mMaxDelay;

    private void $$robo$$android_view_animation_LayoutAnimationController$__constructor__(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LayoutAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(1));
        this.mDelay = d.value;
        this.mOrder = a.getInt(3, 0);
        int resource = a.getResourceId(2, 0);
        if (resource > 0) {
            this.setAnimation(context, resource);
        }
        if ((resource = a.getResourceId(0, 0)) > 0) {
            this.setInterpolator(context, resource);
        }
        a.recycle();
    }

    private void $$robo$$android_view_animation_LayoutAnimationController$__constructor__(Animation animation) {
    }

    private void $$robo$$android_view_animation_LayoutAnimationController$__constructor__(Animation animation, float delay) {
        this.mDelay = delay;
        this.setAnimation(animation);
    }

    private final int $$robo$$android_view_animation_LayoutAnimationController$getOrder() {
        return this.mOrder;
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setOrder(int order) {
        this.mOrder = order;
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setAnimation(Context context, int resourceID) {
        this.setAnimation(AnimationUtils.loadAnimation(context, resourceID));
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setAnimation(Animation animation) {
        this.mAnimation = animation;
        this.mAnimation.setFillBefore(true);
    }

    private final Animation $$robo$$android_view_animation_LayoutAnimationController$getAnimation() {
        return this.mAnimation;
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setInterpolator(Context context, int resourceID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resourceID));
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    private final Interpolator $$robo$$android_view_animation_LayoutAnimationController$getInterpolator() {
        return this.mInterpolator;
    }

    private final float $$robo$$android_view_animation_LayoutAnimationController$getDelay() {
        return this.mDelay;
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$setDelay(float delay) {
        this.mDelay = delay;
    }

    private final boolean $$robo$$android_view_animation_LayoutAnimationController$willOverlap() {
        return this.mDelay < 1.0f;
    }

    private final void $$robo$$android_view_animation_LayoutAnimationController$start() {
        this.mDuration = this.mAnimation.getDuration();
        this.mMaxDelay = Long.MIN_VALUE;
        this.mAnimation.setStartTime(-1L);
    }

    private final Animation $$robo$$android_view_animation_LayoutAnimationController$getAnimationForView(View view) {
        long delay = this.getDelayForView(view) + this.mAnimation.getStartOffset();
        this.mMaxDelay = Math.max(this.mMaxDelay, delay);
        try {
            Object animation = this.mAnimation.clone();
            ((Animation)animation).setStartOffset(delay);
            return animation;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private final boolean $$robo$$android_view_animation_LayoutAnimationController$isDone() {
        return AnimationUtils.currentAnimationTimeMillis() > this.mAnimation.getStartTime() + this.mMaxDelay + this.mDuration;
    }

    private final long $$robo$$android_view_animation_LayoutAnimationController$getDelayForView(View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        AnimationParameters params = lp.layoutAnimationParameters;
        if (params == null) {
            return 0L;
        }
        float delay = this.mDelay * (float)this.mAnimation.getDuration();
        long viewDelay = (long)((float)this.getTransformedIndex(params) * delay);
        float totalDelay = delay * (float)params.count;
        if (this.mInterpolator == null) {
            this.mInterpolator = new LinearInterpolator();
        }
        float normalizedDelay = (float)viewDelay / totalDelay;
        normalizedDelay = this.mInterpolator.getInterpolation(normalizedDelay);
        return (long)(normalizedDelay * totalDelay);
    }

    private final int $$robo$$android_view_animation_LayoutAnimationController$getTransformedIndex(AnimationParameters params) {
        switch (this.getOrder()) {
            case 1: {
                return params.count - 1 - params.index;
            }
            case 2: {
                if (this.mRandomizer == null) {
                    this.mRandomizer = new Random();
                }
                return (int)((float)params.count * this.mRandomizer.nextFloat());
            }
        }
        return params.index;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_LayoutAnimationController$__constructor__(context, attributeSet);
    }

    public LayoutAnimationController(Context context, AttributeSet attributeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_LayoutAnimationController$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Animation animation) {
        this.$$robo$$android_view_animation_LayoutAnimationController$__constructor__(animation);
    }

    public LayoutAnimationController(Animation animation) {
        this(animation, 0.5f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_LayoutAnimationController$__constructor__(android.view.animation.Animation ), 0, this, animation);
    }

    private void __constructor__(Animation animation, float f) {
        this.$$robo$$android_view_animation_LayoutAnimationController$__constructor__(animation, f);
    }

    public LayoutAnimationController(Animation animation, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_LayoutAnimationController$__constructor__(android.view.animation.Animation float ), 0, this, animation, f);
    }

    public int getOrder() {
        return (int)InvokeDynamicSupport.bootstrap("getOrder", $$robo$$android_view_animation_LayoutAnimationController$getOrder(), 0, this);
    }

    public void setOrder(int n) {
        InvokeDynamicSupport.bootstrap("setOrder", $$robo$$android_view_animation_LayoutAnimationController$setOrder(int ), 0, this, n);
    }

    public void setAnimation(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setAnimation", $$robo$$android_view_animation_LayoutAnimationController$setAnimation(android.content.Context int ), 0, this, context, n);
    }

    public void setAnimation(Animation animation) {
        InvokeDynamicSupport.bootstrap("setAnimation", $$robo$$android_view_animation_LayoutAnimationController$setAnimation(android.view.animation.Animation ), 0, this, animation);
    }

    public Animation getAnimation() {
        return InvokeDynamicSupport.bootstrap("getAnimation", $$robo$$android_view_animation_LayoutAnimationController$getAnimation(), 0, this);
    }

    public void setInterpolator(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_view_animation_LayoutAnimationController$setInterpolator(android.content.Context int ), 0, this, context, n);
    }

    public void setInterpolator(Interpolator interpolator2) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_view_animation_LayoutAnimationController$setInterpolator(android.view.animation.Interpolator ), 0, this, interpolator2);
    }

    public Interpolator getInterpolator() {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_view_animation_LayoutAnimationController$getInterpolator(), 0, this);
    }

    public float getDelay() {
        return (float)InvokeDynamicSupport.bootstrap("getDelay", $$robo$$android_view_animation_LayoutAnimationController$getDelay(), 0, this);
    }

    public void setDelay(float f) {
        InvokeDynamicSupport.bootstrap("setDelay", $$robo$$android_view_animation_LayoutAnimationController$setDelay(float ), 0, this, f);
    }

    public boolean willOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("willOverlap", $$robo$$android_view_animation_LayoutAnimationController$willOverlap(), 0, this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_view_animation_LayoutAnimationController$start(), 0, this);
    }

    public Animation getAnimationForView(View view) {
        return InvokeDynamicSupport.bootstrap("getAnimationForView", $$robo$$android_view_animation_LayoutAnimationController$getAnimationForView(android.view.View ), 0, this, view);
    }

    public boolean isDone() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDone", $$robo$$android_view_animation_LayoutAnimationController$isDone(), 0, this);
    }

    protected long getDelayForView(View view) {
        return (long)InvokeDynamicSupport.bootstrap("getDelayForView", $$robo$$android_view_animation_LayoutAnimationController$getDelayForView(android.view.View ), 0, this, view);
    }

    protected int getTransformedIndex(AnimationParameters animationParameters) {
        return (int)InvokeDynamicSupport.bootstrap("getTransformedIndex", $$robo$$android_view_animation_LayoutAnimationController$getTransformedIndex(android.view.animation.LayoutAnimationController$AnimationParameters ), 0, this, animationParameters);
    }

    public /* synthetic */ LayoutAnimationController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutAnimationController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AnimationParameters
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int count;
        public int index;

        private void $$robo$$android_view_animation_LayoutAnimationController_AnimationParameters$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_view_animation_LayoutAnimationController_AnimationParameters$__constructor__();
        }

        public AnimationParameters() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_LayoutAnimationController_AnimationParameters$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationParameters)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

