/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.PathParser;
import android.view.InflateException;
import android.view.animation.Interpolator;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PathInterpolator
implements Interpolator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float PRECISION = 0.002f;
    private float[] mX;
    private float[] mY;

    private void $$robo$$android_view_animation_PathInterpolator$__constructor__(Path path) {
        this.initPath(path);
    }

    private void $$robo$$android_view_animation_PathInterpolator$__constructor__(float controlX, float controlY) {
        this.initQuad(controlX, controlY);
    }

    private void $$robo$$android_view_animation_PathInterpolator$__constructor__(float controlX1, float controlY1, float controlX2, float controlY2) {
        this.initCubic(controlX1, controlY1, controlX2, controlY2);
    }

    private void $$robo$$android_view_animation_PathInterpolator$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_view_animation_PathInterpolator$__constructor__(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.PathInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.PathInterpolator);
        this.parseInterpolatorFromTypeArray(a);
        a.recycle();
    }

    private final void $$robo$$android_view_animation_PathInterpolator$parseInterpolatorFromTypeArray(TypedArray a) {
        if (a.hasValue(4)) {
            String pathData = a.getString(4);
            Path path = PathParser.createPathFromPathData(pathData);
            if (path == null) {
                throw new InflateException("The path is null, which is created from " + pathData);
            }
            this.initPath(path);
        } else {
            boolean hasY2;
            if (!a.hasValue(0)) {
                throw new InflateException("pathInterpolator requires the controlX1 attribute");
            }
            if (!a.hasValue(1)) {
                throw new InflateException("pathInterpolator requires the controlY1 attribute");
            }
            float x1 = a.getFloat(0, 0.0f);
            float y1 = a.getFloat(1, 0.0f);
            boolean hasX2 = a.hasValue(2);
            if (hasX2 != (hasY2 = a.hasValue(3))) {
                throw new InflateException("pathInterpolator requires both controlX2 and controlY2 for cubic Beziers.");
            }
            if (!hasX2) {
                this.initQuad(x1, y1);
            } else {
                float x2 = a.getFloat(2, 0.0f);
                float y2 = a.getFloat(3, 0.0f);
                this.initCubic(x1, y1, x2, y2);
            }
        }
    }

    private final void $$robo$$android_view_animation_PathInterpolator$initQuad(float controlX, float controlY) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(controlX, controlY, 1.0f, 1.0f);
        this.initPath(path);
    }

    private final void $$robo$$android_view_animation_PathInterpolator$initCubic(float x1, float y1, float x2, float y2) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(x1, y1, x2, y2, 1.0f, 1.0f);
        this.initPath(path);
    }

    private final void $$robo$$android_view_animation_PathInterpolator$initPath(Path path) {
        float[] pointComponents = path.approximate(0.002f);
        int numPoints = pointComponents.length / 3;
        if (pointComponents[1] != 0.0f || pointComponents[2] != 0.0f || pointComponents[pointComponents.length - 2] != 1.0f || pointComponents[pointComponents.length - 1] != 1.0f) {
            throw new IllegalArgumentException("The Path must start at (0,0) and end at (1,1)");
        }
        this.mX = new float[numPoints];
        this.mY = new float[numPoints];
        float prevX = 0.0f;
        float prevFraction = 0.0f;
        int componentIndex = 0;
        for (int i = 0; i < numPoints; ++i) {
            float fraction2 = pointComponents[componentIndex++];
            float x = pointComponents[componentIndex++];
            float y = pointComponents[componentIndex++];
            if (fraction2 == prevFraction && x != prevX) {
                throw new IllegalArgumentException("The Path cannot have discontinuity in the X axis.");
            }
            if (x < prevX) {
                throw new IllegalArgumentException("The Path cannot loop back on itself.");
            }
            this.mX[i] = x;
            this.mY[i] = y;
            prevX = x;
            prevFraction = fraction2;
        }
    }

    private final float $$robo$$android_view_animation_PathInterpolator$getInterpolation(float t) {
        if (t <= 0.0f) {
            return 0.0f;
        }
        if (t >= 1.0f) {
            return 1.0f;
        }
        int startIndex = 0;
        int endIndex = this.mX.length - 1;
        while (endIndex - startIndex > 1) {
            int midIndex = (startIndex + endIndex) / 2;
            if (t < this.mX[midIndex]) {
                endIndex = midIndex;
                continue;
            }
            startIndex = midIndex;
        }
        float xRange = this.mX[endIndex] - this.mX[startIndex];
        if (xRange == 0.0f) {
            return this.mY[startIndex];
        }
        float tInRange = t - this.mX[startIndex];
        float fraction2 = tInRange / xRange;
        float startY = this.mY[startIndex];
        float endY = this.mY[endIndex];
        return startY + fraction2 * (endY - startY);
    }

    private void __constructor__(Path path) {
        this.$$robo$$android_view_animation_PathInterpolator$__constructor__(path);
    }

    public PathInterpolator(Path path) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_PathInterpolator$__constructor__(android.graphics.Path ), 0, this, path);
    }

    private void __constructor__(float f, float f2) {
        this.$$robo$$android_view_animation_PathInterpolator$__constructor__(f, f2);
    }

    public PathInterpolator(float f, float f2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_PathInterpolator$__constructor__(float float ), 0, this, f, f2);
    }

    private void __constructor__(float f, float f2, float f3, float f4) {
        this.$$robo$$android_view_animation_PathInterpolator$__constructor__(f, f2, f3, f4);
    }

    public PathInterpolator(float f, float f2, float f3, float f4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_PathInterpolator$__constructor__(float float float float ), 0, this, f, f2, f3, f4);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_PathInterpolator$__constructor__(context, attributeSet);
    }

    public PathInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_PathInterpolator$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        this.$$robo$$android_view_animation_PathInterpolator$__constructor__(resources, theme, attributeSet);
    }

    public PathInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_PathInterpolator$__constructor__(android.content.res.Resources android.content.res.Resources$Theme android.util.AttributeSet ), 0, this, resources, theme, attributeSet);
    }

    private void parseInterpolatorFromTypeArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("parseInterpolatorFromTypeArray", $$robo$$android_view_animation_PathInterpolator$parseInterpolatorFromTypeArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void initQuad(float f, float f2) {
        InvokeDynamicSupport.bootstrap("initQuad", $$robo$$android_view_animation_PathInterpolator$initQuad(float float ), 0, this, f, f2);
    }

    private void initCubic(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("initCubic", $$robo$$android_view_animation_PathInterpolator$initCubic(float float float float ), 0, this, f, f2, f3, f4);
    }

    private void initPath(Path path) {
        InvokeDynamicSupport.bootstrap("initPath", $$robo$$android_view_animation_PathInterpolator$initPath(android.graphics.Path ), 0, this, path);
    }

    @Override
    public float getInterpolation(float f) {
        return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_view_animation_PathInterpolator$getInterpolation(float ), 0, this, f);
    }

    public /* synthetic */ PathInterpolator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PathInterpolator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

