/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Parcel;
import android.util.Slog;
import android.view.inputmethod.InputMethodSubtype;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputMethodSubtypeArray
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputMethodSubtypeArray";
    private Object mLockObject;
    private int mCount;
    private volatile InputMethodSubtype[] mInstance;
    private volatile byte[] mCompressedData;
    private volatile int mDecompressedSize;

    private void $$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(List<InputMethodSubtype> subtypes) {
        this.mLockObject = new Object();
        if (subtypes == null) {
            this.mCount = 0;
            return;
        }
        this.mCount = subtypes.size();
        this.mInstance = subtypes.toArray(new InputMethodSubtype[this.mCount]);
    }

    private void $$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(Parcel source) {
        this.mLockObject = new Object();
        this.mCount = source.readInt();
        if (this.mCount > 0) {
            this.mDecompressedSize = source.readInt();
            this.mCompressedData = source.createByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_inputmethod_InputMethodSubtypeArray$writeToParcel(Parcel dest) {
        if (this.mCount == 0) {
            dest.writeInt(this.mCount);
            return;
        }
        byte[] compressedData = this.mCompressedData;
        int decompressedSize = this.mDecompressedSize;
        if (compressedData == null && decompressedSize == 0) {
            Object object = this.mLockObject;
            synchronized (object) {
                compressedData = this.mCompressedData;
                decompressedSize = this.mDecompressedSize;
                if (compressedData == null && decompressedSize == 0) {
                    byte[] decompressedData = InputMethodSubtypeArray.marshall(this.mInstance);
                    compressedData = InputMethodSubtypeArray.compress(decompressedData);
                    if (compressedData == null) {
                        decompressedSize = -1;
                        Slog.i("InputMethodSubtypeArray", "Failed to compress data.");
                    } else {
                        decompressedSize = decompressedData.length;
                    }
                    this.mDecompressedSize = decompressedSize;
                    this.mCompressedData = compressedData;
                }
            }
        }
        if (compressedData != null && decompressedSize > 0) {
            dest.writeInt(this.mCount);
            dest.writeInt(decompressedSize);
            dest.writeByteArray(compressedData);
        } else {
            Slog.i("InputMethodSubtypeArray", "Unexpected state. Behaving as an empty array.");
            dest.writeInt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputMethodSubtype $$robo$$android_view_inputmethod_InputMethodSubtypeArray$get(int index) {
        if (index < 0 || this.mCount <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        InputMethodSubtype[] instance = this.mInstance;
        if (instance == null) {
            Object object = this.mLockObject;
            synchronized (object) {
                instance = this.mInstance;
                if (instance == null) {
                    byte[] decompressedData = InputMethodSubtypeArray.decompress(this.mCompressedData, this.mDecompressedSize);
                    this.mCompressedData = null;
                    this.mDecompressedSize = 0;
                    if (decompressedData != null) {
                        instance = InputMethodSubtypeArray.unmarshall(decompressedData);
                    } else {
                        Slog.e("InputMethodSubtypeArray", "Failed to decompress data. Returns null as fallback.");
                        instance = new InputMethodSubtype[this.mCount];
                    }
                    this.mInstance = instance;
                }
            }
        }
        return instance[index];
    }

    private final int $$robo$$android_view_inputmethod_InputMethodSubtypeArray$getCount() {
        return this.mCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] $$robo$$android_view_inputmethod_InputMethodSubtypeArray$marshall(InputMethodSubtype[] array2) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.writeTypedArray(array2, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
                parcel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputMethodSubtype[] $$robo$$android_view_inputmethod_InputMethodSubtypeArray$unmarshall(byte[] data) {
        Parcel parcel = null;
        try {
            parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            InputMethodSubtype[] inputMethodSubtypeArray = parcel.createTypedArray(InputMethodSubtype.CREATOR);
            return inputMethodSubtypeArray;
        }
        finally {
            if (parcel != null) {
                parcel.recycle();
                parcel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] $$robo$$android_view_inputmethod_InputMethodSubtypeArray$compress(byte[] data) {
        ByteArrayOutputStream resultStream = null;
        DeflaterOutputStream zipper = null;
        try {
            resultStream = new ByteArrayOutputStream();
            zipper = new GZIPOutputStream(resultStream);
            zipper.write(data);
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (zipper != null) {
                    zipper.close();
                }
            }
            catch (IOException e) {
                zipper = null;
                Slog.e("InputMethodSubtypeArray", "Failed to close the stream.", e);
            }
            try {
                if (resultStream != null) {
                    resultStream.close();
                }
            }
            catch (IOException e) {
                resultStream = null;
                Slog.e("InputMethodSubtypeArray", "Failed to close the stream.", e);
            }
        }
        return resultStream != null ? resultStream.toByteArray() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] $$robo$$android_view_inputmethod_InputMethodSubtypeArray$decompress(byte[] data, int expectedSize) {
        ByteArrayInputStream inputStream = null;
        GZIPInputStream unzipper = null;
        try {
            int restBytes2;
            int totalReadBytes;
            int readBytes;
            inputStream = new ByteArrayInputStream(data);
            unzipper = new GZIPInputStream(inputStream);
            byte[] result = new byte[expectedSize];
            for (totalReadBytes = 0; totalReadBytes < result.length && (readBytes = unzipper.read(result, totalReadBytes, restBytes2 = result.length - totalReadBytes)) >= 0; totalReadBytes += readBytes) {
            }
            if (expectedSize != totalReadBytes) {
                byte[] restBytes2 = null;
                return restBytes2;
            }
            byte[] restBytes2 = result;
            return restBytes2;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (unzipper != null) {
                    unzipper.close();
                }
            }
            catch (IOException e) {
                Slog.e("InputMethodSubtypeArray", "Failed to close the stream.", e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Slog.e("InputMethodSubtypeArray", "Failed to close the stream.", e);
            }
        }
    }

    private void __constructor__(List<InputMethodSubtype> list) {
        this.$$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(list);
    }

    public InputMethodSubtypeArray(List<InputMethodSubtype> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(java.util.List<android.view.inputmethod.InputMethodSubtype> ), 0, this, list);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(parcel);
    }

    public InputMethodSubtypeArray(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public void writeToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$writeToParcel(android.os.Parcel ), 0, this, parcel);
    }

    public InputMethodSubtype get(int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$get(int ), 0, this, n);
    }

    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$getCount(), 0, this);
    }

    private static byte[] marshall(InputMethodSubtype[] inputMethodSubtypeArray) {
        return InvokeDynamicSupport.bootstrapStatic("marshall", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$marshall(android.view.inputmethod.InputMethodSubtype[] ), 0, (InputMethodSubtype[])inputMethodSubtypeArray);
    }

    private static InputMethodSubtype[] unmarshall(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("unmarshall", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$unmarshall(byte[] ), 0, (byte[])byArray);
    }

    private static byte[] compress(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("compress", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$compress(byte[] ), 0, (byte[])byArray);
    }

    private static byte[] decompress(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("decompress", $$robo$$android_view_inputmethod_InputMethodSubtypeArray$decompress(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    public /* synthetic */ InputMethodSubtypeArray() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSubtypeArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

