/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.webkit.MimeTypeMap;
import com.google.errorprone.annotations.DoNotMock;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class URLUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "webkit";
    static String ASSET_BASE = "file:///android_asset/";
    static String RESOURCE_BASE = "file:///android_res/";
    static String FILE_BASE = "file://";
    static String PROXY_BASE = "file:///cookieless_proxy/";
    static String CONTENT_BASE = "content:";
    private static Pattern CONTENT_DISPOSITION_PATTERN;

    private void $$robo$$android_webkit_URLUtil$__constructor__() {
    }

    private static final String $$robo$$android_webkit_URLUtil$guessUrl(String inUrl) {
        WebAddress webAddress;
        String retVal = inUrl;
        if (inUrl.length() == 0) {
            return inUrl;
        }
        if (inUrl.startsWith("about:")) {
            return inUrl;
        }
        if (inUrl.startsWith("data:")) {
            return inUrl;
        }
        if (inUrl.startsWith("file:")) {
            return inUrl;
        }
        if (inUrl.startsWith("javascript:")) {
            return inUrl;
        }
        if (inUrl.endsWith(".")) {
            inUrl = inUrl.substring(0, inUrl.length() - 1);
        }
        try {
            webAddress = new WebAddress(inUrl);
        }
        catch (ParseException ex) {
            return retVal;
        }
        if (webAddress.getHost().indexOf(46) == -1) {
            webAddress.setHost("www." + webAddress.getHost() + ".com");
        }
        return webAddress.toString();
    }

    private static final String $$robo$$android_webkit_URLUtil$composeSearchUrl(String inQuery, String template, String queryPlaceHolder) {
        int placeHolderIndex = template.indexOf(queryPlaceHolder);
        if (placeHolderIndex < 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(template.substring(0, placeHolderIndex));
        try {
            String query = URLEncoder.encode(inQuery, "utf-8");
            buffer.append(query);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        buffer.append(template.substring(placeHolderIndex + queryPlaceHolder.length()));
        return buffer.toString();
    }

    private static final byte[] $$robo$$android_webkit_URLUtil$decode(byte[] url) throws IllegalArgumentException {
        if (url.length == 0) {
            return new byte[0];
        }
        byte[] tempData = new byte[url.length];
        int tempCount = 0;
        for (int i = 0; i < url.length; ++i) {
            byte b = url[i];
            if (b == 37) {
                if (url.length - i > 2) {
                    b = (byte)(URLUtil.parseHex(url[i + 1]) * 16 + URLUtil.parseHex(url[i + 2]));
                    i += 2;
                } else {
                    throw new IllegalArgumentException("Invalid format");
                }
            }
            tempData[tempCount++] = b;
        }
        byte[] retData = new byte[tempCount];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])tempData, (int)0, (byte[])retData, (int)0, (int)tempCount);
        return retData;
    }

    private static final boolean $$robo$$android_webkit_URLUtil$verifyURLEncoding(String url) {
        int count = url.length();
        if (count == 0) {
            return false;
        }
        int index = url.indexOf(37);
        while (index >= 0 && index < count) {
            if (index < count - 2) {
                try {
                    URLUtil.parseHex((byte)url.charAt(++index));
                    URLUtil.parseHex((byte)url.charAt(++index));
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            } else {
                return false;
            }
            index = url.indexOf(37, index + 1);
        }
        return true;
    }

    private static final int $$robo$$android_webkit_URLUtil$parseHex(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 65 + 10;
        }
        if (b >= 97 && b <= 102) {
            return b - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char '" + b + "'");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isAssetUrl(String url) {
        return null != url && url.startsWith("file:///android_asset/");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isResourceUrl(String url) {
        return null != url && url.startsWith("file:///android_res/");
    }

    @Deprecated
    private static final boolean $$robo$$android_webkit_URLUtil$isCookielessProxyUrl(String url) {
        return null != url && url.startsWith("file:///cookieless_proxy/");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isFileUrl(String url) {
        return null != url && url.startsWith("file://") && !url.startsWith("file:///android_asset/") && !url.startsWith("file:///cookieless_proxy/");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isAboutUrl(String url) {
        return null != url && url.startsWith("about:");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isDataUrl(String url) {
        return null != url && url.startsWith("data:");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isJavaScriptUrl(String url) {
        return null != url && url.startsWith("javascript:");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isHttpUrl(String url) {
        return null != url && url.length() > 6 && url.substring(0, 7).equalsIgnoreCase("http://");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isHttpsUrl(String url) {
        return null != url && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isNetworkUrl(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return URLUtil.isHttpUrl(url) || URLUtil.isHttpsUrl(url);
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isContentUrl(String url) {
        return null != url && url.startsWith("content:");
    }

    private static final boolean $$robo$$android_webkit_URLUtil$isValidUrl(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return URLUtil.isAssetUrl(url) || URLUtil.isResourceUrl(url) || URLUtil.isFileUrl(url) || URLUtil.isAboutUrl(url) || URLUtil.isHttpUrl(url) || URLUtil.isHttpsUrl(url) || URLUtil.isJavaScriptUrl(url) || URLUtil.isContentUrl(url);
    }

    private static final String $$robo$$android_webkit_URLUtil$stripAnchor(String url) {
        int anchorIndex = url.indexOf(35);
        if (anchorIndex != -1) {
            return url.substring(0, anchorIndex);
        }
        return url;
    }

    private static final String $$robo$$android_webkit_URLUtil$guessFileName(String url, String contentDisposition, String mimeType) {
        int dotIndex;
        String decodedUrl;
        int index;
        String filename = null;
        String extension = null;
        if (filename == null && contentDisposition != null && (filename = URLUtil.parseContentDisposition(contentDisposition)) != null && (index = filename.lastIndexOf(47) + 1) > 0) {
            filename = filename.substring(index);
        }
        if (filename == null && (decodedUrl = Uri.decode(url)) != null) {
            int index2;
            int queryIndex = decodedUrl.indexOf(63);
            if (queryIndex > 0) {
                decodedUrl = decodedUrl.substring(0, queryIndex);
            }
            if (!decodedUrl.endsWith("/") && (index2 = decodedUrl.lastIndexOf(47) + 1) > 0) {
                filename = decodedUrl.substring(index2);
            }
        }
        if (filename == null) {
            filename = "downloadfile";
        }
        if ((dotIndex = filename.indexOf(46)) < 0) {
            if (mimeType != null && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                extension = "." + extension;
            }
            if (extension == null) {
                extension = mimeType != null && mimeType.toLowerCase(Locale.ROOT).startsWith("text/") ? (mimeType.equalsIgnoreCase("text/html") ? ".html" : ".txt") : ".bin";
            }
        } else {
            if (mimeType != null) {
                int lastDotIndex = filename.lastIndexOf(46);
                String typeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(filename.substring(lastDotIndex + 1));
                if (typeFromExt != null && !typeFromExt.equalsIgnoreCase(mimeType) && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                    extension = "." + extension;
                }
            }
            if (extension == null) {
                extension = filename.substring(dotIndex);
            }
            filename = filename.substring(0, dotIndex);
        }
        return filename + extension;
    }

    private static final String $$robo$$android_webkit_URLUtil$parseContentDisposition(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    static void __staticInitializer__() {
        CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*(\"?)([^\"]*)\\1\\s*$", 2);
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_URLUtil$__constructor__();
    }

    public URLUtil() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_URLUtil$__constructor__(), 0, this);
    }

    public static String guessUrl(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("guessUrl", $$robo$$android_webkit_URLUtil$guessUrl(java.lang.String ), 0, (String)string2);
    }

    public static String composeSearchUrl(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("composeSearchUrl", $$robo$$android_webkit_URLUtil$composeSearchUrl(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static byte[] decode(byte[] byArray) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$android_webkit_URLUtil$decode(byte[] ), 0, (byte[])byArray);
    }

    static boolean verifyURLEncoding(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyURLEncoding", $$robo$$android_webkit_URLUtil$verifyURLEncoding(java.lang.String ), 0, (String)string2);
    }

    private static int parseHex(byte by) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseHex", $$robo$$android_webkit_URLUtil$parseHex(byte ), 0, (byte)by);
    }

    public static boolean isAssetUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAssetUrl", $$robo$$android_webkit_URLUtil$isAssetUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isResourceUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isResourceUrl", $$robo$$android_webkit_URLUtil$isResourceUrl(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static boolean isCookielessProxyUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCookielessProxyUrl", $$robo$$android_webkit_URLUtil$isCookielessProxyUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isFileUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFileUrl", $$robo$$android_webkit_URLUtil$isFileUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isAboutUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAboutUrl", $$robo$$android_webkit_URLUtil$isAboutUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isDataUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDataUrl", $$robo$$android_webkit_URLUtil$isDataUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isJavaScriptUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJavaScriptUrl", $$robo$$android_webkit_URLUtil$isJavaScriptUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isHttpUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHttpUrl", $$robo$$android_webkit_URLUtil$isHttpUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isHttpsUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHttpsUrl", $$robo$$android_webkit_URLUtil$isHttpsUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isNetworkUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNetworkUrl", $$robo$$android_webkit_URLUtil$isNetworkUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isContentUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isContentUrl", $$robo$$android_webkit_URLUtil$isContentUrl(java.lang.String ), 0, (String)string2);
    }

    public static boolean isValidUrl(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidUrl", $$robo$$android_webkit_URLUtil$isValidUrl(java.lang.String ), 0, (String)string2);
    }

    public static String stripAnchor(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("stripAnchor", $$robo$$android_webkit_URLUtil$stripAnchor(java.lang.String ), 0, (String)string2);
    }

    public static String guessFileName(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("guessFileName", $$robo$$android_webkit_URLUtil$guessFileName(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    static String parseContentDisposition(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseContentDisposition", $$robo$$android_webkit_URLUtil$parseContentDisposition(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(URLUtil.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (URLUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

