/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewFactoryProvider;
import com.android.server.LocalServices;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.File;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class WebViewFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    public static String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static String LOGTAG = "WebViewFactory";
    private static boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static Object sProviderLock;
    private static boolean sAddressSpaceReserved;
    private static PackageInfo sPackageInfo;

    private void $$robo$$android_webkit_WebViewFactory$__constructor__() {
    }

    private static final String $$robo$$android_webkit_WebViewFactory$getWebViewPackageName() {
        return AppGlobals.getInitialApplication().getString(17039430);
    }

    private static final PackageInfo $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo() {
        return sPackageInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static final WebViewFactoryProvider $$robo$$android_webkit_WebViewFactory$getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass;
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewFactory.loadNativeLibrary();
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "WebViewFactory.getFactoryClass()");
                try {
                    providerClass = WebViewFactory.getFactoryClass();
                }
                catch (ClassNotFoundException e) {
                    Log.e("WebViewFactory", "error loading provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                }
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                Trace.traceBegin(16L, "providerClass.newInstance()");
                try {
                    webViewFactoryProvider = sProviderInstance = providerClass.newInstance();
                }
                catch (Exception e) {
                    Log.e("WebViewFactory", "error instantiating provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                    StrictMode.setThreadPolicy(oldPolicy);
                }
                return webViewFactoryProvider;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class<WebViewFactoryProvider> $$robo$$android_webkit_WebViewFactory$getFactoryClass() throws ClassNotFoundException {
        Class<WebViewFactoryProvider> clazz;
        Application initialApplication = AppGlobals.getInitialApplication();
        String packageName = WebViewFactory.getWebViewPackageName();
        sPackageInfo = initialApplication.getPackageManager().getPackageInfo(packageName, 0);
        Log.i("WebViewFactory", "Loading " + packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
        Context webViewContext = initialApplication.createPackageContext(packageName, 3);
        initialApplication.getAssets().addAssetPath(webViewContext.getApplicationInfo().sourceDir);
        ClassLoader clazzLoader = webViewContext.getClassLoader();
        Trace.traceBegin(16L, "Class.forName()");
        try {
            clazz = Class.forName("com.android.webview.chromium.WebViewChromiumFactoryProvider", true, clazzLoader);
        }
        catch (Throwable throwable) {
            try {
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException e) {
                try {
                    return Class.forName("com.android.webview.nullwebview.NullWebViewFactoryProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Log.e("WebViewFactory", "Chromium WebView package does not exist", e);
                    throw new AndroidRuntimeException(e);
                }
            }
        }
        Trace.traceEnd(16L);
        return clazz;
    }

    private static final void $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote() {
        try {
            InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"webviewchromium_loader");
            long addressSpaceToReserve = SystemProperties.getLong("persist.sys.webview.vmsize", 0x6400000L);
            sAddressSpaceReserved = WebViewFactory.nativeReserveAddressSpace(addressSpaceToReserve);
            if (!sAddressSpaceReserved) {
                Log.e("WebViewFactory", "reserving " + addressSpaceToReserve + " bytes of address space failed");
            }
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing native loader", t);
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer() {
        String[] nativePaths = null;
        try {
            nativePaths = WebViewFactory.getWebViewNativeLibraryPaths();
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing webview native library", t);
        }
        WebViewFactory.prepareWebViewInSystemServer(nativePaths);
    }

    private static final void $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(String[] nativeLibraryPaths) {
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(false, nativeLibraryPaths);
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(true, nativeLibraryPaths);
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$onWebViewUpdateInstalled() {
        String[] nativeLibs = null;
        try {
            nativeLibs = WebViewFactory.getWebViewNativeLibraryPaths();
            if (nativeLibs != null) {
                long newVmSize = 0L;
                for (String path : nativeLibs) {
                    long length;
                    File f;
                    if (path == null || !(f = new File(path)).exists() || (length = f.length()) <= newVmSize) continue;
                    newVmSize = length;
                }
                newVmSize = Math.max(2L * newVmSize, 0x6400000L);
                Log.d("WebViewFactory", "Setting new address space to " + newVmSize);
                SystemProperties.set("persist.sys.webview.vmsize", Long.toString(newVmSize));
            }
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error preparing webview native library", t);
        }
        WebViewFactory.prepareWebViewInSystemServer(nativeLibs);
    }

    private static final String[] $$robo$$android_webkit_WebViewFactory$getWebViewNativeLibraryPaths() throws PackageManager.NameNotFoundException {
        String path32;
        String path64;
        String NATIVE_LIB_FILE_NAME = "libwebviewchromium.so";
        PackageManager pm = AppGlobals.getInitialApplication().getPackageManager();
        ApplicationInfo ai = pm.getApplicationInfo(WebViewFactory.getWebViewPackageName(), 0);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi(ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32)) {
            path32 = path32 + "/libwebviewchromium.so";
        }
        if (!TextUtils.isEmpty(path64)) {
            path64 = path64 + "/libwebviewchromium.so";
        }
        return new String[]{path32, path64};
    }

    private static final void $$robo$$android_webkit_WebViewFactory$createRelroFile(boolean is64Bit, String[] nativeLibraryPaths) {
        String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(abi, is64Bit){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$abi;
            /* synthetic */ boolean val$is64Bit;

            private void $$robo$$android_webkit_WebViewFactory_1$__constructor__(String string2, boolean bl) {
            }

            private final void $$robo$$android_webkit_WebViewFactory_1$run() {
                try {
                    Log.e("WebViewFactory", "relro file creator for " + this.val$abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(this.val$is64Bit, false);
                }
                catch (RemoteException e) {
                    Log.e("WebViewFactory", "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }

            private void __constructor__(String string2, boolean bl) {
                this.$$robo$$android_webkit_WebViewFactory_1$__constructor__(string2, bl);
            }
            {
                this.val$abi = string2;
                this.val$is64Bit = bl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_1$__constructor__(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_webkit_WebViewFactory_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e("WebViewFactory", "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static final void $$robo$$android_webkit_WebViewFactory$loadNativeLibrary() {
        if (!sAddressSpaceReserved) {
            Log.e("WebViewFactory", "can't load with relro file; address space not reserved");
            return;
        }
        try {
            WebViewFactory.getUpdateService().waitForRelroCreationCompleted(VMRuntime.getRuntime().is64Bit());
        }
        catch (RemoteException e) {
            Log.e("WebViewFactory", "error waiting for relro creation, proceeding without", e);
            return;
        }
        try {
            String[] args = WebViewFactory.getWebViewNativeLibraryPaths();
            boolean result = WebViewFactory.nativeLoadWithRelroFile(args[0], args[1], "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro");
            if (!result) {
                Log.w("WebViewFactory", "failed to load with relro file, proceeding without");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("WebViewFactory", "Failed to list WebView package libraries for loadNativeLibrary", e);
        }
    }

    private static final IWebViewUpdateService $$robo$$android_webkit_WebViewFactory$getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService("webviewupdate"));
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$nativeReserveAddressSpace(long l) {
        return false;
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return false;
    }

    private static final boolean $$robo$$android_webkit_WebViewFactory$nativeLoadWithRelroFile(String string2, String string3, String string4, String string5) {
        return false;
    }

    static void __staticInitializer__() {
        sProviderLock = new Object();
        sAddressSpaceReserved = false;
    }

    private void __constructor__() {
        this.$$robo$$android_webkit_WebViewFactory$__constructor__();
    }

    public WebViewFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory$__constructor__(), 0, this);
    }

    public static String getWebViewPackageName() {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewPackageName", $$robo$$android_webkit_WebViewFactory$getWebViewPackageName(), 0);
    }

    public static PackageInfo getLoadedPackageInfo() {
        return InvokeDynamicSupport.bootstrapStatic("getLoadedPackageInfo", $$robo$$android_webkit_WebViewFactory$getLoadedPackageInfo(), 0);
    }

    static WebViewFactoryProvider getProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getProvider", $$robo$$android_webkit_WebViewFactory$getProvider(), 0);
    }

    private static Class<WebViewFactoryProvider> getFactoryClass() throws ClassNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getFactoryClass", $$robo$$android_webkit_WebViewFactory$getFactoryClass(), 0);
    }

    public static void prepareWebViewInZygote() {
        InvokeDynamicSupport.bootstrapStatic("prepareWebViewInZygote", $$robo$$android_webkit_WebViewFactory$prepareWebViewInZygote(), 0);
    }

    public static void prepareWebViewInSystemServer() {
        InvokeDynamicSupport.bootstrapStatic("prepareWebViewInSystemServer", $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(), 0);
    }

    private static void prepareWebViewInSystemServer(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("prepareWebViewInSystemServer", $$robo$$android_webkit_WebViewFactory$prepareWebViewInSystemServer(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static void onWebViewUpdateInstalled() {
        InvokeDynamicSupport.bootstrapStatic("onWebViewUpdateInstalled", $$robo$$android_webkit_WebViewFactory$onWebViewUpdateInstalled(), 0);
    }

    private static String[] getWebViewNativeLibraryPaths() throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getWebViewNativeLibraryPaths", $$robo$$android_webkit_WebViewFactory$getWebViewNativeLibraryPaths(), 0);
    }

    private static void createRelroFile(boolean bl, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("createRelroFile", $$robo$$android_webkit_WebViewFactory$createRelroFile(boolean java.lang.String[] ), 0, (boolean)bl, (String[])stringArray);
    }

    private static void loadNativeLibrary() {
        InvokeDynamicSupport.bootstrapStatic("loadNativeLibrary", $$robo$$android_webkit_WebViewFactory$loadNativeLibrary(), 0);
    }

    private static IWebViewUpdateService getUpdateService() {
        return InvokeDynamicSupport.bootstrapStatic("getUpdateService", $$robo$$android_webkit_WebViewFactory$getUpdateService(), 0);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeReserveAddressSpace$nativeBinding(long var0);

    private static boolean nativeReserveAddressSpace(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeReserveAddressSpace", $$robo$$android_webkit_WebViewFactory$nativeReserveAddressSpace(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeCreateRelroFile$nativeBinding(String var0, String var1, String var2, String var3);

    private static boolean nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeCreateRelroFile", $$robo$$android_webkit_WebViewFactory$nativeCreateRelroFile(java.lang.String java.lang.String java.lang.String java.lang.String ), 1, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeLoadWithRelroFile$nativeBinding(String var0, String var1, String var2, String var3);

    private static boolean nativeLoadWithRelroFile(String string2, String string3, String string4, String string5) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeLoadWithRelroFile", $$robo$$android_webkit_WebViewFactory$nativeLoadWithRelroFile(java.lang.String java.lang.String java.lang.String java.lang.String ), 1, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    static {
        RobolectricInternals.classInitializing(WebViewFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebViewFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RelroFileCreator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_webkit_WebViewFactory_RelroFileCreator$main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e("WebViewFactory", "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v("WebViewFactory", "RelroFileCreator (64bit = " + is64Bit + "), " + " 32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e("WebViewFactory", "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewFactory.nativeCreateRelroFile(args[0], args[1], "/data/misc/shared_relro/libwebviewchromium32.relro", "/data/misc/shared_relro/libwebviewchromium64.relro");
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted(is64Bit, result);
                }
                catch (RemoteException e) {
                    Log.e("WebViewFactory", "error notifying update service", e);
                }
                if (!result) {
                    Log.e("WebViewFactory", "failed to create relro file");
                }
                System.exit(0);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__();
        }

        private RelroFileCreator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_WebViewFactory_RelroFileCreator$__constructor__(), 0, this);
        }

        public static void main(String[] stringArray) {
            InvokeDynamicSupport.bootstrapStatic("main", $$robo$$android_webkit_WebViewFactory_RelroFileCreator$main(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RelroFileCreator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

