/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbsSeekBar
extends ProgressBar
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Rect mTempRect;
    private Drawable mThumb;
    private ColorStateList mThumbTintList;
    private PorterDuff.Mode mThumbTintMode;
    private boolean mHasThumbTint;
    private boolean mHasThumbTintMode;
    private int mThumbOffset;
    private boolean mSplitTrack;
    float mTouchProgressOffset;
    boolean mIsUserSeekable;
    private int mKeyProgressIncrement;
    private ObjectAnimator mPositionAnimator;
    private static int PROGRESS_ANIMATION_DURATION = 250;
    private static int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private boolean mIsDragging;

    private void $$robo$$android_widget_AbsSeekBar$__constructor__(Context context) {
        this.mTempRect = new Rect();
        this.mThumbTintList = null;
        this.mThumbTintMode = null;
        this.mHasThumbTint = false;
        this.mHasThumbTintMode = false;
        this.mIsUserSeekable = true;
        this.mKeyProgressIncrement = 1;
    }

    private void $$robo$$android_widget_AbsSeekBar$__constructor__(Context context, AttributeSet attrs) {
        this.mTempRect = new Rect();
        this.mThumbTintList = null;
        this.mThumbTintMode = null;
        this.mHasThumbTint = false;
        this.mHasThumbTintMode = false;
        this.mIsUserSeekable = true;
        this.mKeyProgressIncrement = 1;
    }

    private void $$robo$$android_widget_AbsSeekBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AbsSeekBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mTempRect = new Rect();
        this.mThumbTintList = null;
        this.mThumbTintMode = null;
        this.mHasThumbTint = false;
        this.mHasThumbTintMode = false;
        this.mIsUserSeekable = true;
        this.mKeyProgressIncrement = 1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyleAttr, defStyleRes);
        Drawable thumb = a.getDrawable(0);
        this.setThumb(thumb);
        if (a.hasValue(4)) {
            this.mThumbTintMode = Drawable.parseTintMode(a.getInt(4, -1), this.mThumbTintMode);
            this.mHasThumbTintMode = true;
        }
        if (a.hasValue(3)) {
            this.mThumbTintList = a.getColorStateList(3);
            this.mHasThumbTint = true;
        }
        int thumbOffset = a.getDimensionPixelOffset(1, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        this.mSplitTrack = a.getBoolean(2, false);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.Theme, 0, 0);
        this.mDisabledAlpha = a.getFloat(3, 0.5f);
        a.recycle();
        this.applyThumbTint();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumb(Drawable thumb) {
        boolean needUpdate;
        if (this.mThumb != null && thumb != this.mThumb) {
            this.mThumb.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (thumb != null) {
            thumb.setCallback(this);
            if (this.canResolveLayoutDirection()) {
                thumb.setLayoutDirection(this.getLayoutDirection());
            }
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
            if (needUpdate && (thumb.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        this.mThumb = thumb;
        this.applyThumbTint();
        this.invalidate();
        if (needUpdate) {
            this.updateThumbAndTrackPos(this.getWidth(), this.getHeight());
            if (thumb != null && thumb.isStateful()) {
                int[] state = this.getDrawableState();
                thumb.setState(state);
            }
        }
    }

    private final Drawable $$robo$$android_widget_AbsSeekBar$getThumb() {
        return this.mThumb;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumbTintList(ColorStateList tint) {
        this.mThumbTintList = tint;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    private final ColorStateList $$robo$$android_widget_AbsSeekBar$getThumbTintList() {
        return this.mThumbTintList;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumbTintMode(PorterDuff.Mode tintMode) {
        this.mThumbTintMode = tintMode;
        this.mHasThumbTintMode = true;
        this.applyThumbTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_AbsSeekBar$getThumbTintMode() {
        return this.mThumbTintMode;
    }

    private final void $$robo$$android_widget_AbsSeekBar$applyThumbTint() {
        if (this.mThumb != null && (this.mHasThumbTint || this.mHasThumbTintMode)) {
            this.mThumb = this.mThumb.mutate();
            if (this.mHasThumbTint) {
                this.mThumb.setTintList(this.mThumbTintList);
            }
            if (this.mHasThumbTintMode) {
                this.mThumb.setTintMode(this.mThumbTintMode);
            }
        }
    }

    private final int $$robo$$android_widget_AbsSeekBar$getThumbOffset() {
        return this.mThumbOffset;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    private final void $$robo$$android_widget_AbsSeekBar$setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$getSplitTrack() {
        return this.mSplitTrack;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    private final int $$robo$$android_widget_AbsSeekBar$getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    private final synchronized void $$robo$$android_widget_AbsSeekBar$setMax(int max) {
        super.setMax(max);
        if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.getMax() / 20.0f)));
        }
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$verifyDrawable(Drawable who) {
        return who == this.mThumb || super.verifyDrawable(who);
    }

    private final void $$robo$$android_widget_AbsSeekBar$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumb != null) {
            this.mThumb.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$drawableStateChanged() {
        Drawable thumb;
        super.drawableStateChanged();
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if ((thumb = this.mThumb) != null && thumb.isStateful()) {
            thumb.setState(this.getDrawableState());
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumb != null) {
            this.mThumb.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$onProgressRefresh(float scale, boolean fromUser) {
        super.onProgressRefresh(scale, fromUser);
        if (!this.isAnimationRunning()) {
            this.setThumbPos(scale);
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$onAnimatePosition(float scale, boolean fromUser) {
        this.setThumbPos(scale);
    }

    private final void $$robo$$android_widget_AbsSeekBar$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateThumbAndTrackPos(w, h);
    }

    private final void $$robo$$android_widget_AbsSeekBar$updateThumbAndTrackPos(int w, int h) {
        int thumbOffset;
        int trackOffset;
        int thumbHeight;
        Drawable track = this.getCurrentDrawable();
        Drawable thumb = this.mThumb;
        int trackHeight = Math.min(this.mMaxHeight, h - this.mPaddingTop - this.mPaddingBottom);
        int n = thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        if (thumbHeight > trackHeight) {
            trackOffset = (thumbHeight - trackHeight) / 2;
            thumbOffset = 0;
        } else {
            trackOffset = 0;
            thumbOffset = (trackHeight - thumbHeight) / 2;
        }
        if (track != null) {
            track.setBounds(0, trackOffset, w - this.mPaddingRight - this.mPaddingLeft, h - this.mPaddingBottom - trackOffset - this.mPaddingTop);
        }
        if (thumb != null) {
            this.setThumbPos(w, thumb, this.getScale(), thumbOffset);
        }
    }

    private final float $$robo$$android_widget_AbsSeekBar$getScale() {
        int max = this.getMax();
        return max > 0 ? (float)this.getProgress() / (float)max : 0.0f;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumbPos(float scale) {
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, scale, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$setThumbPos(int w, Drawable thumb, float scale, int offset) {
        int bottom;
        int top;
        int available = w - this.mPaddingLeft - this.mPaddingRight;
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        available -= thumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2) + 0.5f);
        if (offset == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            top = oldBounds.top;
            bottom = oldBounds.bottom;
        } else {
            top = offset;
            bottom = offset + thumbHeight;
        }
        int left = this.isLayoutRtl() && this.mMirrorForRtl ? available - thumbPos : thumbPos;
        int right = left + thumbWidth;
        Drawable background = this.getBackground();
        if (background != null) {
            Rect bounds = thumb.getBounds();
            int offsetX = this.mPaddingLeft - this.mThumbOffset;
            int offsetY = this.mPaddingTop;
            background.setHotspotBounds(left + offsetX, top + offsetY, right + offsetX, bottom + offsetY);
        }
        thumb.setBounds(left, top, right, bottom);
    }

    private final void $$robo$$android_widget_AbsSeekBar$onResolveDrawables(int layoutDirection) {
        super.onResolveDrawables(layoutDirection);
        if (this.mThumb != null) {
            this.mThumb.setLayoutDirection(layoutDirection);
        }
    }

    private final synchronized void $$robo$$android_widget_AbsSeekBar$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawThumb(canvas);
    }

    private final void $$robo$$android_widget_AbsSeekBar$drawTrack(Canvas canvas) {
        Drawable thumbDrawable = this.mThumb;
        if (thumbDrawable != null && this.mSplitTrack) {
            Insets insets = thumbDrawable.getOpticalInsets();
            Rect tempRect = this.mTempRect;
            thumbDrawable.copyBounds(tempRect);
            tempRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            tempRect.left += insets.left;
            tempRect.right -= insets.right;
            int saveCount = canvas.save();
            canvas.clipRect(tempRect, Region.Op.DIFFERENCE);
            super.drawTrack(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.drawTrack(canvas);
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$drawThumb(Canvas canvas) {
        if (this.mThumb != null) {
            canvas.save();
            canvas.translate(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    private final synchronized void $$robo$$android_widget_AbsSeekBar$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumb == null ? 0 : this.mThumb.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(AbsSeekBar.resolveSizeAndState(dw += this.mPaddingLeft + this.mPaddingRight, widthMeasureSpec, 0), AbsSeekBar.resolveSizeAndState(dh += this.mPaddingTop + this.mPaddingBottom, heightMeasureSpec, 0));
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.isInScrollingContainer()) {
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    private final void $$robo$$android_widget_AbsSeekBar$setHotspot(float x, float y) {
        Drawable bg = this.getBackground();
        if (bg != null) {
            bg.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$trackTouchEvent(MotionEvent event) {
        float scale;
        int width = this.getWidth();
        int available = width - this.mPaddingLeft - this.mPaddingRight;
        int x = (int)event.getX();
        float progress = 0.0f;
        if (this.isLayoutRtl() && this.mMirrorForRtl) {
            if (x > width - this.mPaddingRight) {
                scale = 0.0f;
            } else if (x < this.mPaddingLeft) {
                scale = 1.0f;
            } else {
                scale = (float)(available - x + this.mPaddingLeft) / (float)available;
                progress = this.mTouchProgressOffset;
            }
        } else if (x < this.mPaddingLeft) {
            scale = 0.0f;
        } else if (x > width - this.mPaddingRight) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.mPaddingLeft) / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setHotspot(x, (int)event.getY());
        this.setProgress((int)(progress += scale * (float)max), true);
    }

    private final void $$robo$$android_widget_AbsSeekBar$attemptClaimDrag() {
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private final void $$robo$$android_widget_AbsSeekBar$onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    private final void $$robo$$android_widget_AbsSeekBar$onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    private final void $$robo$$android_widget_AbsSeekBar$onKeyChange() {
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int progress = this.getProgress();
            switch (keyCode) {
                case 21: {
                    if (progress <= 0) break;
                    this.animateSetProgress(progress - this.mKeyProgressIncrement);
                    this.onKeyChange();
                    return true;
                }
                case 22: {
                    if (progress >= this.getMax()) break;
                    this.animateSetProgress(progress + this.mKeyProgressIncrement);
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$isAnimationRunning() {
        return this.mPositionAnimator != null && this.mPositionAnimator.isRunning();
    }

    private final void $$robo$$android_widget_AbsSeekBar$setProgress(int progress, boolean fromUser) {
        if (this.isAnimationRunning()) {
            this.mPositionAnimator.cancel();
        }
        super.setProgress(progress, fromUser);
    }

    private final void $$robo$$android_widget_AbsSeekBar$animateSetProgress(int progress) {
        float curProgress;
        float f = curProgress = this.isAnimationRunning() ? this.getAnimationPosition() : (float)this.getProgress();
        if (progress < 0) {
            progress = 0;
        } else if (progress > this.getMax()) {
            progress = this.getMax();
        }
        this.setProgressValueOnly(progress);
        this.mPositionAnimator = ObjectAnimator.ofFloat((Object)this, "animationPosition", curProgress, progress);
        this.mPositionAnimator.setDuration(250L);
        this.mPositionAnimator.setAutoCancel(true);
        this.mPositionAnimator.start();
    }

    private final void $$robo$$android_widget_AbsSeekBar$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(AbsSeekBar.class.getName());
    }

    private final void $$robo$$android_widget_AbsSeekBar$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(AbsSeekBar.class.getName());
        if (this.isEnabled()) {
            int progress = this.getProgress();
            if (progress > 0) {
                info.addAction(8192);
            }
            if (progress < this.getMax()) {
                info.addAction(4096);
            }
        }
    }

    private final boolean $$robo$$android_widget_AbsSeekBar$performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        int progress = this.getProgress();
        int increment = Math.max(1, Math.round((float)this.getMax() / 5.0f));
        switch (action) {
            case 8192: {
                if (progress <= 0) {
                    return false;
                }
                this.setProgress(progress - increment, true);
                this.onKeyChange();
                return true;
            }
            case 4096: {
                if (progress >= this.getMax()) {
                    return false;
                }
                this.setProgress(progress + increment, true);
                this.onKeyChange();
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_AbsSeekBar$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, this.getScale(), Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AbsSeekBar$__constructor__(context);
    }

    public AbsSeekBar(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSeekBar$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AbsSeekBar$__constructor__(context, attributeSet);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSeekBar$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AbsSeekBar$__constructor__(context, attributeSet, n);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSeekBar$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AbsSeekBar$__constructor__(context, attributeSet, n, n2);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSeekBar$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void setThumb(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setThumb", $$robo$$android_widget_AbsSeekBar$setThumb(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getThumb() {
        return InvokeDynamicSupport.bootstrap("getThumb", $$robo$$android_widget_AbsSeekBar$getThumb(), 0, this);
    }

    public void setThumbTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setThumbTintList", $$robo$$android_widget_AbsSeekBar$setThumbTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getThumbTintList() {
        return InvokeDynamicSupport.bootstrap("getThumbTintList", $$robo$$android_widget_AbsSeekBar$getThumbTintList(), 0, this);
    }

    public void setThumbTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setThumbTintMode", $$robo$$android_widget_AbsSeekBar$setThumbTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getThumbTintMode() {
        return InvokeDynamicSupport.bootstrap("getThumbTintMode", $$robo$$android_widget_AbsSeekBar$getThumbTintMode(), 0, this);
    }

    private void applyThumbTint() {
        InvokeDynamicSupport.bootstrap("applyThumbTint", $$robo$$android_widget_AbsSeekBar$applyThumbTint(), 0, this);
    }

    public int getThumbOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getThumbOffset", $$robo$$android_widget_AbsSeekBar$getThumbOffset(), 0, this);
    }

    public void setThumbOffset(int n) {
        InvokeDynamicSupport.bootstrap("setThumbOffset", $$robo$$android_widget_AbsSeekBar$setThumbOffset(int ), 0, this, n);
    }

    public void setSplitTrack(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitTrack", $$robo$$android_widget_AbsSeekBar$setSplitTrack(boolean ), 0, this, bl);
    }

    public boolean getSplitTrack() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSplitTrack", $$robo$$android_widget_AbsSeekBar$getSplitTrack(), 0, this);
    }

    public void setKeyProgressIncrement(int n) {
        InvokeDynamicSupport.bootstrap("setKeyProgressIncrement", $$robo$$android_widget_AbsSeekBar$setKeyProgressIncrement(int ), 0, this, n);
    }

    public int getKeyProgressIncrement() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyProgressIncrement", $$robo$$android_widget_AbsSeekBar$getKeyProgressIncrement(), 0, this);
    }

    @Override
    public synchronized void setMax(int n) {
        InvokeDynamicSupport.bootstrap("setMax", $$robo$$android_widget_AbsSeekBar$setMax(int ), 0, this, n);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_AbsSeekBar$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_AbsSeekBar$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_AbsSeekBar$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_AbsSeekBar$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    void onProgressRefresh(float f, boolean bl) {
        InvokeDynamicSupport.bootstrap("onProgressRefresh", $$robo$$android_widget_AbsSeekBar$onProgressRefresh(float boolean ), 0, this, f, bl);
    }

    @Override
    void onAnimatePosition(float f, boolean bl) {
        InvokeDynamicSupport.bootstrap("onAnimatePosition", $$robo$$android_widget_AbsSeekBar$onAnimatePosition(float boolean ), 0, this, f, bl);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_AbsSeekBar$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void updateThumbAndTrackPos(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateThumbAndTrackPos", $$robo$$android_widget_AbsSeekBar$updateThumbAndTrackPos(int int ), 0, this, n, n2);
    }

    private float getScale() {
        return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$android_widget_AbsSeekBar$getScale(), 0, this);
    }

    private void setThumbPos(float f) {
        InvokeDynamicSupport.bootstrap("setThumbPos", $$robo$$android_widget_AbsSeekBar$setThumbPos(float ), 0, this, f);
    }

    private void setThumbPos(int n, Drawable drawable2, float f, int n2) {
        InvokeDynamicSupport.bootstrap("setThumbPos", $$robo$$android_widget_AbsSeekBar$setThumbPos(int android.graphics.drawable.Drawable float int ), 0, this, n, drawable2, f, n2);
    }

    @Override
    public void onResolveDrawables(int n) {
        InvokeDynamicSupport.bootstrap("onResolveDrawables", $$robo$$android_widget_AbsSeekBar$onResolveDrawables(int ), 0, this, n);
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_AbsSeekBar$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    void drawTrack(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawTrack", $$robo$$android_widget_AbsSeekBar$drawTrack(android.graphics.Canvas ), 0, this, canvas);
    }

    void drawThumb(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawThumb", $$robo$$android_widget_AbsSeekBar$drawThumb(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected synchronized void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_AbsSeekBar$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_AbsSeekBar$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_widget_AbsSeekBar$setHotspot(float float ), 0, this, f, f2);
    }

    private void trackTouchEvent(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("trackTouchEvent", $$robo$$android_widget_AbsSeekBar$trackTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void attemptClaimDrag() {
        InvokeDynamicSupport.bootstrap("attemptClaimDrag", $$robo$$android_widget_AbsSeekBar$attemptClaimDrag(), 0, this);
    }

    void onStartTrackingTouch() {
        InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$android_widget_AbsSeekBar$onStartTrackingTouch(), 0, this);
    }

    void onStopTrackingTouch() {
        InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$android_widget_AbsSeekBar$onStopTrackingTouch(), 0, this);
    }

    void onKeyChange() {
        InvokeDynamicSupport.bootstrap("onKeyChange", $$robo$$android_widget_AbsSeekBar$onKeyChange(), 0, this);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_AbsSeekBar$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    boolean isAnimationRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnimationRunning", $$robo$$android_widget_AbsSeekBar$isAnimationRunning(), 0, this);
    }

    @Override
    public void setProgress(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_widget_AbsSeekBar$setProgress(int boolean ), 0, this, n, bl);
    }

    void animateSetProgress(int n) {
        InvokeDynamicSupport.bootstrap("animateSetProgress", $$robo$$android_widget_AbsSeekBar$animateSetProgress(int ), 0, this, n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_AbsSeekBar$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_AbsSeekBar$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_widget_AbsSeekBar$performAccessibilityAction(int android.os.Bundle ), 0, this, n, bundle);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_AbsSeekBar$onRtlPropertiesChanged(int ), 0, this, n);
    }

    public /* synthetic */ AbsSeekBar() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsSeekBar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

