/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseBooleanArray;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ActionMenuView;
import android.widget.ImageButton;
import android.widget.ListPopupWindow;
import com.android.internal.transition.ActionBarTransition;
import com.android.internal.view.ActionBarPolicy;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActionMenuPresenter";
    private View mOverflowButton;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private int mWidthLimit;
    private int mActionItemWidthLimit;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private boolean mStrictWidthLimit;
    private boolean mWidthLimitSet;
    private boolean mExpandedActionViewsExclusive;
    private int mMinCellSize;
    private SparseBooleanArray mActionButtonGroups;
    private View mScrapActionButtonView;
    private OverflowPopup mOverflowPopup;
    private ActionButtonSubmenu mActionButtonPopup;
    private OpenOverflowRunnable mPostedOpenRunnable;
    private ActionMenuPopupCallback mPopupCallback;
    PopupPresenterCallback mPopupPresenterCallback;
    int mOpenSubMenuId;

    private void $$robo$$android_widget_ActionMenuPresenter$__constructor__(Context context) {
        this.mActionButtonGroups = new SparseBooleanArray();
        this.mPopupPresenterCallback = new PopupPresenterCallback(this);
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$initForMenu(Context context, MenuBuilder menu2) {
        super.initForMenu(context, menu2);
        Resources res = context.getResources();
        ActionBarPolicy abp = ActionBarPolicy.get(context);
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = abp.showsOverflowMenuButton();
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = abp.getEmbeddedMenuWidthLimit();
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = abp.getMaxActionButtons();
        }
        int width = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this, this.mSystemContext);
                int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.mOverflowButton.measure(spec, spec);
            }
            width -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = width;
        this.mMinCellSize = (int)(56.0f * res.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onConfigurationChanged(Configuration newConfig) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = this.mContext.getResources().getInteger(17694838);
        }
        if (this.mMenu != null) {
            this.mMenu.onItemsChanged(true);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setWidthLimit(int width, boolean strict) {
        this.mWidthLimit = width;
        this.mStrictWidthLimit = strict;
        this.mWidthLimitSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setReserveOverflow(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
        this.mReserveOverflowSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setItemLimit(int itemCount) {
        this.mMaxItems = itemCount;
        this.mMaxItemsSet = true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setExpandedActionViewsExclusive(boolean isExclusive) {
        this.mExpandedActionViewsExclusive = isExclusive;
    }

    private final MenuView $$robo$$android_widget_ActionMenuPresenter$getMenuView(ViewGroup root) {
        MenuView result = super.getMenuView(root);
        ((ActionMenuView)result).setPresenter(this);
        return result;
    }

    private final View $$robo$$android_widget_ActionMenuPresenter$getItemView(MenuItemImpl item, View convertView, ViewGroup parent) {
        View actionView = item.getActionView();
        if (actionView == null || item.hasCollapsibleActionView()) {
            actionView = super.getItemView(item, convertView, parent);
        }
        actionView.setVisibility(item.isActionViewExpanded() ? 8 : 0);
        ActionMenuView menuParent = (ActionMenuView)parent;
        ViewGroup.LayoutParams lp = actionView.getLayoutParams();
        if (!menuParent.checkLayoutParams(lp)) {
            actionView.setLayoutParams(menuParent.generateLayoutParams(lp));
        }
        return actionView;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$bindItemView(MenuItemImpl item, MenuView.ItemView itemView) {
        itemView.initialize(item, 0);
        ActionMenuView menuView = (ActionMenuView)this.mMenuView;
        ActionMenuItemView actionItemView = (ActionMenuItemView)itemView;
        actionItemView.setItemInvoker(menuView);
        if (this.mPopupCallback == null) {
            this.mPopupCallback = new ActionMenuPopupCallback(this);
        }
        actionItemView.setPopupCallback(this.mPopupCallback);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$shouldIncludeItem(int childIndex, MenuItemImpl item) {
        return item.isActionButton();
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$updateMenuView(boolean cleared) {
        ViewGroup menuViewParent = (ViewGroup)((View)((Object)this.mMenuView)).getParent();
        if (menuViewParent != null) {
            ActionBarTransition.beginDelayedTransition(menuViewParent);
        }
        super.updateMenuView(cleared);
        ((View)((Object)this.mMenuView)).requestLayout();
        if (this.mMenu != null) {
            ArrayList<MenuItemImpl> actionItems = this.mMenu.getActionItems();
            int count = actionItems.size();
            for (int i = 0; i < count; ++i) {
                ActionProvider provider = actionItems.get(i).getActionProvider();
                if (provider == null) continue;
                provider.setSubUiVisibilityListener(this);
            }
        }
        ArrayList<MenuItemImpl> nonActionItems = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
        boolean hasOverflow = false;
        if (this.mReserveOverflow && nonActionItems != null) {
            int count = nonActionItems.size();
            if (count == 1) {
                hasOverflow = !nonActionItems.get(0).isActionViewExpanded();
            } else {
                boolean bl = hasOverflow = count > 0;
            }
        }
        if (hasOverflow) {
            ViewGroup parent;
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this, this.mSystemContext);
            }
            if ((parent = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (parent != null) {
                    parent.removeView(this.mOverflowButton);
                }
                ActionMenuView menuView = (ActionMenuView)this.mMenuView;
                menuView.addView(this.mOverflowButton, menuView.generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)((Object)this.mMenuView)).removeView(this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$filterLeftoverView(ViewGroup parent, int childIndex) {
        if (parent.getChildAt(childIndex) == this.mOverflowButton) {
            return false;
        }
        return super.filterLeftoverView(parent, childIndex);
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$onSubMenuSelected(SubMenuBuilder subMenu) {
        if (!subMenu.hasVisibleItems()) {
            return false;
        }
        SubMenuBuilder topSubMenu = subMenu;
        while (topSubMenu.getParentMenu() != this.mMenu) {
            topSubMenu = (SubMenuBuilder)topSubMenu.getParentMenu();
        }
        View anchor = this.findViewForItem(topSubMenu.getItem());
        if (anchor == null) {
            if (this.mOverflowButton == null) {
                return false;
            }
            anchor = this.mOverflowButton;
        }
        this.mOpenSubMenuId = subMenu.getItem().getItemId();
        this.mActionButtonPopup = new ActionButtonSubmenu(this, this.mContext, subMenu);
        this.mActionButtonPopup.setAnchorView(anchor);
        this.mActionButtonPopup.show();
        super.onSubMenuSelected(subMenu);
        return true;
    }

    private final View $$robo$$android_widget_ActionMenuPresenter$findViewForItem(MenuItem item) {
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        if (parent == null) {
            return null;
        }
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            if (!(child instanceof MenuView.ItemView) || ((MenuView.ItemView)((Object)child)).getItemData() != item) continue;
            return child;
        }
        return null;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$showOverflowMenu() {
        if (this.mReserveOverflow && !this.isOverflowMenuShowing() && this.mMenu != null && this.mMenuView != null && this.mPostedOpenRunnable == null && !this.mMenu.getNonActionItems().isEmpty()) {
            OverflowPopup popup = new OverflowPopup(this, this.mContext, this.mMenu, this.mOverflowButton, true);
            this.mPostedOpenRunnable = new OpenOverflowRunnable(this, popup);
            ((View)((Object)this.mMenuView)).post(this.mPostedOpenRunnable);
            super.onSubMenuSelected(null);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).removeCallbacks(this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup popup = this.mOverflowPopup;
        if (popup != null) {
            popup.dismiss();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$dismissPopupMenus() {
        boolean result = this.hideOverflowMenu();
        return result |= this.hideSubMenus();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$hideSubMenus() {
        if (this.mActionButtonPopup != null) {
            this.mActionButtonPopup.dismiss();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowing() {
        return this.mOverflowPopup != null && this.mOverflowPopup.isShowing();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowPending() {
        return this.mPostedOpenRunnable != null || this.isOverflowMenuShowing();
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$isOverflowReserved() {
        return this.mReserveOverflow;
    }

    private final boolean $$robo$$android_widget_ActionMenuPresenter$flagActionItems() {
        ArrayList<MenuItemImpl> visibleItems = this.mMenu.getVisibleItems();
        int itemsSize = visibleItems.size();
        int maxActions = this.mMaxItems;
        int widthLimit = this.mActionItemWidthLimit;
        int querySpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup parent = (ViewGroup)((Object)this.mMenuView);
        int requiredItems = 0;
        int requestedItems = 0;
        int firstActionWidth = 0;
        boolean hasOverflow = false;
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = visibleItems.get(i);
            if (item.requiresActionButton()) {
                ++requiredItems;
            } else if (item.requestsActionButton()) {
                ++requestedItems;
            } else {
                hasOverflow = true;
            }
            if (!this.mExpandedActionViewsExclusive || !item.isActionViewExpanded()) continue;
            maxActions = 0;
        }
        if (this.mReserveOverflow && (hasOverflow || requiredItems + requestedItems > maxActions)) {
            --maxActions;
        }
        maxActions -= requiredItems;
        SparseBooleanArray seenGroups = this.mActionButtonGroups;
        seenGroups.clear();
        int cellSize = 0;
        int cellsRemaining = 0;
        if (this.mStrictWidthLimit) {
            cellsRemaining = widthLimit / this.mMinCellSize;
            int cellSizeRemaining = widthLimit % this.mMinCellSize;
            cellSize = this.mMinCellSize + cellSizeRemaining / cellsRemaining;
        }
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = visibleItems.get(i);
            if (item.requiresActionButton()) {
                int groupId;
                View v = this.getItemView(item, this.mScrapActionButtonView, parent);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = v;
                }
                if (this.mStrictWidthLimit) {
                    cellsRemaining -= ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                } else {
                    v.measure(querySpec, querySpec);
                }
                int measuredWidth = v.getMeasuredWidth();
                widthLimit -= measuredWidth;
                if (firstActionWidth == 0) {
                    firstActionWidth = measuredWidth;
                }
                if ((groupId = item.getGroupId()) != 0) {
                    seenGroups.put(groupId, true);
                }
                item.setIsActionButton(true);
                continue;
            }
            if (item.requestsActionButton()) {
                boolean isAction;
                int groupId = item.getGroupId();
                boolean inGroup = seenGroups.get(groupId);
                boolean bl = isAction = !(maxActions <= 0 && !inGroup || widthLimit <= 0 || this.mStrictWidthLimit && cellsRemaining <= 0);
                if (isAction) {
                    View v = this.getItemView(item, this.mScrapActionButtonView, parent);
                    if (this.mScrapActionButtonView == null) {
                        this.mScrapActionButtonView = v;
                    }
                    if (this.mStrictWidthLimit) {
                        int cells = ActionMenuView.measureChildForCells(v, cellSize, cellsRemaining, querySpec, 0);
                        cellsRemaining -= cells;
                        if (cells == 0) {
                            isAction = false;
                        }
                    } else {
                        v.measure(querySpec, querySpec);
                    }
                    int measuredWidth = v.getMeasuredWidth();
                    widthLimit -= measuredWidth;
                    if (firstActionWidth == 0) {
                        firstActionWidth = measuredWidth;
                    }
                    isAction = this.mStrictWidthLimit ? (isAction &= widthLimit >= 0) : (isAction &= widthLimit + firstActionWidth > 0);
                }
                if (isAction && groupId != 0) {
                    seenGroups.put(groupId, true);
                } else if (inGroup) {
                    seenGroups.put(groupId, false);
                    for (int j = 0; j < i; ++j) {
                        MenuItemImpl areYouMyGroupie = visibleItems.get(j);
                        if (areYouMyGroupie.getGroupId() != groupId) continue;
                        if (areYouMyGroupie.isActionButton()) {
                            ++maxActions;
                        }
                        areYouMyGroupie.setIsActionButton(false);
                    }
                }
                if (isAction) {
                    --maxActions;
                }
                item.setIsActionButton(isAction);
                continue;
            }
            item.setIsActionButton(false);
        }
        return true;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        this.dismissPopupMenus();
        super.onCloseMenu(menu2, allMenusAreClosing);
    }

    private final Parcelable $$robo$$android_widget_ActionMenuPresenter$onSaveInstanceState() {
        SavedState state = new SavedState();
        state.openSubMenuId = this.mOpenSubMenuId;
        return state;
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onRestoreInstanceState(Parcelable state) {
        MenuItem item;
        SavedState saved = (SavedState)state;
        if (saved.openSubMenuId > 0 && (item = this.mMenu.findItem(saved.openSubMenuId)) != null) {
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            this.onSubMenuSelected(subMenu);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$onSubUiVisibilityChanged(boolean isVisible) {
        if (isVisible) {
            super.onSubMenuSelected(null);
        } else {
            this.mMenu.close(false);
        }
    }

    private final void $$robo$$android_widget_ActionMenuPresenter$setMenuView(ActionMenuView menuView) {
        this.mMenuView = menuView;
        menuView.initialize(this.mMenu);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ActionMenuPresenter$__constructor__(context);
    }

    public ActionMenuPresenter(Context context) {
        super(context, 17367069, 17367068);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("initForMenu", $$robo$$android_widget_ActionMenuPresenter$initForMenu(android.content.Context com.android.internal.view.menu.MenuBuilder ), 0, this, context, menuBuilder);
    }

    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_ActionMenuPresenter$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    public void setWidthLimit(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setWidthLimit", $$robo$$android_widget_ActionMenuPresenter$setWidthLimit(int boolean ), 0, this, n, bl);
    }

    public void setReserveOverflow(boolean bl) {
        InvokeDynamicSupport.bootstrap("setReserveOverflow", $$robo$$android_widget_ActionMenuPresenter$setReserveOverflow(boolean ), 0, this, bl);
    }

    public void setItemLimit(int n) {
        InvokeDynamicSupport.bootstrap("setItemLimit", $$robo$$android_widget_ActionMenuPresenter$setItemLimit(int ), 0, this, n);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExpandedActionViewsExclusive", $$robo$$android_widget_ActionMenuPresenter$setExpandedActionViewsExclusive(boolean ), 0, this, bl);
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getMenuView", $$robo$$android_widget_ActionMenuPresenter$getMenuView(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getItemView", $$robo$$android_widget_ActionMenuPresenter$getItemView(com.android.internal.view.menu.MenuItemImpl android.view.View android.view.ViewGroup ), 0, this, menuItemImpl, view, viewGroup);
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        InvokeDynamicSupport.bootstrap("bindItemView", $$robo$$android_widget_ActionMenuPresenter$bindItemView(com.android.internal.view.menu.MenuItemImpl com.android.internal.view.menu.MenuView$ItemView ), 0, this, menuItemImpl, itemView);
    }

    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIncludeItem", $$robo$$android_widget_ActionMenuPresenter$shouldIncludeItem(int com.android.internal.view.menu.MenuItemImpl ), 0, this, n, menuItemImpl);
    }

    @Override
    public void updateMenuView(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateMenuView", $$robo$$android_widget_ActionMenuPresenter$updateMenuView(boolean ), 0, this, bl);
    }

    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("filterLeftoverView", $$robo$$android_widget_ActionMenuPresenter$filterLeftoverView(android.view.ViewGroup int ), 0, this, viewGroup, n);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSubMenuSelected", $$robo$$android_widget_ActionMenuPresenter$onSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder ), 0, this, subMenuBuilder);
    }

    private View findViewForItem(MenuItem menuItem) {
        return InvokeDynamicSupport.bootstrap("findViewForItem", $$robo$$android_widget_ActionMenuPresenter$findViewForItem(android.view.MenuItem ), 0, this, menuItem);
    }

    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$android_widget_ActionMenuPresenter$showOverflowMenu(), 0, this);
    }

    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$android_widget_ActionMenuPresenter$hideOverflowMenu(), 0, this);
    }

    public boolean dismissPopupMenus() {
        return (boolean)InvokeDynamicSupport.bootstrap("dismissPopupMenus", $$robo$$android_widget_ActionMenuPresenter$dismissPopupMenus(), 0, this);
    }

    public boolean hideSubMenus() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideSubMenus", $$robo$$android_widget_ActionMenuPresenter$hideSubMenus(), 0, this);
    }

    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowing(), 0, this);
    }

    public boolean isOverflowMenuShowPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowPending", $$robo$$android_widget_ActionMenuPresenter$isOverflowMenuShowPending(), 0, this);
    }

    public boolean isOverflowReserved() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowReserved", $$robo$$android_widget_ActionMenuPresenter$isOverflowReserved(), 0, this);
    }

    @Override
    public boolean flagActionItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$android_widget_ActionMenuPresenter$flagActionItems(), 0, this);
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$android_widget_ActionMenuPresenter$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_ActionMenuPresenter$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_ActionMenuPresenter$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void onSubUiVisibilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onSubUiVisibilityChanged", $$robo$$android_widget_ActionMenuPresenter$onSubUiVisibilityChanged(boolean ), 0, this, bl);
    }

    public void setMenuView(ActionMenuView actionMenuView) {
        InvokeDynamicSupport.bootstrap("setMenuView", $$robo$$android_widget_ActionMenuPresenter$setMenuView(android.widget.ActionMenuView ), 0, this, actionMenuView);
    }

    public /* synthetic */ ActionMenuPresenter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPresenter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ActionMenuPopupCallback
    extends ActionMenuItemView.PopupCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(ActionMenuPresenter actionMenuPresenter) {
        }

        private final ListPopupWindow $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$getPopup() {
            return this.this$0.mActionButtonPopup != null ? this.this$0.mActionButtonPopup.getPopup() : null;
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(ActionMenuPresenter x0, 1 x1) {
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(actionMenuPresenter);
        }

        private ActionMenuPopupCallback(ActionMenuPresenter actionMenuPresenter) {
            this.this$0 = actionMenuPresenter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(android.widget.ActionMenuPresenter ), 0, this, actionMenuPresenter);
        }

        @Override
        public ListPopupWindow getPopup() {
            return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$getPopup(), 0, this);
        }

        private /* synthetic */ void __constructor__(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionMenuPopupCallback$__constructor__(actionMenuPresenter, var2_2);
        }

        public /* synthetic */ ActionMenuPopupCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPopupCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OpenOverflowRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private OverflowPopup mPopup;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(ActionMenuPresenter actionMenuPresenter, OverflowPopup popup) {
            this.mPopup = popup;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$run() {
            this.this$0.mMenu.changeMenuMode();
            View menuView = (View)((Object)this.this$0.mMenuView);
            if (menuView != null && menuView.getWindowToken() != null && this.mPopup.tryShow()) {
                this.this$0.mOverflowPopup = this.mPopup;
            }
            this.this$0.mPostedOpenRunnable = null;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
            this.$$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(actionMenuPresenter, overflowPopup);
        }

        public OpenOverflowRunnable(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
            this.this$0 = actionMenuPresenter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$__constructor__(android.widget.ActionMenuPresenter android.widget.ActionMenuPresenter$OverflowPopup ), 0, this, actionMenuPresenter, overflowPopup);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ActionMenuPresenter_OpenOverflowRunnable$run(), 0, this);
        }

        public /* synthetic */ OpenOverflowRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpenOverflowRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(ActionMenuPresenter actionMenuPresenter) {
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            this.this$0.mOpenSubMenuId = ((SubMenuBuilder)subMenu).getItem().getItemId();
            MenuPresenter.Callback cb = this.this$0.getCallback();
            return cb != null ? cb.onOpenSubMenu(subMenu) : false;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            MenuPresenter.Callback cb;
            if (menu2 instanceof SubMenuBuilder) {
                ((SubMenuBuilder)menu2).getRootMenu().close(false);
            }
            if ((cb = this.this$0.getCallback()) != null) {
                cb.onCloseMenu(menu2, allMenusAreClosing);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(ActionMenuPresenter x0, 1 x1) {
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter) {
            this.$$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(actionMenuPresenter);
        }

        private PopupPresenterCallback(ActionMenuPresenter actionMenuPresenter) {
            this.this$0 = actionMenuPresenter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(android.widget.ActionMenuPresenter ), 0, this, actionMenuPresenter);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
        }

        private /* synthetic */ void __constructor__(ActionMenuPresenter actionMenuPresenter, 1 var2_2) {
            this.$$robo$$android_widget_ActionMenuPresenter_PopupPresenterCallback$__constructor__(actionMenuPresenter, var2_2);
        }

        public /* synthetic */ PopupPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActionButtonSubmenu
    extends MenuPopupHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SubMenuBuilder mSubMenu;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenu) {
            this.mSubMenu = subMenu;
            MenuItemImpl item = (MenuItemImpl)subMenu.getItem();
            if (!item.isActionButton()) {
                this.setAnchorView(actionMenuPresenter.mOverflowButton == null ? (View)((Object)actionMenuPresenter.mMenuView) : actionMenuPresenter.mOverflowButton);
            }
            this.setCallback(actionMenuPresenter.mPopupPresenterCallback);
            boolean preserveIconSpacing = false;
            int count = subMenu.size();
            for (int i = 0; i < count; ++i) {
                MenuItem childItem = subMenu.getItem(i);
                if (!childItem.isVisible() || childItem.getIcon() == null) continue;
                preserveIconSpacing = true;
                break;
            }
            this.setForceShowIcon(preserveIconSpacing);
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$onDismiss() {
            super.onDismiss();
            this.this$0.mActionButtonPopup = null;
            this.this$0.mOpenSubMenuId = 0;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenuBuilder) {
            this.$$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(actionMenuPresenter, context, subMenuBuilder);
        }

        public ActionButtonSubmenu(ActionMenuPresenter actionMenuPresenter, Context context, SubMenuBuilder subMenuBuilder) {
            this.this$0 = actionMenuPresenter;
            super(context, subMenuBuilder, null, false, 0x1010444);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$__constructor__(android.widget.ActionMenuPresenter android.content.Context com.android.internal.view.menu.SubMenuBuilder ), 0, this, actionMenuPresenter, context, subMenuBuilder);
        }

        @Override
        public void onDismiss() {
            InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_ActionMenuPresenter_ActionButtonSubmenu$onDismiss(), 0, this);
        }

        public /* synthetic */ ActionButtonSubmenu() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionButtonSubmenu)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly) {
            this.setGravity(0x800005);
            this.setCallback(actionMenuPresenter.mPopupPresenterCallback);
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$onDismiss() {
            super.onDismiss();
            this.this$0.mMenu.close();
            this.this$0.mOverflowPopup = null;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            this.$$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(actionMenuPresenter, context, menuBuilder, view, bl);
        }

        public OverflowPopup(ActionMenuPresenter actionMenuPresenter, Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            this.this$0 = actionMenuPresenter;
            super(context, menuBuilder, view, bl, 0x1010444);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$__constructor__(android.widget.ActionMenuPresenter android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View boolean ), 0, this, actionMenuPresenter, context, menuBuilder, view, bl);
        }

        @Override
        public void onDismiss() {
            InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_ActionMenuPresenter_OverflowPopup$onDismiss(), 0, this);
        }

        public /* synthetic */ OverflowPopup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowPopup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OverflowMenuButton
    extends ImageButton
    implements ActionMenuView.ActionMenuChildView,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mTempPts;
        /* synthetic */ ActionMenuPresenter this$0;

        private void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(ActionMenuPresenter actionMenuPresenter, Context context) {
            this.mTempPts = new float[2];
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
            this.setOnTouchListener((View.OnTouchListener)new ShadowedObject(this, this, actionMenuPresenter){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ActionMenuPresenter val$this$0;
                /* synthetic */ OverflowMenuButton this$1;

                private void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(OverflowMenuButton overflowMenuButton, View x0, ActionMenuPresenter actionMenuPresenter) {
                }

                private final ListPopupWindow $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$getPopup() {
                    if (this.this$1.this$0.mOverflowPopup == null) {
                        return null;
                    }
                    return this.this$1.this$0.mOverflowPopup.getPopup();
                }

                private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStarted() {
                    this.this$1.this$0.showOverflowMenu();
                    return true;
                }

                private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStopped() {
                    if (this.this$1.this$0.mPostedOpenRunnable != null) {
                        return false;
                    }
                    this.this$1.this$0.hideOverflowMenu();
                    return true;
                }

                private void __constructor__(OverflowMenuButton overflowMenuButton, View view, ActionMenuPresenter actionMenuPresenter) {
                    this.$$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(overflowMenuButton, view, actionMenuPresenter);
                }
                {
                    this.this$1 = overflowMenuButton;
                    this.val$this$0 = actionMenuPresenter;
                    super(view);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$__constructor__(android.widget.ActionMenuPresenter$OverflowMenuButton android.view.View android.widget.ActionMenuPresenter ), 0, this, overflowMenuButton, view, actionMenuPresenter);
                }

                @Override
                public ListPopupWindow getPopup() {
                    return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$getPopup(), 0, this);
                }

                @Override
                public boolean onForwardingStarted() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStarted(), 0, this);
                }

                @Override
                public boolean onForwardingStopped() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStopped", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton_1$onForwardingStopped(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            this.this$0.showOverflowMenu();
            return true;
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerBefore() {
            return false;
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerAfter() {
            return false;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            info.setCanOpenPopup(true);
        }

        private final boolean $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$setFrame(int l, int t, int r, int b) {
            boolean changed = super.setFrame(l, t, r, b);
            Drawable d = this.getDrawable();
            Drawable bg = this.getBackground();
            if (d != null && bg != null) {
                float[] pts = this.mTempPts;
                pts[0] = d.getBounds().centerX();
                this.getImageMatrix().mapPoints(pts);
                int offset = (int)pts[0] - this.getWidth() / 2;
                bg.setHotspotBounds(offset, 0, this.getWidth() + offset, this.getHeight());
            }
            return changed;
        }

        private void __constructor__(ActionMenuPresenter actionMenuPresenter, Context context) {
            this.$$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(actionMenuPresenter, context);
        }

        public OverflowMenuButton(ActionMenuPresenter actionMenuPresenter, Context context) {
            this.this$0 = actionMenuPresenter;
            super(context, null, 16843510);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$__constructor__(android.widget.ActionMenuPresenter android.content.Context ), 0, this, actionMenuPresenter, context);
        }

        @Override
        public boolean performClick() {
            return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$performClick(), 0, this);
        }

        @Override
        public boolean needsDividerBefore() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsDividerBefore", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerBefore(), 0, this);
        }

        @Override
        public boolean needsDividerAfter() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsDividerAfter", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$needsDividerAfter(), 0, this);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
        }

        @Override
        protected boolean setFrame(int n, int n2, int n3, int n4) {
            return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_ActionMenuPresenter_OverflowMenuButton$setFrame(int int int int ), 0, this, n, n2, n3, n4);
        }

        public /* synthetic */ OverflowMenuButton() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowMenuButton)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SavedState
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int openSubMenuId;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__() {
        }

        private void $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(Parcel in) {
            this.openSubMenuId = in.readInt();
        }

        private final int $$robo$$android_widget_ActionMenuPresenter_SavedState$describeContents() {
            return 0;
        }

        private final void $$robo$$android_widget_ActionMenuPresenter_SavedState$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.openSubMenuId);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_ActionMenuPresenter_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_ActionMenuPresenter_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_ActionMenuPresenter_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__();
        }

        SavedState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(parcel);
        }

        SavedState(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActionMenuPresenter_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_ActionMenuPresenter_SavedState$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_ActionMenuPresenter_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

