/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.AnimatorInflater;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Advanceable;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AdapterViewAnimator
extends AdapterView<Adapter>
implements RemoteViewsAdapter.RemoteAdapterConnectionCallback,
Advanceable {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RemoteViewAnimator";
    int mWhichChild;
    private int mRestoreWhichChild;
    boolean mAnimateFirstTime;
    int mActiveOffset;
    int mMaxNumActiveViews;
    HashMap<Integer, ViewAndMetaData> mViewsMap;
    ArrayList<Integer> mPreviousViews;
    int mCurrentWindowStart;
    int mCurrentWindowEnd;
    int mCurrentWindowStartUnbounded;
    AdapterView.AdapterDataSetObserver mDataSetObserver;
    Adapter mAdapter;
    RemoteViewsAdapter mRemoteViewsAdapter;
    boolean mDeferNotifyDataSetChanged;
    boolean mFirstTime;
    boolean mLoopViews;
    int mReferenceChildWidth;
    int mReferenceChildHeight;
    ObjectAnimator mInAnimation;
    ObjectAnimator mOutAnimation;
    private int mTouchMode;
    static int TOUCH_MODE_NONE = 0;
    static int TOUCH_MODE_DOWN_IN_CURRENT_VIEW = 1;
    static int TOUCH_MODE_HANDLED = 2;
    private Runnable mPendingCheckForTap;
    private static int DEFAULT_ANIMATION_DURATION = 200;

    private void $$robo$$android_widget_AdapterViewAnimator$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_AdapterViewAnimator$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AdapterViewAnimator$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AdapterViewAnimator$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mWhichChild = 0;
        this.mRestoreWhichChild = -1;
        this.mAnimateFirstTime = true;
        this.mActiveOffset = 0;
        this.mMaxNumActiveViews = 1;
        this.mViewsMap = new HashMap();
        this.mCurrentWindowStart = 0;
        this.mCurrentWindowEnd = -1;
        this.mCurrentWindowStartUnbounded = 0;
        this.mDeferNotifyDataSetChanged = false;
        this.mFirstTime = true;
        this.mLoopViews = true;
        this.mReferenceChildWidth = -1;
        this.mReferenceChildHeight = -1;
        this.mTouchMode = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AdapterViewAnimator, defStyleAttr, defStyleRes);
        int resource = a.getResourceId(0, 0);
        if (resource > 0) {
            this.setInAnimation(context, resource);
        } else {
            this.setInAnimation(this.getDefaultInAnimation());
        }
        resource = a.getResourceId(1, 0);
        if (resource > 0) {
            this.setOutAnimation(context, resource);
        } else {
            this.setOutAnimation(this.getDefaultOutAnimation());
        }
        boolean flag = a.getBoolean(2, true);
        this.setAnimateFirstView(flag);
        this.mLoopViews = a.getBoolean(3, false);
        a.recycle();
        this.initViewAnimator();
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$initViewAnimator() {
        this.mPreviousViews = new ArrayList();
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$configureViewAnimator(int numVisibleViews, int activeOffset) {
        if (activeOffset > numVisibleViews - 1) {
            // empty if block
        }
        this.mMaxNumActiveViews = numVisibleViews;
        this.mActiveOffset = activeOffset;
        this.mPreviousViews.clear();
        this.mViewsMap.clear();
        this.removeAllViewsInLayout();
        this.mCurrentWindowStart = 0;
        this.mCurrentWindowEnd = -1;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$transformViewForTransition(int fromIndex, int toIndex, View view, boolean animate) {
        if (fromIndex == -1) {
            this.mInAnimation.setTarget(view);
            this.mInAnimation.start();
        } else if (toIndex == -1) {
            this.mOutAnimation.setTarget(view);
            this.mOutAnimation.start();
        }
    }

    private final ObjectAnimator $$robo$$android_widget_AdapterViewAnimator$getDefaultInAnimation() {
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
        anim2.setDuration(200L);
        return anim2;
    }

    private final ObjectAnimator $$robo$$android_widget_AdapterViewAnimator$getDefaultOutAnimation() {
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
        anim2.setDuration(200L);
        return anim2;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_AdapterViewAnimator$setDisplayedChild(int whichChild) {
        this.setDisplayedChild(whichChild, true);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setDisplayedChild(int whichChild, boolean animate) {
        if (this.mAdapter != null) {
            this.mWhichChild = whichChild;
            if (whichChild >= this.getWindowSize()) {
                this.mWhichChild = this.mLoopViews ? 0 : this.getWindowSize() - 1;
            } else if (whichChild < 0) {
                this.mWhichChild = this.mLoopViews ? this.getWindowSize() - 1 : 0;
            }
            boolean hasFocus = this.getFocusedChild() != null;
            this.showOnly(this.mWhichChild, animate);
            if (hasFocus) {
                this.requestFocus(2);
            }
        }
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$applyTransformForChildAtIndex(View child, int relativeIndex) {
    }

    private final int $$robo$$android_widget_AdapterViewAnimator$getDisplayedChild() {
        return this.mWhichChild;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$showNext() {
        this.setDisplayedChild(this.mWhichChild + 1);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$showPrevious() {
        this.setDisplayedChild(this.mWhichChild - 1);
    }

    private final int $$robo$$android_widget_AdapterViewAnimator$modulo(int pos, int size) {
        if (size > 0) {
            return (size + pos % size) % size;
        }
        return 0;
    }

    private final View $$robo$$android_widget_AdapterViewAnimator$getViewAtRelativeIndex(int relativeIndex) {
        int i;
        if (relativeIndex >= 0 && relativeIndex <= this.getNumActiveViews() - 1 && this.mAdapter != null && this.mViewsMap.get(i = this.modulo(this.mCurrentWindowStartUnbounded + relativeIndex, this.getWindowSize())) != null) {
            return this.mViewsMap.get((Object)Integer.valueOf((int)i)).view;
        }
        return null;
    }

    private final int $$robo$$android_widget_AdapterViewAnimator$getNumActiveViews() {
        if (this.mAdapter != null) {
            return Math.min(this.getCount() + 1, this.mMaxNumActiveViews);
        }
        return this.mMaxNumActiveViews;
    }

    private final int $$robo$$android_widget_AdapterViewAnimator$getWindowSize() {
        if (this.mAdapter != null) {
            int adapterCount = this.getCount();
            if (adapterCount <= this.getNumActiveViews() && this.mLoopViews) {
                return adapterCount * this.mMaxNumActiveViews;
            }
            return adapterCount;
        }
        return 0;
    }

    private final ViewAndMetaData $$robo$$android_widget_AdapterViewAnimator$getMetaDataForChild(View child) {
        for (ViewAndMetaData vm : this.mViewsMap.values()) {
            if (vm.view != child) continue;
            return vm;
        }
        return null;
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_AdapterViewAnimator$createOrReuseLayoutParams(View v) {
        ViewGroup.LayoutParams currentLp = v.getLayoutParams();
        if (currentLp instanceof ViewGroup.LayoutParams) {
            ViewGroup.LayoutParams lp = currentLp;
            return lp;
        }
        return new ViewGroup.LayoutParams(0, 0);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$refreshChildren() {
        if (this.mAdapter == null) {
            return;
        }
        for (int i = this.mCurrentWindowStart; i <= this.mCurrentWindowEnd; ++i) {
            int index = this.modulo(i, this.getWindowSize());
            int adapterCount = this.getCount();
            View updatedChild = this.mAdapter.getView(this.modulo(i, adapterCount), null, this);
            if (updatedChild.getImportantForAccessibility() == 0) {
                updatedChild.setImportantForAccessibility(1);
            }
            if (!this.mViewsMap.containsKey(index)) continue;
            FrameLayout fl = (FrameLayout)this.mViewsMap.get((Object)Integer.valueOf((int)index)).view;
            if (updatedChild == null) continue;
            fl.removeAllViewsInLayout();
            fl.addView(updatedChild);
        }
    }

    private final FrameLayout $$robo$$android_widget_AdapterViewAnimator$getFrameForChild() {
        return new FrameLayout(this.mContext);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$showOnly(int childIndex, boolean animate) {
        if (this.mAdapter == null) {
            return;
        }
        int adapterCount = this.getCount();
        if (adapterCount == 0) {
            return;
        }
        for (int i = 0; i < this.mPreviousViews.size(); ++i) {
            View viewToRemove = this.mViewsMap.get((Object)this.mPreviousViews.get((int)i)).view;
            this.mViewsMap.remove(this.mPreviousViews.get(i));
            viewToRemove.clearAnimation();
            if (viewToRemove instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)viewToRemove;
                vg.removeAllViewsInLayout();
            }
            this.applyTransformForChildAtIndex(viewToRemove, -1);
            this.removeViewInLayout(viewToRemove);
        }
        this.mPreviousViews.clear();
        int newWindowStartUnbounded = childIndex - this.mActiveOffset;
        int newWindowEndUnbounded = newWindowStartUnbounded + this.getNumActiveViews() - 1;
        int newWindowStart = Math.max(0, newWindowStartUnbounded);
        int newWindowEnd = Math.min(adapterCount - 1, newWindowEndUnbounded);
        if (this.mLoopViews) {
            newWindowStart = newWindowStartUnbounded;
            newWindowEnd = newWindowEndUnbounded;
        }
        int rangeStart = this.modulo(newWindowStart, this.getWindowSize());
        int rangeEnd = this.modulo(newWindowEnd, this.getWindowSize());
        boolean wrap = false;
        if (rangeStart > rangeEnd) {
            wrap = true;
        }
        for (Integer index : this.mViewsMap.keySet()) {
            boolean remove = false;
            if (!(wrap || index >= rangeStart && index <= rangeEnd)) {
                remove = true;
            } else if (wrap && index > rangeEnd && index < rangeStart) {
                remove = true;
            }
            if (!remove) continue;
            View previousView = this.mViewsMap.get((Object)index).view;
            int oldRelativeIndex = this.mViewsMap.get((Object)index).relativeIndex;
            this.mPreviousViews.add(index);
            this.transformViewForTransition(oldRelativeIndex, -1, previousView, animate);
        }
        if (newWindowStart != this.mCurrentWindowStart || newWindowEnd != this.mCurrentWindowEnd || newWindowStartUnbounded != this.mCurrentWindowStartUnbounded) {
            for (int i = newWindowStart; i <= newWindowEnd; ++i) {
                boolean inOldRange;
                int index = this.modulo(i, this.getWindowSize());
                int oldRelativeIndex = this.mViewsMap.containsKey(index) ? this.mViewsMap.get((Object)Integer.valueOf((int)index)).relativeIndex : -1;
                int newRelativeIndex = i - newWindowStartUnbounded;
                boolean bl = inOldRange = this.mViewsMap.containsKey(index) && !this.mPreviousViews.contains(index);
                if (inOldRange) {
                    View view = this.mViewsMap.get((Object)Integer.valueOf((int)index)).view;
                    this.mViewsMap.get((Object)Integer.valueOf((int)index)).relativeIndex = newRelativeIndex;
                    this.applyTransformForChildAtIndex(view, newRelativeIndex);
                    this.transformViewForTransition(oldRelativeIndex, newRelativeIndex, view, animate);
                } else {
                    int adapterPosition = this.modulo(i, adapterCount);
                    View newView = this.mAdapter.getView(adapterPosition, null, this);
                    long itemId = this.mAdapter.getItemId(adapterPosition);
                    FrameLayout fl = this.getFrameForChild();
                    if (newView != null) {
                        fl.addView(newView);
                    }
                    this.mViewsMap.put(index, new ViewAndMetaData(this, fl, newRelativeIndex, adapterPosition, itemId));
                    this.addChild(fl);
                    this.applyTransformForChildAtIndex(fl, newRelativeIndex);
                    this.transformViewForTransition(-1, newRelativeIndex, fl, animate);
                }
                this.mViewsMap.get((Object)Integer.valueOf((int)index)).view.bringToFront();
            }
            this.mCurrentWindowStart = newWindowStart;
            this.mCurrentWindowEnd = newWindowEnd;
            this.mCurrentWindowStartUnbounded = newWindowStartUnbounded;
            if (this.mRemoteViewsAdapter != null) {
                int adapterStart = this.modulo(this.mCurrentWindowStart, adapterCount);
                int adapterEnd = this.modulo(this.mCurrentWindowEnd, adapterCount);
                this.mRemoteViewsAdapter.setVisibleRangeHint(adapterStart, adapterEnd);
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$addChild(View child) {
        this.addViewInLayout(child, -1, this.createOrReuseLayoutParams(child));
        if (this.mReferenceChildWidth == -1 || this.mReferenceChildHeight == -1) {
            int measureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
            child.measure(measureSpec, measureSpec);
            this.mReferenceChildWidth = child.getMeasuredWidth();
            this.mReferenceChildHeight = child.getMeasuredHeight();
        }
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$showTapFeedback(View v) {
        v.setPressed(true);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$hideTapFeedback(View v) {
        v.setPressed(false);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$cancelHandleClick() {
        View v = this.getCurrentView();
        if (v != null) {
            this.hideTapFeedback(v);
        }
        this.mTouchMode = 0;
    }

    private final boolean $$robo$$android_widget_AdapterViewAnimator$onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        boolean handled = false;
        switch (action) {
            case 0: {
                View v = this.getCurrentView();
                if (v == null || !this.isTransformedTouchPointInView(ev.getX(), ev.getY(), v, null)) break;
                if (this.mPendingCheckForTap == null) {
                    this.mPendingCheckForTap = new CheckForTap(this);
                }
                this.mTouchMode = 1;
                this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                if (this.mTouchMode == 1) {
                    View v = this.getCurrentView();
                    ViewAndMetaData viewData = this.getMetaDataForChild(v);
                    if (v != null && this.isTransformedTouchPointInView(ev.getX(), ev.getY(), v, null)) {
                        Handler handler = this.getHandler();
                        if (handler != null) {
                            handler.removeCallbacks(this.mPendingCheckForTap);
                        }
                        this.showTapFeedback(v);
                        this.postDelayed(new Runnable(this, v, viewData){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ View val$v;
                            /* synthetic */ ViewAndMetaData val$viewData;
                            /* synthetic */ AdapterViewAnimator this$0;

                            private void $$robo$$android_widget_AdapterViewAnimator_1$__constructor__(AdapterViewAnimator adapterViewAnimator, View view, ViewAndMetaData viewAndMetaData) {
                            }

                            private final void $$robo$$android_widget_AdapterViewAnimator_1$run() {
                                this.this$0.hideTapFeedback(this.val$v);
                                this.this$0.post(new Runnable(this){
                                    public transient /* synthetic */ Object __robo_data__;
                                    /* synthetic */ 1 this$1;

                                    private void $$robo$$android_widget_AdapterViewAnimator_1_1$__constructor__(1 var1_1) {
                                    }

                                    private final void $$robo$$android_widget_AdapterViewAnimator_1_1$run() {
                                        if (this.this$1.val$viewData != null) {
                                            this.this$1.this$0.performItemClick(this.this$1.val$v, this.this$1.val$viewData.adapterPosition, this.this$1.val$viewData.itemId);
                                        } else {
                                            this.this$1.this$0.performItemClick(this.this$1.val$v, 0, 0L);
                                        }
                                    }

                                    private void __constructor__(1 var1_1) {
                                        this.$$robo$$android_widget_AdapterViewAnimator_1_1$__constructor__(var1_1);
                                    }
                                    {
                                        this.this$1 = var1_1;
                                        this.$$robo$init();
                                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_1_1$__constructor__(android.widget.AdapterViewAnimator$1 ), 0, this, var1_1);
                                    }

                                    @Override
                                    public void run() {
                                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AdapterViewAnimator_1_1$run(), 0, this);
                                    }
                                    {
                                        this.$$robo$init();
                                    }

                                    protected /* synthetic */ void $$robo$init() {
                                        if (this.__robo_data__ == null) {
                                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                        }
                                    }

                                    public /* synthetic */ Object $$robo$getData() {
                                        return this.__robo_data__;
                                    }
                                });
                            }

                            private void __constructor__(AdapterViewAnimator adapterViewAnimator, View view, ViewAndMetaData viewAndMetaData) {
                                this.$$robo$$android_widget_AdapterViewAnimator_1$__constructor__(adapterViewAnimator, view, viewAndMetaData);
                            }
                            {
                                this.this$0 = adapterViewAnimator;
                                this.val$v = view;
                                this.val$viewData = viewAndMetaData;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_1$__constructor__(android.widget.AdapterViewAnimator android.view.View android.widget.AdapterViewAnimator$ViewAndMetaData ), 0, this, adapterViewAnimator, view, viewAndMetaData);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AdapterViewAnimator_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        }, ViewConfiguration.getPressedStateDuration());
                        handled = true;
                    }
                }
                this.mTouchMode = 0;
                break;
            }
            case 3: {
                View v = this.getCurrentView();
                if (v != null) {
                    this.hideTapFeedback(v);
                }
                this.mTouchMode = 0;
            }
        }
        return handled;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$measureChildren() {
        int count = this.getChildCount();
        int childWidth = this.getMeasuredWidth() - this.mPaddingLeft - this.mPaddingRight;
        int childHeight = this.getMeasuredHeight() - this.mPaddingTop - this.mPaddingBottom;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec(childHeight, 0x40000000));
        }
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean haveChildRefSize;
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean bl = haveChildRefSize = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        if (heightSpecMode == 0) {
            heightSpecSize = haveChildRefSize ? this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE && haveChildRefSize) {
            int height = this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom;
            heightSpecSize = height > heightSpecSize ? (heightSpecSize |= 0x1000000) : height;
        }
        if (widthSpecMode == 0) {
            widthSpecSize = haveChildRefSize ? this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE && haveChildRefSize) {
            int width = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight;
            widthSpecSize = width > widthSpecSize ? (widthSpecSize |= 0x1000000) : width;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        this.measureChildren();
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$checkForAndHandleDataChanged() {
        boolean dataChanged = this.mDataChanged;
        if (dataChanged) {
            this.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AdapterViewAnimator this$0;

                private void $$robo$$android_widget_AdapterViewAnimator_2$__constructor__(AdapterViewAnimator adapterViewAnimator) {
                }

                private final void $$robo$$android_widget_AdapterViewAnimator_2$run() {
                    this.this$0.handleDataChanged();
                    if (this.this$0.mWhichChild >= this.this$0.getWindowSize()) {
                        this.this$0.mWhichChild = 0;
                        this.this$0.showOnly(this.this$0.mWhichChild, false);
                    } else if (this.this$0.mOldItemCount != this.this$0.getCount()) {
                        this.this$0.showOnly(this.this$0.mWhichChild, false);
                    }
                    this.this$0.refreshChildren();
                    this.this$0.requestLayout();
                }

                private void __constructor__(AdapterViewAnimator adapterViewAnimator) {
                    this.$$robo$$android_widget_AdapterViewAnimator_2$__constructor__(adapterViewAnimator);
                }
                {
                    this.this$0 = adapterViewAnimator;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_2$__constructor__(android.widget.AdapterViewAnimator ), 0, this, adapterViewAnimator);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AdapterViewAnimator_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        this.mDataChanged = false;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.checkForAndHandleDataChanged();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth();
            int childBottom = this.mPaddingTop + child.getMeasuredHeight();
            child.layout(this.mPaddingLeft, this.mPaddingTop, childRight, childBottom);
        }
    }

    private final Parcelable $$robo$$android_widget_AdapterViewAnimator$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.saveRemoteViewsCache();
        }
        return new SavedState(superState, this.mWhichChild);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mWhichChild = ss.whichChild;
        if (this.mRemoteViewsAdapter != null && this.mAdapter == null) {
            this.mRestoreWhichChild = this.mWhichChild;
        } else {
            this.setDisplayedChild(this.mWhichChild, false);
        }
    }

    private final View $$robo$$android_widget_AdapterViewAnimator$getCurrentView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    private final ObjectAnimator $$robo$$android_widget_AdapterViewAnimator$getInAnimation() {
        return this.mInAnimation;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setInAnimation(ObjectAnimator inAnimation) {
        this.mInAnimation = inAnimation;
    }

    private final ObjectAnimator $$robo$$android_widget_AdapterViewAnimator$getOutAnimation() {
        return this.mOutAnimation;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setOutAnimation(ObjectAnimator outAnimation) {
        this.mOutAnimation = outAnimation;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setInAnimation(Context context, int resourceID) {
        this.setInAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, resourceID));
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setOutAnimation(Context context, int resourceID) {
        this.setOutAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, resourceID));
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setAnimateFirstView(boolean animate) {
        this.mAnimateFirstTime = animate;
    }

    private final int $$robo$$android_widget_AdapterViewAnimator$getBaseline() {
        return this.getCurrentView() != null ? this.getCurrentView().getBaseline() : super.getBaseline();
    }

    private final Adapter $$robo$$android_widget_AdapterViewAnimator$getAdapter() {
        return this.mAdapter;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setAdapter(Adapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter;
        this.checkFocus();
        if (this.mAdapter != null) {
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mItemCount = this.mAdapter.getCount();
        }
        this.setFocusable(true);
        this.mWhichChild = 0;
        this.showOnly(this.mWhichChild, false);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_AdapterViewAnimator$setRemoteViewsAdapter(Intent intent) {
        Intent.FilterComparison fcOld;
        Intent.FilterComparison fcNew;
        if (this.mRemoteViewsAdapter != null && (fcNew = new Intent.FilterComparison(intent)).equals(fcOld = new Intent.FilterComparison(this.mRemoteViewsAdapter.getRemoteViewsServiceIntent()))) {
            return;
        }
        this.mDeferNotifyDataSetChanged = false;
        this.mRemoteViewsAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
        if (this.mRemoteViewsAdapter.isDataReady()) {
            this.setAdapter(this.mRemoteViewsAdapter);
        }
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.setRemoteViewsOnClickHandler(handler);
        }
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$setSelection(int position) {
        this.setDisplayedChild(position);
    }

    private final View $$robo$$android_widget_AdapterViewAnimator$getSelectedView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$deferNotifyDataSetChanged() {
        this.mDeferNotifyDataSetChanged = true;
    }

    private final boolean $$robo$$android_widget_AdapterViewAnimator$onRemoteAdapterConnected() {
        if (this.mRemoteViewsAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteViewsAdapter);
            if (this.mDeferNotifyDataSetChanged) {
                this.mRemoteViewsAdapter.notifyDataSetChanged();
                this.mDeferNotifyDataSetChanged = false;
            }
            if (this.mRestoreWhichChild > -1) {
                this.setDisplayedChild(this.mRestoreWhichChild, false);
                this.mRestoreWhichChild = -1;
            }
            return false;
        }
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.superNotifyDataSetChanged();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onRemoteAdapterDisconnected() {
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$advance() {
        this.showNext();
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$fyiWillBeAdvancedByHostKThx() {
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(AdapterViewAnimator.class.getName());
    }

    private final void $$robo$$android_widget_AdapterViewAnimator$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(AdapterViewAnimator.class.getName());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AdapterViewAnimator$__constructor__(context);
    }

    public AdapterViewAnimator(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AdapterViewAnimator$__constructor__(context, attributeSet);
    }

    public AdapterViewAnimator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AdapterViewAnimator$__constructor__(context, attributeSet, n);
    }

    public AdapterViewAnimator(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AdapterViewAnimator$__constructor__(context, attributeSet, n, n2);
    }

    public AdapterViewAnimator(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initViewAnimator() {
        InvokeDynamicSupport.bootstrap("initViewAnimator", $$robo$$android_widget_AdapterViewAnimator$initViewAnimator(), 0, this);
    }

    void configureViewAnimator(int n, int n2) {
        InvokeDynamicSupport.bootstrap("configureViewAnimator", $$robo$$android_widget_AdapterViewAnimator$configureViewAnimator(int int ), 0, this, n, n2);
    }

    void transformViewForTransition(int n, int n2, View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("transformViewForTransition", $$robo$$android_widget_AdapterViewAnimator$transformViewForTransition(int int android.view.View boolean ), 0, this, n, n2, view, bl);
    }

    ObjectAnimator getDefaultInAnimation() {
        return InvokeDynamicSupport.bootstrap("getDefaultInAnimation", $$robo$$android_widget_AdapterViewAnimator$getDefaultInAnimation(), 0, this);
    }

    ObjectAnimator getDefaultOutAnimation() {
        return InvokeDynamicSupport.bootstrap("getDefaultOutAnimation", $$robo$$android_widget_AdapterViewAnimator$getDefaultOutAnimation(), 0, this);
    }

    @RemotableViewMethod
    public void setDisplayedChild(int n) {
        InvokeDynamicSupport.bootstrap("setDisplayedChild", $$robo$$android_widget_AdapterViewAnimator$setDisplayedChild(int ), 0, this, n);
    }

    private void setDisplayedChild(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setDisplayedChild", $$robo$$android_widget_AdapterViewAnimator$setDisplayedChild(int boolean ), 0, this, n, bl);
    }

    void applyTransformForChildAtIndex(View view, int n) {
        InvokeDynamicSupport.bootstrap("applyTransformForChildAtIndex", $$robo$$android_widget_AdapterViewAnimator$applyTransformForChildAtIndex(android.view.View int ), 0, this, view, n);
    }

    public int getDisplayedChild() {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayedChild", $$robo$$android_widget_AdapterViewAnimator$getDisplayedChild(), 0, this);
    }

    public void showNext() {
        InvokeDynamicSupport.bootstrap("showNext", $$robo$$android_widget_AdapterViewAnimator$showNext(), 0, this);
    }

    public void showPrevious() {
        InvokeDynamicSupport.bootstrap("showPrevious", $$robo$$android_widget_AdapterViewAnimator$showPrevious(), 0, this);
    }

    int modulo(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("modulo", $$robo$$android_widget_AdapterViewAnimator$modulo(int int ), 0, this, n, n2);
    }

    View getViewAtRelativeIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getViewAtRelativeIndex", $$robo$$android_widget_AdapterViewAnimator$getViewAtRelativeIndex(int ), 0, this, n);
    }

    int getNumActiveViews() {
        return (int)InvokeDynamicSupport.bootstrap("getNumActiveViews", $$robo$$android_widget_AdapterViewAnimator$getNumActiveViews(), 0, this);
    }

    int getWindowSize() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowSize", $$robo$$android_widget_AdapterViewAnimator$getWindowSize(), 0, this);
    }

    private ViewAndMetaData getMetaDataForChild(View view) {
        return InvokeDynamicSupport.bootstrap("getMetaDataForChild", $$robo$$android_widget_AdapterViewAnimator$getMetaDataForChild(android.view.View ), 0, this, view);
    }

    ViewGroup.LayoutParams createOrReuseLayoutParams(View view) {
        return InvokeDynamicSupport.bootstrap("createOrReuseLayoutParams", $$robo$$android_widget_AdapterViewAnimator$createOrReuseLayoutParams(android.view.View ), 0, this, view);
    }

    void refreshChildren() {
        InvokeDynamicSupport.bootstrap("refreshChildren", $$robo$$android_widget_AdapterViewAnimator$refreshChildren(), 0, this);
    }

    FrameLayout getFrameForChild() {
        return InvokeDynamicSupport.bootstrap("getFrameForChild", $$robo$$android_widget_AdapterViewAnimator$getFrameForChild(), 0, this);
    }

    void showOnly(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("showOnly", $$robo$$android_widget_AdapterViewAnimator$showOnly(int boolean ), 0, this, n, bl);
    }

    private void addChild(View view) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_widget_AdapterViewAnimator$addChild(android.view.View ), 0, this, view);
    }

    void showTapFeedback(View view) {
        InvokeDynamicSupport.bootstrap("showTapFeedback", $$robo$$android_widget_AdapterViewAnimator$showTapFeedback(android.view.View ), 0, this, view);
    }

    void hideTapFeedback(View view) {
        InvokeDynamicSupport.bootstrap("hideTapFeedback", $$robo$$android_widget_AdapterViewAnimator$hideTapFeedback(android.view.View ), 0, this, view);
    }

    void cancelHandleClick() {
        InvokeDynamicSupport.bootstrap("cancelHandleClick", $$robo$$android_widget_AdapterViewAnimator$cancelHandleClick(), 0, this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_AdapterViewAnimator$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void measureChildren() {
        InvokeDynamicSupport.bootstrap("measureChildren", $$robo$$android_widget_AdapterViewAnimator$measureChildren(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_AdapterViewAnimator$onMeasure(int int ), 0, this, n, n2);
    }

    void checkForAndHandleDataChanged() {
        InvokeDynamicSupport.bootstrap("checkForAndHandleDataChanged", $$robo$$android_widget_AdapterViewAnimator$checkForAndHandleDataChanged(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_AdapterViewAnimator$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_AdapterViewAnimator$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_AdapterViewAnimator$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    public View getCurrentView() {
        return InvokeDynamicSupport.bootstrap("getCurrentView", $$robo$$android_widget_AdapterViewAnimator$getCurrentView(), 0, this);
    }

    public ObjectAnimator getInAnimation() {
        return InvokeDynamicSupport.bootstrap("getInAnimation", $$robo$$android_widget_AdapterViewAnimator$getInAnimation(), 0, this);
    }

    public void setInAnimation(ObjectAnimator objectAnimator) {
        InvokeDynamicSupport.bootstrap("setInAnimation", $$robo$$android_widget_AdapterViewAnimator$setInAnimation(android.animation.ObjectAnimator ), 0, this, objectAnimator);
    }

    public ObjectAnimator getOutAnimation() {
        return InvokeDynamicSupport.bootstrap("getOutAnimation", $$robo$$android_widget_AdapterViewAnimator$getOutAnimation(), 0, this);
    }

    public void setOutAnimation(ObjectAnimator objectAnimator) {
        InvokeDynamicSupport.bootstrap("setOutAnimation", $$robo$$android_widget_AdapterViewAnimator$setOutAnimation(android.animation.ObjectAnimator ), 0, this, objectAnimator);
    }

    public void setInAnimation(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setInAnimation", $$robo$$android_widget_AdapterViewAnimator$setInAnimation(android.content.Context int ), 0, this, context, n);
    }

    public void setOutAnimation(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setOutAnimation", $$robo$$android_widget_AdapterViewAnimator$setOutAnimation(android.content.Context int ), 0, this, context, n);
    }

    public void setAnimateFirstView(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnimateFirstView", $$robo$$android_widget_AdapterViewAnimator$setAnimateFirstView(boolean ), 0, this, bl);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_AdapterViewAnimator$getBaseline(), 0, this);
    }

    @Override
    public Adapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_AdapterViewAnimator$getAdapter(), 0, this);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_AdapterViewAnimator$setAdapter(android.widget.Adapter ), 0, this, adapter);
    }

    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsAdapter", $$robo$$android_widget_AdapterViewAnimator$setRemoteViewsAdapter(android.content.Intent ), 0, this, intent);
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsOnClickHandler", $$robo$$android_widget_AdapterViewAnimator$setRemoteViewsOnClickHandler(android.widget.RemoteViews$OnClickHandler ), 0, this, onClickHandler);
    }

    @Override
    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_AdapterViewAnimator$setSelection(int ), 0, this, n);
    }

    @Override
    public View getSelectedView() {
        return InvokeDynamicSupport.bootstrap("getSelectedView", $$robo$$android_widget_AdapterViewAnimator$getSelectedView(), 0, this);
    }

    @Override
    public void deferNotifyDataSetChanged() {
        InvokeDynamicSupport.bootstrap("deferNotifyDataSetChanged", $$robo$$android_widget_AdapterViewAnimator$deferNotifyDataSetChanged(), 0, this);
    }

    @Override
    public boolean onRemoteAdapterConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("onRemoteAdapterConnected", $$robo$$android_widget_AdapterViewAnimator$onRemoteAdapterConnected(), 0, this);
    }

    @Override
    public void onRemoteAdapterDisconnected() {
        InvokeDynamicSupport.bootstrap("onRemoteAdapterDisconnected", $$robo$$android_widget_AdapterViewAnimator$onRemoteAdapterDisconnected(), 0, this);
    }

    @Override
    public void advance() {
        InvokeDynamicSupport.bootstrap("advance", $$robo$$android_widget_AdapterViewAnimator$advance(), 0, this);
    }

    @Override
    public void fyiWillBeAdvancedByHostKThx() {
        InvokeDynamicSupport.bootstrap("fyiWillBeAdvancedByHostKThx", $$robo$$android_widget_AdapterViewAnimator$fyiWillBeAdvancedByHostKThx(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_AdapterViewAnimator$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_AdapterViewAnimator$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public /* synthetic */ AdapterViewAnimator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterViewAnimator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int whichChild;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(Parcelable superState, int whichChild) {
            this.whichChild = whichChild;
        }

        private void $$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(Parcel in) {
            this.whichChild = in.readInt();
        }

        private final void $$robo$$android_widget_AdapterViewAnimator_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.whichChild);
        }

        private final String $$robo$$android_widget_AdapterViewAnimator_SavedState$toString() {
            return "AdapterViewAnimator.SavedState{ whichChild = " + this.whichChild + " }";
        }

        private /* synthetic */ void $$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_AdapterViewAnimator_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_AdapterViewAnimator_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_AdapterViewAnimator_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_AdapterViewAnimator_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_AdapterViewAnimator_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_AdapterViewAnimator_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n) {
            this.$$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(parcelable, n);
        }

        SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(android.os.Parcelable int ), 0, this, parcelable, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_AdapterViewAnimator_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_AdapterViewAnimator_SavedState$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_AdapterViewAnimator_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class CheckForTap
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AdapterViewAnimator this$0;

        private void $$robo$$android_widget_AdapterViewAnimator_CheckForTap$__constructor__(AdapterViewAnimator adapterViewAnimator) {
        }

        private final void $$robo$$android_widget_AdapterViewAnimator_CheckForTap$run() {
            if (this.this$0.mTouchMode == 1) {
                View v = this.this$0.getCurrentView();
                this.this$0.showTapFeedback(v);
            }
        }

        private void __constructor__(AdapterViewAnimator adapterViewAnimator) {
            this.$$robo$$android_widget_AdapterViewAnimator_CheckForTap$__constructor__(adapterViewAnimator);
        }

        CheckForTap(AdapterViewAnimator adapterViewAnimator) {
            this.this$0 = adapterViewAnimator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_CheckForTap$__constructor__(android.widget.AdapterViewAnimator ), 0, this, adapterViewAnimator);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AdapterViewAnimator_CheckForTap$run(), 0, this);
        }

        public /* synthetic */ CheckForTap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckForTap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ViewAndMetaData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        View view;
        int relativeIndex;
        int adapterPosition;
        long itemId;
        /* synthetic */ AdapterViewAnimator this$0;

        private void $$robo$$android_widget_AdapterViewAnimator_ViewAndMetaData$__constructor__(AdapterViewAnimator adapterViewAnimator, View view, int relativeIndex, int adapterPosition, long itemId) {
            this.view = view;
            this.relativeIndex = relativeIndex;
            this.adapterPosition = adapterPosition;
            this.itemId = itemId;
        }

        private void __constructor__(AdapterViewAnimator adapterViewAnimator, View view, int n, int n2, long l) {
            this.$$robo$$android_widget_AdapterViewAnimator_ViewAndMetaData$__constructor__(adapterViewAnimator, view, n, n2, l);
        }

        ViewAndMetaData(AdapterViewAnimator adapterViewAnimator, View view, int n, int n2, long l) {
            this.this$0 = adapterViewAnimator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterViewAnimator_ViewAndMetaData$__constructor__(android.widget.AdapterViewAnimator android.view.View int int long ), 0, this, adapterViewAnimator, view, n, n2, l);
        }

        public /* synthetic */ ViewAndMetaData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewAndMetaData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

