/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CheckedTextView
extends TextView
implements Checkable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean mChecked;
    private int mCheckMarkResource;
    private Drawable mCheckMarkDrawable;
    private ColorStateList mCheckMarkTintList;
    private PorterDuff.Mode mCheckMarkTintMode;
    private boolean mHasCheckMarkTint;
    private boolean mHasCheckMarkTintMode;
    private int mBasePadding;
    private int mCheckMarkWidth;
    private int mCheckMarkGravity;
    private boolean mNeedRequestlayout;
    private static int[] CHECKED_STATE_SET;

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCheckMarkTintList = null;
        this.mCheckMarkTintMode = null;
        this.mHasCheckMarkTint = false;
        this.mHasCheckMarkTintMode = false;
        this.mCheckMarkGravity = 0x800005;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckedTextView, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(1);
        if (d != null) {
            this.setCheckMarkDrawable(d);
        }
        if (a.hasValue(3)) {
            this.mCheckMarkTintMode = Drawable.parseTintMode(a.getInt(3, -1), this.mCheckMarkTintMode);
            this.mHasCheckMarkTintMode = true;
        }
        if (a.hasValue(2)) {
            this.mCheckMarkTintList = a.getColorStateList(2);
            this.mHasCheckMarkTint = true;
        }
        this.mCheckMarkGravity = a.getInt(4, 0x800005);
        boolean checked = a.getBoolean(0, false);
        this.setChecked(checked);
        a.recycle();
        this.applyCheckMarkTint();
    }

    private final void $$robo$$android_widget_CheckedTextView$toggle() {
        this.setChecked(!this.mChecked);
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_CheckedTextView$isChecked() {
        return this.mChecked;
    }

    private final void $$robo$$android_widget_CheckedTextView$setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(int resid) {
        if (resid != 0 && resid == this.mCheckMarkResource) {
            return;
        }
        this.mCheckMarkResource = resid;
        Drawable d = null;
        if (this.mCheckMarkResource != 0) {
            d = this.getContext().getDrawable(this.mCheckMarkResource);
        }
        this.setCheckMarkDrawable(d);
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(Drawable d) {
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setCallback(null);
            this.unscheduleDrawable(this.mCheckMarkDrawable);
        }
        boolean bl = this.mNeedRequestlayout = d != this.mCheckMarkDrawable;
        if (d != null) {
            d.setCallback(this);
            d.setVisible(this.getVisibility() == 0, false);
            d.setState(CHECKED_STATE_SET);
            this.setMinHeight(d.getIntrinsicHeight());
            this.mCheckMarkWidth = d.getIntrinsicWidth();
            d.setState(this.getDrawableState());
            this.applyCheckMarkTint();
        } else {
            this.mCheckMarkWidth = 0;
        }
        this.mCheckMarkDrawable = d;
        this.resolvePadding();
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkTintList(ColorStateList tint) {
        this.mCheckMarkTintList = tint;
        this.mHasCheckMarkTint = true;
        this.applyCheckMarkTint();
    }

    private final ColorStateList $$robo$$android_widget_CheckedTextView$getCheckMarkTintList() {
        return this.mCheckMarkTintList;
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkTintMode(PorterDuff.Mode tintMode) {
        this.mCheckMarkTintMode = tintMode;
        this.mHasCheckMarkTintMode = true;
        this.applyCheckMarkTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_CheckedTextView$getCheckMarkTintMode() {
        return this.mCheckMarkTintMode;
    }

    private final void $$robo$$android_widget_CheckedTextView$applyCheckMarkTint() {
        if (this.mCheckMarkDrawable != null && (this.mHasCheckMarkTint || this.mHasCheckMarkTintMode)) {
            this.mCheckMarkDrawable = this.mCheckMarkDrawable.mutate();
            if (this.mHasCheckMarkTint) {
                this.mCheckMarkDrawable.setTintList(this.mCheckMarkTintList);
            }
            if (this.mHasCheckMarkTintMode) {
                this.mCheckMarkDrawable.setTintMode(this.mCheckMarkTintMode);
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_CheckedTextView$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setVisible(visibility == 0, false);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.jumpToCurrentState();
        }
    }

    private final boolean $$robo$$android_widget_CheckedTextView$verifyDrawable(Drawable who) {
        return who == this.mCheckMarkDrawable || super.verifyDrawable(who);
    }

    private final Drawable $$robo$$android_widget_CheckedTextView$getCheckMarkDrawable() {
        return this.mCheckMarkDrawable;
    }

    private final void $$robo$$android_widget_CheckedTextView$internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        this.setBasePadding(this.isCheckMarkAtStart());
    }

    private final void $$robo$$android_widget_CheckedTextView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.updatePadding();
    }

    private final void $$robo$$android_widget_CheckedTextView$updatePadding() {
        int newPadding;
        this.resetPaddingToInitialValues();
        int n = newPadding = this.mCheckMarkDrawable != null ? this.mCheckMarkWidth + this.mBasePadding : this.mBasePadding;
        if (this.isCheckMarkAtStart()) {
            this.mNeedRequestlayout |= this.mPaddingLeft != newPadding;
            this.mPaddingLeft = newPadding;
        } else {
            this.mNeedRequestlayout |= this.mPaddingRight != newPadding;
            this.mPaddingRight = newPadding;
        }
        if (this.mNeedRequestlayout) {
            this.requestLayout();
            this.mNeedRequestlayout = false;
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$setBasePadding(boolean checkmarkAtStart) {
        this.mBasePadding = checkmarkAtStart ? this.mPaddingLeft : this.mPaddingRight;
    }

    private final boolean $$robo$$android_widget_CheckedTextView$isCheckMarkAtStart() {
        int gravity = Gravity.getAbsoluteGravity(this.mCheckMarkGravity, this.getLayoutDirection());
        int hgrav = gravity & 7;
        return hgrav == 3;
    }

    private final void $$robo$$android_widget_CheckedTextView$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable checkMarkDrawable = this.mCheckMarkDrawable;
        if (checkMarkDrawable != null) {
            int right;
            int left;
            int verticalGravity = this.getGravity() & 0x70;
            int height = checkMarkDrawable.getIntrinsicHeight();
            int y = 0;
            switch (verticalGravity) {
                case 80: {
                    y = this.getHeight() - height;
                    break;
                }
                case 16: {
                    y = (this.getHeight() - height) / 2;
                }
            }
            boolean checkMarkAtStart = this.isCheckMarkAtStart();
            int width = this.getWidth();
            int top = y;
            int bottom = top + height;
            if (checkMarkAtStart) {
                left = this.mBasePadding;
                right = left + this.mCheckMarkWidth;
            } else {
                right = width - this.mBasePadding;
                left = right - this.mCheckMarkWidth;
            }
            checkMarkDrawable.setBounds(this.mScrollX + left, top, this.mScrollX + right, bottom);
            checkMarkDrawable.draw(canvas);
            Drawable background = this.getBackground();
            if (background != null) {
                background.setHotspotBounds(this.mScrollX + left, top, this.mScrollX + right, bottom);
            }
        }
    }

    private final int[] $$robo$$android_widget_CheckedTextView$onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckedTextView.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    private final void $$robo$$android_widget_CheckedTextView$drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mCheckMarkDrawable != null) {
            int[] myDrawableState = this.getDrawableState();
            this.mCheckMarkDrawable.setState(myDrawableState);
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(CheckedTextView.class.getName());
        event.setChecked(this.mChecked);
    }

    private final void $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(CheckedTextView.class.getName());
        info.setCheckable(true);
        info.setChecked(this.mChecked);
    }

    static void __staticInitializer__() {
        CHECKED_STATE_SET = new int[]{0x10100A0};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context);
    }

    public CheckedTextView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843720);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet, n);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet, n, n2);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    public void toggle() {
        InvokeDynamicSupport.bootstrap("toggle", $$robo$$android_widget_CheckedTextView$toggle(), 0, this);
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_widget_CheckedTextView$isChecked(), 0, this);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_widget_CheckedTextView$setChecked(boolean ), 0, this, bl);
    }

    public void setCheckMarkDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(int ), 0, this, n);
    }

    public void setCheckMarkDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setCheckMarkTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCheckMarkTintList", $$robo$$android_widget_CheckedTextView$setCheckMarkTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getCheckMarkTintList() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkTintList", $$robo$$android_widget_CheckedTextView$getCheckMarkTintList(), 0, this);
    }

    public void setCheckMarkTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setCheckMarkTintMode", $$robo$$android_widget_CheckedTextView$setCheckMarkTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getCheckMarkTintMode() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkTintMode", $$robo$$android_widget_CheckedTextView$getCheckMarkTintMode(), 0, this);
    }

    private void applyCheckMarkTint() {
        InvokeDynamicSupport.bootstrap("applyCheckMarkTint", $$robo$$android_widget_CheckedTextView$applyCheckMarkTint(), 0, this);
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_widget_CheckedTextView$setVisibility(int ), 0, this, n);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_CheckedTextView$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_CheckedTextView$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getCheckMarkDrawable() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$getCheckMarkDrawable(), 0, this);
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("internalSetPadding", $$robo$$android_widget_CheckedTextView$internalSetPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_CheckedTextView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    private void updatePadding() {
        InvokeDynamicSupport.bootstrap("updatePadding", $$robo$$android_widget_CheckedTextView$updatePadding(), 0, this);
    }

    private void setBasePadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBasePadding", $$robo$$android_widget_CheckedTextView$setBasePadding(boolean ), 0, this, bl);
    }

    private boolean isCheckMarkAtStart() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCheckMarkAtStart", $$robo$$android_widget_CheckedTextView$isCheckMarkAtStart(), 0, this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_CheckedTextView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_CheckedTextView$onCreateDrawableState(int ), 0, this, n);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_CheckedTextView$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_CheckedTextView$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    static {
        RobolectricInternals.classInitializing(CheckedTextView.class);
    }

    public /* synthetic */ CheckedTextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckedTextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

