/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CursorAdapter
extends BaseAdapter
implements Filterable,
CursorFilter.CursorFilterClient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected boolean mDataValid;
    protected boolean mAutoRequery;
    protected Cursor mCursor;
    protected Context mContext;
    protected int mRowIDColumn;
    protected ChangeObserver mChangeObserver;
    protected DataSetObserver mDataSetObserver;
    protected CursorFilter mCursorFilter;
    protected FilterQueryProvider mFilterQueryProvider;
    @Deprecated
    public static int FLAG_AUTO_REQUERY = 1;
    public static int FLAG_REGISTER_CONTENT_OBSERVER = 2;

    @Deprecated
    private void $$robo$$android_widget_CursorAdapter$__constructor__(Context context, Cursor c) {
        this.init(context, c, 1);
    }

    private void $$robo$$android_widget_CursorAdapter$__constructor__(Context context, Cursor c, boolean autoRequery) {
        this.init(context, c, autoRequery ? 1 : 2);
    }

    private void $$robo$$android_widget_CursorAdapter$__constructor__(Context context, Cursor c, int flags) {
        this.init(context, c, flags);
    }

    @Deprecated
    private final void $$robo$$android_widget_CursorAdapter$init(Context context, Cursor c, boolean autoRequery) {
        this.init(context, c, autoRequery ? 1 : 2);
    }

    private final void $$robo$$android_widget_CursorAdapter$init(Context context, Cursor c, int flags) {
        if ((flags & 1) == 1) {
            flags |= 2;
            this.mAutoRequery = true;
        } else {
            this.mAutoRequery = false;
        }
        boolean cursorPresent = c != null;
        this.mCursor = c;
        this.mDataValid = cursorPresent;
        this.mContext = context;
        int n = this.mRowIDColumn = cursorPresent ? c.getColumnIndexOrThrow("_id") : -1;
        if ((flags & 2) == 2) {
            this.mChangeObserver = new ChangeObserver(this);
            this.mDataSetObserver = new MyDataSetObserver(this);
        } else {
            this.mChangeObserver = null;
            this.mDataSetObserver = null;
        }
        if (cursorPresent) {
            if (this.mChangeObserver != null) {
                c.registerContentObserver(this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                c.registerDataSetObserver(this.mDataSetObserver);
            }
        }
    }

    private final Cursor $$robo$$android_widget_CursorAdapter$getCursor() {
        return this.mCursor;
    }

    private final int $$robo$$android_widget_CursorAdapter$getCount() {
        if (this.mDataValid && this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    private final Object $$robo$$android_widget_CursorAdapter$getItem(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    private final long $$robo$$android_widget_CursorAdapter$getItemId(int position) {
        if (this.mDataValid && this.mCursor != null) {
            if (this.mCursor.moveToPosition(position)) {
                return this.mCursor.getLong(this.mRowIDColumn);
            }
            return 0L;
        }
        return 0L;
    }

    private final boolean $$robo$$android_widget_CursorAdapter$hasStableIds() {
        return true;
    }

    private final View $$robo$$android_widget_CursorAdapter$getView(int position, View convertView, ViewGroup parent) {
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("couldn't move cursor to position " + position);
        }
        View v = convertView == null ? this.newView(this.mContext, this.mCursor, parent) : convertView;
        this.bindView(v, this.mContext, this.mCursor);
        return v;
    }

    private final View $$robo$$android_widget_CursorAdapter$getDropDownView(int position, View convertView, ViewGroup parent) {
        if (this.mDataValid) {
            this.mCursor.moveToPosition(position);
            View v = convertView == null ? this.newDropDownView(this.mContext, this.mCursor, parent) : convertView;
            this.bindView(v, this.mContext, this.mCursor);
            return v;
        }
        return null;
    }

    public abstract View newView(Context var1, Cursor var2, ViewGroup var3);

    private final View $$robo$$android_widget_CursorAdapter$newDropDownView(Context context, Cursor cursor, ViewGroup parent) {
        return this.newView(context, cursor, parent);
    }

    public abstract void bindView(View var1, Context var2, Cursor var3);

    private final void $$robo$$android_widget_CursorAdapter$changeCursor(Cursor cursor) {
        Cursor old = this.swapCursor(cursor);
        if (old != null) {
            old.close();
        }
    }

    private final Cursor $$robo$$android_widget_CursorAdapter$swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        if (oldCursor != null) {
            if (this.mChangeObserver != null) {
                oldCursor.unregisterContentObserver(this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                oldCursor.unregisterDataSetObserver(this.mDataSetObserver);
            }
        }
        this.mCursor = newCursor;
        if (newCursor != null) {
            if (this.mChangeObserver != null) {
                newCursor.registerContentObserver(this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                newCursor.registerDataSetObserver(this.mDataSetObserver);
            }
            this.mRowIDColumn = newCursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
        return oldCursor;
    }

    private final CharSequence $$robo$$android_widget_CursorAdapter$convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    private final Cursor $$robo$$android_widget_CursorAdapter$runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mCursor;
    }

    private final Filter $$robo$$android_widget_CursorAdapter$getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    private final FilterQueryProvider $$robo$$android_widget_CursorAdapter$getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    private final void $$robo$$android_widget_CursorAdapter$setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    private final void $$robo$$android_widget_CursorAdapter$onContentChanged() {
        if (this.mAutoRequery && this.mCursor != null && !this.mCursor.isClosed()) {
            this.mDataValid = this.mCursor.requery();
        }
    }

    private void __constructor__(Context context, Cursor cursor) {
        this.$$robo$$android_widget_CursorAdapter$__constructor__(context, cursor);
    }

    public CursorAdapter(Context context, Cursor cursor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorAdapter$__constructor__(android.content.Context android.database.Cursor ), 0, this, context, cursor);
    }

    private void __constructor__(Context context, Cursor cursor, boolean bl) {
        this.$$robo$$android_widget_CursorAdapter$__constructor__(context, cursor, bl);
    }

    public CursorAdapter(Context context, Cursor cursor, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorAdapter$__constructor__(android.content.Context android.database.Cursor boolean ), 0, this, context, cursor, bl);
    }

    private void __constructor__(Context context, Cursor cursor, int n) {
        this.$$robo$$android_widget_CursorAdapter$__constructor__(context, cursor, n);
    }

    public CursorAdapter(Context context, Cursor cursor, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorAdapter$__constructor__(android.content.Context android.database.Cursor int ), 0, this, context, cursor, n);
    }

    @Deprecated
    protected void init(Context context, Cursor cursor, boolean bl) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_CursorAdapter$init(android.content.Context android.database.Cursor boolean ), 0, this, context, cursor, bl);
    }

    void init(Context context, Cursor cursor, int n) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_CursorAdapter$init(android.content.Context android.database.Cursor int ), 0, this, context, cursor, n);
    }

    @Override
    public Cursor getCursor() {
        return InvokeDynamicSupport.bootstrap("getCursor", $$robo$$android_widget_CursorAdapter$getCursor(), 0, this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_CursorAdapter$getCount(), 0, this);
    }

    @Override
    public Object getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_CursorAdapter$getItem(int ), 0, this, n);
    }

    @Override
    public long getItemId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_CursorAdapter$getItemId(int ), 0, this, n);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_CursorAdapter$hasStableIds(), 0, this);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_CursorAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    @Override
    public View getDropDownView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getDropDownView", $$robo$$android_widget_CursorAdapter$getDropDownView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    public View newDropDownView(Context context, Cursor cursor, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("newDropDownView", $$robo$$android_widget_CursorAdapter$newDropDownView(android.content.Context android.database.Cursor android.view.ViewGroup ), 0, this, context, cursor, viewGroup);
    }

    @Override
    public void changeCursor(Cursor cursor) {
        InvokeDynamicSupport.bootstrap("changeCursor", $$robo$$android_widget_CursorAdapter$changeCursor(android.database.Cursor ), 0, this, cursor);
    }

    public Cursor swapCursor(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("swapCursor", $$robo$$android_widget_CursorAdapter$swapCursor(android.database.Cursor ), 0, this, cursor);
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("convertToString", $$robo$$android_widget_CursorAdapter$convertToString(android.database.Cursor ), 0, this, cursor);
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("runQueryOnBackgroundThread", $$robo$$android_widget_CursorAdapter$runQueryOnBackgroundThread(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public Filter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_widget_CursorAdapter$getFilter(), 0, this);
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return InvokeDynamicSupport.bootstrap("getFilterQueryProvider", $$robo$$android_widget_CursorAdapter$getFilterQueryProvider(), 0, this);
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        InvokeDynamicSupport.bootstrap("setFilterQueryProvider", $$robo$$android_widget_CursorAdapter$setFilterQueryProvider(android.widget.FilterQueryProvider ), 0, this, filterQueryProvider);
    }

    protected void onContentChanged() {
        InvokeDynamicSupport.bootstrap("onContentChanged", $$robo$$android_widget_CursorAdapter$onContentChanged(), 0, this);
    }

    public /* synthetic */ CursorAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MyDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CursorAdapter this$0;

        private void $$robo$$android_widget_CursorAdapter_MyDataSetObserver$__constructor__(CursorAdapter cursorAdapter) {
        }

        private final void $$robo$$android_widget_CursorAdapter_MyDataSetObserver$onChanged() {
            this.this$0.mDataValid = true;
            this.this$0.notifyDataSetChanged();
        }

        private final void $$robo$$android_widget_CursorAdapter_MyDataSetObserver$onInvalidated() {
            this.this$0.mDataValid = false;
            this.this$0.notifyDataSetInvalidated();
        }

        private /* synthetic */ void $$robo$$android_widget_CursorAdapter_MyDataSetObserver$__constructor__(CursorAdapter x0, 1 x1) {
        }

        private void __constructor__(CursorAdapter cursorAdapter) {
            this.$$robo$$android_widget_CursorAdapter_MyDataSetObserver$__constructor__(cursorAdapter);
        }

        private MyDataSetObserver(CursorAdapter cursorAdapter) {
            this.this$0 = cursorAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorAdapter_MyDataSetObserver$__constructor__(android.widget.CursorAdapter ), 0, this, cursorAdapter);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_CursorAdapter_MyDataSetObserver$onChanged(), 0, this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_CursorAdapter_MyDataSetObserver$onInvalidated(), 0, this);
        }

        private /* synthetic */ void __constructor__(CursorAdapter cursorAdapter, 1 var2_2) {
            this.$$robo$$android_widget_CursorAdapter_MyDataSetObserver$__constructor__(cursorAdapter, var2_2);
        }

        public /* synthetic */ MyDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ChangeObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CursorAdapter this$0;

        private void $$robo$$android_widget_CursorAdapter_ChangeObserver$__constructor__(CursorAdapter cursorAdapter) {
        }

        private final boolean $$robo$$android_widget_CursorAdapter_ChangeObserver$deliverSelfNotifications() {
            return true;
        }

        private final void $$robo$$android_widget_CursorAdapter_ChangeObserver$onChange(boolean selfChange) {
            this.this$0.onContentChanged();
        }

        private void __constructor__(CursorAdapter cursorAdapter) {
            this.$$robo$$android_widget_CursorAdapter_ChangeObserver$__constructor__(cursorAdapter);
        }

        public ChangeObserver(CursorAdapter cursorAdapter) {
            this.this$0 = cursorAdapter;
            super(new Handler());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CursorAdapter_ChangeObserver$__constructor__(android.widget.CursorAdapter ), 0, this, cursorAdapter);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return (boolean)InvokeDynamicSupport.bootstrap("deliverSelfNotifications", $$robo$$android_widget_CursorAdapter_ChangeObserver$deliverSelfNotifications(), 0, this);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_CursorAdapter_ChangeObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ ChangeObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

