/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.CalendarView;
import android.widget.DatePickerCalendarDelegate;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.ICU;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DatePicker
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private static int MODE_SPINNER = 1;
    private static int MODE_CALENDAR = 2;
    private DatePickerDelegate mDelegate;

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        int mode = a.getInt(16, 1);
        int firstDayOfWeek = a.getInt(3, 0);
        a.recycle();
        switch (mode) {
            case 2: {
                this.mDelegate = this.createCalendarUIDelegate(context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                this.mDelegate = this.createSpinnerUIDelegate(context, attrs, defStyleAttr, defStyleRes);
            }
        }
        if (firstDayOfWeek != 0) {
            this.setFirstDayOfWeek(firstDayOfWeek);
        }
    }

    private final DatePickerDelegate $$robo$$android_widget_DatePicker$createSpinnerUIDelegate(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new DatePickerSpinnerDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    private final DatePickerDelegate $$robo$$android_widget_DatePicker$createCalendarUIDelegate(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new DatePickerCalendarDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    private final void $$robo$$android_widget_DatePicker$init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.mDelegate.init(year, monthOfYear, dayOfMonth, onDateChangedListener);
    }

    private final void $$robo$$android_widget_DatePicker$updateDate(int year, int month, int dayOfMonth) {
        this.mDelegate.updateDate(year, month, dayOfMonth);
    }

    private final int $$robo$$android_widget_DatePicker$getYear() {
        return this.mDelegate.getYear();
    }

    private final int $$robo$$android_widget_DatePicker$getMonth() {
        return this.mDelegate.getMonth();
    }

    private final int $$robo$$android_widget_DatePicker$getDayOfMonth() {
        return this.mDelegate.getDayOfMonth();
    }

    private final long $$robo$$android_widget_DatePicker$getMinDate() {
        return this.mDelegate.getMinDate().getTimeInMillis();
    }

    private final void $$robo$$android_widget_DatePicker$setMinDate(long minDate) {
        this.mDelegate.setMinDate(minDate);
    }

    private final long $$robo$$android_widget_DatePicker$getMaxDate() {
        return this.mDelegate.getMaxDate().getTimeInMillis();
    }

    private final void $$robo$$android_widget_DatePicker$setMaxDate(long maxDate) {
        this.mDelegate.setMaxDate(maxDate);
    }

    private final void $$robo$$android_widget_DatePicker$setValidationCallback(ValidationCallback callback) {
        this.mDelegate.setValidationCallback(callback);
    }

    private final void $$robo$$android_widget_DatePicker$setEnabled(boolean enabled) {
        if (this.mDelegate.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    private final boolean $$robo$$android_widget_DatePicker$isEnabled() {
        return this.mDelegate.isEnabled();
    }

    private final boolean $$robo$$android_widget_DatePicker$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(event);
    }

    private final void $$robo$$android_widget_DatePicker$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        this.mDelegate.onPopulateAccessibilityEvent(event);
    }

    private final void $$robo$$android_widget_DatePicker$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        this.mDelegate.onInitializeAccessibilityEvent(event);
    }

    private final void $$robo$$android_widget_DatePicker$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        this.mDelegate.onInitializeAccessibilityNodeInfo(info);
    }

    private final void $$robo$$android_widget_DatePicker$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    private final void $$robo$$android_widget_DatePicker$setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            throw new IllegalArgumentException("firstDayOfWeek must be between 1 and 7");
        }
        this.mDelegate.setFirstDayOfWeek(firstDayOfWeek);
    }

    private final int $$robo$$android_widget_DatePicker$getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    private final boolean $$robo$$android_widget_DatePicker$getCalendarViewShown() {
        return this.mDelegate.getCalendarViewShown();
    }

    private final CalendarView $$robo$$android_widget_DatePicker$getCalendarView() {
        return this.mDelegate.getCalendarView();
    }

    private final void $$robo$$android_widget_DatePicker$setCalendarViewShown(boolean shown) {
        this.mDelegate.setCalendarViewShown(shown);
    }

    private final boolean $$robo$$android_widget_DatePicker$getSpinnersShown() {
        return this.mDelegate.getSpinnersShown();
    }

    private final void $$robo$$android_widget_DatePicker$setSpinnersShown(boolean shown) {
        this.mDelegate.setSpinnersShown(shown);
    }

    private final void $$robo$$android_widget_DatePicker$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private final Parcelable $$robo$$android_widget_DatePicker$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    private final void $$robo$$android_widget_DatePicker$onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState(ss);
    }

    static void __staticInitializer__() {
        LOG_TAG = DatePicker.class.getSimpleName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context);
    }

    public DatePicker(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet);
    }

    public DatePicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet, n);
    }

    public DatePicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet, n, n2);
    }

    public DatePicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private DatePickerDelegate createSpinnerUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createSpinnerUIDelegate", $$robo$$android_widget_DatePicker$createSpinnerUIDelegate(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private DatePickerDelegate createCalendarUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createCalendarUIDelegate", $$robo$$android_widget_DatePicker$createCalendarUIDelegate(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DatePicker$init(int int int android.widget.DatePicker$OnDateChangedListener ), 0, this, n, n2, n3, onDateChangedListener);
    }

    public void updateDate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePicker$updateDate(int int int ), 0, this, n, n2, n3);
    }

    public int getYear() {
        return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_widget_DatePicker$getYear(), 0, this);
    }

    public int getMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_widget_DatePicker$getMonth(), 0, this);
    }

    public int getDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfMonth", $$robo$$android_widget_DatePicker$getDayOfMonth(), 0, this);
    }

    public long getMinDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePicker$getMinDate(), 0, this);
    }

    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DatePicker$setMinDate(long ), 0, this, l);
    }

    public long getMaxDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePicker$getMaxDate(), 0, this);
    }

    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DatePicker$setMaxDate(long ), 0, this, l);
    }

    public void setValidationCallback(ValidationCallback validationCallback) {
        InvokeDynamicSupport.bootstrap("setValidationCallback", $$robo$$android_widget_DatePicker$setValidationCallback(android.widget.DatePicker$ValidationCallback ), 0, this, validationCallback);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_DatePicker$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_DatePicker$isEnabled(), 0, this);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_DatePicker$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_DatePicker$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_DatePicker$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_DatePicker$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DatePicker$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DatePicker$setFirstDayOfWeek(int ), 0, this, n);
    }

    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DatePicker$getFirstDayOfWeek(), 0, this);
    }

    public boolean getCalendarViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCalendarViewShown", $$robo$$android_widget_DatePicker$getCalendarViewShown(), 0, this);
    }

    public CalendarView getCalendarView() {
        return InvokeDynamicSupport.bootstrap("getCalendarView", $$robo$$android_widget_DatePicker$getCalendarView(), 0, this);
    }

    public void setCalendarViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCalendarViewShown", $$robo$$android_widget_DatePicker$setCalendarViewShown(boolean ), 0, this, bl);
    }

    public boolean getSpinnersShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSpinnersShown", $$robo$$android_widget_DatePicker$getSpinnersShown(), 0, this);
    }

    public void setSpinnersShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpinnersShown", $$robo$$android_widget_DatePicker$setSpinnersShown(boolean ), 0, this, bl);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_widget_DatePicker$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_DatePicker$onSaveInstanceState(), 0, this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_DatePicker$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    static {
        RobolectricInternals.classInitializing(DatePicker.class);
    }

    public /* synthetic */ DatePicker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatePicker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mYear;
        private int mMonth;
        private int mDay;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_DatePicker_SavedState$__constructor__(Parcelable superState, int year, int month, int day) {
            this.mYear = year;
            this.mMonth = month;
            this.mDay = day;
        }

        private void $$robo$$android_widget_DatePicker_SavedState$__constructor__(Parcel in) {
            this.mYear = in.readInt();
            this.mMonth = in.readInt();
            this.mDay = in.readInt();
        }

        private final void $$robo$$android_widget_DatePicker_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYear);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mDay);
        }

        private /* synthetic */ void $$robo$$android_widget_DatePicker_SavedState$__constructor__(Parcelable x0, int x1, int x2, int x3, 1 x4) {
        }

        private /* synthetic */ void $$robo$$android_widget_DatePicker_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_DatePicker_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_DatePicker_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_DatePicker_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_DatePicker_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_DatePicker_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_DatePicker_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n, int n2, int n3) {
            this.$$robo$$android_widget_DatePicker_SavedState$__constructor__(parcelable, n, n2, n3);
        }

        private SavedState(Parcelable parcelable, int n, int n2, int n3) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_SavedState$__constructor__(android.os.Parcelable int int int ), 0, this, parcelable, n, n2, n3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_DatePicker_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_DatePicker_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcelable parcelable, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_widget_DatePicker_SavedState$__constructor__(parcelable, n, n2, n3, var5_5);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_DatePicker_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DatePickerSpinnerDelegate
    extends AbstractDatePickerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DATE_FORMAT = "MM/dd/yyyy";
        private static int DEFAULT_START_YEAR = 1900;
        private static int DEFAULT_END_YEAR = 2100;
        private static boolean DEFAULT_CALENDAR_VIEW_SHOWN = true;
        private static boolean DEFAULT_SPINNERS_SHOWN = true;
        private static boolean DEFAULT_ENABLED_STATE = true;
        private LinearLayout mSpinners;
        private NumberPicker mDaySpinner;
        private NumberPicker mMonthSpinner;
        private NumberPicker mYearSpinner;
        private EditText mDaySpinnerInput;
        private EditText mMonthSpinnerInput;
        private EditText mYearSpinnerInput;
        private CalendarView mCalendarView;
        private String[] mShortMonths;
        private java.text.DateFormat mDateFormat;
        private int mNumberOfMonths;
        private Calendar mTempDate;
        private Calendar mMinDate;
        private Calendar mMaxDate;
        private Calendar mCurrentDate;
        private boolean mIsEnabled;

        private void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$__constructor__(DatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            this.mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            this.mIsEnabled = true;
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
            TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
            boolean spinnersShown = attributesArray.getBoolean(6, true);
            boolean calendarViewShown = attributesArray.getBoolean(7, true);
            int startYear = attributesArray.getInt(1, 1900);
            int endYear = attributesArray.getInt(2, 2100);
            String minDate = attributesArray.getString(4);
            String maxDate = attributesArray.getString(5);
            int layoutResourceId = attributesArray.getResourceId(19, 17367106);
            attributesArray.recycle();
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, true);
            NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ DatePickerSpinnerDelegate this$0;

                private void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_1$__constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                }

                private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_1$onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    this.this$0.updateInputState();
                    this.this$0.mTempDate.setTimeInMillis(this.this$0.mCurrentDate.getTimeInMillis());
                    if (picker == this.this$0.mDaySpinner) {
                        int maxDayOfMonth = this.this$0.mTempDate.getActualMaximum(5);
                        if (oldVal == maxDayOfMonth && newVal == 1) {
                            this.this$0.mTempDate.add(5, 1);
                        } else if (oldVal == 1 && newVal == maxDayOfMonth) {
                            this.this$0.mTempDate.add(5, -1);
                        } else {
                            this.this$0.mTempDate.add(5, newVal - oldVal);
                        }
                    } else if (picker == this.this$0.mMonthSpinner) {
                        if (oldVal == 11 && newVal == 0) {
                            this.this$0.mTempDate.add(2, 1);
                        } else if (oldVal == 0 && newVal == 11) {
                            this.this$0.mTempDate.add(2, -1);
                        } else {
                            this.this$0.mTempDate.add(2, newVal - oldVal);
                        }
                    } else if (picker == this.this$0.mYearSpinner) {
                        this.this$0.mTempDate.set(1, newVal);
                    } else {
                        throw new IllegalArgumentException();
                    }
                    this.this$0.setDate(this.this$0.mTempDate.get(1), this.this$0.mTempDate.get(2), this.this$0.mTempDate.get(5));
                    this.this$0.updateSpinners();
                    this.this$0.updateCalendarView();
                    this.this$0.notifyDateChanged();
                }

                private void __constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                    this.$$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_1$__constructor__(datePickerSpinnerDelegate);
                }
                {
                    this.this$0 = datePickerSpinnerDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_1$__constructor__(android.widget.DatePicker$DatePickerSpinnerDelegate ), 0, this, datePickerSpinnerDelegate);
                }

                @Override
                public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_1$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mSpinners = (LinearLayout)this.mDelegator.findViewById(16909027);
            this.mCalendarView = (CalendarView)this.mDelegator.findViewById(16909031);
            this.mCalendarView.setOnDateChangeListener(new CalendarView.OnDateChangeListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ DatePickerSpinnerDelegate this$0;

                private void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_2$__constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                }

                private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_2$onSelectedDayChange(CalendarView view, int year, int month, int monthDay) {
                    this.this$0.setDate(year, month, monthDay);
                    this.this$0.updateSpinners();
                    this.this$0.notifyDateChanged();
                }

                private void __constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                    this.$$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_2$__constructor__(datePickerSpinnerDelegate);
                }
                {
                    this.this$0 = datePickerSpinnerDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_2$__constructor__(android.widget.DatePicker$DatePickerSpinnerDelegate ), 0, this, datePickerSpinnerDelegate);
                }

                @Override
                public void onSelectedDayChange(CalendarView calendarView, int n, int n2, int n3) {
                    InvokeDynamicSupport.bootstrap("onSelectedDayChange", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate_2$onSelectedDayChange(android.widget.CalendarView int int int ), 0, this, calendarView, n, n2, n3);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mDaySpinner = (NumberPicker)this.mDelegator.findViewById(16909029);
            this.mDaySpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
            this.mDaySpinner.setOnLongPressUpdateInterval(100L);
            this.mDaySpinner.setOnValueChangedListener(onChangeListener);
            this.mDaySpinnerInput = (EditText)this.mDaySpinner.findViewById(16909128);
            this.mMonthSpinner = (NumberPicker)this.mDelegator.findViewById(16909028);
            this.mMonthSpinner.setMinValue(0);
            this.mMonthSpinner.setMaxValue(this.mNumberOfMonths - 1);
            this.mMonthSpinner.setDisplayedValues(this.mShortMonths);
            this.mMonthSpinner.setOnLongPressUpdateInterval(200L);
            this.mMonthSpinner.setOnValueChangedListener(onChangeListener);
            this.mMonthSpinnerInput = (EditText)this.mMonthSpinner.findViewById(16909128);
            this.mYearSpinner = (NumberPicker)this.mDelegator.findViewById(16909030);
            this.mYearSpinner.setOnLongPressUpdateInterval(100L);
            this.mYearSpinner.setOnValueChangedListener(onChangeListener);
            this.mYearSpinnerInput = (EditText)this.mYearSpinner.findViewById(16909128);
            if (!spinnersShown && !calendarViewShown) {
                this.setSpinnersShown(true);
            } else {
                this.setSpinnersShown(spinnersShown);
                this.setCalendarViewShown(calendarViewShown);
            }
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(minDate)) {
                if (!this.parseDate(minDate, this.mTempDate)) {
                    this.mTempDate.set(startYear, 0, 1);
                }
            } else {
                this.mTempDate.set(startYear, 0, 1);
            }
            this.setMinDate(this.mTempDate.getTimeInMillis());
            this.mTempDate.clear();
            if (!TextUtils.isEmpty(maxDate)) {
                if (!this.parseDate(maxDate, this.mTempDate)) {
                    this.mTempDate.set(endYear, 11, 31);
                }
            } else {
                this.mTempDate.set(endYear, 11, 31);
            }
            this.setMaxDate(this.mTempDate.getTimeInMillis());
            this.mCurrentDate.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
            this.init(this.mCurrentDate.get(1), this.mCurrentDate.get(2), this.mCurrentDate.get(5), null);
            this.reorderSpinners();
            this.setContentDescriptions();
            if (this.mDelegator.getImportantForAccessibility() == 0) {
                this.mDelegator.setImportantForAccessibility(1);
            }
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
            this.setDate(year, monthOfYear, dayOfMonth);
            this.updateSpinners();
            this.updateCalendarView();
            this.mOnDateChangedListener = onDateChangedListener;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateDate(int year, int month, int dayOfMonth) {
            if (!this.isNewDate(year, month, dayOfMonth)) {
                return;
            }
            this.setDate(year, month, dayOfMonth);
            this.updateSpinners();
            this.updateCalendarView();
            this.notifyDateChanged();
        }

        private final int $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getYear() {
            return this.mCurrentDate.get(1);
        }

        private final int $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMonth() {
            return this.mCurrentDate.get(2);
        }

        private final int $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getDayOfMonth() {
            return this.mCurrentDate.get(5);
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setFirstDayOfWeek(int firstDayOfWeek) {
            this.mCalendarView.setFirstDayOfWeek(firstDayOfWeek);
        }

        private final int $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getFirstDayOfWeek() {
            return this.mCalendarView.getFirstDayOfWeek();
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setMinDate(long minDate) {
            this.mTempDate.setTimeInMillis(minDate);
            if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
                return;
            }
            this.mMinDate.setTimeInMillis(minDate);
            this.mCalendarView.setMinDate(minDate);
            if (this.mCurrentDate.before(this.mMinDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
                this.updateCalendarView();
            }
            this.updateSpinners();
        }

        private final Calendar $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMinDate() {
            Calendar minDate = Calendar.getInstance();
            minDate.setTimeInMillis(this.mCalendarView.getMinDate());
            return minDate;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setMaxDate(long maxDate) {
            this.mTempDate.setTimeInMillis(maxDate);
            if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
                return;
            }
            this.mMaxDate.setTimeInMillis(maxDate);
            this.mCalendarView.setMaxDate(maxDate);
            if (this.mCurrentDate.after(this.mMaxDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
                this.updateCalendarView();
            }
            this.updateSpinners();
        }

        private final Calendar $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMaxDate() {
            Calendar maxDate = Calendar.getInstance();
            maxDate.setTimeInMillis(this.mCalendarView.getMaxDate());
            return maxDate;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setEnabled(boolean enabled) {
            this.mDaySpinner.setEnabled(enabled);
            this.mMonthSpinner.setEnabled(enabled);
            this.mYearSpinner.setEnabled(enabled);
            this.mCalendarView.setEnabled(enabled);
            this.mIsEnabled = enabled;
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$isEnabled() {
            return this.mIsEnabled;
        }

        private final CalendarView $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarView() {
            return this.mCalendarView;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setCalendarViewShown(boolean shown) {
            this.mCalendarView.setVisibility(shown ? 0 : 8);
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarViewShown() {
            return this.mCalendarView.getVisibility() == 0;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setSpinnersShown(boolean shown) {
            this.mSpinners.setVisibility(shown ? 0 : 8);
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getSpinnersShown() {
            return this.mSpinners.isShown();
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onConfigurationChanged(Configuration newConfig) {
            this.setCurrentLocale(newConfig.locale);
        }

        private final Parcelable $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onSaveInstanceState(Parcelable superState) {
            return new SavedState(superState, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onRestoreInstanceState(Parcelable state) {
            SavedState ss = (SavedState)state;
            this.setDate(ss.mYear, ss.mMonth, ss.mDay);
            this.updateSpinners();
            this.updateCalendarView();
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
            this.onPopulateAccessibilityEvent(event);
            return true;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
            int flags = 20;
            String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mCurrentDate.getTimeInMillis(), 20);
            event.getText().add(selectedDateUtterance);
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onInitializeAccessibilityEvent(AccessibilityEvent event) {
            event.setClassName(DatePicker.class.getName());
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            info.setClassName(DatePicker.class.getName());
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setCurrentLocale(Locale locale) {
            super.setCurrentLocale(locale);
            this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
            this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
            this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
            this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
            this.mNumberOfMonths = this.mTempDate.getActualMaximum(2) + 1;
            this.mShortMonths = new DateFormatSymbols().getShortMonths();
            if (this.usingNumericMonths()) {
                this.mShortMonths = new String[this.mNumberOfMonths];
                for (int i = 0; i < this.mNumberOfMonths; ++i) {
                    this.mShortMonths[i] = String.format("%d", i + 1);
                }
            }
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$usingNumericMonths() {
            return Character.isDigit(this.mShortMonths[0].charAt(0));
        }

        private final Calendar $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarForLocale(Calendar oldCalendar, Locale locale) {
            if (oldCalendar == null) {
                return Calendar.getInstance(locale);
            }
            long currentTimeMillis = oldCalendar.getTimeInMillis();
            Calendar newCalendar = Calendar.getInstance(locale);
            newCalendar.setTimeInMillis(currentTimeMillis);
            return newCalendar;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$reorderSpinners() {
            this.mSpinners.removeAllViews();
            String pattern = DateFormat.getBestDateTimePattern(Locale.getDefault(), "yyyyMMMdd");
            char[] order = ICU.getDateFormatOrder(pattern);
            int spinnerCount = order.length;
            block5: for (int i = 0; i < spinnerCount; ++i) {
                switch (order[i]) {
                    case 'd': {
                        this.mSpinners.addView(this.mDaySpinner);
                        this.setImeOptions(this.mDaySpinner, spinnerCount, i);
                        continue block5;
                    }
                    case 'M': {
                        this.mSpinners.addView(this.mMonthSpinner);
                        this.setImeOptions(this.mMonthSpinner, spinnerCount, i);
                        continue block5;
                    }
                    case 'y': {
                        this.mSpinners.addView(this.mYearSpinner);
                        this.setImeOptions(this.mYearSpinner, spinnerCount, i);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException(Arrays.toString(order));
                    }
                }
            }
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$parseDate(String date, Calendar outDate) {
            try {
                outDate.setTime(this.mDateFormat.parse(date));
                return true;
            }
            catch (ParseException e) {
                Log.w(LOG_TAG, "Date: " + date + " not in format: " + "MM/dd/yyyy");
                return false;
            }
        }

        private final boolean $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$isNewDate(int year, int month, int dayOfMonth) {
            return this.mCurrentDate.get(1) != year || this.mCurrentDate.get(2) != dayOfMonth || this.mCurrentDate.get(5) != month;
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setDate(int year, int month, int dayOfMonth) {
            this.mCurrentDate.set(year, month, dayOfMonth);
            if (this.mCurrentDate.before(this.mMinDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
            } else if (this.mCurrentDate.after(this.mMaxDate)) {
                this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            }
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateSpinners() {
            if (this.mCurrentDate.equals(this.mMinDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
                this.mDaySpinner.setWrapSelectorWheel(false);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
                this.mMonthSpinner.setWrapSelectorWheel(false);
            } else if (this.mCurrentDate.equals(this.mMaxDate)) {
                this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
                this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
                this.mDaySpinner.setWrapSelectorWheel(false);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
                this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
                this.mMonthSpinner.setWrapSelectorWheel(false);
            } else {
                this.mDaySpinner.setMinValue(1);
                this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
                this.mDaySpinner.setWrapSelectorWheel(true);
                this.mMonthSpinner.setDisplayedValues(null);
                this.mMonthSpinner.setMinValue(0);
                this.mMonthSpinner.setMaxValue(11);
                this.mMonthSpinner.setWrapSelectorWheel(true);
            }
            String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.mMonthSpinner.getMinValue(), this.mMonthSpinner.getMaxValue() + 1);
            this.mMonthSpinner.setDisplayedValues(displayedValues);
            this.mYearSpinner.setMinValue(this.mMinDate.get(1));
            this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
            this.mYearSpinner.setWrapSelectorWheel(false);
            this.mYearSpinner.setValue(this.mCurrentDate.get(1));
            this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
            this.mDaySpinner.setValue(this.mCurrentDate.get(5));
            if (this.usingNumericMonths()) {
                this.mMonthSpinnerInput.setRawInputType(2);
            }
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateCalendarView() {
            this.mCalendarView.setDate(this.mCurrentDate.getTimeInMillis(), false, false);
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$notifyDateChanged() {
            this.mDelegator.sendAccessibilityEvent(4);
            if (this.mOnDateChangedListener != null) {
                this.mOnDateChangedListener.onDateChanged(this.mDelegator, this.getYear(), this.getMonth(), this.getDayOfMonth());
            }
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setImeOptions(NumberPicker spinner, int spinnerCount, int spinnerIndex) {
            int imeOptions = spinnerIndex < spinnerCount - 1 ? 5 : 6;
            TextView input = (TextView)spinner.findViewById(16909128);
            input.setImeOptions(imeOptions);
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setContentDescriptions() {
            this.trySetContentDescription(this.mDaySpinner, 16909127, 17040759);
            this.trySetContentDescription(this.mDaySpinner, 16909129, 17040760);
            this.trySetContentDescription(this.mMonthSpinner, 16909127, 17040757);
            this.trySetContentDescription(this.mMonthSpinner, 16909129, 17040758);
            this.trySetContentDescription(this.mYearSpinner, 16909127, 17040761);
            this.trySetContentDescription(this.mYearSpinner, 16909129, 17040762);
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$trySetContentDescription(View root, int viewId, int contDescResId) {
            View target = root.findViewById(viewId);
            if (target != null) {
                target.setContentDescription(this.mContext.getString(contDescResId));
            }
        }

        private final void $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateInputState() {
            InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
            if (inputMethodManager != null) {
                if (inputMethodManager.isActive(this.mYearSpinnerInput)) {
                    this.mYearSpinnerInput.clearFocus();
                    inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                } else if (inputMethodManager.isActive(this.mMonthSpinnerInput)) {
                    this.mMonthSpinnerInput.clearFocus();
                    inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                } else if (inputMethodManager.isActive(this.mDaySpinnerInput)) {
                    this.mDaySpinnerInput.clearFocus();
                    inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
                }
            }
        }

        private void __constructor__(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
            this.$$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$__constructor__(datePicker, context, attributeSet, n, n2);
        }

        DatePickerSpinnerDelegate(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
            super(datePicker, context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$__constructor__(android.widget.DatePicker android.content.Context android.util.AttributeSet int int ), 0, this, datePicker, context, attributeSet, n, n2);
        }

        @Override
        public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$init(int int int android.widget.DatePicker$OnDateChangedListener ), 0, this, n, n2, n3, onDateChangedListener);
        }

        @Override
        public void updateDate(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateDate(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public int getYear() {
            return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getYear(), 0, this);
        }

        @Override
        public int getMonth() {
            return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMonth(), 0, this);
        }

        @Override
        public int getDayOfMonth() {
            return (int)InvokeDynamicSupport.bootstrap("getDayOfMonth", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getDayOfMonth(), 0, this);
        }

        @Override
        public void setFirstDayOfWeek(int n) {
            InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setFirstDayOfWeek(int ), 0, this, n);
        }

        @Override
        public int getFirstDayOfWeek() {
            return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getFirstDayOfWeek(), 0, this);
        }

        @Override
        public void setMinDate(long l) {
            InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setMinDate(long ), 0, this, l);
        }

        @Override
        public Calendar getMinDate() {
            return InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMinDate(), 0, this);
        }

        @Override
        public void setMaxDate(long l) {
            InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setMaxDate(long ), 0, this, l);
        }

        @Override
        public Calendar getMaxDate() {
            return InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getMaxDate(), 0, this);
        }

        @Override
        public void setEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setEnabled(boolean ), 0, this, bl);
        }

        @Override
        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$isEnabled(), 0, this);
        }

        @Override
        public CalendarView getCalendarView() {
            return InvokeDynamicSupport.bootstrap("getCalendarView", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarView(), 0, this);
        }

        @Override
        public void setCalendarViewShown(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCalendarViewShown", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setCalendarViewShown(boolean ), 0, this, bl);
        }

        @Override
        public boolean getCalendarViewShown() {
            return (boolean)InvokeDynamicSupport.bootstrap("getCalendarViewShown", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarViewShown(), 0, this);
        }

        @Override
        public void setSpinnersShown(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSpinnersShown", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setSpinnersShown(boolean ), 0, this, bl);
        }

        @Override
        public boolean getSpinnersShown() {
            return (boolean)InvokeDynamicSupport.bootstrap("getSpinnersShown", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getSpinnersShown(), 0, this);
        }

        @Override
        public void onConfigurationChanged(Configuration configuration) {
            InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
        }

        @Override
        public Parcelable onSaveInstanceState(Parcelable parcelable) {
            return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onSaveInstanceState(android.os.Parcelable ), 0, this, parcelable);
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
            InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
        }

        @Override
        public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
        }

        @Override
        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
        }

        @Override
        protected void setCurrentLocale(Locale locale) {
            InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setCurrentLocale(java.util.Locale ), 0, this, locale);
        }

        private boolean usingNumericMonths() {
            return (boolean)InvokeDynamicSupport.bootstrap("usingNumericMonths", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$usingNumericMonths(), 0, this);
        }

        private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
            return InvokeDynamicSupport.bootstrap("getCalendarForLocale", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$getCalendarForLocale(java.util.Calendar java.util.Locale ), 0, this, calendar, locale);
        }

        private void reorderSpinners() {
            InvokeDynamicSupport.bootstrap("reorderSpinners", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$reorderSpinners(), 0, this);
        }

        private boolean parseDate(String string2, Calendar calendar) {
            return (boolean)InvokeDynamicSupport.bootstrap("parseDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$parseDate(java.lang.String java.util.Calendar ), 0, this, string2, calendar);
        }

        private boolean isNewDate(int n, int n2, int n3) {
            return (boolean)InvokeDynamicSupport.bootstrap("isNewDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$isNewDate(int int int ), 0, this, n, n2, n3);
        }

        private void setDate(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setDate(int int int ), 0, this, n, n2, n3);
        }

        private void updateSpinners() {
            InvokeDynamicSupport.bootstrap("updateSpinners", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateSpinners(), 0, this);
        }

        private void updateCalendarView() {
            InvokeDynamicSupport.bootstrap("updateCalendarView", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateCalendarView(), 0, this);
        }

        private void notifyDateChanged() {
            InvokeDynamicSupport.bootstrap("notifyDateChanged", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$notifyDateChanged(), 0, this);
        }

        private void setImeOptions(NumberPicker numberPicker, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setImeOptions", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setImeOptions(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
        }

        private void setContentDescriptions() {
            InvokeDynamicSupport.bootstrap("setContentDescriptions", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$setContentDescriptions(), 0, this);
        }

        private void trySetContentDescription(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrap("trySetContentDescription", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$trySetContentDescription(android.view.View int int ), 0, this, view, n, n2);
        }

        private void updateInputState() {
            InvokeDynamicSupport.bootstrap("updateInputState", $$robo$$android_widget_DatePicker_DatePickerSpinnerDelegate$updateInputState(), 0, this);
        }

        public /* synthetic */ DatePickerSpinnerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatePickerSpinnerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ValidationCallback
    extends InstrumentedInterface {
        public void onValidationChanged(boolean var1);
    }

    public static abstract class AbstractDatePickerDelegate
    implements DatePickerDelegate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected DatePicker mDelegator;
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected OnDateChangedListener mOnDateChangedListener;
        protected ValidationCallback mValidationCallback;

        private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(DatePicker delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setValidationCallback(ValidationCallback callback) {
            this.mValidationCallback = callback;
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onValidationChanged(boolean valid) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(valid);
            }
        }

        private void __constructor__(DatePicker datePicker, Context context) {
            this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(datePicker, context);
        }

        public AbstractDatePickerDelegate(DatePicker datePicker, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(android.widget.DatePicker android.content.Context ), 0, this, datePicker, context);
        }

        protected void setCurrentLocale(Locale locale) {
            InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setCurrentLocale(java.util.Locale ), 0, this, locale);
        }

        @Override
        public void setValidationCallback(ValidationCallback validationCallback) {
            InvokeDynamicSupport.bootstrap("setValidationCallback", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setValidationCallback(android.widget.DatePicker$ValidationCallback ), 0, this, validationCallback);
        }

        protected void onValidationChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onValidationChanged", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onValidationChanged(boolean ), 0, this, bl);
        }

        public /* synthetic */ AbstractDatePickerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractDatePickerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface DatePickerDelegate
    extends InstrumentedInterface {
        public void init(int var1, int var2, int var3, OnDateChangedListener var4);

        public void updateDate(int var1, int var2, int var3);

        public int getYear();

        public int getMonth();

        public int getDayOfMonth();

        public void setFirstDayOfWeek(int var1);

        public int getFirstDayOfWeek();

        public void setMinDate(long var1);

        public Calendar getMinDate();

        public void setMaxDate(long var1);

        public Calendar getMaxDate();

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public CalendarView getCalendarView();

        public void setCalendarViewShown(boolean var1);

        public boolean getCalendarViewShown();

        public void setSpinnersShown(boolean var1);

        public boolean getSpinnersShown();

        public void setValidationCallback(ValidationCallback var1);

        public void onConfigurationChanged(Configuration var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onInitializeAccessibilityEvent(AccessibilityEvent var1);

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo var1);
    }

    public static interface OnDateChangedListener
    extends InstrumentedInterface {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }
}

