/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.widget.CalendarView;
import android.widget.DatePicker;
import android.widget.DatePickerController;
import android.widget.DayPickerView;
import android.widget.LinearLayout;
import android.widget.OnDateChangedListener;
import android.widget.TextView;
import android.widget.YearPickerView;
import com.android.internal.R;
import com.android.internal.widget.AccessibleDateAnimator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DatePickerCalendarDelegate
extends DatePicker.AbstractDatePickerDelegate
implements View.OnClickListener,
DatePickerController,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int USE_LOCALE = 0;
    private static int UNINITIALIZED = -1;
    private static int MONTH_AND_DAY_VIEW = 0;
    private static int YEAR_VIEW = 1;
    private static int DEFAULT_START_YEAR = 1900;
    private static int DEFAULT_END_YEAR = 2100;
    private static int ANIMATION_DURATION = 300;
    private static int MONTH_INDEX = 0;
    private static int DAY_INDEX = 1;
    private static int YEAR_INDEX = 2;
    private SimpleDateFormat mYearFormat;
    private SimpleDateFormat mDayFormat;
    private TextView mDayOfWeekView;
    private LinearLayout mMonthDayYearLayout;
    private LinearLayout mMonthAndDayLayout;
    private TextView mHeaderMonthTextView;
    private TextView mHeaderDayOfMonthTextView;
    private TextView mHeaderYearTextView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private boolean mIsEnabled;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private AccessibleDateAnimator mAnimator;
    private DatePicker.OnDateChangedListener mDateChangedListener;
    private int mCurrentView;
    private Calendar mCurrentDate;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private int mFirstDayOfWeek;
    private HashSet<OnDateChangedListener> mListeners;

    private void $$robo$$android_widget_DatePickerCalendarDelegate$__constructor__(DatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mYearFormat = new SimpleDateFormat("y", Locale.getDefault());
        this.mDayFormat = new SimpleDateFormat("d", Locale.getDefault());
        this.mIsEnabled = true;
        this.mCurrentView = -1;
        this.mFirstDayOfWeek = 0;
        this.mListeners = new HashSet();
        Locale locale = Locale.getDefault();
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mTempDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mMinDate.set(1900, 1, 1);
        this.mMaxDate.set(2100, 12, 31);
        Resources res = this.mDelegator.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        int layoutResourceId = a.getResourceId(17, 17367105);
        View mainView = inflater.inflate(layoutResourceId, null);
        this.mDelegator.addView(mainView);
        this.mDayOfWeekView = (TextView)mainView.findViewById(16909033);
        LinearLayout dateLayout = (LinearLayout)mainView.findViewById(16909032);
        this.mMonthDayYearLayout = (LinearLayout)mainView.findViewById(16909034);
        this.mMonthAndDayLayout = (LinearLayout)mainView.findViewById(16909035);
        this.mMonthAndDayLayout.setOnClickListener(this);
        this.mHeaderMonthTextView = (TextView)mainView.findViewById(16909036);
        this.mHeaderDayOfMonthTextView = (TextView)mainView.findViewById(16909037);
        this.mHeaderYearTextView = (TextView)mainView.findViewById(16909038);
        this.mHeaderYearTextView.setOnClickListener(this);
        int defaultHighlightColor = this.mHeaderYearTextView.getHighlightColor();
        int dayOfWeekTextAppearanceResId = a.getResourceId(9, -1);
        if (dayOfWeekTextAppearanceResId != -1) {
            this.mDayOfWeekView.setTextAppearance(context, dayOfWeekTextAppearanceResId);
        }
        this.mDayOfWeekView.setBackground(a.getDrawable(8));
        dateLayout.setBackground(a.getDrawable(0));
        int headerSelectedTextColor = a.getColor(20, defaultHighlightColor);
        int monthTextAppearanceResId = a.getResourceId(10, -1);
        if (monthTextAppearanceResId != -1) {
            this.mHeaderMonthTextView.setTextAppearance(context, monthTextAppearanceResId);
        }
        this.mHeaderMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderMonthTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int dayOfMonthTextAppearanceResId = a.getResourceId(11, -1);
        if (dayOfMonthTextAppearanceResId != -1) {
            this.mHeaderDayOfMonthTextView.setTextAppearance(context, dayOfMonthTextAppearanceResId);
        }
        this.mHeaderDayOfMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderDayOfMonthTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int yearTextAppearanceResId = a.getResourceId(12, -1);
        if (yearTextAppearanceResId != -1) {
            this.mHeaderYearTextView.setTextAppearance(context, yearTextAppearanceResId);
        }
        this.mHeaderYearTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderYearTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        this.mDayPickerView = new DayPickerView(this.mContext, this);
        this.mYearPickerView = new YearPickerView(this.mContext);
        this.mYearPickerView.init(this);
        int yearSelectedCircleColor = a.getColor(14, defaultHighlightColor);
        this.mYearPickerView.setYearSelectedCircleColor(yearSelectedCircleColor);
        ColorStateList calendarTextColor = a.getColorStateList(15);
        int calendarSelectedTextColor = a.getColor(18, defaultHighlightColor);
        this.mDayPickerView.setCalendarTextColor(ColorStateList.addFirstIfMissing(calendarTextColor, 0x10100A1, calendarSelectedTextColor));
        this.mDayPickerDescription = res.getString(17040999);
        this.mSelectDay = res.getString(17041001);
        this.mYearPickerDescription = res.getString(17041000);
        this.mSelectYear = res.getString(17041002);
        this.mAnimator = (AccessibleDateAnimator)mainView.findViewById(16909039);
        this.mAnimator.addView(this.mDayPickerView);
        this.mAnimator.addView(this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCurrentDate.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation(animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation(animation2);
        this.updateDisplay(false);
        this.setCurrentView(0);
    }

    private final Calendar $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private final int[] $$robo$$android_widget_DatePickerCalendarDelegate$getMonthDayYearIndexes(String pattern) {
        int[] result = new int[3];
        String filteredPattern = pattern.replaceAll("'.*?'", "");
        int dayIndex = filteredPattern.indexOf(100);
        int monthMIndex = filteredPattern.indexOf("M");
        int monthIndex = monthMIndex != -1 ? monthMIndex : filteredPattern.indexOf("L");
        int yearIndex = filteredPattern.indexOf("y");
        if (yearIndex < monthIndex) {
            result[2] = 0;
            if (monthIndex < dayIndex) {
                result[0] = 1;
                result[1] = 2;
            } else {
                result[0] = 2;
                result[1] = 1;
            }
        } else {
            result[2] = 2;
            if (monthIndex < dayIndex) {
                result[0] = 0;
                result[1] = 1;
            } else {
                result[0] = 1;
                result[1] = 0;
            }
        }
        return result;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText(this.mCurrentDate.getDisplayName(7, 2, Locale.getDefault()));
        }
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "yMMMd");
        int[] viewIndices = this.getMonthDayYearIndexes(bestDateTimePattern);
        this.mMonthDayYearLayout.removeAllViews();
        if (viewIndices[2] == 0) {
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
        } else {
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
        }
        this.mMonthAndDayLayout.removeAllViews();
        if (viewIndices[0] > viewIndices[1]) {
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
        } else {
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
        }
        this.mHeaderMonthTextView.setText(this.mCurrentDate.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mHeaderDayOfMonthTextView.setText(this.mDayFormat.format(this.mCurrentDate.getTime()));
        this.mHeaderYearTextView.setText(this.mYearFormat.format(this.mCurrentDate.getTime()));
        long millis = this.mCurrentDate.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime(this.mContext, millis, flags);
        this.mMonthAndDayLayout.setContentDescription(monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime(this.mContext, millis, flags);
            this.mAnimator.announceForAccessibility(fullDateText);
        }
        this.updatePickers();
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setCurrentView(int viewIndex) {
        long millis = this.mCurrentDate.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayLayout.setSelected(true);
                    this.mHeaderYearTextView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                int flags = 16;
                String dayString = DateUtils.formatDateTime(this.mContext, millis, 16);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                this.mAnimator.announceForAccessibility(this.mSelectDay);
                break;
            }
            case 1: {
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayLayout.setSelected(false);
                    this.mHeaderYearTextView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                String yearString = this.mYearFormat.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                this.mAnimator.announceForAccessibility(this.mSelectYear);
            }
        }
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$init(int year, int monthOfYear, int dayOfMonth, DatePicker.OnDateChangedListener callBack) {
        this.mDateChangedListener = callBack;
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, monthOfYear);
        this.mCurrentDate.set(5, dayOfMonth);
        this.updateDisplay(false);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        if (this.mDateChangedListener != null) {
            this.mDateChangedListener.onDateChanged(this.mDelegator, year, month, dayOfMonth);
        }
        this.updateDisplay(false);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getYear() {
        return this.mCurrentDate.get(1);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMonth() {
        return this.mCurrentDate.get(2);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.before(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(minDate);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    private final Calendar $$robo$$android_widget_DatePickerCalendarDelegate$getMinDate() {
        return this.mMinDate;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.after(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(maxDate);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    private final Calendar $$robo$$android_widget_DatePickerCalendarDelegate$getMaxDate() {
        return this.mMaxDate;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setFirstDayOfWeek(int firstDayOfWeek) {
        this.mFirstDayOfWeek = firstDayOfWeek;
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getFirstDayOfWeek() {
        if (this.mFirstDayOfWeek != 0) {
            return this.mFirstDayOfWeek;
        }
        return this.mCurrentDate.getFirstDayOfWeek();
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMinYear() {
        return this.mMinDate.get(1);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMaxYear() {
        return this.mMaxDate.get(1);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMinMonth() {
        return this.mMinDate.get(2);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMaxMonth() {
        return this.mMaxDate.get(2);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMinDay() {
        return this.mMinDate.get(5);
    }

    private final int $$robo$$android_widget_DatePickerCalendarDelegate$getMaxDay() {
        return this.mMaxDate.get(5);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setEnabled(boolean enabled) {
        this.mMonthAndDayLayout.setEnabled(enabled);
        this.mHeaderYearTextView.setEnabled(enabled);
        this.mAnimator.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_DatePickerCalendarDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final CalendarView $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarView() {
        throw new UnsupportedOperationException("CalendarView does not exists for the new DatePicker");
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setCalendarViewShown(boolean shown) {
    }

    private final boolean $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarViewShown() {
        return false;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$setSpinnersShown(boolean shown) {
    }

    private final boolean $$robo$$android_widget_DatePickerCalendarDelegate$getSpinnersShown() {
        return false;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onConfigurationChanged(Configuration newConfig) {
        this.mYearFormat = new SimpleDateFormat("y", newConfig.locale);
        this.mDayFormat = new SimpleDateFormat("d", newConfig.locale);
    }

    private final Parcelable $$robo$$android_widget_DatePickerCalendarDelegate$onSaveInstanceState(Parcelable superState) {
        int year = this.mCurrentDate.get(1);
        int month = this.mCurrentDate.get(2);
        int day = this.mCurrentDate.get(5);
        int listPosition = -1;
        int listPositionOffset = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionOffset = this.mYearPickerView.getFirstPositionOffset();
        }
        return new SavedState(superState, year, month, day, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, listPosition, listPositionOffset);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mCurrentDate.set(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
        this.mCurrentView = ss.getCurrentView();
        this.mMinDate.setTimeInMillis(ss.getMinDate());
        this.mMaxDate.setTimeInMillis(ss.getMaxDate());
        this.updateDisplay(false);
        this.setCurrentView(this.mCurrentView);
        int listPosition = ss.getListPosition();
        if (listPosition != -1) {
            if (this.mCurrentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (this.mCurrentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, ss.getListPositionOffset());
            }
        }
    }

    private final boolean $$robo$$android_widget_DatePickerCalendarDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.getText().add(this.mCurrentDate.getTime().toString());
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(DatePicker.class.getName());
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setClassName(DatePicker.class.getName());
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCurrentDate.get(2), year);
        this.mCurrentDate.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCurrentDate.get(5);
        if (day > (daysInMonth = DatePickerCalendarDelegate.getDaysInMonth(month, year))) {
            this.mCurrentDate.set(5, daysInMonth);
        }
    }

    private static final int $$robo$$android_widget_DatePickerCalendarDelegate$getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onDayOfMonthSelected(int year, int month, int day) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$updatePickers() {
        for (OnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    private final Calendar $$robo$$android_widget_DatePickerCalendarDelegate$getSelectedDay() {
        return this.mCurrentDate;
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$tryVibrate() {
        this.mDelegator.performHapticFeedback(5);
    }

    private final void $$robo$$android_widget_DatePickerCalendarDelegate$onClick(View v) {
        this.tryVibrate();
        if (v.getId() == 16909038) {
            this.setCurrentView(1);
        } else if (v.getId() == 16909035) {
            this.setCurrentView(0);
        }
    }

    private void __constructor__(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_DatePickerCalendarDelegate$__constructor__(datePicker, context, attributeSet, n, n2);
    }

    public DatePickerCalendarDelegate(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(datePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerCalendarDelegate$__constructor__(android.widget.DatePicker android.content.Context android.util.AttributeSet int int ), 0, this, datePicker, context, attributeSet, n, n2);
    }

    private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getCalendarForLocale", $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarForLocale(java.util.Calendar java.util.Locale ), 0, this, calendar, locale);
    }

    private int[] getMonthDayYearIndexes(String string2) {
        return InvokeDynamicSupport.bootstrap("getMonthDayYearIndexes", $$robo$$android_widget_DatePickerCalendarDelegate$getMonthDayYearIndexes(java.lang.String ), 0, this, string2);
    }

    private void updateDisplay(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateDisplay", $$robo$$android_widget_DatePickerCalendarDelegate$updateDisplay(boolean ), 0, this, bl);
    }

    private void setCurrentView(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentView", $$robo$$android_widget_DatePickerCalendarDelegate$setCurrentView(int ), 0, this, n);
    }

    @Override
    public void init(int n, int n2, int n3, DatePicker.OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DatePickerCalendarDelegate$init(int int int android.widget.DatePicker$OnDateChangedListener ), 0, this, n, n2, n3, onDateChangedListener);
    }

    @Override
    public void updateDate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePickerCalendarDelegate$updateDate(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public int getYear() {
        return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_widget_DatePickerCalendarDelegate$getYear(), 0, this);
    }

    @Override
    public int getMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_widget_DatePickerCalendarDelegate$getMonth(), 0, this);
    }

    @Override
    public int getDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfMonth", $$robo$$android_widget_DatePickerCalendarDelegate$getDayOfMonth(), 0, this);
    }

    @Override
    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DatePickerCalendarDelegate$setMinDate(long ), 0, this, l);
    }

    @Override
    public Calendar getMinDate() {
        return InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePickerCalendarDelegate$getMinDate(), 0, this);
    }

    @Override
    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DatePickerCalendarDelegate$setMaxDate(long ), 0, this, l);
    }

    @Override
    public Calendar getMaxDate() {
        return InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePickerCalendarDelegate$getMaxDate(), 0, this);
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DatePickerCalendarDelegate$setFirstDayOfWeek(int ), 0, this, n);
    }

    @Override
    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DatePickerCalendarDelegate$getFirstDayOfWeek(), 0, this);
    }

    @Override
    public int getMinYear() {
        return (int)InvokeDynamicSupport.bootstrap("getMinYear", $$robo$$android_widget_DatePickerCalendarDelegate$getMinYear(), 0, this);
    }

    @Override
    public int getMaxYear() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxYear", $$robo$$android_widget_DatePickerCalendarDelegate$getMaxYear(), 0, this);
    }

    @Override
    public int getMinMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinMonth", $$robo$$android_widget_DatePickerCalendarDelegate$getMinMonth(), 0, this);
    }

    @Override
    public int getMaxMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxMonth", $$robo$$android_widget_DatePickerCalendarDelegate$getMaxMonth(), 0, this);
    }

    @Override
    public int getMinDay() {
        return (int)InvokeDynamicSupport.bootstrap("getMinDay", $$robo$$android_widget_DatePickerCalendarDelegate$getMinDay(), 0, this);
    }

    @Override
    public int getMaxDay() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxDay", $$robo$$android_widget_DatePickerCalendarDelegate$getMaxDay(), 0, this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_DatePickerCalendarDelegate$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_DatePickerCalendarDelegate$isEnabled(), 0, this);
    }

    @Override
    public CalendarView getCalendarView() {
        return InvokeDynamicSupport.bootstrap("getCalendarView", $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarView(), 0, this);
    }

    @Override
    public void setCalendarViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCalendarViewShown", $$robo$$android_widget_DatePickerCalendarDelegate$setCalendarViewShown(boolean ), 0, this, bl);
    }

    @Override
    public boolean getCalendarViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCalendarViewShown", $$robo$$android_widget_DatePickerCalendarDelegate$getCalendarViewShown(), 0, this);
    }

    @Override
    public void setSpinnersShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpinnersShown", $$robo$$android_widget_DatePickerCalendarDelegate$setSpinnersShown(boolean ), 0, this, bl);
    }

    @Override
    public boolean getSpinnersShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSpinnersShown", $$robo$$android_widget_DatePickerCalendarDelegate$getSpinnersShown(), 0, this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DatePickerCalendarDelegate$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_DatePickerCalendarDelegate$onSaveInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_DatePickerCalendarDelegate$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_DatePickerCalendarDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_DatePickerCalendarDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_DatePickerCalendarDelegate$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_DatePickerCalendarDelegate$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public void onYearSelected(int n) {
        InvokeDynamicSupport.bootstrap("onYearSelected", $$robo$$android_widget_DatePickerCalendarDelegate$onYearSelected(int ), 0, this, n);
    }

    private void adjustDayInMonthIfNeeded(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustDayInMonthIfNeeded", $$robo$$android_widget_DatePickerCalendarDelegate$adjustDayInMonthIfNeeded(int int ), 0, this, n, n2);
    }

    public static int getDaysInMonth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDaysInMonth", $$robo$$android_widget_DatePickerCalendarDelegate$getDaysInMonth(int int ), 0, (int)n, (int)n2);
    }

    @Override
    public void onDayOfMonthSelected(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onDayOfMonthSelected", $$robo$$android_widget_DatePickerCalendarDelegate$onDayOfMonthSelected(int int int ), 0, this, n, n2, n3);
    }

    private void updatePickers() {
        InvokeDynamicSupport.bootstrap("updatePickers", $$robo$$android_widget_DatePickerCalendarDelegate$updatePickers(), 0, this);
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("registerOnDateChangedListener", $$robo$$android_widget_DatePickerCalendarDelegate$registerOnDateChangedListener(android.widget.OnDateChangedListener ), 0, this, onDateChangedListener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("unregisterOnDateChangedListener", $$robo$$android_widget_DatePickerCalendarDelegate$unregisterOnDateChangedListener(android.widget.OnDateChangedListener ), 0, this, onDateChangedListener);
    }

    @Override
    public Calendar getSelectedDay() {
        return InvokeDynamicSupport.bootstrap("getSelectedDay", $$robo$$android_widget_DatePickerCalendarDelegate$getSelectedDay(), 0, this);
    }

    @Override
    public void tryVibrate() {
        InvokeDynamicSupport.bootstrap("tryVibrate", $$robo$$android_widget_DatePickerCalendarDelegate$tryVibrate(), 0, this);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_DatePickerCalendarDelegate$onClick(android.view.View ), 0, this, view);
    }

    public /* synthetic */ DatePickerCalendarDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatePickerCalendarDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSelectedYear;
        private int mSelectedMonth;
        private int mSelectedDay;
        private long mMinDate;
        private long mMaxDate;
        private int mCurrentView;
        private int mListPosition;
        private int mListPositionOffset;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(Parcelable superState, int year, int month, int day, long minDate, long maxDate, int currentView, int listPosition, int listPositionOffset) {
            this.mSelectedYear = year;
            this.mSelectedMonth = month;
            this.mSelectedDay = day;
            this.mMinDate = minDate;
            this.mMaxDate = maxDate;
            this.mCurrentView = currentView;
            this.mListPosition = listPosition;
            this.mListPositionOffset = listPositionOffset;
        }

        private void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(Parcel in) {
            this.mSelectedYear = in.readInt();
            this.mSelectedMonth = in.readInt();
            this.mSelectedDay = in.readInt();
            this.mMinDate = in.readLong();
            this.mMaxDate = in.readLong();
            this.mCurrentView = in.readInt();
            this.mListPosition = in.readInt();
            this.mListPositionOffset = in.readInt();
        }

        private final void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedYear);
            dest.writeInt(this.mSelectedMonth);
            dest.writeInt(this.mSelectedDay);
            dest.writeLong(this.mMinDate);
            dest.writeLong(this.mMaxDate);
            dest.writeInt(this.mCurrentView);
            dest.writeInt(this.mListPosition);
            dest.writeInt(this.mListPositionOffset);
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedDay() {
            return this.mSelectedDay;
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedMonth() {
            return this.mSelectedMonth;
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedYear() {
            return this.mSelectedYear;
        }

        private final long $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getMinDate() {
            return this.mMinDate;
        }

        private final long $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getMaxDate() {
            return this.mMaxDate;
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getCurrentView() {
            return this.mCurrentView;
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getListPosition() {
            return this.mListPosition;
        }

        private final int $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getListPositionOffset() {
            return this.mListPositionOffset;
        }

        private /* synthetic */ void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(Parcelable x0, int x1, int x2, int x3, long x4, long x5, int x6, int x7, int x8, 1 x9) {
        }

        private /* synthetic */ void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6) {
            this.$$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(parcelable, n, n2, n3, l, l2, n4, n5, n6);
        }

        private SavedState(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(android.os.Parcelable int int int long long int int int ), 0, this, parcelable, n, n2, n3, l, l2, n4, n5, n6);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public int getSelectedDay() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedDay", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedDay(), 0, this);
        }

        public int getSelectedMonth() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedMonth", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedMonth(), 0, this);
        }

        public int getSelectedYear() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedYear", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getSelectedYear(), 0, this);
        }

        public long getMinDate() {
            return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getMinDate(), 0, this);
        }

        public long getMaxDate() {
            return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getMaxDate(), 0, this);
        }

        public int getCurrentView() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentView", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getCurrentView(), 0, this);
        }

        public int getListPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getListPosition", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getListPosition(), 0, this);
        }

        public int getListPositionOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getListPositionOffset", $$robo$$android_widget_DatePickerCalendarDelegate_SavedState$getListPositionOffset(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6, 1 var12_10) {
            this.$$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(parcelable, n, n2, n3, l, l2, n4, n5, n6, var12_10);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_DatePickerCalendarDelegate_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

