/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsListView;
import android.widget.DatePickerController;
import android.widget.ListView;
import android.widget.OnDateChangedListener;
import android.widget.SimpleMonthAdapter;
import android.widget.SimpleMonthView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
OnDateChangedListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DayPickerView";
    private static int GOTO_SCROLL_DURATION = 250;
    private static int SCROLL_CHANGE_DELAY = 40;
    private static int LIST_TOP_OFFSET;
    private SimpleDateFormat mYearFormat;
    private float mFriction;
    private Calendar mSelectedDay;
    private SimpleMonthAdapter mAdapter;
    private Calendar mTempDay;
    private int mCurrentMonthDisplayed;
    private int mPreviousScrollState;
    private int mCurrentScrollState;
    private DatePickerController mController;
    private boolean mPerformingScroll;
    private ScrollStateRunnable mScrollStateChangedRunnable;

    private void $$robo$$android_widget_DayPickerView$__constructor__(Context context, DatePickerController controller) {
        this.mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
        this.mFriction = 1.0f;
        this.mSelectedDay = Calendar.getInstance();
        this.mTempDay = Calendar.getInstance();
        this.mPreviousScrollState = 0;
        this.mCurrentScrollState = 0;
        this.mScrollStateChangedRunnable = new ScrollStateRunnable(this, this);
        this.init();
        this.setController(controller);
    }

    private final void $$robo$$android_widget_DayPickerView$setController(DatePickerController controller) {
        if (this.mController != null) {
            this.mController.unregisterOnDateChangedListener(this);
        }
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.setUpAdapter();
        this.setAdapter(this.mAdapter);
        this.onDateChanged();
    }

    private final void $$robo$$android_widget_DayPickerView$init() {
        this.setLayoutParams(new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.setUpListView();
    }

    private final void $$robo$$android_widget_DayPickerView$onChange() {
        this.setUpAdapter();
        this.setAdapter(this.mAdapter);
    }

    private final void $$robo$$android_widget_DayPickerView$setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new SimpleMonthAdapter(this.getContext(), this.mController);
        } else {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
            this.mAdapter.notifyDataSetChanged();
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_DayPickerView$setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFriction(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    private final int $$robo$$android_widget_DayPickerView$getDiffMonths(Calendar start, Calendar end) {
        int diffYears = end.get(1) - start.get(1);
        int diffMonths = end.get(2) - start.get(2) + 12 * diffYears;
        return diffMonths;
    }

    private final int $$robo$$android_widget_DayPickerView$getPositionFromDay(Calendar day) {
        int diffMonthMax = this.getDiffMonths(this.mController.getMinDate(), this.mController.getMaxDate());
        int diffMonth = this.getDiffMonths(this.mController.getMinDate(), day);
        if (diffMonth < 0) {
            diffMonth = 0;
        } else if (diffMonth > diffMonthMax) {
            diffMonth = diffMonthMax;
        }
        return diffMonth;
    }

    private final boolean $$robo$$android_widget_DayPickerView$goTo(Calendar day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.setTimeInMillis(day.getTimeInMillis());
        }
        this.mTempDay.setTimeInMillis(day.getTimeInMillis());
        int position = this.getPositionFromDay(day);
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null && (top = child.getTop()) < 0) {
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.smoothScrollToPositionFromTop(position, LIST_TOP_OFFSET, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    private final void $$robo$$android_widget_DayPickerView$postSetSelection(int position) {
        this.clearFocus();
        this.post(new Runnable(this, position){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$position;
            /* synthetic */ DayPickerView this$0;

            private void $$robo$$android_widget_DayPickerView_1$__constructor__(DayPickerView dayPickerView, int n) {
            }

            private final void $$robo$$android_widget_DayPickerView_1$run() {
                this.this$0.setSelection(this.val$position);
            }

            private void __constructor__(DayPickerView dayPickerView, int n) {
                this.$$robo$$android_widget_DayPickerView_1$__constructor__(dayPickerView, n);
            }
            {
                this.this$0 = dayPickerView;
                this.val$position = n;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView_1$__constructor__(android.widget.DayPickerView int ), 0, this, dayPickerView, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_DayPickerView_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.onScrollStateChanged(this, 0);
    }

    private final void $$robo$$android_widget_DayPickerView$onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        SimpleMonthView child = (SimpleMonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    private final void $$robo$$android_widget_DayPickerView$setMonthDisplayed(Calendar date) {
        if (this.mCurrentMonthDisplayed != date.get(2)) {
            this.mCurrentMonthDisplayed = date.get(2);
            this.invalidateViews();
        }
    }

    private final void $$robo$$android_widget_DayPickerView$onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    private final void $$robo$$android_widget_DayPickerView$setCalendarTextColor(ColorStateList colors) {
        this.mAdapter.setCalendarTextColor(colors);
    }

    private final int $$robo$$android_widget_DayPickerView$getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    private final void $$robo$$android_widget_DayPickerView$onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    private final Calendar $$robo$$android_widget_DayPickerView$findAccessibilityFocus() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Calendar focus;
            View child = this.getChildAt(i);
            if (!(child instanceof SimpleMonthView) || (focus = ((SimpleMonthView)child).getAccessibilityFocus()) == null) continue;
            return focus;
        }
        return null;
    }

    private final boolean $$robo$$android_widget_DayPickerView$restoreAccessibilityFocus(Calendar day) {
        if (day == null) {
            return false;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof SimpleMonthView) || !((SimpleMonthView)child).restoreAccessibilityFocus(day)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_DayPickerView$layoutChildren() {
        Calendar focusedDay = this.findAccessibilityFocus();
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
        } else {
            this.restoreAccessibilityFocus(focusedDay);
        }
    }

    private final void $$robo$$android_widget_DayPickerView$onConfigurationChanged(Configuration newConfig) {
        this.mYearFormat = new SimpleDateFormat("yyyy", Locale.getDefault());
    }

    private final void $$robo$$android_widget_DayPickerView$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setItemCount(-1);
    }

    private final String $$robo$$android_widget_DayPickerView$getMonthAndYearString(Calendar day) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(day.getDisplayName(2, 2, Locale.getDefault()));
        sbuf.append(" ");
        sbuf.append(this.mYearFormat.format(day.getTime()));
        return sbuf.toString();
    }

    private final void $$robo$$android_widget_DayPickerView$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(4096);
        info.addAction(8192);
    }

    private final boolean $$robo$$android_widget_DayPickerView$performAccessibilityAction(int action, Bundle arguments) {
        View firstVisibleView;
        if (action != 4096 && action != 8192) {
            return super.performAccessibilityAction(action, arguments);
        }
        int firstVisiblePosition = this.getFirstVisiblePosition();
        int month = firstVisiblePosition % 12;
        int year = firstVisiblePosition / 12 + this.mController.getMinYear();
        Calendar day = Calendar.getInstance();
        day.set(year, month, 1);
        if (action == 4096) {
            day.add(2, 1);
            if (day.get(2) == 12) {
                day.set(2, 0);
                day.add(1, 1);
            }
        } else if (action == 8192 && (firstVisibleView = this.getChildAt(0)) != null && firstVisibleView.getTop() >= -1) {
            day.add(2, -1);
            if (day.get(2) == -1) {
                day.set(2, 11);
                day.add(1, -1);
            }
        }
        this.announceForAccessibility(this.getMonthAndYearString(day));
        this.goTo(day, true, false, true);
        this.mPerformingScroll = true;
        return true;
    }

    static void __staticInitializer__() {
        LIST_TOP_OFFSET = -1;
    }

    private void __constructor__(Context context, DatePickerController datePickerController) {
        this.$$robo$$android_widget_DayPickerView$__constructor__(context, datePickerController);
    }

    public DayPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView$__constructor__(android.content.Context android.widget.DatePickerController ), 0, this, context, datePickerController);
    }

    public void setController(DatePickerController datePickerController) {
        InvokeDynamicSupport.bootstrap("setController", $$robo$$android_widget_DayPickerView$setController(android.widget.DatePickerController ), 0, this, datePickerController);
    }

    public void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DayPickerView$init(), 0, this);
    }

    public void onChange() {
        InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_widget_DayPickerView$onChange(), 0, this);
    }

    protected void setUpAdapter() {
        InvokeDynamicSupport.bootstrap("setUpAdapter", $$robo$$android_widget_DayPickerView$setUpAdapter(), 0, this);
    }

    protected void setUpListView() {
        InvokeDynamicSupport.bootstrap("setUpListView", $$robo$$android_widget_DayPickerView$setUpListView(), 0, this);
    }

    private int getDiffMonths(Calendar calendar, Calendar calendar2) {
        return (int)InvokeDynamicSupport.bootstrap("getDiffMonths", $$robo$$android_widget_DayPickerView$getDiffMonths(java.util.Calendar java.util.Calendar ), 0, this, calendar, calendar2);
    }

    private int getPositionFromDay(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrap("getPositionFromDay", $$robo$$android_widget_DayPickerView$getPositionFromDay(java.util.Calendar ), 0, this, calendar);
    }

    public boolean goTo(Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        return (boolean)InvokeDynamicSupport.bootstrap("goTo", $$robo$$android_widget_DayPickerView$goTo(java.util.Calendar boolean boolean boolean ), 0, this, calendar, bl, bl2, bl3);
    }

    public void postSetSelection(int n) {
        InvokeDynamicSupport.bootstrap("postSetSelection", $$robo$$android_widget_DayPickerView$postSetSelection(int ), 0, this, n);
    }

    @Override
    public void onScroll(AbsListView absListView, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_DayPickerView$onScroll(android.widget.AbsListView int int int ), 0, this, absListView, n, n2, n3);
    }

    protected void setMonthDisplayed(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("setMonthDisplayed", $$robo$$android_widget_DayPickerView$setMonthDisplayed(java.util.Calendar ), 0, this, calendar);
    }

    @Override
    public void onScrollStateChanged(AbsListView absListView, int n) {
        InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$android_widget_DayPickerView$onScrollStateChanged(android.widget.AbsListView int ), 0, this, absListView, n);
    }

    void setCalendarTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCalendarTextColor", $$robo$$android_widget_DayPickerView$setCalendarTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public int getMostVisiblePosition() {
        return (int)InvokeDynamicSupport.bootstrap("getMostVisiblePosition", $$robo$$android_widget_DayPickerView$getMostVisiblePosition(), 0, this);
    }

    @Override
    public void onDateChanged() {
        InvokeDynamicSupport.bootstrap("onDateChanged", $$robo$$android_widget_DayPickerView$onDateChanged(), 0, this);
    }

    private Calendar findAccessibilityFocus() {
        return InvokeDynamicSupport.bootstrap("findAccessibilityFocus", $$robo$$android_widget_DayPickerView$findAccessibilityFocus(), 0, this);
    }

    private boolean restoreAccessibilityFocus(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreAccessibilityFocus", $$robo$$android_widget_DayPickerView$restoreAccessibilityFocus(java.util.Calendar ), 0, this, calendar);
    }

    @Override
    protected void layoutChildren() {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_DayPickerView$layoutChildren(), 0, this);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DayPickerView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_DayPickerView$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private String getMonthAndYearString(Calendar calendar) {
        return InvokeDynamicSupport.bootstrap("getMonthAndYearString", $$robo$$android_widget_DayPickerView$getMonthAndYearString(java.util.Calendar ), 0, this, calendar);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_DayPickerView$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_widget_DayPickerView$performAccessibilityAction(int android.os.Bundle ), 0, this, n, bundle);
    }

    static {
        RobolectricInternals.classInitializing(DayPickerView.class);
    }

    public /* synthetic */ DayPickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected class ScrollStateRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mNewState;
        private View mParent;
        /* synthetic */ DayPickerView this$0;

        private void $$robo$$android_widget_DayPickerView_ScrollStateRunnable$__constructor__(DayPickerView dayPickerView, View view) {
            this.mParent = view;
        }

        private final void $$robo$$android_widget_DayPickerView_ScrollStateRunnable$doScrollStateChange(AbsListView view, int scrollState) {
            this.mParent.removeCallbacks(this);
            this.mNewState = scrollState;
            this.mParent.postDelayed(this, 40L);
        }

        private final void $$robo$$android_widget_DayPickerView_ScrollStateRunnable$run() {
            this.this$0.mCurrentScrollState = this.mNewState;
            if (Log.isLoggable("DayPickerView", 3)) {
                Log.d("DayPickerView", "new scroll state: " + this.mNewState + " old state: " + this.this$0.mPreviousScrollState);
            }
            if (this.mNewState == 0 && this.this$0.mPreviousScrollState != 0 && this.this$0.mPreviousScrollState != 1) {
                this.this$0.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = this.this$0.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = this.this$0.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = this.this$0.getFirstVisiblePosition();
                int lastPosition = this.this$0.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != this.this$0.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = this.this$0.getHeight() / 2;
                if (scroll && top < LIST_TOP_OFFSET) {
                    if (bottom > midpoint) {
                        this.this$0.smoothScrollBy(top, 250);
                    } else {
                        this.this$0.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                this.this$0.mPreviousScrollState = this.mNewState;
            }
        }

        private void __constructor__(DayPickerView dayPickerView, View view) {
            this.$$robo$$android_widget_DayPickerView_ScrollStateRunnable$__constructor__(dayPickerView, view);
        }

        ScrollStateRunnable(DayPickerView dayPickerView, View view) {
            this.this$0 = dayPickerView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DayPickerView_ScrollStateRunnable$__constructor__(android.widget.DayPickerView android.view.View ), 0, this, dayPickerView, view);
        }

        public void doScrollStateChange(AbsListView absListView, int n) {
            InvokeDynamicSupport.bootstrap("doScrollStateChange", $$robo$$android_widget_DayPickerView_ScrollStateRunnable$doScrollStateChange(android.widget.AbsListView int ), 0, this, absListView, n);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_DayPickerView_ScrollStateRunnable$run(), 0, this);
        }

        public /* synthetic */ ScrollStateRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollStateRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

