/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.util.FloatMath;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EdgeEffect
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "EdgeEffect";
    private static int RECEDE_TIME = 600;
    private static int PULL_TIME = 167;
    private static int PULL_DECAY_TIME = 2000;
    private static float MAX_ALPHA = 0.5f;
    private static float MAX_GLOW_SCALE = 2.0f;
    private static float PULL_GLOW_BEGIN = 0.0f;
    private static int MIN_VELOCITY = 100;
    private static int MAX_VELOCITY = 10000;
    private static float EPSILON = 0.001f;
    private static double ANGLE = 0.5235987755982988;
    private static float SIN;
    private static float COS;
    private float mGlowAlpha;
    private float mGlowScaleY;
    private float mGlowAlphaStart;
    private float mGlowAlphaFinish;
    private float mGlowScaleYStart;
    private float mGlowScaleYFinish;
    private long mStartTime;
    private float mDuration;
    private Interpolator mInterpolator;
    private static int STATE_IDLE = 0;
    private static int STATE_PULL = 1;
    private static int STATE_ABSORB = 2;
    private static int STATE_RECEDE = 3;
    private static int STATE_PULL_DECAY = 4;
    private static float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static int VELOCITY_GLOW_FACTOR = 6;
    private int mState;
    private float mPullDistance;
    private Rect mBounds;
    private Paint mPaint;
    private float mRadius;
    private float mBaseGlowScale;
    private float mDisplacement;
    private float mTargetDisplacement;

    private void $$robo$$android_widget_EdgeEffect$__constructor__(Context context) {
        this.mState = 0;
        this.mBounds = new Rect();
        this.mPaint = new Paint();
        this.mDisplacement = 0.5f;
        this.mTargetDisplacement = 0.5f;
        this.mPaint.setAntiAlias(true);
        TypedArray a = context.obtainStyledAttributes(R.styleable.EdgeEffect);
        int themeColor = a.getColor(0, -10066330);
        a.recycle();
        this.mPaint.setColor(themeColor & 0xFFFFFF | 0x33000000);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.mInterpolator = new DecelerateInterpolator();
    }

    private final void $$robo$$android_widget_EdgeEffect$setSize(int width, int height) {
        float r = (float)width * 0.75f / SIN;
        float y = COS * r;
        float h = r - y;
        float or = (float)height * 0.75f / SIN;
        float oy = COS * or;
        float oh = or - oy;
        this.mRadius = r;
        this.mBaseGlowScale = h > 0.0f ? Math.min(oh / h, 1.0f) : 1.0f;
        this.mBounds.set(this.mBounds.left, this.mBounds.top, width, (int)Math.min((float)height, h));
    }

    private final boolean $$robo$$android_widget_EdgeEffect$isFinished() {
        return this.mState == 0;
    }

    private final void $$robo$$android_widget_EdgeEffect$finish() {
        this.mState = 0;
    }

    private final void $$robo$$android_widget_EdgeEffect$onPull(float deltaDistance) {
        this.onPull(deltaDistance, 0.5f);
    }

    private final void $$robo$$android_widget_EdgeEffect$onPull(float deltaDistance, float displacement) {
        long now = AnimationUtils.currentAnimationTimeMillis();
        this.mTargetDisplacement = displacement;
        if (this.mState == 4 && (float)(now - this.mStartTime) < this.mDuration) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = Math.max(0.0f, this.mGlowScaleY);
        }
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 167.0f;
        this.mPullDistance += deltaDistance;
        float absdd = Math.abs(deltaDistance);
        this.mGlowAlpha = this.mGlowAlphaStart = Math.min(0.5f, this.mGlowAlpha + absdd * 0.8f);
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleYStart = 0.0f;
            this.mGlowScaleY = 0.0f;
        } else {
            float scale;
            this.mGlowScaleY = this.mGlowScaleYStart = (scale = Math.max(0.0f, 1.0f - 1.0f / FloatMath.sqrt(Math.abs(this.mPullDistance) * (float)this.mBounds.height()) - 0.3f) / 0.7f);
        }
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    private final void $$robo$$android_widget_EdgeEffect$onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 600.0f;
    }

    private final void $$robo$$android_widget_EdgeEffect$onAbsorb(int velocity) {
        this.mState = 2;
        velocity = Math.min(Math.max(100, Math.abs(velocity)), 10000);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.15f + (float)velocity * 0.02f;
        this.mGlowAlphaStart = 0.3f;
        this.mGlowScaleYStart = Math.max(this.mGlowScaleY, 0.0f);
        this.mGlowScaleYFinish = Math.min(0.025f + (float)(velocity * (velocity / 100)) * 1.5E-4f / 2.0f, 1.0f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min((float)(velocity * 6) * 1.0E-5f, 0.5f));
        this.mTargetDisplacement = 0.5f;
    }

    private final void $$robo$$android_widget_EdgeEffect$setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    private final int $$robo$$android_widget_EdgeEffect$getColor() {
        return this.mPaint.getColor();
    }

    private final boolean $$robo$$android_widget_EdgeEffect$draw(Canvas canvas) {
        this.update();
        int count = canvas.save();
        float centerX = this.mBounds.centerX();
        float centerY = (float)this.mBounds.height() - this.mRadius;
        canvas.scale(1.0f, Math.min(this.mGlowScaleY, 1.0f) * this.mBaseGlowScale, centerX, 0.0f);
        float displacement = Math.max(0.0f, Math.min(this.mDisplacement, 1.0f)) - 0.5f;
        float translateX = (float)this.mBounds.width() * displacement / 2.0f;
        canvas.clipRect(this.mBounds);
        canvas.translate(translateX, 0.0f);
        this.mPaint.setAlpha((int)(255.0f * this.mGlowAlpha));
        canvas.drawCircle(centerX, centerY, this.mRadius, this.mPaint);
        canvas.restoreToCount(count);
        boolean oneLastFrame = false;
        if (this.mState == 3 && this.mGlowScaleY == 0.0f) {
            this.mState = 0;
            oneLastFrame = true;
        }
        return this.mState != 0 || oneLastFrame;
    }

    private final int $$robo$$android_widget_EdgeEffect$getMaxHeight() {
        return (int)((float)this.mBounds.height() * 2.0f + 0.5f);
    }

    private final void $$robo$$android_widget_EdgeEffect$update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float interp = this.mInterpolator.getInterpolation(t);
        this.mGlowAlpha = this.mGlowAlphaStart + (this.mGlowAlphaFinish - this.mGlowAlphaStart) * interp;
        this.mGlowScaleY = this.mGlowScaleYStart + (this.mGlowScaleYFinish - this.mGlowScaleYStart) * interp;
        this.mDisplacement = (this.mDisplacement + this.mTargetDisplacement) / 2.0f;
        if (t >= 0.999f) {
            switch (this.mState) {
                case 2: {
                    this.mState = 3;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 600.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 1: {
                    this.mState = 4;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 2000.0f;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 4: {
                    this.mState = 3;
                    break;
                }
                case 3: {
                    this.mState = 0;
                }
            }
        }
    }

    static void __staticInitializer__() {
        SIN = (float)Math.sin(0.5235987755982988);
        COS = (float)Math.cos(0.5235987755982988);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_EdgeEffect$__constructor__(context);
    }

    public EdgeEffect(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_EdgeEffect$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_widget_EdgeEffect$setSize(int int ), 0, this, n, n2);
    }

    public boolean isFinished() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$android_widget_EdgeEffect$isFinished(), 0, this);
    }

    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_widget_EdgeEffect$finish(), 0, this);
    }

    public void onPull(float f) {
        InvokeDynamicSupport.bootstrap("onPull", $$robo$$android_widget_EdgeEffect$onPull(float ), 0, this, f);
    }

    public void onPull(float f, float f2) {
        InvokeDynamicSupport.bootstrap("onPull", $$robo$$android_widget_EdgeEffect$onPull(float float ), 0, this, f, f2);
    }

    public void onRelease() {
        InvokeDynamicSupport.bootstrap("onRelease", $$robo$$android_widget_EdgeEffect$onRelease(), 0, this);
    }

    public void onAbsorb(int n) {
        InvokeDynamicSupport.bootstrap("onAbsorb", $$robo$$android_widget_EdgeEffect$onAbsorb(int ), 0, this, n);
    }

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_widget_EdgeEffect$setColor(int ), 0, this, n);
    }

    public int getColor() {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_widget_EdgeEffect$getColor(), 0, this);
    }

    public boolean draw(Canvas canvas) {
        return (boolean)InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_EdgeEffect$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public int getMaxHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxHeight", $$robo$$android_widget_EdgeEffect$getMaxHeight(), 0, this);
    }

    private void update() {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_EdgeEffect$update(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(EdgeEffect.class);
    }

    public /* synthetic */ EdgeEffect() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EdgeEffect)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

