/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.app.PendingIntent;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.UndoOperation;
import android.content.UndoOwner;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.WordIterator;
import android.text.style.EasyEditSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpellChecker;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.EditableInputConnection;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Editor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Editor";
    static boolean DEBUG_UNDO = false;
    static int BLINK = 500;
    private static float[] TEMP_POSITION;
    private static int DRAG_SHADOW_MAX_TEXT_LENGTH;
    UndoManager mUndoManager;
    UndoOwner mUndoOwner;
    InputFilter mUndoInputFilter;
    InsertionPointCursorController mInsertionPointCursorController;
    SelectionModifierCursorController mSelectionModifierCursorController;
    ActionMode mSelectionActionMode;
    boolean mInsertionControllerEnabled;
    boolean mSelectionControllerEnabled;
    CorrectionHighlighter mCorrectionHighlighter;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    TextDisplayList[] mTextDisplayLists;
    boolean mFrozenWithFocus;
    boolean mSelectionMoved;
    boolean mTouchFocusSelected;
    KeyListener mKeyListener;
    int mInputType;
    boolean mDiscardNextActionUp;
    boolean mIgnoreActionUpEvent;
    long mShowCursor;
    Blink mBlink;
    boolean mCursorVisible;
    boolean mSelectAllOnFocus;
    boolean mTextIsSelectable;
    CharSequence mError;
    boolean mErrorWasChanged;
    ErrorPopup mErrorPopup;
    boolean mShowErrorAfterAttach;
    boolean mInBatchEditControllers;
    boolean mShowSoftInputOnFocus;
    boolean mPreserveDetachedSelection;
    boolean mTemporaryDetach;
    SuggestionsPopupWindow mSuggestionsPopupWindow;
    SuggestionRangeSpan mSuggestionRangeSpan;
    Runnable mShowSuggestionRunnable;
    Drawable[] mCursorDrawable;
    int mCursorCount;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private PositionListener mPositionListener;
    float mLastDownPositionX;
    float mLastDownPositionY;
    ActionMode.Callback mCustomSelectionActionModeCallback;
    boolean mCreatedWithASelection;
    private SpanController mSpanController;
    WordIterator mWordIterator;
    SpellChecker mSpellChecker;
    private Rect mTempRect;
    private TextView mTextView;
    CursorAnchorInfoNotifier mCursorAnchorInfoNotifier;
    static int EXTRACT_NOTHING = -2;
    static int EXTRACT_UNKNOWN = -1;

    private void $$robo$$android_widget_Editor$__constructor__(TextView textView) {
        this.mInputType = 0;
        this.mCursorVisible = true;
        this.mShowSoftInputOnFocus = true;
        this.mCursorDrawable = new Drawable[2];
        this.mCursorAnchorInfoNotifier = new CursorAnchorInfoNotifier(this);
        this.mTextView = textView;
    }

    private final void $$robo$$android_widget_Editor$onAttachedToWindow() {
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        this.mTemporaryDetach = false;
        ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
        if (this.mInsertionPointCursorController != null) {
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        this.updateSpellCheckSpans(0, this.mTextView.getText().length(), true);
        if (this.mTextView.hasTransientState() && this.mTextView.getSelectionStart() != this.mTextView.getSelectionEnd()) {
            this.mTextView.setHasTransientState(false);
            this.startSelectionActionMode();
        }
        this.getPositionListener().addSubscriber(this.mCursorAnchorInfoNotifier, true);
    }

    private final void $$robo$$android_widget_Editor$onDetachedFromWindow() {
        this.getPositionListener().removeSubscriber(this.mCursorAnchorInfoNotifier);
        if (this.mError != null) {
            this.hideError();
        }
        if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
        }
        this.destroyDisplayListsData();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
        this.mPreserveDetachedSelection = true;
        this.hideControllers();
        this.mPreserveDetachedSelection = false;
        this.mTemporaryDetach = false;
    }

    private final void $$robo$$android_widget_Editor$destroyDisplayListsData() {
        if (this.mTextDisplayLists != null) {
            for (int i = 0; i < this.mTextDisplayLists.length; ++i) {
                RenderNode displayList;
                RenderNode renderNode = displayList = this.mTextDisplayLists[i] != null ? this.mTextDisplayLists[i].displayList : null;
                if (displayList == null || !displayList.isValid()) continue;
                displayList.destroyDisplayListData();
            }
        }
    }

    private final void $$robo$$android_widget_Editor$showError() {
        if (this.mTextView.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mErrorPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mTextView.getContext());
            TextView err = (TextView)inflater.inflate(17367261, null);
            float scale = this.mTextView.getResources().getDisplayMetrics().density;
            this.mErrorPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mErrorPopup.setFocusable(false);
            this.mErrorPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mErrorPopup.getContentView();
        this.chooseSize(this.mErrorPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mErrorPopup.showAsDropDown(this.mTextView, this.getErrorX(), this.getErrorY());
        this.mErrorPopup.fixDirection(this.mErrorPopup.isAboveAnchor());
    }

    private final void $$robo$$android_widget_Editor$setError(CharSequence error, Drawable icon) {
        this.mError = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        if (this.mError == null) {
            this.setErrorIcon(null);
            if (this.mErrorPopup != null) {
                if (this.mErrorPopup.isShowing()) {
                    this.mErrorPopup.dismiss();
                }
                this.mErrorPopup = null;
            }
            this.mShowErrorAfterAttach = false;
        } else {
            this.setErrorIcon(icon);
            if (this.mTextView.isFocused()) {
                this.showError();
            }
        }
    }

    private final void $$robo$$android_widget_Editor$setErrorIcon(Drawable icon) {
        TextView.Drawables dr = this.mTextView.mDrawables;
        if (dr == null) {
            this.mTextView.mDrawables = dr = new TextView.Drawables(this.mTextView.getContext());
        }
        dr.setErrorDrawable(icon, this.mTextView);
        this.mTextView.resetResolvedDrawables();
        this.mTextView.invalidate();
        this.mTextView.requestLayout();
    }

    private final void $$robo$$android_widget_Editor$hideError() {
        if (this.mErrorPopup != null && this.mErrorPopup.isShowing()) {
            this.mErrorPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private final int $$robo$$android_widget_Editor$getErrorX() {
        int errorX;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                int offset = -(dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getWidth() - this.mErrorPopup.getWidth() - this.mTextView.getPaddingRight() + offset;
                break;
            }
            case 1: {
                int offset = (dr != null ? dr.mDrawableSizeLeft : 0) / 2 - (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getPaddingLeft() + offset;
            }
        }
        return errorX;
    }

    private final int $$robo$$android_widget_Editor$getErrorY() {
        int height;
        int compoundPaddingTop = this.mTextView.getCompoundPaddingTop();
        int vspace = this.mTextView.getBottom() - this.mTextView.getTop() - this.mTextView.getCompoundPaddingBottom() - compoundPaddingTop;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                height = dr != null ? dr.mDrawableHeightRight : 0;
                break;
            }
            case 1: {
                height = dr != null ? dr.mDrawableHeightLeft : 0;
            }
        }
        int icontop = compoundPaddingTop + (vspace - height) / 2;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        return icontop + height - this.mTextView.getHeight() - (int)(2.0f * scale + 0.5f);
    }

    private final void $$robo$$android_widget_Editor$createInputContentTypeIfNeeded() {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
    }

    private final void $$robo$$android_widget_Editor$createInputMethodStateIfNeeded() {
        if (this.mInputMethodState == null) {
            this.mInputMethodState = new InputMethodState();
        }
    }

    private final boolean $$robo$$android_widget_Editor$isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    private final void $$robo$$android_widget_Editor$prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.mTextView.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        boolean enabled = windowSupportsHandles && this.mTextView.getLayout() != null;
        this.mInsertionControllerEnabled = enabled && this.isCursorVisible();
        boolean bl = this.mSelectionControllerEnabled = enabled && this.mTextView.textCanBeSelected();
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopSelectionActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    private final void $$robo$$android_widget_Editor$hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    private final void $$robo$$android_widget_Editor$hideControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    private final void $$robo$$android_widget_Editor$hideSpanControllers() {
        if (this.mSpanController != null) {
            this.mSpanController.hide();
        }
    }

    private final void $$robo$$android_widget_Editor$hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && !this.mSuggestionsPopupWindow.isShowingUp()) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
        this.stopSelectionActionMode();
    }

    private final void $$robo$$android_widget_Editor$updateSpellCheckSpans(int start, int end, boolean createSpellChecker) {
        this.mTextView.removeAdjacentSuggestionSpans(start);
        this.mTextView.removeAdjacentSuggestionSpans(end);
        if (this.mTextView.isTextEditable() && this.mTextView.isSuggestionsEnabled() && !(this.mTextView instanceof ExtractEditText)) {
            if (this.mSpellChecker == null && createSpellChecker) {
                this.mSpellChecker = new SpellChecker(this.mTextView);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(start, end);
            }
        }
    }

    private final void $$robo$$android_widget_Editor$onScreenStateChanged(int screenState) {
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    private final void $$robo$$android_widget_Editor$suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private final void $$robo$$android_widget_Editor$resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    private final void $$robo$$android_widget_Editor$adjustInputType(boolean password, boolean passwordInputType, boolean webPasswordInputType, boolean numberPasswordInputType) {
        if ((this.mInputType & 0xF) == 1) {
            if (password || passwordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
            }
            if (webPasswordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0xE0;
            }
        } else if ((this.mInputType & 0xF) == 2 && numberPasswordInputType) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x10;
        }
    }

    private final void $$robo$$android_widget_Editor$chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int defaultWidthInPixels = this.mTextView.getResources().getDimensionPixelSize(17104970);
        StaticLayout l = new StaticLayout(text, tv.getPaint(), defaultWidthInPixels, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float max = 0.0f;
        for (int i = 0; i < ((Layout)l).getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    private final void $$robo$$android_widget_Editor$setFrame() {
        if (this.mErrorPopup != null) {
            TextView tv = (TextView)this.mErrorPopup.getContentView();
            this.chooseSize(this.mErrorPopup, this.mError, tv);
            this.mErrorPopup.update(this.mTextView, this.getErrorX(), this.getErrorY(), this.mErrorPopup.getWidth(), this.mErrorPopup.getHeight());
        }
    }

    private final boolean $$robo$$android_widget_Editor$canSelectText() {
        return this.hasSelectionController() && this.mTextView.getText().length() != 0;
    }

    private final boolean $$robo$$android_widget_Editor$hasPasswordTransformationMethod() {
        return this.mTextView.getTransformationMethod() instanceof PasswordTransformationMethod;
    }

    private final boolean $$robo$$android_widget_Editor$selectCurrentWord() {
        int selectionEnd;
        int selectionStart;
        if (!this.canSelectText()) {
            return false;
        }
        if (this.hasPasswordTransformationMethod()) {
            return this.mTextView.selectAllText();
        }
        int inputType = this.mTextView.getInputType();
        int klass = inputType & 0xF;
        int variation = inputType & 0xFF0;
        if (klass == 2 || klass == 3 || klass == 4 || variation == 16 || variation == 32 || variation == 208 || variation == 176) {
            return this.mTextView.selectAllText();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minOffset = TextUtils.unpackRangeStartFromLong(lastTouchOffsets);
        int maxOffset = TextUtils.unpackRangeEndFromLong(lastTouchOffsets);
        if (minOffset < 0 || minOffset >= this.mTextView.getText().length()) {
            return false;
        }
        if (maxOffset < 0 || maxOffset >= this.mTextView.getText().length()) {
            return false;
        }
        URLSpan[] urlSpans = ((Spanned)this.mTextView.getText()).getSpans(minOffset, maxOffset, URLSpan.class);
        if (urlSpans.length >= 1) {
            URLSpan urlSpan = urlSpans[0];
            selectionStart = ((Spanned)this.mTextView.getText()).getSpanStart(urlSpan);
            selectionEnd = ((Spanned)this.mTextView.getText()).getSpanEnd(urlSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mTextView.getText(), minOffset, maxOffset);
            selectionStart = wordIterator.getBeginning(minOffset);
            selectionEnd = wordIterator.getEnd(maxOffset);
            if (selectionStart == -1 || selectionEnd == -1 || selectionStart == selectionEnd) {
                long range = this.getCharRange(minOffset);
                selectionStart = TextUtils.unpackRangeStartFromLong(range);
                selectionEnd = TextUtils.unpackRangeEndFromLong(range);
            }
        }
        Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        return selectionEnd > selectionStart;
    }

    private final void $$robo$$android_widget_Editor$onLocaleChanged() {
        this.mWordIterator = null;
    }

    private final WordIterator $$robo$$android_widget_Editor$getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    private final long $$robo$$android_widget_Editor$getCharRange(int offset) {
        char nextChar;
        char currentChar;
        int textLength = this.mTextView.getText().length();
        if (offset + 1 < textLength && Character.isSurrogatePair(currentChar = this.mTextView.getText().charAt(offset), nextChar = this.mTextView.getText().charAt(offset + 1))) {
            return TextUtils.packRangeInLong(offset, offset + 2);
        }
        if (offset < textLength) {
            return TextUtils.packRangeInLong(offset, offset + 1);
        }
        if (offset - 2 >= 0) {
            char previousChar = this.mTextView.getText().charAt(offset - 1);
            char previousPreviousChar = this.mTextView.getText().charAt(offset - 2);
            if (Character.isSurrogatePair(previousPreviousChar, previousChar)) {
                return TextUtils.packRangeInLong(offset - 2, offset);
            }
        }
        if (offset - 1 >= 0) {
            return TextUtils.packRangeInLong(offset - 1, offset);
        }
        return TextUtils.packRangeInLong(offset, offset);
    }

    private final boolean $$robo$$android_widget_Editor$touchPositionIsInSelection() {
        int selectionEnd;
        int selectionStart = this.mTextView.getSelectionStart();
        if (selectionStart == (selectionEnd = this.mTextView.getSelectionEnd())) {
            return false;
        }
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
            Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        }
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return minOffset >= selectionStart && maxOffset < selectionEnd;
    }

    private final PositionListener $$robo$$android_widget_Editor$getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener(this);
        }
        return this.mPositionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_widget_Editor$isPositionVisible(float positionX, float positionY) {
        float[] fArray = TEMP_POSITION;
        synchronized (TEMP_POSITION) {
            float[] position = TEMP_POSITION;
            position[0] = positionX;
            position[1] = positionY;
            View view = this.mTextView;
            while (view != null) {
                if (view != this.mTextView) {
                    position[0] = position[0] - (float)view.getScrollX();
                    position[1] = position[1] - (float)view.getScrollY();
                }
                if (position[0] < 0.0f || position[1] < 0.0f || position[0] > (float)view.getWidth() || position[1] > (float)view.getHeight()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(position);
                }
                position[0] = position[0] + (float)view.getLeft();
                position[1] = position[1] + (float)view.getTop();
                ViewParent parent = view.getParent();
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    continue;
                }
                view = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private final boolean $$robo$$android_widget_Editor$isOffsetVisible(int offset) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = layout2.getLineForOffset(offset);
        int lineBottom = layout2.getLineBottom(line);
        int primaryHorizontal = (int)layout2.getPrimaryHorizontal(offset);
        return this.isPositionVisible(primaryHorizontal + this.mTextView.viewportToContentHorizontalOffset(), lineBottom + this.mTextView.viewportToContentVerticalOffset());
    }

    private final boolean $$robo$$android_widget_Editor$isPositionOnText(float x, float y) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = this.mTextView.getLineAtCoordinate(y);
        if ((x = this.mTextView.convertToLocalHorizontalCoordinate(x)) < layout2.getLineLeft(line)) {
            return false;
        }
        return !(x > layout2.getLineRight(line));
    }

    private final boolean $$robo$$android_widget_Editor$performLongClick(boolean handled) {
        if (!handled && !this.isPositionOnText(this.mLastDownPositionX, this.mLastDownPositionY) && this.mInsertionControllerEnabled) {
            int offset = this.mTextView.getOffsetForPosition(this.mLastDownPositionX, this.mLastDownPositionY);
            this.stopSelectionActionMode();
            Selection.setSelection((Spannable)this.mTextView.getText(), offset);
            this.getInsertionController().showWithActionPopup();
            handled = true;
        }
        if (!handled && this.mSelectionActionMode != null) {
            if (this.touchPositionIsInSelection()) {
                int start = this.mTextView.getSelectionStart();
                int end = this.mTextView.getSelectionEnd();
                CharSequence selectedText = this.mTextView.getTransformedText(start, end);
                ClipData data = ClipData.newPlainText(null, selectedText);
                DragLocalState localState = new DragLocalState(this.mTextView, start, end);
                this.mTextView.startDrag(data, this.getTextThumbnailBuilder(selectedText), localState, 0);
                this.stopSelectionActionMode();
            } else {
                this.getSelectionController().hide();
                this.selectCurrentWord();
                this.getSelectionController().show();
            }
            handled = true;
        }
        if (!handled) {
            handled = this.startSelectionActionMode();
        }
        return handled;
    }

    private final long $$robo$$android_widget_Editor$getLastTouchOffsets() {
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return TextUtils.packRangeInLong(minOffset, maxOffset);
    }

    private final void $$robo$$android_widget_Editor$onFocusChanged(boolean focused, int direction) {
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.mTextView.getSelectionStart();
            int selEnd = this.mTextView.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mTextView.getText().length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.mTextView.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                MovementMethod mMovement;
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), lastTapPosition);
                }
                if ((mMovement = this.mTextView.getMovementMethod()) != null) {
                    mMovement.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), direction);
                }
                if ((this.mTextView instanceof ExtractEditText || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    this.mTextView.selectAllText();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mError != null) {
                this.showError();
            }
            this.makeBlink();
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.mTextView.onEndBatchEdit();
            if (this.mTextView instanceof ExtractEditText) {
                int selStart = this.mTextView.getSelectionStart();
                int selEnd = this.mTextView.getSelectionEnd();
                this.hideControllers();
                Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
            } else {
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = true;
                }
                this.hideControllers();
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = false;
                }
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
            }
        }
    }

    private final void $$robo$$android_widget_Editor$downgradeEasyCorrectionSpans() {
        CharSequence text = this.mTextView.getText();
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpans.length; ++i) {
                int flags = suggestionSpans[i].getFlags();
                if ((flags & 1) == 0 || (flags & 2) != 0) continue;
                suggestionSpans[i].setFlags(flags &= 0xFFFFFFFE);
            }
        }
    }

    private final void $$robo$$android_widget_Editor$sendOnTextChanged(int start, int after) {
        this.updateSpellCheckSpans(start, start + after, false);
        this.hideCursorControllers();
    }

    private final int $$robo$$android_widget_Editor$getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mTextView.getText().length()) {
                lastTapPosition = this.mTextView.getText().length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    private final void $$robo$$android_widget_Editor$onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideControllers();
            if (this.mSuggestionsPopupWindow != null) {
                this.mSuggestionsPopupWindow.onParentLostFocus();
            }
            this.ensureEndedBatchEdit();
        }
    }

    private final void $$robo$$android_widget_Editor$onTouchEvent(MotionEvent event) {
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
            this.mShowSuggestionRunnable = null;
        }
        if (event.getActionMasked() == 0) {
            this.mLastDownPositionX = event.getX();
            this.mLastDownPositionY = event.getY();
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    private final void $$robo$$android_widget_Editor$beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mTextView.getText().length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.mTextView.onBeginBatchEdit();
        }
    }

    private final void $$robo$$android_widget_Editor$endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    private final void $$robo$$android_widget_Editor$ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    private final void $$robo$$android_widget_Editor$finishBatchEdit(InputMethodState ims) {
        this.mTextView.onEndBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.mTextView.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.mTextView.invalidateCursor();
        }
        this.sendUpdateSelection();
    }

    private final boolean $$robo$$android_widget_Editor$extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    private final boolean $$robo$$android_widget_Editor$extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        CharSequence content = this.mTextView.getText();
        if (content != null) {
            if (partialStartOffset != -2) {
                int N = content.length();
                if (partialStartOffset < 0) {
                    outText.partialEndOffset = -1;
                    outText.partialStartOffset = -1;
                    partialStartOffset = 0;
                    partialEndOffset = N;
                } else {
                    partialEndOffset += delta;
                    if (content instanceof Spanned) {
                        Spanned spanned = (Spanned)content;
                        ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                        int i = spans.length;
                        while (i > 0) {
                            int j;
                            if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                                partialStartOffset = j;
                            }
                            if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                            partialEndOffset = j;
                        }
                    }
                    outText.partialStartOffset = partialStartOffset;
                    outText.partialEndOffset = partialEndOffset - delta;
                    if (partialStartOffset > N) {
                        partialStartOffset = N;
                    } else if (partialStartOffset < 0) {
                        partialStartOffset = 0;
                    }
                    if (partialEndOffset > N) {
                        partialEndOffset = N;
                    } else if (partialEndOffset < 0) {
                        partialEndOffset = 0;
                    }
                }
                outText.text = (request.flags & 1) != 0 ? content.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content, partialStartOffset, partialEndOffset);
            } else {
                outText.partialStartOffset = 0;
                outText.partialEndOffset = 0;
                outText.text = "";
            }
            outText.flags = 0;
            if (MetaKeyKeyListener.getMetaState(content, 2048) != 0) {
                outText.flags |= 2;
            }
            if (this.mTextView.isSingleLine()) {
                outText.flags |= 1;
            }
            outText.startOffset = 0;
            outText.selectionStart = this.mTextView.getSelectionStart();
            outText.selectionEnd = this.mTextView.getSelectionEnd();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_Editor$reportExtractedText() {
        boolean contentChanged;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ((contentChanged = ims.mContentChanged) || ims.mSelectionModeChanged)) {
            InputMethodManager imm;
            ims.mContentChanged = false;
            ims.mSelectionModeChanged = false;
            ExtractedTextRequest req = ims.mExtractedTextRequest;
            if (req != null && (imm = InputMethodManager.peekInstance()) != null) {
                if (ims.mChangedStart < 0 && !contentChanged) {
                    ims.mChangedStart = -2;
                }
                if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mExtractedText)) {
                    imm.updateExtractedText(this.mTextView, req.token, ims.mExtractedText);
                    ims.mChangedStart = -1;
                    ims.mChangedEnd = -1;
                    ims.mChangedDelta = 0;
                    ims.mContentChanged = false;
                    return true;
                }
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_Editor$sendUpdateSelection() {
        InputMethodManager imm;
        if (null != this.mInputMethodState && this.mInputMethodState.mBatchEditNesting <= 0 && null != (imm = InputMethodManager.peekInstance())) {
            int selectionStart = this.mTextView.getSelectionStart();
            int selectionEnd = this.mTextView.getSelectionEnd();
            int candStart = -1;
            int candEnd = -1;
            if (this.mTextView.getText() instanceof Spannable) {
                Spannable sp = (Spannable)this.mTextView.getText();
                candStart = EditableInputConnection.getComposingSpanStart(sp);
                candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            }
            imm.updateSelection(this.mTextView, selectionStart, selectionEnd, candStart, candEnd);
        }
    }

    private final void $$robo$$android_widget_Editor$onDraw(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        InputMethodManager imm;
        int selectionStart = this.mTextView.getSelectionStart();
        int selectionEnd = this.mTextView.getSelectionEnd();
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting == 0 && (imm = InputMethodManager.peekInstance()) != null && imm.isActive(this.mTextView)) {
            boolean reported = false;
            if (ims.mContentChanged || ims.mSelectionModeChanged) {
                reported = this.reportExtractedText();
            }
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, cursorOffsetVertical);
        }
        if (highlight != null && selectionStart == selectionEnd && this.mCursorCount > 0) {
            this.drawCursor(canvas, cursorOffsetVertical);
            highlight = null;
        }
        if (this.mTextView.canHaveDisplayList() && canvas.isHardwareAccelerated()) {
            this.drawHardwareAccelerated(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, highlightPaint, cursorOffsetVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_Editor$drawHardwareAccelerated(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = layout2.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        layout2.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        if (layout2 instanceof DynamicLayout) {
            if (this.mTextDisplayLists == null) {
                this.mTextDisplayLists = ArrayUtils.emptyArray(TextDisplayList.class);
            }
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            int indexFirstChangedBlock = dynamicLayout.getIndexFirstChangedBlock();
            int endOfPreviousBlock = -1;
            int searchStartIndex = 0;
            for (int i = 0; i < numberOfBlocks; ++i) {
                boolean blockIsInvalid;
                int blockEndLine = blockEndLines[i];
                int blockIndex = blockIndices[i];
                boolean bl = blockIsInvalid = blockIndex == -1;
                if (blockIsInvalid) {
                    blockIndices[i] = blockIndex = this.getAvailableDisplayListIndex(blockIndices, numberOfBlocks, searchStartIndex);
                    searchStartIndex = blockIndex + 1;
                }
                if (this.mTextDisplayLists[blockIndex] == null) {
                    this.mTextDisplayLists[blockIndex] = new TextDisplayList("Text " + blockIndex);
                }
                boolean blockDisplayListIsInvalid = this.mTextDisplayLists[blockIndex].needsRecord();
                RenderNode blockDisplayList = this.mTextDisplayLists[blockIndex].displayList;
                if (i >= indexFirstChangedBlock || blockDisplayListIsInvalid) {
                    int blockBeginLine = endOfPreviousBlock + 1;
                    int top = layout2.getLineTop(blockBeginLine);
                    int bottom = layout2.getLineBottom(blockEndLine);
                    int left = 0;
                    int right = this.mTextView.getWidth();
                    if (this.mTextView.getHorizontallyScrolling()) {
                        float min = Float.MAX_VALUE;
                        float max = Float.MIN_VALUE;
                        for (int line = blockBeginLine; line <= blockEndLine; ++line) {
                            min = Math.min(min, layout2.getLineLeft(line));
                            max = Math.max(max, layout2.getLineRight(line));
                        }
                        left = (int)min;
                        right = (int)(max + 0.5f);
                    }
                    if (blockDisplayListIsInvalid) {
                        HardwareCanvas hardwareCanvas = blockDisplayList.start(right - left, bottom - top);
                        try {
                            hardwareCanvas.translate(-left, -top);
                            layout2.drawText(hardwareCanvas, blockBeginLine, blockEndLine);
                        }
                        finally {
                            blockDisplayList.end(hardwareCanvas);
                            blockDisplayList.setClipToBounds(false);
                        }
                    }
                    blockDisplayList.setLeftTopRightBottom(left, top, right, bottom);
                }
                ((HardwareCanvas)canvas).drawRenderNode(blockDisplayList, null, 0);
                endOfPreviousBlock = blockEndLine;
            }
            dynamicLayout.setIndexFirstChangedBlock(numberOfBlocks);
        } else {
            layout2.drawText(canvas, firstLine, lastLine);
        }
    }

    private final int $$robo$$android_widget_Editor$getAvailableDisplayListIndex(int[] blockIndices, int numberOfBlocks, int searchStartIndex) {
        int length = this.mTextDisplayLists.length;
        for (int i = searchStartIndex; i < length; ++i) {
            boolean blockIndexFound = false;
            for (int j = 0; j < numberOfBlocks; ++j) {
                if (blockIndices[j] != i) continue;
                blockIndexFound = true;
                break;
            }
            if (blockIndexFound) continue;
            return i;
        }
        this.mTextDisplayLists = GrowingArrayUtils.append(this.mTextDisplayLists, length, null);
        return length;
    }

    private final void $$robo$$android_widget_Editor$drawCursor(Canvas canvas, int cursorOffsetVertical) {
        boolean translate;
        boolean bl = translate = cursorOffsetVertical != 0;
        if (translate) {
            canvas.translate(0.0f, cursorOffsetVertical);
        }
        for (int i = 0; i < this.mCursorCount; ++i) {
            this.mCursorDrawable[i].draw(canvas);
        }
        if (translate) {
            canvas.translate(0.0f, -cursorOffsetVertical);
        }
    }

    private final void $$robo$$android_widget_Editor$invalidateTextDisplayList(Layout layout2, int start, int end) {
        if (this.mTextDisplayLists != null && layout2 instanceof DynamicLayout) {
            int i;
            int firstLine = layout2.getLineForOffset(start);
            int lastLine = layout2.getLineForOffset(end);
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            for (i = 0; i < numberOfBlocks && blockEndLines[i] < firstLine; ++i) {
            }
            while (i < numberOfBlocks) {
                int blockIndex = blockIndices[i];
                if (blockIndex != -1) {
                    this.mTextDisplayLists[blockIndex].isDirty = true;
                }
                if (blockEndLines[i] >= lastLine) break;
                ++i;
            }
        }
    }

    private final void $$robo$$android_widget_Editor$invalidateTextDisplayList() {
        if (this.mTextDisplayLists != null) {
            for (int i = 0; i < this.mTextDisplayLists.length; ++i) {
                if (this.mTextDisplayLists[i] == null) continue;
                this.mTextDisplayLists[i].isDirty = true;
            }
        }
    }

    private final void $$robo$$android_widget_Editor$updateCursorsPositions() {
        if (this.mTextView.mCursorDrawableRes == 0) {
            this.mCursorCount = 0;
            return;
        }
        Layout layout2 = this.mTextView.getLayout();
        Layout hintLayout = this.mTextView.getHintLayout();
        int offset = this.mTextView.getSelectionStart();
        int line = layout2.getLineForOffset(offset);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        this.mCursorCount = layout2.isLevelBoundary(offset) ? 2 : 1;
        int middle = bottom;
        if (this.mCursorCount == 2) {
            middle = top + bottom >> 1;
        }
        boolean clamped = layout2.shouldClampCursor(line);
        this.updateCursorPosition(0, top, middle, this.getPrimaryHorizontal(layout2, hintLayout, offset, clamped));
        if (this.mCursorCount == 2) {
            this.updateCursorPosition(1, middle, bottom, layout2.getSecondaryHorizontal(offset, clamped));
        }
    }

    private final float $$robo$$android_widget_Editor$getPrimaryHorizontal(Layout layout2, Layout hintLayout, int offset, boolean clamped) {
        if (TextUtils.isEmpty(layout2.getText()) && hintLayout != null && !TextUtils.isEmpty(hintLayout.getText())) {
            return hintLayout.getPrimaryHorizontal(offset, clamped);
        }
        return layout2.getPrimaryHorizontal(offset, clamped);
    }

    private final boolean $$robo$$android_widget_Editor$startSelectionActionMode() {
        InputMethodManager imm;
        boolean selectionStarted;
        if (this.mSelectionActionMode != null) {
            return false;
        }
        if (!this.canSelectText() || !this.mTextView.requestFocus()) {
            Log.w("TextView", "TextView does not support text selection. Action mode cancelled.");
            return false;
        }
        if (!this.mTextView.hasSelection() && !this.selectCurrentWord()) {
            return false;
        }
        boolean willExtract = this.extractedTextModeWillBeStarted();
        if (!willExtract) {
            SelectionActionModeCallback actionModeCallback = new SelectionActionModeCallback(this);
            this.mSelectionActionMode = this.mTextView.startActionMode(actionModeCallback);
        }
        boolean bl = selectionStarted = this.mSelectionActionMode != null || willExtract;
        if (selectionStarted && !this.mTextView.isTextSelectable() && this.mShowSoftInputOnFocus && (imm = InputMethodManager.peekInstance()) != null) {
            imm.showSoftInput(this.mTextView, 0, null);
        }
        return selectionStarted;
    }

    private final boolean $$robo$$android_widget_Editor$extractedTextModeWillBeStarted() {
        if (!(this.mTextView instanceof ExtractEditText)) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            return imm != null && imm.isFullscreenMode();
        }
        return false;
    }

    private final boolean $$robo$$android_widget_Editor$isCursorInsideSuggestionSpan() {
        CharSequence text = this.mTextView.getText();
        if (!(text instanceof Spannable)) {
            return false;
        }
        SuggestionSpan[] suggestionSpans = ((Spannable)text).getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        return suggestionSpans.length > 0;
    }

    private final boolean $$robo$$android_widget_Editor$isCursorInsideEasyCorrectionSpan() {
        Spannable spannable = (Spannable)this.mTextView.getText();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            if ((suggestionSpans[i].getFlags() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_Editor$onTouchUpEvent(MotionEvent event) {
        boolean selectAllGotFocus = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        this.hideControllers();
        CharSequence text = this.mTextView.getText();
        if (!selectAllGotFocus && text.length() > 0) {
            int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            Selection.setSelection((Spannable)text, offset);
            if (this.mSpellChecker != null) {
                this.mSpellChecker.onSelectionChanged();
            }
            if (!this.extractedTextModeWillBeStarted()) {
                if (this.isCursorInsideEasyCorrectionSpan()) {
                    this.mShowSuggestionRunnable = new Runnable(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ Editor this$0;

                        private void $$robo$$android_widget_Editor_1$__constructor__(Editor editor) {
                        }

                        private final void $$robo$$android_widget_Editor_1$run() {
                            this.this$0.showSuggestions();
                        }

                        private void __constructor__(Editor editor) {
                            this.$$robo$$android_widget_Editor_1$__constructor__(editor);
                        }
                        {
                            this.this$0 = editor;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_1$__constructor__(android.widget.Editor ), 0, this, editor);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Editor_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    this.mTextView.postDelayed(this.mShowSuggestionRunnable, ViewConfiguration.getDoubleTapTimeout());
                } else if (this.hasInsertionController()) {
                    this.getInsertionController().show();
                }
            }
        }
    }

    private final void $$robo$$android_widget_Editor$stopSelectionActionMode() {
        if (this.mSelectionActionMode != null) {
            this.mSelectionActionMode.finish();
        }
    }

    private final boolean $$robo$$android_widget_Editor$hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    private final boolean $$robo$$android_widget_Editor$hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    private final InsertionPointCursorController $$robo$$android_widget_Editor$getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController(this);
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    private final SelectionModifierCursorController $$robo$$android_widget_Editor$getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController(this);
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    private final void $$robo$$android_widget_Editor$updateCursorPosition(int cursorIndex, int top, int bottom, float horizontal) {
        if (this.mCursorDrawable[cursorIndex] == null) {
            this.mCursorDrawable[cursorIndex] = this.mTextView.getContext().getDrawable(this.mTextView.mCursorDrawableRes);
        }
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        this.mCursorDrawable[cursorIndex].getPadding(this.mTempRect);
        int width = this.mCursorDrawable[cursorIndex].getIntrinsicWidth();
        horizontal = Math.max(0.5f, horizontal - 0.5f);
        int left = (int)horizontal - this.mTempRect.left;
        this.mCursorDrawable[cursorIndex].setBounds(left, top - this.mTempRect.top, left + width, bottom + this.mTempRect.bottom);
    }

    private final void $$robo$$android_widget_Editor$onCommitCorrection(CorrectionInfo info) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter(this);
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(info);
    }

    private final void $$robo$$android_widget_Editor$showSuggestions() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow(this);
        }
        this.hideControllers();
        this.mSuggestionsPopupWindow.show();
    }

    private final boolean $$robo$$android_widget_Editor$areSuggestionsShown() {
        return this.mSuggestionsPopupWindow != null && this.mSuggestionsPopupWindow.isShowing();
    }

    private final void $$robo$$android_widget_Editor$onScrollChanged() {
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
    }

    private final boolean $$robo$$android_widget_Editor$shouldBlink() {
        if (!this.isCursorVisible() || !this.mTextView.isFocused()) {
            return false;
        }
        int start = this.mTextView.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.mTextView.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    private final void $$robo$$android_widget_Editor$makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = SystemClock.uptimeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink(this);
            }
            this.mBlink.removeCallbacks(this.mBlink);
            this.mBlink.postAtTime(this.mBlink, this.mShowCursor + 500L);
        } else if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
    }

    private final View.DragShadowBuilder $$robo$$android_widget_Editor$getTextThumbnailBuilder(CharSequence text) {
        TextView shadowView = (TextView)View.inflate(this.mTextView.getContext(), 17367253, null);
        if (shadowView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (text.length() > DRAG_SHADOW_MAX_TEXT_LENGTH) {
            text = text.subSequence(0, DRAG_SHADOW_MAX_TEXT_LENGTH);
        }
        shadowView.setText(text);
        shadowView.setTextColor(this.mTextView.getTextColors());
        shadowView.setTextAppearance(this.mTextView.getContext(), 16);
        shadowView.setGravity(17);
        shadowView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int size = View.MeasureSpec.makeMeasureSpec(0, 0);
        shadowView.measure(size, size);
        shadowView.layout(0, 0, shadowView.getMeasuredWidth(), shadowView.getMeasuredHeight());
        shadowView.invalidate();
        return new View.DragShadowBuilder(shadowView);
    }

    private final void $$robo$$android_widget_Editor$onDrop(DragEvent event) {
        boolean dragDropIntoItself;
        StringBuilder content = new StringBuilder("");
        ClipData clipData = event.getClipData();
        int itemCount = clipData.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ClipData.Item item = clipData.getItemAt(i);
            content.append(item.coerceToStyledText(this.mTextView.getContext()));
        }
        int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
        Object localState = event.getLocalState();
        DragLocalState dragLocalState = null;
        if (localState instanceof DragLocalState) {
            dragLocalState = (DragLocalState)localState;
        }
        boolean bl = dragDropIntoItself = dragLocalState != null && dragLocalState.sourceTextView == this.mTextView;
        if (dragDropIntoItself && offset >= dragLocalState.start && offset < dragLocalState.end) {
            return;
        }
        int originalLength = this.mTextView.getText().length();
        int min = offset;
        int max = offset;
        Selection.setSelection((Spannable)this.mTextView.getText(), max);
        this.mTextView.replaceText_internal(min, max, content);
        if (dragDropIntoItself) {
            CharSequence t;
            int dragSourceStart = dragLocalState.start;
            int dragSourceEnd = dragLocalState.end;
            if (max <= dragSourceStart) {
                int shift = this.mTextView.getText().length() - originalLength;
                dragSourceStart += shift;
                dragSourceEnd += shift;
            }
            this.mTextView.deleteText_internal(dragSourceStart, dragSourceEnd);
            int prevCharIdx = Math.max(0, dragSourceStart - 1);
            int nextCharIdx = Math.min(this.mTextView.getText().length(), dragSourceStart + 1);
            if (nextCharIdx > prevCharIdx + 1 && Character.isSpaceChar((t = this.mTextView.getTransformedText(prevCharIdx, nextCharIdx)).charAt(0)) && Character.isSpaceChar(t.charAt(1))) {
                this.mTextView.deleteText_internal(prevCharIdx, prevCharIdx + 1);
            }
        }
    }

    private final void $$robo$$android_widget_Editor$addSpanWatchers(Spannable text) {
        int textLength = text.length();
        if (this.mKeyListener != null) {
            text.setSpan(this.mKeyListener, 0, textLength, 18);
        }
        if (this.mSpanController == null) {
            this.mSpanController = new SpanController(this);
        }
        text.setSpan(this.mSpanController, 0, textLength, 18);
    }

    static void __staticInitializer__() {
        TEMP_POSITION = new float[2];
        DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
    }

    private void __constructor__(TextView textView) {
        this.$$robo$$android_widget_Editor$__constructor__(textView);
    }

    Editor(TextView textView) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor$__constructor__(android.widget.TextView ), 0, this, textView);
    }

    void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_Editor$onAttachedToWindow(), 0, this);
    }

    void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_Editor$onDetachedFromWindow(), 0, this);
    }

    private void destroyDisplayListsData() {
        InvokeDynamicSupport.bootstrap("destroyDisplayListsData", $$robo$$android_widget_Editor$destroyDisplayListsData(), 0, this);
    }

    private void showError() {
        InvokeDynamicSupport.bootstrap("showError", $$robo$$android_widget_Editor$showError(), 0, this);
    }

    public void setError(CharSequence charSequence, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_widget_Editor$setError(java.lang.CharSequence android.graphics.drawable.Drawable ), 0, this, charSequence, drawable2);
    }

    private void setErrorIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setErrorIcon", $$robo$$android_widget_Editor$setErrorIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void hideError() {
        InvokeDynamicSupport.bootstrap("hideError", $$robo$$android_widget_Editor$hideError(), 0, this);
    }

    private int getErrorX() {
        return (int)InvokeDynamicSupport.bootstrap("getErrorX", $$robo$$android_widget_Editor$getErrorX(), 0, this);
    }

    private int getErrorY() {
        return (int)InvokeDynamicSupport.bootstrap("getErrorY", $$robo$$android_widget_Editor$getErrorY(), 0, this);
    }

    void createInputContentTypeIfNeeded() {
        InvokeDynamicSupport.bootstrap("createInputContentTypeIfNeeded", $$robo$$android_widget_Editor$createInputContentTypeIfNeeded(), 0, this);
    }

    void createInputMethodStateIfNeeded() {
        InvokeDynamicSupport.bootstrap("createInputMethodStateIfNeeded", $$robo$$android_widget_Editor$createInputMethodStateIfNeeded(), 0, this);
    }

    boolean isCursorVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCursorVisible", $$robo$$android_widget_Editor$isCursorVisible(), 0, this);
    }

    void prepareCursorControllers() {
        InvokeDynamicSupport.bootstrap("prepareCursorControllers", $$robo$$android_widget_Editor$prepareCursorControllers(), 0, this);
    }

    private void hideInsertionPointCursorController() {
        InvokeDynamicSupport.bootstrap("hideInsertionPointCursorController", $$robo$$android_widget_Editor$hideInsertionPointCursorController(), 0, this);
    }

    void hideControllers() {
        InvokeDynamicSupport.bootstrap("hideControllers", $$robo$$android_widget_Editor$hideControllers(), 0, this);
    }

    private void hideSpanControllers() {
        InvokeDynamicSupport.bootstrap("hideSpanControllers", $$robo$$android_widget_Editor$hideSpanControllers(), 0, this);
    }

    private void hideCursorControllers() {
        InvokeDynamicSupport.bootstrap("hideCursorControllers", $$robo$$android_widget_Editor$hideCursorControllers(), 0, this);
    }

    private void updateSpellCheckSpans(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateSpellCheckSpans", $$robo$$android_widget_Editor$updateSpellCheckSpans(int int boolean ), 0, this, n, n2, bl);
    }

    void onScreenStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onScreenStateChanged", $$robo$$android_widget_Editor$onScreenStateChanged(int ), 0, this, n);
    }

    private void suspendBlink() {
        InvokeDynamicSupport.bootstrap("suspendBlink", $$robo$$android_widget_Editor$suspendBlink(), 0, this);
    }

    private void resumeBlink() {
        InvokeDynamicSupport.bootstrap("resumeBlink", $$robo$$android_widget_Editor$resumeBlink(), 0, this);
    }

    void adjustInputType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        InvokeDynamicSupport.bootstrap("adjustInputType", $$robo$$android_widget_Editor$adjustInputType(boolean boolean boolean boolean ), 0, this, bl, bl2, bl3, bl4);
    }

    private void chooseSize(PopupWindow popupWindow, CharSequence charSequence, TextView textView) {
        InvokeDynamicSupport.bootstrap("chooseSize", $$robo$$android_widget_Editor$chooseSize(android.widget.PopupWindow java.lang.CharSequence android.widget.TextView ), 0, this, popupWindow, charSequence, textView);
    }

    void setFrame() {
        InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_Editor$setFrame(), 0, this);
    }

    private boolean canSelectText() {
        return (boolean)InvokeDynamicSupport.bootstrap("canSelectText", $$robo$$android_widget_Editor$canSelectText(), 0, this);
    }

    private boolean hasPasswordTransformationMethod() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPasswordTransformationMethod", $$robo$$android_widget_Editor$hasPasswordTransformationMethod(), 0, this);
    }

    private boolean selectCurrentWord() {
        return (boolean)InvokeDynamicSupport.bootstrap("selectCurrentWord", $$robo$$android_widget_Editor$selectCurrentWord(), 0, this);
    }

    void onLocaleChanged() {
        InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_widget_Editor$onLocaleChanged(), 0, this);
    }

    public WordIterator getWordIterator() {
        return InvokeDynamicSupport.bootstrap("getWordIterator", $$robo$$android_widget_Editor$getWordIterator(), 0, this);
    }

    private long getCharRange(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getCharRange", $$robo$$android_widget_Editor$getCharRange(int ), 0, this, n);
    }

    private boolean touchPositionIsInSelection() {
        return (boolean)InvokeDynamicSupport.bootstrap("touchPositionIsInSelection", $$robo$$android_widget_Editor$touchPositionIsInSelection(), 0, this);
    }

    private PositionListener getPositionListener() {
        return InvokeDynamicSupport.bootstrap("getPositionListener", $$robo$$android_widget_Editor$getPositionListener(), 0, this);
    }

    private boolean isPositionVisible(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPositionVisible", $$robo$$android_widget_Editor$isPositionVisible(float float ), 0, this, f, f2);
    }

    private boolean isOffsetVisible(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffsetVisible", $$robo$$android_widget_Editor$isOffsetVisible(int ), 0, this, n);
    }

    private boolean isPositionOnText(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPositionOnText", $$robo$$android_widget_Editor$isPositionOnText(float float ), 0, this, f, f2);
    }

    public boolean performLongClick(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("performLongClick", $$robo$$android_widget_Editor$performLongClick(boolean ), 0, this, bl);
    }

    private long getLastTouchOffsets() {
        return (long)InvokeDynamicSupport.bootstrap("getLastTouchOffsets", $$robo$$android_widget_Editor$getLastTouchOffsets(), 0, this);
    }

    void onFocusChanged(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_Editor$onFocusChanged(boolean int ), 0, this, bl, n);
    }

    private void downgradeEasyCorrectionSpans() {
        InvokeDynamicSupport.bootstrap("downgradeEasyCorrectionSpans", $$robo$$android_widget_Editor$downgradeEasyCorrectionSpans(), 0, this);
    }

    void sendOnTextChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendOnTextChanged", $$robo$$android_widget_Editor$sendOnTextChanged(int int ), 0, this, n, n2);
    }

    private int getLastTapPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getLastTapPosition", $$robo$$android_widget_Editor$getLastTapPosition(), 0, this);
    }

    void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_widget_Editor$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    void onTouchEvent(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Editor$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void beginBatchEdit() {
        InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$android_widget_Editor$beginBatchEdit(), 0, this);
    }

    public void endBatchEdit() {
        InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$android_widget_Editor$endBatchEdit(), 0, this);
    }

    void ensureEndedBatchEdit() {
        InvokeDynamicSupport.bootstrap("ensureEndedBatchEdit", $$robo$$android_widget_Editor$ensureEndedBatchEdit(), 0, this);
    }

    void finishBatchEdit(InputMethodState inputMethodState) {
        InvokeDynamicSupport.bootstrap("finishBatchEdit", $$robo$$android_widget_Editor$finishBatchEdit(android.widget.Editor$InputMethodState ), 0, this, inputMethodState);
    }

    boolean extractText(ExtractedTextRequest extractedTextRequest, ExtractedText extractedText) {
        return (boolean)InvokeDynamicSupport.bootstrap("extractText", $$robo$$android_widget_Editor$extractText(android.view.inputmethod.ExtractedTextRequest android.view.inputmethod.ExtractedText ), 0, this, extractedTextRequest, extractedText);
    }

    private boolean extractTextInternal(ExtractedTextRequest extractedTextRequest, int n, int n2, int n3, ExtractedText extractedText) {
        return (boolean)InvokeDynamicSupport.bootstrap("extractTextInternal", $$robo$$android_widget_Editor$extractTextInternal(android.view.inputmethod.ExtractedTextRequest int int int android.view.inputmethod.ExtractedText ), 0, this, extractedTextRequest, n, n2, n3, extractedText);
    }

    boolean reportExtractedText() {
        return (boolean)InvokeDynamicSupport.bootstrap("reportExtractedText", $$robo$$android_widget_Editor$reportExtractedText(), 0, this);
    }

    private void sendUpdateSelection() {
        InvokeDynamicSupport.bootstrap("sendUpdateSelection", $$robo$$android_widget_Editor$sendUpdateSelection(), 0, this);
    }

    void onDraw(Canvas canvas, Layout layout2, Path path, Paint paint, int n) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_Editor$onDraw(android.graphics.Canvas android.text.Layout android.graphics.Path android.graphics.Paint int ), 0, this, canvas, layout2, path, paint, n);
    }

    private void drawHardwareAccelerated(Canvas canvas, Layout layout2, Path path, Paint paint, int n) {
        InvokeDynamicSupport.bootstrap("drawHardwareAccelerated", $$robo$$android_widget_Editor$drawHardwareAccelerated(android.graphics.Canvas android.text.Layout android.graphics.Path android.graphics.Paint int ), 0, this, canvas, layout2, path, paint, n);
    }

    private int getAvailableDisplayListIndex(int[] nArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getAvailableDisplayListIndex", $$robo$$android_widget_Editor$getAvailableDisplayListIndex(int[] int int ), 0, this, nArray, n, n2);
    }

    private void drawCursor(Canvas canvas, int n) {
        InvokeDynamicSupport.bootstrap("drawCursor", $$robo$$android_widget_Editor$drawCursor(android.graphics.Canvas int ), 0, this, canvas, n);
    }

    void invalidateTextDisplayList(Layout layout2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("invalidateTextDisplayList", $$robo$$android_widget_Editor$invalidateTextDisplayList(android.text.Layout int int ), 0, this, layout2, n, n2);
    }

    void invalidateTextDisplayList() {
        InvokeDynamicSupport.bootstrap("invalidateTextDisplayList", $$robo$$android_widget_Editor$invalidateTextDisplayList(), 0, this);
    }

    void updateCursorsPositions() {
        InvokeDynamicSupport.bootstrap("updateCursorsPositions", $$robo$$android_widget_Editor$updateCursorsPositions(), 0, this);
    }

    private float getPrimaryHorizontal(Layout layout2, Layout layout3, int n, boolean bl) {
        return (float)InvokeDynamicSupport.bootstrap("getPrimaryHorizontal", $$robo$$android_widget_Editor$getPrimaryHorizontal(android.text.Layout android.text.Layout int boolean ), 0, this, layout2, layout3, n, bl);
    }

    boolean startSelectionActionMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("startSelectionActionMode", $$robo$$android_widget_Editor$startSelectionActionMode(), 0, this);
    }

    private boolean extractedTextModeWillBeStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("extractedTextModeWillBeStarted", $$robo$$android_widget_Editor$extractedTextModeWillBeStarted(), 0, this);
    }

    private boolean isCursorInsideSuggestionSpan() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCursorInsideSuggestionSpan", $$robo$$android_widget_Editor$isCursorInsideSuggestionSpan(), 0, this);
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCursorInsideEasyCorrectionSpan", $$robo$$android_widget_Editor$isCursorInsideEasyCorrectionSpan(), 0, this);
    }

    void onTouchUpEvent(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onTouchUpEvent", $$robo$$android_widget_Editor$onTouchUpEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    protected void stopSelectionActionMode() {
        InvokeDynamicSupport.bootstrap("stopSelectionActionMode", $$robo$$android_widget_Editor$stopSelectionActionMode(), 0, this);
    }

    boolean hasInsertionController() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasInsertionController", $$robo$$android_widget_Editor$hasInsertionController(), 0, this);
    }

    boolean hasSelectionController() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSelectionController", $$robo$$android_widget_Editor$hasSelectionController(), 0, this);
    }

    InsertionPointCursorController getInsertionController() {
        return InvokeDynamicSupport.bootstrap("getInsertionController", $$robo$$android_widget_Editor$getInsertionController(), 0, this);
    }

    SelectionModifierCursorController getSelectionController() {
        return InvokeDynamicSupport.bootstrap("getSelectionController", $$robo$$android_widget_Editor$getSelectionController(), 0, this);
    }

    private void updateCursorPosition(int n, int n2, int n3, float f) {
        InvokeDynamicSupport.bootstrap("updateCursorPosition", $$robo$$android_widget_Editor$updateCursorPosition(int int int float ), 0, this, n, n2, n3, f);
    }

    public void onCommitCorrection(CorrectionInfo correctionInfo) {
        InvokeDynamicSupport.bootstrap("onCommitCorrection", $$robo$$android_widget_Editor$onCommitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    void showSuggestions() {
        InvokeDynamicSupport.bootstrap("showSuggestions", $$robo$$android_widget_Editor$showSuggestions(), 0, this);
    }

    boolean areSuggestionsShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("areSuggestionsShown", $$robo$$android_widget_Editor$areSuggestionsShown(), 0, this);
    }

    void onScrollChanged() {
        InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_widget_Editor$onScrollChanged(), 0, this);
    }

    private boolean shouldBlink() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldBlink", $$robo$$android_widget_Editor$shouldBlink(), 0, this);
    }

    void makeBlink() {
        InvokeDynamicSupport.bootstrap("makeBlink", $$robo$$android_widget_Editor$makeBlink(), 0, this);
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("getTextThumbnailBuilder", $$robo$$android_widget_Editor$getTextThumbnailBuilder(java.lang.CharSequence ), 0, this, charSequence);
    }

    void onDrop(DragEvent dragEvent) {
        InvokeDynamicSupport.bootstrap("onDrop", $$robo$$android_widget_Editor$onDrop(android.view.DragEvent ), 0, this, dragEvent);
    }

    public void addSpanWatchers(Spannable spannable) {
        InvokeDynamicSupport.bootstrap("addSpanWatchers", $$robo$$android_widget_Editor$addSpanWatchers(android.text.Spannable ), 0, this, spannable);
    }

    static {
        RobolectricInternals.classInitializing(Editor.class);
    }

    public /* synthetic */ Editor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Editor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TextModifyOperation
    extends UndoOperation<TextView> {
        public transient /* synthetic */ Object __robo_data__;
        int mRangeStart;
        int mRangeEnd;
        CharSequence mOldText;
        public static Parcelable.ClassLoaderCreator<TextModifyOperation> CREATOR;

        private void $$robo$$android_widget_Editor_TextModifyOperation$__constructor__(UndoOwner owner) {
        }

        private void $$robo$$android_widget_Editor_TextModifyOperation$__constructor__(Parcel src, ClassLoader loader) {
            this.mRangeStart = src.readInt();
            this.mRangeEnd = src.readInt();
            this.mOldText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(src);
        }

        private final void $$robo$$android_widget_Editor_TextModifyOperation$commit() {
        }

        private final void $$robo$$android_widget_Editor_TextModifyOperation$undo() {
            this.swapText();
        }

        private final void $$robo$$android_widget_Editor_TextModifyOperation$redo() {
            this.swapText();
        }

        private final void $$robo$$android_widget_Editor_TextModifyOperation$swapText() {
            TextView tv = (TextView)this.getOwnerData();
            Editable editable = (Editable)tv.getText();
            CharSequence curText = this.mRangeStart >= this.mRangeEnd ? null : editable.subSequence(this.mRangeStart, this.mRangeEnd);
            if (this.mOldText == null) {
                editable.delete(this.mRangeStart, this.mRangeEnd);
                this.mRangeEnd = this.mRangeStart;
            } else {
                editable.replace(this.mRangeStart, this.mRangeEnd, this.mOldText);
                this.mRangeEnd = this.mRangeStart + this.mOldText.length();
            }
            this.mOldText = curText;
        }

        private final void $$robo$$android_widget_Editor_TextModifyOperation$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRangeStart);
            dest.writeInt(this.mRangeEnd);
            TextUtils.writeToParcel(this.mOldText, dest, flags);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.ClassLoaderCreator<TextModifyOperation>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_Editor_TextModifyOperation_1$__constructor__() {
                }

                private final TextModifyOperation $$robo$$android_widget_Editor_TextModifyOperation_1$createFromParcel(Parcel in) {
                    return new TextModifyOperation(in, null);
                }

                private final TextModifyOperation $$robo$$android_widget_Editor_TextModifyOperation_1$createFromParcel(Parcel in, ClassLoader loader) {
                    return new TextModifyOperation(in, loader);
                }

                private final TextModifyOperation[] $$robo$$android_widget_Editor_TextModifyOperation_1$newArray(int size) {
                    return new TextModifyOperation[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_Editor_TextModifyOperation_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_TextModifyOperation_1$__constructor__(), 0, this);
                }

                @Override
                public TextModifyOperation createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_Editor_TextModifyOperation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                @Override
                public TextModifyOperation createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_Editor_TextModifyOperation_1$createFromParcel(android.os.Parcel java.lang.ClassLoader ), 0, this, parcel, classLoader);
                }

                public TextModifyOperation[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_Editor_TextModifyOperation_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(UndoOwner undoOwner) {
            this.$$robo$$android_widget_Editor_TextModifyOperation$__constructor__(undoOwner);
        }

        public TextModifyOperation(UndoOwner undoOwner) {
            super(undoOwner);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_TextModifyOperation$__constructor__(android.content.UndoOwner ), 0, this, undoOwner);
        }

        private void __constructor__(Parcel parcel, ClassLoader classLoader) {
            this.$$robo$$android_widget_Editor_TextModifyOperation$__constructor__(parcel, classLoader);
        }

        public TextModifyOperation(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_TextModifyOperation$__constructor__(android.os.Parcel java.lang.ClassLoader ), 0, this, parcel, classLoader);
        }

        @Override
        public void commit() {
            InvokeDynamicSupport.bootstrap("commit", $$robo$$android_widget_Editor_TextModifyOperation$commit(), 0, this);
        }

        @Override
        public void undo() {
            InvokeDynamicSupport.bootstrap("undo", $$robo$$android_widget_Editor_TextModifyOperation$undo(), 0, this);
        }

        @Override
        public void redo() {
            InvokeDynamicSupport.bootstrap("redo", $$robo$$android_widget_Editor_TextModifyOperation$redo(), 0, this);
        }

        private void swapText() {
            InvokeDynamicSupport.bootstrap("swapText", $$robo$$android_widget_Editor_TextModifyOperation$swapText(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_Editor_TextModifyOperation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(TextModifyOperation.class);
        }

        public /* synthetic */ TextModifyOperation() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextModifyOperation)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UndoInputFilter
    implements InputFilter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Editor mEditor;

        private void $$robo$$android_widget_Editor_UndoInputFilter$__constructor__(Editor editor) {
            this.mEditor = editor;
        }

        private final CharSequence $$robo$$android_widget_Editor_UndoInputFilter$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            UndoManager um = this.mEditor.mUndoManager;
            if (um.isInUndo()) {
                return null;
            }
            um.beginUpdate("Edit text");
            TextModifyOperation op = um.getLastOperation(TextModifyOperation.class, this.mEditor.mUndoOwner, 1);
            if (op != null) {
                if (op.mOldText == null) {
                    if (start < end && (dstart >= op.mRangeStart && dend <= op.mRangeEnd || dstart == op.mRangeEnd && dend == op.mRangeEnd)) {
                        op.mRangeEnd = dstart + (end - start);
                        um.endUpdate();
                        return null;
                    }
                } else if (start == end && dend == op.mRangeStart - 1) {
                    SpannableStringBuilder str = op.mOldText instanceof SpannableString ? (SpannableStringBuilder)op.mOldText : new SpannableStringBuilder(op.mOldText);
                    str.insert(0, dest, dstart, dend);
                    op.mRangeStart = dstart;
                    op.mOldText = str;
                    um.endUpdate();
                    return null;
                }
                um.commitState(null);
                um.setUndoLabel("Edit text");
            }
            op = new TextModifyOperation(this.mEditor.mUndoOwner);
            op.mRangeStart = dstart;
            op.mRangeEnd = start < end ? dstart + (end - start) : dstart;
            if (dstart < dend) {
                op.mOldText = dest.subSequence(dstart, dend);
            }
            um.addOperation(op, 0);
            um.endUpdate();
            return null;
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_UndoInputFilter$__constructor__(editor);
        }

        public UndoInputFilter(Editor editor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_UndoInputFilter$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_widget_Editor_UndoInputFilter$filter(java.lang.CharSequence int int android.text.Spanned int int ), 0, this, charSequence, n, n2, spanned, n3, n4);
        }

        public /* synthetic */ UndoInputFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UndoInputFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InputMethodState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Rect mCursorRectInWindow;
        float[] mTmpOffset;
        ExtractedTextRequest mExtractedTextRequest;
        ExtractedText mExtractedText;
        int mBatchEditNesting;
        boolean mCursorChanged;
        boolean mSelectionModeChanged;
        boolean mContentChanged;
        int mChangedStart;
        int mChangedEnd;
        int mChangedDelta;

        private void $$robo$$android_widget_Editor_InputMethodState$__constructor__() {
            this.mCursorRectInWindow = new Rect();
            this.mTmpOffset = new float[2];
            this.mExtractedText = new ExtractedText();
        }

        private void __constructor__() {
            this.$$robo$$android_widget_Editor_InputMethodState$__constructor__();
        }

        InputMethodState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_InputMethodState$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InputContentType
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int imeOptions;
        String privateImeOptions;
        CharSequence imeActionLabel;
        int imeActionId;
        Bundle extras;
        TextView.OnEditorActionListener onEditorActionListener;
        boolean enterDown;

        private void $$robo$$android_widget_Editor_InputContentType$__constructor__() {
            this.imeOptions = 0;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_Editor_InputContentType$__constructor__();
        }

        InputContentType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_InputContentType$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputContentType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ErrorPopup
    extends PopupWindow
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mAbove;
        private TextView mView;
        private int mPopupInlineErrorBackgroundId;
        private int mPopupInlineErrorAboveBackgroundId;

        private void $$robo$$android_widget_Editor_ErrorPopup$__constructor__(TextView v, int width, int height) {
            this.mAbove = false;
            this.mPopupInlineErrorBackgroundId = 0;
            this.mPopupInlineErrorAboveBackgroundId = 0;
            this.mView = v;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 230);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        private final void $$robo$$android_widget_Editor_ErrorPopup$fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 231);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 230);
            }
            this.mView.setBackgroundResource(above ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId);
        }

        private final int $$robo$$android_widget_Editor_ErrorPopup$getResourceId(int currentId, int index) {
            if (currentId == 0) {
                TypedArray styledAttributes = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                currentId = styledAttributes.getResourceId(index, 0);
                styledAttributes.recycle();
            }
            return currentId;
        }

        private final void $$robo$$android_widget_Editor_ErrorPopup$update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }

        private void __constructor__(TextView textView, int n, int n2) {
            this.$$robo$$android_widget_Editor_ErrorPopup$__constructor__(textView, n, n2);
        }

        ErrorPopup(TextView textView, int n, int n2) {
            super(textView, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_ErrorPopup$__constructor__(android.widget.TextView int int ), 0, this, textView, n, n2);
        }

        void fixDirection(boolean bl) {
            InvokeDynamicSupport.bootstrap("fixDirection", $$robo$$android_widget_Editor_ErrorPopup$fixDirection(boolean ), 0, this, bl);
        }

        private int getResourceId(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_widget_Editor_ErrorPopup$getResourceId(int int ), 0, this, n, n2);
        }

        @Override
        public void update(int n, int n2, int n3, int n4, boolean bl) {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_Editor_ErrorPopup$update(int int int int boolean ), 0, this, n, n2, n3, n4, bl);
        }

        public /* synthetic */ ErrorPopup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ErrorPopup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CorrectionHighlighter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Path mPath;
        private Paint mPaint;
        private int mStart;
        private int mEnd;
        private long mFadingStartTime;
        private RectF mTempRectF;
        private static int FADE_OUT_DURATION = 400;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_CorrectionHighlighter$__constructor__(Editor editor) {
            this.mPath = new Path();
            this.mPaint = new Paint(1);
            this.mPaint.setCompatibilityScaling(((Editor)editor).mTextView.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        private final void $$robo$$android_widget_Editor_CorrectionHighlighter$highlight(CorrectionInfo info) {
            this.mStart = info.getOffset();
            this.mEnd = this.mStart + info.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }

        private final void $$robo$$android_widget_Editor_CorrectionHighlighter$draw(Canvas canvas, int cursorOffsetVertical) {
            if (this.updatePath() && this.updatePaint()) {
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, cursorOffsetVertical);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, -cursorOffsetVertical);
                }
                this.invalidate(true);
            } else {
                this.stopAnimation();
                this.invalidate(false);
            }
        }

        private final boolean $$robo$$android_widget_Editor_CorrectionHighlighter$updatePaint() {
            long duration = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (duration > 400L) {
                return false;
            }
            float coef = 1.0f - (float)duration / 400.0f;
            int highlightColorAlpha = Color.alpha(((Editor)this.this$0).mTextView.mHighlightColor);
            int color2 = (((Editor)this.this$0).mTextView.mHighlightColor & 0xFFFFFF) + ((int)((float)highlightColorAlpha * coef) << 24);
            this.mPaint.setColor(color2);
            return true;
        }

        private final boolean $$robo$$android_widget_Editor_CorrectionHighlighter$updatePath() {
            Layout layout2 = this.this$0.mTextView.getLayout();
            if (layout2 == null) {
                return false;
            }
            int length = this.this$0.mTextView.getText().length();
            int start = Math.min(length, this.mStart);
            int end = Math.min(length, this.mEnd);
            this.mPath.reset();
            layout2.getSelectionPath(start, end, this.mPath);
            return true;
        }

        private final void $$robo$$android_widget_Editor_CorrectionHighlighter$invalidate(boolean delayed) {
            if (this.this$0.mTextView.getLayout() == null) {
                return;
            }
            if (this.mTempRectF == null) {
                this.mTempRectF = new RectF();
            }
            this.mPath.computeBounds(this.mTempRectF, false);
            int left = this.this$0.mTextView.getCompoundPaddingLeft();
            int top = this.this$0.mTextView.getExtendedPaddingTop() + this.this$0.mTextView.getVerticalOffset(true);
            if (delayed) {
                this.this$0.mTextView.postInvalidateOnAnimation(left + (int)this.mTempRectF.left, top + (int)this.mTempRectF.top, left + (int)this.mTempRectF.right, top + (int)this.mTempRectF.bottom);
            } else {
                this.this$0.mTextView.postInvalidate((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
            }
        }

        private final void $$robo$$android_widget_Editor_CorrectionHighlighter$stopAnimation() {
            this.this$0.mCorrectionHighlighter = null;
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_CorrectionHighlighter$__constructor__(editor);
        }

        public CorrectionHighlighter(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_CorrectionHighlighter$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        public void highlight(CorrectionInfo correctionInfo) {
            InvokeDynamicSupport.bootstrap("highlight", $$robo$$android_widget_Editor_CorrectionHighlighter$highlight(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
        }

        public void draw(Canvas canvas, int n) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_Editor_CorrectionHighlighter$draw(android.graphics.Canvas int ), 0, this, canvas, n);
        }

        private boolean updatePaint() {
            return (boolean)InvokeDynamicSupport.bootstrap("updatePaint", $$robo$$android_widget_Editor_CorrectionHighlighter$updatePaint(), 0, this);
        }

        private boolean updatePath() {
            return (boolean)InvokeDynamicSupport.bootstrap("updatePath", $$robo$$android_widget_Editor_CorrectionHighlighter$updatePath(), 0, this);
        }

        private void invalidate(boolean bl) {
            InvokeDynamicSupport.bootstrap("invalidate", $$robo$$android_widget_Editor_CorrectionHighlighter$invalidate(boolean ), 0, this, bl);
        }

        private void stopAnimation() {
            InvokeDynamicSupport.bootstrap("stopAnimation", $$robo$$android_widget_Editor_CorrectionHighlighter$stopAnimation(), 0, this);
        }

        public /* synthetic */ CorrectionHighlighter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CorrectionHighlighter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SelectionModifierCursorController
    implements CursorController,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DELAY_BEFORE_REPLACE_ACTION = 200;
        private SelectionStartHandleView mStartHandle;
        private SelectionEndHandleView mEndHandle;
        private int mMinTouchOffset;
        private int mMaxTouchOffset;
        private long mPreviousTapUpTime;
        private float mDownPositionX;
        private float mDownPositionY;
        private boolean mGestureStayedInTapRegion;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SelectionModifierCursorController$__constructor__(Editor editor) {
            this.mPreviousTapUpTime = 0L;
            this.resetTouchOffsets();
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$show() {
            if (this.this$0.mTextView.isInBatchEditMode()) {
                return;
            }
            this.initDrawables();
            this.initHandles();
            this.this$0.hideInsertionPointCursorController();
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$initDrawables() {
            if (this.this$0.mSelectHandleLeft == null) {
                this.this$0.mSelectHandleLeft = this.this$0.mTextView.getContext().getDrawable(((Editor)this.this$0).mTextView.mTextSelectHandleLeftRes);
            }
            if (this.this$0.mSelectHandleRight == null) {
                this.this$0.mSelectHandleRight = this.this$0.mTextView.getContext().getDrawable(((Editor)this.this$0).mTextView.mTextSelectHandleRightRes);
            }
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionStartHandleView(this.this$0, this.this$0.mSelectHandleLeft, this.this$0.mSelectHandleRight);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionEndHandleView(this.this$0, this.this$0.mSelectHandleRight, this.this$0.mSelectHandleLeft);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            this.mStartHandle.showActionPopupWindow(200);
            this.mEndHandle.setActionPopupWindow(this.mStartHandle.getActionPopupWindow());
            this.this$0.hideInsertionPointCursorController();
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$onTouchEvent(MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    long duration;
                    float x = event.getX();
                    float y = event.getY();
                    this.mMinTouchOffset = this.mMaxTouchOffset = this.this$0.mTextView.getOffsetForPosition(x, y);
                    if (this.mGestureStayedInTapRegion && (duration = SystemClock.uptimeMillis() - this.mPreviousTapUpTime) <= (long)ViewConfiguration.getDoubleTapTimeout()) {
                        boolean stayedInArea;
                        float deltaX = x - this.mDownPositionX;
                        float deltaY = y - this.mDownPositionY;
                        float distanceSquared = deltaX * deltaX + deltaY * deltaY;
                        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.this$0.mTextView.getContext());
                        int doubleTapSlop = viewConfiguration.getScaledDoubleTapSlop();
                        boolean bl = stayedInArea = distanceSquared < (float)(doubleTapSlop * doubleTapSlop);
                        if (stayedInArea && this.this$0.isPositionOnText(x, y)) {
                            this.this$0.startSelectionActionMode();
                            this.this$0.mDiscardNextActionUp = true;
                        }
                    }
                    this.mDownPositionX = x;
                    this.mDownPositionY = y;
                    this.mGestureStayedInTapRegion = true;
                    break;
                }
                case 5: 
                case 6: {
                    if (!this.this$0.mTextView.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                    this.updateMinAndMaxOffsets(event);
                    break;
                }
                case 2: {
                    ViewConfiguration viewConfiguration;
                    int doubleTapTouchSlop;
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    if (!this.mGestureStayedInTapRegion || !((distanceSquared = (deltaX = event.getX() - this.mDownPositionX) * deltaX + (deltaY = event.getY() - this.mDownPositionY) * deltaY) > (float)((doubleTapTouchSlop = (viewConfiguration = ViewConfiguration.get(this.this$0.mTextView.getContext())).getScaledDoubleTapTouchSlop()) * doubleTapTouchSlop))) break;
                    this.mGestureStayedInTapRegion = false;
                    break;
                }
                case 1: {
                    this.mPreviousTapUpTime = SystemClock.uptimeMillis();
                }
            }
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int offset = this.this$0.mTextView.getOffsetForPosition(event.getX(index), event.getY(index));
                if (offset < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset;
                }
                if (offset <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset;
            }
        }

        private final int $$robo$$android_widget_Editor_SelectionModifierCursorController$getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        private final int $$robo$$android_widget_Editor_SelectionModifierCursorController$getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
        }

        private final boolean $$robo$$android_widget_Editor_SelectionModifierCursorController$isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        private final void $$robo$$android_widget_Editor_SelectionModifierCursorController$onDetached() {
            ViewTreeObserver observer = this.this$0.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_SelectionModifierCursorController$__constructor__(editor);
        }

        SelectionModifierCursorController(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SelectionModifierCursorController$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_SelectionModifierCursorController$show(), 0, this);
        }

        private void initDrawables() {
            InvokeDynamicSupport.bootstrap("initDrawables", $$robo$$android_widget_Editor_SelectionModifierCursorController$initDrawables(), 0, this);
        }

        private void initHandles() {
            InvokeDynamicSupport.bootstrap("initHandles", $$robo$$android_widget_Editor_SelectionModifierCursorController$initHandles(), 0, this);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_SelectionModifierCursorController$hide(), 0, this);
        }

        public void onTouchEvent(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Editor_SelectionModifierCursorController$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        private void updateMinAndMaxOffsets(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("updateMinAndMaxOffsets", $$robo$$android_widget_Editor_SelectionModifierCursorController$updateMinAndMaxOffsets(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public int getMinTouchOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getMinTouchOffset", $$robo$$android_widget_Editor_SelectionModifierCursorController$getMinTouchOffset(), 0, this);
        }

        public int getMaxTouchOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxTouchOffset", $$robo$$android_widget_Editor_SelectionModifierCursorController$getMaxTouchOffset(), 0, this);
        }

        public void resetTouchOffsets() {
            InvokeDynamicSupport.bootstrap("resetTouchOffsets", $$robo$$android_widget_Editor_SelectionModifierCursorController$resetTouchOffsets(), 0, this);
        }

        public boolean isSelectionStartDragged() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelectionStartDragged", $$robo$$android_widget_Editor_SelectionModifierCursorController$isSelectionStartDragged(), 0, this);
        }

        @Override
        public void onTouchModeChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onTouchModeChanged", $$robo$$android_widget_Editor_SelectionModifierCursorController$onTouchModeChanged(boolean ), 0, this, bl);
        }

        @Override
        public void onDetached() {
            InvokeDynamicSupport.bootstrap("onDetached", $$robo$$android_widget_Editor_SelectionModifierCursorController$onDetached(), 0, this);
        }

        public /* synthetic */ SelectionModifierCursorController() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionModifierCursorController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InsertionPointCursorController
    implements CursorController,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InsertionHandleView mHandle;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_InsertionPointCursorController$__constructor__(Editor editor) {
        }

        private final void $$robo$$android_widget_Editor_InsertionPointCursorController$show() {
            this.getHandle().show();
        }

        private final void $$robo$$android_widget_Editor_InsertionPointCursorController$showWithActionPopup() {
            this.getHandle().showWithActionPopup();
        }

        private final void $$robo$$android_widget_Editor_InsertionPointCursorController$hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        private final void $$robo$$android_widget_Editor_InsertionPointCursorController$onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        private final InsertionHandleView $$robo$$android_widget_Editor_InsertionPointCursorController$getHandle() {
            if (this.this$0.mSelectHandleCenter == null) {
                this.this$0.mSelectHandleCenter = this.this$0.mTextView.getContext().getDrawable(((Editor)this.this$0).mTextView.mTextSelectHandleRes);
            }
            if (this.mHandle == null) {
                this.mHandle = new InsertionHandleView(this.this$0, this.this$0.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        private final void $$robo$$android_widget_Editor_InsertionPointCursorController$onDetached() {
            ViewTreeObserver observer = this.this$0.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_InsertionPointCursorController$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_InsertionPointCursorController$__constructor__(editor);
        }

        private InsertionPointCursorController(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_InsertionPointCursorController$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_InsertionPointCursorController$show(), 0, this);
        }

        public void showWithActionPopup() {
            InvokeDynamicSupport.bootstrap("showWithActionPopup", $$robo$$android_widget_Editor_InsertionPointCursorController$showWithActionPopup(), 0, this);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_InsertionPointCursorController$hide(), 0, this);
        }

        @Override
        public void onTouchModeChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onTouchModeChanged", $$robo$$android_widget_Editor_InsertionPointCursorController$onTouchModeChanged(boolean ), 0, this, bl);
        }

        private InsertionHandleView getHandle() {
            return InvokeDynamicSupport.bootstrap("getHandle", $$robo$$android_widget_Editor_InsertionPointCursorController$getHandle(), 0, this);
        }

        @Override
        public void onDetached() {
            InvokeDynamicSupport.bootstrap("onDetached", $$robo$$android_widget_Editor_InsertionPointCursorController$onDetached(), 0, this);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_InsertionPointCursorController$__constructor__(editor, var2_2);
        }

        public /* synthetic */ InsertionPointCursorController() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsertionPointCursorController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener,
    InstrumentedInterface {
        public void show();

        public void hide();

        public void onDetached();
    }

    private class SelectionEndHandleView
    extends HandleView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SelectionEndHandleView$__constructor__(Editor editor, Drawable drawableLtr, Drawable drawableRtl) {
        }

        private final int $$robo$$android_widget_Editor_SelectionEndHandleView$getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() * 3 / 4;
            }
            return drawable2.getIntrinsicWidth() / 4;
        }

        private final int $$robo$$android_widget_Editor_SelectionEndHandleView$getHorizontalGravity(boolean isRtlRun) {
            return isRtlRun ? 3 : 5;
        }

        private final int $$robo$$android_widget_Editor_SelectionEndHandleView$getCurrentCursorOffset() {
            return this.this$0.mTextView.getSelectionEnd();
        }

        private final void $$robo$$android_widget_Editor_SelectionEndHandleView$updateSelection(int offset) {
            Selection.setSelection((Spannable)this.this$0.mTextView.getText(), this.this$0.mTextView.getSelectionStart(), offset);
            this.updateDrawable();
        }

        private final void $$robo$$android_widget_Editor_SelectionEndHandleView$updatePosition(float x, float y) {
            int selectionStart;
            int offset = this.this$0.mTextView.getOffsetForPosition(x, y);
            if (offset <= (selectionStart = this.this$0.mTextView.getSelectionStart())) {
                offset = Math.min(selectionStart + 1, this.this$0.mTextView.getText().length());
            }
            this.positionAtCursorOffset(offset, false);
        }

        private final void $$robo$$android_widget_Editor_SelectionEndHandleView$setActionPopupWindow(ActionPopupWindow actionPopupWindow) {
            this.mActionPopupWindow = actionPopupWindow;
        }

        private void __constructor__(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.$$robo$$android_widget_Editor_SelectionEndHandleView$__constructor__(editor, drawable2, drawable3);
        }

        public SelectionEndHandleView(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.this$0 = editor;
            super(editor, drawable2, drawable3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SelectionEndHandleView$__constructor__(android.widget.Editor android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, editor, drawable2, drawable3);
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHotspotX", $$robo$$android_widget_Editor_SelectionEndHandleView$getHotspotX(android.graphics.drawable.Drawable boolean ), 0, this, drawable2, bl);
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalGravity", $$robo$$android_widget_Editor_SelectionEndHandleView$getHorizontalGravity(boolean ), 0, this, bl);
        }

        @Override
        public int getCurrentCursorOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentCursorOffset", $$robo$$android_widget_Editor_SelectionEndHandleView$getCurrentCursorOffset(), 0, this);
        }

        @Override
        public void updateSelection(int n) {
            InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_widget_Editor_SelectionEndHandleView$updateSelection(int ), 0, this, n);
        }

        @Override
        public void updatePosition(float f, float f2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_SelectionEndHandleView$updatePosition(float float ), 0, this, f, f2);
        }

        public void setActionPopupWindow(ActionPopupWindow actionPopupWindow) {
            InvokeDynamicSupport.bootstrap("setActionPopupWindow", $$robo$$android_widget_Editor_SelectionEndHandleView$setActionPopupWindow(android.widget.Editor$ActionPopupWindow ), 0, this, actionPopupWindow);
        }

        public /* synthetic */ SelectionEndHandleView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionEndHandleView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SelectionStartHandleView
    extends HandleView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SelectionStartHandleView$__constructor__(Editor editor, Drawable drawableLtr, Drawable drawableRtl) {
        }

        private final int $$robo$$android_widget_Editor_SelectionStartHandleView$getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() * 3 / 4;
        }

        private final int $$robo$$android_widget_Editor_SelectionStartHandleView$getHorizontalGravity(boolean isRtlRun) {
            return isRtlRun ? 5 : 3;
        }

        private final int $$robo$$android_widget_Editor_SelectionStartHandleView$getCurrentCursorOffset() {
            return this.this$0.mTextView.getSelectionStart();
        }

        private final void $$robo$$android_widget_Editor_SelectionStartHandleView$updateSelection(int offset) {
            Selection.setSelection((Spannable)this.this$0.mTextView.getText(), offset, this.this$0.mTextView.getSelectionEnd());
            this.updateDrawable();
        }

        private final void $$robo$$android_widget_Editor_SelectionStartHandleView$updatePosition(float x, float y) {
            int selectionEnd;
            int offset = this.this$0.mTextView.getOffsetForPosition(x, y);
            if (offset >= (selectionEnd = this.this$0.mTextView.getSelectionEnd())) {
                offset = Math.max(0, selectionEnd - 1);
            }
            this.positionAtCursorOffset(offset, false);
        }

        private final ActionPopupWindow $$robo$$android_widget_Editor_SelectionStartHandleView$getActionPopupWindow() {
            return this.mActionPopupWindow;
        }

        private void __constructor__(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.$$robo$$android_widget_Editor_SelectionStartHandleView$__constructor__(editor, drawable2, drawable3);
        }

        public SelectionStartHandleView(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.this$0 = editor;
            super(editor, drawable2, drawable3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SelectionStartHandleView$__constructor__(android.widget.Editor android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, editor, drawable2, drawable3);
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHotspotX", $$robo$$android_widget_Editor_SelectionStartHandleView$getHotspotX(android.graphics.drawable.Drawable boolean ), 0, this, drawable2, bl);
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalGravity", $$robo$$android_widget_Editor_SelectionStartHandleView$getHorizontalGravity(boolean ), 0, this, bl);
        }

        @Override
        public int getCurrentCursorOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentCursorOffset", $$robo$$android_widget_Editor_SelectionStartHandleView$getCurrentCursorOffset(), 0, this);
        }

        @Override
        public void updateSelection(int n) {
            InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_widget_Editor_SelectionStartHandleView$updateSelection(int ), 0, this, n);
        }

        @Override
        public void updatePosition(float f, float f2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_SelectionStartHandleView$updatePosition(float float ), 0, this, f, f2);
        }

        public ActionPopupWindow getActionPopupWindow() {
            return InvokeDynamicSupport.bootstrap("getActionPopupWindow", $$robo$$android_widget_Editor_SelectionStartHandleView$getActionPopupWindow(), 0, this);
        }

        public /* synthetic */ SelectionStartHandleView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionStartHandleView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InsertionHandleView
    extends HandleView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
        private static int RECENT_CUT_COPY_DURATION = 15000;
        private float mDownPositionX;
        private float mDownPositionY;
        private Runnable mHider;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_InsertionHandleView$__constructor__(Editor editor, Drawable drawable2) {
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$show() {
            super.show();
            long durationSinceCutOrCopy = SystemClock.uptimeMillis() - TextView.LAST_CUT_OR_COPY_TIME;
            if (durationSinceCutOrCopy < 15000L) {
                this.showActionPopupWindow(0);
            }
            this.hideAfterDelay();
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$showWithActionPopup() {
            this.show();
            this.showActionPopupWindow(0);
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$hideAfterDelay() {
            if (this.mHider == null) {
                this.mHider = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ InsertionHandleView this$1;

                    private void $$robo$$android_widget_Editor_InsertionHandleView_1$__constructor__(InsertionHandleView insertionHandleView) {
                    }

                    private final void $$robo$$android_widget_Editor_InsertionHandleView_1$run() {
                        this.this$1.hide();
                    }

                    private void __constructor__(InsertionHandleView insertionHandleView) {
                        this.$$robo$$android_widget_Editor_InsertionHandleView_1$__constructor__(insertionHandleView);
                    }
                    {
                        this.this$1 = insertionHandleView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_InsertionHandleView_1$__constructor__(android.widget.Editor$InsertionHandleView ), 0, this, insertionHandleView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Editor_InsertionHandleView_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                this.removeHiderCallback();
            }
            this.this$0.mTextView.postDelayed(this.mHider, 4000L);
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$removeHiderCallback() {
            if (this.mHider != null) {
                this.this$0.mTextView.removeCallbacks(this.mHider);
            }
        }

        private final int $$robo$$android_widget_Editor_InsertionHandleView$getHotspotX(Drawable drawable2, boolean isRtlRun) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        private final int $$robo$$android_widget_Editor_InsertionHandleView$getHorizontalGravity(boolean isRtlRun) {
            return 1;
        }

        private final int $$robo$$android_widget_Editor_InsertionHandleView$getCursorOffset() {
            Drawable cursor;
            int offset = super.getCursorOffset();
            Drawable drawable2 = cursor = this.this$0.mCursorCount > 0 ? this.this$0.mCursorDrawable[0] : null;
            if (cursor != null) {
                cursor.getPadding(this.this$0.mTempRect);
                offset += (cursor.getIntrinsicWidth() - ((Editor)this.this$0).mTempRect.left - ((Editor)this.this$0).mTempRect.right) / 2;
            }
            return offset;
        }

        private final boolean $$robo$$android_widget_Editor_InsertionHandleView$onTouchEvent(MotionEvent ev) {
            boolean result = super.onTouchEvent(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDownPositionX = ev.getRawX();
                    this.mDownPositionY = ev.getRawY();
                    break;
                }
                case 1: {
                    ViewConfiguration viewConfiguration;
                    int touchSlop;
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    if (!this.offsetHasBeenChanged() && (distanceSquared = (deltaX = this.mDownPositionX - ev.getRawX()) * deltaX + (deltaY = this.mDownPositionY - ev.getRawY()) * deltaY) < (float)((touchSlop = (viewConfiguration = ViewConfiguration.get(this.this$0.mTextView.getContext())).getScaledTouchSlop()) * touchSlop)) {
                        if (this.mActionPopupWindow != null && this.mActionPopupWindow.isShowing()) {
                            this.mActionPopupWindow.hide();
                        } else {
                            this.showWithActionPopup();
                        }
                    }
                    this.hideAfterDelay();
                    break;
                }
                case 3: {
                    this.hideAfterDelay();
                    break;
                }
            }
            return result;
        }

        private final int $$robo$$android_widget_Editor_InsertionHandleView$getCurrentCursorOffset() {
            return this.this$0.mTextView.getSelectionStart();
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$updateSelection(int offset) {
            Selection.setSelection((Spannable)this.this$0.mTextView.getText(), offset);
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$updatePosition(float x, float y) {
            this.positionAtCursorOffset(this.this$0.mTextView.getOffsetForPosition(x, y), false);
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        private final void $$robo$$android_widget_Editor_InsertionHandleView$onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }

        private void __constructor__(Editor editor, Drawable drawable2) {
            this.$$robo$$android_widget_Editor_InsertionHandleView$__constructor__(editor, drawable2);
        }

        public InsertionHandleView(Editor editor, Drawable drawable2) {
            this.this$0 = editor;
            super(editor, drawable2, drawable2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_InsertionHandleView$__constructor__(android.widget.Editor android.graphics.drawable.Drawable ), 0, this, editor, drawable2);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_InsertionHandleView$show(), 0, this);
        }

        public void showWithActionPopup() {
            InvokeDynamicSupport.bootstrap("showWithActionPopup", $$robo$$android_widget_Editor_InsertionHandleView$showWithActionPopup(), 0, this);
        }

        private void hideAfterDelay() {
            InvokeDynamicSupport.bootstrap("hideAfterDelay", $$robo$$android_widget_Editor_InsertionHandleView$hideAfterDelay(), 0, this);
        }

        private void removeHiderCallback() {
            InvokeDynamicSupport.bootstrap("removeHiderCallback", $$robo$$android_widget_Editor_InsertionHandleView$removeHiderCallback(), 0, this);
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHotspotX", $$robo$$android_widget_Editor_InsertionHandleView$getHotspotX(android.graphics.drawable.Drawable boolean ), 0, this, drawable2, bl);
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalGravity", $$robo$$android_widget_Editor_InsertionHandleView$getHorizontalGravity(boolean ), 0, this, bl);
        }

        @Override
        protected int getCursorOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getCursorOffset", $$robo$$android_widget_Editor_InsertionHandleView$getCursorOffset(), 0, this);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Editor_InsertionHandleView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        @Override
        public int getCurrentCursorOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentCursorOffset", $$robo$$android_widget_Editor_InsertionHandleView$getCurrentCursorOffset(), 0, this);
        }

        @Override
        public void updateSelection(int n) {
            InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_widget_Editor_InsertionHandleView$updateSelection(int ), 0, this, n);
        }

        @Override
        public void updatePosition(float f, float f2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_InsertionHandleView$updatePosition(float float ), 0, this, f, f2);
        }

        @Override
        void onHandleMoved() {
            InvokeDynamicSupport.bootstrap("onHandleMoved", $$robo$$android_widget_Editor_InsertionHandleView$onHandleMoved(), 0, this);
        }

        @Override
        public void onDetached() {
            InvokeDynamicSupport.bootstrap("onDetached", $$robo$$android_widget_Editor_InsertionHandleView$onDetached(), 0, this);
        }

        public /* synthetic */ InsertionHandleView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsertionHandleView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class HandleView
    extends View
    implements TextViewPositionListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        private PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private boolean mIsDragging;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;
        protected int mHotspotX;
        protected int mHorizontalGravity;
        private float mTouchOffsetY;
        private float mIdealVerticalOffset;
        private int mLastParentX;
        private int mLastParentY;
        protected ActionPopupWindow mActionPopupWindow;
        private int mPreviousOffset;
        private boolean mPositionHasChanged;
        private Runnable mActionPopupShower;
        private int mMinSize;
        private static int HISTORY_SIZE = 5;
        private static int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private long[] mPreviousOffsetsTimes;
        private int[] mPreviousOffsets;
        private int mPreviousOffsetIndex;
        private int mNumberPreviousOffsets;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_HandleView$__constructor__(Editor editor, Drawable drawableLtr, Drawable drawableRtl) {
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.mContainer = new PopupWindow(editor.mTextView.getContext(), null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setContentView(this);
            this.mDrawableLtr = drawableLtr;
            this.mDrawableRtl = drawableRtl;
            this.mMinSize = editor.mTextView.getContext().getResources().getDimensionPixelSize(17105052);
            this.updateDrawable();
            int handleHeight = this.getPreferredHeight();
            this.mTouchOffsetY = -0.3f * (float)handleHeight;
            this.mIdealVerticalOffset = 0.7f * (float)handleHeight;
        }

        private final void $$robo$$android_widget_Editor_HandleView$updateDrawable() {
            int offset = this.getCurrentCursorOffset();
            boolean isRtlCharAtOffset = this.this$0.mTextView.getLayout().isRtlCharAt(offset);
            this.mDrawable = isRtlCharAtOffset ? this.mDrawableRtl : this.mDrawableLtr;
            this.mHotspotX = this.getHotspotX(this.mDrawable, isRtlCharAtOffset);
            this.mHorizontalGravity = this.getHorizontalGravity(isRtlCharAtOffset);
        }

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        protected abstract int getHorizontalGravity(boolean var1);

        private final void $$robo$$android_widget_Editor_HandleView$startTouchUpFilter(int offset) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(offset);
        }

        private final void $$robo$$android_widget_Editor_HandleView$addPositionToTouchUpFilter(int offset) {
            this.mPreviousOffsetIndex = (this.mPreviousOffsetIndex + 1) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = offset;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            ++this.mNumberPreviousOffsets;
        }

        private final void $$robo$$android_widget_Editor_HandleView$filterOnTouchUp() {
            long now = SystemClock.uptimeMillis();
            int i = 0;
            int index = this.mPreviousOffsetIndex;
            int iMax = Math.min(this.mNumberPreviousOffsets, 5);
            while (i < iMax && now - this.mPreviousOffsetsTimes[index] < 150L) {
                index = (this.mPreviousOffsetIndex - ++i + 5) % 5;
            }
            if (i > 0 && i < iMax && now - this.mPreviousOffsetsTimes[index] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[index], false);
            }
        }

        private final boolean $$robo$$android_widget_Editor_HandleView$offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        private final void $$robo$$android_widget_Editor_HandleView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.getPreferredWidth(), this.getPreferredHeight());
        }

        private final int $$robo$$android_widget_Editor_HandleView$getPreferredWidth() {
            return Math.max(this.mDrawable.getIntrinsicWidth(), this.mMinSize);
        }

        private final int $$robo$$android_widget_Editor_HandleView$getPreferredHeight() {
            return Math.max(this.mDrawable.getIntrinsicHeight(), this.mMinSize);
        }

        private final void $$robo$$android_widget_Editor_HandleView$show() {
            if (this.isShowing()) {
                return;
            }
            this.this$0.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false);
            this.hideActionPopupWindow();
        }

        private final void $$robo$$android_widget_Editor_HandleView$dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        private final void $$robo$$android_widget_Editor_HandleView$hide() {
            this.dismiss();
            this.this$0.getPositionListener().removeSubscriber(this);
        }

        private final void $$robo$$android_widget_Editor_HandleView$showActionPopupWindow(int delay) {
            if (this.mActionPopupWindow == null) {
                this.mActionPopupWindow = new ActionPopupWindow(this.this$0);
            }
            if (this.mActionPopupShower == null) {
                this.mActionPopupShower = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ HandleView this$1;

                    private void $$robo$$android_widget_Editor_HandleView_1$__constructor__(HandleView handleView) {
                    }

                    private final void $$robo$$android_widget_Editor_HandleView_1$run() {
                        this.this$1.mActionPopupWindow.show();
                    }

                    private void __constructor__(HandleView handleView) {
                        this.$$robo$$android_widget_Editor_HandleView_1$__constructor__(handleView);
                    }
                    {
                        this.this$1 = handleView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_HandleView_1$__constructor__(android.widget.Editor$HandleView ), 0, this, handleView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Editor_HandleView_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                this.this$0.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            this.this$0.mTextView.postDelayed(this.mActionPopupShower, delay);
        }

        private final void $$robo$$android_widget_Editor_HandleView$hideActionPopupWindow() {
            if (this.mActionPopupShower != null) {
                this.this$0.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            if (this.mActionPopupWindow != null) {
                this.mActionPopupWindow.hide();
            }
        }

        private final boolean $$robo$$android_widget_Editor_HandleView$isShowing() {
            return this.mContainer.isShowing();
        }

        private final boolean $$robo$$android_widget_Editor_HandleView$isVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (this.this$0.mTextView.isInBatchEditMode()) {
                return false;
            }
            return this.this$0.isPositionVisible(this.mPositionX + this.mHotspotX, this.mPositionY);
        }

        public abstract int getCurrentCursorOffset();

        protected abstract void updateSelection(int var1);

        public abstract void updatePosition(float var1, float var2);

        private final void $$robo$$android_widget_Editor_HandleView$positionAtCursorOffset(int offset, boolean parentScrolled) {
            boolean offsetChanged;
            Layout layout2 = this.this$0.mTextView.getLayout();
            if (layout2 == null) {
                this.this$0.prepareCursorControllers();
                return;
            }
            boolean bl = offsetChanged = offset != this.mPreviousOffset;
            if (offsetChanged || parentScrolled) {
                if (offsetChanged) {
                    this.updateSelection(offset);
                    this.addPositionToTouchUpFilter(offset);
                }
                int line = layout2.getLineForOffset(offset);
                this.mPositionX = (int)(layout2.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
                this.mPositionY = layout2.getLineBottom(line);
                this.mPositionX += this.this$0.mTextView.viewportToContentHorizontalOffset();
                this.mPositionY += this.this$0.mTextView.viewportToContentVerticalOffset();
                this.mPreviousOffset = offset;
                this.mPositionHasChanged = true;
            }
        }

        private final void $$robo$$android_widget_Editor_HandleView$updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), parentScrolled);
            if (parentPositionChanged || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (parentPositionX != this.mLastParentX || parentPositionY != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(parentPositionX - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(parentPositionY - this.mLastParentY);
                        this.mLastParentX = parentPositionX;
                        this.mLastParentY = parentPositionY;
                    }
                    this.onHandleMoved();
                }
                if (this.isVisible()) {
                    int positionX = parentPositionX + this.mPositionX;
                    int positionY = parentPositionY + this.mPositionY;
                    if (this.isShowing()) {
                        this.mContainer.update(positionX, positionY, -1, -1);
                    } else {
                        this.mContainer.showAtLocation(this.this$0.mTextView, 0, positionX, positionY);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        private final void $$robo$$android_widget_Editor_HandleView$onDraw(Canvas c) {
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            int left = this.getHorizontalOffset();
            this.mDrawable.setBounds(left, 0, left + drawWidth, this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(c);
        }

        private final int $$robo$$android_widget_Editor_HandleView$getHorizontalOffset() {
            int left;
            int width = this.getPreferredWidth();
            int drawWidth = this.mDrawable.getIntrinsicWidth();
            switch (this.mHorizontalGravity) {
                case 3: {
                    left = 0;
                    break;
                }
                default: {
                    left = (width - drawWidth) / 2;
                    break;
                }
                case 5: {
                    left = width - drawWidth;
                }
            }
            return left;
        }

        private final int $$robo$$android_widget_Editor_HandleView$getCursorOffset() {
            return 0;
        }

        private final boolean $$robo$$android_widget_Editor_HandleView$onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    this.mTouchToWindowOffsetX = ev.getRawX() - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = ev.getRawY() - (float)this.mPositionY;
                    PositionListener positionListener = this.this$0.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mIsDragging = true;
                    break;
                }
                case 2: {
                    float newVerticalOffset;
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    float previousVerticalOffset = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float currentVerticalOffset = rawY - (float)this.mPositionY - (float)this.mLastParentY;
                    if (previousVerticalOffset < this.mIdealVerticalOffset) {
                        newVerticalOffset = Math.min(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.max(newVerticalOffset, previousVerticalOffset);
                    } else {
                        newVerticalOffset = Math.max(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.min(newVerticalOffset, previousVerticalOffset);
                    }
                    this.mTouchToWindowOffsetY = newVerticalOffset + (float)this.mLastParentY;
                    float newPosX = rawX - this.mTouchToWindowOffsetX + (float)this.mHotspotX;
                    float newPosY = rawY - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(newPosX, newPosY);
                    break;
                }
                case 1: {
                    this.filterOnTouchUp();
                    this.mIsDragging = false;
                    break;
                }
                case 3: {
                    this.mIsDragging = false;
                }
            }
            return true;
        }

        private final boolean $$robo$$android_widget_Editor_HandleView$isDragging() {
            return this.mIsDragging;
        }

        private final void $$robo$$android_widget_Editor_HandleView$onHandleMoved() {
            this.hideActionPopupWindow();
        }

        private final void $$robo$$android_widget_Editor_HandleView$onDetached() {
            this.hideActionPopupWindow();
        }

        private void __constructor__(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.$$robo$$android_widget_Editor_HandleView$__constructor__(editor, drawable2, drawable3);
        }

        public HandleView(Editor editor, Drawable drawable2, Drawable drawable3) {
            this.this$0 = editor;
            super(editor.mTextView.getContext());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_HandleView$__constructor__(android.widget.Editor android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, editor, drawable2, drawable3);
        }

        protected void updateDrawable() {
            InvokeDynamicSupport.bootstrap("updateDrawable", $$robo$$android_widget_Editor_HandleView$updateDrawable(), 0, this);
        }

        private void startTouchUpFilter(int n) {
            InvokeDynamicSupport.bootstrap("startTouchUpFilter", $$robo$$android_widget_Editor_HandleView$startTouchUpFilter(int ), 0, this, n);
        }

        private void addPositionToTouchUpFilter(int n) {
            InvokeDynamicSupport.bootstrap("addPositionToTouchUpFilter", $$robo$$android_widget_Editor_HandleView$addPositionToTouchUpFilter(int ), 0, this, n);
        }

        private void filterOnTouchUp() {
            InvokeDynamicSupport.bootstrap("filterOnTouchUp", $$robo$$android_widget_Editor_HandleView$filterOnTouchUp(), 0, this);
        }

        public boolean offsetHasBeenChanged() {
            return (boolean)InvokeDynamicSupport.bootstrap("offsetHasBeenChanged", $$robo$$android_widget_Editor_HandleView$offsetHasBeenChanged(), 0, this);
        }

        @Override
        protected void onMeasure(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_Editor_HandleView$onMeasure(int int ), 0, this, n, n2);
        }

        private int getPreferredWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getPreferredWidth", $$robo$$android_widget_Editor_HandleView$getPreferredWidth(), 0, this);
        }

        private int getPreferredHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getPreferredHeight", $$robo$$android_widget_Editor_HandleView$getPreferredHeight(), 0, this);
        }

        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_HandleView$show(), 0, this);
        }

        protected void dismiss() {
            InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_Editor_HandleView$dismiss(), 0, this);
        }

        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_HandleView$hide(), 0, this);
        }

        void showActionPopupWindow(int n) {
            InvokeDynamicSupport.bootstrap("showActionPopupWindow", $$robo$$android_widget_Editor_HandleView$showActionPopupWindow(int ), 0, this, n);
        }

        protected void hideActionPopupWindow() {
            InvokeDynamicSupport.bootstrap("hideActionPopupWindow", $$robo$$android_widget_Editor_HandleView$hideActionPopupWindow(), 0, this);
        }

        public boolean isShowing() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_Editor_HandleView$isShowing(), 0, this);
        }

        private boolean isVisible() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_widget_Editor_HandleView$isVisible(), 0, this);
        }

        protected void positionAtCursorOffset(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("positionAtCursorOffset", $$robo$$android_widget_Editor_HandleView$positionAtCursorOffset(int boolean ), 0, this, n, bl);
        }

        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_HandleView$updatePosition(int int boolean boolean ), 0, this, n, n2, bl, bl2);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_Editor_HandleView$onDraw(android.graphics.Canvas ), 0, this, canvas);
        }

        private int getHorizontalOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffset", $$robo$$android_widget_Editor_HandleView$getHorizontalOffset(), 0, this);
        }

        protected int getCursorOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getCursorOffset", $$robo$$android_widget_Editor_HandleView$getCursorOffset(), 0, this);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Editor_HandleView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public boolean isDragging() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDragging", $$robo$$android_widget_Editor_HandleView$isDragging(), 0, this);
        }

        void onHandleMoved() {
            InvokeDynamicSupport.bootstrap("onHandleMoved", $$robo$$android_widget_Editor_HandleView$onHandleMoved(), 0, this);
        }

        public void onDetached() {
            InvokeDynamicSupport.bootstrap("onDetached", $$robo$$android_widget_Editor_HandleView$onDetached(), 0, this);
        }

        public /* synthetic */ HandleView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HandleView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CursorAnchorInfoNotifier
    implements TextViewPositionListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CursorAnchorInfo.Builder mSelectionInfoBuilder;
        int[] mTmpIntOffset;
        Matrix mViewToScreenMatrix;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_CursorAnchorInfoNotifier$__constructor__(Editor editor) {
            this.mSelectionInfoBuilder = new CursorAnchorInfo.Builder();
            this.mTmpIntOffset = new int[2];
            this.mViewToScreenMatrix = new Matrix();
        }

        private final void $$robo$$android_widget_Editor_CursorAnchorInfoNotifier$updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            InputMethodState ims = this.this$0.mInputMethodState;
            if (ims == null || ims.mBatchEditNesting > 0) {
                return;
            }
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (null == imm) {
                return;
            }
            if (!imm.isActive(this.this$0.mTextView)) {
                return;
            }
            if (!imm.isCursorAnchorInfoEnabled()) {
                return;
            }
            Layout layout2 = this.this$0.mTextView.getLayout();
            if (layout2 == null) {
                return;
            }
            CursorAnchorInfo.Builder builder = this.mSelectionInfoBuilder;
            builder.reset();
            int selectionStart = this.this$0.mTextView.getSelectionStart();
            builder.setSelectionRange(selectionStart, this.this$0.mTextView.getSelectionEnd());
            this.mViewToScreenMatrix.set(this.this$0.mTextView.getMatrix());
            this.this$0.mTextView.getLocationOnScreen(this.mTmpIntOffset);
            this.mViewToScreenMatrix.postTranslate(this.mTmpIntOffset[0], this.mTmpIntOffset[1]);
            builder.setMatrix(this.mViewToScreenMatrix);
            float viewportToContentHorizontalOffset = this.this$0.mTextView.viewportToContentHorizontalOffset();
            float viewportToContentVerticalOffset = this.this$0.mTextView.viewportToContentVerticalOffset();
            CharSequence text = this.this$0.mTextView.getText();
            if (text instanceof Spannable) {
                boolean hasComposingText;
                Spannable sp = (Spannable)text;
                int composingTextStart = EditableInputConnection.getComposingSpanStart(sp);
                int composingTextEnd = EditableInputConnection.getComposingSpanEnd(sp);
                if (composingTextEnd < composingTextStart) {
                    int temp = composingTextEnd;
                    composingTextEnd = composingTextStart;
                    composingTextStart = temp;
                }
                boolean bl = hasComposingText = 0 <= composingTextStart && composingTextStart < composingTextEnd;
                if (hasComposingText) {
                    CharSequence composingText = text.subSequence(composingTextStart, composingTextEnd);
                    builder.setComposingText(composingTextStart, composingText);
                    int minLine = layout2.getLineForOffset(composingTextStart);
                    int maxLine = layout2.getLineForOffset(composingTextEnd - 1);
                    for (int line = minLine; line <= maxLine; ++line) {
                        int lineStart = layout2.getLineStart(line);
                        int lineEnd = layout2.getLineEnd(line);
                        int offsetStart = Math.max(lineStart, composingTextStart);
                        int offsetEnd = Math.min(lineEnd, composingTextEnd);
                        boolean ltrLine = layout2.getParagraphDirection(line) == 1;
                        float[] widths = new float[offsetEnd - offsetStart];
                        layout2.getPaint().getTextWidths(text, offsetStart, offsetEnd, widths);
                        float top = layout2.getLineTop(line);
                        float bottom = layout2.getLineBottom(line);
                        for (int offset = offsetStart; offset < offsetEnd; ++offset) {
                            float right;
                            float left;
                            float charWidth = widths[offset - offsetStart];
                            boolean isRtl = layout2.isRtlCharAt(offset);
                            float primary = layout2.getPrimaryHorizontal(offset);
                            float secondary = layout2.getSecondaryHorizontal(offset);
                            if (ltrLine) {
                                if (isRtl) {
                                    left = secondary - charWidth;
                                    right = secondary;
                                } else {
                                    left = primary;
                                    right = primary + charWidth;
                                }
                            } else if (!isRtl) {
                                left = secondary;
                                right = secondary + charWidth;
                            } else {
                                left = primary - charWidth;
                                right = primary;
                            }
                            float localLeft = left + viewportToContentHorizontalOffset;
                            float localRight = right + viewportToContentHorizontalOffset;
                            float localTop = top + viewportToContentVerticalOffset;
                            float localBottom = bottom + viewportToContentVerticalOffset;
                            boolean isTopLeftVisible = this.this$0.isPositionVisible(localLeft, localTop);
                            boolean isBottomRightVisible = this.this$0.isPositionVisible(localRight, localBottom);
                            int characterBoundsFlags = 0;
                            if (isTopLeftVisible || isBottomRightVisible) {
                                characterBoundsFlags |= 1;
                            }
                            if (!isTopLeftVisible || !isTopLeftVisible) {
                                characterBoundsFlags |= 2;
                            }
                            if (isRtl) {
                                characterBoundsFlags |= 4;
                            }
                            builder.addCharacterBounds(offset, localLeft, localTop, localRight, localBottom, characterBoundsFlags);
                        }
                    }
                }
            }
            if (0 <= selectionStart) {
                int offset = selectionStart;
                int line = layout2.getLineForOffset(offset);
                float insertionMarkerX = layout2.getPrimaryHorizontal(offset) + viewportToContentHorizontalOffset;
                float insertionMarkerTop = (float)layout2.getLineTop(line) + viewportToContentVerticalOffset;
                float insertionMarkerBaseline = (float)layout2.getLineBaseline(line) + viewportToContentVerticalOffset;
                float insertionMarkerBottom = (float)layout2.getLineBottom(line) + viewportToContentVerticalOffset;
                boolean isTopVisible = this.this$0.isPositionVisible(insertionMarkerX, insertionMarkerTop);
                boolean isBottomVisible = this.this$0.isPositionVisible(insertionMarkerX, insertionMarkerBottom);
                int insertionMarkerFlags = 0;
                if (isTopVisible || isBottomVisible) {
                    insertionMarkerFlags |= 1;
                }
                if (!isTopVisible || !isBottomVisible) {
                    insertionMarkerFlags |= 2;
                }
                if (layout2.isRtlCharAt(offset)) {
                    insertionMarkerFlags |= 4;
                }
                builder.setInsertionMarkerLocation(insertionMarkerX, insertionMarkerTop, insertionMarkerBaseline, insertionMarkerBottom, insertionMarkerFlags);
            }
            imm.updateCursorAnchorInfo(this.this$0.mTextView, builder.build());
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_CursorAnchorInfoNotifier$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_CursorAnchorInfoNotifier$__constructor__(editor);
        }

        private CursorAnchorInfoNotifier(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_CursorAnchorInfoNotifier$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_CursorAnchorInfoNotifier$updatePosition(int int boolean boolean ), 0, this, n, n2, bl, bl2);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_CursorAnchorInfoNotifier$__constructor__(editor, var2_2);
        }

        public /* synthetic */ CursorAnchorInfoNotifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorAnchorInfoNotifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActionPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int POPUP_TEXT_LAYOUT = 17367254;
        private TextView mPasteTextView;
        private TextView mReplaceTextView;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_ActionPopupWindow$__constructor__(Editor editor) {
        }

        private final void $$robo$$android_widget_Editor_ActionPopupWindow$createPopupWindow() {
            this.mPopupWindow = new PopupWindow(this.this$0.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setClippingEnabled(true);
        }

        private final void $$robo$$android_widget_Editor_ActionPopupWindow$initContentView() {
            LinearLayout linearLayout = new LinearLayout(this.this$0.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303298);
            LayoutInflater inflater = (LayoutInflater)this.this$0.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mPasteTextView = (TextView)inflater.inflate(17367254, null);
            this.mPasteTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mPasteTextView);
            this.mPasteTextView.setText(17039371);
            this.mPasteTextView.setOnClickListener(this);
            this.mReplaceTextView = (TextView)inflater.inflate(17367254, null);
            this.mReplaceTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mReplaceTextView);
            this.mReplaceTextView.setText(17040465);
            this.mReplaceTextView.setOnClickListener(this);
        }

        private final void $$robo$$android_widget_Editor_ActionPopupWindow$show() {
            boolean canPaste = this.this$0.mTextView.canPaste();
            boolean canSuggest = this.this$0.mTextView.isSuggestionsEnabled() && this.this$0.isCursorInsideSuggestionSpan();
            this.mPasteTextView.setVisibility(canPaste ? 0 : 8);
            this.mReplaceTextView.setVisibility(canSuggest ? 0 : 8);
            if (!canPaste && !canSuggest) {
                return;
            }
            super.show();
        }

        private final void $$robo$$android_widget_Editor_ActionPopupWindow$onClick(View view) {
            if (view == this.mPasteTextView && this.this$0.mTextView.canPaste()) {
                this.this$0.mTextView.onTextContextMenuItem(0x1020022);
                this.hide();
            } else if (view == this.mReplaceTextView) {
                int middle = (this.this$0.mTextView.getSelectionStart() + this.this$0.mTextView.getSelectionEnd()) / 2;
                this.this$0.stopSelectionActionMode();
                Selection.setSelection((Spannable)this.this$0.mTextView.getText(), middle);
                this.this$0.showSuggestions();
            }
        }

        private final int $$robo$$android_widget_Editor_ActionPopupWindow$getTextOffset() {
            return (this.this$0.mTextView.getSelectionStart() + this.this$0.mTextView.getSelectionEnd()) / 2;
        }

        private final int $$robo$$android_widget_Editor_ActionPopupWindow$getVerticalLocalPosition(int line) {
            return this.this$0.mTextView.getLayout().getLineTop(line) - this.mContentView.getMeasuredHeight();
        }

        private final int $$robo$$android_widget_Editor_ActionPopupWindow$clipVertically(int positionY) {
            if (positionY < 0) {
                int offset = this.getTextOffset();
                Layout layout2 = this.this$0.mTextView.getLayout();
                int line = layout2.getLineForOffset(offset);
                positionY += layout2.getLineBottom(line) - layout2.getLineTop(line);
                positionY += this.mContentView.getMeasuredHeight();
                Drawable handle = this.this$0.mTextView.getContext().getDrawable(((Editor)this.this$0).mTextView.mTextSelectHandleRes);
                positionY += handle.getIntrinsicHeight();
            }
            return positionY;
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_ActionPopupWindow$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_ActionPopupWindow$__constructor__(editor);
        }

        private ActionPopupWindow(Editor editor) {
            this.this$0 = editor;
            super(editor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_ActionPopupWindow$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        protected void createPopupWindow() {
            InvokeDynamicSupport.bootstrap("createPopupWindow", $$robo$$android_widget_Editor_ActionPopupWindow$createPopupWindow(), 0, this);
        }

        @Override
        protected void initContentView() {
            InvokeDynamicSupport.bootstrap("initContentView", $$robo$$android_widget_Editor_ActionPopupWindow$initContentView(), 0, this);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_ActionPopupWindow$show(), 0, this);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_Editor_ActionPopupWindow$onClick(android.view.View ), 0, this, view);
        }

        @Override
        protected int getTextOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getTextOffset", $$robo$$android_widget_Editor_ActionPopupWindow$getTextOffset(), 0, this);
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalLocalPosition", $$robo$$android_widget_Editor_ActionPopupWindow$getVerticalLocalPosition(int ), 0, this, n);
        }

        @Override
        protected int clipVertically(int n) {
            return (int)InvokeDynamicSupport.bootstrap("clipVertically", $$robo$$android_widget_Editor_ActionPopupWindow$clipVertically(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_ActionPopupWindow$__constructor__(editor, var2_2);
        }

        public /* synthetic */ ActionPopupWindow() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionPopupWindow)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SelectionActionModeCallback
    implements ActionMode.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SelectionActionModeCallback$__constructor__(Editor editor) {
        }

        private final boolean $$robo$$android_widget_Editor_SelectionActionModeCallback$onCreateActionMode(ActionMode mode, Menu menu2) {
            boolean legacy = ((Editor)this.this$0).mTextView.getContext().getApplicationInfo().targetSdkVersion < 21;
            Context context = !legacy && menu2 instanceof MenuBuilder ? ((MenuBuilder)menu2).getContext() : this.this$0.mTextView.getContext();
            TypedArray styledAttributes = context.obtainStyledAttributes(R.styleable.SelectionModeDrawables);
            mode.setTitle(this.this$0.mTextView.getContext().getString(17040467));
            mode.setSubtitle(null);
            mode.setTitleOptionalHint(true);
            menu2.add(0, 16908319, 0, 17039373).setIcon(styledAttributes.getResourceId(3, 0)).setAlphabeticShortcut('a').setShowAsAction(6);
            if (this.this$0.mTextView.canCut()) {
                menu2.add(0, 0x1020020, 0, 17039363).setIcon(styledAttributes.getResourceId(0, 0)).setAlphabeticShortcut('x').setShowAsAction(6);
            }
            if (this.this$0.mTextView.canCopy()) {
                menu2.add(0, 0x1020021, 0, 0x1040001).setIcon(styledAttributes.getResourceId(1, 0)).setAlphabeticShortcut('c').setShowAsAction(6);
            }
            if (this.this$0.mTextView.canPaste()) {
                menu2.add(0, 0x1020022, 0, 17039371).setIcon(styledAttributes.getResourceId(2, 0)).setAlphabeticShortcut('v').setShowAsAction(6);
            }
            styledAttributes.recycle();
            if (this.this$0.mCustomSelectionActionModeCallback != null && !this.this$0.mCustomSelectionActionModeCallback.onCreateActionMode(mode, menu2)) {
                return false;
            }
            if (menu2.hasVisibleItems() || mode.getCustomView() != null) {
                this.this$0.getSelectionController().show();
                this.this$0.mTextView.setHasTransientState(true);
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_widget_Editor_SelectionActionModeCallback$onPrepareActionMode(ActionMode mode, Menu menu2) {
            if (this.this$0.mCustomSelectionActionModeCallback != null) {
                return this.this$0.mCustomSelectionActionModeCallback.onPrepareActionMode(mode, menu2);
            }
            return true;
        }

        private final boolean $$robo$$android_widget_Editor_SelectionActionModeCallback$onActionItemClicked(ActionMode mode, MenuItem item) {
            if (this.this$0.mCustomSelectionActionModeCallback != null && this.this$0.mCustomSelectionActionModeCallback.onActionItemClicked(mode, item)) {
                return true;
            }
            return this.this$0.mTextView.onTextContextMenuItem(item.getItemId());
        }

        private final void $$robo$$android_widget_Editor_SelectionActionModeCallback$onDestroyActionMode(ActionMode mode) {
            if (this.this$0.mCustomSelectionActionModeCallback != null) {
                this.this$0.mCustomSelectionActionModeCallback.onDestroyActionMode(mode);
            }
            if (!this.this$0.mPreserveDetachedSelection) {
                Selection.setSelection((Spannable)this.this$0.mTextView.getText(), this.this$0.mTextView.getSelectionEnd());
                this.this$0.mTextView.setHasTransientState(false);
            }
            if (this.this$0.mSelectionModifierCursorController != null) {
                this.this$0.mSelectionModifierCursorController.hide();
            }
            this.this$0.mSelectionActionMode = null;
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_SelectionActionModeCallback$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_SelectionActionModeCallback$__constructor__(editor);
        }

        private SelectionActionModeCallback(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SelectionActionModeCallback$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onCreateActionMode", $$robo$$android_widget_Editor_SelectionActionModeCallback$onCreateActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPrepareActionMode", $$robo$$android_widget_Editor_SelectionActionModeCallback$onPrepareActionMode(android.view.ActionMode android.view.Menu ), 0, this, actionMode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onActionItemClicked", $$robo$$android_widget_Editor_SelectionActionModeCallback$onActionItemClicked(android.view.ActionMode android.view.MenuItem ), 0, this, actionMode, menuItem);
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_widget_Editor_SelectionActionModeCallback$onDestroyActionMode(android.view.ActionMode ), 0, this, actionMode);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_SelectionActionModeCallback$__constructor__(editor, var2_2);
        }

        public /* synthetic */ SelectionActionModeCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionActionModeCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_NUMBER_SUGGESTIONS = 5;
        private static int ADD_TO_DICTIONARY = -1;
        private static int DELETE_TEXT = -2;
        private SuggestionInfo[] mSuggestionInfos;
        private int mNumberOfSuggestions;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp;
        private SuggestionAdapter mSuggestionsAdapter;
        private Comparator<SuggestionSpan> mSuggestionSpanComparator;
        private HashMap<SuggestionSpan, Integer> mSpansLengths;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SuggestionsPopupWindow$__constructor__(Editor editor) {
            this.mIsShowingUp = false;
            this.mCursorWasVisibleBeforeSuggestions = editor.mCursorVisible;
            this.mSuggestionSpanComparator = new SuggestionSpanComparator(this);
            this.mSpansLengths = new HashMap();
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow(this, this.this$0.mTextView.getContext(), 16843635);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$initContentView() {
            ListView listView = new ListView(this.this$0.mTextView.getContext());
            this.mSuggestionsAdapter = new SuggestionAdapter(this);
            listView.setAdapter(this.mSuggestionsAdapter);
            listView.setOnItemClickListener(this);
            this.mContentView = listView;
            this.mSuggestionInfos = new SuggestionInfo[7];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo(this);
            }
        }

        private final boolean $$robo$$android_widget_Editor_SuggestionsPopupWindow$isShowingUp() {
            return this.mIsShowingUp;
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        private final SuggestionSpan[] $$robo$$android_widget_Editor_SuggestionsPopupWindow$getSuggestionSpans() {
            int pos = this.this$0.mTextView.getSelectionStart();
            Spannable spannable = (Spannable)this.this$0.mTextView.getText();
            SuggestionSpan[] suggestionSpans = spannable.getSpans(pos, pos, SuggestionSpan.class);
            this.mSpansLengths.clear();
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int start = spannable.getSpanStart(suggestionSpan);
                int end = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, end - start);
            }
            Arrays.sort(suggestionSpans, this.mSuggestionSpanComparator);
            return suggestionSpans;
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$show() {
            if (!(this.this$0.mTextView.getText() instanceof Editable)) {
                return;
            }
            if (this.updateSuggestions()) {
                this.mCursorWasVisibleBeforeSuggestions = this.this$0.mCursorVisible;
                this.this$0.mTextView.setCursorVisible(false);
                this.mIsShowingUp = true;
                super.show();
            }
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$measureContent() {
            DisplayMetrics displayMetrics = this.this$0.mTextView.getResources().getDisplayMetrics();
            int horizontalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int verticalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int width = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, view.getMeasuredWidth());
            }
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), verticalMeasure);
            Drawable popupBackground = this.mPopupWindow.getBackground();
            if (popupBackground != null) {
                if (this.this$0.mTempRect == null) {
                    this.this$0.mTempRect = new Rect();
                }
                popupBackground.getPadding(this.this$0.mTempRect);
                width += ((Editor)this.this$0).mTempRect.left + ((Editor)this.this$0).mTempRect.right;
            }
            this.mPopupWindow.setWidth(width);
        }

        private final int $$robo$$android_widget_Editor_SuggestionsPopupWindow$getTextOffset() {
            return this.this$0.mTextView.getSelectionStart();
        }

        private final int $$robo$$android_widget_Editor_SuggestionsPopupWindow$getVerticalLocalPosition(int line) {
            return this.this$0.mTextView.getLayout().getLineBottom(line);
        }

        private final int $$robo$$android_widget_Editor_SuggestionsPopupWindow$clipVertically(int positionY) {
            int height = this.mContentView.getMeasuredHeight();
            DisplayMetrics displayMetrics = this.this$0.mTextView.getResources().getDisplayMetrics();
            return Math.min(positionY, displayMetrics.heightPixels - height);
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$hide() {
            super.hide();
        }

        private final boolean $$robo$$android_widget_Editor_SuggestionsPopupWindow$updateSuggestions() {
            Spannable spannable = (Spannable)this.this$0.mTextView.getText();
            SuggestionSpan[] suggestionSpans = this.getSuggestionSpans();
            int nbSpans = suggestionSpans.length;
            if (nbSpans == 0) {
                return false;
            }
            this.mNumberOfSuggestions = 0;
            int spanUnionStart = this.this$0.mTextView.getText().length();
            int spanUnionEnd = 0;
            SuggestionSpan misspelledSpan = null;
            int underlineColor = 0;
            block0: for (int spanIndex = 0; spanIndex < nbSpans; ++spanIndex) {
                SuggestionSpan suggestionSpan = suggestionSpans[spanIndex];
                int spanStart = spannable.getSpanStart(suggestionSpan);
                int spanEnd = spannable.getSpanEnd(suggestionSpan);
                spanUnionStart = Math.min(spanStart, spanUnionStart);
                spanUnionEnd = Math.max(spanEnd, spanUnionEnd);
                if ((suggestionSpan.getFlags() & 2) != 0) {
                    misspelledSpan = suggestionSpan;
                }
                if (spanIndex == 0) {
                    underlineColor = suggestionSpan.getUnderlineColor();
                }
                String[] suggestions = suggestionSpan.getSuggestions();
                int nbSuggestions = suggestions.length;
                for (int suggestionIndex = 0; suggestionIndex < nbSuggestions; ++suggestionIndex) {
                    String suggestion = suggestions[suggestionIndex];
                    boolean suggestionIsDuplicate = false;
                    for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                        if (!this.mSuggestionInfos[i].text.toString().equals(suggestion)) continue;
                        SuggestionSpan otherSuggestionSpan = this.mSuggestionInfos[i].suggestionSpan;
                        int otherSpanStart = spannable.getSpanStart(otherSuggestionSpan);
                        int otherSpanEnd = spannable.getSpanEnd(otherSuggestionSpan);
                        if (spanStart != otherSpanStart || spanEnd != otherSpanEnd) continue;
                        suggestionIsDuplicate = true;
                        break;
                    }
                    if (suggestionIsDuplicate) continue;
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = suggestionSpan;
                    suggestionInfo.suggestionIndex = suggestionIndex;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), suggestion);
                    ++this.mNumberOfSuggestions;
                    if (this.mNumberOfSuggestions != 5) continue;
                    spanIndex = nbSpans;
                    continue block0;
                }
            }
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                this.highlightTextDifferences(this.mSuggestionInfos[i], spanUnionStart, spanUnionEnd);
            }
            if (misspelledSpan != null) {
                int misspelledStart = spannable.getSpanStart(misspelledSpan);
                int misspelledEnd = spannable.getSpanEnd(misspelledSpan);
                if (misspelledStart >= 0 && misspelledEnd > misspelledStart) {
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = misspelledSpan;
                    suggestionInfo.suggestionIndex = -1;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), this.this$0.mTextView.getContext().getString(17040468));
                    suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                    ++this.mNumberOfSuggestions;
                }
            }
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
            suggestionInfo.suggestionSpan = null;
            suggestionInfo.suggestionIndex = -2;
            suggestionInfo.text.replace(0, suggestionInfo.text.length(), this.this$0.mTextView.getContext().getString(17040469));
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
            ++this.mNumberOfSuggestions;
            if (this.this$0.mSuggestionRangeSpan == null) {
                this.this$0.mSuggestionRangeSpan = new SuggestionRangeSpan();
            }
            if (underlineColor == 0) {
                this.this$0.mSuggestionRangeSpan.setBackgroundColor(((Editor)this.this$0).mTextView.mHighlightColor);
            } else {
                float BACKGROUND_TRANSPARENCY = 0.4f;
                int newAlpha = (int)((float)Color.alpha(underlineColor) * 0.4f);
                this.this$0.mSuggestionRangeSpan.setBackgroundColor((underlineColor & 0xFFFFFF) + (newAlpha << 24));
            }
            spannable.setSpan(this.this$0.mSuggestionRangeSpan, spanUnionStart, spanUnionEnd, 33);
            this.mSuggestionsAdapter.notifyDataSetChanged();
            return true;
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$highlightTextDifferences(SuggestionInfo suggestionInfo, int unionStart, int unionEnd) {
            Spannable text = (Spannable)this.this$0.mTextView.getText();
            int spanStart = text.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = text.getSpanEnd(suggestionInfo.suggestionSpan);
            suggestionInfo.suggestionStart = spanStart - unionStart;
            suggestionInfo.suggestionEnd = suggestionInfo.suggestionStart + suggestionInfo.text.length();
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, suggestionInfo.text.length(), 33);
            String textAsString = text.toString();
            suggestionInfo.text.insert(0, textAsString.substring(unionStart, spanStart));
            suggestionInfo.text.append(textAsString.substring(spanEnd, unionEnd));
        }

        private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            Editable editable = (Editable)this.this$0.mTextView.getText();
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[position];
            if (suggestionInfo.suggestionIndex == -2) {
                int spanUnionStart = editable.getSpanStart(this.this$0.mSuggestionRangeSpan);
                int spanUnionEnd = editable.getSpanEnd(this.this$0.mSuggestionRangeSpan);
                if (spanUnionStart >= 0 && spanUnionEnd > spanUnionStart) {
                    if (spanUnionEnd < editable.length() && Character.isSpaceChar(editable.charAt(spanUnionEnd)) && (spanUnionStart == 0 || Character.isSpaceChar(editable.charAt(spanUnionStart - 1)))) {
                        ++spanUnionEnd;
                    }
                    this.this$0.mTextView.deleteText_internal(spanUnionStart, spanUnionEnd);
                }
                this.hide();
                return;
            }
            int spanStart = editable.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = editable.getSpanEnd(suggestionInfo.suggestionSpan);
            if (spanStart < 0 || spanEnd <= spanStart) {
                this.hide();
                return;
            }
            String originalText = editable.toString().substring(spanStart, spanEnd);
            if (suggestionInfo.suggestionIndex == -1) {
                Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                intent.putExtra("word", originalText);
                intent.putExtra("locale", this.this$0.mTextView.getTextServicesLocale().toString());
                intent.setFlags(intent.getFlags() | 0x10000000);
                this.this$0.mTextView.getContext().startActivity(intent);
                editable.removeSpan(suggestionInfo.suggestionSpan);
                Selection.setSelection(editable, spanEnd);
                this.this$0.updateSpellCheckSpans(spanStart, spanEnd, false);
            } else {
                SuggestionSpan[] suggestionSpans = (SuggestionSpan[])editable.getSpans(spanStart, spanEnd, SuggestionSpan.class);
                int length = suggestionSpans.length;
                int[] suggestionSpansStarts = new int[length];
                int[] suggestionSpansEnds = new int[length];
                int[] suggestionSpansFlags = new int[length];
                for (int i = 0; i < length; ++i) {
                    SuggestionSpan suggestionSpan = suggestionSpans[i];
                    suggestionSpansStarts[i] = editable.getSpanStart(suggestionSpan);
                    suggestionSpansEnds[i] = editable.getSpanEnd(suggestionSpan);
                    suggestionSpansFlags[i] = editable.getSpanFlags(suggestionSpan);
                    int suggestionSpanFlags = suggestionSpan.getFlags();
                    if ((suggestionSpanFlags & 2) <= 0) continue;
                    suggestionSpanFlags &= 0xFFFFFFFD;
                    suggestionSpan.setFlags(suggestionSpanFlags &= 0xFFFFFFFE);
                }
                int suggestionStart = suggestionInfo.suggestionStart;
                int suggestionEnd = suggestionInfo.suggestionEnd;
                String suggestion = suggestionInfo.text.subSequence(suggestionStart, suggestionEnd).toString();
                this.this$0.mTextView.replaceText_internal(spanStart, spanEnd, suggestion);
                suggestionInfo.suggestionSpan.notifySelection(this.this$0.mTextView.getContext(), originalText, suggestionInfo.suggestionIndex);
                String[] suggestions = suggestionInfo.suggestionSpan.getSuggestions();
                suggestions[suggestionInfo.suggestionIndex] = originalText;
                int lengthDifference = suggestion.length() - (spanEnd - spanStart);
                for (int i = 0; i < length; ++i) {
                    if (suggestionSpansStarts[i] > spanStart || suggestionSpansEnds[i] < spanEnd) continue;
                    this.this$0.mTextView.setSpan_internal(suggestionSpans[i], suggestionSpansStarts[i], suggestionSpansEnds[i] + lengthDifference, suggestionSpansFlags[i]);
                }
                int newCursorPosition = spanEnd + lengthDifference;
                this.this$0.mTextView.setCursorPosition_internal(newCursorPosition, newCursorPosition);
            }
            this.hide();
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_SuggestionsPopupWindow$__constructor__(editor);
        }

        public SuggestionsPopupWindow(Editor editor) {
            this.this$0 = editor;
            super(editor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SuggestionsPopupWindow$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        protected void createPopupWindow() {
            InvokeDynamicSupport.bootstrap("createPopupWindow", $$robo$$android_widget_Editor_SuggestionsPopupWindow$createPopupWindow(), 0, this);
        }

        @Override
        protected void initContentView() {
            InvokeDynamicSupport.bootstrap("initContentView", $$robo$$android_widget_Editor_SuggestionsPopupWindow$initContentView(), 0, this);
        }

        public boolean isShowingUp() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowingUp", $$robo$$android_widget_Editor_SuggestionsPopupWindow$isShowingUp(), 0, this);
        }

        public void onParentLostFocus() {
            InvokeDynamicSupport.bootstrap("onParentLostFocus", $$robo$$android_widget_Editor_SuggestionsPopupWindow$onParentLostFocus(), 0, this);
        }

        private SuggestionSpan[] getSuggestionSpans() {
            return InvokeDynamicSupport.bootstrap("getSuggestionSpans", $$robo$$android_widget_Editor_SuggestionsPopupWindow$getSuggestionSpans(), 0, this);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_SuggestionsPopupWindow$show(), 0, this);
        }

        @Override
        protected void measureContent() {
            InvokeDynamicSupport.bootstrap("measureContent", $$robo$$android_widget_Editor_SuggestionsPopupWindow$measureContent(), 0, this);
        }

        @Override
        protected int getTextOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getTextOffset", $$robo$$android_widget_Editor_SuggestionsPopupWindow$getTextOffset(), 0, this);
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalLocalPosition", $$robo$$android_widget_Editor_SuggestionsPopupWindow$getVerticalLocalPosition(int ), 0, this, n);
        }

        @Override
        protected int clipVertically(int n) {
            return (int)InvokeDynamicSupport.bootstrap("clipVertically", $$robo$$android_widget_Editor_SuggestionsPopupWindow$clipVertically(int ), 0, this, n);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_SuggestionsPopupWindow$hide(), 0, this);
        }

        private boolean updateSuggestions() {
            return (boolean)InvokeDynamicSupport.bootstrap("updateSuggestions", $$robo$$android_widget_Editor_SuggestionsPopupWindow$updateSuggestions(), 0, this);
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int n, int n2) {
            InvokeDynamicSupport.bootstrap("highlightTextDifferences", $$robo$$android_widget_Editor_SuggestionsPopupWindow$highlightTextDifferences(android.widget.Editor$SuggestionsPopupWindow$SuggestionInfo int int ), 0, this, suggestionInfo, n, n2);
        }

        @Override
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_Editor_SuggestionsPopupWindow$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        public /* synthetic */ SuggestionsPopupWindow() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionsPopupWindow)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SuggestionsPopupWindow this$1;

            private void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$__constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
            }

            private final int $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$compare(SuggestionSpan span1, SuggestionSpan span2) {
                int flag2;
                int flag1 = span1.getFlags();
                if (flag1 != (flag2 = span2.getFlags())) {
                    boolean misspelled2;
                    boolean easy1 = (flag1 & 1) != 0;
                    boolean easy2 = (flag2 & 1) != 0;
                    boolean misspelled1 = (flag1 & 2) != 0;
                    boolean bl = misspelled2 = (flag2 & 2) != 0;
                    if (easy1 && !misspelled1) {
                        return -1;
                    }
                    if (easy2 && !misspelled2) {
                        return 1;
                    }
                    if (misspelled1) {
                        return -1;
                    }
                    if (misspelled2) {
                        return 1;
                    }
                }
                return (Integer)this.this$1.mSpansLengths.get(span1) - (Integer)this.this$1.mSpansLengths.get(span2);
            }

            private /* synthetic */ void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$__constructor__(SuggestionsPopupWindow x0, 1 x1) {
            }

            private void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$__constructor__(suggestionsPopupWindow);
            }

            private SuggestionSpanComparator(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.this$1 = suggestionsPopupWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$__constructor__(android.widget.Editor$SuggestionsPopupWindow ), 0, this, suggestionsPopupWindow);
            }

            @Override
            public int compare(SuggestionSpan suggestionSpan, SuggestionSpan suggestionSpan2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$compare(android.text.style.SuggestionSpan android.text.style.SuggestionSpan ), 0, this, suggestionSpan, suggestionSpan2);
            }

            private /* synthetic */ void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow, 1 var2_2) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionSpanComparator$__constructor__(suggestionsPopupWindow, var2_2);
            }

            public /* synthetic */ SuggestionSpanComparator() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionSpanComparator)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class SuggestionAdapter
        extends BaseAdapter
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private LayoutInflater mInflater;
            /* synthetic */ SuggestionsPopupWindow this$1;

            private void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$__constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.mInflater = (LayoutInflater)this.this$1.this$0.mTextView.getContext().getSystemService("layout_inflater");
            }

            private final int $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getCount() {
                return this.this$1.mNumberOfSuggestions;
            }

            private final Object $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getItem(int position) {
                return this.this$1.mSuggestionInfos[position];
            }

            private final long $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getItemId(int position) {
                return position;
            }

            private final View $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getView(int position, View convertView, ViewGroup parent) {
                TextView textView = (TextView)convertView;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(((Editor)this.this$1.this$0).mTextView.mTextEditSuggestionItemLayout, parent, false);
                }
                SuggestionInfo suggestionInfo = this.this$1.mSuggestionInfos[position];
                textView.setText(suggestionInfo.text);
                if (suggestionInfo.suggestionIndex == -1 || suggestionInfo.suggestionIndex == -2) {
                    textView.setBackgroundColor(0);
                } else {
                    textView.setBackgroundColor(-1);
                }
                return textView;
            }

            private /* synthetic */ void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$__constructor__(SuggestionsPopupWindow x0, 1 x1) {
            }

            private void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$__constructor__(suggestionsPopupWindow);
            }

            private SuggestionAdapter(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.this$1 = suggestionsPopupWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$__constructor__(android.widget.Editor$SuggestionsPopupWindow ), 0, this, suggestionsPopupWindow);
            }

            @Override
            public int getCount() {
                return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getCount(), 0, this);
            }

            @Override
            public Object getItem(int n) {
                return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getItem(int ), 0, this, n);
            }

            @Override
            public long getItemId(int n) {
                return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getItemId(int ), 0, this, n);
            }

            @Override
            public View getView(int n, View view, ViewGroup viewGroup) {
                return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
            }

            private /* synthetic */ void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow, 1 var2_2) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionAdapter$__constructor__(suggestionsPopupWindow, var2_2);
            }

            public /* synthetic */ SuggestionAdapter() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionAdapter)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class SuggestionInfo
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int suggestionStart;
            int suggestionEnd;
            SuggestionSpan suggestionSpan;
            int suggestionIndex;
            SpannableStringBuilder text;
            TextAppearanceSpan highlightSpan;
            /* synthetic */ SuggestionsPopupWindow this$1;

            private void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionInfo$__constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.text = new SpannableStringBuilder();
                this.highlightSpan = new TextAppearanceSpan(this.this$1.this$0.mTextView.getContext(), 16974104);
            }

            private /* synthetic */ void $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionInfo$__constructor__(SuggestionsPopupWindow x0, 1 x1) {
            }

            private void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionInfo$__constructor__(suggestionsPopupWindow);
            }

            private SuggestionInfo(SuggestionsPopupWindow suggestionsPopupWindow) {
                this.this$1 = suggestionsPopupWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionInfo$__constructor__(android.widget.Editor$SuggestionsPopupWindow ), 0, this, suggestionsPopupWindow);
            }

            private /* synthetic */ void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow, 1 var2_2) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_SuggestionInfo$__constructor__(suggestionsPopupWindow, var2_2);
            }

            public /* synthetic */ SuggestionInfo() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuggestionInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class CustomPopupWindow
        extends PopupWindow
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SuggestionsPopupWindow this$1;

            private void $$robo$$android_widget_Editor_SuggestionsPopupWindow_CustomPopupWindow$__constructor__(SuggestionsPopupWindow suggestionsPopupWindow, Context context, int defStyleAttr) {
            }

            private final void $$robo$$android_widget_Editor_SuggestionsPopupWindow_CustomPopupWindow$dismiss() {
                super.dismiss();
                this.this$1.this$0.getPositionListener().removeSubscriber(this.this$1);
                ((Spannable)this.this$1.this$0.mTextView.getText()).removeSpan(this.this$1.this$0.mSuggestionRangeSpan);
                this.this$1.this$0.mTextView.setCursorVisible(this.this$1.mCursorWasVisibleBeforeSuggestions);
                if (this.this$1.this$0.hasInsertionController()) {
                    this.this$1.this$0.getInsertionController().show();
                }
            }

            private void __constructor__(SuggestionsPopupWindow suggestionsPopupWindow, Context context, int n) {
                this.$$robo$$android_widget_Editor_SuggestionsPopupWindow_CustomPopupWindow$__constructor__(suggestionsPopupWindow, context, n);
            }

            public CustomPopupWindow(SuggestionsPopupWindow suggestionsPopupWindow, Context context, int n) {
                this.this$1 = suggestionsPopupWindow;
                super(context, null, n);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SuggestionsPopupWindow_CustomPopupWindow$__constructor__(android.widget.Editor$SuggestionsPopupWindow android.content.Context int ), 0, this, suggestionsPopupWindow, context, n);
            }

            @Override
            public void dismiss() {
                InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_Editor_SuggestionsPopupWindow_CustomPopupWindow$dismiss(), 0, this);
            }

            public /* synthetic */ CustomPopupWindow() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CustomPopupWindow)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected PopupWindow mPopupWindow;
        protected ViewGroup mContentView;
        int mPositionX;
        int mPositionY;
        /* synthetic */ Editor this$0;

        protected abstract void createPopupWindow();

        protected abstract void initContentView();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        protected abstract int clipVertically(int var1);

        private void $$robo$$android_widget_Editor_PinnedPopupWindow$__constructor__(Editor editor) {
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1002);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(wrapContent);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$show() {
            this.this$0.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = this.this$0.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$measureContent() {
            DisplayMetrics displayMetrics = this.this$0.mTextView.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$computeLocalPosition() {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int offset = this.getTextOffset();
            this.mPositionX = (int)(this.this$0.mTextView.getLayout().getPrimaryHorizontal(offset) - (float)width / 2.0f);
            this.mPositionX += this.this$0.mTextView.viewportToContentHorizontalOffset();
            int line = this.this$0.mTextView.getLayout().getLineForOffset(offset);
            this.mPositionY = this.getVerticalLocalPosition(line);
            this.mPositionY += this.this$0.mTextView.viewportToContentVerticalOffset();
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$updatePosition(int parentPositionX, int parentPositionY) {
            int positionX = parentPositionX + this.mPositionX;
            int positionY = parentPositionY + this.mPositionY;
            positionY = this.clipVertically(positionY);
            DisplayMetrics displayMetrics = this.this$0.mTextView.getResources().getDisplayMetrics();
            int width = this.mContentView.getMeasuredWidth();
            positionX = Math.min(displayMetrics.widthPixels - width, positionX);
            positionX = Math.max(0, positionX);
            if (this.isShowing()) {
                this.mPopupWindow.update(positionX, positionY, -1, -1);
            } else {
                this.mPopupWindow.showAtLocation(this.this$0.mTextView, 0, positionX, positionY);
            }
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$hide() {
            this.mPopupWindow.dismiss();
            this.this$0.getPositionListener().removeSubscriber(this);
        }

        private final void $$robo$$android_widget_Editor_PinnedPopupWindow$updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            if (this.isShowing() && this.this$0.isOffsetVisible(this.getTextOffset())) {
                if (parentScrolled) {
                    this.computeLocalPosition();
                }
                this.updatePosition(parentPositionX, parentPositionY);
            } else {
                this.hide();
            }
        }

        private final boolean $$robo$$android_widget_Editor_PinnedPopupWindow$isShowing() {
            return this.mPopupWindow.isShowing();
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_PinnedPopupWindow$__constructor__(editor);
        }

        public PinnedPopupWindow(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_PinnedPopupWindow$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Editor_PinnedPopupWindow$show(), 0, this);
        }

        protected void measureContent() {
            InvokeDynamicSupport.bootstrap("measureContent", $$robo$$android_widget_Editor_PinnedPopupWindow$measureContent(), 0, this);
        }

        private void computeLocalPosition() {
            InvokeDynamicSupport.bootstrap("computeLocalPosition", $$robo$$android_widget_Editor_PinnedPopupWindow$computeLocalPosition(), 0, this);
        }

        private void updatePosition(int n, int n2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_PinnedPopupWindow$updatePosition(int int ), 0, this, n, n2);
        }

        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_PinnedPopupWindow$hide(), 0, this);
        }

        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_PinnedPopupWindow$updatePosition(int int boolean boolean ), 0, this, n, n2, bl, bl2);
        }

        public boolean isShowing() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_Editor_PinnedPopupWindow$isShowing(), 0, this);
        }

        public /* synthetic */ PinnedPopupWindow() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PinnedPopupWindow)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int MAXIMUM_NUMBER_OF_LISTENERS = 7;
        private TextViewPositionListener[] mPositionListeners;
        private boolean[] mCanMove;
        private boolean mPositionHasChanged;
        private int mPositionX;
        private int mPositionY;
        private int mNumberOfListeners;
        private boolean mScrollHasChanged;
        int[] mTempCoords;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_PositionListener$__constructor__(Editor editor) {
            this.MAXIMUM_NUMBER_OF_LISTENERS = 7;
            this.mPositionListeners = new TextViewPositionListener[7];
            this.mCanMove = new boolean[7];
            this.mPositionHasChanged = true;
            this.mTempCoords = new int[2];
        }

        private final void $$robo$$android_widget_Editor_PositionListener$addSubscriber(TextViewPositionListener positionListener, boolean canMove) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                ViewTreeObserver vto = this.this$0.mTextView.getViewTreeObserver();
                vto.addOnPreDrawListener(this);
            }
            int emptySlotIndex = -1;
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener listener = this.mPositionListeners[i];
                if (listener == positionListener) {
                    return;
                }
                if (emptySlotIndex >= 0 || listener != null) continue;
                emptySlotIndex = i;
            }
            this.mPositionListeners[emptySlotIndex] = positionListener;
            this.mCanMove[emptySlotIndex] = canMove;
            ++this.mNumberOfListeners;
        }

        private final void $$robo$$android_widget_Editor_PositionListener$removeSubscriber(TextViewPositionListener positionListener) {
            for (int i = 0; i < 7; ++i) {
                if (this.mPositionListeners[i] != positionListener) continue;
                this.mPositionListeners[i] = null;
                --this.mNumberOfListeners;
                break;
            }
            if (this.mNumberOfListeners == 0) {
                ViewTreeObserver vto = this.this$0.mTextView.getViewTreeObserver();
                vto.removeOnPreDrawListener(this);
            }
        }

        private final int $$robo$$android_widget_Editor_PositionListener$getPositionX() {
            return this.mPositionX;
        }

        private final int $$robo$$android_widget_Editor_PositionListener$getPositionY() {
            return this.mPositionY;
        }

        private final boolean $$robo$$android_widget_Editor_PositionListener$onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener positionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (positionListener = this.mPositionListeners[i]) == null) continue;
                positionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        private final void $$robo$$android_widget_Editor_PositionListener$updatePosition() {
            this.this$0.mTextView.getLocationInWindow(this.mTempCoords);
            this.mPositionHasChanged = this.mTempCoords[0] != this.mPositionX || this.mTempCoords[1] != this.mPositionY;
            this.mPositionX = this.mTempCoords[0];
            this.mPositionY = this.mTempCoords[1];
        }

        private final void $$robo$$android_widget_Editor_PositionListener$onScrollChanged() {
            this.mScrollHasChanged = true;
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_PositionListener$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_PositionListener$__constructor__(editor);
        }

        private PositionListener(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_PositionListener$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        public void addSubscriber(TextViewPositionListener textViewPositionListener, boolean bl) {
            InvokeDynamicSupport.bootstrap("addSubscriber", $$robo$$android_widget_Editor_PositionListener$addSubscriber(android.widget.Editor$TextViewPositionListener boolean ), 0, this, textViewPositionListener, bl);
        }

        public void removeSubscriber(TextViewPositionListener textViewPositionListener) {
            InvokeDynamicSupport.bootstrap("removeSubscriber", $$robo$$android_widget_Editor_PositionListener$removeSubscriber(android.widget.Editor$TextViewPositionListener ), 0, this, textViewPositionListener);
        }

        public int getPositionX() {
            return (int)InvokeDynamicSupport.bootstrap("getPositionX", $$robo$$android_widget_Editor_PositionListener$getPositionX(), 0, this);
        }

        public int getPositionY() {
            return (int)InvokeDynamicSupport.bootstrap("getPositionY", $$robo$$android_widget_Editor_PositionListener$getPositionY(), 0, this);
        }

        @Override
        public boolean onPreDraw() {
            return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_widget_Editor_PositionListener$onPreDraw(), 0, this);
        }

        private void updatePosition() {
            InvokeDynamicSupport.bootstrap("updatePosition", $$robo$$android_widget_Editor_PositionListener$updatePosition(), 0, this);
        }

        public void onScrollChanged() {
            InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_widget_Editor_PositionListener$onScrollChanged(), 0, this);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_PositionListener$__constructor__(editor, var2_2);
        }

        public /* synthetic */ PositionListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PositionListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int POPUP_TEXT_LAYOUT = 17367254;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;
        private EasyEditDeleteListener mOnDeleteListener;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_EasyEditPopupWindow$__constructor__(Editor editor) {
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$createPopupWindow() {
            this.mPopupWindow = new PopupWindow(this.this$0.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$initContentView() {
            LinearLayout linearLayout = new LinearLayout(this.this$0.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303299);
            LayoutInflater inflater = (LayoutInflater)this.this$0.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)inflater.inflate(17367254, null);
            this.mDeleteTextView.setLayoutParams(wrapContent);
            this.mDeleteTextView.setText(17040466);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$setEasyEditSpan(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$setOnDeleteListener(EasyEditDeleteListener listener) {
            this.mOnDeleteListener = listener;
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$onClick(View view) {
            if (view == this.mDeleteTextView && this.mEasyEditSpan != null && this.mEasyEditSpan.isDeleteEnabled() && this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onDeleteClick(this.mEasyEditSpan);
            }
        }

        private final void $$robo$$android_widget_Editor_EasyEditPopupWindow$hide() {
            if (this.mEasyEditSpan != null) {
                this.mEasyEditSpan.setDeleteEnabled(false);
            }
            this.mOnDeleteListener = null;
            super.hide();
        }

        private final int $$robo$$android_widget_Editor_EasyEditPopupWindow$getTextOffset() {
            Editable editable = (Editable)this.this$0.mTextView.getText();
            return editable.getSpanEnd(this.mEasyEditSpan);
        }

        private final int $$robo$$android_widget_Editor_EasyEditPopupWindow$getVerticalLocalPosition(int line) {
            return this.this$0.mTextView.getLayout().getLineBottom(line);
        }

        private final int $$robo$$android_widget_Editor_EasyEditPopupWindow$clipVertically(int positionY) {
            return positionY;
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_EasyEditPopupWindow$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_EasyEditPopupWindow$__constructor__(editor);
        }

        private EasyEditPopupWindow(Editor editor) {
            this.this$0 = editor;
            super(editor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_EasyEditPopupWindow$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        protected void createPopupWindow() {
            InvokeDynamicSupport.bootstrap("createPopupWindow", $$robo$$android_widget_Editor_EasyEditPopupWindow$createPopupWindow(), 0, this);
        }

        @Override
        protected void initContentView() {
            InvokeDynamicSupport.bootstrap("initContentView", $$robo$$android_widget_Editor_EasyEditPopupWindow$initContentView(), 0, this);
        }

        public void setEasyEditSpan(EasyEditSpan easyEditSpan) {
            InvokeDynamicSupport.bootstrap("setEasyEditSpan", $$robo$$android_widget_Editor_EasyEditPopupWindow$setEasyEditSpan(android.text.style.EasyEditSpan ), 0, this, easyEditSpan);
        }

        private void setOnDeleteListener(EasyEditDeleteListener easyEditDeleteListener) {
            InvokeDynamicSupport.bootstrap("setOnDeleteListener", $$robo$$android_widget_Editor_EasyEditPopupWindow$setOnDeleteListener(android.widget.Editor$EasyEditDeleteListener ), 0, this, easyEditDeleteListener);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_Editor_EasyEditPopupWindow$onClick(android.view.View ), 0, this, view);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_EasyEditPopupWindow$hide(), 0, this);
        }

        @Override
        protected int getTextOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getTextOffset", $$robo$$android_widget_Editor_EasyEditPopupWindow$getTextOffset(), 0, this);
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalLocalPosition", $$robo$$android_widget_Editor_EasyEditPopupWindow$getVerticalLocalPosition(int ), 0, this, n);
        }

        @Override
        protected int clipVertically(int n) {
            return (int)InvokeDynamicSupport.bootstrap("clipVertically", $$robo$$android_widget_Editor_EasyEditPopupWindow$clipVertically(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_EasyEditPopupWindow$__constructor__(editor, var2_2);
        }

        public /* synthetic */ EasyEditPopupWindow() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EasyEditPopupWindow)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface EasyEditDeleteListener
    extends InstrumentedInterface {
        public void onDeleteClick(EasyEditSpan var1);
    }

    public class SpanController
    implements SpanWatcher,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DISPLAY_TIMEOUT_MS = 3000;
        private EasyEditPopupWindow mPopupWindow;
        private Runnable mHidePopup;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_SpanController$__constructor__(Editor editor) {
        }

        private final boolean $$robo$$android_widget_Editor_SpanController$isNonIntermediateSelectionSpan(Spannable text, Object span) {
            return (Selection.SELECTION_START == span || Selection.SELECTION_END == span) && (text.getSpanFlags(span) & 0x200) == 0;
        }

        private final void $$robo$$android_widget_Editor_SpanController$onSpanAdded(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                this.this$0.sendUpdateSelection();
            } else if (span instanceof EasyEditSpan) {
                if (this.mPopupWindow == null) {
                    this.mPopupWindow = new EasyEditPopupWindow(this.this$0);
                    this.mHidePopup = new Runnable(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ SpanController this$1;

                        private void $$robo$$android_widget_Editor_SpanController_1$__constructor__(SpanController spanController) {
                        }

                        private final void $$robo$$android_widget_Editor_SpanController_1$run() {
                            this.this$1.hide();
                        }

                        private void __constructor__(SpanController spanController) {
                            this.$$robo$$android_widget_Editor_SpanController_1$__constructor__(spanController);
                        }
                        {
                            this.this$1 = spanController;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SpanController_1$__constructor__(android.widget.Editor$SpanController ), 0, this, spanController);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Editor_SpanController_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                }
                if (this.mPopupWindow.mEasyEditSpan != null) {
                    this.mPopupWindow.mEasyEditSpan.setDeleteEnabled(false);
                }
                this.mPopupWindow.setEasyEditSpan((EasyEditSpan)span);
                this.mPopupWindow.setOnDeleteListener(new EasyEditDeleteListener(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ SpanController this$1;

                    private void $$robo$$android_widget_Editor_SpanController_2$__constructor__(SpanController spanController) {
                    }

                    private final void $$robo$$android_widget_Editor_SpanController_2$onDeleteClick(EasyEditSpan span) {
                        Editable editable = (Editable)this.this$1.this$0.mTextView.getText();
                        int start = editable.getSpanStart(span);
                        int end = editable.getSpanEnd(span);
                        if (start >= 0 && end >= 0) {
                            this.this$1.sendEasySpanNotification(1, span);
                            this.this$1.this$0.mTextView.deleteText_internal(start, end);
                        }
                        editable.removeSpan(span);
                    }

                    private void __constructor__(SpanController spanController) {
                        this.$$robo$$android_widget_Editor_SpanController_2$__constructor__(spanController);
                    }
                    {
                        this.this$1 = spanController;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SpanController_2$__constructor__(android.widget.Editor$SpanController ), 0, this, spanController);
                    }

                    @Override
                    public void onDeleteClick(EasyEditSpan easyEditSpan) {
                        InvokeDynamicSupport.bootstrap("onDeleteClick", $$robo$$android_widget_Editor_SpanController_2$onDeleteClick(android.text.style.EasyEditSpan ), 0, this, easyEditSpan);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                if (this.this$0.mTextView.getWindowVisibility() != 0) {
                    return;
                }
                if (this.this$0.mTextView.getLayout() == null) {
                    return;
                }
                if (this.this$0.extractedTextModeWillBeStarted()) {
                    return;
                }
                this.mPopupWindow.show();
                this.this$0.mTextView.removeCallbacks(this.mHidePopup);
                this.this$0.mTextView.postDelayed(this.mHidePopup, 3000L);
            }
        }

        private final void $$robo$$android_widget_Editor_SpanController$onSpanRemoved(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                this.this$0.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span == this.mPopupWindow.mEasyEditSpan) {
                this.hide();
            }
        }

        private final void $$robo$$android_widget_Editor_SpanController$onSpanChanged(Spannable text, Object span, int previousStart, int previousEnd, int newStart, int newEnd) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                this.this$0.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span instanceof EasyEditSpan) {
                EasyEditSpan easyEditSpan = (EasyEditSpan)span;
                this.sendEasySpanNotification(2, easyEditSpan);
                text.removeSpan(easyEditSpan);
            }
        }

        private final void $$robo$$android_widget_Editor_SpanController$hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                this.this$0.mTextView.removeCallbacks(this.mHidePopup);
            }
        }

        private final void $$robo$$android_widget_Editor_SpanController$sendEasySpanNotification(int textChangedType, EasyEditSpan span) {
            try {
                PendingIntent pendingIntent = span.getPendingIntent();
                if (pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("android.text.style.EXTRA_TEXT_CHANGED_TYPE", textChangedType);
                    pendingIntent.send(this.this$0.mTextView.getContext(), 0, intent);
                }
            }
            catch (PendingIntent.CanceledException e) {
                Log.w("Editor", "PendingIntent for notification cannot be sent", e);
            }
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_SpanController$__constructor__(editor);
        }

        SpanController(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_SpanController$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        private boolean isNonIntermediateSelectionSpan(Spannable spannable, Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("isNonIntermediateSelectionSpan", $$robo$$android_widget_Editor_SpanController$isNonIntermediateSelectionSpan(android.text.Spannable java.lang.Object ), 0, this, spannable, object);
        }

        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanAdded", $$robo$$android_widget_Editor_SpanController$onSpanAdded(android.text.Spannable java.lang.Object int int ), 0, this, spannable, object, n, n2);
        }

        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanRemoved", $$robo$$android_widget_Editor_SpanController$onSpanRemoved(android.text.Spannable java.lang.Object int int ), 0, this, spannable, object, n, n2);
        }

        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onSpanChanged", $$robo$$android_widget_Editor_SpanController$onSpanChanged(android.text.Spannable java.lang.Object int int int int ), 0, this, spannable, object, n, n2, n3, n4);
        }

        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Editor_SpanController$hide(), 0, this);
        }

        private void sendEasySpanNotification(int n, EasyEditSpan easyEditSpan) {
            InvokeDynamicSupport.bootstrap("sendEasySpanNotification", $$robo$$android_widget_Editor_SpanController$sendEasySpanNotification(int android.text.style.EasyEditSpan ), 0, this, n, easyEditSpan);
        }

        public /* synthetic */ SpanController() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpanController)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DragLocalState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public TextView sourceTextView;
        public int start;
        public int end;

        private void $$robo$$android_widget_Editor_DragLocalState$__constructor__(TextView sourceTextView, int start, int end) {
            this.sourceTextView = sourceTextView;
            this.start = start;
            this.end = end;
        }

        private void __constructor__(TextView textView, int n, int n2) {
            this.$$robo$$android_widget_Editor_DragLocalState$__constructor__(textView, n, n2);
        }

        public DragLocalState(TextView textView, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_DragLocalState$__constructor__(android.widget.TextView int int ), 0, this, textView, n, n2);
        }

        public /* synthetic */ DragLocalState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DragLocalState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class Blink
    extends Handler
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mCancelled;
        /* synthetic */ Editor this$0;

        private void $$robo$$android_widget_Editor_Blink$__constructor__(Editor editor) {
        }

        private final void $$robo$$android_widget_Editor_Blink$run() {
            if (this.mCancelled) {
                return;
            }
            this.removeCallbacks(this);
            if (this.this$0.shouldBlink()) {
                if (this.this$0.mTextView.getLayout() != null) {
                    this.this$0.mTextView.invalidateCursorPath();
                }
                this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            }
        }

        private final void $$robo$$android_widget_Editor_Blink$cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        private final void $$robo$$android_widget_Editor_Blink$uncancel() {
            this.mCancelled = false;
        }

        private /* synthetic */ void $$robo$$android_widget_Editor_Blink$__constructor__(Editor x0, 1 x1) {
        }

        private void __constructor__(Editor editor) {
            this.$$robo$$android_widget_Editor_Blink$__constructor__(editor);
        }

        private Blink(Editor editor) {
            this.this$0 = editor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_Blink$__constructor__(android.widget.Editor ), 0, this, editor);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_Editor_Blink$run(), 0, this);
        }

        void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_widget_Editor_Blink$cancel(), 0, this);
        }

        void uncancel() {
            InvokeDynamicSupport.bootstrap("uncancel", $$robo$$android_widget_Editor_Blink$uncancel(), 0, this);
        }

        private /* synthetic */ void __constructor__(Editor editor, 1 var2_2) {
            this.$$robo$$android_widget_Editor_Blink$__constructor__(editor, var2_2);
        }

        public /* synthetic */ Blink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Blink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface TextViewPositionListener
    extends InstrumentedInterface {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }

    private static class TextDisplayList
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderNode displayList;
        boolean isDirty;

        private void $$robo$$android_widget_Editor_TextDisplayList$__constructor__(String name) {
            this.isDirty = true;
            this.displayList = RenderNode.create(name, null);
        }

        private final boolean $$robo$$android_widget_Editor_TextDisplayList$needsRecord() {
            return this.isDirty || !this.displayList.isValid();
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_widget_Editor_TextDisplayList$__constructor__(string2);
        }

        public TextDisplayList(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Editor_TextDisplayList$__constructor__(java.lang.String ), 0, this, string2);
        }

        boolean needsRecord() {
            return (boolean)InvokeDynamicSupport.bootstrap("needsRecord", $$robo$$android_widget_Editor_TextDisplayList$needsRecord(), 0, this);
        }

        public /* synthetic */ TextDisplayList() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextDisplayList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

