/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class FrameLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DEFAULT_CHILD_GRAVITY = 0x800033;
    @ViewDebug.ExportedProperty(category="measurement")
    boolean mMeasureAllChildren;
    @ViewDebug.ExportedProperty(category="drawing")
    private Drawable mForeground;
    private ColorStateList mForegroundTintList;
    private PorterDuff.Mode mForegroundTintMode;
    private boolean mHasForegroundTint;
    private boolean mHasForegroundTintMode;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingTop;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingBottom;
    private Rect mSelfBounds;
    private Rect mOverlayBounds;
    @ViewDebug.ExportedProperty(category="drawing")
    private int mForegroundGravity;
    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean mForegroundInPadding;
    boolean mForegroundBoundsChanged;
    private ArrayList<View> mMatchParentChildren;

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context) {
        this.mMeasureAllChildren = false;
        this.mForegroundTintList = null;
        this.mForegroundTintMode = null;
        this.mHasForegroundTint = false;
        this.mHasForegroundTintMode = false;
        this.mForegroundPaddingLeft = 0;
        this.mForegroundPaddingTop = 0;
        this.mForegroundPaddingRight = 0;
        this.mForegroundPaddingBottom = 0;
        this.mSelfBounds = new Rect();
        this.mOverlayBounds = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
        this.mForegroundBoundsChanged = false;
        this.mMatchParentChildren = new ArrayList(1);
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_FrameLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mMeasureAllChildren = false;
        this.mForegroundTintList = null;
        this.mForegroundTintMode = null;
        this.mHasForegroundTint = false;
        this.mHasForegroundTintMode = false;
        this.mForegroundPaddingLeft = 0;
        this.mForegroundPaddingTop = 0;
        this.mForegroundPaddingRight = 0;
        this.mForegroundPaddingBottom = 0;
        this.mSelfBounds = new Rect();
        this.mOverlayBounds = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
        this.mForegroundBoundsChanged = false;
        this.mMatchParentChildren = new ArrayList(1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameLayout, defStyleAttr, defStyleRes);
        this.mForegroundGravity = a.getInt(2, this.mForegroundGravity);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setForeground(d);
        }
        if (a.getBoolean(1, false)) {
            this.setMeasureAllChildren(true);
        }
        if (a.hasValue(4)) {
            this.mForegroundTintMode = Drawable.parseTintMode(a.getInt(4, -1), this.mForegroundTintMode);
            this.mHasForegroundTintMode = true;
        }
        if (a.hasValue(3)) {
            this.mForegroundTintList = a.getColorStateList(3);
            this.mHasForegroundTint = true;
        }
        this.mForegroundInPadding = a.getBoolean(5, true);
        a.recycle();
        this.applyForegroundTint();
    }

    private final int $$robo$$android_widget_FrameLayout$getForegroundGravity() {
        return this.mForegroundGravity;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_FrameLayout$setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundGravity != foregroundGravity) {
            if ((foregroundGravity & 0x800007) == 0) {
                foregroundGravity |= 0x800003;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                if (this.mForeground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_FrameLayout$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mForeground != null) {
            this.mForeground.setVisible(visibility == 0, false);
        }
    }

    private final boolean $$robo$$android_widget_FrameLayout$verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mForeground;
    }

    private final void $$robo$$android_widget_FrameLayout$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_FrameLayout$drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    private final void $$robo$$android_widget_FrameLayout$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mForeground != null) {
            this.mForeground.setHotspot(x, y);
        }
    }

    private final LayoutParams $$robo$$android_widget_FrameLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    private final void $$robo$$android_widget_FrameLayout$setForeground(Drawable d) {
        if (this.mForeground != d) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = d;
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
            if (d != null) {
                Rect padding;
                this.setWillNotDraw(false);
                d.setCallback(this);
                d.setLayoutDirection(this.getLayoutDirection());
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                this.applyForegroundTint();
                if (this.mForegroundGravity == 119 && d.getPadding(padding = new Rect())) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    private final Drawable $$robo$$android_widget_FrameLayout$getForeground() {
        return this.mForeground;
    }

    private final void $$robo$$android_widget_FrameLayout$setForegroundTintList(ColorStateList tint) {
        this.mForegroundTintList = tint;
        this.mHasForegroundTint = true;
        this.applyForegroundTint();
    }

    private final ColorStateList $$robo$$android_widget_FrameLayout$getForegroundTintList() {
        return this.mForegroundTintList;
    }

    private final void $$robo$$android_widget_FrameLayout$setForegroundTintMode(PorterDuff.Mode tintMode) {
        this.mForegroundTintMode = tintMode;
        this.mHasForegroundTintMode = true;
        this.applyForegroundTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_FrameLayout$getForegroundTintMode() {
        return this.mForegroundTintMode;
    }

    private final void $$robo$$android_widget_FrameLayout$applyForegroundTint() {
        if (this.mForeground != null && (this.mHasForegroundTint || this.mHasForegroundTintMode)) {
            this.mForeground = this.mForeground.mutate();
            if (this.mHasForegroundTint) {
                this.mForeground.setTintList(this.mForegroundTintList);
            }
            if (this.mHasForegroundTintMode) {
                this.mForeground.setTintMode(this.mForegroundTintMode);
            }
        }
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingLeftWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.mPaddingLeft, this.mForegroundPaddingLeft) : this.mPaddingLeft + this.mForegroundPaddingLeft;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingRightWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.mPaddingRight, this.mForegroundPaddingRight) : this.mPaddingRight + this.mForegroundPaddingRight;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingTopWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.mPaddingTop, this.mForegroundPaddingTop) : this.mPaddingTop + this.mForegroundPaddingTop;
    }

    private final int $$robo$$android_widget_FrameLayout$getPaddingBottomWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.mPaddingBottom, this.mForegroundPaddingBottom) : this.mPaddingBottom + this.mForegroundPaddingBottom;
    }

    private final void $$robo$$android_widget_FrameLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode(widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode(heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = FrameLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
        maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), FrameLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View child = this.mMatchParentChildren.get(i);
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - lp.leftMargin - lp.rightMargin, 0x40000000) : FrameLayout.getChildMeasureSpec(widthMeasureSpec, this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + lp.leftMargin + lp.rightMargin, lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - lp.topMargin - lp.bottomMargin, 0x40000000) : FrameLayout.getChildMeasureSpec(heightMeasureSpec, this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + lp.topMargin + lp.bottomMargin, lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private final void $$robo$$android_widget_FrameLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    private final void $$robo$$android_widget_FrameLayout$layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        this.mForegroundBoundsChanged = true;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    if (!forceLeftGravity) {
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                }
                default: {
                    childLeft = parentLeft + lp.leftMargin;
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + lp.topMargin;
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - lp.bottomMargin;
                    break;
                }
                default: {
                    childTop = parentTop + lp.topMargin;
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    private final void $$robo$$android_widget_FrameLayout$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    private final void $$robo$$android_widget_FrameLayout$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect selfBounds = this.mSelfBounds;
                Rect overlayBounds = this.mOverlayBounds;
                int w = this.mRight - this.mLeft;
                int h = this.mBottom - this.mTop;
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.mPaddingLeft, this.mPaddingTop, w - this.mPaddingRight, h - this.mPaddingBottom);
                }
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mForegroundGravity, foreground.getIntrinsicWidth(), foreground.getIntrinsicHeight(), selfBounds, overlayBounds, layoutDirection);
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    private final boolean $$robo$$android_widget_FrameLayout$gatherTransparentRegion(Region region) {
        boolean opaque = super.gatherTransparentRegion(region);
        if (region != null && this.mForeground != null) {
            this.applyDrawableToTransparentRegion(this.mForeground, region);
        }
        return opaque;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_FrameLayout$setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    @Deprecated
    private final boolean $$robo$$android_widget_FrameLayout$getConsiderGoneChildrenWhenMeasuring() {
        return this.getMeasureAllChildren();
    }

    private final boolean $$robo$$android_widget_FrameLayout$getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    private final LayoutParams $$robo$$android_widget_FrameLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final boolean $$robo$$android_widget_FrameLayout$shouldDelayChildPressedState() {
        return false;
    }

    private final boolean $$robo$$android_widget_FrameLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_FrameLayout$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final void $$robo$$android_widget_FrameLayout$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(FrameLayout.class.getName());
    }

    private final void $$robo$$android_widget_FrameLayout$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(FrameLayout.class.getName());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context);
    }

    public FrameLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet);
    }

    public FrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet, n);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_FrameLayout$__constructor__(context, attributeSet, n, n2);
    }

    public FrameLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public int getForegroundGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getForegroundGravity", $$robo$$android_widget_FrameLayout$getForegroundGravity(), 0, this);
    }

    @RemotableViewMethod
    public void setForegroundGravity(int n) {
        InvokeDynamicSupport.bootstrap("setForegroundGravity", $$robo$$android_widget_FrameLayout$setForegroundGravity(int ), 0, this, n);
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_widget_FrameLayout$setVisibility(int ), 0, this, n);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_FrameLayout$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_FrameLayout$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_FrameLayout$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_FrameLayout$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_FrameLayout$generateDefaultLayoutParams(), 0, this);
    }

    public void setForeground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setForeground", $$robo$$android_widget_FrameLayout$setForeground(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getForeground() {
        return InvokeDynamicSupport.bootstrap("getForeground", $$robo$$android_widget_FrameLayout$getForeground(), 0, this);
    }

    public void setForegroundTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setForegroundTintList", $$robo$$android_widget_FrameLayout$setForegroundTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getForegroundTintList() {
        return InvokeDynamicSupport.bootstrap("getForegroundTintList", $$robo$$android_widget_FrameLayout$getForegroundTintList(), 0, this);
    }

    public void setForegroundTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setForegroundTintMode", $$robo$$android_widget_FrameLayout$setForegroundTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getForegroundTintMode() {
        return InvokeDynamicSupport.bootstrap("getForegroundTintMode", $$robo$$android_widget_FrameLayout$getForegroundTintMode(), 0, this);
    }

    private void applyForegroundTint() {
        InvokeDynamicSupport.bootstrap("applyForegroundTint", $$robo$$android_widget_FrameLayout$applyForegroundTint(), 0, this);
    }

    int getPaddingLeftWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingLeftWithForeground", $$robo$$android_widget_FrameLayout$getPaddingLeftWithForeground(), 0, this);
    }

    int getPaddingRightWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingRightWithForeground", $$robo$$android_widget_FrameLayout$getPaddingRightWithForeground(), 0, this);
    }

    private int getPaddingTopWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingTopWithForeground", $$robo$$android_widget_FrameLayout$getPaddingTopWithForeground(), 0, this);
    }

    private int getPaddingBottomWithForeground() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingBottomWithForeground", $$robo$$android_widget_FrameLayout$getPaddingBottomWithForeground(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_FrameLayout$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_FrameLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    void layoutChildren(int n, int n2, int n3, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_FrameLayout$layoutChildren(int int int int boolean ), 0, this, n, n2, n3, n4, bl);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_FrameLayout$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_FrameLayout$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$android_widget_FrameLayout$gatherTransparentRegion(android.graphics.Region ), 0, this, region);
    }

    @RemotableViewMethod
    public void setMeasureAllChildren(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMeasureAllChildren", $$robo$$android_widget_FrameLayout$setMeasureAllChildren(boolean ), 0, this, bl);
    }

    @Deprecated
    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return (boolean)InvokeDynamicSupport.bootstrap("getConsiderGoneChildrenWhenMeasuring", $$robo$$android_widget_FrameLayout$getConsiderGoneChildrenWhenMeasuring(), 0, this);
    }

    public boolean getMeasureAllChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMeasureAllChildren", $$robo$$android_widget_FrameLayout$getMeasureAllChildren(), 0, this);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_FrameLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_FrameLayout$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_FrameLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_FrameLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_FrameLayout$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_FrameLayout$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public /* synthetic */ FrameLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int gravity;

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.gravity = -1;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FrameLayout_Layout);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int width, int height) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int width, int height, int gravity) {
            this.gravity = -1;
            this.gravity = gravity;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.gravity = -1;
            this.gravity = source.gravity;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(n, n2, n3);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_FrameLayout_LayoutParams$__constructor__(android.widget.FrameLayout$LayoutParams ), 0, this, layoutParams);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

