/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class ImageView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Uri mUri;
    private int mResource;
    private Matrix mMatrix;
    private ScaleType mScaleType;
    private boolean mHaveFrame;
    private boolean mAdjustViewBounds;
    private int mMaxWidth;
    private int mMaxHeight;
    private ColorFilter mColorFilter;
    private boolean mHasColorFilter;
    private Xfermode mXfermode;
    private int mAlpha;
    private int mViewAlphaScale;
    private boolean mColorMod;
    private Drawable mDrawable;
    private ColorStateList mDrawableTintList;
    private PorterDuff.Mode mDrawableTintMode;
    private boolean mHasDrawableTint;
    private boolean mHasDrawableTintMode;
    private int[] mState;
    private boolean mMergeState;
    private int mLevel;
    private int mDrawableWidth;
    private int mDrawableHeight;
    private Matrix mDrawMatrix;
    private RectF mTempSrc;
    private RectF mTempDst;
    private boolean mCropToPadding;
    private int mBaseline;
    private boolean mBaselineAlignBottom;
    private boolean mAdjustViewBoundsCompat;
    private static ScaleType[] sScaleTypeArray;
    private static Matrix.ScaleToFit[] sS2FArray;

    private void $$robo$$android_widget_ImageView$__constructor__(Context context) {
        this.mResource = 0;
        this.mHaveFrame = false;
        this.mAdjustViewBounds = false;
        this.mMaxWidth = Integer.MAX_VALUE;
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mColorFilter = null;
        this.mHasColorFilter = false;
        this.mAlpha = 255;
        this.mViewAlphaScale = 256;
        this.mColorMod = false;
        this.mDrawable = null;
        this.mDrawableTintList = null;
        this.mDrawableTintMode = null;
        this.mHasDrawableTint = false;
        this.mHasDrawableTintMode = false;
        this.mState = null;
        this.mMergeState = false;
        this.mLevel = 0;
        this.mDrawMatrix = null;
        this.mTempSrc = new RectF();
        this.mTempDst = new RectF();
        this.mBaseline = -1;
        this.mBaselineAlignBottom = false;
        this.mAdjustViewBoundsCompat = false;
        this.initImageView();
    }

    private void $$robo$$android_widget_ImageView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ImageView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ImageView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mResource = 0;
        this.mHaveFrame = false;
        this.mAdjustViewBounds = false;
        this.mMaxWidth = Integer.MAX_VALUE;
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mColorFilter = null;
        this.mHasColorFilter = false;
        this.mAlpha = 255;
        this.mViewAlphaScale = 256;
        this.mColorMod = false;
        this.mDrawable = null;
        this.mDrawableTintList = null;
        this.mDrawableTintMode = null;
        this.mHasDrawableTint = false;
        this.mHasDrawableTintMode = false;
        this.mState = null;
        this.mMergeState = false;
        this.mLevel = 0;
        this.mDrawMatrix = null;
        this.mTempSrc = new RectF();
        this.mTempDst = new RectF();
        this.mBaseline = -1;
        this.mBaselineAlignBottom = false;
        this.mAdjustViewBoundsCompat = false;
        this.initImageView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageView, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setImageDrawable(d);
        }
        this.mBaselineAlignBottom = a.getBoolean(6, false);
        this.mBaseline = a.getDimensionPixelSize(8, -1);
        this.setAdjustViewBounds(a.getBoolean(2, false));
        this.setMaxWidth(a.getDimensionPixelSize(3, Integer.MAX_VALUE));
        this.setMaxHeight(a.getDimensionPixelSize(4, Integer.MAX_VALUE));
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setScaleType(sScaleTypeArray[index]);
        }
        if (a.hasValue(5)) {
            this.mDrawableTintList = a.getColorStateList(5);
            this.mHasDrawableTint = true;
            this.mDrawableTintMode = PorterDuff.Mode.SRC_ATOP;
            this.mHasDrawableTintMode = true;
        }
        if (a.hasValue(9)) {
            this.mDrawableTintMode = Drawable.parseTintMode(a.getInt(9, -1), this.mDrawableTintMode);
            this.mHasDrawableTintMode = true;
        }
        this.applyImageTint();
        int alpha = a.getInt(10, 255);
        if (alpha != 255) {
            this.setAlpha(alpha);
        }
        this.mCropToPadding = a.getBoolean(7, false);
        a.recycle();
    }

    private final void $$robo$$android_widget_ImageView$initImageView() {
        this.mMatrix = new Matrix();
        this.mScaleType = ScaleType.FIT_CENTER;
        this.mAdjustViewBoundsCompat = this.mContext.getApplicationInfo().targetSdkVersion <= 17;
    }

    private final boolean $$robo$$android_widget_ImageView$verifyDrawable(Drawable dr) {
        return this.mDrawable == dr || super.verifyDrawable(dr);
    }

    private final void $$robo$$android_widget_ImageView$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mDrawable != null) {
            this.mDrawable.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_widget_ImageView$invalidateDrawable(Drawable dr) {
        if (dr == this.mDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    private final boolean $$robo$$android_widget_ImageView$hasOverlappingRendering() {
        return this.getBackground() != null && this.getBackground().getCurrent() != null;
    }

    private final void $$robo$$android_widget_ImageView$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        CharSequence contentDescription = this.getContentDescription();
        if (!TextUtils.isEmpty(contentDescription)) {
            event.getText().add(contentDescription);
        }
    }

    private final boolean $$robo$$android_widget_ImageView$getAdjustViewBounds() {
        return this.mAdjustViewBounds;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setAdjustViewBounds(boolean adjustViewBounds) {
        this.mAdjustViewBounds = adjustViewBounds;
        if (adjustViewBounds) {
            this.setScaleType(ScaleType.FIT_CENTER);
        }
    }

    private final int $$robo$$android_widget_ImageView$getMaxWidth() {
        return this.mMaxWidth;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    private final int $$robo$$android_widget_ImageView$getMaxHeight() {
        return this.mMaxHeight;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
    }

    private final Drawable $$robo$$android_widget_ImageView$getDrawable() {
        return this.mDrawable;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setImageResource(int resId) {
        if (this.mUri != null || this.mResource != resId) {
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.updateDrawable(null);
            this.mResource = resId;
            this.mUri = null;
            this.resolveUri();
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setImageURI(Uri uri) {
        if (this.mResource != 0 || this.mUri != uri && (uri == null || this.mUri == null || !uri.equals(this.mUri))) {
            this.updateDrawable(null);
            this.mResource = 0;
            this.mUri = uri;
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.resolveUri();
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_ImageView$setImageDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.mResource = 0;
            this.mUri = null;
            int oldWidth = this.mDrawableWidth;
            int oldHeight = this.mDrawableHeight;
            this.updateDrawable(drawable2);
            if (oldWidth != this.mDrawableWidth || oldHeight != this.mDrawableHeight) {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_ImageView$setImageTintList(ColorStateList tint) {
        this.mDrawableTintList = tint;
        this.mHasDrawableTint = true;
        this.applyImageTint();
    }

    private final ColorStateList $$robo$$android_widget_ImageView$getImageTintList() {
        return this.mDrawableTintList;
    }

    private final void $$robo$$android_widget_ImageView$setImageTintMode(PorterDuff.Mode tintMode) {
        this.mDrawableTintMode = tintMode;
        this.mHasDrawableTintMode = true;
        this.applyImageTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_ImageView$getImageTintMode() {
        return this.mDrawableTintMode;
    }

    private final void $$robo$$android_widget_ImageView$applyImageTint() {
        if (this.mDrawable != null && (this.mHasDrawableTint || this.mHasDrawableTintMode)) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasDrawableTint) {
                this.mDrawable.setTintList(this.mDrawableTintList);
            }
            if (this.mHasDrawableTintMode) {
                this.mDrawable.setTintMode(this.mDrawableTintMode);
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setImageBitmap(Bitmap bm) {
        this.setImageDrawable(new BitmapDrawable(this.mContext.getResources(), bm));
    }

    private final void $$robo$$android_widget_ImageView$setImageState(int[] state, boolean merge) {
        this.mState = state;
        this.mMergeState = merge;
        if (this.mDrawable != null) {
            this.refreshDrawableState();
            this.resizeFromDrawable();
        }
    }

    private final void $$robo$$android_widget_ImageView$setSelected(boolean selected) {
        super.setSelected(selected);
        this.resizeFromDrawable();
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setImageLevel(int level) {
        this.mLevel = level;
        if (this.mDrawable != null) {
            this.mDrawable.setLevel(level);
            this.resizeFromDrawable();
        }
    }

    private final void $$robo$$android_widget_ImageView$setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.setWillNotCacheDrawing(this.mScaleType == ScaleType.CENTER);
            this.requestLayout();
            this.invalidate();
        }
    }

    private final ScaleType $$robo$$android_widget_ImageView$getScaleType() {
        return this.mScaleType;
    }

    private final Matrix $$robo$$android_widget_ImageView$getImageMatrix() {
        if (this.mDrawMatrix == null) {
            return new Matrix(Matrix.IDENTITY_MATRIX);
        }
        return this.mDrawMatrix;
    }

    private final void $$robo$$android_widget_ImageView$setImageMatrix(Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix == null && !this.mMatrix.isIdentity() || matrix != null && !this.mMatrix.equals(matrix)) {
            this.mMatrix.set(matrix);
            this.configureBounds();
            this.invalidate();
        }
    }

    private final boolean $$robo$$android_widget_ImageView$getCropToPadding() {
        return this.mCropToPadding;
    }

    private final void $$robo$$android_widget_ImageView$setCropToPadding(boolean cropToPadding) {
        if (this.mCropToPadding != cropToPadding) {
            this.mCropToPadding = cropToPadding;
            this.requestLayout();
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ImageView$resolveUri() {
        if (this.mDrawable != null) {
            return;
        }
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = this.mContext.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w("ImageView", "Unable to find resource: " + this.mResource, e);
                this.mUri = null;
            }
        } else if (this.mUri != null) {
            String scheme = this.mUri.getScheme();
            if ("android.resource".equals(scheme)) {
                try {
                    ContentResolver.OpenResourceIdResult r = this.mContext.getContentResolver().getResourceId(this.mUri);
                    d = r.r.getDrawable(r.id, this.mContext.getTheme());
                }
                catch (Exception e) {
                    Log.w("ImageView", "Unable to open content: " + this.mUri, e);
                }
            } else if ("content".equals(scheme) || "file".equals(scheme)) {
                InputStream stream = null;
                try {
                    stream = this.mContext.getContentResolver().openInputStream(this.mUri);
                    d = Drawable.createFromStream(stream, null);
                }
                catch (Exception e) {
                    Log.w("ImageView", "Unable to open content: " + this.mUri, e);
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            Log.w("ImageView", "Unable to close content: " + this.mUri, e);
                        }
                    }
                }
            } else {
                d = Drawable.createFromPath(this.mUri.toString());
            }
            if (d == null) {
                System.out.println("resolveUri failed on bad bitmap uri: " + this.mUri);
                this.mUri = null;
            }
        } else {
            return;
        }
        this.updateDrawable(d);
    }

    private final int[] $$robo$$android_widget_ImageView$onCreateDrawableState(int extraSpace) {
        if (this.mState == null) {
            return super.onCreateDrawableState(extraSpace);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        return ImageView.mergeDrawableStates(super.onCreateDrawableState(extraSpace + this.mState.length), this.mState);
    }

    private final void $$robo$$android_widget_ImageView$updateDrawable(Drawable d) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
        }
        this.mDrawable = d;
        if (d != null) {
            d.setCallback(this);
            d.setLayoutDirection(this.getLayoutDirection());
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            d.setVisible(this.getVisibility() == 0, true);
            d.setLevel(this.mLevel);
            this.mDrawableWidth = d.getIntrinsicWidth();
            this.mDrawableHeight = d.getIntrinsicHeight();
            this.applyImageTint();
            this.applyColorMod();
            this.configureBounds();
        } else {
            this.mDrawableHeight = -1;
            this.mDrawableWidth = -1;
        }
    }

    private final void $$robo$$android_widget_ImageView$resizeFromDrawable() {
        Drawable d = this.mDrawable;
        if (d != null) {
            int h;
            int w = d.getIntrinsicWidth();
            if (w < 0) {
                w = this.mDrawableWidth;
            }
            if ((h = d.getIntrinsicHeight()) < 0) {
                h = this.mDrawableHeight;
            }
            if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                this.mDrawableWidth = w;
                this.mDrawableHeight = h;
                this.requestLayout();
            }
        }
    }

    private final void $$robo$$android_widget_ImageView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (this.mDrawable != null) {
            this.mDrawable.setLayoutDirection(layoutDirection);
        }
    }

    private static final Matrix.ScaleToFit $$robo$$android_widget_ImageView$scaleTypeToScaleToFit(ScaleType st) {
        return sS2FArray[st.nativeInt - 1];
    }

    private final void $$robo$$android_widget_ImageView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthSize;
        int w;
        int h;
        this.resolveUri();
        float desiredAspect = 0.0f;
        boolean resizeWidth = false;
        boolean resizeHeight = false;
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (this.mDrawable == null) {
            this.mDrawableWidth = -1;
            this.mDrawableHeight = -1;
            h = 0;
            w = 0;
        } else {
            w = this.mDrawableWidth;
            h = this.mDrawableHeight;
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            if (this.mAdjustViewBounds) {
                resizeWidth = widthSpecMode != 0x40000000;
                resizeHeight = heightSpecMode != 0x40000000;
                desiredAspect = (float)w / (float)h;
            }
        }
        int pleft = this.mPaddingLeft;
        int pright = this.mPaddingRight;
        int ptop = this.mPaddingTop;
        int pbottom = this.mPaddingBottom;
        if (resizeWidth || resizeHeight) {
            float actualAspect;
            widthSize = this.resolveAdjustedSize(w + pleft + pright, this.mMaxWidth, widthMeasureSpec);
            heightSize = this.resolveAdjustedSize(h + ptop + pbottom, this.mMaxHeight, heightMeasureSpec);
            if (desiredAspect != 0.0f && (double)Math.abs((actualAspect = (float)(widthSize - pleft - pright) / (float)(heightSize - ptop - pbottom)) - desiredAspect) > 1.0E-7) {
                boolean done = false;
                if (resizeWidth) {
                    int newWidth = (int)(desiredAspect * (float)(heightSize - ptop - pbottom)) + pleft + pright;
                    if (!resizeHeight && !this.mAdjustViewBoundsCompat) {
                        widthSize = this.resolveAdjustedSize(newWidth, this.mMaxWidth, widthMeasureSpec);
                    }
                    if (newWidth <= widthSize) {
                        widthSize = newWidth;
                        done = true;
                    }
                }
                if (!done && resizeHeight) {
                    int newHeight = (int)((float)(widthSize - pleft - pright) / desiredAspect) + ptop + pbottom;
                    if (!resizeWidth && !this.mAdjustViewBoundsCompat) {
                        heightSize = this.resolveAdjustedSize(newHeight, this.mMaxHeight, heightMeasureSpec);
                    }
                    if (newHeight <= heightSize) {
                        heightSize = newHeight;
                    }
                }
            }
        } else {
            w += pleft + pright;
            h += ptop + pbottom;
            w = Math.max(w, this.getSuggestedMinimumWidth());
            h = Math.max(h, this.getSuggestedMinimumHeight());
            widthSize = ImageView.resolveSizeAndState(w, widthMeasureSpec, 0);
            heightSize = ImageView.resolveSizeAndState(h, heightMeasureSpec, 0);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private final int $$robo$$android_widget_ImageView$resolveAdjustedSize(int desiredSize, int maxSize, int measureSpec) {
        int result = desiredSize;
        int specMode = View.MeasureSpec.getMode(measureSpec);
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = Math.min(desiredSize, maxSize);
                break;
            }
            case -2147483648: {
                result = Math.min(Math.min(desiredSize, specSize), maxSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    private final boolean $$robo$$android_widget_ImageView$setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        this.mHaveFrame = true;
        this.configureBounds();
        return changed;
    }

    private final void $$robo$$android_widget_ImageView$configureBounds() {
        boolean fits;
        if (this.mDrawable == null || !this.mHaveFrame) {
            return;
        }
        int dwidth = this.mDrawableWidth;
        int dheight = this.mDrawableHeight;
        int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (dwidth <= 0 || dheight <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, dwidth, dheight);
            if (ScaleType.MATRIX == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix.isIdentity() ? null : this.mMatrix;
            } else if (fits) {
                this.mDrawMatrix = null;
            } else if (ScaleType.CENTER == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setTranslate((int)((float)(vwidth - dwidth) * 0.5f + 0.5f), (int)((float)(vheight - dheight) * 0.5f + 0.5f));
            } else if (ScaleType.CENTER_CROP == this.mScaleType) {
                float scale;
                this.mDrawMatrix = this.mMatrix;
                float dx = 0.0f;
                float dy = 0.0f;
                if (dwidth * vheight > vwidth * dheight) {
                    scale = (float)vheight / (float)dheight;
                    dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                } else {
                    scale = (float)vwidth / (float)dwidth;
                    dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                }
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate((int)(dx + 0.5f), (int)(dy + 0.5f));
            } else if (ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
                float dx = (int)(((float)vwidth - (float)dwidth * scale) * 0.5f + 0.5f);
                float dy = (int)(((float)vheight - (float)dheight * scale) * 0.5f + 0.5f);
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(dx, dy);
            } else {
                this.mTempSrc.set(0.0f, 0.0f, dwidth, dheight);
                this.mTempDst.set(0.0f, 0.0f, vwidth, vheight);
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setRectToRect(this.mTempSrc, this.mTempDst, ImageView.scaleTypeToScaleToFit(this.mScaleType));
            }
        }
    }

    private final void $$robo$$android_widget_ImageView$drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    private final void $$robo$$android_widget_ImageView$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mDrawable != null) {
            this.mDrawable.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_widget_ImageView$animateTransform(Matrix matrix) {
        if (matrix == null) {
            this.mDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.mDrawable.setBounds(0, 0, this.mDrawableWidth, this.mDrawableHeight);
            if (this.mDrawMatrix == null) {
                this.mDrawMatrix = new Matrix();
            }
            this.mDrawMatrix.set(matrix);
        }
        this.invalidate();
    }

    private final void $$robo$$android_widget_ImageView$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            if (this.mCropToPadding) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            }
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    @ViewDebug.ExportedProperty(category="layout")
    private final int $$robo$$android_widget_ImageView$getBaseline() {
        if (this.mBaselineAlignBottom) {
            return this.getMeasuredHeight();
        }
        return this.mBaseline;
    }

    private final void $$robo$$android_widget_ImageView$setBaseline(int baseline) {
        if (this.mBaseline != baseline) {
            this.mBaseline = baseline;
            this.requestLayout();
        }
    }

    private final void $$robo$$android_widget_ImageView$setBaselineAlignBottom(boolean aligned) {
        if (this.mBaselineAlignBottom != aligned) {
            this.mBaselineAlignBottom = aligned;
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_ImageView$getBaselineAlignBottom() {
        return this.mBaselineAlignBottom;
    }

    private final void $$robo$$android_widget_ImageView$setColorFilter(int color2, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(color2, mode));
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setColorFilter(int color2) {
        this.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    private final void $$robo$$android_widget_ImageView$clearColorFilter() {
        this.setColorFilter(null);
    }

    private final void $$robo$$android_widget_ImageView$setXfermode(Xfermode mode) {
        if (this.mXfermode != mode) {
            this.mXfermode = mode;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    private final ColorFilter $$robo$$android_widget_ImageView$getColorFilter() {
        return this.mColorFilter;
    }

    private final void $$robo$$android_widget_ImageView$setColorFilter(ColorFilter cf) {
        if (this.mColorFilter != cf) {
            this.mColorFilter = cf;
            this.mHasColorFilter = true;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    private final int $$robo$$android_widget_ImageView$getImageAlpha() {
        return this.mAlpha;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setImageAlpha(int alpha) {
        this.setAlpha(alpha);
    }

    @Deprecated
    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setAlpha(int alpha) {
        if (this.mAlpha != (alpha &= 0xFF)) {
            this.mAlpha = alpha;
            this.mColorMod = true;
            this.applyColorMod();
            this.invalidate();
        }
    }

    private final void $$robo$$android_widget_ImageView$applyColorMod() {
        if (this.mDrawable != null && this.mColorMod) {
            this.mDrawable = this.mDrawable.mutate();
            if (this.mHasColorFilter) {
                this.mDrawable.setColorFilter(this.mColorFilter);
            }
            this.mDrawable.setXfermode(this.mXfermode);
            this.mDrawable.setAlpha(this.mAlpha * this.mViewAlphaScale >> 8);
        }
    }

    private final boolean $$robo$$android_widget_ImageView$isOpaque() {
        return super.isOpaque() || this.mDrawable != null && this.mXfermode == null && this.mDrawable.getOpacity() == -1 && this.mAlpha * this.mViewAlphaScale >> 8 == 255 && this.isFilledByImage();
    }

    private final boolean $$robo$$android_widget_ImageView$isFilledByImage() {
        if (this.mDrawable == null) {
            return false;
        }
        Rect bounds = this.mDrawable.getBounds();
        Matrix matrix = this.mDrawMatrix;
        if (matrix == null) {
            return bounds.left <= 0 && bounds.top <= 0 && bounds.right >= this.getWidth() && bounds.bottom >= this.getHeight();
        }
        if (matrix.rectStaysRect()) {
            RectF boundsSrc = this.mTempSrc;
            RectF boundsDst = this.mTempDst;
            boundsSrc.set(bounds);
            matrix.mapRect(boundsDst, boundsSrc);
            return boundsDst.left <= 0.0f && boundsDst.top <= 0.0f && boundsDst.right >= (float)this.getWidth() && boundsDst.bottom >= (float)this.getHeight();
        }
        return false;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ImageView$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mDrawable != null) {
            this.mDrawable.setVisible(visibility == 0, false);
        }
    }

    private final void $$robo$$android_widget_ImageView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDrawable != null) {
            this.mDrawable.setVisible(this.getVisibility() == 0, false);
        }
    }

    private final void $$robo$$android_widget_ImageView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDrawable != null) {
            this.mDrawable.setVisible(false, false);
        }
    }

    private final void $$robo$$android_widget_ImageView$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(ImageView.class.getName());
    }

    private final void $$robo$$android_widget_ImageView$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(ImageView.class.getName());
    }

    static void __staticInitializer__() {
        sScaleTypeArray = new ScaleType[]{ScaleType.MATRIX, ScaleType.FIT_XY, ScaleType.FIT_START, ScaleType.FIT_CENTER, ScaleType.FIT_END, ScaleType.CENTER, ScaleType.CENTER_CROP, ScaleType.CENTER_INSIDE};
        sS2FArray = new Matrix.ScaleToFit[]{Matrix.ScaleToFit.FILL, Matrix.ScaleToFit.START, Matrix.ScaleToFit.CENTER, Matrix.ScaleToFit.END};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ImageView$__constructor__(context);
    }

    public ImageView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ImageView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ImageView$__constructor__(context, attributeSet);
    }

    public ImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ImageView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ImageView$__constructor__(context, attributeSet, n);
    }

    public ImageView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ImageView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ImageView$__constructor__(context, attributeSet, n, n2);
    }

    public ImageView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ImageView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initImageView() {
        InvokeDynamicSupport.bootstrap("initImageView", $$robo$$android_widget_ImageView$initImageView(), 0, this);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_ImageView$verifyDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_ImageView$jumpDrawablesToCurrentState(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_widget_ImageView$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public boolean hasOverlappingRendering() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasOverlappingRendering", $$robo$$android_widget_ImageView$hasOverlappingRendering(), 0, this);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_ImageView$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    public boolean getAdjustViewBounds() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAdjustViewBounds", $$robo$$android_widget_ImageView$getAdjustViewBounds(), 0, this);
    }

    @RemotableViewMethod
    public void setAdjustViewBounds(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAdjustViewBounds", $$robo$$android_widget_ImageView$setAdjustViewBounds(boolean ), 0, this, bl);
    }

    public int getMaxWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxWidth", $$robo$$android_widget_ImageView$getMaxWidth(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxWidth(int n) {
        InvokeDynamicSupport.bootstrap("setMaxWidth", $$robo$$android_widget_ImageView$setMaxWidth(int ), 0, this, n);
    }

    public int getMaxHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxHeight", $$robo$$android_widget_ImageView$getMaxHeight(), 0, this);
    }

    @RemotableViewMethod
    public void setMaxHeight(int n) {
        InvokeDynamicSupport.bootstrap("setMaxHeight", $$robo$$android_widget_ImageView$setMaxHeight(int ), 0, this, n);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_widget_ImageView$getDrawable(), 0, this);
    }

    @RemotableViewMethod
    public void setImageResource(int n) {
        InvokeDynamicSupport.bootstrap("setImageResource", $$robo$$android_widget_ImageView$setImageResource(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setImageURI(Uri uri) {
        InvokeDynamicSupport.bootstrap("setImageURI", $$robo$$android_widget_ImageView$setImageURI(android.net.Uri ), 0, this, uri);
    }

    public void setImageDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setImageDrawable", $$robo$$android_widget_ImageView$setImageDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setImageTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setImageTintList", $$robo$$android_widget_ImageView$setImageTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public ColorStateList getImageTintList() {
        return InvokeDynamicSupport.bootstrap("getImageTintList", $$robo$$android_widget_ImageView$getImageTintList(), 0, this);
    }

    public void setImageTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setImageTintMode", $$robo$$android_widget_ImageView$setImageTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public PorterDuff.Mode getImageTintMode() {
        return InvokeDynamicSupport.bootstrap("getImageTintMode", $$robo$$android_widget_ImageView$getImageTintMode(), 0, this);
    }

    private void applyImageTint() {
        InvokeDynamicSupport.bootstrap("applyImageTint", $$robo$$android_widget_ImageView$applyImageTint(), 0, this);
    }

    @RemotableViewMethod
    public void setImageBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setImageBitmap", $$robo$$android_widget_ImageView$setImageBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void setImageState(int[] nArray, boolean bl) {
        InvokeDynamicSupport.bootstrap("setImageState", $$robo$$android_widget_ImageView$setImageState(int[] boolean ), 0, this, nArray, bl);
    }

    @Override
    public void setSelected(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelected", $$robo$$android_widget_ImageView$setSelected(boolean ), 0, this, bl);
    }

    @RemotableViewMethod
    public void setImageLevel(int n) {
        InvokeDynamicSupport.bootstrap("setImageLevel", $$robo$$android_widget_ImageView$setImageLevel(int ), 0, this, n);
    }

    public void setScaleType(ScaleType scaleType) {
        InvokeDynamicSupport.bootstrap("setScaleType", $$robo$$android_widget_ImageView$setScaleType(android.widget.ImageView$ScaleType ), 0, this, scaleType);
    }

    public ScaleType getScaleType() {
        return InvokeDynamicSupport.bootstrap("getScaleType", $$robo$$android_widget_ImageView$getScaleType(), 0, this);
    }

    public Matrix getImageMatrix() {
        return InvokeDynamicSupport.bootstrap("getImageMatrix", $$robo$$android_widget_ImageView$getImageMatrix(), 0, this);
    }

    public void setImageMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("setImageMatrix", $$robo$$android_widget_ImageView$setImageMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    public boolean getCropToPadding() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCropToPadding", $$robo$$android_widget_ImageView$getCropToPadding(), 0, this);
    }

    public void setCropToPadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCropToPadding", $$robo$$android_widget_ImageView$setCropToPadding(boolean ), 0, this, bl);
    }

    private void resolveUri() {
        InvokeDynamicSupport.bootstrap("resolveUri", $$robo$$android_widget_ImageView$resolveUri(), 0, this);
    }

    @Override
    public int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_ImageView$onCreateDrawableState(int ), 0, this, n);
    }

    private void updateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("updateDrawable", $$robo$$android_widget_ImageView$updateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void resizeFromDrawable() {
        InvokeDynamicSupport.bootstrap("resizeFromDrawable", $$robo$$android_widget_ImageView$resizeFromDrawable(), 0, this);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_ImageView$onRtlPropertiesChanged(int ), 0, this, n);
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType scaleType) {
        return InvokeDynamicSupport.bootstrapStatic("scaleTypeToScaleToFit", $$robo$$android_widget_ImageView$scaleTypeToScaleToFit(android.widget.ImageView$ScaleType ), 0, (ScaleType)scaleType);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_ImageView$onMeasure(int int ), 0, this, n, n2);
    }

    private int resolveAdjustedSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("resolveAdjustedSize", $$robo$$android_widget_ImageView$resolveAdjustedSize(int int int ), 0, this, n, n2, n3);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_widget_ImageView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    private void configureBounds() {
        InvokeDynamicSupport.bootstrap("configureBounds", $$robo$$android_widget_ImageView$configureBounds(), 0, this);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_ImageView$drawableStateChanged(), 0, this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_ImageView$drawableHotspotChanged(float float ), 0, this, f, f2);
    }

    public void animateTransform(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("animateTransform", $$robo$$android_widget_ImageView$animateTransform(android.graphics.Matrix ), 0, this, matrix);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_ImageView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_ImageView$getBaseline(), 0, this);
    }

    public void setBaseline(int n) {
        InvokeDynamicSupport.bootstrap("setBaseline", $$robo$$android_widget_ImageView$setBaseline(int ), 0, this, n);
    }

    public void setBaselineAlignBottom(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBaselineAlignBottom", $$robo$$android_widget_ImageView$setBaselineAlignBottom(boolean ), 0, this, bl);
    }

    public boolean getBaselineAlignBottom() {
        return (boolean)InvokeDynamicSupport.bootstrap("getBaselineAlignBottom", $$robo$$android_widget_ImageView$getBaselineAlignBottom(), 0, this);
    }

    public void setColorFilter(int n, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_widget_ImageView$setColorFilter(int android.graphics.PorterDuff$Mode ), 0, this, n, mode);
    }

    @RemotableViewMethod
    public void setColorFilter(int n) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_widget_ImageView$setColorFilter(int ), 0, this, n);
    }

    public void clearColorFilter() {
        InvokeDynamicSupport.bootstrap("clearColorFilter", $$robo$$android_widget_ImageView$clearColorFilter(), 0, this);
    }

    public void setXfermode(Xfermode xfermode) {
        InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$android_widget_ImageView$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_widget_ImageView$getColorFilter(), 0, this);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_widget_ImageView$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    public int getImageAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getImageAlpha", $$robo$$android_widget_ImageView$getImageAlpha(), 0, this);
    }

    @RemotableViewMethod
    public void setImageAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setImageAlpha", $$robo$$android_widget_ImageView$setImageAlpha(int ), 0, this, n);
    }

    @Deprecated
    @RemotableViewMethod
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_widget_ImageView$setAlpha(int ), 0, this, n);
    }

    private void applyColorMod() {
        InvokeDynamicSupport.bootstrap("applyColorMod", $$robo$$android_widget_ImageView$applyColorMod(), 0, this);
    }

    @Override
    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_widget_ImageView$isOpaque(), 0, this);
    }

    private boolean isFilledByImage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFilledByImage", $$robo$$android_widget_ImageView$isFilledByImage(), 0, this);
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_widget_ImageView$setVisibility(int ), 0, this, n);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_ImageView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_ImageView$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_ImageView$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_ImageView$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    static {
        RobolectricInternals.classInitializing(ImageView.class);
    }

    public /* synthetic */ ImageView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImageView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ScaleType
    extends Enum<ScaleType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ScaleType MATRIX;
        public static /* enum */ ScaleType FIT_XY;
        public static /* enum */ ScaleType FIT_START;
        public static /* enum */ ScaleType FIT_CENTER;
        public static /* enum */ ScaleType FIT_END;
        public static /* enum */ ScaleType CENTER;
        public static /* enum */ ScaleType CENTER_CROP;
        public static /* enum */ ScaleType CENTER_INSIDE;
        int nativeInt;
        private static /* synthetic */ ScaleType[] $VALUES;

        private static final ScaleType[] $$robo$$android_widget_ImageView_ScaleType$values() {
            return (ScaleType[])$VALUES.clone();
        }

        private static final ScaleType $$robo$$android_widget_ImageView_ScaleType$valueOf(String name) {
            return Enum.valueOf(ScaleType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_widget_ImageView_ScaleType$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        static void __staticInitializer__() {
            MATRIX = new ScaleType(0);
            FIT_XY = new ScaleType(1);
            FIT_START = new ScaleType(2);
            FIT_CENTER = new ScaleType(3);
            FIT_END = new ScaleType(4);
            CENTER = new ScaleType(5);
            CENTER_CROP = new ScaleType(6);
            CENTER_INSIDE = new ScaleType(7);
            $VALUES = new ScaleType[]{MATRIX, FIT_XY, FIT_START, FIT_CENTER, FIT_END, CENTER, CENTER_CROP, CENTER_INSIDE};
        }

        public static ScaleType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_widget_ImageView_ScaleType$values(), 0);
        }

        public static ScaleType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_widget_ImageView_ScaleType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_widget_ImageView_ScaleType$__constructor__(string2, n, n2);
        }

        private ScaleType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ImageView_ScaleType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(ScaleType.class);
        }

        public /* synthetic */ ScaleType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

